/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.parser.image.OneBitImage;

public class DeviceGrayColorSpace
extends GenericColorSpace {
    public DeviceGrayColorSpace() {
        this.componentCount = 1;
        this.setType(1568372915);
        this.cs = ColorSpace.getInstance(1003);
    }

    @Override
    public final BufferedImage dataToRGB(byte[] data, int width, int height) {
        int oldSize = data.length;
        int requiredSize = width * height;
        if (oldSize < requiredSize) {
            byte[] oldData = data;
            data = new byte[requiredSize];
            System.arraycopy(oldData, 0, data, 0, oldSize);
        }
        return OneBitImage.make(width, height, data);
    }

    @Override
    public final void setColor(int[] operand) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            operand = this.flattenIndexedValue(operand);
        }
        int val = DeviceGrayColorSpace.checkRange(operand[0]);
        this.currentColor = new PdfColor(val, val, val);
    }

    private static int checkRange(int r2) {
        return r2 > 255 ? 255 : Math.max(r2, 0);
    }

    @Override
    public final void setColor(float[] operand) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            operand = this.flattenIndexedValue(operand);
        }
        int val = (int)(255.0f * DeviceGrayColorSpace.checkRange(operand[0]));
        this.currentColor = new PdfColor(val, val, val);
    }

    private static float checkRange(float r2) {
        return r2 > 1.0f ? 1.0f : (r2 < 0.0f ? 0.0f : r2);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w2, int h2) {
        byte[] newData = new byte[data.length * 3];
        int ptr = 0;
        for (byte aData : data) {
            newData[ptr++] = aData;
            newData[ptr++] = aData;
            newData[ptr++] = aData;
        }
        return newData;
    }

    @Override
    public byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        int count = index.length;
        byte[] newIndex = new byte[count * 3];
        for (int i2 = 0; i2 < count; ++i2) {
            byte value = index[i2];
            for (int j2 = 0; j2 < 3; ++j2) {
                newIndex[i2 * 3 + j2] = value;
            }
        }
        return newIndex;
    }
}

