/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;

public class CalRGBColorSpace
extends GenericColorSpace {
    private int r;
    private int g;
    private int b;
    private static final double cs00 = 3.240449;
    private static final double cs01 = -1.537136;
    private static final double cs02 = -0.498531;
    private static final double cs10 = -0.969265;
    private static final double cs11 = 1.876011;
    private static final double cs12 = 0.041556;
    private static final double cs20 = 0.055643;
    private static final double cs21 = -0.204026;
    private static final double cs22 = 1.057229;
    private final double kr;
    private final double kg;
    private final double kb;
    private float lastC = -255.0f;
    private float lastI = -255.0f;
    private float lastE = -255.0f;
    private final float[] A = new float[]{1.0f, 1.0f, 1.0f};

    public CalRGBColorSpace(float[] whitepoint, float[] matrix, float[] gamma) {
        this.cs = ColorSpace.getInstance(1001);
        this.setCIEValues(whitepoint, null, matrix, gamma);
        this.setType(1008872003);
        this.kr = 1.0 / (3.240449 * (double)this.W[0] + -1.537136 * (double)this.W[1] + -0.498531 * (double)this.W[2]);
        this.kg = 1.0 / (-0.969265 * (double)this.W[0] + 1.876011 * (double)this.W[1] + 0.041556 * (double)this.W[2]);
        this.kb = 1.0 / (0.055643 * (double)this.W[0] + -0.204026 * (double)this.W[1] + 1.057229 * (double)this.W[2]);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w2, int h2) {
        return data;
    }

    @Override
    public final BufferedImage dataToRGB(byte[] data, int width, int height) {
        DataBufferByte db = new DataBufferByte(data, data.length);
        int[] bands = new int[]{0, 1, 2};
        BufferedImage image = new BufferedImage(width, height, 1);
        WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, bands, null);
        image.setData(raster);
        return image;
    }

    @Override
    public final void setColor(float[] number_values) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            number_values = this.flattenIndexedValue(number_values);
        }
        for (int i2 = 0; i2 < this.componentCount; ++i2) {
            this.A[i2] = number_values[i2];
            if (!(this.A[i2] > 1.0f)) continue;
            return;
        }
        this.convertToRGB(this.A[0], this.A[1], this.A[2]);
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }

    private void convertToRGB(float C2, float I2, float E2) {
        if (this.lastC != C2 || this.lastI != I2 || this.lastE != E2) {
            double ag2 = Math.pow(C2, this.G[0]);
            double bg2 = Math.pow(I2, this.G[1]);
            double cg = Math.pow(E2, this.G[2]);
            double X2 = (double)this.Ma[0] * ag2 + (double)this.Ma[3] * bg2 + (double)this.Ma[6] * cg;
            double Y2 = (double)this.Ma[1] * ag2 + (double)this.Ma[4] * bg2 + (double)this.Ma[7] * cg;
            double Z2 = (double)this.Ma[2] * ag2 + (double)this.Ma[5] * bg2 + (double)this.Ma[8] * cg;
            double rawR = 3.240449 * X2 + -1.537136 * Y2 + -0.498531 * Z2;
            double rawG = -0.969265 * X2 + 1.876011 * Y2 + 0.041556 * Z2;
            double rawB = 0.055643 * X2 + -0.204026 * Y2 + 1.057229 * Z2;
            this.r = (int)(255.0 * Math.sqrt(CalRGBColorSpace.clip(rawR * this.kr)));
            this.g = (int)(255.0 * Math.sqrt(CalRGBColorSpace.clip(rawG * this.kg)));
            this.b = (int)(255.0 * Math.sqrt(CalRGBColorSpace.clip(rawB * this.kb)));
            this.lastC = C2;
            this.lastI = I2;
            this.lastE = E2;
        }
    }

    private static double clip(double v2) {
        return v2 > 1.0 ? 1.0 : v2;
    }
}

