/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.parser.image.OneBitImage;

public class CalGrayColorSpace
extends GenericColorSpace {
    public CalGrayColorSpace(float[] whitepoint, float[] gamma) {
        this.componentCount = 1;
        this.setCIEValues(whitepoint, null, null, gamma);
        this.setType(391471749);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w2, int h2) {
        byte[] newData = new byte[data.length * 3];
        int ptr = 0;
        for (byte aData : data) {
            newData[ptr++] = aData;
            newData[ptr++] = aData;
            newData[ptr++] = aData;
        }
        return newData;
    }

    @Override
    public final BufferedImage dataToRGB(byte[] data, int width, int height) {
        return OneBitImage.make(width, height, data);
    }

    @Override
    public final void setColor(float[] number_values) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            number_values = this.flattenIndexedValue(number_values);
        }
        float A2 = number_values[0];
        float AG = (float)Math.pow(A2, this.G[0]);
        float lum = this.W[1] * AG;
        int val = (int)Math.max(295.8 * Math.pow(lum, 0.3333333333333333) - 40.8, 0.0);
        this.currentColor = new PdfColor(val, val, val);
    }

    @Override
    public byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        int count = index.length;
        byte[] newIndex = new byte[count * 3];
        for (int i2 = 0; i2 < count; ++i2) {
            byte value = index[i2];
            for (int j2 = 0; j2 < 3; ++j2) {
                newIndex[i2 * 3 + j2] = value;
            }
        }
        return newIndex;
    }
}

