/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.FileAccessHelper;
import org.jpedal.display.PageOffsets;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.linear.LinearParser;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PagesObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;

public class FileAccess {
    private Certificate certificate;
    private PageOffsets currentOffset;
    private String password;
    private DynamicVectorRenderer currentDisplay;
    private int lastPageDecoded = -1;
    private PrivateKey key;
    private PdfPageData pageData = new PdfPageData();
    private ObjectStore objectStoreRef = new ObjectStore();
    public boolean isOpen;
    private int minimumCacheSize = -1;
    private boolean closeOnExit = true;
    private String filename;
    private PdfObjectReader currentPdfFile;
    private int pageCount;
    private int pageNumber = 1;
    private boolean isDecoding;
    final LinearParser linearParser = new LinearParser();
    private final ExternalHandlers externalHandlers;
    private final PdfResources res;
    private final DecoderOptions options;
    private String pdfUrl;
    private float[] defaultMediaSize;
    private float[] defaultCropSize;

    public FileAccess(ExternalHandlers externalHandlers, PdfResources res, DecoderOptions options) {
        this.externalHandlers = externalHandlers;
        this.res = res;
        this.options = options;
        FileAccessHelper.init();
    }

    public boolean isFileViewable(PdfObjectReader currentPdfFile) {
        if (currentPdfFile != null) {
            PdfFileReader objectReader = currentPdfFile.getObjectReader();
            DecryptionFactory decryption = objectReader.getDecryptionObject();
            return decryption == null || decryption.getBooleanValue(100) || this.certificate != null;
        }
        return false;
    }

    void openPdfArray(byte[] data, String password) throws PdfException {
        this.password = password;
        this.openPdfArray(data);
    }

    void openPdfArray(byte[] data) throws PdfException {
        if (data == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.isOpen = false;
        this.res.flush();
        this.res.flushObjects();
        try {
            this.currentPdfFile = this.password != null ? new PdfObjectReader(this.password) : new PdfObjectReader();
            this.currentPdfFile.setObjectStore(this.objectStoreRef);
            this.currentPdfFile.openPdfFile(data);
            this.openPdfFile();
            this.objectStoreRef.storeFileName("r" + System.currentTimeMillis());
        }
        catch (PdfException e2) {
            throw new PdfException("[PDF] OpenPdfArray generated exception " + e2.getMessage(), e2);
        }
    }

    DynamicVectorRenderer getDynamicRenderer() {
        return this.currentDisplay;
    }

    public PdfResources getRes() {
        return this.res;
    }

    DynamicVectorRenderer getDynamicRenderer(boolean reset) {
        DynamicVectorRenderer latestVersion = this.currentDisplay;
        if (reset) {
            this.currentDisplay = new SwingDisplay(0, this.objectStoreRef, false);
        }
        return latestVersion;
    }

    public final void openPdfFileFromStream(Object filename, String password) throws PdfException {
        ImageInputStream iis;
        this.closeOnExit = false;
        if (filename instanceof ImageInputStream) {
            iis = (ImageInputStream)filename;
            if (this.isOpen) {
                this.closePdfFile();
            }
            this.isOpen = false;
            this.filename = "ImageInputStream" + System.currentTimeMillis();
            if (LogWriter.isRunningFromIDE) {
                LogWriter.writeLog("open " + filename);
            }
        } else {
            throw new RuntimeException(filename + " not currently an option");
        }
        this.res.flush();
        this.res.flushObjects();
        this.objectStoreRef.storeFileName(this.filename);
        this.currentPdfFile = new PdfObjectReader(password);
        this.currentPdfFile.setObjectStore(this.objectStoreRef);
        this.currentPdfFile.openPdfFile(iis);
        this.openPdfFile();
    }

    public void openPdfFile(String filename, boolean supportLinearized, String password) throws PdfException {
        this.isOpen = false;
        if (LogWriter.isRunningFromIDE) {
            LogWriter.writeLog("open " + filename);
        }
        this.filename = filename;
        this.res.flush();
        this.res.flushObjects();
        this.objectStoreRef.storeFileName(filename);
        this.currentPdfFile = new PdfObjectReader(password);
        this.currentPdfFile.setObjectStore(this.objectStoreRef);
        this.currentPdfFile.openPdfFile(filename, supportLinearized);
        this.openPdfFile();
    }

    int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int newPage) {
        this.pageNumber = newPage;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    void setPageCount(int newPageCount) {
        this.pageCount = newPageCount;
    }

    boolean isDecoding() {
        return this.isDecoding;
    }

    void setDecoding(boolean b2) {
        this.isDecoding = b2;
    }

    public boolean isPasswordSupplied(PdfObjectReader currentPdfFile) {
        if (currentPdfFile != null) {
            PdfFileReader objectReader = currentPdfFile.getObjectReader();
            DecryptionFactory decryption = objectReader.getDecryptionObject();
            if (decryption != null && decryption.getEncHash() != null) {
                this.objectStoreRef.setEncHash((byte[])decryption.getEncHash().clone());
            }
            return decryption != null && (decryption.getBooleanValue(104) || this.certificate != null);
        }
        return false;
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    void setObjectStore(ObjectStore newStore) {
        this.objectStoreRef = newStore;
    }

    public void setUserEncryption(Certificate certificate, PrivateKey key) {
        this.certificate = certificate;
        this.key = key;
    }

    private PdfObjectReader getNewReader(String password) {
        PdfObjectReader currentPdfFile = this.certificate != null ? new PdfObjectReader(this.certificate, this.key) : (password != null ? new PdfObjectReader(password) : new PdfObjectReader());
        return currentPdfFile;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public PdfObjectReader getIO() {
        return this.currentPdfFile;
    }

    public void setIO(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
    }

    public final boolean isEncrypted() {
        if (this.currentPdfFile != null) {
            PdfFileReader objectReader = this.currentPdfFile.getObjectReader();
            DecryptionFactory decryption = objectReader.getDecryptionObject();
            return decryption != null && decryption.getBooleanValue(101);
        }
        return false;
    }

    public void dispose() {
        if (this.currentPdfFile != null) {
            this.currentPdfFile.dispose();
        }
        this.currentPdfFile = null;
        this.currentDisplay = null;
        ++FileAccessHelper.bb;
    }

    public String getFilename() {
        return this.filename;
    }

    public int readAllPageReferences(PdfObject pdfObject, Map<String, Integer> rotations, Map<String, String> parents, int tempPageCount, AcroRenderer formRenderer, PdfResources res, int insetW, int insetH) {
        String currentPageOffset = pdfObject.getObjectRefAsString();
        int rotation = 0;
        int type = FileAccess.getType(pdfObject);
        int rawRotation = FileAccess.getRawRotation(pdfObject, rotations, parents, currentPageOffset);
        if (rawRotation != -1) {
            rotation = rawRotation;
        }
        PdfPageData pageData = this.pageData;
        pageData.setPageRotation(rotation, tempPageCount);
        float[] mediaBox = pdfObject.getFloatArray(1313305473);
        float[] cropBox = pdfObject.getFloatArray(1076199815);
        if (mediaBox == null) {
            mediaBox = this.defaultMediaSize;
        }
        if (cropBox == null) {
            cropBox = this.defaultCropSize;
        }
        if (mediaBox != null) {
            pageData.setMediaBox(mediaBox);
        }
        if (cropBox != null) {
            pageData.setCropBox(cropBox);
        }
        if (type == 825701731) {
            if (pdfObject.getDictionary(2004251818) != null) {
                res.setPdfObject(2, pdfObject.getDictionary(2004251818));
            }
            byte[][] kidList = pdfObject.getKeyArray(456733763);
            int kidCount = 0;
            if (kidList != null) {
                kidCount = kidList.length;
            }
            if (kidCount > 0) {
                for (int ii = 0; ii < kidCount; ++ii) {
                    String ref = new String(kidList[ii]);
                    if (pdfObject.getObjectRefAsString().equals(ref)) continue;
                    float[] lastMediaBox = this.defaultMediaSize;
                    this.defaultMediaSize = mediaBox;
                    float[] lastCropBox = this.defaultCropSize;
                    this.defaultCropSize = cropBox;
                    PdfObject nextObject = new PageObject(ref);
                    nextObject.ignoreRecursion(true);
                    nextObject.ignoreStream(true);
                    this.currentPdfFile.readObject(nextObject);
                    if (nextObject.getNameAsConstant(608780341) != 540096309) {
                        nextObject = new PagesObject(ref);
                        nextObject.ignoreRecursion(true);
                        nextObject.ignoreStream(true);
                        this.currentPdfFile.readObject(nextObject);
                    }
                    tempPageCount = this.readAllPageReferences(nextObject, rotations, parents, tempPageCount, formRenderer, res, insetW, insetH);
                    this.defaultMediaSize = lastMediaBox;
                    this.defaultCropSize = lastCropBox;
                }
            }
        } else if (type == 540096309) {
            this.currentPdfFile.setLookup(currentPageOffset, tempPageCount);
            pageData.checkSizeSet(tempPageCount);
            if (formRenderer != null) {
                byte[][] annotList = pdfObject.getKeyArray(1044338049);
                if (annotList != null && annotList.length == 1 && annotList[0] == null) {
                    annotList = null;
                }
                if (annotList != null) {
                    formRenderer.resetAnnotData(insetW, insetH, this.pageData, tempPageCount, this.currentPdfFile, annotList);
                }
            }
            ++tempPageCount;
        }
        return tempPageCount;
    }

    private static int getRawRotation(PdfObject pdfObject, Map<String, Integer> rotations, Map<String, String> parents, String currentPageOffset) {
        int rawRotation = pdfObject.getInt(1144088180);
        String parent = pdfObject.getStringKey(1110793845);
        if (rawRotation == -1) {
            while (parent != null && rawRotation == -1) {
                Integer savedRotation = rotations.get(parent);
                if (savedRotation != null) {
                    rawRotation = savedRotation;
                }
                if (rawRotation != -1) continue;
                parent = parents.get(parent);
            }
            if (rawRotation != -1) {
                rotations.put(currentPageOffset, rawRotation);
                parents.put(currentPageOffset, parent);
            }
        } else {
            rotations.put(currentPageOffset, rawRotation);
            parents.put(currentPageOffset, parent);
        }
        return rawRotation;
    }

    private static int getType(PdfObject pdfObject) {
        int type = pdfObject.getNameAsConstant(608780341);
        if (type == -1) {
            type = pdfObject.getKeyArray(456733763) != null ? 825701731 : 540096309;
        }
        return type;
    }

    PdfPageData getPdfPageData() {
        return this.pageData;
    }

    void setPageData(PdfPageData pageData) {
        this.pageData = pageData;
    }

    public void waitForDecodingToFinish() {
        while (this.isDecoding) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
                this.isDecoding = false;
                PdfObject linearObject = this.linearParser.getLinearObject(this.isOpen, this.currentPdfFile);
                if (linearObject == null) continue;
                linearObject.setBoolean(859785322, true);
            }
        }
    }

    boolean readFile(boolean supportLinearized, InputStream is, String rawFileName, String password) throws PdfException {
        this.res.flush();
        this.res.flushObjects();
        String rawPassword = password;
        this.currentPdfFile = password == null ? new PdfObjectReader() : new PdfObjectReader(password);
        if (is != null) {
            try {
                File tempURLFile = ObjectStore.createTempFile(rawFileName);
                this.filename = tempURLFile.getAbsolutePath();
                String storedFileName = tempURLFile.getName().substring(0, tempURLFile.getName().lastIndexOf(46));
                this.objectStoreRef.storeFileName(storedFileName);
                this.objectStoreRef.setFileToDeleteOnFlush(this.filename);
                this.currentPdfFile.setObjectStore(this.objectStoreRef);
                if (supportLinearized) {
                    byte[] passwordToUse;
                    byte[] linearBytes;
                    if (password == null) {
                        password = String.valueOf(System.currentTimeMillis());
                        password = password.substring(password.length() - 4);
                        this.objectStoreRef.setIdrPassword(password.getBytes());
                    }
                    if ((linearBytes = this.linearParser.readLinearData(passwordToUse = password.getBytes(), this.currentPdfFile, tempURLFile, is, this)) != null) {
                        this.currentPdfFile.openPdfFile(linearBytes);
                        this.openPdfFile();
                        if (this.pageCount < 2) {
                            this.options.setDisplayView(1);
                        } else {
                            this.options.setDisplayView(this.options.getPageMode());
                        }
                        this.linearParser.linearizedBackgroundReaderer.start();
                        return true;
                    }
                    try {
                        this.openPdfFile(tempURLFile.getAbsolutePath(), true, password);
                    }
                    catch (PdfException e2) {
                        boolean isURL = this.pdfUrl != null;
                        String message = isURL ? "[PDF] Exception " + e2 + " trying to open as Linearised - defaulting to non-linearised" : "[PDF] Exception " + e2 + " trying to open as Linearised - stream is not valid";
                        LogWriter.writeLog(message);
                        if (isURL) {
                            password = rawPassword;
                            supportLinearized = false;
                            this.currentPdfFile = password == null ? new PdfObjectReader() : new PdfObjectReader(password);
                            this.currentPdfFile.setObjectStore(this.objectStoreRef);
                            try {
                                is = new URL(this.pdfUrl).openStream();
                            }
                            catch (IOException ee) {
                                LogWriter.writeLog("[PDF] Exception " + ee.getMessage());
                            }
                        }
                        throw e2;
                    }
                }
                if (!supportLinearized) {
                    this.currentPdfFile.openPdfFile(is);
                    this.openPdfFile();
                    if (this.pageCount < 2) {
                        this.options.setDisplayView(1);
                    } else {
                        this.options.setDisplayView(this.options.getPageMode());
                    }
                }
            }
            catch (IOException e3) {
                LogWriter.writeLog("[PDF] Exception " + e3 + " opening URL ");
            }
        }
        return false;
    }

    public void closePdfFile() {
        AcroRenderer formRenderer;
        this.waitForDecodingToFinish();
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        this.linearParser.closePdfFile();
        Javascript javascript = this.externalHandlers.getJavaScript();
        if (javascript != null) {
            javascript.closeFile();
        }
        if ((formRenderer = this.externalHandlers.getFormRenderer()) != null) {
            formRenderer.openFile(this.pageCount, 0, 0, this.pageData, this.currentPdfFile, null);
            formRenderer.removeDisplayComponentsFromScreen();
        }
        this.pageCount = 0;
        if (this.currentPdfFile != null && this.closeOnExit) {
            this.currentPdfFile.closePdfFile();
            this.currentPdfFile = null;
        }
        this.lastPageDecoded = -1;
        this.currentDisplay.writeCustom(43, null);
        this.objectStoreRef.flush();
        ObjectStore.flushPages();
    }

    public void setStreamCacheSize(int size) {
        this.minimumCacheSize = size;
    }

    int getLastPageDecoded() {
        return this.lastPageDecoded;
    }

    public void setLastPageDecoded(int page) {
        this.lastPageDecoded = page;
    }

    public void setDVR(DynamicVectorRenderer swingDisplay) {
        this.currentDisplay = swingDisplay;
    }

    public PageOffsets getOffset() {
        return this.currentOffset;
    }

    public void setOffset(PageOffsets newOffset) {
        this.currentOffset = newOffset;
    }

    public void openPdfFile() throws PdfException {
        this.currentPdfFile.setObjectStore(this.objectStoreRef);
        this.currentPdfFile.setJavaScriptObject(this.externalHandlers.getJavaScript());
        this.pageNumber = 1;
        this.isDecoding = true;
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        PdfObject linearObject = this.linearParser.getLinearObject(this.isOpen, this.currentPdfFile);
        try {
            ActionHandler handler;
            PdfObject pdfObject;
            this.currentPdfFile.getObjectReader().setCacheSize(this.minimumCacheSize);
            PdfPageData pageData = this.pageData = new PdfPageData();
            if (!this.currentPdfFile.getObjectReader().validateFileStart()) {
                LogWriter.writeLog("PDF file contains gabage at start of file before %PDF");
            }
            String pdfVersion = this.currentPdfFile.getObjectReader().getType();
            LogWriter.writeLog("Pdf version : " + pdfVersion);
            if (pdfVersion == null) {
                if (linearObject != null) {
                    linearObject.setBoolean(859785322, true);
                }
                this.currentPdfFile = null;
                this.isDecoding = false;
                throw new PdfException("No version on first line ");
            }
            int linearPageCount = -1;
            if (this.linearParser.hasLinearData()) {
                pdfObject = this.linearParser.readHintTable(this.currentPdfFile);
                linearPageCount = this.linearParser.getPageCount();
            } else {
                pdfObject = this.currentPdfFile.getObjectReader().readReferenceTable(null);
            }
            if (pdfObject != null && (!this.isEncrypted() || this.isPasswordSupplied(this.currentPdfFile))) {
                this.openPdfFile(pdfObject, formRenderer, linearPageCount);
            }
            if ((handler = this.externalHandlers.getFormActionHandler()) != null) {
                handler.init(null, this.externalHandlers.getJavaScript(), formRenderer);
            }
            this.currentOffset = null;
            this.isOpen = true;
        }
        catch (PdfException e2) {
            this.isDecoding = false;
            if (linearObject != null) {
                linearObject.setBoolean(859785322, true);
            }
            this.isOpen = true;
            this.closePdfFile();
            this.isOpen = false;
            throw new PdfException(e2.getMessage() + " opening file", e2);
        }
        finally {
            this.isDecoding = false;
            if (linearObject != null) {
                linearObject.setBoolean(859785322, true);
            }
        }
    }

    private void openPdfFile(PdfObject pdfObject, AcroRenderer formRenderer, int linearPageCount) {
        pdfObject.ignoreRecursion(true);
        this.res.setValues(pdfObject, this.currentPdfFile);
        this.currentPdfFile.readDocumentMetaData(pdfObject, this.externalHandlers.getJavaScript());
        int type = pdfObject.getNameAsConstant(608780341);
        PdfObject pageObject = type != 540096309 ? FileAccess.readPageTree(pdfObject, this.currentPdfFile) : pdfObject;
        LogWriter.writeLog("Pages being read from " + pageObject + ' ' + pageObject.getObjectRefAsString());
        this.pageNumber = 1;
        if (formRenderer != null) {
            formRenderer.resetAnnotData(this.options.getInsetW(), this.options.getInsetW(), this.pageData, 1, this.currentPdfFile, null);
        }
        int tempPageCount = this.readAllPageReferences(pageObject, new HashMap<String, Integer>(1000), new HashMap<String, String>(1000), 1, formRenderer, this.res, this.options.getInsetW(), this.options.getInsetH());
        this.pageCount = linearPageCount > 0 ? linearPageCount : tempPageCount - 1;
        this.currentPdfFile.readPageLabels(this.pageCount);
        if (this.pageCount == 0) {
            LogWriter.writeLog("No pages found");
        }
        if (formRenderer != null) {
            this.pageCount = formRenderer.openFile(this.pageCount, this.options.getInsetW(), this.options.getInsetH(), this.pageData, this.currentPdfFile, this.res.getPdfObject(1));
        }
        this.pageData.setPageCount(this.pageCount);
    }

    private static PdfObject readPageTree(PdfObject pdfObject, PdfObjectReader currentPdfFile) {
        PdfObject pageObj = pdfObject.getDictionary(825701731);
        if (pageObj != null) {
            pdfObject = new PagesObject(pageObj.getObjectRefAsString());
            currentPdfFile.readObject(pdfObject);
            if (pdfObject.getNameAsConstant(608780341) == -1) {
                pdfObject = pageObj;
            }
        }
        return pdfObject;
    }

    public void openPdfFile(String filename) throws PdfException {
        this.isOpen = false;
        if (LogWriter.isRunningFromIDE) {
            LogWriter.writeLog("open " + filename);
        }
        this.filename = filename;
        this.res.flush();
        this.res.flushObjects();
        this.objectStoreRef.storeFileName(filename);
        this.currentPdfFile = this.getNewReader(this.password);
        this.currentPdfFile.setObjectStore(this.objectStoreRef);
        this.currentPdfFile.openPdfFile(filename, false);
        this.openPdfFile();
        if (this.pageCount < 2) {
            this.options.setDisplayView(1);
        } else {
            this.options.setDisplayView(this.options.getPageMode());
        }
    }

    void setPDFURL(String pdfUrl) {
        this.pdfUrl = pdfUrl;
    }
}

