/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.layout.Baseline;
import org.jdesktop.layout.LayoutStyle;

public class GroupLayout
implements LayoutManager2 {
    private static final int MIN_SIZE = 0;
    private static final int PREF_SIZE = 1;
    private static final int MAX_SIZE = 2;
    private static final int UNSET = Integer.MIN_VALUE;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private static final int NO_ALIGNMENT = 0;
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int CENTER = 3;
    public static final int BASELINE = 3;
    public static final int DEFAULT_SIZE = -1;
    public static final int PREFERRED_SIZE = -2;
    private boolean autocreatePadding;
    private boolean autocreateContainerPadding;
    private Group horizontalGroup;
    private Group verticalGroup;
    private Map componentInfos;
    private Container host;
    private List parallelList;
    private boolean springsChanged;
    private boolean hasPreferredPaddingSprings;
    static /* synthetic */ Class class$org$jdesktop$layout$GroupLayout;

    private static void checkSize(int min, int pref, int max, boolean isComponentSpring) {
        GroupLayout.checkResizeType(min, isComponentSpring);
        if (!isComponentSpring && pref < 0) {
            throw new IllegalArgumentException("Pref must be >= 0");
        }
        GroupLayout.checkResizeType(max, isComponentSpring);
        GroupLayout.checkLessThan(min, pref);
        GroupLayout.checkLessThan(min, max);
        GroupLayout.checkLessThan(pref, max);
    }

    private static void checkResizeType(int type, boolean isComponentSpring) {
        if (type < 0 && (isComponentSpring && type != -1 && type != -2 || !isComponentSpring && type != -2)) {
            throw new IllegalArgumentException("Invalid size");
        }
    }

    private static void checkLessThan(int min, int max) {
        if (min >= 0 && max >= 0 && min > max) {
            throw new IllegalArgumentException("Following is not met: min<=pref<=max");
        }
    }

    private static void checkAlignment(int alignment, boolean allowsBaseline) {
        if (alignment == 1 || alignment == 2 || alignment == 3) {
            return;
        }
        if (allowsBaseline && alignment != 3) {
            throw new IllegalArgumentException("Alignment must be one of:LEADING, TRAILING, CENTER or BASELINE");
        }
        throw new IllegalArgumentException("Alignment must be one of:LEADING, TRAILING or CENTER");
    }

    static boolean isVisible(Component c2) {
        return c2.isVisible();
    }

    public GroupLayout(Container host) {
        if (host == null) {
            throw new IllegalArgumentException("Container must be non-null");
        }
        this.host = host;
        this.setHorizontalGroup(this.createParallelGroup(1, true));
        this.setVerticalGroup(this.createParallelGroup(1, true));
        this.componentInfos = new HashMap();
        this.autocreatePadding = false;
        this.parallelList = new ArrayList();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HORIZONTAL\n");
        this.dump(buffer, this.horizontalGroup, "  ", 1);
        buffer.append("\nVERTICAL\n");
        this.dump(buffer, this.verticalGroup, "  ", 2);
        return buffer.toString();
    }

    private void dump(StringBuffer buffer, Spring spring, String indent, int axis) {
        String origin = "";
        String padding = "";
        if (spring instanceof ComponentSpring) {
            ComponentSpring cSpring = (ComponentSpring)spring;
            origin = Integer.toString(cSpring.getOrigin()) + " ";
            String name = cSpring.getComponent().getName();
            if (name != null) {
                origin = "name=" + name + ", ";
            }
        }
        if (spring instanceof AutopaddingSpring) {
            AutopaddingSpring paddingSpring = (AutopaddingSpring)spring;
            padding = ", userCreated=" + paddingSpring.getUserCreated() + ", matches=" + paddingSpring.getMatchDescription();
        }
        buffer.append(indent + spring.getClass().getName() + " " + Integer.toHexString(spring.hashCode()) + " " + origin + ", size=" + spring.getSize() + ", alignment=" + spring.getAlignment() + " prefs=[" + spring.getMinimumSize(axis) + " " + spring.getPreferredSize(axis) + " " + spring.getMaximumSize(axis) + padding + "]\n");
        if (spring instanceof Group) {
            List springs = ((Group)spring).springs;
            indent = indent + "  ";
            for (int counter = 0; counter < springs.size(); ++counter) {
                this.dump(buffer, (Spring)springs.get(counter), indent, axis);
            }
        }
    }

    public void setAutocreateGaps(boolean autocreatePadding) {
        this.autocreatePadding = autocreatePadding;
    }

    public boolean getAutocreateGaps() {
        return this.autocreatePadding;
    }

    public void setAutocreateContainerGaps(boolean autocreatePadding) {
        if (autocreatePadding != this.autocreateContainerPadding) {
            this.autocreateContainerPadding = autocreatePadding;
            this.horizontalGroup = this.createTopLevelGroup(this.getHorizontalGroup());
            this.verticalGroup = this.createTopLevelGroup(this.getVerticalGroup());
        }
    }

    public boolean getAutocreateContainerGaps() {
        return this.autocreateContainerPadding;
    }

    public void setHorizontalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.horizontalGroup = this.createTopLevelGroup(group);
    }

    public Group getHorizontalGroup() {
        int index = 0;
        if (this.horizontalGroup.springs.size() > 1) {
            index = 1;
        }
        return (Group)this.horizontalGroup.springs.get(index);
    }

    public void setVerticalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.verticalGroup = this.createTopLevelGroup(group);
    }

    public Group getVerticalGroup() {
        int index = 0;
        if (this.verticalGroup.springs.size() > 1) {
            index = 1;
        }
        return (Group)this.verticalGroup.springs.get(index);
    }

    private Group createTopLevelGroup(Group specifiedGroup) {
        SequentialGroup group = this.createSequentialGroup();
        if (this.getAutocreateContainerGaps()) {
            group.addSpring(new ContainerAutopaddingSpring());
            group.add(specifiedGroup);
            group.addSpring(new ContainerAutopaddingSpring());
        } else {
            group.add(specifiedGroup);
        }
        return group;
    }

    public SequentialGroup createSequentialGroup() {
        return new SequentialGroup();
    }

    public ParallelGroup createParallelGroup() {
        return this.createParallelGroup(1);
    }

    public ParallelGroup createParallelGroup(int alignment) {
        return this.createParallelGroup(alignment, true);
    }

    public ParallelGroup createParallelGroup(int alignment, boolean resizable) {
        if (alignment == 3) {
            return new BaselineGroup(resizable);
        }
        return new ParallelGroup(alignment, resizable);
    }

    public void linkSize(Component[] components) {
        this.linkSize(components, 3);
    }

    public void linkSize(Component[] components, int axis) {
        boolean vertical;
        if (components == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        boolean horizontal = (axis & 1) == 1;
        boolean bl2 = vertical = (axis & 2) == 2;
        if (!vertical && !horizontal) {
            throw new IllegalArgumentException("Axis must contain HORIZONTAL or VERTICAL");
        }
        for (int counter = components.length - 1; counter >= 0; --counter) {
            Component c2 = components[counter];
            if (components[counter] == null) {
                throw new IllegalArgumentException("Components must be non-null");
            }
            this.getComponentInfo(c2);
        }
        if (horizontal) {
            this.linkSize0(components, 1);
        }
        if (vertical) {
            this.linkSize0(components, 2);
        }
    }

    private void linkSize0(Component[] components, int axis) {
        ComponentInfo master = this.getComponentInfo(components[components.length - 1]).getMasterComponentInfo(axis);
        for (int counter = components.length - 2; counter >= 0; --counter) {
            master.addChild(this.getComponentInfo(components[counter]), axis);
        }
    }

    public void replace(Component existingComponent, Component newComponent) {
        ComponentInfo info;
        if (existingComponent == null || newComponent == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 1);
            this.registerComponents(this.verticalGroup, 2);
        }
        if ((info = (ComponentInfo)this.componentInfos.remove(existingComponent)) == null) {
            throw new IllegalArgumentException("Component must already exist");
        }
        this.host.remove(existingComponent);
        this.host.add(newComponent);
        info.setComponent(newComponent);
        this.componentInfos.put(newComponent, info);
        this.invalidateLayout(this.host);
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        ComponentInfo info = (ComponentInfo)this.componentInfos.remove(component);
        if (info != null) {
            info.dispose();
            this.springsChanged = true;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        this.checkParent(parent);
        this.prepare(1);
        return this.adjustSize(this.horizontalGroup.getPreferredSize(1), this.verticalGroup.getPreferredSize(2));
    }

    public Dimension minimumLayoutSize(Container parent) {
        this.checkParent(parent);
        this.prepare(0);
        return this.adjustSize(this.horizontalGroup.getMinimumSize(1), this.verticalGroup.getMinimumSize(2));
    }

    public void layoutContainer(Container parent) {
        this.prepare();
        Insets insets = parent.getInsets();
        if (this.getAutocreateGaps() || this.getAutocreateContainerGaps() || this.hasPreferredPaddingSprings) {
            this.resetAutopadding(this.horizontalGroup, 1, -1, 0, parent.getWidth() - insets.left - insets.right);
            this.resetAutopadding(this.verticalGroup, 2, -1, 0, parent.getHeight() - insets.top - insets.bottom);
        }
        this.horizontalGroup.setSize(1, 0, parent.getWidth() - insets.left - insets.right);
        this.verticalGroup.setSize(2, 0, parent.getHeight() - insets.top - insets.bottom);
        Iterator componentInfo = this.componentInfos.values().iterator();
        while (componentInfo.hasNext()) {
            ComponentInfo info = (ComponentInfo)componentInfo.next();
            Component c2 = info.getComponent();
            info.setBounds(insets);
        }
    }

    public void addLayoutComponent(Component component, Object constraints) {
    }

    public Dimension maximumLayoutSize(Container parent) {
        this.checkParent(parent);
        this.prepare(2);
        return this.adjustSize(this.horizontalGroup.getMaximumSize(1), this.verticalGroup.getMaximumSize(2));
    }

    public float getLayoutAlignmentX(Container parent) {
        this.checkParent(parent);
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        this.checkParent(parent);
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateLayout(Container parent) {
        this.checkParent(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.horizontalGroup.setSize(1, Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.verticalGroup.setSize(2, Integer.MIN_VALUE, Integer.MIN_VALUE);
            Iterator cis = this.componentInfos.values().iterator();
            while (cis.hasNext()) {
                ComponentInfo ci = (ComponentInfo)cis.next();
                ci.clear();
            }
        }
    }

    private void resetAutopadding(Group group, int axis, int sizeType, int origin, int size) {
        group.resetAutopadding();
        switch (sizeType) {
            case 0: {
                size = group.getMinimumSize(axis);
                break;
            }
            case 1: {
                size = group.getPreferredSize(axis);
                break;
            }
            case 2: {
                size = group.getMaximumSize(axis);
            }
        }
        group.setSize(axis, origin, size);
        group.calculateAutopadding(axis);
    }

    private void prepare(int sizeType) {
        this.prepare();
        if (this.getAutocreateGaps() || this.getAutocreateContainerGaps() || this.hasPreferredPaddingSprings) {
            this.resetAutopadding(this.horizontalGroup, 1, sizeType, 0, 0);
            this.resetAutopadding(this.verticalGroup, 2, sizeType, 0, 0);
        }
    }

    private void prepare() {
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 1);
            this.registerComponents(this.verticalGroup, 2);
        }
        if (this.springsChanged || this.hasVisibilityChanged()) {
            this.checkComponents();
            this.horizontalGroup.removeAutopadding();
            this.verticalGroup.removeAutopadding();
            if (this.getAutocreateGaps()) {
                this.adjustAutopadding(true);
            } else if (this.hasPreferredPaddingSprings || this.getAutocreateContainerGaps()) {
                this.adjustAutopadding(false);
            }
            this.springsChanged = false;
        }
    }

    private boolean hasVisibilityChanged() {
        Iterator infos = this.componentInfos.values().iterator();
        boolean visibilityChanged = false;
        while (infos.hasNext()) {
            ComponentInfo info = (ComponentInfo)infos.next();
            if (!info.updateVisibility()) continue;
            visibilityChanged = true;
        }
        return visibilityChanged;
    }

    private void checkComponents() {
        Iterator infos = this.componentInfos.values().iterator();
        while (infos.hasNext()) {
            ComponentInfo info = (ComponentInfo)infos.next();
            if (info.horizontalSpring == null) {
                throw new IllegalStateException(info.component + " is not attached to a horizontal group");
            }
            if (info.verticalSpring != null) continue;
            throw new IllegalStateException(info.component + " is not attached to a vertical group");
        }
    }

    private void registerComponents(Group group, int axis) {
        List springs = group.springs;
        for (int counter = springs.size() - 1; counter >= 0; --counter) {
            Spring spring = (Spring)springs.get(counter);
            if (spring instanceof ComponentSpring) {
                ((ComponentSpring)spring).installIfNecessary(axis);
                continue;
            }
            if (!(spring instanceof Group)) continue;
            this.registerComponents((Group)spring, axis);
        }
    }

    private Dimension adjustSize(int width, int height) {
        Insets insets = this.host.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    private void checkParent(Container parent) {
        if (parent != this.host) {
            throw new IllegalArgumentException("GroupLayout can only be used with one Container at a time");
        }
    }

    private ComponentInfo getComponentInfo(Component component) {
        ComponentInfo info = (ComponentInfo)this.componentInfos.get(component);
        if (info == null) {
            this.componentInfos.put(component, new ComponentInfo(component));
            this.host.add(component);
        }
        return info;
    }

    private void adjustAutopadding(boolean insert) {
        this.horizontalGroup.insertAutopadding(1, new ArrayList(1), new ArrayList(1), new ArrayList(1), new ArrayList(1), insert);
        this.verticalGroup.insertAutopadding(2, new ArrayList(1), new ArrayList(1), new ArrayList(1), new ArrayList(1), insert);
    }

    private boolean areParallelSiblings(Component source, Component target, int axis) {
        Spring spring;
        ComponentSpring targetSpring;
        ComponentSpring sourceSpring;
        ComponentInfo sourceInfo = this.getComponentInfo(source);
        ComponentInfo targetInfo = this.getComponentInfo(target);
        if (axis == 1) {
            sourceSpring = sourceInfo.horizontalSpring;
            targetSpring = targetInfo.horizontalSpring;
        } else {
            sourceSpring = sourceInfo.verticalSpring;
            targetSpring = targetInfo.verticalSpring;
        }
        List sourcePath = this.parallelList;
        sourcePath.clear();
        for (spring = sourceSpring.getParent(); spring != null; spring = spring.getParent()) {
            sourcePath.add(spring);
        }
        for (spring = targetSpring.getParent(); spring != null; spring = spring.getParent()) {
            if (!sourcePath.contains(spring)) continue;
            while (spring != null) {
                if (spring instanceof ParallelGroup) {
                    return true;
                }
                spring = spring.getParent();
            }
            return false;
        }
        return false;
    }

    private static class ComponentInfo {
        private Component component;
        ComponentSpring horizontalSpring;
        ComponentSpring verticalSpring;
        private ComponentInfo horizontalMaster;
        private ComponentInfo verticalMaster;
        private List horizontalDependants;
        private List verticalDependants;
        private int[] horizontalSizes;
        private int[] verticalSizes;
        private boolean visible;
        static final /* synthetic */ boolean $assertionsDisabled;

        ComponentInfo(Component component) {
            this.component = component;
            this.visible = GroupLayout.isVisible(component);
            this.clear();
        }

        public void dispose() {
            ComponentInfo newMaster;
            ComponentInfo linked;
            this.removeSpring(this.horizontalSpring);
            this.horizontalSpring = null;
            this.removeSpring(this.verticalSpring);
            this.verticalSpring = null;
            if (this.horizontalMaster == this) {
                this.horizontalDependants.remove(this);
                if (this.horizontalDependants.size() == 1) {
                    linked = (ComponentInfo)this.horizontalDependants.get(0);
                    linked.horizontalMaster = null;
                    linked.horizontalDependants = null;
                } else if (this.horizontalDependants.size() > 1) {
                    newMaster.horizontalMaster = newMaster = (ComponentInfo)this.horizontalDependants.get(0);
                    newMaster.horizontalDependants = this.horizontalDependants;
                }
            } else if (this.horizontalMaster != null) {
                this.horizontalMaster.horizontalDependants.remove(this);
                if (this.horizontalMaster.horizontalDependants.size() == 1) {
                    this.horizontalMaster.horizontalDependants = null;
                    this.horizontalMaster.horizontalMaster = null;
                }
            }
            if (this.verticalMaster == this) {
                this.verticalDependants.remove(this);
                if (this.verticalDependants.size() == 1) {
                    linked = (ComponentInfo)this.verticalDependants.get(0);
                    linked.verticalMaster = null;
                    linked.verticalDependants = null;
                } else if (this.verticalDependants.size() > 1) {
                    newMaster.verticalMaster = newMaster = (ComponentInfo)this.verticalDependants.get(0);
                    newMaster.verticalDependants = this.verticalDependants;
                }
            } else if (this.verticalMaster != null) {
                this.verticalMaster.verticalDependants.remove(this);
                if (this.verticalMaster.verticalDependants.size() == 1) {
                    this.verticalMaster.verticalDependants = null;
                    this.verticalMaster.verticalMaster = null;
                }
            }
        }

        private void removeSpring(Spring spring) {
            if (spring != null) {
                ((Group)spring.getParent()).springs.remove(spring);
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        boolean updateVisibility() {
            boolean newVisible = GroupLayout.isVisible(this.component);
            if (this.visible != newVisible) {
                this.visible = newVisible;
                return true;
            }
            return false;
        }

        public void setBounds(Insets insets) {
            int x2 = 0;
            int y2 = 0;
            int w2 = 0;
            int h2 = 0;
            if (this.horizontalSpring != null) {
                x2 = this.horizontalSpring.getOrigin();
                w2 = this.horizontalSpring.getSize();
            }
            if (this.verticalSpring != null) {
                y2 = this.verticalSpring.getOrigin();
                h2 = this.verticalSpring.getSize();
            }
            this.component.setBounds(x2 + insets.left, y2 + insets.top, w2, h2);
        }

        public void setComponent(Component component) {
            this.component = component;
            if (this.horizontalSpring != null) {
                this.horizontalSpring.setComponent(component);
            }
            if (this.verticalSpring != null) {
                this.verticalSpring.setComponent(component);
            }
        }

        public Component getComponent() {
            return this.component;
        }

        public boolean isLinked(int axis) {
            if (axis == 1) {
                return this.horizontalMaster != null;
            }
            return this.verticalMaster != null;
        }

        public ComponentInfo getMasterComponentInfo(int axis) {
            if (axis == 1) {
                if (this.horizontalMaster == null) {
                    this.horizontalMaster = this;
                    this.horizontalDependants = new ArrayList(1);
                    this.horizontalDependants.add(this);
                    this.horizontalSizes = new int[3];
                    this.clear();
                }
                return this.horizontalMaster;
            }
            if (this.verticalMaster == null) {
                this.verticalMaster = this;
                this.verticalDependants = new ArrayList(1);
                this.verticalDependants.add(this);
                this.verticalSizes = new int[3];
                this.clear();
            }
            return this.verticalMaster;
        }

        public void addChild(ComponentInfo child, int axis) {
            if (axis == 1) {
                this.addChild0(child, 1);
            } else {
                if (!$assertionsDisabled && axis != 2) {
                    throw new AssertionError();
                }
                this.addChild0(child, 2);
            }
        }

        private void addChild0(ComponentInfo child, int axis) {
            if (axis == 1) {
                if (child.horizontalMaster == child) {
                    this.horizontalDependants.addAll(child.horizontalDependants);
                    child.horizontalDependants = null;
                    child.horizontalSizes = null;
                } else {
                    this.horizontalDependants.add(child);
                }
                child.horizontalMaster = this;
            } else {
                if (child.verticalMaster == child) {
                    this.verticalDependants.addAll(child.verticalDependants);
                    child.verticalDependants = null;
                    child.verticalSizes = null;
                } else {
                    this.verticalDependants.add(child);
                }
                child.verticalMaster = this;
            }
        }

        public void clear() {
            this.clear(this.horizontalSizes);
            this.clear(this.verticalSizes);
        }

        private void clear(int[] sizes) {
            if (sizes != null) {
                for (int counter = sizes.length - 1; counter >= 0; --counter) {
                    sizes[counter] = Integer.MIN_VALUE;
                }
            }
        }

        int getLinkSize(int axis, int type) {
            int[] sizes = null;
            List dependants = null;
            if (axis == 1) {
                if (this.horizontalMaster != this) {
                    return this.horizontalMaster.getLinkSize(axis, type);
                }
                sizes = this.horizontalSizes;
                dependants = this.horizontalDependants;
            } else if (axis == 2) {
                if (this.verticalMaster != this) {
                    return this.verticalMaster.getLinkSize(axis, type);
                }
                sizes = this.verticalSizes;
                dependants = this.verticalDependants;
            }
            if (sizes[type] == Integer.MIN_VALUE) {
                sizes[type] = this.calcLinkSize(dependants, axis, type);
            }
            return sizes[type];
        }

        private int calcLinkSize(List dependants, int axis, int type) {
            int count = dependants.size() - 1;
            int size = this.getDependantSpringSize(dependants, axis, type, count--);
            while (count >= 0) {
                size = Math.max(size, this.getDependantSpringSize(dependants, axis, type, count--));
            }
            return size;
        }

        private int getDependantSpringSize(List dependants, int axis, int type, int index) {
            ComponentInfo ci = (ComponentInfo)dependants.get(index);
            ComponentSpring spring = axis == 1 ? ci.horizontalSpring : ci.verticalSpring;
            return spring.getPreferredSize1(axis);
        }

        static {
            $assertionsDisabled = !(class$org$jdesktop$layout$GroupLayout == null ? (class$org$jdesktop$layout$GroupLayout = GroupLayout.class$("org.jdesktop.layout.GroupLayout")) : class$org$jdesktop$layout$GroupLayout).desiredAssertionStatus();
        }
    }

    private class ContainerAutopaddingSpring
    extends AutopaddingSpring {
        private List targets;

        ContainerAutopaddingSpring() {
            this.setUserCreated(true);
        }

        ContainerAutopaddingSpring(int pref, int max) {
            super(pref, max);
            this.setUserCreated(true);
        }

        public void add(ComponentSpring spring, int axis) {
            if (this.targets == null) {
                this.targets = new ArrayList(1);
            }
            this.targets.add(spring);
        }

        public void calculatePadding(int axis) {
            LayoutStyle p2 = LayoutStyle.getSharedInstance();
            int maxPadding = 0;
            this.size = 0;
            if (this.targets != null) {
                int position = axis == 1 ? 7 : 1;
                for (int i2 = this.targets.size() - 1; i2 >= 0; --i2) {
                    ComponentSpring targetSpring = (ComponentSpring)this.targets.get(i2);
                    int padding = 10;
                    if (targetSpring.getComponent() instanceof JComponent) {
                        padding = p2.getContainerGap((JComponent)targetSpring.getComponent(), position, GroupLayout.this.host);
                        maxPadding = Math.max(padding, maxPadding);
                        padding -= targetSpring.getOrigin();
                    } else {
                        maxPadding = Math.max(padding, maxPadding);
                    }
                    this.size = Math.max(this.size, padding);
                }
            } else {
                int position;
                int n2 = position = axis == 1 ? 3 : 5;
                if (this.sources != null) {
                    for (int i3 = this.sources.size() - 1; i3 >= 0; --i3) {
                        ComponentSpring sourceSpring = (ComponentSpring)this.sources.get(i3);
                        maxPadding = Math.max(maxPadding, this.updateSize(p2, sourceSpring, position));
                    }
                } else if (this.source != null) {
                    maxPadding = this.updateSize(p2, this.source, position);
                }
            }
            if (this.lastSize != Integer.MIN_VALUE) {
                this.size += Math.min(maxPadding, this.lastSize);
            }
        }

        private int updateSize(LayoutStyle p2, ComponentSpring sourceSpring, int position) {
            int padding = 10;
            if (sourceSpring.getComponent() instanceof JComponent) {
                padding = p2.getContainerGap((JComponent)sourceSpring.getComponent(), position, GroupLayout.this.host);
            }
            int delta = Math.max(0, this.getParent().getSize() - sourceSpring.getSize() - sourceSpring.getOrigin());
            this.size = Math.max(this.size, padding - delta);
            return padding;
        }

        String getMatchDescription() {
            if (this.targets != null) {
                return "leading: " + this.targets.toString();
            }
            if (this.sources != null) {
                return "trailing: " + this.sources.toString();
            }
            return "--";
        }
    }

    private static class AutopaddingMatch {
        public ComponentSpring source;
        public ComponentSpring target;

        AutopaddingMatch(ComponentSpring source, ComponentSpring target) {
            this.source = source;
            this.target = target;
        }

        private String toString(ComponentSpring spring) {
            return spring.getComponent().getName();
        }

        public String toString() {
            return "[" + this.toString(this.source) + "-" + this.toString(this.target) + "]";
        }
    }

    private class AutopaddingSpring
    extends Spring {
        List sources;
        ComponentSpring source;
        private List matches;
        int size;
        int lastSize;
        private int pref;
        private int max;
        private int type;
        private boolean userCreated;

        private AutopaddingSpring() {
            this.pref = -2;
            this.max = -2;
            this.type = 0;
        }

        AutopaddingSpring(int pref, int max) {
            this.pref = pref;
            this.max = max;
        }

        AutopaddingSpring(int type, int pref, int max) {
            this.type = type;
            this.pref = pref;
            this.max = max;
            this.userCreated = true;
        }

        public void setSource(ComponentSpring source) {
            this.source = source;
        }

        public void setSources(List sources) {
            this.sources = new ArrayList(sources.size());
            this.sources.addAll(sources);
        }

        public void setUserCreated(boolean userCreated) {
            this.userCreated = userCreated;
        }

        public boolean getUserCreated() {
            return this.userCreated;
        }

        void clear() {
            this.lastSize = this.getSize();
            super.clear();
            this.size = 0;
        }

        public void reset() {
            this.size = 0;
            this.sources = null;
            this.source = null;
            this.matches = null;
        }

        public void calculatePadding(int axis) {
            this.size = Integer.MIN_VALUE;
            int maxPadding = Integer.MIN_VALUE;
            if (this.matches != null) {
                LayoutStyle p2 = LayoutStyle.getSharedInstance();
                int position = axis == 1 ? 3 : 5;
                for (int i2 = this.matches.size() - 1; i2 >= 0; --i2) {
                    AutopaddingMatch match = (AutopaddingMatch)this.matches.get(i2);
                    maxPadding = Math.max(maxPadding, this.calculatePadding(p2, position, match.source, match.target));
                }
            }
            if (this.size == Integer.MIN_VALUE) {
                this.size = 0;
            }
            if (maxPadding == Integer.MIN_VALUE) {
                maxPadding = 0;
            }
            if (this.lastSize != Integer.MIN_VALUE) {
                this.size += Math.min(maxPadding, this.lastSize);
            }
        }

        private int calculatePadding(LayoutStyle p2, int position, ComponentSpring source, ComponentSpring target) {
            int delta = target.getOrigin() - (source.getOrigin() + source.getSize());
            if (delta >= 0) {
                int padding = source.getComponent() instanceof JComponent && target.getComponent() instanceof JComponent ? p2.getPreferredGap((JComponent)source.getComponent(), (JComponent)target.getComponent(), this.type, position, GroupLayout.this.host) : 10;
                if (padding > delta) {
                    this.size = Math.max(this.size, padding - delta);
                }
                return padding;
            }
            return 0;
        }

        public void add(ComponentSpring spring, int axis) {
            int oAxis;
            int n2 = oAxis = axis == 1 ? 2 : 1;
            if (this.source != null) {
                if (GroupLayout.this.areParallelSiblings(this.source.getComponent(), spring.getComponent(), oAxis)) {
                    this.addMatch(this.source, spring);
                }
            } else {
                Component component = spring.getComponent();
                for (int counter = this.sources.size() - 1; counter >= 0; --counter) {
                    ComponentSpring source = (ComponentSpring)this.sources.get(counter);
                    if (!GroupLayout.this.areParallelSiblings(source.getComponent(), component, oAxis)) continue;
                    this.addMatch(source, spring);
                }
            }
        }

        private void addMatch(ComponentSpring source, ComponentSpring target) {
            if (this.matches == null) {
                this.matches = new ArrayList(1);
            }
            this.matches.add(new AutopaddingMatch(source, target));
        }

        int getMinimumSize0(int axis) {
            return this.size;
        }

        int getPreferredSize0(int axis) {
            if (this.pref == -2 || this.pref == -1) {
                return this.size;
            }
            return Math.max(this.size, this.pref);
        }

        int getMaximumSize0(int axis) {
            if (this.max >= 0) {
                return Math.max(this.getPreferredSize(axis), this.max);
            }
            return this.size;
        }

        String getMatchDescription() {
            return this.matches == null ? "" : this.matches.toString();
        }

        public String toString() {
            return super.toString() + this.getMatchDescription();
        }
    }

    class GapSpring
    extends Spring {
        private int min;
        private int pref;
        private int max;

        GapSpring(int min, int pref, int max) {
            GroupLayout.checkSize(min, pref, max, false);
            this.min = min;
            this.pref = pref;
            this.max = max;
        }

        int getMinimumSize0(int axis) {
            if (this.min == -2) {
                return this.getPreferredSize(axis);
            }
            return this.min;
        }

        int getPreferredSize0(int axis) {
            return this.pref;
        }

        int getMaximumSize0(int axis) {
            if (this.max == -2) {
                return this.getPreferredSize(axis);
            }
            return this.max;
        }
    }

    class PaddingSpring
    extends Spring {
        private JComponent source;
        private JComponent target;
        private int type;
        private boolean canGrow;

        PaddingSpring(JComponent source, JComponent target, int type, boolean canGrow) {
            this.source = source;
            this.target = target;
            this.type = type;
            this.canGrow = canGrow;
        }

        int getMinimumSize0(int axis) {
            return this.getPadding(axis);
        }

        int getPreferredSize0(int axis) {
            return this.getPadding(axis);
        }

        int getMaximumSize0(int axis) {
            if (this.canGrow) {
                return Short.MAX_VALUE;
            }
            return this.getPadding(axis);
        }

        private int getPadding(int axis) {
            int position = axis == 1 ? 3 : 5;
            return LayoutStyle.getSharedInstance().getPreferredGap(this.source, this.target, this.type, position, GroupLayout.this.host);
        }
    }

    class ComponentSpring
    extends Spring {
        private Component component;
        private int origin;
        private int min;
        private int pref;
        private int max;
        private int baseline;
        private boolean installed;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ComponentSpring(Component component, int min, int pref, int max) {
            this.baseline = -1;
            this.component = component;
            GroupLayout.checkSize(min, pref, max, true);
            this.min = min;
            this.max = max;
            this.pref = pref;
            GroupLayout.this.getComponentInfo(component);
        }

        int getMinimumSize0(int axis) {
            if (this.isLinked(axis)) {
                return this.getLinkSize(axis, 0);
            }
            return this.getMinimumSize1(axis);
        }

        int getMinimumSize1(int axis) {
            if (!GroupLayout.isVisible(this.component)) {
                return 0;
            }
            if (this.min >= 0) {
                return this.min;
            }
            if (this.min == -2) {
                return this.getPreferredSize1(axis);
            }
            if (!$assertionsDisabled && this.min != -1) {
                throw new AssertionError();
            }
            return this.getSizeAlongAxis(axis, this.component.getMinimumSize());
        }

        int getPreferredSize0(int axis) {
            if (this.isLinked(axis)) {
                return this.getLinkSize(axis, 1);
            }
            return Math.max(this.getMinimumSize(axis), this.getPreferredSize1(axis));
        }

        int getPreferredSize1(int axis) {
            if (!GroupLayout.isVisible(this.component)) {
                return 0;
            }
            if (this.pref >= 0) {
                return this.pref;
            }
            return this.getSizeAlongAxis(axis, this.component.getPreferredSize());
        }

        int getMaximumSize0(int axis) {
            if (!GroupLayout.isVisible(this.component)) {
                return 0;
            }
            if (this.isLinked(axis)) {
                return this.getLinkSize(axis, 2);
            }
            return Math.max(this.getMinimumSize(axis), this.getMaximumSize1(axis));
        }

        int getMaximumSize1(int axis) {
            if (this.max >= 0) {
                return this.max;
            }
            if (this.max == -2) {
                return this.getPreferredSize1(axis);
            }
            if (!$assertionsDisabled && this.max != -1) {
                throw new AssertionError();
            }
            return this.getSizeAlongAxis(axis, this.component.getMaximumSize());
        }

        private int getSizeAlongAxis(int axis, Dimension size) {
            return axis == 1 ? size.width : size.height;
        }

        private int getLinkSize(int axis, int type) {
            if (!GroupLayout.isVisible(this.component)) {
                return 0;
            }
            ComponentInfo ci = GroupLayout.this.getComponentInfo(this.component);
            return ci.getLinkSize(axis, type);
        }

        void setSize(int axis, int origin, int size) {
            super.setSize(axis, origin, size);
            this.origin = origin;
            if (size == Integer.MIN_VALUE) {
                this.baseline = -1;
            }
        }

        int getOrigin() {
            return this.origin;
        }

        void setComponent(Component component) {
            this.component = component;
        }

        Component getComponent() {
            return this.component;
        }

        int getBaseline() {
            if (this.baseline == -1 && this.component instanceof JComponent) {
                ComponentSpring horizontalSpring = ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).horizontalSpring;
                int width = horizontalSpring != null ? horizontalSpring.getSize() : this.component.getPreferredSize().width;
                this.baseline = Baseline.getBaseline((JComponent)this.component, width, this.getPreferredSize(2));
            }
            return this.baseline;
        }

        private boolean isLinked(int axis) {
            return GroupLayout.this.getComponentInfo(this.component).isLinked(axis);
        }

        void installIfNecessary(int axis) {
            if (!this.installed) {
                this.installed = true;
                if (axis == 1) {
                    ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).horizontalSpring = this;
                } else {
                    ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).verticalSpring = this;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$jdesktop$layout$GroupLayout == null ? (class$org$jdesktop$layout$GroupLayout = GroupLayout.class$("org.jdesktop.layout.GroupLayout")) : class$org$jdesktop$layout$GroupLayout).desiredAssertionStatus();
        }
    }

    private class BaselineGroup
    extends ParallelGroup {
        private boolean allSpringsHaveBaseline;
        private int prefAscent;
        private int prefDescent;

        BaselineGroup(boolean resizable) {
            super(1, resizable);
            this.prefDescent = -1;
            this.prefAscent = -1;
        }

        void setSize(int axis, int origin, int size) {
            if (size == Integer.MIN_VALUE) {
                this.prefDescent = -1;
                this.prefAscent = -1;
            }
            super.setSize(axis, origin, size);
        }

        void setSize0(int axis, int origin, int size) {
            if (axis == 1 || this.prefAscent == -1) {
                super.setSize0(axis, origin, size);
            } else {
                this.baselineLayout(origin, size);
            }
        }

        int calculateSize(int axis, int type) {
            if (this.springs.size() < 2 || axis != 2) {
                return super.calculateSize(axis, type);
            }
            if (this.prefAscent == -1) {
                this.calculateBaseline();
            }
            if (this.allSpringsHaveBaseline) {
                return this.prefAscent + this.prefDescent;
            }
            return Math.max(this.prefAscent + this.prefDescent, super.calculateSize(axis, type));
        }

        private void calculateBaseline() {
            this.prefAscent = 0;
            this.prefDescent = 0;
            this.allSpringsHaveBaseline = true;
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = this.getSpring(counter);
                int baseline = -1;
                if (spring instanceof ComponentSpring && (baseline = ((ComponentSpring)spring).getBaseline()) >= 0) {
                    this.prefAscent = Math.max(this.prefAscent, baseline);
                    this.prefDescent = Math.max(this.prefDescent, spring.getPreferredSize(2) - baseline);
                }
                if (baseline >= 0) continue;
                this.allSpringsHaveBaseline = false;
            }
        }

        private void baselineLayout(int origin, int size) {
            int max = this.springs.size();
            for (int counter = 0; counter < max; ++counter) {
                Spring spring = this.getSpring(counter);
                int baseline = -1;
                if (spring instanceof ComponentSpring && (baseline = ((ComponentSpring)spring).getBaseline()) >= 0) {
                    spring.setSize(2, origin + this.prefAscent - baseline, spring.getPreferredSize(2));
                }
                if (baseline >= 0) continue;
                int sSize = Math.min(spring.getMaximumSize(2), size);
                spring.setSize(2, origin + (size - sSize) / 2, sSize);
            }
        }
    }

    public class ParallelGroup
    extends Group {
        private int childAlignment;
        private boolean resizable;

        ParallelGroup(int childAlignment, boolean resizable) {
            GroupLayout.checkAlignment(childAlignment, true);
            this.childAlignment = childAlignment;
            this.resizable = resizable;
        }

        public ParallelGroup add(Group group) {
            return (ParallelGroup)this.addSpring(group);
        }

        public ParallelGroup add(Component component) {
            return this.add(component, -1, -1, -1);
        }

        public ParallelGroup add(Component component, int min, int pref, int max) {
            return (ParallelGroup)this.addSpring(new ComponentSpring(component, min, pref, max));
        }

        public ParallelGroup add(int pref) {
            return this.add(pref, pref, pref);
        }

        public ParallelGroup add(int min, int pref, int max) {
            return (ParallelGroup)this.addSpring(new GapSpring(min, pref, max));
        }

        public ParallelGroup add(int alignment, Group group) {
            group.setAlignment(alignment);
            return (ParallelGroup)this.addSpring(group);
        }

        public ParallelGroup add(int alignment, Component component) {
            return this.add(alignment, component, -1, -1, -1);
        }

        public ParallelGroup add(int alignment, Component component, int min, int pref, int max) {
            ComponentSpring spring = new ComponentSpring(component, min, pref, max);
            spring.setAlignment(alignment);
            return (ParallelGroup)this.addSpring(spring);
        }

        boolean isResizable() {
            return this.resizable;
        }

        int operator(int a10, int b2) {
            return Math.max(a10, b2);
        }

        int getMinimumSize0(int axis) {
            if (!this.isResizable()) {
                return this.getPreferredSize(axis);
            }
            return super.getMinimumSize0(axis);
        }

        int getMaximumSize0(int axis) {
            if (!this.isResizable()) {
                return this.getPreferredSize(axis);
            }
            return super.getMaximumSize0(axis);
        }

        void setSize0(int axis, int origin, int size) {
            int alignment = this.childAlignment;
            if (alignment == 3) {
                alignment = 1;
            }
            int max = this.springs.size();
            block4: for (int counter = 0; counter < max; ++counter) {
                Spring spring = this.getSpring(counter);
                int sAlignment = spring.getAlignment();
                int springSize = Math.min(size, spring.getMaximumSize(axis));
                if (sAlignment == 0) {
                    sAlignment = alignment;
                }
                switch (sAlignment) {
                    case 2: {
                        spring.setSize(axis, origin + size - springSize, springSize);
                        continue block4;
                    }
                    case 3: {
                        spring.setSize(axis, origin + (size - springSize) / 2, springSize);
                        continue block4;
                    }
                    default: {
                        spring.setSize(axis, origin, springSize);
                    }
                }
            }
        }

        void insertAutopadding(int axis, List leadingPadding, List trailingPadding, List leading, List trailing, boolean insert) {
            for (int counter = 0; counter < this.springs.size(); ++counter) {
                Spring spring = this.getSpring(counter);
                if (spring instanceof ComponentSpring) {
                    for (int i2 = 0; i2 < leadingPadding.size(); ++i2) {
                        ((AutopaddingSpring)leadingPadding.get(i2)).add((ComponentSpring)spring, axis);
                    }
                    trailing.add(spring);
                    continue;
                }
                if (spring instanceof Group) {
                    ((Group)spring).insertAutopadding(axis, leadingPadding, trailingPadding, leading, trailing, insert);
                    continue;
                }
                if (!(spring instanceof AutopaddingSpring)) continue;
                trailingPadding.add(spring);
            }
        }
    }

    private static class SpringDelta
    implements Comparable {
        public int index;
        public int delta;

        public SpringDelta(int index, int delta) {
            this.index = index;
            this.delta = delta;
        }

        public int compareTo(Object o2) {
            return this.delta - ((SpringDelta)o2).delta;
        }

        public String toString() {
            return super.toString() + "[index=" + this.index + ", delta=" + this.delta + "]";
        }
    }

    public class SequentialGroup
    extends Group {
        static final /* synthetic */ boolean $assertionsDisabled;

        SequentialGroup() {
        }

        public SequentialGroup add(Group group) {
            return (SequentialGroup)this.addSpring(group);
        }

        public SequentialGroup add(Component component) {
            return this.add(component, -1, -1, -1);
        }

        public SequentialGroup add(Component component, int min, int pref, int max) {
            return (SequentialGroup)this.addSpring(new ComponentSpring(component, min, pref, max));
        }

        public SequentialGroup add(int pref) {
            return this.add(pref, pref, pref);
        }

        public SequentialGroup add(int min, int pref, int max) {
            return (SequentialGroup)this.addSpring(new GapSpring(min, pref, max));
        }

        public SequentialGroup addPreferredGap(JComponent comp1, JComponent comp2, int type) {
            return this.addPreferredGap(comp1, comp2, type, false);
        }

        public SequentialGroup addPreferredGap(JComponent comp1, JComponent comp2, int type, boolean canGrow) {
            if (type != 0 && type != 1 && type != 3) {
                throw new IllegalArgumentException("Invalid type argument");
            }
            return (SequentialGroup)this.addSpring(new PaddingSpring(comp1, comp2, type, canGrow));
        }

        public SequentialGroup addPreferredGap(int type) {
            return this.addPreferredGap(type, -1, -1);
        }

        public SequentialGroup addPreferredGap(int type, int pref, int max) {
            if (type != 0 && type != 1) {
                throw new IllegalArgumentException("Padding type must be one of Padding.RELATED or Padding.UNRELATED");
            }
            if (pref < 0 && pref != -1 || max < 0 && max != -1 && max != -2 || pref >= 0 && max >= 0 && pref > max) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_VALUE or >= 0 and pref <= max");
            }
            GroupLayout.this.hasPreferredPaddingSprings = true;
            return (SequentialGroup)this.addSpring(new AutopaddingSpring(type, pref, max));
        }

        public SequentialGroup addContainerGap() {
            return this.addContainerGap(-1, -1);
        }

        public SequentialGroup addContainerGap(int pref, int max) {
            if (pref < 0 && pref != -1 || max < 0 && max != -1 && max != -2 || pref >= 0 && max >= 0 && pref > max) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_VALUE or >= 0 and pref <= max");
            }
            GroupLayout.this.hasPreferredPaddingSprings = true;
            return (SequentialGroup)this.addSpring(new ContainerAutopaddingSpring(pref, max));
        }

        int operator(int a10, int b2) {
            return this.constrain(a10) + this.constrain(b2);
        }

        void setSize0(int axis, int origin, int size) {
            int pref = this.getPreferredSize(axis);
            if (size - pref == 0) {
                int max = this.springs.size();
                for (int counter = 0; counter < max; ++counter) {
                    Spring spring = this.getSpring(counter);
                    int springPref = spring.getPreferredSize(axis);
                    spring.setSize(axis, origin, springPref);
                    origin += springPref;
                }
            } else if (this.springs.size() == 1) {
                Spring spring = this.getSpring(0);
                spring.setSize(axis, origin, Math.min(size, spring.getMaximumSize(axis)));
            } else if (this.springs.size() > 1) {
                this.resize(axis, origin, size);
            }
        }

        private void resize(int axis, int origin, int size) {
            List resizable;
            int resizableCount;
            int delta = size - this.getPreferredSize(axis);
            if (!$assertionsDisabled && delta == 0) {
                throw new AssertionError();
            }
            boolean useMin = delta < 0;
            int springCount = this.springs.size();
            if (useMin) {
                delta *= -1;
            }
            if ((resizableCount = (resizable = this.buildResizableList(axis, useMin)).size()) > 0) {
                int counter;
                int sDelta = delta / resizableCount;
                int slop = delta - sDelta * resizableCount;
                int[] sizes = new int[springCount];
                int sign = useMin ? -1 : 1;
                for (counter = 0; counter < resizableCount; ++counter) {
                    SpringDelta springDelta = (SpringDelta)resizable.get(counter);
                    if (counter + 1 == resizableCount) {
                        sDelta += slop;
                    }
                    springDelta.delta = Math.min(sDelta, springDelta.delta);
                    delta -= springDelta.delta;
                    if (springDelta.delta != sDelta && counter + 1 < resizableCount) {
                        sDelta = delta / (resizableCount - counter - 1);
                        slop = delta - sDelta * (resizableCount - counter - 1);
                    }
                    Spring spring = this.getSpring(springDelta.index);
                    sizes[springDelta.index] = sign * springDelta.delta;
                }
                for (counter = 0; counter < springCount; ++counter) {
                    Spring spring = this.getSpring(counter);
                    int sSize = spring.getPreferredSize(axis) + sizes[counter];
                    spring.setSize(axis, origin, sSize);
                    origin += sSize;
                }
            } else {
                for (int counter = 0; counter < springCount; ++counter) {
                    Spring spring = this.getSpring(counter);
                    int sSize = useMin ? spring.getMinimumSize(axis) : spring.getMaximumSize(axis);
                    spring.setSize(axis, origin, sSize);
                    origin += sSize;
                }
            }
        }

        private List buildResizableList(int axis, boolean useMin) {
            int size = this.springs.size();
            ArrayList<SpringDelta> sorted = new ArrayList<SpringDelta>(size);
            for (int counter = 0; counter < size; ++counter) {
                Spring spring = this.getSpring(counter);
                int sDelta = useMin ? spring.getPreferredSize(axis) - spring.getMinimumSize(axis) : spring.getMaximumSize(axis) - spring.getPreferredSize(axis);
                if (sDelta <= 0) continue;
                sorted.add(new SpringDelta(counter, sDelta));
            }
            Collections.sort(sorted);
            return sorted;
        }

        private AutopaddingSpring getNextAutopadding(int index, boolean insert) {
            Spring spring = this.getSpring(index);
            if (spring instanceof AutopaddingSpring && ((AutopaddingSpring)spring).getUserCreated()) {
                return (AutopaddingSpring)spring;
            }
            if (insert) {
                AutopaddingSpring autoSpring = new AutopaddingSpring();
                this.springs.add(index, autoSpring);
                return autoSpring;
            }
            return null;
        }

        void insertAutopadding(int axis, List leadingPadding, List trailingPadding, List leading, List trailing, boolean insert) {
            ArrayList<AutopaddingSpring> newLeadingPadding = new ArrayList<AutopaddingSpring>(leadingPadding);
            ArrayList newTrailingPadding = new ArrayList(1);
            ArrayList<ComponentSpring> newLeading = new ArrayList<ComponentSpring>(leading);
            ArrayList newTrailing = null;
            for (int counter = 0; counter < this.springs.size(); ++counter) {
                AutopaddingSpring padding;
                Spring spring = this.getSpring(counter);
                if (spring instanceof AutopaddingSpring) {
                    padding = (AutopaddingSpring)spring;
                    padding.setSources(newLeading);
                    newLeading.clear();
                    if (counter + 1 == this.springs.size()) {
                        if (padding instanceof ContainerAutopaddingSpring) continue;
                        trailingPadding.add(padding);
                        continue;
                    }
                    newLeadingPadding.clear();
                    newLeadingPadding.add(padding);
                    continue;
                }
                if (newLeading.size() > 0 && insert) {
                    padding = new AutopaddingSpring();
                    this.springs.add(counter--, padding);
                    continue;
                }
                if (spring instanceof ComponentSpring) {
                    ComponentSpring cSpring = (ComponentSpring)spring;
                    if (!GroupLayout.isVisible(cSpring.getComponent())) continue;
                    for (int i2 = 0; i2 < newLeadingPadding.size(); ++i2) {
                        ((AutopaddingSpring)newLeadingPadding.get(i2)).add(cSpring, axis);
                    }
                    newLeading.clear();
                    newLeadingPadding.clear();
                    if (counter + 1 == this.springs.size()) {
                        trailing.add(cSpring);
                        continue;
                    }
                    newLeading.add(cSpring);
                    continue;
                }
                if (spring instanceof Group) {
                    if (newTrailing == null) {
                        newTrailing = new ArrayList(1);
                    } else {
                        newTrailing.clear();
                    }
                    newTrailingPadding.clear();
                    ((Group)spring).insertAutopadding(axis, newLeadingPadding, newTrailingPadding, newLeading, newTrailing, insert);
                    newLeading.clear();
                    newLeadingPadding.clear();
                    if (counter + 1 == this.springs.size()) {
                        trailing.addAll(newTrailing);
                        trailingPadding.addAll(newTrailingPadding);
                        continue;
                    }
                    newLeading.addAll(newTrailing);
                    newLeadingPadding.addAll(newTrailingPadding);
                    continue;
                }
                newLeadingPadding.clear();
                newLeading.clear();
            }
        }

        static {
            $assertionsDisabled = !(class$org$jdesktop$layout$GroupLayout == null ? (class$org$jdesktop$layout$GroupLayout = GroupLayout.class$("org.jdesktop.layout.GroupLayout")) : class$org$jdesktop$layout$GroupLayout).desiredAssertionStatus();
        }
    }

    public abstract class Group
    extends Spring {
        List springs;
        static final /* synthetic */ boolean $assertionsDisabled;

        Group() {
            this.springs = new ArrayList();
        }

        int indexOf(Spring spring) {
            return this.springs.indexOf(spring);
        }

        Group addSpring(Spring spring, int index) {
            this.springs.add(spring);
            spring.setParent(this);
            if (!(spring instanceof AutopaddingSpring)) {
                GroupLayout.this.springsChanged = true;
            }
            return this;
        }

        Group addSpring(Spring spring) {
            this.addSpring(spring, this.springs.size());
            return this;
        }

        void setParent(Spring parent) {
            super.setParent(parent);
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                ((Spring)this.springs.get(counter)).setParent(this);
            }
        }

        void setSize(int axis, int origin, int size) {
            super.setSize(axis, origin, size);
            if (size == Integer.MIN_VALUE) {
                for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                    this.getSpring(counter).setSize(axis, origin, size);
                }
            } else {
                this.setSize0(axis, origin, size);
            }
        }

        abstract void setSize0(int var1, int var2, int var3);

        int getMinimumSize0(int axis) {
            return this.calculateSize(axis, 0);
        }

        int getPreferredSize0(int axis) {
            return this.calculateSize(axis, 1);
        }

        int getMaximumSize0(int axis) {
            return this.calculateSize(axis, 2);
        }

        abstract int operator(int var1, int var2);

        int calculateSize(int axis, int type) {
            int count = this.springs.size();
            if (count == 0) {
                return 0;
            }
            if (count == 1) {
                return this.getSize(this.getSpring(0), axis, type);
            }
            int size = this.constrain(this.operator(this.getSize(this.getSpring(0), axis, type), this.getSize(this.getSpring(1), axis, type)));
            for (int counter = 2; counter < count; ++counter) {
                size = this.constrain(this.operator(size, this.getSize(this.getSpring(counter), axis, type)));
            }
            return size;
        }

        Spring getSpring(int index) {
            return (Spring)this.springs.get(index);
        }

        int getSize(Spring spring, int axis, int type) {
            switch (type) {
                case 0: {
                    return spring.getMinimumSize(axis);
                }
                case 1: {
                    return spring.getPreferredSize(axis);
                }
                case 2: {
                    return spring.getMaximumSize(axis);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }

        abstract void insertAutopadding(int var1, List var2, List var3, List var4, List var5, boolean var6);

        void removeAutopadding() {
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = (Spring)this.springs.get(counter);
                if (spring instanceof AutopaddingSpring) {
                    if (((AutopaddingSpring)spring).getUserCreated()) {
                        ((AutopaddingSpring)spring).reset();
                        continue;
                    }
                    this.springs.remove(counter);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).removeAutopadding();
            }
        }

        void resetAutopadding() {
            this.clear();
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = (Spring)this.springs.get(counter);
                if (spring instanceof AutopaddingSpring) {
                    ((AutopaddingSpring)spring).clear();
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).resetAutopadding();
            }
        }

        void calculateAutopadding(int axis) {
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = (Spring)this.springs.get(counter);
                if (spring instanceof AutopaddingSpring) {
                    spring.clear();
                    ((AutopaddingSpring)spring).calculatePadding(axis);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).calculateAutopadding(axis);
            }
            this.clear();
        }

        static {
            $assertionsDisabled = !(class$org$jdesktop$layout$GroupLayout == null ? (class$org$jdesktop$layout$GroupLayout = GroupLayout.class$("org.jdesktop.layout.GroupLayout")) : class$org$jdesktop$layout$GroupLayout).desiredAssertionStatus();
        }
    }

    abstract class Spring {
        private int size;
        private int min;
        private int max = Integer.MIN_VALUE;
        private int pref = Integer.MIN_VALUE;
        private Spring parent;
        private int alignment;

        Spring() {
            this.min = Integer.MIN_VALUE;
        }

        abstract int getMinimumSize0(int var1);

        abstract int getPreferredSize0(int var1);

        abstract int getMaximumSize0(int var1);

        void setParent(Spring parent) {
            this.parent = parent;
        }

        Spring getParent() {
            return this.parent;
        }

        void setAlignment(int alignment) {
            GroupLayout.checkAlignment(alignment, false);
            this.alignment = alignment;
        }

        int getAlignment() {
            return this.alignment;
        }

        final int getMinimumSize(int axis) {
            if (this.min == Integer.MIN_VALUE) {
                this.min = this.constrain(this.getMinimumSize0(axis));
            }
            return this.min;
        }

        final int getPreferredSize(int axis) {
            if (this.pref == Integer.MIN_VALUE) {
                this.pref = this.constrain(this.getPreferredSize0(axis));
            }
            return this.pref;
        }

        final int getMaximumSize(int axis) {
            if (this.max == Integer.MIN_VALUE) {
                this.max = this.constrain(this.getMaximumSize0(axis));
            }
            return this.max;
        }

        void clear() {
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
            this.size = Integer.MIN_VALUE;
        }

        void setSize(int axis, int origin, int size) {
            this.size = size;
            if (size == Integer.MIN_VALUE) {
                this.clear();
            }
        }

        int getSize() {
            return this.size;
        }

        int constrain(int value) {
            return Math.min(value, Short.MAX_VALUE);
        }
    }
}

