/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    long jniRef;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int HOT = 32;
    static final int MOVED = 64;
    static final int RESIZED = 128;
    static final int EXPANDING = 256;
    static final int IGNORE_WHEEL = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int THEME_BACKGROUND = 2048;
    static final int LAYOUT_NEEDED = 4096;
    static final int LAYOUT_CHANGED = 8192;
    static final int LAYOUT_CHILD = 16384;
    static final int RELEASED = 32768;
    static final int DISPOSE_SENT = 65536;
    static final int FOREIGN_HANDLE = 131072;
    static final int DRAG_DETECT = 262144;
    static final int RESIZING = 524288;
    static final int WEBKIT_EVENTS_FIX = 0x100000;
    static final String WEBKIT_EVENTS_FIX_KEY = "org.eclipse.swt.internal.webKitEventsFix";
    static final String GLCONTEXT_KEY = "org.eclipse.swt.internal.cocoa.glcontext";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.isActive";
    static final int SKIN_NEEDED = 0x200000;
    static final int HAS_AUTO_DIRECTION = 0;
    static final int AUTO_TEXT_DIRECTION = 0x6000000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;

    Widget() {
    }

    public Widget(Widget widget, int n2) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n2;
        this.display = widget.display;
        this.reskinWidget();
    }

    long accessibleHandle() {
        return 0L;
    }

    long accessibilityActionDescription(long l2, long l3, long l4) {
        return this.callSuperObject(l2, l3, l4);
    }

    long accessibilityActionNames(long l2, long l3) {
        return this.callSuperObject(l2, l3);
    }

    long accessibilityAttributeNames(long l2, long l3) {
        return this.callSuperObject(l2, l3);
    }

    long accessibilityAttributeValue(long l2, long l3, long l4) {
        return this.callSuperObject(l2, l3, l4);
    }

    long accessibilityAttributeValue_forParameter(long l2, long l3, long l4, long l5) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, l4, l5);
    }

    long accessibilityFocusedUIElement(long l2, long l3) {
        return this.callSuperObject(l2, l3);
    }

    long accessibilityHitTest(long l2, long l3, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, nSPoint);
    }

    boolean accessibilityIsAttributeSettable(long l2, long l3, long l4) {
        return this.callSuperBoolean(l2, l3, l4);
    }

    boolean accessibilityIsIgnored(long l2, long l3) {
        return this.callSuperBoolean(l2, l3);
    }

    long accessibilityParameterizedAttributeNames(long l2, long l3) {
        return this.callSuperObject(l2, l3);
    }

    void accessibilityPerformAction(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void accessibilitySetValue_forAttribute(long l2, long l3, long l4, long l5) {
        this.callSuper(l2, l3, l4, l5);
    }

    String getClipboardText() {
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return "";
        }
        NSString nSString = nSPasteboard.stringForType(OS.NSStringPboardType);
        return nSString != null ? nSString.getString() : null;
    }

    void setClipRegion(NSView nSView) {
    }

    long attributedSubstringFromRange(long l2, long l3, long l4) {
        return 0L;
    }

    void callSuper(long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3);
    }

    void callSuper(long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, l4);
    }

    void callSuper(long l2, long l3, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, nSRect);
    }

    void callSuper(long l2, long l3, long l4, long l5) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, l4, l5);
    }

    void callSuper(long l2, long l3, NSRect nSRect, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, nSRect, l4);
    }

    long callSuper(long l2, long l3, long l4, NSRect nSRect, long l5) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, l4, nSRect, l5);
    }

    boolean callSuperBoolean(long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3) != 0L;
    }

    boolean canBecomeKeyWindow(long l2, long l3) {
        return this.callSuperBoolean(l2, l3);
    }

    boolean needsPanelToBecomeKey(long l2, long l3) {
        return this.callSuperBoolean(l2, l3);
    }

    void cancelOperation(long l2, long l3, long l4) {
    }

    NSSize cellSize(long l2, long l3) {
        NSSize nSSize = new NSSize();
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper_stret(nSSize, objc_super2, l3);
        return nSSize;
    }

    NSSize cellSizeForBounds(long l2, long l3, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, objc_super2, l3, nSRect);
        return nSSize;
    }

    boolean callSuperBoolean(long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, l4) != 0L;
    }

    boolean callSuperBoolean(long l2, long l3, NSRange nSRange, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper_bool(objc_super2, l3, nSRange, l4);
    }

    long callSuperObject(long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3);
    }

    long callSuperObject(long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, l4);
    }

    long callSuperObject(long l2, long l3, long l4, long l5) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, l4, l5);
    }

    NSRect callSuperRect(long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        NSRect nSRect = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect, objc_super2, l3, l4);
        return nSRect;
    }

    NSRect callSuperRect(long l2, long l3, NSRect nSRect, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, l3, nSRect, l4);
        return nSRect2;
    }

    boolean canDragRowsWithIndexes_atPoint(long l2, long l3, long l4, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper_bool(objc_super2, l3, l4, nSPoint);
    }

    long characterIndexForPoint(long l2, long l3, long l4) {
        return Integer.MAX_VALUE;
    }

    long columnAtPoint(long l2, long l3, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, nSPoint);
    }

    boolean acceptsFirstMouse(long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, l4) != 0L;
    }

    boolean acceptsFirstResponder(long l2, long l3) {
        return this.callSuperBoolean(l2, l3);
    }

    boolean becomeFirstResponder(long l2, long l3) {
        return this.callSuperBoolean(l2, l3);
    }

    void becomeKeyWindow(long l2, long l3) {
        this.callSuper(l2, l3);
    }

    public void reskin(int n2) {
        this.checkWidget();
        this.reskinWidget();
        if ((n2 & 1) != 0) {
            this.reskinChildren(n2);
        }
    }

    void reskinChildren(int n2) {
    }

    void reskinWidget() {
        if ((this.state & 0x200000) != 0x200000) {
            this.state |= 0x200000;
            this.display.addSkinnableWidget(this);
        }
    }

    boolean resignFirstResponder(long l2, long l3) {
        return this.callSuperBoolean(l2, l3);
    }

    public void addListener(int n2, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n2, listener);
    }

    void _addListener(int n2, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n2, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    boolean canBecomeKeyView(long l2, long l3) {
        return true;
    }

    static int checkBits(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n3 | n4 | n5 | n6 | n7 | n8;
        if ((n2 & n9) == 0) {
            n2 |= n3;
        }
        if ((n2 & n3) != 0) {
            n2 = n2 & ~n9 | n3;
        }
        if ((n2 & n4) != 0) {
            n2 = n2 & ~n9 | n4;
        }
        if ((n2 & n5) != 0) {
            n2 = n2 & ~n9 | n5;
        }
        if ((n2 & n6) != 0) {
            n2 = n2 & ~n9 | n6;
        }
        if ((n2 & n7) != 0) {
            n2 = n2 & ~n9 | n7;
        }
        if ((n2 & n8) != 0) {
            n2 = n2 & ~n9 | n8;
        }
        return n2;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void clearDeferFlushing(long l2, long l3) {
    }

    boolean textView_clickOnLink_atIndex(long l2, long l3, long l4, long l5, long l6) {
        return true;
    }

    void collapseItem_collapseChildren(long l2, long l3, long l4, boolean bl2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, l4, bl2);
    }

    void copyToClipboard(char[] cArray) {
        if (cArray.length == 0) {
            return;
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return;
        }
        nSPasteboard.declareTypes(NSArray.arrayWithObject(OS.NSStringPboardType), null);
        nSPasteboard.setString(NSString.stringWithCharacters(cArray, cArray.length), OS.NSStringPboardType);
    }

    void createHandle() {
    }

    void createJNIRef() {
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0L) {
            this.error(2);
        }
    }

    void createWidget() {
        this.createJNIRef();
        this.createHandle();
        this.setOrientation();
        this.register();
    }

    void comboBoxSelectionDidChange(long l2, long l3, long l4) {
    }

    void comboBoxWillDismiss(long l2, long l3, long l4) {
    }

    void comboBoxWillPopUp(long l2, long l3, long l4) {
    }

    void dealloc(long l2, long l3) {
        this.callSuper(l2, l3);
    }

    void deregister() {
    }

    void destroyJNIRef() {
        if (this.jniRef != 0L) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0L;
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void deselectAll(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void deselectRow(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void doCommandBySelector(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    boolean dragSelectionWithEvent(long l2, long l3, long l4, long l5, long l6) {
        return false;
    }

    void drawBackground(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
    }

    void drawBackgroundInClipRect(long l2, long l3, NSRect nSRect) {
        this.callSuper(l2, l3, nSRect);
    }

    void drawImageWithFrameInView(long l2, long l3, long l4, NSRect nSRect, long l5) {
        this.callSuper(l2, l3, l4, nSRect, l5);
    }

    NSRect drawTitleWithFrameInView(long l2, long l3, long l4, NSRect nSRect, long l5) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, l3, l4, nSRect, l5);
        return nSRect2;
    }

    void drawInteriorWithFrame_inView(long l2, long l3, NSRect nSRect, long l4) {
        this.callSuper(l2, l3, nSRect, l4);
    }

    void drawLabelInRect(long l2, long l3, boolean bl2, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, bl2, nSRect);
    }

    void drawViewBackgroundInRect(long l2, long l3, NSRect nSRect) {
        this.callSuper(l2, l3, nSRect);
    }

    void drawWithExpansionFrame_inView(long l2, long l3, NSRect nSRect, long l4) {
        this.callSuper(l2, l3, nSRect, l4);
    }

    void drawRect(long l2, long l3, NSRect nSRect) {
        if (!this.isDrawing()) {
            return;
        }
        Display display = this.display;
        NSView nSView = new NSView(l2);
        display.isPainting.addObject(nSView);
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        nSGraphicsContext.saveGraphicsState();
        this.setClipRegion(nSView);
        this.drawBackground(l2, nSGraphicsContext, nSRect);
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, nSRect);
        if (!this.isDisposed()) {
            this.drawWidget(l2, nSGraphicsContext, nSRect);
        }
        nSGraphicsContext.restoreGraphicsState();
        display.isPainting.removeObjectIdenticalTo(nSView);
    }

    void _drawThemeProgressArea(long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, l4);
    }

    void drawWidget(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
    }

    long imageView() {
        return 0L;
    }

    void redrawWidget(NSView nSView, boolean bl2) {
        nSView.setNeedsDisplay(true);
    }

    void redrawWidget(NSView nSView, long l2, long l3, long l4, long l5, boolean bl2) {
        NSRect nSRect = new NSRect();
        nSRect.x = l2;
        nSRect.y = l3;
        nSRect.width = l4;
        nSRect.height = l5;
        nSView.setNeedsDisplayInRect(nSRect);
    }

    void error(int n2) {
        SWT.error(n2);
    }

    void expandItem_expandChildren(long l2, long l3, long l4, boolean bl2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, l4, bl2);
    }

    NSRect expansionFrameWithFrame_inView(long l2, long l3, NSRect nSRect, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, l3, nSRect, l4);
        return nSRect2;
    }

    boolean filters(int n2) {
        return this.display.filters(n2);
    }

    NSRect firstRectForCharacterRange(long l2, long l3, long l4) {
        return new NSRect();
    }

    int fixMnemonic(char[] cArray) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            if ((cArray[n3++] = cArray[n2++]) != '&' || n2 == cArray.length) continue;
            if (cArray[n2] == '&') {
                ++n2;
                continue;
            }
            --n3;
        }
        return n3;
    }

    NSRect focusRingMaskBoundsForFrame(long l2, long l3, NSRect nSRect, long l4) {
        return this.callSuperRect(l2, l3, nSRect, l4);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(IS_ACTIVE)) {
            return new Boolean(this.isActive());
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
                if (!string.equals(objectArray[i2])) continue;
                return objectArray[i2 + 1];
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    boolean getDrawing() {
        return true;
    }

    public Listener[] getListeners(int n2) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(n2);
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hasMarkedText(long l2, long l3) {
        return false;
    }

    NSRect headerRectOfColumn(long l2, long l3, long l4) {
        return this.callSuperRect(l2, l3, l4);
    }

    void helpRequested(long l2, long l3, long l4) {
    }

    void highlightSelectionInClipRect(long l2, long l3, long l4) {
    }

    long hitTest(long l2, long l3, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, nSPoint);
    }

    long hitTestForEvent(long l2, long l3, long l4, NSRect nSRect, long l5) {
        return 0L;
    }

    boolean hooks(int n2) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n2);
    }

    long image(long l2, long l3) {
        return 0L;
    }

    NSRect imageRectForBounds(long l2, long l3, NSRect nSRect) {
        return new NSRect();
    }

    boolean insertText(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
        return true;
    }

    boolean isActive() {
        return true;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    boolean isDrawing() {
        return true;
    }

    boolean isFlipped(long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3) != 0L;
    }

    public boolean isListening(int n2) {
        this.checkWidget();
        return this.hooks(n2);
    }

    boolean isOpaque(long l2, long l3) {
        return false;
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void flagsChanged(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void keyDown(long l2, long l3, long l4) {
        this.superKeyDown(l2, l3, l4);
    }

    void keyUp(long l2, long l3, long l4) {
        this.superKeyUp(l2, l3, l4);
    }

    void mouseDown(long l2, long l3, long l4) {
        this.mouseDownSuper(l2, l3, l4);
    }

    boolean mouseDownCanMoveWindow(long l2, long l3) {
        return this.callSuperBoolean(l2, l3);
    }

    void mouseDownSuper(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void mouseUp(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void mouseMoved(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void mouseDragged(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void mouseEntered(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void mouseExited(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void cursorUpdate(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void rightMouseDown(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void rightMouseUp(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void rightMouseDragged(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void otherMouseDown(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void otherMouseUp(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void otherMouseDragged(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    boolean shouldDelayWindowOrderingForEvent(long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, l4) != 0L;
    }

    boolean menuHasKeyEquivalent_forEvent_target_action(long l2, long l3, long l4, long l5, long l6, long l7) {
        return true;
    }

    long menuForEvent(long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l3, l4);
    }

    void menuNeedsUpdate(long l2, long l3, long l4) {
    }

    boolean makeFirstResponder(long l2, long l3, long l4) {
        return this.callSuperBoolean(l2, l3, l4);
    }

    NSRange markedRange(long l2, long l3) {
        return new NSRange();
    }

    void menu_willHighlightItem(long l2, long l3, long l4, long l5) {
    }

    void menuDidClose(long l2, long l3, long l4) {
    }

    void menuWillOpen(long l2, long l3, long l4) {
    }

    void noResponderFor(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    long numberOfRowsInTableView(long l2, long l3, long l4) {
        return 0L;
    }

    long outlineView_child_ofItem(long l2, long l3, long l4, long l5, long l6) {
        return 0L;
    }

    void outlineView_didClickTableColumn(long l2, long l3, long l4, long l5) {
    }

    long outlineView_objectValueForTableColumn_byItem(long l2, long l3, long l4, long l5, long l6) {
        return 0L;
    }

    boolean outlineView_isItemExpandable(long l2, long l3, long l4, long l5) {
        return false;
    }

    long outlineView_numberOfChildrenOfItem(long l2, long l3, long l4, long l5) {
        return 0L;
    }

    boolean outlineView_shouldExpandItem_item(long l2, long l3, long l4, long l5) {
        return true;
    }

    boolean outlineView_shouldReorderColumn_toColumn(long l2, long l3, long l4, long l5, long l6) {
        return true;
    }

    boolean outlineView_shouldEditTableColumn_row(long l2, long l3, long l4, long l5, long l6) {
        return false;
    }

    boolean outlineView_shouldTrackCell_forTableColumn_item(long l2, long l3, long l4, long l5, long l6, long l7) {
        return true;
    }

    void outlineView_willDisplayCell_forTableColumn_item(long l2, long l3, long l4, long l5, long l6, long l7) {
    }

    void outlineViewColumnDidMove(long l2, long l3, long l4) {
    }

    void outlineViewColumnDidResize(long l2, long l3, long l4) {
    }

    void outlineViewSelectionDidChange(long l2, long l3, long l4) {
    }

    void outlineViewSelectionIsChanging(long l2, long l3, long l4) {
    }

    void outlineView_setObjectValue_forTableColumn_byItem(long l2, long l3, long l4, long l5, long l6, long l7) {
    }

    boolean outlineView_writeItems_toPasteboard(long l2, long l3, long l4, long l5, long l6) {
        return false;
    }

    public void notifyListeners(int n2, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n2, event);
    }

    void pageDown(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void pageUp(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void postEvent(int n2) {
        this.sendEvent(n2, null, false);
    }

    void postEvent(int n2, Event event) {
        this.sendEvent(n2, event, false);
    }

    void reflectScrolledClipView(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void register() {
    }

    void release(boolean bl2) {
        if ((this.state & 0x10000) == 0) {
            this.state |= 0x10000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl2);
        }
        if ((this.state & 0x8000) == 0) {
            this.state |= 0x8000;
            if (bl2) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl2) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
        this.destroyJNIRef();
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        if (this.display.tooltipTarget == this) {
            this.display.tooltipTarget = null;
        }
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n2, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, listener);
    }

    protected void removeListener(int n2, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, sWTEventListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    static int resolveTextDirection(String string) {
        return 0;
    }

    void scrollClipViewToPoint(long l2, long l3, long l4, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, l4, nSPoint);
    }

    void selectRowIndexes_byExtendingSelection(long l2, long l3, long l4, boolean bl2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, l4, bl2);
    }

    void scrollWheel(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    NSRange selectedRange(long l2, long l3) {
        return new NSRange();
    }

    long nextValidKeyView(long l2, long l3) {
        return this.callSuperObject(l2, l3);
    }

    long previousValidKeyView(long l2, long l3) {
        return this.callSuperObject(l2, l3);
    }

    void sendDoubleSelection() {
    }

    void sendEvent(Event event) {
        this.display.sendEvent(this.eventTable, event);
    }

    void sendEvent(int n2) {
        this.sendEvent(n2, null, true);
    }

    void sendEvent(int n2, Event event) {
        this.sendEvent(n2, event, true);
    }

    void sendEvent(int n2, Event event, boolean bl2) {
        if (this.eventTable == null && !this.display.filters(n2)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n2;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl2) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n2) {
        if ((this.state & 0x100000) != 0) {
            return true;
        }
        Event event = new Event();
        if (!this.setKeyState(event, n2, nSEvent)) {
            return true;
        }
        return this.sendKeyEvent(n2, event);
    }

    boolean sendKeyEvent(int n2, Event event) {
        this.sendEvent(n2, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendHorizontalSelection() {
    }

    void sendCancelSelection() {
    }

    void sendSearchSelection() {
    }

    void sendSelection() {
    }

    void sendSelectionEvent(int n2) {
        this.sendSelectionEvent(n2, null, false);
    }

    void sendSelectionEvent(int n2, Event event, boolean bl2) {
        NSEvent nSEvent;
        if (this.eventTable == null && !this.display.filters(n2)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        if ((nSEvent = NSApplication.sharedApplication().currentEvent()) != null) {
            this.setInputState(event, nSEvent, 0);
        }
        this.sendEvent(n2, event, bl2);
    }

    void sendVerticalSelection() {
    }

    public void setData(Object object) {
        this.checkWidget();
        if (WEBKIT_EVENTS_FIX_KEY.equals(object)) {
            this.state |= 0x100000;
            return;
        }
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (GLCONTEXT_KEY.equals(string)) {
            this.setOpenGLContext(object);
            return;
        }
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            for (n2 = 1; n2 < objectArray.length && !string.equals(objectArray[n2]); n2 += 2) {
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n2 == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n2] = string;
            objectArray[n2 + 1] = object;
        } else if ((this.state & 4) != 0 && n2 != objectArray.length) {
            int n3 = objectArray.length - 2;
            if (n3 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n3];
                System.arraycopy(objectArray, 0, objectArray3, 0, n2);
                System.arraycopy(objectArray, n2 + 2, objectArray3, n2, n3 - n2);
                this.data = objectArray3;
            }
        }
        if (string.equals("org.eclipse.swt.skin.class") || string.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    void setOpenGLContext(Object object) {
    }

    void setOrientation() {
    }

    void setFrameOrigin(long l2, long l3, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, nSPoint);
    }

    void setFrameSize(long l2, long l3, NSSize nSSize) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, nSSize);
    }

    void setImage(long l2, long l3, long l4) {
    }

    boolean setInputState(Event event, NSEvent nSEvent, int n2) {
        int n3;
        if (nSEvent == null && (nSEvent = NSApplication.sharedApplication().currentEvent()) == null) {
            return true;
        }
        long l2 = nSEvent.modifierFlags();
        if ((l2 & 0x80000L) != 0L) {
            event.stateMask |= 0x10000;
        }
        if ((l2 & 0x20000L) != 0L) {
            event.stateMask |= 0x20000;
        }
        if ((l2 & 0x40000L) != 0L) {
            event.stateMask |= 0x40000;
        }
        if ((l2 & 0x100000L) != 0L) {
            event.stateMask |= 0x400000;
        }
        if (((n3 = OS.GetCurrentEventButtonState()) & 1) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((n3 & 2) != 0) {
            event.stateMask |= 0x200000;
        }
        if ((n3 & 4) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((n3 & 8) != 0) {
            event.stateMask |= 0x800000;
        }
        if ((n3 & 0x10) != 0) {
            event.stateMask |= 0x2000000;
        }
        switch (n2) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode == 262144) {
                    event.stateMask &= 0xFFFBFFFF;
                }
                if (event.keyCode != 0x400000) break;
                event.stateMask &= 0xFFBFFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode == 262144) {
                    event.stateMask |= 0x40000;
                }
                if (event.keyCode != 0x400000) break;
                event.stateMask |= 0x400000;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int n2, NSEvent nSEvent) {
        boolean bl2 = false;
        short s2 = nSEvent.keyCode();
        event.keyCode = Display.translateKey(s2);
        switch (event.keyCode) {
            case 10: {
                event.keyCode = 0x1000050;
                event.character = (char)13;
                break;
            }
            case 8: {
                event.character = (char)8;
                break;
            }
            case 13: {
                event.character = (char)13;
                break;
            }
            case 127: {
                event.character = (char)127;
                break;
            }
            case 27: {
                event.character = (char)27;
                break;
            }
            case 9: {
                event.character = (char)9;
                break;
            }
            default: {
                NSString nSString;
                if ((event.keyCode == 0 || 16777258 <= event.keyCode && event.keyCode <= 0x1000050) && (nSString = nSEvent.characters()) != null && nSString.length() > 0L) {
                    event.character = (char)nSString.characterAtIndex(0L);
                }
                if (event.keyCode != 0) break;
                long l2 = 0L;
                long l3 = OS.TISCopyCurrentKeyboardInputSource();
                long l4 = OS.TISGetInputSourceProperty(l3, OS.kTISPropertyUnicodeKeyLayoutData());
                if (l4 != 0L) {
                    l2 = OS.CFDataGetBytePtr(l4);
                    if (l2 != 0L && OS.CFDataGetLength(l4) > 0L) {
                        long l5 = nSEvent.CGEvent();
                        long l6 = OS.CGEventGetIntegerValueField(l5, 10);
                        int n3 = 256;
                        char[] cArray = new char[n3];
                        int[] nArray = new int[1];
                        int[] nArray2 = new int[1];
                        OS.UCKeyTranslate(l2, s2, (short)(event.type != 1 ? 1 : 0), 0, (int)l6, 0, nArray2, n3, nArray, cArray);
                        event.keyCode = nArray[0] < 1 ? 0 : cArray[0];
                    }
                } else {
                    NSString nSString2 = nSEvent.charactersIgnoringModifiers().lowercaseString();
                    if (nSString2.length() > 0L) {
                        event.keyCode = (char)nSString2.characterAtIndex(0L);
                    }
                }
                if (l3 == 0L) break;
                OS.CFRelease(l3);
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !bl2) {
            return false;
        }
        this.setLocationMask(event, nSEvent);
        this.setInputState(event, nSEvent, n2);
        return true;
    }

    void setLocationMask(Event event, NSEvent nSEvent) {
        switch (nSEvent.keyCode()) {
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                event.keyLocation = 16384;
                break;
            }
            case 54: 
            case 60: 
            case 61: 
            case 62: {
                event.keyLocation = 131072;
                break;
            }
            case 65: 
            case 67: 
            case 69: 
            case 75: 
            case 76: 
            case 78: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: {
                event.keyLocation = 2;
            }
        }
    }

    boolean setMarkedText_selectedRange(long l2, long l3, long l4, long l5) {
        return true;
    }

    void setNeedsDisplay(long l2, long l3, boolean bl2) {
        if (bl2 && !this.isDrawing()) {
            return;
        }
        NSView nSView = new NSView(l2);
        if (bl2 && this.display.isPainting.containsObject(nSView)) {
            NSMutableArray nSMutableArray = this.display.needsDisplay;
            if (nSMutableArray == null) {
                nSMutableArray = (NSMutableArray)new NSMutableArray().alloc();
                this.display.needsDisplay = nSMutableArray = nSMutableArray.initWithCapacity(12L);
            }
            nSMutableArray.addObject(nSView);
            return;
        }
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, bl2);
    }

    void setNeedsDisplayInRect(long l2, long l3, long l4) {
        if (!this.isDrawing()) {
            return;
        }
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, l4, (long)NSRect.sizeof);
        NSView nSView = new NSView(l2);
        if (this.display.isPainting.containsObject(nSView)) {
            NSMutableArray nSMutableArray = this.display.needsDisplayInRect;
            if (nSMutableArray == null) {
                nSMutableArray = (NSMutableArray)new NSMutableArray().alloc();
                this.display.needsDisplayInRect = nSMutableArray = nSMutableArray.initWithCapacity(12L);
            }
            nSMutableArray.addObject(nSView);
            nSMutableArray.addObject(NSValue.valueWithRect(nSRect));
            return;
        }
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3, nSRect);
    }

    void setObjectValue(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void setShouldExpandItem(long l2, long l3, boolean bl2) {
    }

    void setShouldScrollClipView(long l2, long l3, boolean bl2) {
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        return false;
    }

    boolean shouldChangeTextInRange_replacementString(long l2, long l3, long l4, long l5) {
        return true;
    }

    NSSize sizeOfLabel(long l2, long l3, boolean bl2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, objc_super2, l3, bl2);
        return nSSize;
    }

    void superKeyDown(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void superKeyUp(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void tableViewColumnDidMove(long l2, long l3, long l4) {
    }

    void tableViewColumnDidResize(long l2, long l3, long l4) {
    }

    void tableViewSelectionDidChange(long l2, long l3, long l4) {
    }

    void tableViewSelectionIsChanging(long l2, long l3, long l4) {
    }

    void tableView_didClickTableColumn(long l2, long l3, long l4, long l5) {
    }

    long tableView_objectValueForTableColumn_row(long l2, long l3, long l4, long l5, long l6) {
        return 0L;
    }

    boolean tableView_shouldSelectRow(long l2, long l3, long l4, long l5) {
        return true;
    }

    void tableView_setObjectValue_forTableColumn_row(long l2, long l3, long l4, long l5, long l6, long l7) {
    }

    boolean tableView_shouldReorderColumn_toColumn(long l2, long l3, long l4, long l5, long l6) {
        return true;
    }

    boolean tableView_shouldEditTableColumn_row(long l2, long l3, long l4, long l5, long l6) {
        return false;
    }

    boolean tableView_shouldTrackCell_forTableColumn_row(long l2, long l3, long l4, long l5, long l6, long l7) {
        return true;
    }

    void tableView_willDisplayCell_forTableColumn_row(long l2, long l3, long l4, long l5, long l6, long l7) {
    }

    void textViewDidChangeSelection(long l2, long l3, long l4) {
    }

    void textDidChange(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void textDidEndEditing(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long l2, long l3, long l4, long l5, long l6) {
        return new NSRange();
    }

    NSRect titleRectForBounds(long l2, long l3, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, l3, nSRect);
        return nSRect2;
    }

    long toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(long l2, long l3, long l4, long l5, boolean bl2) {
        return 0L;
    }

    long toolbarAllowedItemIdentifiers(long l2, long l3, long l4) {
        return 0L;
    }

    long toolbarDefaultItemIdentifiers(long l2, long l3, long l4) {
        return 0L;
    }

    long toolbarSelectableItemIdentifiers(long l2, long l3, long l4) {
        return 0L;
    }

    String tooltipText() {
        return null;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }

    void touchesBeganWithEvent(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void touchesCancelledWithEvent(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void touchesEndedWithEvent(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void touchesMovedWithEvent(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void beginGestureWithEvent(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void endGestureWithEvent(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void magnifyWithEvent(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void rotateWithEvent(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void swipeWithEvent(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    void resetCursorRects(long l2, long l3) {
        this.callSuper(l2, l3);
    }

    void updateTrackingAreas(long l2, long l3) {
        this.callSuper(l2, l3);
    }

    long validAttributesForMarkedText(long l2, long l3) {
        return 0L;
    }

    void tabView_didSelectTabViewItem(long l2, long l3, long l4, long l5) {
    }

    void tabView_willSelectTabViewItem(long l2, long l3, long l4, long l5) {
    }

    boolean tableView_writeRowsWithIndexes_toPasteboard(long l2, long l3, long l4, long l5, long l6) {
        return false;
    }

    boolean validateMenuItem(long l2, long l3, long l4) {
        return true;
    }

    long view_stringForToolTip_point_userData(long l2, long l3, long l4, long l5, long l6, long l7) {
        return 0L;
    }

    void viewDidMoveToWindow(long l2, long l3) {
    }

    void viewWillMoveToWindow(long l2, long l3, long l4) {
    }

    void windowDidMove(long l2, long l3, long l4) {
    }

    void windowDidResize(long l2, long l3, long l4) {
    }

    void windowDidResignKey(long l2, long l3, long l4) {
    }

    void windowDidBecomeKey(long l2, long l3, long l4) {
    }

    void windowDidMiniturize(long l2, long l3, long l4) {
    }

    void windowDidDeminiturize(long l2, long l3, long l4) {
    }

    void windowSendEvent(long l2, long l3, long l4) {
        this.callSuper(l2, l3, l4);
    }

    boolean windowShouldClose(long l2, long l3, long l4) {
        return false;
    }

    void windowWillClose(long l2, long l3, long l4) {
    }

    long nextState(long l2, long l3) {
        return this.callSuperObject(l2, l3);
    }

    void updateOpenGLContext(long l2, long l3, long l4) {
    }

    boolean shouldDrawInsertionPoint(long l2, long l3) {
        return this.callSuperBoolean(l2, l3);
    }

    boolean readSelectionFromPasteboard(long l2, long l3, long l4) {
        return false;
    }

    long validRequestorForSendType(long l2, long l3, long l4, long l5) {
        return this.callSuperObject(l2, l3, l4, l5);
    }

    boolean writeSelectionToPasteboard(long l2, long l3, long l4, long l5) {
        return false;
    }
}

