/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTreeItem;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeItem
extends Item {
    Tree parent;
    TreeItem parentItem;
    TreeItem[] items;
    int itemCount;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    boolean expanded;
    Color foreground;
    Color background;
    Color[] cellForeground;
    Color[] cellBackground;
    Font font;
    Font[] cellFont;
    int width = -1;
    public SWTTreeItem handle;

    public TreeItem(Tree tree, int n2) {
        this(TreeItem.checkNull(tree), null, n2, -1, true);
    }

    public TreeItem(Tree tree, int n2, int n3) {
        this(TreeItem.checkNull(tree), null, n2, TreeItem.checkIndex(n3), true);
    }

    public TreeItem(TreeItem treeItem, int n2) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, treeItem, n2, -1, true);
    }

    public TreeItem(TreeItem treeItem, int n2, int n3) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, treeItem, n2, TreeItem.checkIndex(n3), true);
    }

    TreeItem(Tree tree, TreeItem treeItem, int n2, int n3, boolean bl2) {
        super(tree, n2);
        this.parent = tree;
        this.parentItem = treeItem;
        if (bl2) {
            tree.createItem(this, treeItem, n3);
        } else {
            this.handle = (SWTTreeItem)new SWTTreeItem().alloc().init();
            this.createJNIRef();
            this.register();
            this.items = new TreeItem[4];
        }
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    static int checkIndex(int n2) {
        if (n2 < 0) {
            SWT.error(6);
        }
        return n2;
    }

    int calculateWidth(int n2, GC gC) {
        Object object;
        Object object2;
        String string;
        if (n2 == 0 && this.width != -1) {
            return this.width;
        }
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[n2];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.font;
        }
        if (font == null) {
            font = this.parent.defaultFont();
        }
        String string2 = n2 == 0 ? this.text : (string = this.strings == null ? "" : this.strings[n2]);
        Image image = n2 == 0 ? this.image : (this.images == null ? null : this.images[n2]);
        NSTextFieldCell nSTextFieldCell = this.parent.dataCell;
        if (font.extraTraits != 0) {
            object2 = this.parent.createString(string, font, null, 0, false, true, false);
            nSTextFieldCell.setAttributedStringValue((NSAttributedString)object2);
            ((NSObject)object2).release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            object2 = (NSString)new NSString().alloc();
            object2 = ((NSString)object2).initWithString(string != null ? string : "");
            nSTextFieldCell.setTitle((NSString)object2);
            ((NSObject)object2).release();
        }
        object2 = new objc_super();
        ((objc_super)object2).receiver = nSTextFieldCell.id;
        ((objc_super)object2).super_class = OS.objc_msgSend(nSTextFieldCell.id, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, (objc_super)object2, OS.sel_cellSize);
        if (image != null) {
            nSSize.width += (double)(this.parent.imageBounds.width + 3);
        }
        int n3 = (int)Math.ceil(nSSize.width);
        boolean bl2 = true;
        if ((this.parent.style & 0x10000000) != 0) {
            bl2 = this.cached;
        }
        if (bl2 && this.parent.hooks(41)) {
            gC.setFont(font);
            object = new Event();
            ((Event)object).item = this;
            ((Event)object).index = n2;
            ((Event)object).gc = gC;
            NSTableView nSTableView = (NSTableView)this.parent.view;
            int n4 = (int)nSTableView.rowHeight();
            ((Event)object).width = n3;
            ((Event)object).height = n4;
            ((Event)object).detail = nSTextFieldCell.isHighlighted() && ((this.style & 0x8000) == 0 || this.parent.hasFocus()) ? 2 : 0;
            this.parent.sendEvent(41, (Event)object);
            if (n4 < ((Event)object).height) {
                nSTableView.setRowHeight(((Event)object).height);
                nSTableView.setNeedsDisplay(true);
            }
            n3 = ((Event)object).width;
        }
        if (n2 == 0) {
            object = (NSOutlineView)this.parent.view;
            this.width = n3 = (int)((double)n3 + ((NSOutlineView)object).indentationPerLevel() * (double)(1L + ((NSOutlineView)object).levelForItem(this.handle)));
        }
        return n3;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.cached = false;
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.grayed = false;
        this.checked = false;
        this.background = null;
        this.foreground = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.font = null;
        this.cellFont = null;
        this.width = -1;
    }

    public void clear(int n2, boolean bl2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (n2 < 0 || n2 >= n3) {
            this.error(6);
        }
        this.parent.clear(this, n2, bl2);
    }

    public void clearAll(boolean bl2) {
        this.checkWidget();
        this.parent.clearAll(this, bl2);
    }

    NSObject createString(int n2) {
        String string = n2 == 0 ? this.text : (this.strings == null ? "" : this.strings[n2]);
        return NSString.stringWith(string != null ? string : "");
    }

    void dealloc(long l2, long l3) {
        OS.object_setInstanceVariable(l2, Display.SWT_OBJECT, 0L);
        super.destroyJNIRef();
        super.dealloc(l2, l3);
    }

    void deregister() {
        super.deregister();
    }

    void destroyJNIRef() {
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[n2] == null) {
            return this.getBackground();
        }
        return this.cellBackground[n2];
    }

    public Rectangle getBounds() {
        Object object;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        this.parent.checkItems();
        NSOutlineView nSOutlineView = (NSOutlineView)this.parent.view;
        int n2 = (int)nSOutlineView.rowForItem(this.handle);
        if (n2 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        NSTableColumn nSTableColumn = this.parent.columnCount == 0 ? this.parent.firstColumn : this.parent.columns[0].nsColumn;
        int n3 = this.parent.indexOf(nSTableColumn);
        NSRect nSRect = nSOutlineView.frameOfCellAtColumn(n3, n2);
        if (this.image != null) {
            nSRect.x += (double)(this.parent.imageBounds.width + 3);
        }
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[n3];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.font;
        }
        if (font == null) {
            font = this.parent.defaultFont();
        }
        NSTextFieldCell nSTextFieldCell = this.parent.dataCell;
        nSTextFieldCell.setImage(null);
        if (font.extraTraits != 0) {
            object = this.parent.createString(this.text, font, null, 0, false, true, false);
            nSTextFieldCell.setAttributedStringValue((NSAttributedString)object);
            ((NSObject)object).release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            object = (NSString)new NSString().alloc();
            object = ((NSString)object).initWithString(this.text);
            nSTextFieldCell.setTitle((NSString)object);
            ((NSObject)object).release();
        }
        object = new objc_super();
        ((objc_super)object).receiver = nSTextFieldCell.id;
        ((objc_super)object).super_class = OS.objc_msgSend(nSTextFieldCell.id, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, (objc_super)object, OS.sel_cellSize);
        NSRect nSRect2 = nSOutlineView.rectOfColumn(n3);
        nSSize.width = Math.min(nSSize.width, nSRect2.width - (nSRect.x - nSRect2.x));
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)Math.ceil(nSSize.width), (int)Math.ceil(nSRect.height));
    }

    public Rectangle getBounds(int n2) {
        Object object;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n2 || n2 >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.parent.checkItems();
        NSOutlineView nSOutlineView = (NSOutlineView)this.parent.view;
        if (this.parent.columnCount == 0) {
            n2 = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            object = this.parent.getColumn(n2);
            n2 = this.parent.indexOf(((TreeColumn)object).nsColumn);
        }
        object = nSOutlineView.frameOfCellAtColumn(n2, nSOutlineView.rowForItem(this.handle));
        return new Rectangle((int)((NSRect)object).x, (int)((NSRect)object).y, (int)((NSRect)object).width, (int)((NSRect)object).height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n2] == null) {
            return this.getFont();
        }
        return this.cellFont[n2];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[n2] == null) {
            return this.getForeground();
        }
        return this.cellForeground[n2];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n2 == 0) {
            return this.getImage();
        }
        if (this.images != null && 0 <= n2 && n2 < this.images.length) {
            return this.images[n2];
        }
        return null;
    }

    public Rectangle getImageBounds(int n2) {
        Object object;
        Image image;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n2 || n2 >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.parent.checkItems();
        NSOutlineView nSOutlineView = (NSOutlineView)this.parent.view;
        Image image2 = n2 == 0 ? this.image : (image = this.images != null ? this.images[n2] : null);
        if (this.parent.columnCount == 0) {
            n2 = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            object = this.parent.getColumn(n2);
            n2 = this.parent.indexOf(((TreeColumn)object).nsColumn);
        }
        object = nSOutlineView.frameOfCellAtColumn(n2, nSOutlineView.rowForItem(this.handle));
        ((NSRect)object).x += 3.0;
        ((NSRect)object).width = image != null ? (double)this.parent.imageBounds.width : 0.0;
        return new Rectangle((int)((NSRect)object).x, (int)((NSRect)object).y, (int)((NSRect)object).width, (int)((NSRect)object).height);
    }

    public TreeItem getItem(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n2 >= this.itemCount) {
            this.error(6);
        }
        return this.parent._getItem(this, n2, true);
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.itemCount;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        TreeItem[] treeItemArray = new TreeItem[this.itemCount];
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            treeItemArray[i2] = this.parent._getItem(this, i2, true);
        }
        return treeItemArray;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n2 == 0) {
            return this.getText();
        }
        if (this.strings != null && 0 <= n2 && n2 < this.strings.length) {
            String string = this.strings[n2];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int n2) {
        Object object;
        Image image;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n2 || n2 >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.parent.checkItems();
        NSOutlineView nSOutlineView = (NSOutlineView)this.parent.view;
        Image image2 = n2 == 0 ? this.image : (image = this.images != null ? this.images[n2] : null);
        if (this.parent.columnCount == 0) {
            n2 = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            object = this.parent.getColumn(n2);
            n2 = this.parent.indexOf(((TreeColumn)object).nsColumn);
        }
        object = nSOutlineView.frameOfCellAtColumn(n2, nSOutlineView.rowForItem(this.handle));
        ((NSRect)object).x += 2.0;
        ((NSRect)object).width -= 2.0;
        if (image != null) {
            int n3 = this.parent.imageBounds.width + 3;
            ((NSRect)object).x += (double)n3;
            ((NSRect)object).width -= (double)n3;
        }
        return new Rectangle((int)((NSRect)object).x, (int)((NSRect)object).y, (int)((NSRect)object).width, (int)((NSRect)object).height);
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parentItem != this) {
            return -1;
        }
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            if (treeItem != this.items[i2]) continue;
            return i2;
        }
        return -1;
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    void redraw(int n2) {
        NSRect nSRect;
        if (this.parent.ignoreRedraw || !this.isDrawing()) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.parent.view;
        if (n2 == -1 || this.parent.hooks(41) || this.parent.hooks(40) || this.parent.hooks(42)) {
            nSRect = nSOutlineView.rectOfRow(nSOutlineView.rowForItem(this.handle));
        } else {
            int n3;
            if (this.parent.columnCount == 0) {
                n3 = (this.parent.style & 0x20) != 0 ? 1 : 0;
            } else if (0 <= n2 && n2 < this.parent.columnCount) {
                n3 = this.parent.indexOf(this.parent.columns[n2].nsColumn);
            } else {
                return;
            }
            nSRect = nSOutlineView.frameOfCellAtColumn(n3, nSOutlineView.rowForItem(this.handle));
        }
        nSOutlineView.setNeedsDisplayInRect(nSRect);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
    }

    void release(boolean bl2) {
        TreeItem[] treeItemArray = null;
        Tree tree = this.parent;
        if (bl2 && this.getDrawing()) {
            treeItemArray = tree.getSelection();
        }
        super.release(bl2);
        if (treeItemArray != null) {
            tree.selectItems(treeItemArray, true);
        }
    }

    void releaseChildren(boolean bl2) {
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            TreeItem treeItem = this.items[i2];
            if (treeItem == null || treeItem.isDisposed()) continue;
            treeItem.release(false);
        }
        this.items = null;
        this.itemCount = 0;
        super.releaseChildren(bl2);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != null) {
            this.handle.autorelease();
        }
        this.handle = null;
        this.parentItem = null;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void removeAll() {
        this.checkWidget();
        this.parent.setItemCount(this, 0);
    }

    void sendExpand(boolean bl2, boolean bl3) {
        if (this.itemCount == 0) {
            return;
        }
        if (this.expanded != bl2) {
            Event event = new Event();
            event.item = this;
            this.parent.sendEvent(bl2 ? 17 : 18, event);
            if (this.isDisposed()) {
                return;
            }
            this.expanded = bl2;
        }
        if (bl3) {
            for (int i2 = 0; i2 < this.itemCount; ++i2) {
                if (this.items[i2] == null) continue;
                this.items[i2].sendExpand(bl2, bl3);
            }
        }
    }

    public void setBackground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if ((color2 = this.background) == color) {
            return;
        }
        this.background = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(-1);
    }

    public void setBackground(int n2, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        if (this.cellBackground == null) {
            if (color == null) {
                return;
            }
            this.cellBackground = new Color[n3];
        }
        if ((color2 = this.cellBackground[n2]) == color) {
            return;
        }
        this.cellBackground[n2] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(n2);
    }

    public void setChecked(boolean bl2) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == bl2) {
            return;
        }
        this.checked = bl2;
        this.cached = true;
        this.redraw(-1);
    }

    public void setExpanded(boolean bl2) {
        this.checkWidget();
        if (this.itemCount == 0 || bl2 == this.getExpanded()) {
            return;
        }
        this.parent.checkItems();
        this.parent.ignoreExpand = true;
        this.expanded = bl2;
        if (bl2) {
            ((NSOutlineView)this.parent.view).expandItem(this.handle);
        } else {
            ((NSOutlineView)this.parent.view).collapseItem(this.handle);
        }
        this.parent.ignoreExpand = false;
        this.cached = true;
        if (!bl2) {
            this.parent.setScrollWidth();
        }
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.width = -1;
        this.cached = true;
        this.redraw(-1);
    }

    public void setFont(int n2, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[n3];
        }
        if ((font2 = this.cellFont[n2]) == font) {
            return;
        }
        this.cellFont[n2] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.width = -1;
        this.cached = true;
        this.redraw(n2);
    }

    public void setForeground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if ((color2 = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(-1);
    }

    public void setForeground(int n2, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        if (this.cellForeground == null) {
            if (color == null) {
                return;
            }
            this.cellForeground = new Color[n3];
        }
        if ((color2 = this.cellForeground[n2]) == color) {
            return;
        }
        this.cellForeground[n2] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(n2);
    }

    public void setGrayed(boolean bl2) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl2) {
            return;
        }
        this.grayed = bl2;
        this.cached = true;
        this.redraw(-1);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < imageArray.length; ++i2) {
            this.setImage(i2, imageArray[i2]);
        }
    }

    public void setImage(int n2, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.parent.imageBounds == null && image != null) {
            this.parent.setItemHeight(image, null, false);
        }
        if (n2 == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            this.width = -1;
            super.setImage(image);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 <= n2 && n2 < n3) {
            if (this.images == null) {
                this.images = new Image[n3];
            }
            if (image != null && image.type == 1 && image.equals(this.images[n2])) {
                return;
            }
            this.images[n2] = image;
        }
        this.cached = true;
        if (n2 == 0) {
            this.parent.setScrollWidth(this);
        }
        if (0 <= n2 && n2 < n3) {
            this.redraw(n2);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setItemCount(int n2) {
        this.checkWidget();
        n2 = Math.max(0, n2);
        this.parent.setItemCount(this, n2);
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string == null) continue;
            this.setText(i2, string);
        }
    }

    public void setText(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n2 == 0) {
            if (string.equals(this.text)) {
                return;
            }
            this.width = -1;
            super.setText(string);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 <= n2 && n2 < n3) {
            if (this.strings == null) {
                this.strings = new String[n3];
            }
            if (string.equals(this.strings[n2])) {
                return;
            }
            this.strings[n2] = string;
        }
        this.cached = true;
        if (n2 == 0) {
            this.parent.setScrollWidth(this);
        }
        if (0 <= n2 && n2 < n3) {
            this.redraw(n2);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    void updateExpanded() {
        if (this.itemCount == 0) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.parent.view;
        if (this.expanded != nSOutlineView.isItemExpanded(this.handle)) {
            if (this.expanded) {
                nSOutlineView.expandItem(this.handle);
            } else {
                nSOutlineView.collapseItem(this.handle);
            }
        }
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            if (this.items[i2] == null) continue;
            this.items[i2].updateExpanded();
        }
    }
}

