/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Cursor clientCursor;
    Cursor resizeCursor;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    boolean inEvent = false;
    NSWindow window;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n2) {
        super(composite, Tracker.checkStyle(n2));
        this.parent = composite;
    }

    public Tracker(Display display, int n2) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n2);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n2 = this.bounds.x + this.bounds.width / 2;
        int n3 = this.bounds.y;
        if (this.parent != null) {
            Point point = this.parent.toDisplay(n2, n3);
            n2 = point.x;
            n3 = point.y;
        }
        this.display.setCursorLocation(n2, n3);
        return new Point(n2, n3);
    }

    Point adjustResizeCursor(boolean bl2) {
        Object object;
        if (this.bounds == null) {
            return null;
        }
        int n2 = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n3 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        if (this.parent != null) {
            object = this.parent.toDisplay(n2, n3);
            n2 = ((Point)object).x;
            n3 = ((Point)object).y;
        }
        if (bl2) {
            this.display.setCursorLocation(n2, n3);
        }
        if (this.clientCursor == null) {
            object = null;
            switch (this.cursorOrientation) {
                case 128: {
                    object = new Cursor(this.display, 7);
                    break;
                }
                case 1024: {
                    object = new Cursor(this.display, 7);
                    break;
                }
                case 16384: {
                    object = new Cursor(this.display, 9);
                    break;
                }
                case 131072: {
                    object = new Cursor(this.display, 9);
                    break;
                }
                case 16512: {
                    object = new Cursor(this.display, 8);
                    break;
                }
                case 132096: {
                    object = new Cursor(this.display, 8);
                    break;
                }
                case 17408: {
                    object = new Cursor(this.display, 6);
                    break;
                }
                case 131200: {
                    object = new Cursor(this.display, 6);
                    break;
                }
                default: {
                    object = new Cursor(this.display, 5);
                }
            }
            this.display.lockCursor = false;
            ((Cursor)object).handle.set();
            this.display.lockCursor = true;
            if (this.resizeCursor != null) {
                this.resizeCursor.dispose();
            }
            this.resizeCursor = object;
        }
        return new Point(n2, n3);
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x24480) == 0) {
            n2 |= 0x24480;
        }
        return n2;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int n2 = this.rectangles[0].x;
        int n3 = this.rectangles[0].y;
        int n4 = this.rectangles[0].x + this.rectangles[0].width;
        int n5 = this.rectangles[0].y + this.rectangles[0].height;
        for (int i2 = 1; i2 < this.rectangles.length; ++i2) {
            int n6;
            int n7;
            if (this.rectangles[i2].x < n2) {
                n2 = this.rectangles[i2].x;
            }
            if (this.rectangles[i2].y < n3) {
                n3 = this.rectangles[i2].y;
            }
            if ((n7 = this.rectangles[i2].x + this.rectangles[i2].width) > n4) {
                n4 = n7;
            }
            if ((n6 = this.rectangles[i2].y + this.rectangles[i2].height) <= n5) continue;
            n5 = n6;
        }
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                if (this.bounds.width != 0) {
                    n2 = (rectangleArray[i2].x - this.bounds.x) * 100 / this.bounds.width;
                    n4 = rectangleArray[i2].width * 100 / this.bounds.width;
                } else {
                    n4 = 100;
                }
                if (this.bounds.height != 0) {
                    n3 = (rectangleArray[i2].y - this.bounds.y) * 100 / this.bounds.height;
                    n5 = rectangleArray[i2].height * 100 / this.bounds.height;
                } else {
                    n5 = 100;
                }
                rectangleArray2[i2] = new Rectangle(n2, n3, n4, n5);
            }
        }
        return rectangleArray2;
    }

    void drawRectangles(NSWindow nSWindow, Rectangle[] rectangleArray, boolean bl2) {
        NSGraphicsContext nSGraphicsContext = nSWindow.graphicsContext();
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext(nSGraphicsContext);
        nSGraphicsContext.saveGraphicsState();
        Point point = this.parent != null ? this.display.map(this.parent, null, 0, 0) : new Point(0, 0);
        nSGraphicsContext.setCompositingOperation(bl2 ? 0L : 2L);
        NSRect nSRect = new NSRect();
        NSPoint nSPoint = new NSPoint();
        double d2 = this.display.getPrimaryFrame().height;
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            Rectangle rectangle = rectangleArray[i2];
            nSRect.x = rectangle.x + point.x;
            nSRect.y = d2 - (double)(rectangle.y + point.y + rectangle.height);
            nSRect.width = rectangle.width;
            nSRect.height = rectangle.height;
            nSPoint.x = nSRect.x;
            nSPoint.y = nSRect.y;
            nSPoint = nSWindow.convertScreenToBase(nSPoint);
            nSRect.x = nSPoint.x;
            nSRect.y = nSPoint.y;
            if (bl2) {
                nSRect.width += 1.0;
                nSRect.height += 1.0;
                NSBezierPath.fillRect(nSRect);
                continue;
            }
            nSRect.x += 0.5;
            nSRect.y += 0.5;
            NSBezierPath.strokeRect(nSRect);
        }
        if (!bl2) {
            nSGraphicsContext.flushGraphics();
        }
        nSGraphicsContext.restoreGraphicsState();
        NSGraphicsContext.static_restoreGraphicsState();
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            Rectangle rectangle = this.rectangles[i2];
            rectangleArray[i2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void mouse(NSEvent nSEvent) {
        NSPoint nSPoint;
        if (nSEvent == null || nSEvent.type() == 5L) {
            nSPoint = NSEvent.mouseLocation();
        } else {
            nSPoint = nSEvent.locationInWindow();
            nSPoint = nSEvent.window().convertBaseToScreen(nSPoint);
        }
        nSPoint.y = this.display.getPrimaryFrame().height - nSPoint.y;
        int n2 = (int)nSPoint.x;
        int n3 = (int)nSPoint.y;
        if (n2 != this.oldX || n3 != this.oldY) {
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
                Rectangle rectangle = this.rectangles[i2];
                rectangleArray2[i2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Event event = new Event();
            event.x = n2;
            event.y = n3;
            if ((this.style & 0x10) != 0) {
                Point point;
                boolean bl2 = this.resizeRectangles(n2 - this.oldX, n3 - this.oldY);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl3 = false;
                if (this.rectangles != rectangleArray) {
                    int n4 = this.rectangles.length;
                    if (n4 != rectangleArray2.length) {
                        bl3 = true;
                    } else {
                        for (int i3 = 0; i3 < n4; ++i3) {
                            if (this.rectangles[i3].equals(rectangleArray2[i3])) continue;
                            bl3 = true;
                            break;
                        }
                    }
                } else {
                    bl3 = true;
                }
                if (bl3) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                if ((point = this.adjustResizeCursor(bl2)) != null) {
                    n2 = point.x;
                    n3 = point.y;
                }
            } else {
                this.moveRectangles(n2 - this.oldX, n3 - this.oldY);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl4 = false;
                if (this.rectangles != rectangleArray) {
                    int n5 = this.rectangles.length;
                    if (n5 != rectangleArray2.length) {
                        bl4 = true;
                    } else {
                        for (int i4 = 0; i4 < n5; ++i4) {
                            if (this.rectangles[i4].equals(rectangleArray2[i4])) continue;
                            bl4 = true;
                            break;
                        }
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
            }
            this.oldX = n2;
            this.oldY = n3;
        }
        switch ((int)nSEvent.type()) {
            case 2: 
            case 4: 
            case 26: {
                this.tracking = false;
            }
        }
    }

    void key(NSEvent nSEvent) {
        int n2;
        int n3 = (int)nSEvent.type();
        long l2 = nSEvent.modifierFlags();
        short s2 = nSEvent.keyCode();
        int n4 = Display.translateKey(s2);
        switch (n3) {
            case 10: 
            case 11: {
                Event event = new Event();
                event.keyCode = n4;
                int n5 = n2 = n3 == 10 ? 1 : 2;
                if (!this.setKeyState(event, n2, nSEvent) || this.sendKeyEvent(n2, event)) break;
                return;
            }
            case 12: {
                int n6 = 0;
                switch (n4) {
                    case 65536: {
                        n6 = 524288;
                        break;
                    }
                    case 262144: {
                        n6 = 262144;
                        break;
                    }
                    case 0x400000: {
                        n6 = 0x100000;
                        break;
                    }
                    case 131072: {
                        n6 = 131072;
                        break;
                    }
                    case 16777298: {
                        Event event = new Event();
                        event.keyCode = n4;
                        this.setInputState(event, nSEvent, 1);
                        this.sendKeyEvent(1, event);
                        this.setInputState(event, nSEvent, 2);
                        this.sendKeyEvent(2, event);
                    }
                }
                if (n6 == 0) break;
                n2 = ((long)n6 & l2) != 0L ? 1 : 2;
                Event event = new Event();
                event.keyCode = n4;
                this.setLocationMask(event, nSEvent);
                this.setInputState(event, nSEvent, n2);
                if (this.sendKeyEvent(n2, event)) break;
                return;
            }
        }
        int n7 = (l2 & 0x40000L) != 0L ? 1 : 9;
        n2 = 0;
        int n8 = 0;
        switch (s2) {
            case 53: {
                this.cancelled = true;
                this.tracking = false;
                break;
            }
            case 36: 
            case 76: {
                this.tracking = false;
                break;
            }
            case 123: {
                n2 = -n7;
                break;
            }
            case 124: {
                n2 = n7;
                break;
            }
            case 126: {
                n8 = -n7;
                break;
            }
            case 125: {
                n8 = n7;
            }
        }
        if (n2 != 0 || n8 != 0) {
            Point point;
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
                Rectangle rectangle = this.rectangles[i2];
                rectangleArray2[i2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Event event = new Event();
            int n9 = this.oldX + n2;
            int n10 = this.oldY + n8;
            event.x = n9;
            event.y = n10;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(n2, n8);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl2 = false;
                if (this.rectangles != rectangleArray) {
                    int n11 = this.rectangles.length;
                    if (n11 != rectangleArray2.length) {
                        bl2 = true;
                    } else {
                        for (int i3 = 0; i3 < n11; ++i3) {
                            if (this.rectangles[i3].equals(rectangleArray2[i3])) continue;
                            bl2 = true;
                            break;
                        }
                    }
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                point = this.adjustResizeCursor(true);
            } else {
                this.moveRectangles(n2, n8);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl3 = false;
                if (this.rectangles != rectangleArray) {
                    int n12 = this.rectangles.length;
                    if (n12 != rectangleArray2.length) {
                        bl3 = true;
                    } else {
                        for (int i4 = 0; i4 < n12; ++i4) {
                            if (this.rectangles[i4].equals(rectangleArray2[i4])) continue;
                            bl3 = true;
                            break;
                        }
                    }
                } else {
                    bl3 = true;
                }
                if (bl3) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                point = this.adjustMoveCursor();
            }
            if (point != null) {
                this.oldX = point.x;
                this.oldY = point.y;
            }
        }
    }

    void moveRectangles(int n2, int n3) {
        if (this.bounds == null) {
            return;
        }
        if (n2 < 0 && (this.style & 0x4000) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x20000) == 0) {
            n2 = 0;
        }
        if (n3 < 0 && (this.style & 0x80) == 0) {
            n3 = 0;
        }
        if (n3 > 0 && (this.style & 0x400) == 0) {
            n3 = 0;
        }
        if (n2 == 0 && n3 == 0) {
            return;
        }
        this.bounds.x += n2;
        this.bounds.y += n3;
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            this.rectangles[i2].x += n2;
            this.rectangles[i2].y += n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean open() {
        Point point;
        int n2;
        NSObject nSObject;
        this.checkWidget();
        Display display = this.display;
        this.cancelled = false;
        this.tracking = true;
        this.window = (NSWindow)new NSWindow().alloc();
        NSArray nSArray = NSScreen.screens();
        double d2 = 3.4028234663852886E38;
        double d3 = 1.4E-45f;
        double d4 = 3.4028234663852886E38;
        double d5 = 1.4E-45f;
        int n3 = (int)nSArray.count();
        for (int i2 = 0; i2 < n3; ++i2) {
            nSObject = new NSScreen(nSArray.objectAtIndex(i2));
            NSRect nSRect = ((NSScreen)nSObject).frame();
            double d6 = nSRect.x;
            double d7 = nSRect.x + nSRect.width;
            double d8 = nSRect.y;
            double d9 = nSRect.y + nSRect.height;
            if (d6 < d2) {
                d2 = d6;
            }
            if (d7 < d2) {
                d2 = d7;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if (d7 > d3) {
                d3 = d7;
            }
            if (d8 < d4) {
                d4 = d8;
            }
            if (d9 < d4) {
                d4 = d9;
            }
            if (d8 > d5) {
                d5 = d8;
            }
            if (!(d9 > d5)) continue;
            d5 = d9;
        }
        NSRect nSRect = new NSRect();
        nSRect.x = d2;
        nSRect.y = d4;
        nSRect.width = d3 - d2;
        nSRect.height = d5 - d4;
        this.window = this.window.initWithContentRect(nSRect, 0L, 2L, false);
        this.window.setOpaque(false);
        this.window.setLevel(25L);
        this.window.setContentView(null);
        this.window.setBackgroundColor(NSColor.clearColor());
        nSObject = this.window.graphicsContext();
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext((NSGraphicsContext)nSObject);
        ((NSGraphicsContext)nSObject).setCompositingOperation(0L);
        nSRect.y = 0.0;
        nSRect.x = 0.0;
        NSBezierPath.fillRect(nSRect);
        NSGraphicsContext.static_restoreGraphicsState();
        this.window.orderFrontRegardless();
        this.drawRectangles(this.window, this.rectangles, false);
        int n4 = this.style & 0x480;
        if (n4 == 128 || n4 == 1024) {
            this.cursorOrientation |= n4;
        }
        if ((n2 = this.style & 0x24000) == 16384 || n2 == 131072) {
            this.cursorOrientation |= n2;
        }
        boolean bl2 = false;
        NSApplication nSApplication = NSApplication.sharedApplication();
        NSEvent nSEvent = nSApplication.currentEvent();
        if (nSEvent != null) {
            switch ((int)nSEvent.type()) {
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 25: 
                case 27: {
                    bl2 = true;
                    break;
                }
            }
        }
        if ((point = bl2 ? display.getCursorLocation() : ((this.style & 0x10) != 0 ? this.adjustResizeCursor(true) : this.adjustMoveCursor())) != null) {
            this.oldX = point.x;
            this.oldY = point.y;
        }
        Control control = display.trackingControl;
        display.trackingControl = null;
        while (this.tracking && !this.cancelled) {
            Object var25_26;
            block34: {
                block33: {
                    display.addPool();
                    try {
                        if (this.parent != null && this.parent.isDisposed()) {
                            var25_26 = null;
                            display.removePool();
                            break;
                        }
                        display.runSkin();
                        display.runDeferredLayouts();
                        NSEvent nSEvent2 = nSApplication.nextEventMatchingMask(0L, NSDate.distantFuture(), OS.NSDefaultRunLoopMode, true);
                        if (nSEvent2 == null) {
                            break block33;
                        }
                        int n5 = (int)nSEvent2.type();
                        switch (n5) {
                            case 2: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 26: 
                            case 27: {
                                this.mouse(nSEvent2);
                                break;
                            }
                            case 10: 
                            case 11: 
                            case 12: {
                                this.key(nSEvent2);
                                break;
                            }
                        }
                        boolean bl3 = true;
                        switch (n5) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 25: 
                            case 26: 
                            case 27: {
                                bl3 = false;
                                break;
                            }
                        }
                        if (bl3) {
                            nSApplication.sendEvent(nSEvent2);
                        }
                        if (this.clientCursor != null && this.resizeCursor == null) {
                            display.lockCursor = false;
                            this.clientCursor.handle.set();
                            display.lockCursor = true;
                        }
                        display.runAsyncMessages(false);
                        break block34;
                    }
                    catch (Throwable throwable) {
                        var25_26 = null;
                        display.removePool();
                        throw throwable;
                    }
                }
                var25_26 = null;
                display.removePool();
                continue;
            }
            var25_26 = null;
            display.removePool();
        }
        if (this.resizeCursor != null) {
            this.resizeCursor.dispose();
        }
        this.resizeCursor = null;
        if (control != null && !control.isDisposed()) {
            display.trackingControl = control;
        }
        display.setCursor(display.findControl(true));
        if (!this.isDisposed()) {
            this.drawRectangles(this.window, this.rectangles, true);
        }
        if (this.window != null) {
            this.window.close();
        }
        this.tracking = false;
        this.window = null;
        if (this.cancelled) return false;
        return true;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    boolean resizeRectangles(int n2, int n3) {
        Rectangle rectangle;
        int n4;
        if (this.bounds == null) {
            return false;
        }
        boolean bl2 = false;
        if (n2 < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x4000;
            bl2 = true;
        }
        if (n2 > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x20000;
            bl2 = true;
        }
        if (n3 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x80;
            bl2 = true;
        }
        if (n3 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x400;
            bl2 = true;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n2 > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return bl2;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n2 -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    for (n4 = 0; n4 < this.proportions.length; ++n4) {
                        rectangle = this.proportions[n4];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n2) {
            if ((this.style & 0x4000) == 0) {
                return bl2;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n2 += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                for (n4 = 0; n4 < this.proportions.length; ++n4) {
                    rectangle = this.proportions[n4];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n3 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return bl2;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n3 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    for (n4 = 0; n4 < this.proportions.length; ++n4) {
                        rectangle = this.proportions[n4];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n3) {
            if ((this.style & 0x80) == 0) {
                return bl2;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n3 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                for (n4 = 0; n4 < this.proportions.length; ++n4) {
                    rectangle = this.proportions[n4];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n2;
            this.bounds.width -= n2;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n2;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n3;
            this.bounds.height -= n3;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n3;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            Rectangle rectangle2 = this.proportions[i2];
            rectangleArray[i2] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
        }
        this.rectangles = rectangleArray;
        return bl2;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.clientCursor = cursor;
        if (cursor != null) {
            this.display.lockCursor = false;
            if (this.inEvent) {
                cursor.handle.set();
            }
            this.display.lockCursor = true;
        }
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        int n2 = rectangleArray.length;
        this.rectangles = new Rectangle[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Rectangle rectangle = rectangleArray[i2];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[i2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl2) {
        this.checkWidget();
        this.stippled = bl2;
    }
}

