/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBox;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSToolbar;
import org.eclipse.swt.internal.cocoa.NSToolbarItem;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTBox;
import org.eclipse.swt.internal.cocoa.SWTButton;
import org.eclipse.swt.internal.cocoa.SWTButtonCell;
import org.eclipse.swt.internal.cocoa.SWTMenuItem;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    NSView view;
    NSButton button;
    NSToolbarItem nsItem;
    NSMenuItem nsMenuRep;
    NSString id;
    int width = 6;
    ToolBar parent;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    Control control;
    boolean selection;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;
    static final int DEFAULT_SEPARATOR_WIDTH = 6;
    static final int INSET = 3;
    static final int ARROW_WIDTH = 5;

    public ToolItem(ToolBar toolBar, int n2) {
        super(toolBar, ToolItem.checkStyle(n2));
        this.parent = toolBar;
        toolBar.createItem(this, toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n2, int n3) {
        super(toolBar, ToolItem.checkStyle(n2));
        this.parent = toolBar;
        toolBar.createItem(this, n3);
    }

    long accessibleHandle() {
        if (this.button != null && this.button.cell() != null) {
            return this.button.cell().id;
        }
        if (this.view != null) {
            return this.view.id;
        }
        return 0L;
    }

    long accessibilityActionNames(long l2, long l3) {
        long l4 = super.accessibilityActionNames(l2, l3);
        if (l2 == this.accessibleHandle()) {
            if ((this.style & 4) != 0) {
                NSArray nSArray = new NSArray(l4);
                NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() + 1L);
                nSMutableArray.addObjectsFromArray(nSArray);
                nSMutableArray.addObject(OS.NSAccessibilityShowMenuAction);
                l4 = nSMutableArray.id;
            }
        } else {
            l4 = super.accessibilityActionNames(l2, l3);
        }
        return l4;
    }

    long accessibilityAttributeNames(long l2, long l3) {
        long l4 = super.accessibilityAttributeNames(l2, l3);
        if (l2 == this.accessibleHandle()) {
            if ((this.style & 0x30) != 0) {
                NSArray nSArray = new NSArray(l4);
                NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() + 1L);
                nSMutableArray.addObjectsFromArray(nSArray);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                l4 = nSMutableArray.id;
            } else if ((this.style & 4) != 0) {
                NSArray nSArray = new NSArray(l4);
                NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() + 1L);
                nSMutableArray.addObjectsFromArray(nSArray);
                nSMutableArray.addObject(OS.NSAccessibilityChildrenAttribute);
                l4 = nSMutableArray.id;
            }
        } else {
            l4 = super.accessibilityAttributeNames(l2, l3);
        }
        return l4;
    }

    long accessibilityAttributeValue(long l2, long l3, long l4) {
        NSString nSString = new NSString(l4);
        if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute) || nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            NSString nSString2;
            NSString nSString3 = (this.style & 8) != 0 ? OS.NSAccessibilityButtonRole : ((this.style & 0x10) != 0 ? OS.NSAccessibilityRadioButtonRole : ((this.style & 0x20) != 0 ? OS.NSAccessibilityCheckBoxRole : (nSString2 = (this.style & 4) != 0 ? OS.NSAccessibilityMenuButtonRole : null)));
            if (nSString2 != null) {
                if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                    return nSString2.id;
                }
                long l5 = OS.NSAccessibilityRoleDescription(nSString2.id, 0L);
                return l5;
            }
        } else {
            if (nSString.isEqualToString(OS.NSAccessibilityTitleAttribute)) {
                String string;
                String string2 = string = this.text.length() > 0 ? this.text : this.toolTipText;
                if (string != null) {
                    return NSString.stringWith((String)string).id;
                }
                return NSString.string().id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityHelpAttribute)) {
                String string = this.toolTipText;
                if (string != null) {
                    return NSString.stringWith((String)string).id;
                }
                return NSString.string().id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityValueAttribute) && (this.style & 0x30) != 0) {
                NSNumber nSNumber = NSNumber.numberWithInt(this.selection ? 1 : 0);
                return nSNumber.id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
                NSNumber nSNumber = NSNumber.numberWithBool(this.getEnabled());
                return nSNumber.id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
                NSArray nSArray = NSArray.array();
                return nSArray.id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityParentAttribute)) {
                return this.parent.view.id;
            }
        }
        return super.accessibilityAttributeValue(l2, l3, l4);
    }

    boolean accessibilityIsIgnored(long l2, long l3) {
        if (l2 == this.accessibleHandle()) {
            return false;
        }
        return super.accessibilityIsIgnored(l2, l3);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return ToolItem.checkBits(n2, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    boolean handleKeyDown() {
        if ((this.style & 4) != 0) {
            NSRect nSRect = this.view.frame();
            Event event = new Event();
            event.detail = 4;
            event.x = (int)nSRect.x;
            event.y = (int)(nSRect.y + nSRect.height);
            this.sendSelectionEvent(13, event, false);
            return true;
        }
        return false;
    }

    Point computeSize() {
        this.checkWidget();
        int n2 = 0;
        int n3 = 0;
        if ((this.style & 2) != 0) {
            if ((this.parent.style & 0x100) != 0) {
                n2 = this.getWidth();
                if (n2 <= 0) {
                    n2 = 6;
                }
                n3 = 22;
            } else {
                n2 = 24;
                n3 = this.getWidth();
                if (n3 <= 0) {
                    n3 = 6;
                }
            }
            if (this.control != null) {
                n3 = Math.max(n3, this.control.getMininumHeight());
            }
        } else {
            if (this.text.length() != 0 || this.image != null) {
                NSSize nSSize = this.button.cell().cellSize();
                n2 = (int)Math.ceil(nSSize.width);
                n3 = (int)Math.ceil(nSSize.height);
            } else {
                n2 = 24;
                n3 = 22;
            }
            if ((this.style & 4) != 0) {
                n2 += 8;
            }
            if (this.parent.nsToolbar == null || this.image != null) {
                n2 += 6;
                n3 += 6;
            } else {
                n3 -= 2;
            }
        }
        return new Point(n2, n3);
    }

    void createHandle() {
        if (this.parent.nsToolbar != null) {
            this.id = NSString.stringWith(String.valueOf(ToolBar.NEXT_ID++));
            this.id.retain();
            this.nsItem = ((NSToolbarItem)new NSToolbarItem().alloc()).initWithItemIdentifier(this.id);
            this.nsItem.setAction(OS.sel_sendSelection);
            this.nsMenuRep = ((NSMenuItem)new SWTMenuItem().alloc()).initWithTitle(NSString.string(), OS.sel_sendSelection, NSString.string());
            this.nsItem.setMenuFormRepresentation(this.nsMenuRep);
        }
        if ((this.style & 2) != 0) {
            if (this.parent.nsToolbar != null) {
                this.view = (NSView)new SWTView().alloc();
                this.view.init();
            } else {
                NSBox nSBox = (NSBox)new SWTBox().alloc();
                nSBox.init();
                nSBox.setBoxType(2L);
                nSBox.setBorderWidth(0.0);
                this.view = nSBox;
            }
        } else {
            NSView nSView = (NSView)new SWTView().alloc();
            nSView.init();
            this.button = (NSButton)new SWTButton().alloc();
            this.button.init();
            NSButtonCell nSButtonCell = (NSButtonCell)new SWTButtonCell().alloc().init();
            this.button.setCell(nSButtonCell);
            nSButtonCell.release();
            nSButtonCell.setHighlightsBy(1L);
            nSButtonCell.setBackgroundStyle(2L);
            this.button.setBordered(false);
            this.button.setAction(OS.sel_sendSelection);
            this.button.setTarget(this.button);
            if (this.nsMenuRep != null) {
                this.nsMenuRep.setTarget(this.button);
            }
            Font font = this.parent.font != null ? this.parent.font : this.parent.defaultFont();
            this.button.setFont(font.handle);
            this.button.setImagePosition(6L);
            this.button.setTitle(NSString.string());
            this.button.setEnabled(this.parent.getEnabled());
            nSView.addSubview(this.button);
            this.view = nSView;
        }
    }

    NSAttributedString createString() {
        NSAttributedString nSAttributedString = this.parent.createString(this.text, null, this.parent.foreground, 0x1000000, false, true, true);
        nSAttributedString.autorelease();
        return nSAttributedString;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
        if (this.button != null) {
            this.display.removeWidget(this.button);
            this.display.removeWidget(this.button.cell());
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    void drawImageWithFrameInView(long l2, long l3, long l4, NSRect nSRect, long l5) {
        boolean bl2;
        if (this.text.length() > 0) {
            if ((this.parent.style & 0x20000) != 0) {
                nSRect.x += 3.0;
            } else {
                nSRect.y += 3.0;
            }
        }
        long l6 = NSGraphicsContext.currentContext().graphicsPort();
        NSCell nSCell = new NSCell(l2);
        boolean bl3 = bl2 = this.parent.nsToolbar != null && this.getSelection() && (this.style & 0x20) != 0 && !nSCell.isHighlighted();
        if (bl2) {
            NSGraphicsContext.currentContext().saveGraphicsState();
            CGRect cGRect = new CGRect();
            cGRect.origin.x = nSRect.x;
            cGRect.origin.y = nSRect.y;
            cGRect.size.width = nSRect.width;
            cGRect.size.height = nSRect.height;
            OS.CGContextBeginTransparencyLayerWithRect(l6, cGRect, 0L);
        }
        super.drawImageWithFrameInView(l2, l3, l4, nSRect, l5);
        if (bl2) {
            NSColor.colorWithDeviceRed(0.0, 0.0, 0.0, 0.3f).setFill();
            OS.NSRectFillUsingOperation(nSRect, 5L);
            OS.CGContextEndTransparencyLayer(l6);
            NSGraphicsContext.currentContext().restoreGraphicsState();
        }
    }

    NSRect drawTitleWithFrameInView(long l2, long l3, long l4, NSRect nSRect, long l5) {
        boolean bl2;
        boolean bl3 = bl2 = new NSButtonCell(l2).isHighlighted() && this.text.length() > 0 && this.image == null;
        if (bl2) {
            NSColor nSColor = NSColor.colorWithDeviceRed(1.0, 1.0, 1.0, 0.8f);
            NSAttributedString nSAttributedString = new NSAttributedString(l4);
            NSMutableAttributedString nSMutableAttributedString = new NSMutableAttributedString(nSAttributedString.mutableCopy());
            NSRange nSRange = new NSRange();
            nSRange.location = 0L;
            nSRange.length = nSAttributedString.length();
            nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, nSColor, nSRange);
            nSMutableAttributedString.autorelease();
            l4 = nSMutableAttributedString.id;
        }
        return super.drawTitleWithFrameInView(l2, l3, l4, nSRect, l5);
    }

    void drawWidget(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l2 == this.view.id) {
            NSRect nSRect2;
            boolean bl2;
            boolean bl3 = bl2 = this.getSelection() && this.parent.nsToolbar == null;
            if (bl2) {
                nSRect2 = this.view.bounds();
                nSGraphicsContext.saveGraphicsState();
                NSColor.colorWithDeviceRed(0.1f, 0.1f, 0.1f, 0.1f).setFill();
                NSColor.colorWithDeviceRed(0.2f, 0.2f, 0.2f, 0.2f).setStroke();
                NSBezierPath.fillRect(nSRect2);
                nSRect2.x += 0.5;
                nSRect2.y += 0.5;
                nSRect2.width -= 1.0;
                nSRect2.height -= 1.0;
                NSBezierPath.strokeRect(nSRect2);
                nSGraphicsContext.restoreGraphicsState();
            }
            if ((this.style & 4) != 0) {
                nSRect2 = this.view.bounds();
                nSGraphicsContext.saveGraphicsState();
                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                NSPoint nSPoint = new NSPoint();
                nSBezierPath.moveToPoint(nSPoint);
                nSPoint.x += 5.0;
                nSBezierPath.lineToPoint(nSPoint);
                nSPoint.y += 4.0;
                nSPoint.x -= 2.5;
                nSBezierPath.lineToPoint(nSPoint);
                nSBezierPath.closePath();
                NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
                nSAffineTransform.translateXBy((int)nSRect2.width - 5 - 3, (int)(nSRect2.height - 2.0) / 2);
                nSAffineTransform.concat();
                NSColor nSColor = this.isEnabled() ? NSColor.blackColor() : NSColor.disabledControlTextColor();
                nSColor.set();
                nSBezierPath.fill();
                nSGraphicsContext.restoreGraphicsState();
            }
        }
    }

    void enableWidget(boolean bl2) {
        if (this.parent.nsToolbar != null) {
            this.nsItem.setEnabled(bl2);
        }
        if ((this.style & 2) == 0) {
            this.button.setEnabled(bl2);
            this.updateImage(true);
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.parent.nsToolbar != null) {
            NSRect nSRect = this.view.frame();
            nSRect = this.parent.view.convertRect_fromView_(nSRect, this.view);
            return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
        }
        NSRect nSRect = this.view.frame();
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    void setClipRegion(NSView nSView) {
        this.parent.setClipRegion(nSView);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    boolean getDrawing() {
        return this.parent.getDrawing();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    NSString getItemID() {
        NSString nSString = this.id;
        if ((this.style & 2) != 0 && this.control == null) {
            if (this.width == 6 || this.width == 0) {
                if (OS.VERSION < 4208) {
                    nSString = OS.NSToolbarSeparatorItemIdentifier;
                }
            } else if (this.width == -1) {
                nSString = OS.NSToolbarSpaceItemIdentifier;
            } else if (this.width == -2) {
                nSString = OS.NSToolbarFlexibleSpaceItemIdentifier;
            }
        }
        return nSString;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.selection;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    long menuForEvent(long l2, long l3, long l4) {
        return this.parent.menuForEvent(l2, l3, l4);
    }

    void mouseDown(long l2, long l3, long l4) {
        if (!this.parent.mouseEvent(this.parent.view.id, l3, l4, 3)) {
            return;
        }
        Display display = this.display;
        display.trackingControl = this.parent;
        super.mouseDown(l2, l3, l4);
        display.trackingControl = null;
        if ((this.style & 4) != 0 && l2 == this.view.id) {
            NSRect nSRect = this.view.frame();
            Event event = new Event();
            event.detail = 4;
            event.x = (int)nSRect.x;
            event.y = (int)(nSRect.y + nSRect.height);
            this.sendSelectionEvent(13, event, false);
        }
    }

    boolean mouseDownCanMoveWindow(long l2, long l3) {
        if (l2 == this.view.id) {
            return false;
        }
        return super.mouseDownCanMoveWindow(l2, l3);
    }

    void mouseUp(long l2, long l3, long l4) {
        if (!this.parent.mouseEvent(this.parent.view.id, l3, l4, 4)) {
            return;
        }
        super.mouseUp(l2, l3, l4);
    }

    void mouseDragged(long l2, long l3, long l4) {
        if (!this.parent.mouseEvent(this.parent.view.id, l3, l4, 5)) {
            return;
        }
        super.mouseDragged(l2, l3, l4);
    }

    void rightMouseDown(long l2, long l3, long l4) {
        if (!this.parent.mouseEvent(this.parent.view.id, l3, l4, 3)) {
            return;
        }
        super.rightMouseDown(l2, l3, l4);
    }

    void rightMouseUp(long l2, long l3, long l4) {
        if (!this.parent.mouseEvent(this.parent.view.id, l3, l4, 4)) {
            return;
        }
        super.rightMouseUp(l2, l3, l4);
    }

    void rightMouseDragged(long l2, long l3, long l4) {
        if (!this.parent.mouseEvent(this.parent.view.id, l3, l4, 5)) {
            return;
        }
        super.rightMouseDragged(l2, l3, l4);
    }

    void otherMouseDown(long l2, long l3, long l4) {
        if (!this.parent.mouseEvent(this.parent.view.id, l3, l4, 3)) {
            return;
        }
        super.otherMouseDown(l2, l3, l4);
    }

    void otherMouseUp(long l2, long l3, long l4) {
        if (!this.parent.mouseEvent(this.parent.view.id, l3, l4, 4)) {
            return;
        }
        super.otherMouseUp(l2, l3, l4);
    }

    void otherMouseDragged(long l2, long l3, long l4) {
        if (!this.parent.mouseEvent(this.parent.view.id, l3, l4, 5)) {
            return;
        }
        super.otherMouseDragged(l2, l3, l4);
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
        if (this.button != null) {
            this.display.addWidget(this.button, this);
            this.display.addWidget(this.button.cell(), this);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void releaseParent() {
        super.releaseParent();
        this.setVisible(false);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        if (this.button != null) {
            this.button.release();
        }
        this.button = null;
        this.view = null;
        if (this.nsItem != null) {
            this.nsItem.release();
            this.nsItem = null;
        }
        if (this.id != null) {
            this.id.release();
            this.id = null;
        }
        if (this.nsMenuRep != null) {
            this.nsMenuRep.release();
            this.nsMenuRep = null;
        }
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    void selectRadio() {
        ToolItem[] toolItemArray = this.parent.getItems();
        for (int i2 = 0; i2 < toolItemArray.length && toolItemArray[i2] != this; ++i2) {
        }
        for (int i3 = i2 - 1; i3 >= 0 && toolItemArray[i3].setRadioSelection(false); --i3) {
        }
        for (int i4 = i2 + 1; i4 < toolItemArray.length && toolItemArray[i4].setRadioSelection(false); ++i4) {
        }
        this.setSelection(true);
    }

    void sendSelection() {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        }
        this.sendSelectionEvent(13);
    }

    void setBounds(int n2, int n3, int n4, int n5) {
        NSRect nSRect = new NSRect();
        if (this.parent.nsToolbar == null) {
            nSRect.x = n2;
            nSRect.y = n3;
            nSRect.width = n4;
            nSRect.height = n5;
            this.view.setFrame(nSRect);
            if (this.button != null) {
                nSRect.x = 0.0;
                nSRect.y = 0.0;
                nSRect.width = n4;
                nSRect.height = n5;
                if ((this.style & 4) != 0) {
                    nSRect.width -= 8.0;
                }
                this.button.setFrame(nSRect);
            }
        } else {
            NSSize nSSize = new NSSize();
            nSSize.height = n5;
            nSSize.width = n4;
            this.nsItem.setView(null);
            this.view.setFrameSize(nSSize);
            if ((this.style & 4) != 0) {
                nSSize.width -= 8.0;
            }
            if (this.button != null) {
                this.button.setFrameSize(nSSize);
            }
            if ((this.style & 4) != 0) {
                nSSize.width += 8.0;
            }
            this.nsItem.setMinSize(nSSize);
            this.nsItem.setMaxSize(nSSize);
            this.nsItem.setView(this.view);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        if (this.parent.nsToolbar == null) {
            NSBox nSBox = (NSBox)this.view;
            if (control == null) {
                nSBox.setBoxType(2L);
            } else {
                nSBox.setBoxType(4L);
            }
        } else {
            this.nsItem.setMenuFormRepresentation(control == null ? this.nsMenuRep : NSMenuItem.separatorItem());
        }
        this.control = control;
        this.view.setHidden(control != null);
        if (control != null && !control.isDisposed()) {
            control.moveAbove(null);
        }
        this.parent.relayout();
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        if ((this.state & 8) == 0 && bl2) {
            return;
        }
        this.state = bl2 ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(bl2);
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        this.updateImage(true);
    }

    boolean setFocus() {
        if (this.button == null) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        NSWindow nSWindow = this.view.window();
        if (nSWindow == null) {
            return false;
        }
        return nSWindow.makeFirstResponder(this.button);
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        this.updateImage(true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.updateImage(true);
    }

    boolean setRadioSelection(boolean bl2) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl2) {
            this.setSelection(bl2);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl2) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.selection = bl2;
        if (this.parent.nsToolbar != null && (this.style & 0x10) != 0 && this.selection) {
            this.parent.nsToolbar.setSelectedItemIdentifier(this.nsItem.itemIdentifier());
        }
        this.view.setNeedsDisplay(true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.getText())) {
            return;
        }
        super.setText(string);
        NSButton nSButton = this.button;
        if (this.parent.nsToolbar != null) {
            char[] cArray = new char[this.text.length()];
            this.text.getChars(0, cArray.length, cArray, 0);
            int n2 = this.fixMnemonic(cArray);
            this.nsMenuRep.setTitle(NSString.stringWithCharacters(cArray, n2));
        }
        nSButton.setAttributedTitle(this.createString());
        if (this.text.length() != 0 && this.image != null) {
            if ((this.parent.style & 0x20000) != 0) {
                nSButton.setImagePosition(2L);
            } else {
                nSButton.setImagePosition(5L);
            }
        } else {
            nSButton.setImagePosition(this.text.length() != 0 ? 0L : 1L);
        }
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string == null && this.toolTipText == null) {
            return;
        }
        if (string != null && string.equals(this.toolTipText)) {
            return;
        }
        this.toolTipText = string;
        if (this.parent.nsToolbar != null) {
            char[] cArray = new char[this.toolTipText.length()];
            string.getChars(0, cArray.length, cArray, 0);
            int n2 = this.fixMnemonic(cArray);
            this.nsItem.setToolTip(NSString.stringWithCharacters(cArray, n2));
        } else {
            this.parent.checkToolTip(this);
        }
    }

    void setVisible(boolean bl2) {
        if (bl2) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        this.view.setHidden(!bl2);
    }

    public void setWidth(int n2) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n2 < -2 || this.width == n2) {
            return;
        }
        this.width = n2;
        if (this.parent.nsToolbar != null) {
            NSToolbar nSToolbar = this.parent.nsToolbar;
            int n3 = this.parent.indexOf(this);
            nSToolbar.removeItemAtIndex(n3);
            nSToolbar.insertItemWithItemIdentifier(this.getItemID(), n3);
        }
        this.parent.relayout();
    }

    String tooltipText() {
        return this.toolTipText;
    }

    void updateImage(boolean bl2) {
        if ((this.style & 2) != 0) {
            return;
        }
        Image image = null;
        image = (this.state & 8) == 8 && this.disabledImage != null ? this.disabledImage : ((this.state & 0x20) == 32 && this.hotImage != null ? this.hotImage : this.image);
        NSButton nSButton = this.button;
        nSButton.setImage(image != null ? image.handle : null);
        nSButton.setNeedsDisplay(true);
        if (this.text.length() != 0 && image != null) {
            if ((this.parent.style & 0x20000) != 0) {
                nSButton.setImagePosition(2L);
            } else {
                nSButton.setImagePosition(5L);
            }
        } else {
            nSButton.setImagePosition(this.text.length() != 0 ? 0L : 1L);
        }
        this.parent.relayout();
    }

    boolean validateMenuItem(long l2, long l3, long l4) {
        return this.isEnabled();
    }
}

