/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSToolbar;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTToolbar;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    int itemCount;
    ToolItem[] items;
    NSToolbar nsToolbar;
    NSArray accessibilityAttributes = null;
    ToolItem lastFocus;
    static int NEXT_ID;

    public ToolBar(Composite composite, int n2) {
        this(composite, n2, false);
    }

    ToolBar(Composite composite, int n2, boolean bl2) {
        super(composite, ToolBar.checkStyle(composite, n2, bl2));
        this.style = (n2 & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    long accessibilityAttributeValue(long l2, long l3, long l4) {
        id id2;
        NSString nSString = new NSString(l4);
        if (l2 == this.accessibleHandle() && this.accessible != null && (id2 = this.accessible.internal_accessibilityAttributeValue(nSString, -1)) != null) {
            return id2.id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute) || nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            id2 = OS.NSAccessibilityToolbarRole;
            if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                return ((NSString)id2).id;
            }
            long l5 = OS.NSAccessibilityRoleDescription(((NSString)id2).id, 0L);
            return l5;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
            id2 = NSMutableArray.arrayWithCapacity(this.itemCount);
            for (int i2 = 0; i2 < this.itemCount; ++i2) {
                ((NSMutableArray)id2).addObject(new id(this.getItem(i2).accessibleHandle()));
            }
            return ((NSMutableArray)id2).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return NSNumber.numberWithBool((boolean)this.isEnabled()).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityFocusedAttribute)) {
            boolean bl2 = this.view.id == this.view.window().firstResponder().id;
            return NSNumber.numberWithBool((boolean)bl2).id;
        }
        return super.accessibilityAttributeValue(l2, l3, l4);
    }

    boolean accessibilityIsIgnored(long l2, long l3) {
        if (l2 == this.view.id) {
            return false;
        }
        return super.accessibilityIsIgnored(l2, l3);
    }

    static int checkStyle(Composite composite, int n2, boolean bl2) {
        int n3 = n2 & 0xFFFFFCFF;
        if (!bl2 && (n3 & 0x10000) != 0) {
            n3 &= 0xFFFEFFFF;
        }
        if ((n2 & 0x10000) != 0) {
            if (composite instanceof Shell) {
                Shell shell = (Shell)composite;
                if (shell.window.toolbar() != null) {
                    n3 &= 0xFFFEFFFF;
                }
            } else {
                n3 &= 0xFFFEFFFF;
            }
        }
        if ((n3 & 0x10000) != 0) {
            n3 &= 0xFFFFFDBF;
            n3 |= 0x100;
        }
        return n3;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = n2;
        int n5 = n3;
        if (n2 == -1) {
            n4 = Integer.MAX_VALUE;
        }
        if (n3 == -1) {
            n5 = Integer.MAX_VALUE;
        }
        int[] nArray = this.layout(n4, n5, false);
        Point point = new Point(nArray[1], nArray[2]);
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        if (this.nsToolbar != null) {
            NSRect nSRect = this.view.frame();
            NSRect nSRect2 = new NSView(this.view.subviews().objectAtIndex(0L)).frame();
            n4 += (int)nSRect.width - (int)nSRect2.width;
        } else if (this.scrollView != null) {
            NSSize nSSize = new NSSize();
            nSSize.width = n4;
            nSSize.height = n5;
            nSSize = NSScrollView.frameSizeForContentSize(nSSize, false, false, 2L);
            n4 = (int)nSSize.width;
            n5 = (int)nSSize.height;
            NSRect nSRect = this.scrollView.contentView().frame();
            n2 = (int)((double)n2 - nSRect.x);
            n3 = (int)((double)n3 - nSRect.y);
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    void createHandle() {
        if ((this.style & 0x10000) != 0) {
            this.nsToolbar = ((NSToolbar)new SWTToolbar().alloc()).initWithIdentifier(NSString.stringWith(String.valueOf(NEXT_ID++)));
            this.nsToolbar.setDelegate(this.nsToolbar);
            this.nsToolbar.setDisplayMode(2L);
            NSWindow nSWindow = this.parent.view.window();
            nSWindow.setToolbar(this.nsToolbar);
            this.nsToolbar.setVisible(true);
            NSArray nSArray = nSWindow.contentView().superview().subviews();
            int n2 = 0;
            while ((long)n2 < nSArray.count()) {
                id id2 = nSArray.objectAtIndex(n2);
                if (new NSObject(id2).className().getString().equals("NSToolbarView")) {
                    this.view = new NSView(id2);
                    OS.object_setClass(this.view.id, OS.objc_getClass("SWTToolbarView"));
                    this.view.retain();
                    break;
                }
                ++n2;
            }
            this.style &= 0xFFFEFFFF;
        } else {
            Object object;
            this.state |= 0x800;
            if (this.hasBorder()) {
                object = new NSRect();
                NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
                nSScrollView.initWithFrame((NSRect)object);
                nSScrollView.setDrawsBackground(false);
                nSScrollView.setBorderType(2L);
                this.scrollView = nSScrollView;
            }
            object = (NSView)new SWTView().alloc();
            ((NSObject)object).init();
            this.view = object;
            if (this.scrollView != null) {
                this.view.setAutoresizingMask(18L);
            }
        }
    }

    void createItem(ToolItem toolItem, int n2) {
        if (0 > n2 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] toolItemArray = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, toolItemArray, 0, this.items.length);
            this.items = toolItemArray;
        }
        toolItem.createWidget();
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount++ - n2);
        this.items[n2] = toolItem;
        if (this.nsToolbar != null) {
            this.nsToolbar.insertItemWithItemIdentifier(toolItem.getItemID(), n2);
        } else {
            this.view.addSubview(toolItem.view);
        }
        this.relayout();
    }

    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    NSFont defaultNSFont() {
        return NSFont.systemFontOfSize(11.0);
    }

    void deregister() {
        super.deregister();
        if (this.nsToolbar != null) {
            this.display.removeWidget(this.nsToolbar);
        }
    }

    void destroyItem(ToolItem toolItem) {
        int n2;
        for (n2 = 0; n2 < this.itemCount && this.items[n2] != toolItem; ++n2) {
        }
        if (n2 == this.itemCount) {
            return;
        }
        if (toolItem == this.lastFocus) {
            this.lastFocus = null;
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --this.itemCount - n2);
        this.items[this.itemCount] = null;
        if (this.nsToolbar != null) {
            this.nsToolbar.removeItemAtIndex(n2);
        } else {
            toolItem.view.removeFromSuperview();
        }
        this.relayout();
    }

    void drawBackground(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l2 != this.view.id) {
            return;
        }
        if (this.background != null) {
            this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
        }
    }

    void enableWidget(boolean bl2) {
        super.enableWidget(bl2);
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            ToolItem toolItem = this.items[i2];
            if (toolItem == null) continue;
            toolItem.enableWidget(bl2 && toolItem.getEnabled());
        }
    }

    Widget findTooltip(NSPoint nSPoint) {
        nSPoint = this.view.convertPoint_fromView_(nSPoint, null);
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            ToolItem toolItem = this.items[i2];
            if (!OS.NSPointInRect(nSPoint, toolItem.view.frame())) continue;
            return toolItem;
        }
        return super.findTooltip(nSPoint);
    }

    void setZOrder() {
        if (this.nsToolbar != null) {
            return;
        }
        super.setZOrder();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.nsToolbar != null) {
            NSRect nSRect = this.view.frame();
            nSRect = this.view.convertRect_toView_(nSRect, null);
            return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
        }
        return super.getBounds();
    }

    boolean forceFocus(NSView nSView) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i2 = 0; i2 < toolItemArray.length; ++i2) {
            ToolItem toolItem = toolItemArray[i2];
            if (!toolItem.setFocus()) continue;
            this.lastFocus = toolItem;
            return true;
        }
        return false;
    }

    public ToolItem getItem(int n2) {
        this.checkWidget();
        if (0 <= n2 && n2 < this.itemCount) {
            return this.items[n2];
        }
        this.error(6);
        return null;
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            Rectangle rectangle = this.items[i2].getBounds();
            if (!rectangle.contains(point)) continue;
            return this.items[i2];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] toolItemArray = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, toolItemArray, 0, this.itemCount);
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        return this.layout(rectangle.width, rectangle.height, false)[0];
    }

    boolean hasKeyboardFocus(long l2) {
        return this.hasFocus();
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        if (toolItem.isDisposed()) {
            this.error(5);
        }
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            if (this.items[i2] != toolItem) continue;
            return i2;
        }
        return -1;
    }

    int[] layoutHorizontal(int n2, int n3, boolean bl2) {
        Object object;
        int n4;
        int n5 = 0;
        int n6 = 2;
        int n7 = 0;
        int n8 = 0;
        int n9 = n7;
        int n10 = n8;
        int n11 = 0;
        int n12 = 1;
        boolean bl3 = (this.style & 0x40) != 0;
        int n13 = 0;
        Point[] pointArray = new Point[this.itemCount];
        for (n4 = 0; n4 < this.itemCount; ++n4) {
            pointArray[n4] = this.items[n4].computeSize();
            object = pointArray[n4];
            n13 = Math.max(n13, ((Point)object).y);
        }
        for (n4 = 0; n4 < this.itemCount; ++n4) {
            object = this.items[n4];
            Point point = pointArray[n4];
            if (bl3 && n4 != 0 && n9 + point.x > n2) {
                ++n12;
                n9 = n7;
                n10 += n6 + n13;
            }
            if (bl2) {
                ((ToolItem)object).setBounds(n9, n10, point.x, n13);
                boolean bl4 = n9 + point.x <= n2 && n10 + n13 <= n3;
                ((ToolItem)object).setVisible(bl4);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    control.setBounds(n9, n10, point.x, n13);
                }
            }
            n11 = Math.max(n11, n9 += n5 + point.x);
        }
        return new int[]{n12, n11, n10 + n13};
    }

    int[] layoutUnified(int n2, int n3, boolean bl2) {
        Object object;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Point[] pointArray = new Point[this.itemCount];
        NSRect[] nSRectArray = new NSRect[this.itemCount];
        NSArray nSArray = new NSView(this.view.subviews().objectAtIndex(0L)).subviews();
        for (n4 = 0; n4 < this.itemCount; ++n4) {
            pointArray[n4] = this.items[n4].computeSize();
            object = pointArray[n4];
            nSRectArray[n4] = new NSView(nSArray.objectAtIndex(n4)).frame();
            if (n4 == 0) {
                n5 = (int)nSRectArray[0].x;
            }
            n7 = Math.max(n7, ((Point)object).y);
        }
        for (n4 = 0; n4 < this.itemCount; ++n4) {
            object = this.items[n4];
            Point point = pointArray[n4];
            if (bl2) {
                ((ToolItem)object).setBounds(0, 0, point.x, n7);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    control.setBounds(n5, n6, point.x, n7);
                }
            }
            n5 = (int)((double)n5 + nSRectArray[n4].width);
            n8 = Math.max(n8, n5);
        }
        return new int[]{1, n8, n7};
    }

    int[] layoutVertical(int n2, int n3, boolean bl2) {
        Object object;
        int n4;
        int n5 = 2;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n7;
        int n10 = n8;
        int n11 = 0;
        int n12 = 1;
        boolean bl3 = (this.style & 0x40) != 0;
        int n13 = 0;
        Point[] pointArray = new Point[this.itemCount];
        for (n4 = 0; n4 < this.itemCount; ++n4) {
            pointArray[n4] = this.items[n4].computeSize();
            object = pointArray[n4];
            n13 = Math.max(n13, ((Point)object).x);
        }
        for (n4 = 0; n4 < this.itemCount; ++n4) {
            object = this.items[n4];
            Point point = pointArray[n4];
            if (bl3 && n4 != 0 && n10 + point.y > n3) {
                ++n12;
                n9 += n5 + n13;
                n10 = n8;
            }
            if (bl2) {
                ((ToolItem)object).setBounds(n9, n10, n13, point.y);
                boolean bl4 = n9 + n13 <= n2 && n10 + point.y <= n3;
                ((ToolItem)object).setVisible(bl4);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    control.setBounds(n9, n10, n13, point.y);
                }
            }
            n11 = Math.max(n11, n10 += n6 + point.y);
        }
        return new int[]{n12, n9 + n13, n11};
    }

    int[] layout(int n2, int n3, boolean bl2) {
        if (this.nsToolbar != null) {
            return this.layoutUnified(n2, n3, bl2);
        }
        if ((this.style & 0x200) != 0) {
            return this.layoutVertical(n2, n3, bl2);
        }
        return this.layoutHorizontal(n2, n3, bl2);
    }

    void register() {
        super.register();
        if (this.nsToolbar != null) {
            this.display.addWidget(this.nsToolbar, this);
        }
    }

    void relayout() {
        if (!this.getDrawing()) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        this.layout(rectangle.width, rectangle.height, true);
    }

    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.itemCount; ++i2) {
                ToolItem toolItem = this.items[i2];
                if (toolItem == null || toolItem.isDisposed()) continue;
                toolItem.release(false);
            }
            this.itemCount = 0;
            this.items = null;
        }
        super.releaseChildren(bl2);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsToolbar != null) {
            this.nsToolbar.release();
            this.nsToolbar = null;
        }
        if (this.accessibilityAttributes != null) {
            this.accessibilityAttributes.release();
        }
        this.accessibilityAttributes = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            ToolItem toolItem = this.items[i2];
            if (toolItem.control != control) continue;
            toolItem.setControl(null);
        }
    }

    void resized() {
        super.resized();
        this.relayout();
    }

    void reskinChildren(int n2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                ToolItem toolItem = this.items[i2];
                if (toolItem == null) continue;
                toolItem.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    boolean sendMouseEvent(NSEvent nSEvent, int n2, boolean bl2) {
        switch (n2) {
            case 5: 
            case 6: {
                NSPoint nSPoint = NSEvent.mouseLocation();
                nSPoint = this.view.window().convertScreenToBase(nSPoint);
                for (int i2 = 0; i2 < this.itemCount; ++i2) {
                    ToolItem toolItem = this.items[i2];
                    int n3 = toolItem.state;
                    NSPoint nSPoint2 = toolItem.view.convertPoint_fromView_(nSPoint, null);
                    toolItem.state = toolItem.view.mouse(nSPoint2, toolItem.view.bounds()) ? (toolItem.state |= 0x20) : (toolItem.state &= 0xFFFFFFDF);
                    if (n3 == toolItem.state) continue;
                    toolItem.updateImage(true);
                }
                break;
            }
            case 7: {
                for (int i3 = 0; i3 < this.itemCount; ++i3) {
                    ToolItem toolItem = this.items[i3];
                    int n4 = toolItem.state;
                    toolItem.state &= 0xFFFFFFDF;
                    if (n4 == toolItem.state) continue;
                    toolItem.updateImage(true);
                }
                break;
            }
        }
        return super.sendMouseEvent(nSEvent, n2, bl2);
    }

    void setBounds(int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        if (this.nsToolbar != null) {
            return;
        }
        super.setBounds(n2, n3, n4, n5, bl2, bl3);
    }

    void setFont(NSFont nSFont) {
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            ToolItem toolItem = this.items[i2];
            if (toolItem.button == null) continue;
            toolItem.button.setAttributedTitle(toolItem.createString());
        }
    }

    public void setRedraw(boolean bl2) {
        this.checkWidget();
        super.setRedraw(bl2);
        if (bl2 && this.drawCount == 0) {
            this.relayout();
        }
    }

    public void setVisible(boolean bl2) {
        if (this.nsToolbar != null) {
            this.nsToolbar.setVisible(bl2);
        }
        super.setVisible(bl2);
    }

    long toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(long l2, long l3, long l4, long l5, boolean bl2) {
        NSString nSString = new NSString(l5);
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            ToolItem toolItem = this.items[i2];
            if (!nSString.isEqual(toolItem.nsItem.itemIdentifier())) continue;
            return toolItem.nsItem.id;
        }
        return 0L;
    }

    long toolbarAllowedItemIdentifiers(long l2, long l3, long l4) {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(this.itemCount);
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            nSMutableArray.addObject(this.items[i2].nsItem.itemIdentifier());
        }
        return nSMutableArray.id;
    }

    long toolbarDefaultItemIdentifiers(long l2, long l3, long l4) {
        return this.toolbarAllowedItemIdentifiers(l2, l3, l4);
    }

    long toolbarSelectableItemIdentifiers(long l2, long l3, long l4) {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(this.itemCount);
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            if ((this.items[i2].style & 0x10) == 0) continue;
            nSMutableArray.addObject(this.items[i2].nsItem.itemIdentifier());
        }
        return nSMutableArray.id;
    }

    boolean translateTraversal(int n2, NSEvent nSEvent, boolean[] blArray) {
        int n3;
        int n4;
        boolean bl2 = super.translateTraversal(n2, nSEvent, blArray);
        if (bl2) {
            return bl2;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        switch (n2) {
            case 123: {
                bl3 = false;
                break;
            }
            case 124: {
                bl3 = true;
                break;
            }
            case 126: {
                bl3 = false;
                bl4 = true;
                break;
            }
            case 125: {
                bl3 = true;
                bl4 = true;
                break;
            }
            default: {
                return false;
            }
        }
        blArray[0] = true;
        if (bl4 && this.lastFocus != null && this.lastFocus.handleKeyDown()) {
            return false;
        }
        ToolItem[] toolItemArray = this.getItems();
        ToolItem toolItem = this.lastFocus;
        int n5 = toolItemArray.length;
        for (n4 = 0; n4 < n5 && toolItemArray[n4] != toolItem; ++n4) {
        }
        if (n4 == n5) {
            return false;
        }
        int n6 = n4;
        int n7 = n3 = bl3 ? 1 : -1;
        while ((n4 = (n4 + n3 + n5) % n5) != n6) {
            ToolItem toolItem2 = toolItemArray[n4];
            if (toolItem2.isDisposed() || !toolItem2.setFocus()) continue;
            this.lastFocus = toolItem2;
            return false;
        }
        return false;
    }
}

