/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.Widget;

public class TaskBar
extends Widget {
    int itemCount;
    TaskItem[] items = new TaskItem[4];

    TaskBar(Display display, int n2) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
        this.reskinWidget();
    }

    void createItem(TaskItem taskItem, int n2) {
        if (n2 == -1) {
            n2 = this.itemCount;
        }
        if (0 > n2 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            TaskItem[] taskItemArray = new TaskItem[this.items.length + 4];
            System.arraycopy(this.items, 0, taskItemArray, 0, this.items.length);
            this.items = taskItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount++ - n2);
        this.items[n2] = taskItem;
    }

    void createItems() {
        this.getItem(null);
    }

    void destroyItem(TaskItem taskItem) {
        int n2;
        for (n2 = 0; n2 < this.itemCount && this.items[n2] != taskItem; ++n2) {
        }
        if (n2 == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --this.itemCount - n2);
        this.items[this.itemCount] = null;
    }

    public TaskItem getItem(int n2) {
        this.checkWidget();
        this.createItems();
        if (0 > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        return this.items[n2];
    }

    public int getItemCount() {
        this.checkWidget();
        this.createItems();
        return this.itemCount;
    }

    public TaskItem getItem(Shell shell) {
        this.checkWidget();
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            if (this.items[i2] == null || this.items[i2].shell != shell) continue;
            return this.items[i2];
        }
        TaskItem taskItem = null;
        if (shell == null) {
            taskItem = new TaskItem(this, 0);
        }
        return taskItem;
    }

    public TaskItem[] getItems() {
        this.checkWidget();
        this.createItems();
        TaskItem[] taskItemArray = new TaskItem[this.itemCount];
        System.arraycopy(this.items, 0, taskItemArray, 0, taskItemArray.length);
        return taskItemArray;
    }

    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                TaskItem taskItem = this.items[i2];
                if (taskItem == null || taskItem.isDisposed()) continue;
                taskItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl2);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.display.taskBar == this) {
            this.display.taskBar = null;
        }
    }

    void reskinChildren(int n2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                TaskItem taskItem = this.items[i2];
                if (taskItem == null) continue;
                taskItem.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }
}

