/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    Color foreground;
    Color background;
    Color[] cellForeground;
    Color[] cellBackground;
    Font font;
    Font[] cellFont;
    int width = -1;

    public TableItem(Table table, int n2) {
        this(table, n2, TableItem.checkNull(table).getItemCount(), true);
    }

    public TableItem(Table table, int n2, int n3) {
        this(table, n2, n3, true);
    }

    TableItem(Table table, int n2, int n3, boolean bl2) {
        super(table, n2);
        this.parent = table;
        if (bl2) {
            table.createItem(this, n3);
        }
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    int calculateWidth(int n2, GC gC, boolean bl2) {
        Object object;
        String string;
        if (n2 == 0 && this.width != -1) {
            return this.width;
        }
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[n2];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.font;
        }
        if (font == null) {
            font = this.parent.defaultFont();
        }
        String string2 = n2 == 0 ? this.text : (string = this.strings == null ? "" : this.strings[n2]);
        Image image = n2 == 0 ? this.image : (this.images == null ? null : this.images[n2]);
        NSTextFieldCell nSTextFieldCell = this.parent.dataCell;
        if (font.extraTraits != 0) {
            object = this.parent.createString(string, font, null, 0, false, true, false);
            nSTextFieldCell.setAttributedStringValue((NSAttributedString)object);
            ((NSObject)object).release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            object = (NSString)new NSString().alloc();
            object = ((NSString)object).initWithString(string != null ? string : "");
            nSTextFieldCell.setTitle((NSString)object);
            ((NSObject)object).release();
        }
        object = new objc_super();
        ((objc_super)object).receiver = nSTextFieldCell.id;
        ((objc_super)object).super_class = OS.objc_msgSend(nSTextFieldCell.id, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, (objc_super)object, OS.sel_cellSize);
        if (image != null) {
            nSSize.width += (double)(this.parent.imageBounds.width + 3);
        }
        int n3 = (int)Math.ceil(nSSize.width);
        boolean bl3 = true;
        if ((this.parent.style & 0x10000000) != 0) {
            bl3 = this.cached;
        }
        if (bl3 && this.parent.hooks(41)) {
            gC.setFont(font);
            Event event = new Event();
            event.item = this;
            event.index = n2;
            event.gc = gC;
            NSTableView nSTableView = (NSTableView)this.parent.view;
            int n4 = (int)nSTableView.rowHeight();
            event.width = n3;
            event.height = n4;
            if (bl2 && ((this.parent.style & 0x8000) == 0 || this.parent.hasFocus())) {
                event.detail |= 2;
            }
            this.parent.sendEvent(41, event);
            if (n4 < event.height) {
                nSTableView.setRowHeight(event.height);
                nSTableView.setNeedsDisplay(true);
            }
            n3 = event.width;
        }
        if (n2 == 0) {
            this.width = n3;
        }
        return n3;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.cached = false;
        this.grayed = false;
        this.checked = false;
        this.background = null;
        this.foreground = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.font = null;
        this.cellFont = null;
        this.width = -1;
    }

    NSObject createString(int n2) {
        String string = n2 == 0 ? this.text : (this.strings == null ? "" : this.strings[n2]);
        return NSString.stringWith(string != null ? string : "");
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[n2] == null) {
            return this.getBackground();
        }
        return this.cellBackground[n2];
    }

    public Rectangle getBounds() {
        Object object;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        NSTableView nSTableView = (NSTableView)this.parent.view;
        int n2 = this.parent.indexOf(this);
        NSTableColumn nSTableColumn = this.parent.columnCount == 0 ? this.parent.firstColumn : this.parent.columns[0].nsColumn;
        int n3 = this.parent.indexOf(nSTableColumn);
        NSRect nSRect = nSTableView.frameOfCellAtColumn(n3, n2);
        if (this.image != null) {
            nSRect.x += (double)(this.parent.imageBounds.width + 3);
        }
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[n3];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.font;
        }
        if (font == null) {
            font = this.parent.defaultFont();
        }
        NSTextFieldCell nSTextFieldCell = this.parent.dataCell;
        nSTextFieldCell.setImage(null);
        if (font.extraTraits != 0) {
            object = this.parent.createString(this.text, font, null, 0, false, true, false);
            nSTextFieldCell.setAttributedStringValue((NSAttributedString)object);
            ((NSObject)object).release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            object = (NSString)new NSString().alloc();
            object = ((NSString)object).initWithString(this.text);
            nSTextFieldCell.setTitle((NSString)object);
            ((NSObject)object).release();
        }
        object = new objc_super();
        ((objc_super)object).receiver = nSTextFieldCell.id;
        ((objc_super)object).super_class = OS.objc_msgSend(nSTextFieldCell.id, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, (objc_super)object, OS.sel_cellSize);
        NSRect nSRect2 = nSTableView.rectOfColumn(n3);
        nSSize.width = Math.min(nSSize.width, nSRect2.width - (nSRect.x - nSRect2.x));
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)Math.ceil(nSSize.width), (int)Math.ceil(nSRect.height));
    }

    public Rectangle getBounds(int n2) {
        Object object;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n2 || n2 >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        NSTableView nSTableView = (NSTableView)this.parent.view;
        if (this.parent.columnCount == 0) {
            n2 = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            object = this.parent.getColumn(n2);
            n2 = this.parent.indexOf(((TableColumn)object).nsColumn);
        }
        object = nSTableView.frameOfCellAtColumn(n2, this.parent.indexOf(this));
        return new Rectangle((int)((NSRect)object).x, (int)((NSRect)object).y, (int)((NSRect)object).width, (int)((NSRect)object).height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n2] == null) {
            return this.getFont();
        }
        return this.cellFont[n2];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[n2] == null) {
            return this.getForeground();
        }
        return this.cellForeground[n2];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n2 == 0) {
            return this.getImage();
        }
        if (this.images != null && 0 <= n2 && n2 < this.images.length) {
            return this.images[n2];
        }
        return null;
    }

    public Rectangle getImageBounds(int n2) {
        Object object;
        Image image;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n2 || n2 >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        NSTableView nSTableView = (NSTableView)this.parent.view;
        Image image2 = n2 == 0 ? this.image : (image = this.images != null ? this.images[n2] : null);
        if (this.parent.columnCount == 0) {
            n2 = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            object = this.parent.getColumn(n2);
            n2 = this.parent.indexOf(((TableColumn)object).nsColumn);
        }
        object = nSTableView.frameOfCellAtColumn(n2, this.parent.indexOf(this));
        ((NSRect)object).x += 3.0;
        ((NSRect)object).width = image != null ? (double)this.parent.imageBounds.width : 0.0;
        return new Rectangle((int)((NSRect)object).x, (int)((NSRect)object).y, (int)((NSRect)object).width, (int)((NSRect)object).height);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return 0;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n2 == 0) {
            return this.getText();
        }
        if (this.strings != null && 0 <= n2 && n2 < this.strings.length) {
            String string = this.strings[n2];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int n2) {
        Object object;
        Image image;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n2 || n2 >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        NSTableView nSTableView = (NSTableView)this.parent.view;
        Image image2 = n2 == 0 ? this.image : (image = this.images != null ? this.images[n2] : null);
        if (this.parent.columnCount == 0) {
            n2 = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            object = this.parent.getColumn(n2);
            n2 = this.parent.indexOf(((TableColumn)object).nsColumn);
        }
        object = nSTableView.frameOfCellAtColumn(n2, this.parent.indexOf(this));
        ((NSRect)object).x += 2.0;
        ((NSRect)object).width -= 2.0;
        if (image != null) {
            int n3 = this.parent.imageBounds.width + 3;
            ((NSRect)object).x += (double)n3;
            ((NSRect)object).width -= (double)n3;
        }
        return new Rectangle((int)((NSRect)object).x, (int)((NSRect)object).y, (int)((NSRect)object).width, (int)((NSRect)object).height);
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    void redraw(int n2) {
        if (this.parent.currentItem == this || !this.isDrawing()) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.parent.view;
        NSRect nSRect = null;
        if (n2 == -1 || this.parent.hooks(41) || this.parent.hooks(40) || this.parent.hooks(42)) {
            nSRect = nSTableView.rectOfRow(this.parent.indexOf(this));
        } else {
            int n3;
            if (this.parent.columnCount == 0) {
                n3 = (this.parent.style & 0x20) != 0 ? 1 : 0;
            } else if (0 <= n2 && n2 < this.parent.columnCount) {
                n3 = this.parent.indexOf(this.parent.columns[n2].nsColumn);
            } else {
                return;
            }
            nSRect = nSTableView.frameOfCellAtColumn(n3, this.parent.indexOf(this));
        }
        nSTableView.setNeedsDisplayInRect(nSRect);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void setBackground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if ((color2 = this.background) == color) {
            return;
        }
        this.background = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(-1);
    }

    public void setBackground(int n2, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        if (this.cellBackground == null) {
            if (color == null) {
                return;
            }
            this.cellBackground = new Color[n3];
        }
        if ((color2 = this.cellBackground[n2]) == color) {
            return;
        }
        this.cellBackground[n2] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(n2);
    }

    public void setChecked(boolean bl2) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == bl2) {
            return;
        }
        this.checked = bl2;
        this.cached = true;
        this.redraw(-1);
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.width = -1;
        this.cached = true;
        this.redraw(-1);
    }

    public void setFont(int n2, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[n3];
        }
        if ((font2 = this.cellFont[n2]) == font) {
            return;
        }
        this.cellFont[n2] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.width = -1;
        this.cached = true;
        this.redraw(n2);
    }

    public void setForeground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if ((color2 = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(-1);
    }

    public void setForeground(int n2, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        if (this.cellForeground == null) {
            if (color == null) {
                return;
            }
            this.cellForeground = new Color[n3];
        }
        if ((color2 = this.cellForeground[n2]) == color) {
            return;
        }
        this.cellForeground[n2] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(n2);
    }

    public void setGrayed(boolean bl2) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl2) {
            return;
        }
        this.grayed = bl2;
        this.cached = true;
        this.redraw(-1);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < imageArray.length; ++i2) {
            this.setImage(i2, imageArray[i2]);
        }
    }

    public void setImage(int n2, Image image) {
        int n3;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((n3 = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.parent.imageBounds == null && image != null) {
            this.parent.setItemHeight(image, null, false);
        }
        if (n2 == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            this.width = -1;
            super.setImage(image);
        }
        int n4 = Math.max(1, this.parent.columnCount);
        if (0 <= n2 && n2 < n4) {
            if (this.images == null) {
                this.images = new Image[n4];
            }
            if (image != null && image.type == 1 && image.equals(this.images[n2])) {
                return;
            }
            this.images[n2] = image;
        }
        this.cached = true;
        if (n2 == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(n2);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        this.cached = true;
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string == null) continue;
            this.setText(i2, string);
        }
    }

    public void setText(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n2 == 0) {
            if (string.equals(this.text)) {
                return;
            }
            this.width = -1;
            super.setText(string);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 <= n2 && n2 < n3) {
            if (this.strings == null) {
                this.strings = new String[n3];
            }
            if (string.equals(this.strings[n2])) {
                return;
            }
            this.strings[n2] = string;
        }
        this.cached = true;
        if (n2 == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(n2);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

