/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTImageTextCell;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderCell;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderView;
import org.eclipse.swt.internal.cocoa.SWTTableView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    TableColumn sortColumn;
    TableItem currentItem;
    NSTableHeaderView headerView;
    NSTableColumn firstColumn;
    NSTableColumn checkColumn;
    NSTextFieldCell dataCell;
    NSButtonCell buttonCell;
    int columnCount;
    int itemCount;
    int lastIndexOf;
    int sortDirection;
    int selectedRowIndex = -1;
    boolean ignoreSelect;
    boolean fixScrollWidth;
    boolean drawExpansion;
    boolean didSelect;
    boolean preventSelect;
    boolean dragDetected;
    Rectangle imageBounds;
    boolean shouldScroll = true;
    static int NEXT_ID;
    static final int FIRST_COLUMN_MINIMUM_WIDTH = 5;
    static final int IMAGE_GAP = 3;
    static final int TEXT_GAP = 2;
    static final int CELL_GAP = 1;

    public Table(Composite composite, int n2) {
        super(composite, Table.checkStyle(n2));
    }

    boolean acceptsFirstResponder(long l2, long l3) {
        return true;
    }

    long accessibilityAttributeValue(long l2, long l3, long l4) {
        long l5;
        long l6 = 0L;
        NSString nSString = new NSString(l4);
        if ((nSString.isEqualToString(OS.NSAccessibilityColumnsAttribute) || nSString.isEqualToString(OS.NSAccessibilityVisibleColumnsAttribute)) && (this.style & 0x20) != 0 && (l5 = super.accessibilityAttributeValue(l2, l3, l4)) != 0L) {
            NSArray nSArray = new NSArray(l5);
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() - 1L);
            nSMutableArray.addObjectsFromArray(nSArray);
            nSMutableArray.removeObjectAtIndex(0L);
            l6 = nSMutableArray.id;
        }
        if (l6 != 0L) {
            return l6;
        }
        return super.accessibilityAttributeValue(l2, l3, l4);
    }

    void _addListener(int n2, Listener listener) {
        super._addListener(n2, listener);
        this.clearCachedWidth(this.items);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    TableItem _getItem(int n2) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n2];
        }
        if (this.items[n2] != null) {
            return this.items[n2];
        }
        this.items[n2] = new TableItem(this, 0, -1, false);
        return this.items[n2];
    }

    int calculateWidth(TableItem[] tableItemArray, int n2, GC gC) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            TableItem tableItem = tableItemArray[i2];
            if (tableItem == null || !tableItem.cached) continue;
            n3 = Math.max(n3, tableItem.calculateWidth(n2, gC, this.isSelected(n2)));
        }
        return n3;
    }

    NSSize cellSize(long l2, long l3) {
        NSSize nSSize = super.cellSize(l2, l3);
        NSCell nSCell = new NSCell(l2);
        NSImage nSImage = nSCell.image();
        if (nSImage != null) {
            nSSize.width += (double)(this.imageBounds.width + 3);
        }
        if (this.hooks(41)) {
            long[] lArray = new long[1];
            OS.object_getInstanceVariable(l2, Display.SWT_ROW, lArray);
            long l4 = lArray[0];
            TableItem tableItem = this._getItem((int)l4);
            OS.object_getInstanceVariable(l2, Display.SWT_COLUMN, lArray);
            long l5 = lArray[0];
            int n2 = 0;
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                if (this.columns[i2].nsColumn.id != l5) continue;
                n2 = i2;
                break;
            }
            this.sendMeasureItem(tableItem, n2, nSSize, nSCell.isHighlighted());
        }
        return nSSize;
    }

    boolean canDragRowsWithIndexes_atPoint(long l2, long l3, long l4, NSPoint nSPoint) {
        boolean bl2;
        if (!super.canDragRowsWithIndexes_atPoint(l2, l3, l4, nSPoint)) {
            return false;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        long l5 = nSTableView.rowAtPoint(nSPoint);
        long l6 = NSApplication.sharedApplication().currentEvent().modifierFlags();
        boolean bl3 = bl2 = (this.state & 0x40000) != 0 && this.hooks(29);
        if (bl2 && !nSTableView.isRowSelected(l5) && (l6 & 0x1A0000L) == 0L) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(l5);
            nSTableView.selectRowIndexes(nSIndexSet, false);
            nSIndexSet.release();
        }
        return nSTableView.isRowSelected(l5) && bl2 || !this.hasFocus();
    }

    boolean checkData(TableItem tableItem) {
        return this.checkData(tableItem, this.indexOf(tableItem));
    }

    boolean checkData(TableItem tableItem, int n2) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = this.indexOf(tableItem);
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || tableItem.isDisposed()) {
                return false;
            }
            if (!this.setScrollWidth(tableItem)) {
                tableItem.redraw(-1);
            }
        }
        return true;
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x10) == 0) {
            n2 |= 0x300;
        }
        return Table.checkBits(n2 |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n2) {
        TableItem tableItem;
        this.checkWidget();
        if (0 > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n2]) != null) {
            if (this.currentItem != tableItem) {
                tableItem.clear();
            }
            if (this.currentItem == null) {
                tableItem.redraw(-1);
            }
            this.setScrollWidth(tableItem);
        }
    }

    public void clear(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        if (0 > n2 || n2 > n3 || n3 >= this.itemCount) {
            this.error(6);
        }
        if (n2 == 0 && n3 == this.itemCount - 1) {
            this.clearAll();
        } else {
            for (int i2 = n2; i2 <= n3; ++i2) {
                this.clear(i2);
            }
        }
    }

    public void clear(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (0 <= nArray[n2] && nArray[n2] < this.itemCount) continue;
            this.error(6);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.clear(nArray[n2]);
        }
    }

    public void clearAll() {
        this.checkWidget();
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            TableItem tableItem = this.items[i2];
            if (tableItem == null) continue;
            tableItem.clear();
        }
        if (this.currentItem == null && this.isDrawing()) {
            this.view.setNeedsDisplay(true);
        }
        this.setScrollWidth(this.items, true);
    }

    void clearCachedWidth(TableItem[] tableItemArray) {
        if (tableItemArray == null) {
            return;
        }
        for (int i2 = 0; i2 < tableItemArray.length; ++i2) {
            if (tableItemArray[i2] == null) continue;
            tableItemArray[i2].width = -1;
        }
    }

    long columnAtPoint(long l2, long l3, NSPoint nSPoint) {
        if ((this.style & 0x20) != 0 && nSPoint.x <= (double)this.getCheckColumnWidth() && nSPoint.y < this.headerView.frame().height) {
            return 1L;
        }
        return super.columnAtPoint(l2, l3, nSPoint);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        int n4;
        this.checkWidget();
        int n5 = 0;
        if (n2 == -1) {
            if (this.columnCount != 0) {
                for (n4 = 0; n4 < this.columnCount; ++n4) {
                    n5 += this.columns[n4].getWidth();
                }
            } else {
                GC gC = new GC(this);
                n5 += this.calculateWidth(this.items, 0, gC) + 1;
                gC.dispose();
            }
            if ((this.style & 0x20) != 0) {
                n5 += this.getCheckColumnWidth();
            }
        } else {
            n5 = n2;
        }
        if (n5 <= 0) {
            n5 = 64;
        }
        n4 = 0;
        n4 = n3 == -1 ? this.itemCount * this.getItemHeight() + this.getHeaderHeight() : n3;
        if (n4 <= 0) {
            n4 = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n5, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    void createColumn(TableItem tableItem, int n2) {
        Resource[] resourceArray;
        Color[] colorArray;
        Resource[] resourceArray2;
        Object[] objectArray;
        String[] stringArray = tableItem.strings;
        if (stringArray != null) {
            objectArray = new String[this.columnCount];
            System.arraycopy(stringArray, 0, objectArray, 0, n2);
            System.arraycopy(stringArray, n2, objectArray, n2 + 1, this.columnCount - n2 - 1);
            objectArray[n2] = "";
            tableItem.strings = objectArray;
        }
        if (n2 == 0) {
            tableItem.text = "";
        }
        if ((objectArray = tableItem.images) != null) {
            resourceArray2 = new Image[this.columnCount];
            System.arraycopy(objectArray, 0, resourceArray2, 0, n2);
            System.arraycopy(objectArray, n2, resourceArray2, n2 + 1, this.columnCount - n2 - 1);
            tableItem.images = resourceArray2;
        }
        if (n2 == 0) {
            tableItem.image = null;
        }
        if ((resourceArray2 = tableItem.cellBackground) != null) {
            colorArray = new Color[this.columnCount];
            System.arraycopy(resourceArray2, 0, colorArray, 0, n2);
            System.arraycopy(resourceArray2, n2, colorArray, n2 + 1, this.columnCount - n2 - 1);
            tableItem.cellBackground = colorArray;
        }
        if ((colorArray = tableItem.cellForeground) != null) {
            resourceArray = new Color[this.columnCount];
            System.arraycopy(colorArray, 0, resourceArray, 0, n2);
            System.arraycopy(colorArray, n2, resourceArray, n2 + 1, this.columnCount - n2 - 1);
            tableItem.cellForeground = resourceArray;
        }
        if ((resourceArray = tableItem.cellFont) != null) {
            Font[] fontArray = new Font[this.columnCount];
            System.arraycopy(resourceArray, 0, fontArray, 0, n2);
            System.arraycopy(resourceArray, n2, fontArray, n2 + 1, this.columnCount - n2 - 1);
            tableItem.cellFont = fontArray;
        }
    }

    void createHandle() {
        NSString nSString;
        NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
        nSScrollView.init();
        nSScrollView.setHasHorizontalScroller((this.style & 0x100) != 0);
        nSScrollView.setHasVerticalScroller((this.style & 0x200) != 0);
        nSScrollView.setAutohidesScrollers(true);
        nSScrollView.setBorderType(this.hasBorder() ? 2L : 0L);
        NSTableView nSTableView = (NSTableView)new SWTTableView().alloc();
        nSTableView.init();
        nSTableView.setAllowsMultipleSelection((this.style & 2) != 0);
        nSTableView.setDataSource(nSTableView);
        nSTableView.setDelegate(nSTableView);
        nSTableView.setColumnAutoresizingStyle(0L);
        NSSize nSSize = new NSSize();
        nSSize.height = 1.0;
        nSSize.width = 1.0;
        nSTableView.setIntercellSpacing(nSSize);
        nSTableView.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            nSTableView.setFocusRingType(1L);
        }
        this.headerView = (NSTableHeaderView)new SWTTableHeaderView().alloc().init();
        nSTableView.setHeaderView(null);
        NSString nSString2 = NSString.string();
        if ((this.style & 0x20) != 0) {
            this.checkColumn = (NSTableColumn)new NSTableColumn().alloc();
            nSString = (NSString)new NSString().alloc();
            nSString = nSString.initWithString(String.valueOf(++NEXT_ID));
            this.checkColumn = this.checkColumn.initWithIdentifier(nSString);
            nSString.release();
            this.checkColumn.headerCell().setTitle(nSString2);
            nSTableView.addTableColumn(this.checkColumn);
            this.checkColumn.setResizingMask(0L);
            this.checkColumn.setEditable(false);
            long l2 = NSButton.cellClass();
            this.buttonCell = new NSButtonCell(OS.class_createInstance(l2, 0L));
            this.buttonCell.init();
            this.checkColumn.setDataCell(this.buttonCell);
            this.buttonCell.setButtonType(3L);
            this.buttonCell.setControlSize(1L);
            this.buttonCell.setImagePosition(1L);
            this.buttonCell.setAllowsMixedState(true);
            this.checkColumn.setWidth(this.getCheckColumnWidth());
        }
        this.firstColumn = (NSTableColumn)new NSTableColumn().alloc();
        nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString(String.valueOf(++NEXT_ID));
        this.firstColumn = this.firstColumn.initWithIdentifier(nSString);
        nSString.release();
        this.firstColumn.setMinWidth(5.0);
        this.firstColumn.setWidth(0.0);
        this.firstColumn.setResizingMask(0L);
        this.firstColumn.headerCell().setTitle(nSString2);
        nSTableView.addTableColumn(this.firstColumn);
        this.dataCell = (NSTextFieldCell)new SWTImageTextCell().alloc().init();
        this.dataCell.setLineBreakMode(4L);
        this.firstColumn.setDataCell(this.dataCell);
        nSTableView.setHighlightedTableColumn(null);
        this.scrollView = nSScrollView;
        this.view = nSTableView;
    }

    void createItem(TableColumn tableColumn, int n2) {
        int n3;
        NSObject nSObject;
        Object object;
        if (0 > n2 || n2 > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == this.columns.length) {
            object = new TableColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, object, 0, this.columns.length);
            this.columns = object;
        }
        if (this.columnCount == 0) {
            object = this.firstColumn;
            ((NSTableColumn)object).setMinWidth(0.0);
            ((NSTableColumn)object).setResizingMask(2L);
            this.firstColumn = null;
        } else {
            object = (NSTableColumn)new NSTableColumn().alloc();
            nSObject = (NSString)new NSString().alloc();
            nSObject = ((NSString)nSObject).initWithString(String.valueOf(++NEXT_ID));
            object = ((NSTableColumn)object).initWithIdentifier((NSString)nSObject);
            nSObject.release();
            ((NSTableColumn)object).setMinWidth(0.0);
            ((NSTableView)this.view).addTableColumn((NSTableColumn)object);
            n3 = (this.style & 0x20) != 0 ? 1 : 0;
            ((NSTableView)this.view).moveColumn(this.columnCount + n3, n2 + n3);
            ((NSTableColumn)object).setDataCell(this.dataCell);
        }
        tableColumn.createJNIRef();
        nSObject = (NSTableHeaderCell)new SWTTableHeaderCell().alloc().init();
        ((NSTableColumn)object).setHeaderCell((NSCell)nSObject);
        this.display.addWidget(nSObject, tableColumn);
        tableColumn.nsColumn = object;
        ((NSTableColumn)object).setWidth(0.0);
        System.arraycopy(this.columns, n2, this.columns, n2 + 1, this.columnCount++ - n2);
        this.columns[n2] = tableColumn;
        for (n3 = 0; n3 < this.itemCount; ++n3) {
            TableItem tableItem = this.items[n3];
            if (tableItem == null || this.columnCount <= 1) continue;
            this.createColumn(tableItem, n2);
        }
    }

    void createItem(TableItem tableItem, int n2) {
        if (0 > n2 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int n3 = this.getDrawing() ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n3];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount++ - n2);
        this.items[n2] = tableItem;
        this.updateRowCount();
        if (n2 != this.itemCount) {
            this.fixSelection(n2, true);
        }
    }

    void createWidget() {
        super.createWidget();
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        return this.display.tableViewFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.headerView);
        this.display.removeWidget(this.dataCell);
        if (this.buttonCell != null) {
            this.display.removeWidget(this.buttonCell);
        }
    }

    void deselectAll(long l2, long l3, long l4) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() != -1L) {
            return;
        }
        super.deselectAll(l2, l3, l4);
    }

    void deselectRow(long l2, long l3, long l4) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() == l4) {
            return;
        }
        super.deselectRow(l2, l3, l4);
    }

    public void deselect(int n2) {
        this.checkWidget();
        if (0 <= n2 && n2 < this.itemCount) {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.deselectRow(n2);
            this.ignoreSelect = false;
        }
    }

    public void deselect(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        if (n3 < 0 || n2 >= this.itemCount) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(this.itemCount - 1, n3);
        if (n2 == 0 && n3 == this.itemCount - 1) {
            this.deselectAll();
        } else {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            for (int i2 = n2; i2 <= n3; ++i2) {
                nSTableView.deselectRow(i2);
            }
            this.ignoreSelect = false;
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nSTableView.deselectRow(nArray[i2]);
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.deselectAll(null);
        this.ignoreSelect = false;
    }

    void destroyItem(TableColumn tableColumn) {
        Object object;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.columnCount && this.columns[n3] != tableColumn; ++n3) {
        }
        for (n2 = 0; n2 < this.itemCount; ++n2) {
            Object[] objectArray;
            Object[] objectArray2;
            object = this.items[n2];
            if (object == null) continue;
            if (this.columnCount <= 1) {
                ((TableItem)object).strings = null;
                ((TableItem)object).images = null;
                ((TableItem)object).cellBackground = null;
                ((TableItem)object).cellForeground = null;
                ((TableItem)object).cellFont = null;
                continue;
            }
            if (((TableItem)object).strings != null) {
                objectArray2 = ((TableItem)object).strings;
                if (n3 == 0) {
                    ((TableItem)object).text = objectArray2[1] != null ? objectArray2[1] : "";
                }
                objectArray = new String[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n3);
                System.arraycopy(objectArray2, n3 + 1, objectArray, n3, this.columnCount - 1 - n3);
                ((TableItem)object).strings = objectArray;
            } else if (n3 == 0) {
                ((TableItem)object).text = "";
            }
            if (((TableItem)object).images != null) {
                objectArray2 = ((TableItem)object).images;
                if (n3 == 0) {
                    ((TableItem)object).image = objectArray2[1];
                }
                objectArray = new Image[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n3);
                System.arraycopy(objectArray2, n3 + 1, objectArray, n3, this.columnCount - 1 - n3);
                ((TableItem)object).images = objectArray;
            } else if (n3 == 0) {
                ((TableItem)object).image = null;
            }
            if (((TableItem)object).cellBackground != null) {
                objectArray2 = ((TableItem)object).cellBackground;
                objectArray = new Color[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n3);
                System.arraycopy(objectArray2, n3 + 1, objectArray, n3, this.columnCount - 1 - n3);
                ((TableItem)object).cellBackground = objectArray;
            }
            if (((TableItem)object).cellForeground != null) {
                objectArray2 = ((TableItem)object).cellForeground;
                objectArray = new Color[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n3);
                System.arraycopy(objectArray2, n3 + 1, objectArray, n3, this.columnCount - 1 - n3);
                ((TableItem)object).cellForeground = objectArray;
            }
            if (((TableItem)object).cellFont == null) continue;
            objectArray2 = ((TableItem)object).cellFont;
            objectArray = new Font[this.columnCount - 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, n3);
            System.arraycopy(objectArray2, n3 + 1, objectArray, n3, this.columnCount - 1 - n3);
            ((TableItem)object).cellFont = objectArray;
        }
        n2 = this.indexOf(tableColumn.nsColumn);
        System.arraycopy(this.columns, n3 + 1, this.columns, n3, --this.columnCount - n3);
        this.columns[this.columnCount] = null;
        if (this.columnCount == 0) {
            this.firstColumn = tableColumn.nsColumn;
            this.firstColumn.retain();
            this.firstColumn.setMinWidth(5.0);
            this.firstColumn.setResizingMask(0L);
            this.setScrollWidth();
        } else {
            ((NSTableView)this.view).removeTableColumn(tableColumn.nsColumn);
        }
        object = ((NSTableView)this.view).tableColumns();
        int n4 = (int)((NSArray)object).count();
        block2: for (int i2 = n2; i2 < n4; ++i2) {
            long l2 = ((NSArray)object).objectAtIndex((long)((long)i2)).id;
            for (int i3 = 0; i3 < this.columnCount; ++i3) {
                if (this.columns[i3].nsColumn.id != l2) continue;
                this.columns[i3].sendEvent(10);
                continue block2;
            }
        }
    }

    void destroyItem(TableItem tableItem) {
        int n2;
        for (n2 = 0; n2 < this.itemCount && this.items[n2] != tableItem; ++n2) {
        }
        if (n2 != this.itemCount - 1) {
            this.fixSelection(n2, false);
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --this.itemCount - n2);
        this.items[this.itemCount] = null;
        this.updateRowCount();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    boolean dragDetect(int n2, int n3, boolean bl2, boolean[] blArray) {
        return false;
    }

    void drawBackgroundInClipRect(long l2, long l3, NSRect nSRect) {
        super.drawViewBackgroundInRect(l2, l3, nSRect);
        if (l2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, NSGraphicsContext.currentContext(), nSRect, -1);
    }

    void drawInteriorWithFrame_inView(long l2, long l3, NSRect nSRect, long l4) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl2;
        Color color;
        boolean bl3 = this.hooks(40);
        boolean bl4 = this.hooks(42);
        boolean bl5 = this.hooks(41);
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(l2);
        NSTableView nSTableView = (NSTableView)this.view;
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l2, Display.SWT_ROW, lArray);
        long l5 = lArray[0];
        TableItem tableItem = this._getItem((int)l5);
        OS.object_getInstanceVariable(l2, Display.SWT_COLUMN, lArray);
        long l6 = lArray[0];
        long l7 = nSTableView.tableColumns().indexOfObjectIdenticalTo(new id(l6));
        int n2 = 0;
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (this.columns[i2].nsColumn.id != l6) continue;
            n2 = i2;
            break;
        }
        Color color2 = color = tableItem.cellBackground != null ? tableItem.cellBackground[n2] : null;
        if (color == null) {
            color = tableItem.background;
        }
        boolean bl6 = color != null;
        boolean bl7 = true;
        boolean bl8 = bl2 = nSTextFieldCell.isHighlighted();
        boolean bl9 = this.hasFocus();
        Color color3 = null;
        Color color4 = null;
        if (bl2 && (bl3 || bl4)) {
            color4 = Color.cocoa_new(this.display, bl9 ? this.display.alternateSelectedControlTextColor : this.display.selectedControlTextColor);
            color3 = Color.cocoa_new(this.display, bl9 ? this.display.alternateSelectedControlColor : this.display.secondarySelectedControlColor);
        }
        NSSize nSSize = super.cellSize(l2, OS.sel_cellSize);
        NSImage nSImage = nSTextFieldCell.image();
        if (nSImage != null) {
            nSSize.width += (double)(this.imageBounds.width + 3);
        }
        int n3 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSTableView.intercellSpacing();
        int n4 = (int)Math.ceil(nSTableView.rowHeight() + nSSize2.height);
        NSRect nSRect2 = nSTableView.rectOfColumn(l7);
        nSRect2.y = nSRect.y;
        nSRect2.height = nSRect.height + nSSize2.height;
        if (this.columnCount == 0) {
            NSRect nSRect3 = nSTableView.rectOfRow(l5);
            nSRect2.width = nSRect3.width;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        if (bl4 || bl3) {
            NSRect nSRect4 = nSTableView.frameOfCellAtColumn(l7, l5);
            d2 = nSRect.x - nSRect4.x;
            d3 = nSRect.y - nSRect4.y;
            if (this.drawExpansion) {
                d2 -= 0.5;
                d3 -= 0.5;
            }
        }
        int n5 = (int)(nSRect.x - d2);
        int n6 = (int)(nSRect.y - d3);
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        if (bl5) {
            this.sendMeasureItem(tableItem, n2, nSSize, bl2);
        }
        Color color5 = null;
        if (bl3) {
            nSGraphicsContext.saveGraphicsState();
            object4 = NSAffineTransform.transform();
            ((NSAffineTransform)object4).translateXBy(d2, d3);
            ((NSAffineTransform)object4).concat();
            object3 = new GCData();
            ((GCData)object3).paintRect = nSRect2;
            object2 = GC.cocoa_new(this, (GCData)object3);
            ((GC)object2).setFont(tableItem.getFont(n2));
            if (bl2 && ((this.style & 0x8000) == 0 || bl9)) {
                object = color4;
                ((GC)object2).setBackground(color3);
            } else {
                object = tableItem.getForeground(n2);
                ((GC)object2).setBackground(tableItem.getBackground(n2));
            }
            ((GC)object2).setForeground((Color)object);
            if (!this.drawExpansion) {
                ((GC)object2).setClipping((int)(nSRect2.x - d2), (int)(nSRect2.y - d3), (int)nSRect2.width, (int)nSRect2.height);
            }
            Event event = new Event();
            event.item = tableItem;
            event.gc = object2;
            event.index = n2;
            event.detail = 16;
            if (bl6) {
                event.detail |= 8;
            }
            if (bl2 && ((this.style & 0x8000) == 0 || bl9)) {
                event.detail |= 2;
            }
            event.x = (int)nSRect2.x;
            event.y = (int)nSRect2.y;
            event.width = (int)nSRect2.width;
            event.height = (int)nSRect2.height;
            this.sendEvent(40, event);
            if (!event.doit) {
                bl8 = false;
                bl6 = false;
                bl7 = false;
            } else {
                bl6 = bl6 && (event.detail & 8) != 0;
                bl7 = (event.detail & 0x10) != 0;
                boolean bl10 = bl8 = bl8 && (event.detail & 2) != 0;
            }
            if (!bl8 && bl2) {
                color5 = Color.cocoa_new(this.display, ((GC)object2).getForeground().handle);
            }
            ((Resource)object2).dispose();
            nSGraphicsContext.restoreGraphicsState();
            if (this.isDisposed()) {
                return;
            }
            if (tableItem.isDisposed()) {
                return;
            }
            if (bl8) {
                nSRect2.height -= nSSize2.height;
                this.callSuper(nSTableView.id, OS.sel_highlightSelectionInClipRect_, nSRect2);
                nSRect2.height += nSSize2.height;
            }
        } else if (bl2 && (this.style & 0x8000) != 0 && !bl9) {
            color5 = tableItem.getForeground(n2);
        }
        if (bl6 && !bl8) {
            nSGraphicsContext.saveGraphicsState();
            object4 = color.handle;
            object3 = NSColor.colorWithDeviceRed((double)object4[0], (double)object4[1], (double)object4[2], 1.0);
            ((NSColor)object3).setFill();
            NSBezierPath.fillRect(nSRect2);
            nSGraphicsContext.restoreGraphicsState();
        }
        if (bl7) {
            if ((!this.drawExpansion || bl5) && nSImage != null) {
                object4 = new NSRect();
                ((NSRect)object4).x = nSRect.x + 3.0;
                ((NSRect)object4).y = nSRect.y + (double)((float)Math.ceil((nSRect.height - (double)this.imageBounds.height) / 2.0));
                ((NSRect)object4).width = this.imageBounds.width;
                ((NSRect)object4).height = this.imageBounds.height;
                nSGraphicsContext.saveGraphicsState();
                NSBezierPath.bezierPathWithRect(nSRect).addClip();
                object3 = NSAffineTransform.transform();
                ((NSAffineTransform)object3).scaleXBy(1.0, -1.0);
                ((NSAffineTransform)object3).translateXBy(0.0, -(((NSRect)object4).height + 2.0 * ((NSRect)object4).y));
                ((NSAffineTransform)object3).concat();
                nSImage.drawInRect((NSRect)object4, new NSRect(), 2L, 1.0);
                nSGraphicsContext.restoreGraphicsState();
                int n7 = this.imageBounds.width + 3;
                nSRect.x += (double)n7;
                nSRect.width -= (double)n7;
            }
            nSTextFieldCell.setHighlighted(false);
            boolean bl11 = false;
            if (color5 != null) {
                object3 = color5.handle;
                if (object3[0] == 0.0 && object3[1] == 0.0 && object3[2] == 0.0 && object3[3] == 1.0) {
                    object2 = new NSMutableAttributedString(nSTextFieldCell.attributedStringValue().mutableCopy());
                    object = new NSRange();
                    ((NSRange)object).length = ((NSAttributedString)object2).length();
                    ((NSMutableAttributedString)object2).removeAttribute(OS.NSForegroundColorAttributeName, (NSRange)object);
                    int n8 = this.columnCount == 0 ? 16384 : this.columns[n2].style & 0x1024000;
                    NSSize nSSize3 = ((NSAttributedString)object2).size();
                    NSRect nSRect5 = new NSRect();
                    nSRect5.x = nSRect.x + 2.0;
                    nSRect5.y = nSRect.y;
                    nSRect5.width = nSRect.width - 2.0;
                    switch (n8) {
                        case 0x1000000: {
                            nSRect5.width -= 2.0;
                            break;
                        }
                        case 131072: {
                            if (!(nSRect.width > nSSize3.width)) break;
                            nSRect5.width -= 2.0;
                        }
                    }
                    nSRect5.height = nSRect.height;
                    if (nSRect5.height > nSSize3.height) {
                        nSRect5.y += (nSRect5.height - nSSize3.height) / 2.0;
                        nSRect5.height = nSSize3.height;
                    }
                    ((NSAttributedString)object2).drawInRect(nSRect5);
                    ((NSObject)object2).release();
                } else {
                    object2 = NSColor.colorWithDeviceRed((double)object3[0], (double)object3[1], (double)object3[2], (double)object3[3]);
                    nSTextFieldCell.setTextColor((NSColor)object2);
                    bl11 = true;
                }
            } else {
                bl11 = true;
            }
            if (bl11) {
                object3 = nSTextFieldCell.attributedStringValue();
                object2 = ((NSAttributedString)object3).size();
                if (nSRect.height > ((NSSize)object2).height) {
                    nSRect.y += (nSRect.height - ((NSSize)object2).height) / 2.0;
                    nSRect.height = ((NSSize)object2).height;
                }
                super.drawInteriorWithFrame_inView(l2, l3, nSRect, l4);
            }
        }
        if (bl4) {
            nSGraphicsContext.saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(d2, d3);
            nSAffineTransform.concat();
            object3 = new GCData();
            ((GCData)object3).paintRect = nSRect2;
            object2 = GC.cocoa_new(this, (GCData)object3);
            ((GC)object2).setFont(tableItem.getFont(n2));
            if (bl8) {
                ((GC)object2).setForeground(color4);
                ((GC)object2).setBackground(color3);
            } else {
                ((GC)object2).setForeground(color5 != null ? color5 : tableItem.getForeground(n2));
                ((GC)object2).setBackground(tableItem.getBackground(n2));
            }
            if (!this.drawExpansion) {
                ((GC)object2).setClipping((int)(nSRect2.x - d2), (int)(nSRect2.y - d3), (int)nSRect2.width, (int)nSRect2.height);
            }
            object = new Event();
            ((Event)object).item = tableItem;
            ((Event)object).gc = object2;
            ((Event)object).index = n2;
            if (bl7) {
                ((Event)object).detail |= 0x10;
            }
            if (bl6) {
                ((Event)object).detail |= 8;
            }
            if (bl2) {
                ((Event)object).detail |= 2;
            }
            ((Event)object).x = n5;
            ((Event)object).y = n6;
            ((Event)object).width = n3;
            ((Event)object).height = n4;
            this.sendEvent(42, (Event)object);
            ((Resource)object2).dispose();
            nSGraphicsContext.restoreGraphicsState();
        }
    }

    void drawWithExpansionFrame_inView(long l2, long l3, NSRect nSRect, long l4) {
        this.drawExpansion = true;
        super.drawWithExpansionFrame_inView(l2, l3, nSRect, l4);
        this.drawExpansion = false;
    }

    void drawRect(long l2, long l3, NSRect nSRect) {
        this.fixScrollWidth = false;
        super.drawRect(l2, l3, nSRect);
        if (this.isDisposed()) {
            return;
        }
        if (this.fixScrollWidth) {
            this.fixScrollWidth = false;
            if (this.setScrollWidth(this.items, true)) {
                this.view.setNeedsDisplay(true);
            }
        }
    }

    NSRect expansionFrameWithFrame_inView(long l2, long l3, NSRect nSRect, long l4) {
        if (this.toolTipText == null) {
            NSRect nSRect2;
            NSRect nSRect3 = super.expansionFrameWithFrame_inView(l2, l3, nSRect, l4);
            NSCell nSCell = new NSCell(l2);
            NSAttributedString nSAttributedString = nSCell.attributedStringValue();
            NSSize nSSize = nSAttributedString.size();
            if (nSRect3.width != 0.0 && nSRect3.height != 0.0) {
                if (this.hooks(41)) {
                    nSRect2 = nSRect;
                    NSSize nSSize2 = nSCell.cellSize();
                    nSRect2.width = nSSize2.width;
                } else {
                    nSRect2 = nSRect3;
                }
                if (nSSize.height > nSRect2.height) {
                    nSRect2.height = nSSize.height;
                }
            } else {
                Object object;
                if (this.hooks(41)) {
                    nSRect2 = nSRect;
                    object = nSCell.cellSize();
                    nSRect2.width = ((NSSize)object).width;
                } else {
                    nSRect2 = nSCell.titleRectForBounds(nSRect);
                    object = super.cellSize(l2, OS.sel_cellSize);
                    nSRect2.width = ((NSSize)object).width;
                }
                if (nSSize.height > nSRect2.height) {
                    nSRect2.height = nSSize.height;
                } else {
                    object = this.scrollView.contentView().bounds();
                    OS.NSIntersectionRect((NSRect)object, nSRect2, (NSRect)object);
                    if (OS.NSEqualRects(nSRect2, (NSRect)object)) {
                        return new NSRect();
                    }
                }
            }
            return nSRect2;
        }
        return new NSRect();
    }

    Widget findTooltip(NSPoint nSPoint) {
        long l2;
        NSTableView nSTableView = (NSTableView)this.view;
        NSTableHeaderView nSTableHeaderView = nSTableView.headerView();
        if (nSTableHeaderView != null && (l2 = nSTableHeaderView.columnAtPoint(nSPoint = nSTableHeaderView.convertPoint_fromView_(nSPoint, null))) != -1L) {
            NSArray nSArray = nSTableView.tableColumns();
            id id2 = nSArray.objectAtIndex(l2);
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                TableColumn tableColumn = this.columns[i2];
                if (tableColumn.nsColumn.id != id2.id) continue;
                return tableColumn;
            }
        }
        return super.findTooltip(nSPoint);
    }

    void fixSelection(int n2, boolean bl2) {
        int[] nArray = this.getSelectionIndices();
        if (nArray.length == 0) {
            return;
        }
        int n3 = 0;
        boolean bl3 = false;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!bl2 && nArray[i2] == n2) {
                bl3 = true;
                continue;
            }
            int n4 = n3++;
            nArray[n4] = nArray[i2];
            if (nArray[n4] < n2) continue;
            int n5 = n4;
            nArray[n5] = nArray[n5] + (bl2 ? 1 : -1);
            bl3 = true;
        }
        if (bl3) {
            this.select(nArray, n3, true);
        }
    }

    int getCheckColumnWidth() {
        return (int)this.checkColumn.dataCell().cellSize().width;
    }

    public Rectangle getClientArea() {
        NSTableHeaderView nSTableHeaderView;
        this.checkWidget();
        Rectangle rectangle = super.getClientArea();
        if (OS.VERSION_MMB < OS.VERSION_MMB(10, 11, 0) && (nSTableHeaderView = ((NSTableView)this.view).headerView()) != null) {
            int n2 = (int)nSTableHeaderView.bounds().height;
            rectangle.y -= n2;
            rectangle.height += n2;
        }
        return rectangle;
    }

    TableColumn getColumn(id id2) {
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (this.columns[i2].nsColumn.id != id2.id) continue;
            return this.columns[i2];
        }
        return null;
    }

    public TableColumn getColumn(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n2];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] nArray = new int[this.columnCount];
        int n2 = 0;
        while (n2 < this.columnCount) {
            TableColumn tableColumn = this.columns[n2];
            int n3 = this.indexOf(tableColumn.nsColumn);
            if ((this.style & 0x20) != 0) {
                --n3;
            }
            nArray[n3] = n2++;
        }
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        NSTableHeaderView nSTableHeaderView = ((NSTableView)this.view).headerView();
        if (nSTableHeaderView == null) {
            return 0;
        }
        return (int)nSTableHeaderView.bounds().height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return ((NSTableView)this.view).headerView() != null;
    }

    public TableItem getItem(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(n2);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = point.x;
        nSPoint.y = point.y;
        int n2 = (int)nSTableView.rowAtPoint(nSPoint);
        if (n2 == -1) {
            return null;
        }
        return this.items[n2];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSTableView)this.view).rowHeight() + 1;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            for (int i2 = 0; i2 < this.itemCount; ++i2) {
                tableItemArray[i2] = this._getItem(i2);
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return ((NSTableView)this.view).usesAlternatingRowBackgroundColors();
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return new TableItem[0];
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n2 = (int)nSIndexSet.count();
        long[] lArray = new long[n2];
        nSIndexSet.getIndexes(lArray, n2, 0L);
        TableItem[] tableItemArray = new TableItem[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            tableItemArray[i2] = this._getItem((int)lArray[i2]);
        }
        return tableItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)((NSTableView)this.view).numberOfSelectedRows();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return -1;
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n2 = (int)nSIndexSet.count();
        long[] lArray = new long[n2];
        nSIndexSet.getIndexes(lArray, n2, 0L);
        return (int)lArray[0];
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return new int[0];
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n2 = (int)nSIndexSet.count();
        long[] lArray = new long[n2];
        nSIndexSet.getIndexes(lArray, n2, 0L);
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            nArray[i2] = (int)lArray[i2];
        }
        return nArray;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        int n2;
        NSTableHeaderView nSTableHeaderView;
        this.checkWidget();
        NSRect nSRect = this.scrollView.documentVisibleRect();
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = nSRect.x;
        nSPoint.y = nSRect.y;
        if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 11, 0) && (nSTableHeaderView = ((NSTableView)this.view).headerView()) != null) {
            int n3 = (int)nSTableHeaderView.bounds().height;
            nSPoint.y += (double)n3;
        }
        if ((n2 = (int)((NSTableView)this.view).rowAtPoint(nSPoint)) == -1) {
            return 0;
        }
        return n2;
    }

    NSRect headerRectOfColumn(long l2, long l3, long l4) {
        if ((this.style & 0x20) == 0) {
            return this.callSuperRect(l2, l3, l4);
        }
        if (l4 == 0L) {
            NSRect nSRect = this.callSuperRect(l2, l3, l4);
            nSRect.width = 0.0;
            return nSRect;
        }
        if (l4 == 1L) {
            NSRect nSRect = this.callSuperRect(l2, l3, l4);
            nSRect.width += this.checkColumn.width() + 1.0;
            nSRect.x -= this.checkColumn.width() + 1.0;
            return nSRect;
        }
        return this.callSuperRect(l2, l3, l4);
    }

    void highlightSelectionInClipRect(long l2, long l3, long l4) {
        if (this.hooks(40)) {
            return;
        }
        if ((this.style & 0x8000) != 0 && !this.hasFocus()) {
            return;
        }
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, l4, (long)NSRect.sizeof);
        this.callSuper(l2, l3, nSRect);
    }

    long hitTestForEvent(long l2, long l3, long l4, NSRect nSRect, long l5) {
        return this.callSuper(l2, l3, l4, nSRect, l5);
    }

    long image(long l2, long l3) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l2, Display.SWT_IMAGE, lArray);
        return lArray[0];
    }

    NSRect imageRectForBounds(long l2, long l3, NSRect nSRect) {
        NSImage nSImage = new NSCell(l2).image();
        if (nSImage != null) {
            nSRect.x += 3.0;
            nSRect.width = this.imageBounds.width;
            nSRect.height = this.imageBounds.height;
        }
        return nSRect;
    }

    int indexOf(NSTableColumn nSTableColumn) {
        return (int)((NSTableView)this.view).tableColumns().indexOfObjectIdenticalTo(nSTableColumn);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (this.columns[i2] != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            for (int i2 = 0; i2 < this.itemCount; ++i2) {
                if (this.items[i2] != tableItem) continue;
                this.lastIndexOf = i2;
                return this.lastIndexOf;
            }
        } else {
            for (int i3 = this.itemCount - 1; i3 >= 0; --i3) {
                if (this.items[i3] != tableItem) continue;
                this.lastIndexOf = i3;
                return this.lastIndexOf;
            }
        }
        return -1;
    }

    public boolean isSelected(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 >= this.itemCount) {
            return false;
        }
        return ((NSTableView)this.view).isRowSelected(n2);
    }

    boolean isTransparent() {
        return true;
    }

    void keyDown(long l2, long l3, long l4) {
        this.preventSelect = false;
        this.ignoreSelect = false;
        super.keyDown(l2, l3, l4);
    }

    boolean isTrim(NSView nSView) {
        if (super.isTrim(nSView)) {
            return true;
        }
        return nSView.id == this.headerView.id;
    }

    long menuForEvent(long l2, long l3, long l4) {
        if (l2 != this.headerView.id) {
            NSPoint nSPoint;
            long l5;
            NSEvent nSEvent = new NSEvent(l4);
            NSTableView nSTableView = (NSTableView)this.view;
            NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
            if (!nSIndexSet.containsIndex(l5 = nSTableView.rowAtPoint(nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null)))) {
                NSIndexSet nSIndexSet2 = (NSIndexSet)new NSIndexSet().alloc();
                nSIndexSet2 = nSIndexSet2.initWithIndex(l5);
                nSTableView.selectRowIndexes(nSIndexSet2, false);
                nSIndexSet2.release();
            }
        }
        return super.menuForEvent(l2, l3, l4);
    }

    void mouseDown(long l2, long l3, long l4) {
        NSEvent nSEvent;
        if (l2 == this.view.id && ((nSEvent = new NSEvent(l4)).modifierFlags() & 0x40000L) != 0L) {
            return;
        }
        super.mouseDown(l2, l3, l4);
    }

    void mouseDownSuper(long l2, long l3, long l4) {
        NSRect nSRect;
        int n2;
        NSCell nSCell;
        this.preventSelect = false;
        this.ignoreSelect = false;
        boolean bl2 = false;
        NSTableView nSTableView = (NSTableView)this.view;
        NSEvent nSEvent = new NSEvent(l4);
        NSPoint nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null);
        int n3 = (int)nSTableView.rowAtPoint(nSPoint);
        if (n3 != -1 && (this.style & 0x20) != 0 && (nSCell = nSTableView.preparedCellAtColumn(n2 = (int)nSTableView.columnAtPoint(nSPoint), n3)) != null && nSCell.isKindOfClass(OS.class_NSButtonCell) && nSCell.isEnabled() && OS.NSPointInRect(nSPoint, nSRect = nSCell.imageRectForBounds(nSTableView.frameOfCellAtColumn(n2, n3)))) {
            this.preventSelect = true;
            bl2 = true;
        }
        if (!bl2 && n3 != -1 && (nSEvent.modifierFlags() & 0xFFFF0000L) == 0L && nSEvent.clickCount() == 1L && nSTableView.isRowSelected(n3) && 0 <= n3 && n3 < this.itemCount) {
            this.selectedRowIndex = n3;
        }
        this.didSelect = false;
        super.mouseDownSuper(l2, l3, l4);
        this.didSelect = false;
    }

    boolean needsPanelToBecomeKey(long l2, long l3) {
        return false;
    }

    long nextState(long l2, long l3) {
        NSTableView nSTableView = (NSTableView)this.view;
        int n2 = (int)nSTableView.clickedRow();
        if (n2 == -1) {
            n2 = (int)nSTableView.selectedRow();
        }
        TableItem tableItem = this.items[n2];
        if (tableItem.grayed) {
            return tableItem.checked ? 0L : -1L;
        }
        return tableItem.checked ? 0L : 1L;
    }

    long numberOfRowsInTableView(long l2, long l3, long l4) {
        return this.itemCount;
    }

    void register() {
        super.register();
        this.display.addWidget(this.headerView, this);
        this.display.addWidget(this.dataCell, this);
        if (this.buttonCell != null) {
            this.display.addWidget(this.buttonCell, this);
        }
    }

    void releaseChildren(boolean bl2) {
        Item item;
        int n2;
        if (this.items != null) {
            for (n2 = 0; n2 < this.itemCount; ++n2) {
                item = this.items[n2];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.items = null;
        }
        if (this.columns != null) {
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                item = this.columns[n2];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl2);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.headerView != null) {
            this.headerView.release();
        }
        this.headerView = null;
        if (this.firstColumn != null) {
            this.firstColumn.release();
        }
        this.firstColumn = null;
        if (this.checkColumn != null) {
            this.checkColumn.release();
        }
        this.checkColumn = null;
        if (this.dataCell != null) {
            this.dataCell.release();
        }
        this.dataCell = null;
        if (this.buttonCell != null) {
            this.buttonCell.release();
        }
        this.buttonCell = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.currentItem = null;
        this.sortColumn = null;
    }

    public void remove(int n2) {
        TableItem tableItem;
        this.checkWidget();
        if (0 > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n2]) != null) {
            tableItem.release(false);
        }
        if (n2 != this.itemCount - 1) {
            this.fixSelection(n2, false);
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --this.itemCount - n2);
        this.items[this.itemCount] = null;
        this.updateRowCount();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        if (0 > n2 || n2 > n3 || n3 >= this.itemCount) {
            this.error(6);
        }
        if (n2 == 0 && n3 == this.itemCount - 1) {
            this.removeAll();
        } else {
            int n4 = n3 - n2 + 1;
            for (int i2 = n2; i2 < n4; ++i2) {
                TableItem tableItem = this.items[i2];
                if (tableItem == null) continue;
                tableItem.release(false);
            }
            int[] nArray = this.getSelectionIndices();
            if (nArray.length != 0) {
                int n5 = 0;
                boolean bl2 = false;
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    if (nArray[i3] >= n2 && nArray[i3] <= n3) {
                        bl2 = true;
                        continue;
                    }
                    int n6 = n5++;
                    nArray[n6] = nArray[i3];
                    if (nArray[n6] <= n3) continue;
                    int n7 = n6;
                    nArray[n7] = nArray[n7] - n4;
                    bl2 = true;
                }
                if (bl2) {
                    this.select(nArray, n5, true);
                }
            }
            System.arraycopy(this.items, n2 + n4, this.items, n2, this.itemCount - (n2 + n4));
            for (int i4 = this.itemCount; i4 < this.items.length; ++i4) {
                this.items[i4] = null;
            }
            this.itemCount -= n4;
            this.updateRowCount();
        }
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n2 = nArray2[nArray2.length - 1];
        int n3 = nArray2[0];
        if (0 > n2 || n2 > n3 || n3 >= this.itemCount) {
            this.error(6);
        }
        int n4 = -1;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n5 = nArray2[i2];
            if (n5 == n4) continue;
            TableItem tableItem = this.items[n5];
            if (tableItem != null) {
                tableItem.release(false);
            }
            if (n5 != this.itemCount - 1) {
                this.fixSelection(n5, false);
            }
            System.arraycopy(this.items, n5 + 1, this.items, n5, --this.itemCount - n5);
            this.items[this.itemCount] = null;
            n4 = n5;
        }
        this.updateRowCount();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void removeAll() {
        this.checkWidget();
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            TableItem tableItem = this.items[i2];
            if (tableItem == null || tableItem.isDisposed()) continue;
            tableItem.release(false);
        }
        this.setTableEmpty();
        this.updateRowCount();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void reskinChildren(int n2) {
        Item item;
        int n3;
        if (this.items != null) {
            for (n3 = 0; n3 < this.itemCount; ++n3) {
                item = this.items[n3];
                if (item == null) continue;
                item.reskin(n2);
            }
        }
        if (this.columns != null) {
            for (n3 = 0; n3 < this.columnCount; ++n3) {
                item = this.columns[n3];
                if (item.isDisposed()) continue;
                item.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    void scrollClipViewToPoint(long l2, long l3, long l4, NSPoint nSPoint) {
        if (this.shouldScroll) {
            super.scrollClipViewToPoint(l2, l3, l4, nSPoint);
            if ((this.style & 0x20) != 0 && this.columnCount > 0 && ((NSTableView)this.view).headerView() != null && nSPoint.x <= (double)this.getCheckColumnWidth()) {
                this.headerView.setNeedsDisplayInRect(this.headerView.headerRectOfColumn(1L));
            }
        }
    }

    public void select(int n2) {
        this.checkWidget();
        if (0 <= n2 && n2 < this.itemCount) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(n2);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
            nSIndexSet.release();
        }
    }

    public void select(int n2, int n3) {
        this.checkWidget();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        if (this.itemCount == 0 || n2 >= this.itemCount) {
            return;
        }
        if (n2 == 0 && n3 == this.itemCount - 1) {
            this.selectAll();
        } else {
            n2 = Math.max(0, n2);
            n3 = Math.min(n3, this.itemCount - 1);
            NSRange nSRange = new NSRange();
            nSRange.location = n2;
            nSRange.length = n3 - n2 + 1;
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndexesInRange(nSRange);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
            nSIndexSet.release();
        }
    }

    public void select(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n2 = nArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        int n3 = 0;
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = nArray[i2];
            if (n4 < 0 || n4 >= this.itemCount) continue;
            nSMutableIndexSet.addIndex(nArray[i2]);
            ++n3;
        }
        if (n3 > 0) {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSMutableIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
        }
        nSMutableIndexSet.release();
    }

    void select(int[] nArray, int n2, boolean bl2) {
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        for (int i2 = 0; i2 < n2; ++i2) {
            nSMutableIndexSet.addIndex(nArray[i2]);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectRowIndexes(nSMutableIndexSet, !bl2);
        this.ignoreSelect = false;
        nSMutableIndexSet.release();
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectAll(null);
        this.ignoreSelect = false;
    }

    void setBackgroundColor(NSColor nSColor) {
        ((NSTableView)this.view).setBackgroundColor(nSColor);
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = this.getColumnOrder();
        boolean bl2 = false;
        boolean[] blArray = new boolean[this.columnCount];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(5);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
            if (nArray[i2] == nArray2[i2]) continue;
            bl2 = true;
        }
        if (bl2) {
            TableColumn tableColumn;
            int n3;
            int n4;
            NSTableView nSTableView = (NSTableView)this.view;
            int[] nArray3 = new int[nArray2.length];
            int n5 = (this.style & 0x20) != 0 ? 1 : 0;
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                n4 = nArray2[i3];
                nArray3[n4] = (int)nSTableView.rectOfColumn((long)((long)(i3 + n5))).x;
            }
            int[] nArray4 = new int[nArray.length];
            for (n4 = 0; n4 < nArray.length; ++n4) {
                n3 = nArray[n4];
                tableColumn = this.columns[n3];
                int n6 = this.indexOf(tableColumn.nsColumn);
                int n7 = n4 + n5;
                nSTableView.moveColumn(n6, n7);
                nArray4[n3] = (int)nSTableView.rectOfColumn((long)((long)n7)).x;
            }
            TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
            for (n3 = 0; n3 < this.columnCount; ++n3) {
                tableColumn = tableColumnArray[n3];
                if (tableColumn.isDisposed() || nArray4[n3] == nArray3[n3]) continue;
                tableColumn.sendEvent(10);
            }
        }
    }

    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        this.setItemHeight(null, nSFont, !this.hooks(41));
        this.view.setNeedsDisplay(true);
        this.clearCachedWidth(this.items);
        this.setScrollWidth(this.items, true);
    }

    public void setHeaderVisible(boolean bl2) {
        this.checkWidget();
        ((NSTableView)this.view).setHeaderView(bl2 ? this.headerView : null);
        this.scrollView.tile();
    }

    void setImage(long l2, long l3, long l4) {
        OS.object_setInstanceVariable(l2, Display.SWT_IMAGE, l4);
    }

    public void setItemCount(int n2) {
        TableItem[] tableItemArray;
        int n3;
        this.checkWidget();
        n2 = Math.max(0, n2);
        if (n2 == this.itemCount) {
            return;
        }
        TableItem[] tableItemArray2 = this.items;
        if (n2 < this.itemCount) {
            for (n3 = n2; n3 < this.itemCount; ++n3) {
                tableItemArray = tableItemArray2[n3];
                if (tableItemArray == null || tableItemArray.isDisposed()) continue;
                tableItemArray.release(false);
            }
        }
        if (n2 > this.itemCount && (this.getStyle() & 0x10000000) == 0) {
            for (n3 = this.itemCount; n3 < n2; ++n3) {
                new TableItem(this, 0, n3, true);
            }
            return;
        }
        n3 = Math.max(4, (n2 + 3) / 4 * 4);
        tableItemArray = new TableItem[n3];
        if (tableItemArray2 != null) {
            System.arraycopy(this.items, 0, tableItemArray, 0, Math.min(n2, this.itemCount));
        }
        tableItemArray2 = tableItemArray;
        this.items = tableItemArray;
        this.itemCount = n2;
        this.updateRowCount();
    }

    void setItemHeight(int n2) {
        this.checkWidget();
        if (n2 < -1) {
            this.error(5);
        }
        if (n2 != -1) {
            ((NSTableView)this.view).setRowHeight(n2);
        }
    }

    void setItemHeight(Image image, NSFont nSFont, boolean bl2) {
        Rectangle rectangle;
        if (nSFont == null) {
            nSFont = this.getFont().handle;
        }
        double d2 = nSFont.ascender();
        double d3 = -nSFont.descender() + nSFont.leading();
        int n2 = (int)Math.ceil(d2 + d3) + 1;
        Rectangle rectangle2 = rectangle = image != null ? image.getBounds() : this.imageBounds;
        if (rectangle != null) {
            this.imageBounds = rectangle;
            n2 = Math.max(n2, rectangle.height);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        if (bl2 || nSTableView.rowHeight() < (double)n2) {
            nSTableView.setRowHeight(n2);
        }
    }

    public void setRedraw(boolean bl2) {
        this.checkWidget();
        super.setRedraw(bl2);
        if (bl2 && this.drawCount == 0) {
            if (this.items.length > 4 && this.items.length - this.itemCount > 3) {
                int n2 = Math.max(4, (this.itemCount + 3) / 4 * 4);
                TableItem[] tableItemArray = new TableItem[n2];
                System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
                this.items = tableItemArray;
            }
            this.setScrollWidth();
        }
    }

    public void setLinesVisible(boolean bl2) {
        this.checkWidget();
        ((NSTableView)this.view).setUsesAlternatingRowBackgroundColors(bl2);
        ((NSTableView)this.view).setGridStyleMask(bl2 ? 1L : 0L);
    }

    boolean setScrollWidth() {
        return this.setScrollWidth(this.items, true);
    }

    boolean setScrollWidth(TableItem tableItem) {
        if (this.columnCount != 0) {
            return false;
        }
        if (!this.getDrawing()) {
            return false;
        }
        if (this.currentItem != null) {
            if (this.currentItem != tableItem) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        GC gC = new GC(this);
        int n2 = tableItem.calculateWidth(0, gC, this.isSelected(this.indexOf(tableItem)));
        gC.dispose();
        int n3 = (int)this.firstColumn.width();
        if (n3 < n2) {
            this.firstColumn.setWidth(n2);
            if (this.horizontalBar != null && this.horizontalBar.view != null) {
                this.redrawWidget(this.horizontalBar.view, false);
            }
            return true;
        }
        return false;
    }

    boolean setScrollWidth(TableItem[] tableItemArray, boolean bl2) {
        int n2;
        if (tableItemArray == null) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        if (!this.getDrawing()) {
            return false;
        }
        if (this.currentItem != null) {
            this.fixScrollWidth = true;
            return false;
        }
        GC gC = new GC(this);
        int n3 = 0;
        for (n2 = 0; n2 < tableItemArray.length; ++n2) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem == null) continue;
            n3 = Math.max(n3, tableItem.calculateWidth(0, gC, this.isSelected(this.indexOf(tableItem))));
        }
        gC.dispose();
        if (!bl2 && (n2 = (int)this.firstColumn.width()) >= n3) {
            return false;
        }
        this.firstColumn.setWidth(n3);
        if (this.horizontalBar != null && this.horizontalBar.view != null) {
            this.redrawWidget(this.horizontalBar.view, false);
        }
        return true;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.deselectAll();
        if (0 <= n2 && n2 < this.itemCount) {
            this.select(n2);
            this.showIndex(n2);
        }
    }

    public void setSelection(int n2, int n3) {
        this.checkWidget();
        this.deselectAll();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        if (this.itemCount == 0 || n2 >= this.itemCount) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, this.itemCount - 1);
        this.select(n2, n3);
        this.showIndex(n2);
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = nArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.select(nArray);
        this.showIndex(nArray[0]);
    }

    public void setSelection(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = tableItemArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.indexOf(tableItemArray[n2 - i2 - 1]);
            if (n4 == -1) continue;
            nArray[n3++] = n4;
        }
        if (n3 > 0) {
            this.select(nArray);
            this.showIndex(nArray[0]);
        }
    }

    void setShouldScrollClipView(long l2, long l3, boolean bl2) {
        this.shouldScroll = bl2;
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn == this.sortColumn) {
            return;
        }
        this.setSort(tableColumn, this.sortDirection);
    }

    public void setSortDirection(int n2) {
        this.checkWidget();
        if (n2 != 128 && n2 != 1024 && n2 != 0) {
            return;
        }
        if (n2 == this.sortDirection) {
            return;
        }
        this.setSort(this.sortColumn, n2);
    }

    void setSort(TableColumn tableColumn, int n2) {
        NSImage nSImage = null;
        NSTableColumn nSTableColumn = null;
        if (tableColumn != null) {
            nSTableColumn = tableColumn.nsColumn;
            if (n2 == 1024) {
                nSImage = NSImage.imageNamed(NSString.stringWith("NSDescendingSortIndicator"));
            }
            if (n2 == 128) {
                nSImage = NSImage.imageNamed(NSString.stringWith("NSAscendingSortIndicator"));
            }
        }
        NSTableView nSTableView = (NSTableView)this.view;
        if (this.sortColumn != null && this.sortColumn != tableColumn) {
            nSTableView.setIndicatorImage(null, this.sortColumn.nsColumn);
        }
        nSTableView.setHighlightedTableColumn(nSTableColumn);
        nSTableView.setIndicatorImage(nSImage, nSTableColumn);
        this.sortDirection = n2;
        this.sortColumn = tableColumn;
    }

    void setTableEmpty() {
        this.itemCount = 0;
        this.items = new TableItem[4];
        this.imageBounds = null;
    }

    public void setTopIndex(int n2) {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        int n3 = Math.max(0, Math.min(n2, this.itemCount));
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = this.scrollView.contentView().bounds().x;
        nSPoint.y = nSTableView.frameOfCellAtColumn((long)0L, (long)((long)n3)).y;
        if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 11, 0) && nSTableView.headerView() != null) {
            NSRect nSRect = this.headerView.frame();
            nSPoint.y -= nSRect.y + nSRect.height;
        }
        this.view.scrollPoint(nSPoint);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        if (this.columnCount <= 1) {
            return;
        }
        int n2 = this.indexOf(tableColumn.nsColumn);
        if (0 > n2 || n2 >= this.columnCount + ((this.style & 0x20) != 0 ? 1 : 0)) {
            return;
        }
        ((NSTableView)this.view).scrollColumnToVisible(n2);
    }

    void showIndex(int n2) {
        if (0 <= n2 && n2 < this.itemCount) {
            ((NSTableView)this.view).scrollRowToVisible(n2);
        }
    }

    public void showItem(TableItem tableItem) {
        int n2;
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if ((n2 = this.indexOf(tableItem)) != -1) {
            this.showIndex(n2);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n2 = this.getSelectionIndex();
        if (n2 >= 0) {
            this.checkData(this._getItem(n2));
            this.showIndex(n2);
        }
    }

    void selectRowIndexes_byExtendingSelection(long l2, long l3, long l4, boolean bl2) {
        NSIndexSet nSIndexSet;
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && (nSIndexSet = new NSIndexSet(l4)).count() == 0L) {
            return;
        }
        super.selectRowIndexes_byExtendingSelection(l2, l3, l4, bl2);
    }

    void sendDoubleSelection() {
        NSTableView nSTableView = (NSTableView)this.view;
        int n2 = (int)nSTableView.clickedRow();
        if (n2 == -1) {
            n2 = (int)nSTableView.selectedRow();
        }
        if (n2 != -1) {
            Object object;
            if ((this.style & 0x20) != 0) {
                object = nSTableView.tableColumns();
                int n3 = (int)nSTableView.clickedColumn();
                if (n3 != -1) {
                    id id2 = ((NSArray)object).objectAtIndex(n3);
                    if (id2.id == this.checkColumn.id) {
                        return;
                    }
                }
            }
            object = new Event();
            ((Event)object).item = this._getItem(n2);
            this.sendSelectionEvent(14, (Event)object, false);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n2) {
        boolean bl2 = super.sendKeyEvent(nSEvent, n2);
        if (!bl2) {
            return bl2;
        }
        if (n2 != 1) {
            return bl2;
        }
        short s2 = nSEvent.keyCode();
        switch (s2) {
            case 36: 
            case 76: {
                this.sendDoubleSelection();
            }
        }
        return bl2;
    }

    void sendMeasureItem(TableItem tableItem, int n2, NSSize nSSize, boolean bl2) {
        NSTableView nSTableView = (NSTableView)this.view;
        int n3 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSTableView.intercellSpacing();
        int n4 = (int)Math.ceil(nSTableView.rowHeight() + nSSize2.height);
        GCData gCData = new GCData();
        gCData.paintRect = nSTableView.frame();
        GC gC = GC.cocoa_new(this, gCData);
        gC.setFont(tableItem.getFont(n2));
        Event event = new Event();
        event.item = tableItem;
        event.gc = gC;
        event.index = n2;
        event.width = n3;
        event.height = n4;
        if (bl2 && ((this.style & 0x8000) == 0 || this.hasFocus())) {
            event.detail |= 2;
        }
        this.sendEvent(41, event);
        gC.dispose();
        if (!this.isDisposed() && !tableItem.isDisposed()) {
            nSSize.width = event.width;
            nSSize.height = event.height;
            if (n4 < event.height) {
                nSTableView.setRowHeight(event.height);
            }
            if (n3 != event.width && this.columnCount == 0 && n2 == 0) {
                tableItem.width = event.width;
                if (this.setScrollWidth(tableItem)) {
                    nSTableView.setNeedsDisplay(true);
                }
            }
        }
    }

    void tableViewColumnDidMove(long l2, long l3, long l4) {
        NSNotification nSNotification = new NSNotification(l4);
        NSDictionary nSDictionary = nSNotification.userInfo();
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSOldColumn");
        id id2 = nSDictionary.valueForKey(nSString);
        nSString.release();
        nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSNewColumn");
        id id3 = nSDictionary.valueForKey(nSString);
        nSString.release();
        int n2 = new NSNumber(id2).intValue();
        int n3 = new NSNumber(id3).intValue();
        NSTableView nSTableView = (NSTableView)this.view;
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        NSArray nSArray = nSTableView.tableColumns();
        for (int i2 = n4; i2 <= n5; ++i2) {
            id id4 = nSArray.objectAtIndex(i2);
            TableColumn tableColumn = this.getColumn(id4);
            if (tableColumn == null) continue;
            tableColumn.sendEvent(10);
            if (!this.isDisposed()) continue;
            return;
        }
        this.headerView.setNeedsDisplay(true);
    }

    void tableViewColumnDidResize(long l2, long l3, long l4) {
        NSNotification nSNotification = new NSNotification(l4);
        NSDictionary nSDictionary = nSNotification.userInfo();
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSTableColumn");
        id id2 = nSDictionary.valueForKey(nSString);
        nSString.release();
        TableColumn tableColumn = this.getColumn(id2);
        if (tableColumn == null) {
            return;
        }
        tableColumn.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        int n2 = this.indexOf(tableColumn.nsColumn);
        if (n2 == -1) {
            return;
        }
        NSArray nSArray = nSTableView.tableColumns();
        int n3 = (int)nSTableView.numberOfColumns();
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            id2 = nSArray.objectAtIndex(i2);
            tableColumn = this.getColumn(id2);
            if (tableColumn == null) continue;
            tableColumn.sendEvent(10);
            if (!this.isDisposed()) continue;
            return;
        }
    }

    void sendSelection() {
        if (this.ignoreSelect) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        int n2 = (int)nSTableView.selectedRow();
        if (n2 == -1) {
            this.sendSelectionEvent(13);
        } else {
            TableItem tableItem = this._getItem(n2);
            Event event = new Event();
            event.item = tableItem;
            event.index = n2;
            this.sendSelectionEvent(13, event, false);
        }
    }

    void tableViewSelectionDidChange(long l2, long l3, long l4) {
        if (this.didSelect) {
            return;
        }
        this.sendSelection();
    }

    void tableViewSelectionIsChanging(long l2, long l3, long l4) {
        this.didSelect = true;
        this.sendSelection();
    }

    void tableView_didClickTableColumn(long l2, long l3, long l4, long l5) {
        TableColumn tableColumn = this.getColumn(new id(l5));
        if (tableColumn == null) {
            return;
        }
        tableColumn.sendSelectionEvent(13);
    }

    long tableView_objectValueForTableColumn_row(long l2, long l3, long l4, long l5, long l6) {
        int n2 = (int)l6;
        TableItem tableItem = this._getItem(n2);
        this.checkData(tableItem, n2);
        if (this.checkColumn != null && l5 == this.checkColumn.id) {
            NSNumber nSNumber = tableItem.checked && tableItem.grayed ? NSNumber.numberWithInt(-1) : NSNumber.numberWithInt(tableItem.checked ? 1 : 0);
            return nSNumber.id;
        }
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (this.columns[i2].nsColumn.id != l5) continue;
            return tableItem.createString((int)i2).id;
        }
        return tableItem.createString((int)0).id;
    }

    boolean tableView_shouldReorderColumn_toColumn(long l2, long l3, long l4, long l5, long l6) {
        if ((this.style & 0x20) != 0) {
            if (l5 == 0L) {
                return false;
            }
            if (l6 == 0L) {
                return false;
            }
        }
        NSTableView nSTableView = new NSTableView(l4);
        id id2 = nSTableView.tableColumns().objectAtIndex(l5);
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (this.columns[i2].nsColumn.id != id2.id) continue;
            return this.columns[i2].movable;
        }
        return true;
    }

    boolean tableView_shouldTrackCell_forTableColumn_row(long l2, long l3, long l4, long l5, long l6, long l7) {
        if ((this.style & 0x20) != 0 && new NSCell(l5).isKindOfClass(OS.class_NSButtonCell)) {
            return true;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        return nSTableView.isRowSelected(l7);
    }

    void tableView_setObjectValue_forTableColumn_row(long l2, long l3, long l4, long l5, long l6, long l7) {
        if (this.checkColumn != null && l6 == this.checkColumn.id) {
            TableItem tableItem = this.items[(int)l7];
            tableItem.checked = !tableItem.checked;
            Event event = new Event();
            event.detail = 32;
            event.item = tableItem;
            event.index = (int)l7;
            this.sendSelectionEvent(13, event, false);
            tableItem.redraw(-1);
        }
    }

    void tableView_willDisplayCell_forTableColumn_row(long l2, long l3, long l4, long l5, long l6, long l7) {
        Font font;
        NSColor nSColor;
        if (this.checkColumn != null && l6 == this.checkColumn.id) {
            return;
        }
        TableItem tableItem = this.items[(int)l7];
        int n2 = 0;
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (this.columns[i2].nsColumn.id != l6) continue;
            n2 = i2;
            break;
        }
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(l5);
        OS.object_setInstanceVariable(l5, Display.SWT_ROW, l7);
        OS.object_setInstanceVariable(l5, Display.SWT_COLUMN, l6);
        Image image = n2 == 0 ? tableItem.image : (tableItem.images == null ? null : tableItem.images[n2]);
        nSTextFieldCell.setImage(image != null ? image.handle : null);
        if (nSTextFieldCell.isEnabled()) {
            if (nSTextFieldCell.isHighlighted()) {
                nSColor = NSColor.selectedControlTextColor();
            } else {
                Color color;
                Color color2 = color = tableItem.cellForeground != null ? tableItem.cellForeground[n2] : null;
                if (color == null) {
                    color = tableItem.foreground;
                }
                if (color == null) {
                    color = this.getForegroundColor();
                }
                nSColor = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], 1.0);
            }
        } else {
            nSColor = NSColor.disabledControlTextColor();
        }
        int n3 = (this.style & 0x4000000) != 0 ? 1 : 0;
        int n4 = 0;
        if (this.columnCount > 0) {
            int n5 = this.columns[n2].style;
            if ((n5 & 0x1000000) != 0) {
                n4 = 2;
            } else if ((n5 & 0x20000) != 0) {
                n4 = 1;
            }
        }
        Font font2 = font = tableItem.cellFont != null ? tableItem.cellFont[n2] : null;
        if (font == null) {
            font = tableItem.font;
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.extraTraits != 0) {
            NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
            nSMutableDictionary.setObject(nSColor, OS.NSForegroundColorAttributeName);
            nSMutableDictionary.setObject(font.handle, OS.NSFontAttributeName);
            this.addTraits(nSMutableDictionary, font);
            NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            nSMutableParagraphStyle.setLineBreakMode(2L);
            nSMutableParagraphStyle.setAlignment(n4);
            nSMutableParagraphStyle.setBaseWritingDirection(n3);
            nSMutableDictionary.setObject(nSMutableParagraphStyle, OS.NSParagraphStyleAttributeName);
            nSMutableParagraphStyle.release();
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSTextFieldCell.title(), nSMutableDictionary);
            nSTextFieldCell.setAttributedStringValue(nSAttributedString);
            nSAttributedString.release();
            nSMutableDictionary.release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            nSTextFieldCell.setTextColor(nSColor);
            nSTextFieldCell.setAlignment(n4);
            nSTextFieldCell.setBaseWritingDirection(n3);
        }
    }

    boolean tableView_writeRowsWithIndexes_toPasteboard(long l2, long l3, long l4, long l5, long l6) {
        return this.sendMouseEvent(NSApplication.sharedApplication().currentEvent(), 29, true);
    }

    boolean sendMouseEvent(NSEvent nSEvent, int n2, boolean bl2) {
        if (n2 == 29) {
            this.dragDetected = true;
        } else if (n2 == 4) {
            if (!this.dragDetected && this.selectedRowIndex != -1) {
                NSTableView nSTableView = (NSTableView)this.view;
                NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
                int n3 = (int)nSIndexSet.count();
                long[] lArray = new long[n3];
                nSIndexSet.getIndexes(lArray, n3, 0L);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (lArray[i2] == (long)this.selectedRowIndex) continue;
                    this.ignoreSelect = true;
                    nSTableView.deselectRow(lArray[i2]);
                    this.ignoreSelect = false;
                }
                Event event = new Event();
                event.item = this._getItem(this.selectedRowIndex);
                this.selectedRowIndex = -1;
                this.sendSelectionEvent(13, event, false);
                this.ignoreSelect = true;
            }
            this.dragDetected = false;
        }
        return super.sendMouseEvent(nSEvent, n2, bl2);
    }

    NSRect titleRectForBounds(long l2, long l3, NSRect nSRect) {
        NSImage nSImage = new NSCell(l2).image();
        if (nSImage != null) {
            int n2 = this.imageBounds.width + 3;
            nSRect.x += (double)n2;
            nSRect.width -= (double)n2;
        }
        return nSRect;
    }

    void updateCursorRects(boolean bl2) {
        super.updateCursorRects(bl2);
        if (this.headerView == null) {
            return;
        }
        this.updateCursorRects(bl2, this.headerView);
    }

    void updateRowCount() {
        NSTableView nSTableView = (NSTableView)this.view;
        this.setRedraw(false);
        this.ignoreSelect = true;
        nSTableView.noteNumberOfRowsChanged();
        this.ignoreSelect = false;
        nSTableView.tile();
        this.setRedraw(true);
    }
}

