/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSTabView;
import org.eclipse.swt.internal.cocoa.NSTabViewItem;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTabView;
import org.eclipse.swt.internal.cocoa.SWTTabViewItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    int itemCount;
    boolean ignoreSelect;

    public TabFolder(Composite composite, int n2) {
        super(composite, TabFolder.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        n2 = TabFolder.checkBits(n2, 128, 1024, 0, 0, 0, 0);
        return n2 & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        Point point = super.computeSize(n2, n3, bl2);
        if (n2 == -1 && this.items.length > 0) {
            NSSize nSSize = ((NSTabView)this.view).minimumSize();
            Rectangle rectangle = this.computeTrim(0, 0, (int)Math.ceil(nSSize.width), 0);
            point.x = Math.max(rectangle.width, point.x);
        }
        return point;
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        NSTabView nSTabView = (NSTabView)this.view;
        NSRect nSRect = nSTabView.contentRect();
        n2 = (int)((double)n2 - nSRect.x);
        n3 = (int)((double)n3 - nSRect.y);
        NSRect nSRect2 = nSTabView.frame();
        n4 = (int)((double)n4 + Math.ceil(nSRect2.width - nSRect.width));
        n5 = (int)((double)n5 + Math.ceil(nSRect2.height - nSRect.height));
        return super.computeTrim(n2, n3, n4, n5);
    }

    void createHandle() {
        NSTabView nSTabView = (NSTabView)new SWTTabView().alloc();
        nSTabView.init();
        nSTabView.setDelegate(nSTabView);
        if ((this.style & 0x400) != 0) {
            nSTabView.setTabViewType(2L);
        }
        this.view = nSTabView;
    }

    void createItem(TabItem tabItem, int n2) {
        Object object;
        int n3 = this.itemCount;
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        if (n3 == this.items.length) {
            object = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, object, 0, this.items.length);
            this.items = object;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, n3 - n2);
        this.items[n2] = tabItem;
        ++this.itemCount;
        tabItem.nsItem = object = (NSTabViewItem)new SWTTabViewItem().alloc().init();
        tabItem.createJNIRef();
        tabItem.register();
        ((NSTabView)this.view).insertTabViewItem((NSTabViewItem)object, n2);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    NSFont defaultNSFont() {
        return this.display.tabViewFont;
    }

    void destroyItem(TabItem tabItem) {
        int n2;
        int n3 = this.itemCount;
        for (n2 = 0; n2 < n3 && this.items[n2] != tabItem; ++n2) {
        }
        if (n2 == n3) {
            return;
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --n3 - n2);
        this.items[n3] = null;
        if (n3 == 0) {
            this.items = new TabItem[4];
        }
        this.itemCount = n3;
        ((NSTabView)this.view).removeTabViewItem(tabItem.nsItem);
    }

    void drawBackground(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
    }

    Widget findTooltip(NSPoint nSPoint) {
        NSTabViewItem nSTabViewItem = ((NSTabView)this.view).tabViewItemAtPoint(nSPoint = this.view.convertPoint_fromView_(nSPoint, null));
        if (nSTabViewItem != null) {
            for (int i2 = 0; i2 < this.itemCount; ++i2) {
                TabItem tabItem = this.items[i2];
                if (tabItem.nsItem.id != nSTabViewItem.id) continue;
                return tabItem;
            }
        }
        return super.findTooltip(nSPoint);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        NSRect nSRect = ((NSTabView)this.view).contentRect();
        int n2 = Math.max(0, (int)nSRect.x);
        int n3 = Math.max(0, (int)nSRect.y);
        int n4 = Math.max(0, (int)Math.ceil(nSRect.width));
        int n5 = Math.max(0, (int)Math.ceil(nSRect.height));
        return new Rectangle(n2, n3, n4, n5);
    }

    public TabItem getItem(int n2) {
        this.checkWidget();
        int n3 = this.itemCount;
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        return this.items[n2];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = point.x;
        nSPoint.y = point.y;
        NSTabView nSTabView = (NSTabView)this.view;
        NSTabViewItem nSTabViewItem = nSTabView.tabViewItemAtPoint(nSPoint);
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            NSTabViewItem nSTabViewItem2 = this.items[i2].nsItem;
            if (!nSTabViewItem2.isEqual(nSTabViewItem)) continue;
            return this.items[i2];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n2 = this.itemCount;
        TabItem[] tabItemArray = new TabItem[n2];
        System.arraycopy(this.items, 0, tabItemArray, 0, n2);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n2 = this.getSelectionIndex();
        if (n2 == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n2]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTabViewItem nSTabViewItem = ((NSTabView)this.view).selectedTabViewItem();
        if (nSTabViewItem == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            if (this.items[i2].nsItem.id != nSTabViewItem.id) continue;
            return i2;
        }
        return -1;
    }

    float getThemeAlpha() {
        return (this.background != null ? 1.0f : 0.25f) * this.parent.getThemeAlpha();
    }

    public int indexOf(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        int n2 = this.itemCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.items[i2] != tabItem) continue;
            return i2;
        }
        return -1;
    }

    boolean isTransparent() {
        return true;
    }

    Point minimumSize(int n2, int n3, boolean bl2) {
        Control[] controlArray = this._getChildren();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            SerializableCompatibility serializableCompatibility;
            int n6;
            Control control = controlArray[i2];
            int n7 = this.itemCount;
            for (n6 = 0; n6 < n7 && this.items[n6].control != control; ++n6) {
            }
            if (n6 == n7) {
                serializableCompatibility = control.getBounds();
                n4 = Math.max(n4, serializableCompatibility.x + serializableCompatibility.width);
                n5 = Math.max(n5, serializableCompatibility.y + serializableCompatibility.height);
                continue;
            }
            serializableCompatibility = control.computeSize(n2, n3, bl2);
            n4 = Math.max(n4, ((Point)serializableCompatibility).x);
            n5 = Math.max(n5, ((Point)serializableCompatibility).y);
        }
        return new Point(n4, n5);
    }

    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                TabItem tabItem = this.items[i2];
                if (tabItem == null || tabItem.isDisposed()) continue;
                tabItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl2);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n2 = this.itemCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            TabItem tabItem = this.items[i2];
            if (tabItem.control != control) continue;
            tabItem.setControl(null);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void reskinChildren(int n2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.itemCount; ++i2) {
                TabItem tabItem = this.items[i2];
                if (tabItem == null) continue;
                tabItem.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    void setFont(NSFont nSFont) {
        ((NSTabView)this.view).setFont(nSFont);
        int n2 = this.getSelectionIndex();
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            this.items[i2].updateText(i2 == n2);
        }
    }

    void setForeground(double[] dArray) {
        super.setForeground(dArray);
        int n2 = this.getSelectionIndex();
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            this.items[i2].updateText(i2 == n2);
        }
    }

    public void setSelection(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false, false);
        } else {
            for (int i2 = tabItemArray.length - 1; i2 >= 0; --i2) {
                int n2 = this.indexOf(tabItemArray[i2]);
                if (n2 == -1) continue;
                this.setSelection(n2, false, false);
            }
        }
    }

    public void setSelection(int n2) {
        this.checkWidget();
        int n3 = this.itemCount;
        if (0 > n2 || n2 >= n3) {
            return;
        }
        this.setSelection(n2, false, false);
    }

    void setSelection(int n2, boolean bl2, boolean bl3) {
        Control control;
        TabItem tabItem;
        if (0 > n2 || n2 >= this.itemCount) {
            return;
        }
        int n3 = this.getSelectionIndex();
        if (!bl3 && n3 == n2) {
            return;
        }
        if (n3 != -1 && (tabItem = this.items[n3]) != null && (control = tabItem.control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        this.ignoreSelect = true;
        ((NSTabView)this.view).selectTabViewItemAtIndex(n2);
        this.ignoreSelect = false;
        n2 = this.getSelectionIndex();
        if (n2 != -1 && (tabItem = this.items[n2]) != null) {
            control = tabItem.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(true);
            }
            if (bl2) {
                Event event = new Event();
                event.item = tabItem;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    void setSmallSize() {
        ((NSTabView)this.view).setControlSize(1L);
    }

    boolean traversePage(boolean bl2) {
        int n2 = this.getItemCount();
        if (n2 == 0) {
            return false;
        }
        int n3 = this.getSelectionIndex();
        if (n3 == -1) {
            n3 = 0;
        } else {
            int n4 = bl2 ? 1 : -1;
            n3 = (n3 + n4 + n2) % n2;
        }
        this.setSelection(n3, true, false);
        return n3 == this.getSelectionIndex();
    }

    void tabView_willSelectTabViewItem(long l2, long l3, long l4, long l5) {
        if (l5 == 0L) {
            return;
        }
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            Widget widget;
            TabItem tabItem = this.items[i2];
            if (tabItem.nsItem.id != l5) continue;
            int n2 = this.getSelectionIndex();
            if (n2 != -1 && (widget = this.items[n2]) != null) {
                Control control;
                if (OS.VERSION >= 4208) {
                    ((TabItem)widget).updateText(false);
                }
                if ((control = ((TabItem)widget).control) != null && !control.isDisposed()) {
                    control.setVisible(false);
                }
            }
            if ((widget = tabItem.control) != null && !widget.isDisposed()) {
                ((Control)widget).setVisible(true);
            }
            if (OS.VERSION < 4208) break;
            tabItem.updateText(true);
            break;
        }
    }

    void tabView_didSelectTabViewItem(long l2, long l3, long l4, long l5) {
        if (l5 == 0L) {
            return;
        }
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            Object object;
            TabItem tabItem = this.items[i2];
            Control control = tabItem.control;
            if (control != null && ((NSView)(object = control.topView())).superview() == null) {
                this.contentView().addSubview((NSView)object, -1L, null);
            }
            if (tabItem.nsItem.id != l5 || this.ignoreSelect) continue;
            object = new Event();
            ((Event)object).item = tabItem;
            this.sendSelectionEvent(13, (Event)object, false);
        }
    }
}

