/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RunnableLock;

public class Synchronizer {
    Display display;
    int messageCount;
    RunnableLock[] messages;
    Object messageLock = new Object();
    Thread syncThread;
    static final int GROW_SIZE = 4;
    static final int MESSAGE_LIMIT = 64;
    static final boolean IS_COCOA = "cocoa".equals(SWT.getPlatform());
    static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());

    public Synchronizer(Display display) {
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(RunnableLock runnableLock) {
        boolean bl2 = false;
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messages == null) {
                this.messages = new RunnableLock[4];
            }
            if (this.messageCount == this.messages.length) {
                RunnableLock[] runnableLockArray = new RunnableLock[this.messageCount + 4];
                System.arraycopy(this.messages, 0, runnableLockArray, 0, this.messageCount);
                this.messages = runnableLockArray;
            }
            this.messages[this.messageCount++] = runnableLock;
            bl2 = this.messageCount == 1;
        }
        if (bl2) {
            this.display.wakeThread();
        }
    }

    protected void asyncExec(Runnable runnable) {
        if (runnable == null && !IS_GTK && !IS_COCOA) {
            this.display.wake();
            return;
        }
        this.addLast(new RunnableLock(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMessageCount() {
        Object object = this.messageLock;
        synchronized (object) {
            return this.messageCount;
        }
    }

    void releaseSynchronizer() {
        this.display = null;
        this.messages = null;
        this.messageLock = null;
        this.syncThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RunnableLock removeFirst() {
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messageCount == 0) {
                return null;
            }
            RunnableLock runnableLock = this.messages[0];
            System.arraycopy(this.messages, 1, this.messages, 0, --this.messageCount);
            this.messages[this.messageCount] = null;
            if (this.messageCount == 0 && this.messages.length > 64) {
                this.messages = null;
            }
            return runnableLock;
        }
    }

    boolean runAsyncMessages() {
        return this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean runAsyncMessages(boolean bl2) {
        boolean bl3 = false;
        do {
            block11: {
                RunnableLock runnableLock;
                if ((runnableLock = this.removeFirst()) == null) {
                    return bl3;
                }
                bl3 = true;
                RunnableLock runnableLock2 = runnableLock;
                synchronized (runnableLock2) {
                    block12: {
                        Object var7_6;
                        this.syncThread = runnableLock.thread;
                        this.display.sendPreEvent(0);
                        try {
                            try {
                                runnableLock.run();
                            }
                            catch (Throwable throwable) {
                                runnableLock.throwable = throwable;
                                SWT.error(46, throwable);
                                var7_6 = null;
                                if (this.display != null && !this.display.isDisposed()) {
                                    this.display.sendPostEvent(0);
                                }
                                this.syncThread = null;
                                runnableLock.notifyAll();
                                break block11;
                            }
                            var7_6 = null;
                            if (this.display == null) break block12;
                        }
                        catch (Throwable throwable) {
                            var7_6 = null;
                            if (this.display != null && !this.display.isDisposed()) {
                                this.display.sendPostEvent(0);
                            }
                            this.syncThread = null;
                            runnableLock.notifyAll();
                            throw throwable;
                        }
                        if (!this.display.isDisposed()) {
                            this.display.sendPostEvent(0);
                        }
                    }
                    this.syncThread = null;
                    runnableLock.notifyAll();
                }
            }
        } while (bl2);
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncExec(Runnable runnable) {
        RunnableLock runnableLock = null;
        Object object = Device.class;
        synchronized (Device.class) {
            if (this.display == null || this.display.isDisposed()) {
                SWT.error(45);
            }
            if (!this.display.isValidThread()) {
                if (runnable == null) {
                    this.display.wake();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                runnableLock = new RunnableLock(runnable);
                runnableLock.thread = Thread.currentThread();
                this.addLast(runnableLock);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (runnableLock == null) {
                if (runnable != null) {
                    this.display.sendPreEvent(0);
                    try {
                        runnable.run();
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (this.display != null && !this.display.isDisposed()) {
                            this.display.sendPostEvent(0);
                        }
                        throw throwable;
                    }
                    if (this.display != null && !this.display.isDisposed()) {
                        this.display.sendPostEvent(0);
                    }
                }
                return;
            }
            object = runnableLock;
            synchronized (object) {
                boolean bl2 = false;
                while (!runnableLock.done()) {
                    try {
                        runnableLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    Compatibility.interrupt();
                }
                if (runnableLock.throwable != null) {
                    SWT.error(46, runnableLock.throwable);
                }
            }
            return;
        }
    }
}

