/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSNumberFormatter;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSStepper;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTStepper;
import org.eclipse.swt.internal.cocoa.SWTTextField;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    NSTextField textView;
    NSNumberFormatter textFormatter;
    NSStepper buttonView;
    int pageIncrement = 10;
    int digits = 0;
    int textLimit = LIMIT;
    static int GAP = 0;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Spinner(Composite composite, int n2) {
        super(composite, Spinner.checkStyle(n2));
    }

    boolean acceptsFirstResponder(long l2, long l3) {
        if (l2 == this.view.id) {
            return false;
        }
        return super.acceptsFirstResponder(l2, l3);
    }

    boolean accessibilityIsIgnored(long l2, long l3) {
        if (l2 == this.view.id) {
            return true;
        }
        return super.accessibilityIsIgnored(l2, l3);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n2) {
        return n2 & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        double d2 = 0.0;
        double d3 = 0.0;
        String string = Double.toString(this.buttonView.maxValue());
        Font font = Font.cocoa_new(this.display, this.textView.font());
        NSAttributedString nSAttributedString = this.parent.createString(string, font, null, 0, false, true, false);
        NSSize nSSize = nSAttributedString.size();
        nSAttributedString.release();
        d2 = (float)nSSize.width;
        d3 = (float)nSSize.height;
        if (n2 != -1) {
            d2 = n2;
        }
        if (n3 != -1) {
            d3 = n3;
        }
        Rectangle rectangle = this.computeTrim(0, 0, (int)Math.ceil(d2), (int)Math.ceil(d3));
        if (n3 == -1) {
            nSSize = this.buttonView.cell().cellSize();
            rectangle.height = Math.max(rectangle.height, (int)nSSize.height);
        }
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        NSRect nSRect = this.textView.frame();
        NSCell nSCell = new NSCell(this.textView.cell());
        NSRect nSRect2 = nSCell.drawingRectForBounds(nSRect);
        n4 = (int)((double)n4 + (nSRect.width - nSRect2.width));
        n5 = (int)((double)n5 + (nSRect.height - nSRect2.height));
        n4 += GAP;
        NSSize nSSize = this.buttonView.cell().cellSize();
        return new Rectangle(n2, n3, n4 += (int)nSSize.width, n5);
    }

    public void copy() {
        this.checkWidget();
        NSText nSText = this.textView.currentEditor();
        if (nSText != null) {
            nSText.copy(null);
        }
    }

    void createHandle() {
        NSView nSView = (NSView)new SWTView().alloc();
        nSView.init();
        NSStepper nSStepper = (NSStepper)new SWTStepper().alloc();
        nSStepper.init();
        nSStepper.setValueWraps((this.style & 0x40) != 0);
        nSStepper.setTarget(nSStepper);
        nSStepper.setAction(OS.sel_sendSelection);
        nSStepper.setMaxValue(100.0);
        NSTextField nSTextField = (NSTextField)new SWTTextField().alloc();
        nSTextField.init();
        nSTextField.setEditable((this.style & 8) == 0);
        if ((this.style & 0x800) == 0) {
            nSTextField.setFocusRingType(1L);
            nSTextField.setBordered(false);
        }
        this.textFormatter = (NSNumberFormatter)new NSNumberFormatter().alloc();
        this.textFormatter.init();
        nSView.addSubview(nSTextField);
        nSView.addSubview(nSStepper);
        this.buttonView = nSStepper;
        this.textView = nSTextField;
        this.view = nSView;
        this.setSelection(0, false, true, false);
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        NSText nSText = this.textView.currentEditor();
        if (nSText != null) {
            nSText.cut(null);
        }
    }

    void enableWidget(boolean bl2) {
        super.enableWidget(bl2);
        this.buttonView.setEnabled(bl2);
        this.textView.setEnabled(bl2);
    }

    NSFont defaultNSFont() {
        return this.display.textFieldFont;
    }

    void deregister() {
        super.deregister();
        if (this.textView != null) {
            this.display.removeWidget(this.textView);
            this.display.removeWidget(this.textView.cell());
        }
        if (this.buttonView != null) {
            this.display.removeWidget(this.buttonView);
            this.display.removeWidget(this.buttonView.cell());
        }
    }

    void drawBackground(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        NSText nSText;
        if (this.backgroundImage == null) {
            return;
        }
        if (new NSView(l2).isKindOfClass(OS.class_NSText) && !(nSText = new NSText(l2)).isFieldEditor()) {
            return;
        }
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
    }

    void drawInteriorWithFrame_inView(long l2, long l3, NSRect nSRect, long l4) {
        Image image;
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if ((image = control.backgroundImage) != null && !image.isDisposed()) {
            NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
            control.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
        }
        super.drawInteriorWithFrame_inView(l2, l3, nSRect, l4);
    }

    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        return cursor != null || (this.style & 8) != 0 ? cursor : this.display.getSystemCursor(19);
    }

    NSView focusView() {
        return this.textView;
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    public int getIncrement() {
        this.checkWidget();
        return (int)this.buttonView.increment();
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)this.buttonView.maxValue();
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)this.buttonView.minValue();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return (int)this.buttonView.doubleValue();
    }

    int getSelectionText(boolean[] blArray) {
        String string = this.textView.stringValue().getString();
        try {
            int n2;
            int n3;
            if (this.digits > 0) {
                String string2 = this.textFormatter.decimalSeparator().getString();
                n3 = string.indexOf(string2);
                if (n3 != -1) {
                    int n4;
                    int n5;
                    int n6 = string.startsWith("+") || string.startsWith("-") ? 1 : 0;
                    String string3 = n6 != n3 ? string.substring(n6, n3) : "0";
                    String string4 = string.substring(n3 + 1);
                    if (string4.length() > this.digits) {
                        string4 = string4.substring(0, this.digits);
                    } else {
                        n5 = this.digits - string4.length();
                        for (n4 = 0; n4 < n5; ++n4) {
                            string4 = string4 + "0";
                        }
                    }
                    n5 = Integer.parseInt(string3);
                    n4 = Integer.parseInt(string4);
                    for (int i2 = 0; i2 < this.digits; ++i2) {
                        n5 *= 10;
                    }
                    n2 = n5 + n4;
                    if (string.startsWith("-")) {
                        n2 = -n2;
                    }
                } else {
                    n2 = Integer.parseInt(string);
                    for (int i3 = 0; i3 < this.digits; ++i3) {
                        n2 *= 10;
                    }
                }
            } else {
                n2 = Integer.parseInt(string);
            }
            int n7 = this.getMaximum();
            n3 = this.getMinimum();
            if (n3 <= n2 && n2 <= n7) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        blArray[0] = true;
        return -1;
    }

    public String getText() {
        this.checkWidget();
        NSString nSString = new NSTextFieldCell(this.textView.cell()).title();
        return nSString.getString();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    boolean handleIsAccessible(long l2) {
        return true;
    }

    boolean isEventView(long l2) {
        return true;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        NSText nSText = this.textView.currentEditor();
        if (nSText != null) {
            nSText.paste(null);
        }
    }

    void register() {
        super.register();
        if (this.textView != null) {
            this.display.addWidget(this.textView, this);
            this.display.addWidget(this.textView.cell(), this);
        }
        if (this.buttonView != null) {
            this.display.addWidget(this.buttonView, this);
            this.display.addWidget(this.buttonView.cell(), this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.textFormatter != null) {
            this.textFormatter.release();
        }
        if (this.buttonView != null) {
            this.buttonView.release();
        }
        if (this.textView != null) {
            this.textView.release();
        }
        this.textFormatter = null;
        this.buttonView = null;
        this.textView = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.textView != null) {
            this.textView.abortEditing();
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    void resized() {
        super.resized();
        this.buttonView.sizeToFit();
        NSSize nSSize = this.textView.cell().cellSize();
        NSRect nSRect = this.buttonView.bounds();
        NSRect nSRect2 = this.view.frame();
        nSRect.x = nSRect2.width - nSRect.width;
        nSRect.y = (nSRect2.height - nSRect.height) / 2.0;
        int n2 = (int)Math.min(nSSize.height, nSRect2.height);
        nSRect2.x = 0.0;
        nSRect2.y = (nSRect2.height - (double)n2) / 2.0;
        nSRect2.width -= nSRect.width + (double)GAP;
        nSRect2.height = n2;
        this.textView.setFrame(nSRect2);
        this.buttonView.setFrame(nSRect);
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n2) {
        boolean bl2 = super.sendKeyEvent(nSEvent, n2);
        if (!bl2) {
            return bl2;
        }
        if (n2 != 1) {
            return bl2;
        }
        int n3 = 0;
        short s2 = nSEvent.keyCode();
        switch (s2) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
                return true;
            }
            case 116: {
                n3 = this.pageIncrement;
                break;
            }
            case 121: {
                n3 = -this.pageIncrement;
                break;
            }
            case 125: {
                n3 = -this.getIncrement();
                break;
            }
            case 126: {
                n3 = this.getIncrement();
            }
        }
        if (n3 != 0) {
            boolean[] blArray = new boolean[1];
            int n4 = this.getSelectionText(blArray);
            if (blArray[0]) {
                n4 = (int)this.buttonView.doubleValue();
            }
            int n5 = n4 + n3;
            int n6 = (int)this.buttonView.maxValue();
            int n7 = (int)this.buttonView.minValue();
            if ((this.style & 0x40) != 0) {
                if (n5 > n6) {
                    n5 = n7;
                }
                if (n5 < n7) {
                    n5 = n6;
                }
            }
            if (n4 != (n5 = Math.min(Math.max(n7, n5), n6))) {
                this.setSelection(n5, true, true, true);
            }
            bl2 = false;
        } else {
            int n8;
            boolean[] blArray = new boolean[1];
            int n9 = this.getSelectionText(blArray);
            if (!blArray[0] && (n8 = (int)this.buttonView.doubleValue()) != n9) {
                this.setSelection(n9, true, false, true);
            }
        }
        return bl2;
    }

    void sendSelection() {
        this.setSelection(this.getSelection(), false, true, true);
    }

    void setBackgroundColor(NSColor nSColor) {
        this.textView.setBackgroundColor(nSColor);
    }

    void setBackgroundImage(NSImage nSImage) {
        NSTextField nSTextField = this.textView;
        nSTextField.setDrawsBackground(nSImage == null);
        NSText nSText = nSTextField.window().fieldEditor(true, nSTextField);
        nSText.setDrawsBackground(nSImage == null);
    }

    public void setDigits(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(5);
        }
        if (n2 == this.digits) {
            return;
        }
        this.digits = n2;
        int n3 = (int)this.buttonView.doubleValue();
        this.setSelection(n3, false, true, false);
    }

    void setFont(NSFont nSFont) {
        this.textView.setFont(nSFont);
    }

    void setForeground(double[] dArray) {
        NSColor nSColor = dArray == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], 1.0);
        this.textView.setTextColor(nSColor);
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.buttonView.setIncrement(n2);
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        int n3 = this.getMinimum();
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSelection();
        this.buttonView.setMaxValue(n2);
        if (n4 > n2) {
            this.setSelection(n2, true, true, false);
        }
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        int n3 = this.getMaximum();
        if (n2 > n3) {
            return;
        }
        int n4 = this.getSelection();
        this.buttonView.setMinValue(n2);
        if (n4 < n2) {
            this.setSelection(n2, true, true, false);
        }
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.pageIncrement = n2;
    }

    void setOrientation() {
        int n2 = (this.style & 0x4000000) != 0 ? 1 : 0;
        this.textView.setBaseWritingDirection(n2);
    }

    public void setSelection(int n2) {
        this.checkWidget();
        int n3 = this.getMinimum();
        int n4 = this.getMaximum();
        n2 = Math.min(Math.max(n3, n2), n4);
        this.setSelection(n2, true, true, false);
    }

    void setSelection(int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (bl2) {
            this.buttonView.setDoubleValue(n2);
        }
        if (bl3) {
            Object object;
            int n3;
            Object object2;
            String string = String.valueOf(n2);
            if (this.digits > 0) {
                object2 = this.textFormatter.decimalSeparator().getString();
                n3 = string.length() - this.digits;
                object = new StringBuffer();
                if (n3 > 0) {
                    ((StringBuffer)object).append(string.substring(0, n3));
                    ((StringBuffer)object).append((String)object2);
                    ((StringBuffer)object).append(string.substring(n3));
                } else {
                    ((StringBuffer)object).append("0");
                    ((StringBuffer)object).append((String)object2);
                    while (n3++ < 0) {
                        ((StringBuffer)object).append("0");
                    }
                    ((StringBuffer)object).append(string);
                }
                string = ((StringBuffer)object).toString();
            }
            object2 = new NSCell(this.textView.cell());
            if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, n3 = (int)((NSCell)object2).title().length(), null)) == null) {
                return;
            }
            this.textView.setStringValue(NSString.stringWith(string));
            NSRange nSRange = new NSRange();
            nSRange.location = 0L;
            nSRange.length = string.length();
            object = this.textView.currentEditor();
            if (object != null) {
                ((NSText)object).setSelectedRange(nSRange);
            }
            this.sendEvent(24);
        }
        if (bl4) {
            this.sendSelectionEvent(13);
        }
    }

    void setSmallSize() {
        this.textView.cell().setControlSize(1L);
        this.buttonView.cell().setControlSize(1L);
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        if (n2 == 0) {
            this.error(7);
        }
        this.textLimit = n2;
    }

    public void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        if (n4 < n3) {
            return;
        }
        if (n5 < 0) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        if (n7 < 1) {
            return;
        }
        n2 = Math.min(Math.max(n3, n2), n4);
        this.pageIncrement = n7;
        this.digits = n5;
        this.buttonView.setIncrement(n6);
        this.buttonView.setMaxValue(n4);
        this.buttonView.setMinValue(n3);
        this.setSelection(n2, true, true, false);
    }

    boolean shouldChangeTextInRange_replacementString(long l2, long l3, long l4, long l5) {
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, l4, (long)NSRange.sizeof);
        boolean bl2 = this.callSuperBoolean(l2, l3, nSRange, l5);
        if (this.hooks(25)) {
            String string;
            String string2 = new NSString(l5).getString();
            NSEvent nSEvent = this.display.application.currentEvent();
            long l6 = nSEvent.type();
            if (l6 != 10L && l6 != 11L) {
                nSEvent = null;
            }
            if ((string = this.verifyText(string2, (int)nSRange.location, (int)(nSRange.location + nSRange.length), nSEvent)) == null) {
                return false;
            }
            if (string2 != string) {
                int n2 = string.length();
                NSText nSText = this.textView.currentEditor();
                if (nSText != null) {
                    long l7;
                    NSRange nSRange2 = nSText.selectedRange();
                    if (this.textLimit != LIMIT && (l7 = nSText.string().length()) - nSRange2.length + (long)n2 > (long)this.textLimit) {
                        n2 = (int)((long)this.textLimit - l7 + nSRange2.length);
                    }
                    char[] cArray = new char[n2];
                    string.getChars(0, cArray.length, cArray, 0);
                    NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
                    nSText.replaceCharactersInRange(nSText.selectedRange(), nSString);
                    bl2 = false;
                }
            }
            if (!bl2) {
                this.sendEvent(24);
            }
        }
        return bl2;
    }

    void textDidChange(long l2, long l3, long l4) {
        int n2;
        super.textDidChange(l2, l3, l4);
        boolean[] blArray = new boolean[1];
        int n3 = this.getSelectionText(blArray);
        if (!blArray[0] && n3 != (n2 = (int)this.buttonView.doubleValue())) {
            this.setSelection(n3, true, false, true);
        }
        this.postEvent(24);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long l2, long l3, long l4, long l5, long l6) {
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, l6, (long)NSRange.sizeof);
        return nSRange;
    }

    void textDidEndEditing(long l2, long l3, long l4) {
        boolean[] blArray = new boolean[1];
        int n2 = this.getSelectionText(blArray);
        if (blArray[0]) {
            n2 = (int)this.buttonView.doubleValue();
            this.setSelection(n2, false, true, false);
        }
        super.textDidEndEditing(l2, l3, l4);
    }

    void updateCursorRects(boolean bl2) {
        super.updateCursorRects(bl2);
        this.updateCursorRects(bl2, this.textView);
        this.updateCursorRects(bl2, this.buttonView);
    }

    String verifyText(String string, int n2, int n3, NSEvent nSEvent) {
        Event event = new Event();
        if (nSEvent != null) {
            this.setKeyState(event, 3, nSEvent);
        }
        event.text = string;
        event.start = n2;
        event.end = n3;
        int n4 = 0;
        if (this.digits > 0) {
            String string2 = ".";
            n4 = string.indexOf(string2);
            if (n4 != -1) {
                string = string.substring(0, n4) + string.substring(n4 + 1);
            }
            n4 = 0;
        }
        while (n4 < string.length() && Character.isDigit(string.charAt(n4))) {
            ++n4;
        }
        event.doit = n4 == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

