/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScroller;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    boolean dragging;
    int minimum;
    int maximum;
    int thumb;
    int increment = 1;
    int pageIncrement = 10;

    public Slider(Composite composite, int n2) {
        super(composite, Slider.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return Slider.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            n5 = (int)NSScroller.scrollerWidthForControlSize(((NSScroller)this.view).controlSize());
            n4 = n5 * 10;
        } else {
            n4 = (int)NSScroller.scrollerWidthForControlSize(((NSScroller)this.view).controlSize());
            n5 = n4 * 10;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        return new Point(n4, n5);
    }

    void createHandle() {
        NSScroller nSScroller = (NSScroller)new SWTScroller().alloc();
        NSRect nSRect = new NSRect();
        if ((this.style & 0x100) != 0) {
            nSRect.width = 1.0;
        } else {
            nSRect.height = 1.0;
        }
        nSScroller.initWithFrame(nSRect);
        nSScroller.setEnabled(true);
        nSScroller.setTarget(nSScroller);
        nSScroller.setAction(OS.sel_sendSelection);
        this.view = nSScroller;
        this.updateBar(0, this.minimum, this.maximum, this.thumb);
    }

    void createWidget() {
        this.maximum = 100;
        this.thumb = 10;
        super.createWidget();
    }

    NSFont defaultNSFont() {
        return this.display.scrollerFont;
    }

    void enableWidget(boolean bl2) {
        int n2;
        super.enableWidget(bl2);
        if (bl2 && (n2 = this.maximum - this.thumb - this.minimum) <= 0) {
            ((NSScroller)this.view).setEnabled(false);
        }
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        NSScroller nSScroller = (NSScroller)this.view;
        double d2 = nSScroller.doubleValue();
        return (int)(0.5 + ((double)(this.maximum - this.thumb - this.minimum) * d2 + (double)this.minimum));
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void sendSelection() {
        Event event = new Event();
        int n2 = (int)((NSScroller)this.view).hitPart();
        int n3 = this.getSelection();
        switch (n2) {
            case 4: {
                event.detail = 0x1000001;
                n3 -= this.increment;
                break;
            }
            case 1: {
                n3 -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 5: {
                n3 += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 3: {
                n3 += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 1;
            }
        }
        if (event.detail != 1) {
            this.setSelection(n3);
        }
        this.sendSelectionEvent(13, event, true);
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.increment = n2;
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n2 <= this.minimum) {
            return;
        }
        if (n2 - this.minimum < this.thumb) {
            this.thumb = n2 - this.minimum;
        }
        int n3 = Math.max(this.minimum, Math.min(this.getSelection(), n2 - this.thumb));
        this.maximum = n2;
        this.updateBar(n3, this.minimum, n2, this.thumb);
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n2 >= this.maximum) {
            return;
        }
        if (this.maximum - n2 < this.thumb) {
            this.thumb = this.maximum - n2;
        }
        int n3 = Math.min(this.maximum - this.thumb, Math.max(this.getSelection(), n2));
        this.minimum = n2;
        this.updateBar(n3, n2, this.maximum, this.thumb);
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.pageIncrement = n2;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.updateBar(n2, this.minimum, this.maximum, this.thumb);
    }

    void setSmallSize() {
    }

    void updateBar(int n2, int n3, int n4, int n5) {
        NSScroller nSScroller = (NSScroller)this.view;
        n2 = Math.max(n3, Math.min(n4 - n5, n2));
        int n6 = n4 - n5 - n3;
        float f2 = n6 <= 0 ? 1.0f : (float)(n2 - n3) / (float)n6;
        float f3 = n6 <= 0 ? 1.0f : (float)n5 / (float)(n4 - n3);
        nSScroller.setDoubleValue(f2);
        nSScroller.setKnobProportion(f3);
        nSScroller.setEnabled(n6 > 0);
    }

    public void setThumb(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        n2 = Math.min(n2, this.maximum - this.minimum);
        this.updateBar(this.getSelection(), this.minimum, this.maximum, n2);
        this.thumb = n2;
    }

    public void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        if (n3 < 0) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        if (n7 < 1) {
            return;
        }
        this.thumb = n5 = Math.min(n5, n4 - n3);
        this.maximum = n4;
        this.minimum = n3;
        this.increment = n6;
        this.pageIncrement = n7;
        this.updateBar(n2, n3, n4, n5);
    }
}

