/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSNotificationCenter;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPanel;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSStatusBar;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSTrackingArea;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanel;
import org.eclipse.swt.internal.cocoa.SWTWindow;
import org.eclipse.swt.internal.cocoa.SWTWindowDelegate;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Shell
extends Decorations {
    NSWindow window;
    SWTWindowDelegate windowDelegate;
    long hostWindowClass;
    NSWindow hostWindow;
    long tooltipOwner;
    long tooltipTag;
    long tooltipUserData;
    int glContextCount;
    boolean opened;
    boolean moved;
    boolean resized;
    boolean fullScreen;
    boolean center;
    boolean deferFlushing;
    boolean scrolling;
    boolean isPopup;
    Control lastActive;
    Rectangle normalBounds;
    boolean keyInputHappened;
    NSRect currentFrame;
    NSRect fullScreenFrame;
    ToolBar toolBar;
    Map windowEmbedCounts;
    MenuItem escMenuItem;
    static int DEFAULT_CLIENT_WIDTH = -1;
    static int DEFAULT_CLIENT_HEIGHT = -1;

    public Shell() {
        this((Display)null);
    }

    public Shell(int n2) {
        this((Display)null, n2);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int n2) {
        this(display, null, n2, 0L, false);
    }

    Shell(Display display, Shell shell, int n2, long l2, boolean bl2) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        if (!Display.getSheetEnabled()) {
            this.center = shell != null && (n2 & 0x10000000) != 0;
        }
        this.style = Shell.checkStyle(shell, n2);
        this.parent = shell;
        this.display = display;
        if (l2 != 0L) {
            if (bl2) {
                this.view = new NSView(l2);
            } else {
                this.window = new NSWindow(l2);
                this.state |= 0x20000;
            }
        }
        this.reskinWidget();
        this.createWidget();
    }

    public Shell(Shell shell) {
        this(shell, 2144);
    }

    public Shell(Shell shell, int n2) {
        this(shell != null ? shell.display : null, shell, n2, 0L, false);
    }

    public static Shell internal_new(Display display, long l2) {
        return new Shell(display, null, 8, l2, false);
    }

    public static Shell cocoa_new(Display display, long l2) {
        return new Shell(display, null, 8, l2, true);
    }

    static int checkStyle(Shell shell, int n2) {
        n2 = Decorations.checkStyle(n2);
        int n3 = 229376;
        if (((n2 &= 0xBFFFFFFF) & 0x10000000) != 0) {
            if (Display.getSheetEnabled()) {
                n2 &= 0xFFFFFB1F;
                if (shell == null) {
                    n2 &= 0xEFFFFFFF;
                    n2 |= 0x4F0;
                }
            } else {
                n2 &= 0xEFFFFFFF;
                n2 |= shell == null ? 1264 : 2144;
            }
            if ((n2 & n3) == 0) {
                n2 |= shell == null ? 65536 : 32768;
            }
        }
        int n4 = n2 & ~n3;
        if ((n2 & 0x20000) != 0) {
            return n4 | 0x20000;
        }
        if ((n2 & 0x10000) != 0) {
            return n4 | 0x10000;
        }
        if ((n2 & 0x8000) != 0) {
            return n4 | 0x8000;
        }
        return n4;
    }

    boolean accessibilityIsIgnored(long l2, long l3) {
        if (l2 == this.view.id) {
            return true;
        }
        return super.accessibilityIsIgnored(l2, l3);
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(26, typedListener);
        this.addListener(21, typedListener);
        this.addListener(27, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
    }

    void attachObserversToWindow(NSWindow nSWindow) {
        Integer n2;
        if (nSWindow == null || nSWindow.id == 0L) {
            return;
        }
        long l2 = OS.object_getClass(nSWindow.id);
        long l3 = OS.class_getMethodImplementation(l2, OS.sel_sendEvent_);
        if (l3 == Display.windowCallback3.getAddress()) {
            return;
        }
        this.hostWindow = nSWindow;
        this.hostWindow.retain();
        long l4 = this.display.createWindowSubclass(l2, "SWTAWTWindow", true);
        OS.object_setClass(this.hostWindow.id, l4);
        this.display.addWidget(this.hostWindow, this);
        this.hostWindowClass = l2;
        if (this.windowEmbedCounts == null) {
            this.windowEmbedCounts = new HashMap();
        }
        if ((n2 = (Integer)this.windowEmbedCounts.get(this.hostWindow)) == null) {
            n2 = new Integer(0);
        }
        n2 = new Integer(n2 + 1);
        this.windowEmbedCounts.put(this.hostWindow, n2);
        NSNotificationCenter nSNotificationCenter = NSNotificationCenter.defaultCenter();
        nSNotificationCenter.addObserver(this.windowDelegate, OS.sel_windowDidBecomeKey_, OS.NSWindowDidBecomeKeyNotification, this.hostWindow);
        nSNotificationCenter.addObserver(this.windowDelegate, OS.sel_windowDidDeminiaturize_, OS.NSWindowDidDeminiaturizeNotification, this.hostWindow);
        nSNotificationCenter.addObserver(this.windowDelegate, OS.sel_windowDidMiniaturize_, OS.NSWindowDidMiniaturizeNotification, this.hostWindow);
        nSNotificationCenter.addObserver(this.windowDelegate, OS.sel_windowDidMove_, OS.NSWindowDidMoveNotification, this.hostWindow);
        nSNotificationCenter.addObserver(this.windowDelegate, OS.sel_windowDidResize_, OS.NSWindowDidResizeNotification, this.hostWindow);
        nSNotificationCenter.addObserver(this.windowDelegate, OS.sel_windowDidResignKey_, OS.NSWindowDidResignKeyNotification, this.hostWindow);
        nSNotificationCenter.addObserver(this.windowDelegate, OS.sel_windowWillClose_, OS.NSWindowWillCloseNotification, this.hostWindow);
    }

    void becomeKeyWindow(long l2, long l3) {
        Shell shell = this.getModalShell();
        if (shell != null && shell.window != null) {
            shell.window.makeKeyAndOrderFront(null);
            return;
        }
        Display display = this.display;
        display.keyWindow = this.view.window();
        super.becomeKeyWindow(l2, l3);
        display.checkFocus();
        display.keyWindow = null;
    }

    void bringToTop(boolean bl2) {
        if (this.getMinimized()) {
            return;
        }
        if (bl2) {
            this.forceActive();
        } else {
            this.setActive();
        }
    }

    boolean canBecomeKeyWindow(long l2, long l3) {
        if (this.isPopup) {
            return false;
        }
        if (this.window != null) {
            NSView nSView;
            NSView nSView2;
            NSEvent nSEvent;
            if ((this.style & 0x80000) != 0 && (nSEvent = NSApplication.sharedApplication().currentEvent()) != null && nSEvent.type() == 1L && (nSView2 = this.window.contentView()) != null && (nSView = nSView2.hitTest(nSEvent.locationInWindow())) == nSView2) {
                return false;
            }
            long l4 = this.window.styleMask();
            if (l4 == 0L || (l4 & 0xC8L) != 0L) {
                return true;
            }
        }
        return super.canBecomeKeyWindow(l2, l3);
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.display.map((Control)this.parent, null, this.parent.getClientArea());
        int n2 = Math.max(rectangle2.x, rectangle2.x + (rectangle2.width - rectangle.width) / 2);
        int n3 = Math.max(rectangle2.y, rectangle2.y + (rectangle2.height - rectangle.height) / 2);
        Rectangle rectangle3 = this.parent.getMonitor().getClientArea();
        n2 = n2 + rectangle.width > rectangle3.x + rectangle3.width ? Math.max(rectangle3.x, rectangle3.x + rectangle3.width - rectangle.width) : Math.max(n2, rectangle3.x);
        n3 = n3 + rectangle.height > rectangle3.y + rectangle3.height ? Math.max(rectangle3.y, rectangle3.y + rectangle3.height - rectangle.height) : Math.max(n3, rectangle3.y);
        this.setLocation(n2, n3);
    }

    void clearDeferFlushing(long l2, long l3) {
        this.deferFlushing = false;
        this.scrolling = false;
        if (this.window != null) {
            this.window.flushWindowIfNeeded();
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget(false);
    }

    void closeWidget(boolean bl2) {
        if (this.display.isDisposed()) {
            return;
        }
        Event event = new Event();
        this.sendEvent(21, event);
        if ((bl2 || event.doit) && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        Point point = super.computeSize(n2, n3, bl2);
        if (this.toolBar != null && n2 == -1 && this.toolBar.itemCount > 0) {
            Point point2 = this.toolBar.computeSize(-1, -1);
            point.x = Math.max(point2.x, point.x);
        }
        return point;
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n2, n3, n4, n5);
        NSRect nSRect = new NSRect();
        nSRect.x = rectangle.x;
        nSRect.y = rectangle.y;
        nSRect.width = rectangle.width;
        nSRect.height = rectangle.height;
        if (this.window != null && !this._getFullScreen() && !this.fixResize()) {
            double d2 = nSRect.height;
            nSRect = this.window.frameRectForContentRect(nSRect);
            nSRect.y += d2 - nSRect.height;
        }
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    void createHandle() {
        NSWindow nSWindow;
        NSObject nSObject;
        this.state |= 0x10;
        if (this.window == null && this.view == null) {
            Object object;
            int n2 = 0;
            if ((this.style & 0x10000004) != 0) {
                this.window = (NSWindow)new SWTPanel().alloc();
                n2 = (this.style & 0x10000000) != 0 ? (n2 |= 0x40) : (n2 |= 0x90);
            } else {
                this.window = (NSWindow)new SWTWindow().alloc();
            }
            if ((this.style & 8) == 0) {
                if ((this.style & 0x20) != 0) {
                    n2 |= 1;
                }
                if ((this.style & 0x40) != 0) {
                    n2 |= 2;
                }
                if ((this.style & 0x80) != 0) {
                    n2 |= 4;
                }
                if ((this.style & 0x400) != 0) {
                    n2 |= 8;
                }
                if ((this.style & 0x10) != 0) {
                    n2 |= 8;
                }
            }
            nSObject = null;
            NSScreen nSScreen = new NSScreen(NSScreen.screens().objectAtIndex(0L));
            if (this.parent != null) {
                nSObject = this.parentWindow().screen();
            }
            if (nSObject == null) {
                nSObject = nSScreen;
            }
            this.window = this.window.initWithContentRect(new NSRect(), n2, 2L, (this.style & 0x4000) != 0, (NSScreen)nSObject);
            if ((this.style & 0xCF8) == 0 || (this.style & 0x10000004) != 0) {
                this.window.setHasShadow(true);
            }
            if ((this.style & 4) != 0) {
                ((NSPanel)this.window).setFloatingPanel(false);
                ((NSPanel)this.window).setHidesOnDeactivate(false);
                ((NSPanel)this.window).setBecomesKeyOnlyIfNeeded(false);
            }
            this.window.setReleasedWhenClosed(true);
            if ((this.style & 8) == 0) {
                object = this.window.minSize();
                ((NSSize)object).width = NSWindow.minFrameWidthWithTitle(NSString.string(), n2);
                this.window.setMinSize((NSSize)object);
            }
            if (this.fixResize() && this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 0);
            }
            this.display.cascadeWindow(this.window, (NSScreen)nSObject);
            object = ((NSScreen)nSObject).frame();
            double d2 = ((NSRect)object).width * 5.0 / 8.0;
            double d3 = ((NSRect)object).height * 5.0 / 8.0;
            NSRect nSRect = this.window.frame();
            NSRect nSRect2 = nSScreen.frame();
            nSRect.y = nSRect2.height - (nSRect2.height - (nSRect.y + nSRect.height) + d3);
            nSRect.width = d2;
            nSRect.height = d3;
            this.window.setFrame(nSRect, false);
            if ((this.style & 0x4000) != 0) {
                this.window.setLevel(25L);
            }
            super.createHandle();
            this.topView().setHidden(true);
        } else {
            this.state &= 0xFFFFFFEF;
            if (this.window != null) {
                this.view = this.window.contentView();
                if (this.view == null) {
                    super.createHandle();
                } else {
                    this.view.retain();
                }
            } else {
                NSView nSView = this.view;
                super.createHandle();
                nSView.addSubview(this.topView());
            }
            this.style |= 0x40000;
        }
        this.windowDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        if (this.window == null) {
            NSWindow nSWindow2 = this.view.window();
            this.attachObserversToWindow(nSWindow2);
        } else {
            int n3 = 0;
            if (this.parent != null) {
                n3 |= 2;
            }
            if (OS.VERSION >= 4208 && this.parent == null) {
                n3 = (this.style & 4) != 0 ? 256 : 128;
            }
            if (n3 != 0) {
                this.window.setCollectionBehavior(n3);
            }
            this.window.setAcceptsMouseMovedEvents(true);
            this.window.setDelegate(this.windowDelegate);
        }
        if (OS.VERSION < 4192 && this.window != null) {
            this.window.windowRef();
        }
        if ((nSWindow = this.window) == null) {
            nSWindow = this.view.window();
        }
        if ((nSObject = nSWindow.fieldEditor(true, null)) != null) {
            OS.object_setClass(nSObject.id, OS.objc_getClass("SWTEditorView"));
            new NSTextView(nSObject).setAllowsUndo(true);
        }
    }

    void deferFlushing() {
        this.deferFlushing = true;
        this.view.performSelector(OS.sel_clearDeferFlushing, null, 0.0, this.display.runLoopModes());
    }

    void deregister() {
        super.deregister();
        if (this.window != null) {
            this.display.removeWidget(this.window);
        }
        if (this.windowDelegate != null) {
            this.display.removeWidget(this.windowDelegate);
        }
    }

    void destroyWidget() {
        NSWindow nSWindow = this.window;
        if (nSWindow != null) {
            nSWindow.retain();
        }
        Display display = this.display;
        NSView nSView = this.topView();
        if (nSView != null) {
            nSView.retain();
        }
        boolean bl2 = (this.style & 0x10000000) != 0;
        this.releaseHandle();
        if (nSWindow != null) {
            if (bl2) {
                NSApplication nSApplication = NSApplication.sharedApplication();
                nSApplication.endSheet(nSWindow, 0L);
            }
            nSWindow.close();
        } else if (nSView != null) {
            nSView.removeFromSuperview();
        }
        if (nSView != null) {
            nSView.release();
        }
        if (nSWindow != null) {
            if (!display.isDisposed() && display.getShells().length == 0) {
                display.setMenuBar(null);
            }
            nSWindow.release();
        }
    }

    void drawBackground(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l2 != this.view.id) {
            return;
        }
        if (this.regionPath != null && this.background == null) {
            nSGraphicsContext.saveGraphicsState();
            NSColor.windowBackgroundColor().setFill();
            NSBezierPath.fillRect(nSRect);
            nSGraphicsContext.restoreGraphicsState();
            return;
        }
        super.drawBackground(l2, nSGraphicsContext, nSRect);
    }

    Control findBackgroundControl() {
        return this.background != null || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    Cursor findCursor() {
        return this.cursor;
    }

    boolean fixResize() {
        if (this.window == null) {
            return false;
        }
        return (this.style & 8) == 0 && (this.style & 0x10) != 0 && (this.style & 0x100004E0) == 0;
    }

    void fixShell(Shell shell, Control control) {
        if (this == shell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
    }

    public void forceActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        if (this.window == null) {
            return;
        }
        this.makeKeyAndOrderFront();
        NSApplication nSApplication = NSApplication.sharedApplication();
        nSApplication.activateIgnoringOtherApps(true);
    }

    public int getAlpha() {
        this.checkWidget();
        if (this.window == null) {
            return 255;
        }
        return (int)(this.window.alphaValue() * 255.0);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.window != null) {
            NSRect nSRect = this.window.frame();
            double d2 = this.display.getPrimaryFrame().height - (double)((int)(nSRect.y + nSRect.height));
            Rectangle rectangle = new Rectangle((int)nSRect.x, (int)d2, (int)nSRect.width, (int)nSRect.height);
            double d3 = this.view.window().userSpaceScaleFactor();
            rectangle.x = (int)((double)rectangle.x / d3);
            rectangle.y = (int)((double)rectangle.y / d3);
            rectangle.width = (int)((double)rectangle.width / d3);
            rectangle.height = (int)((double)rectangle.height / d3);
            return rectangle;
        }
        NSRect nSRect = this.view.frame();
        NSPoint nSPoint = new NSPoint();
        NSRect nSRect2 = this.display.getPrimaryFrame();
        if (!this.view.isFlipped()) {
            nSPoint.y = this.view.bounds().height - nSPoint.y;
        }
        nSPoint = this.view.convertPoint_toView_(nSPoint, null);
        nSPoint = this.view.window().convertBaseToScreen(nSPoint);
        nSPoint.y = nSRect2.height - nSPoint.y;
        return new Rectangle((int)nSPoint.x, (int)nSPoint.y, (int)nSRect.width, (int)nSRect.height);
    }

    public Rectangle getClientArea() {
        NSRect nSRect;
        this.checkWidget();
        if (this.window != null) {
            if (!this.fixResize()) {
                nSRect = this.window.contentView().frame();
            } else {
                double d2 = this.window.userSpaceScaleFactor();
                nSRect = this.window.frame();
                nSRect.width /= d2;
                nSRect.height /= d2;
            }
        } else {
            nSRect = this.topView().frame();
        }
        int n2 = (int)nSRect.width;
        int n3 = (int)nSRect.height;
        if (this.scrollView != null) {
            NSSize nSSize = new NSSize();
            nSSize.width = n2;
            nSSize.height = n3;
            nSSize = NSScrollView.contentSizeForFrameSize(nSSize, (this.style & 0x100) != 0, (this.style & 0x200) != 0, 0L);
            n2 = (int)nSSize.width;
            n3 = (int)nSSize.height;
        }
        return new Rectangle(0, 0, n2, n3);
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this._getFullScreen();
    }

    boolean _getFullScreen() {
        if ((this.window.collectionBehavior() & 0x80L) != 0L) {
            return (this.window.styleMask() & 0x4000L) != 0L;
        }
        return this.fullScreen;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public Point getLocation() {
        this.checkWidget();
        if (this.window != null) {
            NSRect nSRect = this.window.frame();
            double d2 = this.display.getPrimaryFrame().height - (double)((int)(nSRect.y + nSRect.height));
            Point point = new Point((int)nSRect.x, (int)d2);
            double d3 = this.view.window().userSpaceScaleFactor();
            point.x = (int)((double)point.x / d3);
            point.y = (int)((double)point.y / d3);
            return point;
        }
        NSPoint nSPoint = new NSPoint();
        NSRect nSRect = this.display.getPrimaryFrame();
        if (!this.view.isFlipped()) {
            nSPoint.y = this.view.bounds().height - nSPoint.y;
        }
        nSPoint = this.view.convertPoint_toView_(nSPoint, null);
        nSPoint = this.view.window().convertBaseToScreen(nSPoint);
        nSPoint.y = nSRect.height - nSPoint.y;
        double d4 = this.view.window().userSpaceScaleFactor();
        nSPoint.x /= d4;
        nSPoint.y /= d4;
        return new Point((int)nSPoint.x, (int)nSPoint.y);
    }

    public boolean getMaximized() {
        this.checkWidget();
        if (this.window == null) {
            return false;
        }
        return !this._getFullScreen() && this.window.isZoomed();
    }

    Shell getModalShell() {
        Shell shell = null;
        Shell[] shellArray = this.display.modalShells;
        if (shellArray != null) {
            int n2 = 196608;
            int n3 = shellArray.length;
            while (--n3 >= 0) {
                Shell shell2 = shellArray[n3];
                if (shell2 == null) continue;
                if ((shell2.style & n2) != 0) {
                    Composite composite = this;
                    while (composite != null && composite != shell2) {
                        composite = composite.parent;
                    }
                    if (composite == shell2) break;
                    return shell2;
                }
                if ((shell2.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (shell2.parent != shell) continue;
                return shell2;
            }
        }
        return null;
    }

    public boolean getModified() {
        this.checkWidget();
        return this.window.isDocumentEdited();
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (!this.getVisible()) {
            return super.getMinimized();
        }
        if (this.window == null) {
            return false;
        }
        return this.window.isMiniaturized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        if (this.window == null) {
            return new Point(0, 0);
        }
        NSSize nSSize = this.window.minSize();
        return new Point((int)nSSize.width, (int)nSSize.height);
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        int n2;
        this.checkWidget();
        int n3 = 0;
        Shell[] shellArray2 = this.display.getShells();
        for (n2 = 0; n2 < shellArray2.length; ++n2) {
            shellArray = shellArray2[n2];
            while ((shellArray = shellArray.parent) != null && shellArray != this) {
            }
            if (shellArray != this) continue;
            ++n3;
        }
        n2 = 0;
        shellArray = new Shell[n3];
        for (int i2 = 0; i2 < shellArray2.length; ++i2) {
            Composite composite = shellArray2[i2];
            while ((composite = composite.parent) != null && composite != this) {
            }
            if (composite != this) continue;
            shellArray[n2++] = shellArray2[i2];
        }
        return shellArray;
    }

    public Point getSize() {
        this.checkWidget();
        NSRect nSRect = this.window != null ? this.window.frame() : this.view.frame();
        Point point = new Point((int)nSRect.width, (int)nSRect.height);
        double d2 = this.view.window().userSpaceScaleFactor();
        point.x = (int)((double)point.x / d2);
        point.y = (int)((double)point.y / d2);
        return point;
    }

    float getThemeAlpha() {
        return 1.0f;
    }

    public ToolBar getToolBar() {
        this.checkWidget();
        if ((this.style & 8) == 0 && this.toolBar == null) {
            this.toolBar = new ToolBar(this, 65792, true);
        }
        return this.toolBar;
    }

    boolean hasBorder() {
        return false;
    }

    boolean hasRegion() {
        return this.region != null;
    }

    void helpRequested(long l2, long l3, long l4) {
        Control control = this.display.getFocusControl();
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                break;
            }
            control = control.parent;
        }
    }

    void invalidateVisibleRegion() {
        this.resetVisibleRegion();
        if (this.toolBar != null) {
            this.toolBar.resetVisibleRegion();
        }
        this.invalidateChildrenVisibleRegion();
    }

    boolean isDrawing() {
        return this.getDrawing();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isEnabledCursor() {
        return true;
    }

    boolean isResizing() {
        return (this.state & 0x80000) != 0;
    }

    boolean isTransparent() {
        return false;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    boolean makeFirstResponder(long l2, long l3, long l4) {
        Display display = this.display;
        boolean bl2 = super.makeFirstResponder(l2, l3, l4);
        if (!display.isDisposed()) {
            display.checkFocus();
        }
        return bl2;
    }

    void makeKeyAndOrderFront() {
        NSWindow nSWindow;
        if (this.parent != null && (nSWindow = this.parentWindow()).isMiniaturized()) {
            nSWindow.deminiaturize(null);
        }
        this.window.makeKeyAndOrderFront(null);
    }

    void mouseMoved(long l2, long l3, long l4) {
        super.mouseMoved(l2, l3, l4);
        if (l2 == this.view.id && this.window == null) {
            this.view.window().mouseMoved(new NSEvent(l4));
        }
    }

    void noResponderFor(long l2, long l3, long l4) {
        if (l4 != OS.sel_keyDown_) {
            super.noResponderFor(l2, l3, l4);
        }
    }

    public void open() {
        this.checkWidget();
        int n2 = 229376;
        if ((this.style & n2) != 0) {
            this.display.setModalShell(this);
        } else {
            this.updateModal();
        }
        this.bringToTop(false);
        this.setWindowVisible(true, true);
        if (this.isDisposed()) {
            return;
        }
        if (!(this.restoreFocus() || this.traverseGroup(true) || this.parent != null && this.parentWindow().isMiniaturized())) {
            this.setFocus();
        }
    }

    NSWindow parentWindow() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.view.window();
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    void register() {
        super.register();
        if (this.window != null) {
            this.display.addWidget(this.window, this);
        }
        if (this.windowDelegate != null) {
            this.display.addWidget(this.windowDelegate, this);
        }
    }

    void releaseChildren(boolean bl2) {
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            Shell shell = shellArray[i2];
            if (shell == null || shell.isDisposed()) continue;
            shell.dispose();
        }
        super.releaseChildren(bl2);
    }

    void releaseHandle() {
        if (this.window != null) {
            this.window.setDelegate(null);
        }
        this.removeObserversFromWindow();
        if (this.windowDelegate != null) {
            this.windowDelegate.release();
        }
        this.windowDelegate = null;
        super.releaseHandle();
        this.window = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.toolBar != null) {
            this.toolBar.dispose();
            this.toolBar = null;
        }
        if (this.tooltipTag != 0L) {
            this.view.window().contentView().removeToolTip(this.tooltipTag);
            this.tooltipTag = 0L;
        }
        this.display.clearModal(this);
        this.updateParent(false);
        this.display.updateQuitMenu();
        this.lastActive = null;
    }

    void removeObserversFromWindow() {
        NSNotificationCenter.defaultCenter().removeObserver(this.windowDelegate);
        if (this.hostWindow != null) {
            Integer n2 = (Integer)this.windowEmbedCounts.get(this.hostWindow);
            if (n2 == null) {
                n2 = new Integer(0);
            }
            n2 = new Integer(n2 - 1);
            this.windowEmbedCounts.put(this.hostWindow, n2);
            if (n2 <= 0) {
                this.windowEmbedCounts.remove(this.hostWindow);
                if (this.hostWindowClass != 0L) {
                    OS.object_setClass(this.hostWindow.id, this.hostWindowClass);
                }
                this.display.removeWidget(this.hostWindow);
                this.hostWindow.release();
                this.hostWindow = null;
                this.hostWindowClass = 0L;
            }
        }
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(27, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
    }

    void reskinChildren(int n2) {
        if (this.toolBar != null) {
            this.toolBar.reskin(n2);
        }
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            Shell shell = shellArray[i2];
            if (shell == null) continue;
            shell.reskin(n2);
        }
        super.reskinChildren(n2);
    }

    void sendToolTipEvent(boolean bl2) {
        NSObject nSObject;
        Object object;
        if (!this.isVisible()) {
            return;
        }
        NSWindow nSWindow = this.view.window();
        if (this.tooltipTag == 0L) {
            object = nSWindow.contentView();
            this.tooltipTag = ((NSView)object).addToolTipRect(new NSRect(), nSWindow, 0L);
            if (this.tooltipTag != 0L) {
                NSDictionary nSDictionary;
                nSObject = new NSTrackingArea(this.tooltipTag);
                id id2 = nSObject.owner();
                if (id2 != null) {
                    this.tooltipOwner = id2.id;
                }
                if ((nSDictionary = nSObject.userInfo()) != null) {
                    this.tooltipUserData = nSDictionary.id;
                } else {
                    long[] lArray = new long[1];
                    OS.object_getInstanceVariable(this.tooltipTag, new byte[]{95, 117, 115, 101, 114, 73, 110, 102, 111}, lArray);
                    this.tooltipUserData = lArray[0];
                }
            }
        }
        if (this.tooltipTag == 0L || this.tooltipOwner == 0L || this.tooltipUserData == 0L) {
            return;
        }
        object = nSWindow.convertScreenToBase(NSEvent.mouseLocation());
        nSObject = NSEvent.enterExitEventWithType(bl2 ? 8L : 9L, (NSPoint)object, 0L, 0.0, nSWindow.windowNumber(), null, 0L, this.tooltipTag, this.tooltipUserData);
        OS.objc_msgSend(this.tooltipOwner, bl2 ? OS.sel_mouseEntered_ : OS.sel_mouseExited_, ((NSEvent)nSObject).id);
    }

    public void setActive() {
        if (this.window == null) {
            return;
        }
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        this.makeKeyAndOrderFront();
    }

    void setActiveControl(Control control) {
        this.setActiveControl(control, 0);
    }

    void setActiveControl(Control control, int n2) {
        int n3;
        int n4;
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n5 = Math.min(controlArray.length, controlArray2.length);
        for (n4 = 0; n4 < n5 && controlArray[n4] == controlArray2[n4]; ++n4) {
        }
        for (n3 = controlArray2.length - 1; n3 >= n4; --n3) {
            if (controlArray2[n3].isDisposed()) continue;
            controlArray2[n3].sendEvent(27);
        }
        for (n3 = controlArray.length - 1; n3 >= n4; --n3) {
            if (controlArray[n3].isDisposed()) continue;
            Event event = new Event();
            event.detail = n2;
            controlArray[n3].sendEvent(26, event);
        }
    }

    public void setAlpha(int n2) {
        if (this.window == null) {
            return;
        }
        this.checkWidget();
        this.window.setAlphaValue((float)(n2 &= 0xFF) / 255.0f);
    }

    void setBounds(int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        Object object;
        boolean bl4;
        if (this.window == null) {
            if (bl2) {
                return;
            }
            if (bl3) {
                NSSize nSSize = new NSSize();
                nSSize.width = n4;
                nSSize.height = n5;
                this.view.setFrameSize(nSSize);
                return;
            }
        }
        if (this._getFullScreen()) {
            this.setFullScreen(false);
        }
        if ((bl4 = this.window.isSheet()) && bl2 && !bl3) {
            return;
        }
        int n6 = (int)this.display.getPrimaryFrame().height;
        double d2 = this.window.userSpaceScaleFactor();
        n2 = (int)((double)n2 * d2);
        n3 = (int)((double)n3 * d2);
        n4 = (int)((double)n4 * d2);
        n5 = (int)((double)n5 * d2);
        NSRect nSRect = this.window.frame();
        if (!bl2) {
            n2 = (int)nSRect.x;
            n3 = n6 - (int)(nSRect.y + nSRect.height);
        }
        if (bl3) {
            object = this.window.minSize();
            n4 = Math.max(n4, (int)((NSSize)object).width);
            n5 = Math.max(n5, (int)((NSSize)object).height);
        } else {
            n4 = (int)nSRect.width;
            n5 = (int)nSRect.height;
        }
        if (bl4) {
            n3 = n6 - (int)(nSRect.y + nSRect.height);
            object = this.parent.getShell().window.frame();
            nSRect.width = n4;
            nSRect.height = n5;
            nSRect.x = ((NSRect)object).x + (((NSRect)object).width - nSRect.width) / 2.0;
            nSRect.y = n6 - (int)((double)n3 + nSRect.height);
            this.window.setFrame(nSRect, this.isVisible(), true);
        } else {
            nSRect.x = n2;
            nSRect.y = n6 - (n3 + n5);
            nSRect.width = n4;
            nSRect.height = n5;
            this.window.setFrame(nSRect, this.isVisible());
        }
    }

    void setClipRegion(NSView nSView) {
        if (this.regionPath != null) {
            NSView nSView2 = this.topView();
            if (!nSView2.isFlipped()) {
                nSView2 = this.eventView();
            }
            NSPoint nSPoint = nSView.convertPoint_toView_(new NSPoint(), nSView2);
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(-nSPoint.x, -nSPoint.y);
            this.regionPath.transformUsingAffineTransform(nSAffineTransform);
            this.regionPath.addClip();
            nSAffineTransform.translateXBy(2.0 * nSPoint.x, 2.0 * nSPoint.y);
            this.regionPath.transformUsingAffineTransform(nSAffineTransform);
        }
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        if ((this.state & 8) == 0 == bl2) {
            return;
        }
        super.setEnabled(bl2);
        if (bl2 && this.window != null && this.window.isMainWindow() && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setFullScreen(boolean bl2) {
        this.checkWidget();
        if (this.window == null) {
            return;
        }
        if (this._getFullScreen() == bl2) {
            return;
        }
        if ((this.window.collectionBehavior() & 0x80L) != 0L) {
            OS.objc_msgSend(this.window.id, OS.sel_toggleFullScreen_, 0);
            return;
        }
        this.fullScreen = bl2;
        if (bl2) {
            this.currentFrame = this.window.frame();
            this.window.setShowsResizeIndicator(false);
            if (this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 0);
            }
            this.fullScreenFrame = NSScreen.mainScreen().frame();
            if (this.getMonitor().equals(this.display.getPrimaryMonitor())) {
                if (this.menuBar != null) {
                    double d2 = NSStatusBar.systemStatusBar().thickness();
                    this.fullScreenFrame.height -= d2;
                    OS.SetSystemUIMode(2, 0);
                } else {
                    OS.SetSystemUIMode(3, 0);
                }
            }
            this.window.setFrame(this.fullScreenFrame, true);
            NSRect nSRect = new NSRect();
            nSRect.width = this.fullScreenFrame.width;
            nSRect.height = this.fullScreenFrame.height;
            this.window.contentView().setFrame(nSRect);
        } else {
            this.window.setShowsResizeIndicator(true);
            if (this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 1);
            }
            OS.SetSystemUIMode(0, 0);
            this.window.setFrame(this.currentFrame, true);
        }
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        super.setMenuBar(menu);
        if (this.display.getActiveShell() == this) {
            this.display.setMenuBar(this.menuBar);
        }
    }

    public void setImeInputMode(int n2) {
        this.checkWidget();
    }

    public void setMaximized(boolean bl2) {
        this.checkWidget();
        super.setMaximized(bl2);
        if (this.window == null) {
            return;
        }
        if (this.window.isZoomed() == bl2) {
            return;
        }
        this.window.zoom(null);
    }

    public void setMinimized(boolean bl2) {
        this.checkWidget();
        super.setMinimized(bl2);
        if (this.window == null) {
            return;
        }
        if (!this.getVisible()) {
            return;
        }
        if (bl2) {
            this.window.miniaturize(null);
        } else {
            this.window.deminiaturize(null);
        }
    }

    public void setMinimumSize(int n2, int n3) {
        this.checkWidget();
        if (this.window == null) {
            return;
        }
        NSSize nSSize = new NSSize();
        nSSize.width = n2;
        nSSize.height = n3;
        this.window.setMinSize(nSSize);
        NSRect nSRect = this.window.frame();
        if ((double)n2 > nSRect.width || (double)n3 > nSRect.height) {
            n2 = (int)((double)n2 > nSRect.width ? (double)n2 : nSRect.width);
            n3 = (int)((double)n3 > nSRect.height ? (double)n3 : nSRect.height);
            this.setBounds(0, 0, n2, n3, false, true);
        }
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    public void setModified(boolean bl2) {
        this.checkWidget();
        this.window.setDocumentEdited(bl2);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.window == null) {
            return;
        }
        if (region != null) {
            if (region.isDisposed()) {
                this.error(5);
            }
            Rectangle rectangle = region.getBounds();
            this.setSize(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
        this.region = region;
        if (this.regionPath != null) {
            this.regionPath.release();
        }
        this.regionPath = this.getPath(region);
        if (region != null) {
            this.window.setBackgroundColor(NSColor.clearColor());
        } else {
            this.window.setBackgroundColor(NSColor.windowBackgroundColor());
        }
        this.updateOpaque();
        this.window.contentView().setNeedsDisplay(true);
        if (this.isVisible() && this.window.hasShadow()) {
            this.window.display();
            this.window.invalidateShadow();
        }
    }

    void setScrolling() {
        this.scrolling = true;
        this.view.performSelector(OS.sel_clearDeferFlushing, null, 0.0, this.display.runLoopModes());
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.window == null) {
            return;
        }
        super.setText(string);
        NSString nSString = NSString.stringWith(string);
        this.window.setTitle(nSString);
    }

    public void setVisible(boolean bl2) {
        this.checkWidget();
        int n2 = 229376;
        if ((this.style & n2) != 0) {
            if (bl2) {
                this.display.setModalShell(this);
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
        if (this.window == null) {
            super.setVisible(bl2);
        } else {
            this.setWindowVisible(bl2, false);
        }
    }

    void setWindowVisible(boolean bl2, boolean bl3) {
        Control control;
        NSView[] nSViewArray;
        if (bl2) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (this.window != null && this.window.isVisible() == bl2) {
            return;
        }
        if (bl2) {
            this.display.clearPool();
            if (this.center && !this.moved) {
                if (this.isDisposed()) {
                    return;
                }
                this.center();
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.topView().setHidden(false);
            this.invalidateVisibleRegion();
            if (this.window != null) {
                if ((this.style & 0x10000000) != 0) {
                    nSViewArray = NSApplication.sharedApplication();
                    nSViewArray.beginSheet(this.window, this.parentWindow(), null, 0L, 0L);
                    if (OS.VERSION <= 4192 && this.window.respondsToSelector(OS.sel__setNeedsToUseHeartBeatWindow_)) {
                        OS.objc_msgSend(this.window.id, OS.sel__setNeedsToUseHeartBeatWindow_, 0);
                    }
                } else {
                    boolean bl4;
                    boolean bl5 = bl4 = this.parent != null && this.parentWindow().isMiniaturized();
                    if (!bl4) {
                        if (bl3 && (this.style & 0x80000) == 0) {
                            this.makeKeyAndOrderFront();
                        } else {
                            this.window.orderFront(null);
                        }
                        if (this.isDisposed()) {
                            return;
                        }
                        if (this.minimized != this.window.isMiniaturized()) {
                            if (this.minimized) {
                                this.window.miniaturize(null);
                            } else {
                                this.window.deminiaturize(null);
                            }
                        }
                    }
                }
            }
            if (this.isDisposed()) {
                return;
            }
            this.updateParent(bl2);
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            this.updateParent(bl2);
            if (this.window != null) {
                if ((this.style & 0x10000000) != 0) {
                    nSViewArray = NSApplication.sharedApplication();
                    nSViewArray.endSheet(this.window, 0L);
                }
                this.window.orderOut(null);
            }
            if (this.isDisposed()) {
                return;
            }
            this.topView().setHidden(true);
            this.invalidateVisibleRegion();
            this.sendEvent(23);
        }
        if (this.isDisposed()) {
            return;
        }
        this.display.updateQuitMenu();
        if (this.isDisposed()) {
            return;
        }
        nSViewArray = new NSView[1];
        Control control2 = this.display.findControl(false, nSViewArray);
        if (!(control2 == null || control2.isActive() && control2.isEnabled())) {
            control2 = null;
        }
        if ((control = control2) != null && control.isTrim(nSViewArray[0])) {
            control = null;
        }
        this.display.checkEnterExit(control, null, false);
    }

    void setZOrder() {
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
        if (this.window == null) {
            return;
        }
        this.window.setContentView(this.scrollView != null ? this.scrollView : this.view);
        if (this.fixResize()) {
            NSRect nSRect = this.window.frame();
            nSRect.y = 0.0;
            nSRect.x = 0.0;
            double d2 = this.window.userSpaceScaleFactor();
            nSRect.width /= d2;
            nSRect.height /= d2;
            this.window.contentView().setFrame(nSRect);
        }
    }

    void setZOrder(Control control, boolean bl2) {
        if (this.window == null) {
            return;
        }
        if (!this.getVisible()) {
            return;
        }
        if (control == null) {
            if (bl2) {
                this.window.orderFront(null);
            } else {
                this.window.orderBack(null);
            }
        } else {
            NSWindow nSWindow = control.getShell().window;
            this.window.orderWindow(bl2 ? 1L : -1L, nSWindow.windowNumber());
        }
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    void updateCursorRects(boolean bl2) {
        super.updateCursorRects(bl2);
        if (this.toolBar != null) {
            this.toolBar.updateCursorRects(bl2);
        }
    }

    void updateModal() {
    }

    void updateOpaque() {
        if (this.window == null) {
            return;
        }
        this.window.setOpaque(this.region == null && this.glContextCount == 0);
    }

    void updateParent(boolean bl2) {
        Object object;
        if (this.window != null) {
            if (bl2) {
                if (this.parent != null && this.parent.getVisible()) {
                    object = this.display.modalPanel != null ? this.display.modalPanel : this.parentWindow();
                    ((NSWindow)object).addChildWindow(this.window, 1L);
                    if ((this.style & 0x4000) != 0) {
                        this.window.setLevel(25L);
                    }
                }
            } else {
                object = this.window.parentWindow();
                if (object != null) {
                    ((NSWindow)object).removeChildWindow(this.window);
                }
            }
        }
        object = this.getShells();
        for (int i2 = 0; i2 < ((Shell[])object).length; ++i2) {
            Object object2 = object[i2];
            if (((Shell)object2).parent != this || !((Control)object2).getVisible()) continue;
            ((Shell)object2).updateParent(bl2);
        }
    }

    void updateSystemUIMode() {
        if ((this.window.collectionBehavior() & 0x80L) != 0L) {
            return;
        }
        if (!this.getMonitor().equals(this.display.getPrimaryMonitor())) {
            return;
        }
        int n2 = this.display.systemUIMode;
        int n3 = this.display.systemUIOptions;
        if (this.fullScreen) {
            n2 = 3;
            if (this.menuBar != null) {
                n2 = 2;
            }
            n3 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetSystemUIMode(nArray, nArray2);
        if (nArray[0] != n2 || nArray2[0] != n3) {
            OS.SetSystemUIMode(n2, n3);
        }
        if (this.fullScreen) {
            this.window.setFrame(this.fullScreenFrame, true);
        }
    }

    long view_stringForToolTip_point_userData(long l2, long l3, long l4, long l5, long l6, long l7) {
        NSPoint nSPoint = new NSPoint();
        OS.memmove(nSPoint, l6, (long)NSPoint.sizeof);
        Control control = this.display.findControl(false);
        if (control == null) {
            return 0L;
        }
        Widget widget = control.findTooltip(new NSView(l4).convertPoint_toView_(nSPoint, null));
        String string = widget.tooltipText();
        if (string == null) {
            return 0L;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n2 = this.fixMnemonic(cArray);
        return NSString.stringWithCharacters((char[])cArray, (long)((long)n2)).id;
    }

    void viewWillMoveToWindow(long l2, long l3, long l4) {
        if (this.window == null) {
            long l5;
            long l6 = l5 = this.hostWindow != null ? this.hostWindow.id : 0L;
            if (l5 != 0L) {
                this.removeObserversFromWindow();
            }
            if (l4 != 0L) {
                this.attachObserversToWindow(new NSWindow(l4));
            }
        }
    }

    void windowDidBecomeKey(long l2, long l3, long l4) {
        Drawable drawable;
        if (this.window != null) {
            drawable = this.display;
            ((Display)drawable).setMenuBar(this.menuBar);
        }
        this.sendEvent(26);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
        if (this.isDisposed()) {
            return;
        }
        if ((this.window.collectionBehavior() & 0x80L) == 0L) {
            drawable = this;
            while (((Shell)drawable).parent != null && !((Shell)(drawable = (Shell)((Shell)drawable).parent))._getFullScreen()) {
            }
            if (!((Shell)drawable)._getFullScreen() || this.menuBar != null) {
                this.updateSystemUIMode();
            } else {
                ((Shell)drawable).updateSystemUIMode();
            }
        }
    }

    void windowDidDeminiturize(long l2, long l3, long l4) {
        this.minimized = false;
        this.sendEvent(20);
    }

    void windowDidMiniturize(long l2, long l3, long l4) {
        this.minimized = true;
        this.sendEvent(19);
    }

    void windowDidMove(long l2, long l3, long l4) {
        this.moved = true;
        this.sendEvent(10);
    }

    void windowDidResize(long l2, long l3, long l4) {
        NSRect nSRect;
        if ((this.window.collectionBehavior() & 0x80L) == 0L && this.fullScreen) {
            this.window.setFrame(this.fullScreenFrame, true);
            nSRect = new NSRect();
            nSRect.width = this.fullScreenFrame.width;
            nSRect.height = this.fullScreenFrame.height;
            this.window.contentView().setFrame(nSRect);
        }
        if (this.fixResize()) {
            nSRect = this.window.frame();
            nSRect.y = 0.0;
            nSRect.x = 0.0;
            double d2 = this.window.userSpaceScaleFactor();
            nSRect.width /= d2;
            nSRect.height /= d2;
            this.window.contentView().setFrame(nSRect);
        }
        this.resized = true;
        this.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
    }

    void windowDidResignKey(long l2, long l3, long l4) {
        if (this.display.isDisposed()) {
            return;
        }
        this.sendEvent(27);
        if (this.isDisposed()) {
            return;
        }
        this.setActiveControl(null);
        if (this.isDisposed()) {
            return;
        }
        this.saveFocus();
    }

    void windowSendEvent(long l2, long l3, long l4) {
        NSEvent nSEvent = new NSEvent(l4);
        int n2 = (int)nSEvent.type();
        switch (n2) {
            case 1: 
            case 3: 
            case 25: {
                this.display.clickCount = (int)((long)this.display.clickCountButton == nSEvent.buttonNumber() ? nSEvent.clickCount() : 1L);
                this.display.clickCountButton = (int)nSEvent.buttonNumber();
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 26: {
                NSWindow nSWindow;
                Object object;
                Widget widget;
                NSView[] nSViewArray = new NSView[1];
                Control control = this.display.findControl(false, nSViewArray);
                if (!(control == null || control.isActive() && control.isEnabled())) {
                    control = null;
                }
                if (n2 == 5) {
                    widget = control;
                    if (widget != null && widget.isTrim(nSViewArray[0])) {
                        widget = null;
                    }
                    this.display.checkEnterExit((Control)widget, nSEvent, false);
                    if (widget != null && (widget.state & 0x100000) != 0) {
                        widget = null;
                    }
                    if (widget != null) {
                        widget.sendMouseEvent(nSEvent, n2, false);
                    }
                }
                widget = null;
                if (control != null) {
                    object = nSEvent.locationInWindow();
                    if (nSViewArray[0] != null && (nSWindow = nSEvent.window()) != null && nSWindow != nSViewArray[0].window()) {
                        object = nSWindow.convertBaseToScreen((NSPoint)object);
                        object = nSViewArray[0].window().convertScreenToBase((NSPoint)object);
                    }
                    widget = control.findTooltip((NSPoint)object);
                }
                if (this.display.tooltipControl != control || this.display.tooltipTarget != widget) {
                    Shell shell;
                    object = this.display.tooltipControl;
                    nSWindow = object != null && !((Widget)object).isDisposed() ? ((Control)object).getShell() : null;
                    Shell shell2 = shell = control != null && !control.isDisposed() ? control.getShell() : null;
                    if (nSWindow != null) {
                        ((Shell)((Object)nSWindow)).sendToolTipEvent(false);
                    }
                    if (shell != null) {
                        shell.sendToolTipEvent(true);
                    }
                }
                this.display.tooltipControl = control;
                this.display.tooltipTarget = widget;
                break;
            }
            case 10: {
                Object object;
                if (this.display.escAsAcceleratorPresent && nSEvent.keyCode() == 53) {
                    NSMenu nSMenu;
                    if (this.escMenuItem == null || this.escMenuItem.getAccelerator() != 27) {
                        this.updateEscMenuItem();
                    }
                    if (this.escMenuItem != null && (object = this.escMenuItem.getParent()) != null && (nSMenu = ((Menu)object).nsMenu) != null) {
                        nSMenu.performKeyEquivalent(nSEvent);
                    }
                }
                if ((nSEvent.modifierFlags() & 0x40000L) == 0L || (object = nSEvent.characters()) == null || ((NSString)object).length() != 1L) break;
                int n3 = (int)((NSString)object).characterAtIndex(0L);
                switch (n3) {
                    case 9: 
                    case 25: 
                    case 63276: 
                    case 63277: {
                        this.view.window().firstResponder().keyDown(nSEvent);
                        return;
                    }
                }
            }
        }
        if (this.isDisposed()) {
            return;
        }
        super.windowSendEvent(l2, l3, l4);
    }

    private void updateEscMenuItem() {
        if (this.menuBar != null && !this.menuBar.isDisposed()) {
            this.searchForEscMenuItem(this.menuBar);
        } else if (this.display.appMenuBar != null && !this.display.appMenuBar.isDisposed()) {
            this.searchForEscMenuItem(this.display.appMenuBar);
        }
    }

    private boolean searchForEscMenuItem(Menu menu) {
        if (menu == null || menu.isDisposed()) {
            return false;
        }
        MenuItem[] menuItemArray = menu.getItems();
        if (menuItemArray == null) {
            return false;
        }
        for (MenuItem menuItem : menuItemArray) {
            Menu menu2;
            if (menuItem == null || menuItem.isDisposed()) continue;
            if (menuItem.getAccelerator() == 27) {
                this.escMenuItem = menuItem;
                return true;
            }
            if ((menuItem.getStyle() & 0x40) == 0 || !this.searchForEscMenuItem(menu2 = menuItem.getMenu())) continue;
            return true;
        }
        return false;
    }

    boolean windowShouldClose(long l2, long l3, long l4) {
        if (this.isEnabled()) {
            this.closeWidget(false);
        }
        return false;
    }

    void windowWillClose(long l2, long l3, long l4) {
        this.closeWidget(true);
    }
}

