/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScroller;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    NSScrollView scrollView;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite composite, int n2) {
        super(composite, n2);
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        if (this.scrollView != null) {
            int n6;
            NSSize nSSize = new NSSize();
            nSSize.width = n4;
            nSSize.height = n5;
            int n7 = n6 = this.hasBorder() ? 2 : 0;
            if (OS.VERSION >= 4208) {
                OS.objc_msgSend_stret(nSSize, OS.class_NSScrollView, OS.sel_frameSizeForContentSize_horizontalScrollerClass_verticalScrollerClass_borderType_controlSize_scrollerStyle_, nSSize, (this.style & 0x100) != 0 ? OS.class_NSScroller : 0L, (this.style & 0x200) != 0 ? OS.class_NSScroller : 0L, n6, 0L, 0L);
            } else {
                nSSize = NSScrollView.frameSizeForContentSize(nSSize, (this.style & 0x100) != 0, (this.style & 0x200) != 0, n6);
            }
            n4 = (int)nSSize.width;
            n5 = (int)nSSize.height;
            NSRect nSRect = this.scrollView.contentView().frame();
            n2 = (int)((double)n2 - nSRect.x);
            n3 = (int)((double)n3 - nSRect.y);
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    ScrollBar createScrollBar(int n2) {
        long l2;
        if (this.scrollView == null) {
            return null;
        }
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.parent = this;
        scrollBar.style = n2;
        scrollBar.display = this.display;
        NSRect nSRect = new NSRect();
        if ((n2 & 0x100) != 0) {
            nSRect.width = 1.0;
        } else {
            nSRect.height = 1.0;
        }
        NSScroller nSScroller = (NSScroller)new SWTScroller().alloc();
        nSScroller.initWithFrame(nSRect);
        if ((n2 & 0x100) != 0) {
            this.scrollView.setHorizontalScroller(nSScroller);
            l2 = OS.sel_sendHorizontalSelection;
        } else {
            this.scrollView.setVerticalScroller(nSScroller);
            l2 = OS.sel_sendVerticalSelection;
        }
        scrollBar.view = nSScroller;
        scrollBar.createJNIRef();
        scrollBar.register();
        if ((this.state & 2) == 0) {
            scrollBar.target = nSScroller.target();
            scrollBar.actionSelector = nSScroller.action();
        }
        nSScroller.setTarget(this.scrollView);
        nSScroller.setAction(l2);
        if ((this.state & 2) != 0) {
            scrollBar.updateBar(0, 0, 100, 10);
        }
        return scrollBar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.scrollView != null) {
            this.display.removeWidget(this.scrollView);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.scrollView != null) {
            NSSize nSSize = this.scrollView.contentSize();
            NSClipView nSClipView = this.scrollView.contentView();
            NSRect nSRect = nSClipView.bounds();
            return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSSize.width, (int)nSSize.height);
        }
        NSRect nSRect = this.view.bounds();
        return new Rectangle(0, 0, (int)nSRect.width, (int)nSRect.height);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public int getScrollbarsMode() {
        this.checkWidget();
        int n2 = 0;
        if (this.scrollView != null && OS.VERSION >= 4208 && OS.objc_msgSend(this.scrollView.id, OS.sel_scrollerStyle) == 1L) {
            n2 = 2;
        }
        return n2;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2) || this.hooks(31);
    }

    boolean isEventView(long l2) {
        return l2 == this.eventView().id;
    }

    boolean isNeeded(ScrollBar scrollBar) {
        return true;
    }

    boolean isTrim(NSView nSView) {
        if (this.scrollView != null) {
            if (this.scrollView.id == nSView.id) {
                return true;
            }
            if (this.horizontalBar != null && this.horizontalBar.view.id == nSView.id) {
                return true;
            }
            if (this.verticalBar != null && this.verticalBar.view.id == nSView.id) {
                return true;
            }
        }
        return super.isTrim(nSView);
    }

    void redrawBackgroundImage() {
        Control control;
        if (this.scrollView != null && (control = this.findBackgroundControl()) != null && control.backgroundImage != null) {
            this.redrawWidget(this.view, false);
        }
    }

    void reflectScrolledClipView(long l2, long l3, long l4) {
        super.reflectScrolledClipView(l2, l3, l4);
        this.redrawBackgroundImage();
    }

    void register() {
        super.register();
        if (this.scrollView != null) {
            this.display.addWidget(this.scrollView, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.scrollView != null) {
            this.scrollView.release();
        }
        this.scrollView = null;
    }

    void releaseChildren(boolean bl2) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(bl2);
    }

    void reskinChildren(int n2) {
        if (this.horizontalBar != null) {
            this.horizontalBar.reskin(n2);
        }
        if (this.verticalBar != null) {
            this.verticalBar.reskin(n2);
        }
        super.reskinChildren(n2);
    }

    void scrollClipViewToPoint(long l2, long l3, long l4, NSPoint nSPoint) {
        if ((this.state & 2) == 0 && this.scrollView != null) {
            boolean bl2;
            NSClipView nSClipView = new NSClipView(l4);
            boolean bl3 = bl2 = nSClipView.copiesOnScroll();
            if (this.visibleRgn == 0L) {
                boolean bl4 = bl3 = !this.isObscured();
            }
            if (bl3) {
                bl3 = !this.hasRegion();
            }
            nSClipView.setCopiesOnScroll(bl3);
        }
        super.scrollClipViewToPoint(l2, l3, l4, nSPoint);
    }

    void sendHorizontalSelection() {
        if (this.horizontalBar.view.isHiddenOrHasHiddenAncestor()) {
            return;
        }
        this.horizontalBar.sendSelection();
    }

    void sendVerticalSelection() {
        if (this.verticalBar.view.isHiddenOrHasHiddenAncestor()) {
            return;
        }
        this.verticalBar.sendSelection();
    }

    void enableWidget(boolean bl2) {
        super.enableWidget(bl2);
        if (this.horizontalBar != null) {
            this.horizontalBar.enableWidget(bl2 && this.isNeeded(this.horizontalBar));
        }
        if (this.verticalBar != null) {
            this.verticalBar.enableWidget(bl2 && this.isNeeded(this.verticalBar));
        }
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl2) {
        if (this.scrollView == null) {
            return false;
        }
        if ((this.state & 2) == 0) {
            return false;
        }
        if (bl2) {
            if ((scrollBar.state & 0x10) == 0) {
                return false;
            }
            scrollBar.state &= 0xFFFFFFEF;
        } else {
            if ((scrollBar.state & 0x10) != 0) {
                return false;
            }
            scrollBar.state |= 0x10;
        }
        if ((scrollBar.style & 0x100) != 0) {
            this.scrollView.setHasHorizontalScroller(bl2);
        } else {
            this.scrollView.setHasVerticalScroller(bl2);
        }
        scrollBar.sendEvent(bl2 ? 22 : 23);
        this.sendEvent(11);
        return true;
    }

    void setZOrder() {
        super.setZOrder();
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
    }

    NSView topView() {
        if (this.scrollView != null) {
            return this.scrollView;
        }
        return super.topView();
    }

    void updateCursorRects(boolean bl2) {
        super.updateCursorRects(bl2);
        if (this.scrollView == null) {
            return;
        }
        this.updateCursorRects(bl2, this.scrollView);
        NSClipView nSClipView = this.scrollView.contentView();
        this.updateCursorRects(bl2, nSClipView);
    }
}

