/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    NSScroller view;
    Scrollable parent;
    int minimum;
    int maximum = 100;
    int thumb = 10;
    int increment = 1;
    int pageIncrement = 10;
    id target;
    long actionSelector;

    ScrollBar() {
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return ScrollBar.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
    }

    boolean getDrawing() {
        return this.parent.getDrawing();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        NSScroller nSScroller = this.view;
        double d2 = nSScroller.doubleValue();
        return (int)(0.5 + ((double)(this.maximum - this.thumb - this.minimum) * d2 + (double)this.minimum));
    }

    public Point getSize() {
        this.checkWidget();
        NSRect nSRect = this.view.frame();
        return new Point((int)nSRect.width, (int)nSRect.height);
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public Rectangle getThumbBounds() {
        this.checkWidget();
        NSRect nSRect = this.view.rectForPart(2L);
        nSRect = this.view.convertRect_toView_(nSRect, this.parent.view);
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    public Rectangle getThumbTrackBounds() {
        this.checkWidget();
        NSRect nSRect = this.view.rectForPart(6L);
        nSRect = this.view.convertRect_toView_(nSRect, this.parent.view);
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0 && !this.view.isHidden();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        this.view = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    void sendSelection() {
        NSPoint nSPoint;
        NSWindow nSWindow = this.view.window();
        if (this.target == null) {
            this.parent.getShell().deferFlushing();
        }
        int n2 = 0;
        if (this.target != null) {
            this.view.sendAction(this.actionSelector, this.target);
        } else {
            n2 = this.getSelection();
        }
        NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
        if (nSEvent != null) {
            nSPoint = nSEvent.locationInWindow();
            if (nSEvent.window() == null) {
                nSPoint = nSWindow.convertScreenToBase(nSPoint);
            }
        } else {
            nSPoint = nSWindow.mouseLocationOutsideOfEventStream();
        }
        int n3 = (int)this.view.testPart(nSPoint);
        Event event = new Event();
        switch (n3) {
            case 4: {
                n2 -= this.increment;
                event.detail = 0x1000001;
                break;
            }
            case 1: {
                n2 -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 5: {
                n2 += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 3: {
                n2 += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 1;
            }
        }
        if (this.target == null && event.detail != 1) {
            this.setSelection(n2);
        }
        this.sendSelectionEvent(13, event, true);
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.increment = n2;
    }

    void setClipRegion(NSView nSView) {
        this.parent.setClipRegion(nSView);
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        if (bl2) {
            if ((this.state & 8) == 0) {
                return;
            }
            this.state &= 0xFFFFFFF7;
        } else {
            if ((this.state & 8) != 0) {
                return;
            }
            this.state |= 8;
        }
        this.enableWidget(bl2);
    }

    void enableWidget(boolean bl2) {
        if (!bl2 || (this.state & 8) == 0) {
            this.view.setEnabled(bl2);
        }
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n2 <= this.minimum) {
            return;
        }
        if (n2 - this.minimum < this.thumb) {
            this.thumb = n2 - this.minimum;
        }
        int n3 = Math.max(this.minimum, Math.min(this.getSelection(), n2 - this.thumb));
        this.maximum = n2;
        this.updateBar(n3, this.minimum, n2, this.thumb);
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n2 >= this.maximum) {
            return;
        }
        if (this.maximum - n2 < this.thumb) {
            this.thumb = this.maximum - n2;
        }
        int n3 = Math.min(this.maximum - this.thumb, Math.max(this.getSelection(), n2));
        this.minimum = n2;
        this.updateBar(n3, n2, this.maximum, this.thumb);
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.pageIncrement = n2;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.updateBar(n2, this.minimum, this.maximum, this.thumb);
    }

    public void setThumb(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        n2 = Math.min(n2, this.maximum - this.minimum);
        this.updateBar(this.getSelection(), this.minimum, this.maximum, n2);
        this.thumb = n2;
    }

    public void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        if (n3 < 0) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        if (n7 < 1) {
            return;
        }
        this.thumb = n5 = Math.min(n5, n4 - n3);
        this.maximum = n4;
        this.minimum = n3;
        this.increment = n6;
        this.pageIncrement = n7;
        this.updateBar(n2, n3, n4, n5);
    }

    public void setVisible(boolean bl2) {
        this.checkWidget();
        this.parent.setScrollBarVisible(this, bl2);
    }

    void updateBar(int n2, int n3, int n4, int n5) {
        NSScroller nSScroller = this.view;
        n2 = Math.max(n3, Math.min(n4 - n5, n2));
        int n6 = n4 - n5 - n3;
        float f2 = n6 <= 0 ? 1.0f : (float)(n2 - n3) / (float)n6;
        float f3 = n6 <= 0 ? 1.0f : (float)n5 / (float)(n4 - n3);
        double d2 = nSScroller.doubleValue();
        double d3 = nSScroller.knobProportion();
        nSScroller.setDoubleValue(f2);
        nSScroller.setKnobProportion(f3);
        nSScroller.setEnabled(n6 > 0);
        if (OS.VERSION >= 4208 && this.target == null && ((double)f3 != d3 || (double)f2 != d2)) {
            OS.objc_msgSend(this.parent.scrollView.id, OS.sel_flashScrollers);
        }
    }
}

