/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSSlider;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTSlider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    int increment = 1;
    int pageIncrement = 10;

    public Scale(Composite composite, int n2) {
        super(composite, Scale.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return Scale.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        NSSlider nSSlider = (NSSlider)this.view;
        double d2 = nSSlider.knobThickness();
        int n4 = 64;
        int n5 = 64;
        if ((this.style & 0x100) != 0) {
            n5 = (int)Math.ceil(d2);
            n4 = n5 * 10;
        } else {
            n4 = (int)Math.ceil(d2);
            n5 = n4 * 10;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        return new Point(n4, n5);
    }

    void createHandle() {
        this.state |= 0x800;
        NSSlider nSSlider = (NSSlider)new SWTSlider().alloc();
        nSSlider.init();
        nSSlider.setMaxValue(100.0);
        nSSlider.setTarget(nSSlider);
        nSSlider.setAction(OS.sel_sendSelection);
        this.view = nSSlider;
    }

    NSFont defaultNSFont() {
        return this.display.sliderFont;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)((NSSlider)this.view).maxValue();
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)((NSSlider)this.view).minValue();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return (int)((NSSlider)this.view).doubleValue();
    }

    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void sendSelection() {
        NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
        if (nSEvent.type() != 2L) {
            this.sendSelectionEvent(13);
        }
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.increment = n2;
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        int n3 = (int)((NSSlider)this.view).minValue();
        if (n2 <= n3) {
            return;
        }
        ((NSSlider)this.view).setMaxValue(n2);
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        int n3 = (int)((NSSlider)this.view).maxValue();
        if (0 > n2 || n2 >= n3) {
            return;
        }
        ((NSSlider)this.view).setMinValue(n2);
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.pageIncrement = n2;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        ((NSSlider)this.view).setDoubleValue(n2);
    }
}

