/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    Cursor sizeCursor;
    boolean dragging;
    int lastX;
    int lastY;
    int startX;
    int startY;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;
    NSArray accessibilityAttributes = null;

    public Sash(Composite composite, int n2) {
        super(composite, Sash.checkStyle(n2));
        int n3 = (n2 & 0x200) != 0 ? 9 : 7;
        this.sizeCursor = new Cursor(this.display, n3);
    }

    long accessibilityAttributeNames(long l2, long l3) {
        if (this.accessibilityAttributes == null) {
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(10L);
            nSMutableArray.addObject(OS.NSAccessibilityRoleAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityRoleDescriptionAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityParentAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityPositionAttribute);
            nSMutableArray.addObject(OS.NSAccessibilitySizeAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityWindowAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityTopLevelUIElementAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityFocusedAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityMaxValueAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityMinValueAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityNextContentsAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityPreviousContentsAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityOrientationAttribute);
            if (this.accessible != null) {
                NSMutableArray nSMutableArray2 = NSMutableArray.arrayWithCapacity(3L);
                nSMutableArray2.addObject(OS.NSAccessibilityHelpAttribute);
                nSMutableArray2.addObject(OS.NSAccessibilityDescriptionAttribute);
                nSMutableArray2.addObject(OS.NSAccessibilityTitleAttribute);
                for (int i2 = (int)nSMutableArray2.count() - 1; i2 >= 0; --i2) {
                    NSString nSString = new NSString(nSMutableArray2.objectAtIndex((long)((long)i2)).id);
                    if (this.accessible.internal_accessibilityAttributeValue(nSString, -1) == null) continue;
                    nSMutableArray.addObject(nSMutableArray2.objectAtIndex(i2));
                }
            }
            this.accessibilityAttributes = nSMutableArray;
            this.accessibilityAttributes.retain();
        }
        return this.accessibilityAttributes.id;
    }

    long accessibilityAttributeValue(long l2, long l3, long l4) {
        Control[] controlArray;
        long l5 = 0L;
        NSString nSString = new NSString(l4);
        if (this.accessible != null && (controlArray = this.accessible.internal_accessibilityAttributeValue(nSString, -1)) != null) {
            l5 = controlArray.id;
        }
        if (l5 != 0L) {
            return l5;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute) || nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            controlArray = OS.NSAccessibilitySplitterRole;
            if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                return controlArray.id;
            }
            return OS.NSAccessibilityRoleDescription(controlArray.id, 0L);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return NSNumber.numberWithBool((boolean)this.isEnabled()).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityOrientationAttribute)) {
            controlArray = (this.style & 0x200) != 0 ? OS.NSAccessibilityVerticalOrientationValue : OS.NSAccessibilityHorizontalOrientationValue;
            return controlArray.id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityValueAttribute)) {
            controlArray = this.getLocation();
            int n2 = (this.style & 0x200) != 0 ? controlArray.x : controlArray.y;
            return NSNumber.numberWithInt((int)n2).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMaxValueAttribute)) {
            controlArray = this.parent.topView().frame();
            double d2 = (this.style & 0x200) != 0 ? controlArray.width : controlArray.height;
            return NSNumber.numberWithDouble((double)d2).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMinValueAttribute)) {
            return NSNumber.numberWithInt((int)0).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityNextContentsAttribute)) {
            controlArray = this.parent._getChildren();
            Control control = null;
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                if (controlArray[i2] != this || i2 >= controlArray.length - 1) continue;
                control = controlArray[i2 + 1];
                break;
            }
            if (control != null) {
                return NSArray.arrayWithObject((id)control.view).id;
            }
            return NSArray.array().id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityPreviousContentsAttribute)) {
            controlArray = this.parent._getChildren();
            Control control = null;
            for (int i3 = 0; i3 < controlArray.length; ++i3) {
                if (controlArray[i3] != this || i3 <= 0) continue;
                control = controlArray[i3 - 1];
                break;
            }
            if (control != null) {
                return NSArray.arrayWithObject((id)control.view).id;
            }
            return NSArray.array().id;
        }
        return super.accessibilityAttributeValue(l2, l3, l4);
    }

    boolean accessibilityIsIgnored(long l2, long l3) {
        return false;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return Sash.checkBits(n2 |= 0x10000, 256, 512, 0, 0, 0, 0);
    }

    boolean becomeFirstResponder(long l2, long l3) {
        boolean bl2 = super.becomeFirstResponder(l2, l3);
        NSRect nSRect = this.view.frame();
        this.lastX = (int)nSRect.x;
        this.lastY = (int)nSRect.y;
        return bl2;
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            n4 += 64;
            n5 += 5;
        } else {
            n4 += 5;
            n5 += 64;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        return new Point(n4, n5);
    }

    void createHandle() {
        this.state |= 0x800;
        NSView nSView = (NSView)new SWTView().alloc();
        nSView.init();
        this.view = nSView;
    }

    void drawBackground(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
    }

    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        if (cursor == null) {
            int n2 = (this.style & 0x100) != 0 ? 7 : 9;
            cursor = this.display.getSystemCursor(n2);
        }
        return cursor;
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n2) {
        super.sendKeyEvent(nSEvent, n2);
        if (n2 == 1) {
            short s2 = nSEvent.keyCode();
            switch (s2) {
                case 123: 
                case 124: 
                case 125: 
                case 126: {
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 9;
                    long l2 = nSEvent.modifierFlags();
                    if ((l2 & 0x40000L) != 0L) {
                        n5 = 1;
                    }
                    if ((this.style & 0x200) != 0) {
                        if (s2 == 126 || s2 == 125) break;
                        n3 = s2 == 123 ? -n5 : n5;
                    } else {
                        if (s2 == 123 || s2 == 124) break;
                        n4 = s2 == 126 ? -n5 : n5;
                    }
                    Rectangle rectangle = this.getBounds();
                    int n6 = rectangle.width;
                    int n7 = rectangle.height;
                    Rectangle rectangle2 = this.parent.getBounds();
                    int n8 = rectangle2.width;
                    int n9 = rectangle2.height;
                    int n10 = this.lastX;
                    int n11 = this.lastY;
                    if ((this.style & 0x200) != 0) {
                        n10 = Math.min(Math.max(0, this.lastX + n3), n8 - n6);
                    } else {
                        n11 = Math.min(Math.max(0, this.lastY + n4), n9 - n7);
                    }
                    if (n10 == this.lastX && n11 == this.lastY) {
                        return true;
                    }
                    Event event = new Event();
                    event.x = n10;
                    event.y = n11;
                    event.width = n6;
                    event.height = n7;
                    this.sendSelectionEvent(13, event, true);
                    if (this.isDisposed() || !event.doit) break;
                    this.setBounds(event.x, event.y, n6, n7);
                    if (this.isDisposed()) break;
                    this.lastX = event.x;
                    this.lastY = event.y;
                    if (this.isDisposed()) {
                        return false;
                    }
                    int n12 = event.x;
                    int n13 = event.y;
                    if ((this.style & 0x200) != 0) {
                        n13 += n7 / 2;
                    } else {
                        n12 += n6 / 2;
                    }
                    this.display.setCursorLocation(this.parent.toDisplay(n12, n13));
                    break;
                }
            }
        }
        return true;
    }

    void mouseDown(long l2, long l3, long l4) {
        super.mouseDown(l2, l3, l4);
        if (this.isDisposed()) {
            return;
        }
        NSEvent nSEvent = new NSEvent(l4);
        if (nSEvent.clickCount() != 1L) {
            return;
        }
        NSPoint nSPoint = nSEvent.locationInWindow();
        NSPoint nSPoint2 = this.view.convertPoint_fromView_(nSPoint, null);
        this.startX = (int)nSPoint2.x;
        this.startY = (int)nSPoint2.y;
        NSRect nSRect = this.view.frame();
        Event event = new Event();
        event.x = (int)nSRect.x;
        event.y = (int)nSRect.y;
        event.width = (int)nSRect.width;
        event.height = (int)nSRect.height;
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            this.dragging = true;
            this.setLocation(event.x, event.y);
        }
    }

    boolean mouseEvent(long l2, long l3, long l4, int n2) {
        super.mouseEvent(l2, l3, l4, n2);
        return new NSEvent(l4).type() != 1L;
    }

    void mouseDragged(long l2, long l3, long l4) {
        super.mouseDragged(l2, l3, l4);
        if (this.isDisposed()) {
            return;
        }
        if (!this.dragging) {
            return;
        }
        NSEvent nSEvent = new NSEvent(l4);
        NSPoint nSPoint = nSEvent.locationInWindow();
        NSPoint nSPoint2 = this.view.convertPoint_fromView_(nSPoint, null);
        NSRect nSRect = this.view.frame();
        NSRect nSRect2 = this.parent.topView().frame();
        int n2 = this.lastX;
        int n3 = this.lastY;
        if ((this.style & 0x200) != 0) {
            n2 = Math.min(Math.max(0, (int)(nSPoint2.x + nSRect.x - (double)this.startX)), (int)(nSRect2.width - nSRect.width));
        } else {
            n3 = Math.min(Math.max(0, (int)(nSPoint2.y + nSRect.y - (double)this.startY)), (int)(nSRect2.height - nSRect.height));
        }
        if (n2 == this.lastX && n3 == this.lastY) {
            return;
        }
        Event event = new Event();
        event.x = n2;
        event.y = n3;
        event.width = (int)nSRect.width;
        event.height = (int)nSRect.height;
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            this.setBounds(event.x, event.y, (int)nSRect.width, (int)nSRect.height);
        }
    }

    void mouseUp(long l2, long l3, long l4) {
        super.mouseUp(l2, l3, l4);
        if (this.isDisposed()) {
            return;
        }
        if (!this.dragging) {
            return;
        }
        this.dragging = false;
        NSRect nSRect = this.view.frame();
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = (int)nSRect.width;
        event.height = (int)nSRect.height;
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.setBounds(event.x, event.y, (int)nSRect.width, (int)nSRect.height);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.accessibilityAttributes != null) {
            this.accessibilityAttributes.release();
        }
        this.accessibilityAttributes = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.sizeCursor != null) {
            this.sizeCursor.dispose();
        }
        this.sizeCursor = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void superKeyDown(long l2, long l3, long l4) {
    }

    void superKeyUp(long l2, long l3, long l4) {
    }

    int traversalCode(int n2, NSEvent nSEvent) {
        return 0;
    }
}

