/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSProgressIndicator;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTProgressIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    NSBezierPath visiblePath;

    public ProgressBar(Composite composite, int n2) {
        super(composite, ProgressBar.checkStyle(n2));
    }

    static int checkStyle(int n2) {
        return ProgressBar.checkBits(n2 |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 14;
        int n5 = 0;
        int n6 = 0;
        if ((this.style & 0x100) != 0) {
            n6 = n4;
            n5 = n6 * 10;
        } else {
            n5 = n4;
            n6 = n5 * 10;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n6 = n3;
        }
        return new Point(n5, n6);
    }

    void createHandle() {
        NSProgressIndicator nSProgressIndicator = (NSProgressIndicator)new SWTProgressIndicator().alloc();
        nSProgressIndicator.init();
        nSProgressIndicator.setUsesThreadedAnimation(false);
        if ((this.style & 0x200) != 0) {
            nSProgressIndicator.setBoundsRotation(-90.0);
        }
        nSProgressIndicator.setIndeterminate((this.style & 2) != 0);
        this.view = nSProgressIndicator;
    }

    NSFont defaultNSFont() {
        return this.display.progressIndicatorFont;
    }

    void _drawThemeProgressArea(long l2, long l3, long l4) {
        NSRect nSRect = this.view.frame();
        if (nSRect.width == 0.0 || nSRect.height == 0.0) {
            return;
        }
        if (this.visiblePath == null) {
            long l5 = this.getVisibleRegion();
            this.visiblePath = this.getPath(l5);
            OS.DisposeRgn(l5);
        }
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        nSGraphicsContext.saveGraphicsState();
        this.visiblePath.setClip();
        super._drawThemeProgressArea(l2, l3, l4);
        nSGraphicsContext.restoreGraphicsState();
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)((NSProgressIndicator)this.view).maxValue();
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)((NSProgressIndicator)this.view).minValue();
    }

    public int getSelection() {
        this.checkWidget();
        return (int)((NSProgressIndicator)this.view).doubleValue();
    }

    public int getState() {
        this.checkWidget();
        return 0;
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        int n3 = (int)((NSProgressIndicator)this.view).minValue();
        if (n2 <= n3) {
            return;
        }
        ((NSProgressIndicator)this.view).setMaxValue(n2);
        int n4 = (int)((NSProgressIndicator)this.view).doubleValue();
        int n5 = Math.min(n4, n2);
        if (n4 != n5) {
            ((NSProgressIndicator)this.view).setDoubleValue(n5);
        }
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        int n3 = (int)((NSProgressIndicator)this.view).maxValue();
        if (0 > n2 || n2 >= n3) {
            return;
        }
        ((NSProgressIndicator)this.view).setMinValue(n2);
        int n4 = (int)((NSProgressIndicator)this.view).doubleValue();
        int n5 = Math.max(n4, n2);
        if (n4 != n5) {
            ((NSProgressIndicator)this.view).setDoubleValue(n5);
        }
    }

    public void setSelection(int n2) {
        this.checkWidget();
        ((NSProgressIndicator)this.view).setDoubleValue(n2);
        this.update(false);
    }

    public void setState(int n2) {
        this.checkWidget();
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    void resetVisibleRegion() {
        super.resetVisibleRegion();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    void viewDidMoveToWindow(long l2, long l3) {
        if (this.view.window() != null && (this.style & 2) != 0) {
            ((NSProgressIndicator)this.view).startAnimation(null);
        }
    }
}

