/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.cocoa.NSAlert;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSPanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";
    int returnCode;

    public MessageBox(Shell shell) {
        this(shell, 65570);
    }

    public MessageBox(Shell shell, int n2) {
        super(shell, MessageBox.checkStyle(shell, MessageBox.checkStyle(n2)));
        if (Display.getSheetEnabled() && shell != null && (n2 & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    static int checkStyle(int n2) {
        int n3 = 4064;
        int n4 = n2 & n3;
        if (n4 == 32 || n4 == 256 || n4 == 288) {
            return n2;
        }
        if (n4 == 64 || n4 == 128 || n4 == 192 || n4 == 448) {
            return n2;
        }
        if (n4 == 1280 || n4 == 3584) {
            return n2;
        }
        n2 = n2 & ~n3 | 0x20;
        return n2;
    }

    public String getMessage() {
        return this.message;
    }

    public int open() {
        Display display;
        NSString nSString;
        NSAlert nSAlert = (NSAlert)new NSAlert().alloc().init();
        int n2 = 1;
        if ((this.style & 1) != 0) {
            n2 = 2;
        }
        if ((this.style & 2) != 0) {
            n2 = 1;
        }
        if ((this.style & 4) != 0) {
            n2 = 1;
        }
        if ((this.style & 8) != 0) {
            n2 = 0;
        }
        if ((this.style & 0x10) != 0) {
            n2 = 1;
        }
        nSAlert.setAlertStyle(n2);
        int n3 = 4064;
        int n4 = this.style & n3;
        switch (n4) {
            case 32: {
                nSString = NSString.stringWith(SWT.getMessage("SWT_OK"));
                nSAlert.addButtonWithTitle(nSString);
                break;
            }
            case 256: {
                nSString = NSString.stringWith(SWT.getMessage("SWT_Cancel"));
                nSAlert.addButtonWithTitle(nSString);
                break;
            }
            case 288: {
                nSString = NSString.stringWith(SWT.getMessage("SWT_OK"));
                nSAlert.addButtonWithTitle(nSString);
                nSString = NSString.stringWith(SWT.getMessage("SWT_Cancel"));
                nSAlert.addButtonWithTitle(nSString);
                break;
            }
            case 64: {
                nSString = NSString.stringWith(SWT.getMessage("SWT_Yes"));
                nSAlert.addButtonWithTitle(nSString);
                break;
            }
            case 128: {
                nSString = NSString.stringWith(SWT.getMessage("SWT_No"));
                nSAlert.addButtonWithTitle(nSString);
                break;
            }
            case 192: {
                nSString = NSString.stringWith(SWT.getMessage("SWT_Yes"));
                nSAlert.addButtonWithTitle(nSString);
                nSString = NSString.stringWith(SWT.getMessage("SWT_No"));
                nSAlert.addButtonWithTitle(nSString);
                break;
            }
            case 448: {
                nSString = NSString.stringWith(SWT.getMessage("SWT_Yes"));
                nSAlert.addButtonWithTitle(nSString);
                nSString = NSString.stringWith(SWT.getMessage("SWT_Cancel"));
                nSAlert.addButtonWithTitle(nSString);
                nSString = NSString.stringWith(SWT.getMessage("SWT_No"));
                nSAlert.addButtonWithTitle(nSString);
                break;
            }
            case 1280: {
                nSString = NSString.stringWith(SWT.getMessage("SWT_Retry"));
                nSAlert.addButtonWithTitle(nSString);
                nSString = NSString.stringWith(SWT.getMessage("SWT_Cancel"));
                nSAlert.addButtonWithTitle(nSString);
                break;
            }
            case 3584: {
                nSString = NSString.stringWith(SWT.getMessage("SWT_Abort"));
                nSAlert.addButtonWithTitle(nSString);
                nSString = NSString.stringWith(SWT.getMessage("SWT_Ignore"));
                nSAlert.addButtonWithTitle(nSString);
                nSString = NSString.stringWith(SWT.getMessage("SWT_Retry"));
                nSAlert.addButtonWithTitle(nSString);
            }
        }
        nSString = NSString.stringWith(this.title != null ? this.title : "");
        NSPanel nSPanel = nSAlert.window();
        nSPanel.setTitle(nSString);
        NSString nSString2 = NSString.stringWith(this.message != null ? this.message : "");
        nSAlert.setMessageText(nSString2);
        int n5 = 0;
        long l2 = 0L;
        SWTPanelDelegate sWTPanelDelegate = null;
        Display display2 = display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        if ((this.style & 0x10000000) != 0) {
            sWTPanelDelegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
            l2 = OS.NewGlobalRef(this);
            if (l2 == 0L) {
                this.error(2);
            }
            OS.object_setInstanceVariable(sWTPanelDelegate.id, Display.SWT_OBJECT, l2);
            nSAlert.beginSheetModalForWindow(this.parent.view.window(), sWTPanelDelegate, OS.sel_panelDidEnd_returnCode_contextInfo_, 0L);
            display.setModalDialog(this, nSPanel);
            if ((this.style & 0x10000) != 0) {
                n5 = (int)nSAlert.runModal();
            } else {
                this.returnCode = 0;
                NSPanel nSPanel2 = nSAlert.window();
                while (nSPanel2.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                n5 = this.returnCode;
            }
        } else {
            display.setModalDialog(this, nSPanel);
            n5 = (int)nSAlert.runModal();
        }
        display.setModalDialog(null);
        if (sWTPanelDelegate != null) {
            sWTPanelDelegate.release();
        }
        if (l2 != 0L) {
            OS.DeleteGlobalRef(l2);
        }
        nSAlert.release();
        switch (n4) {
            case 32: {
                switch (n5) {
                    case 1000: {
                        return 32;
                    }
                }
                break;
            }
            case 256: {
                switch (n5) {
                    case 1000: {
                        return 256;
                    }
                }
                break;
            }
            case 288: {
                switch (n5) {
                    case 1000: {
                        return 32;
                    }
                    case 1001: {
                        return 256;
                    }
                }
                break;
            }
            case 64: {
                switch (n5) {
                    case 1000: {
                        return 64;
                    }
                }
                break;
            }
            case 128: {
                switch (n5) {
                    case 1000: {
                        return 128;
                    }
                }
                break;
            }
            case 192: {
                switch (n5) {
                    case 1000: {
                        return 64;
                    }
                    case 1001: {
                        return 128;
                    }
                }
                break;
            }
            case 448: {
                switch (n5) {
                    case 1000: {
                        return 64;
                    }
                    case 1001: {
                        return 256;
                    }
                    case 1002: {
                        return 128;
                    }
                }
                break;
            }
            case 1280: {
                switch (n5) {
                    case 1000: {
                        return 1024;
                    }
                    case 1001: {
                        return 256;
                    }
                }
                break;
            }
            case 3584: {
                switch (n5) {
                    case 1000: {
                        return 512;
                    }
                    case 1001: {
                        return 2048;
                    }
                    case 1002: {
                        return 1024;
                    }
                }
            }
        }
        return 256;
    }

    void panelDidEnd_returnCode_contextInfo(long l2, long l3, long l4, long l5, long l6) {
        this.returnCode = (int)l5;
        NSApplication nSApplication = NSApplication.sharedApplication();
        nSApplication.endSheet(new NSAlert(l4).window(), l5);
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

