/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTMenu;
import org.eclipse.swt.internal.cocoa.SWTMenuItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    NSMenu nsMenu;
    int x;
    int y;
    int itemCount;
    boolean hasLocation;
    boolean visible;
    MenuItem[] items;
    MenuItem cascade;
    MenuItem defaultItem;
    Decorations parent;
    static final int GAP = 4;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n2) {
        this.checkSubclass();
        this.checkParent(decorations);
        this.style = Menu.checkStyle(n2);
        if (decorations != null) {
            this.display = decorations.display;
        } else {
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = Display.getDefault();
            }
            if (!this.display.isValidThread()) {
                this.error(22);
            }
        }
        this.parent = decorations;
        this.reskinWidget();
        this.createWidget();
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    Menu(Display display) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
        this.style = 2;
        this.reskinWidget();
        this.createWidget();
    }

    Menu(Display display, NSMenu nSMenu) {
        this.display = display;
        this.style = 4;
        this.nsMenu = nSMenu;
        this.reskinWidget();
        this.createWidget();
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    void checkParent(Widget widget) {
        if (widget == null && Display.getDefault().appMenuBar == null) {
            this.error(4);
        }
        if (widget != null) {
            if (widget.isDisposed()) {
                this.error(5);
            }
            widget.checkWidget();
            widget.checkOpen();
        }
    }

    static int checkStyle(int n2) {
        return Menu.checkBits(n2, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean bl2) {
        if ((this.style & 6) != 0) {
            return;
        }
        TrayItem trayItem = this.display.currentTrayItem;
        if (trayItem != null && bl2) {
            trayItem.showMenu(this);
            return;
        }
        if (bl2) {
            NSObject nSObject;
            Shell shell = this.getShell();
            NSWindow nSWindow = shell.view.window();
            NSPoint nSPoint = null;
            if (this.hasLocation) {
                nSObject = nSWindow.contentView();
                Point point = this.display.map(null, (Control)shell, new Point(this.x, this.y));
                nSPoint = new NSPoint();
                double d2 = nSWindow.userSpaceScaleFactor();
                nSPoint.x = (double)point.x * d2;
                nSPoint.y = (((NSView)nSObject).frame().height - (double)point.y) * d2;
            } else {
                nSPoint = nSWindow.mouseLocationOutsideOfEventStream();
            }
            this.hasLocation = false;
            nSWindow.retain();
            this.display.sendPreExternalEventDispatchEvent();
            nSObject = NSEvent.otherEventWithType(15L, nSPoint, 0L, 0.0, nSWindow.windowNumber(), nSWindow.graphicsContext(), (short)0, 0L, 0L);
            NSMenu.popUpContextMenu(this.nsMenu, (NSEvent)nSObject, shell.view);
            this.display.sendPostExternalEventDispatchEvent();
            nSWindow.release();
        } else {
            this.nsMenu.cancelTracking();
        }
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    void createHandle() {
        this.display.addMenu(this);
        if (this.nsMenu == null) {
            NSMenu nSMenu = (NSMenu)new SWTMenu().alloc();
            nSMenu = nSMenu.initWithTitle(NSString.string());
            nSMenu.setAutoenablesItems(false);
            nSMenu.setDelegate(nSMenu);
            this.nsMenu = nSMenu;
        } else {
            this.nsMenu.retain();
            long l2 = OS.object_getClass(this.nsMenu.id);
            long l3 = this.display.createMenuSubclass(l2, "SWTSystemMenu", true);
            if (l2 != l3) {
                OS.object_setClass(this.nsMenu.id, l3);
            }
            this.nsMenu.setDelegate(this.nsMenu);
        }
    }

    void createItem(MenuItem menuItem, int n2) {
        Object object;
        if (0 > n2 || n2 > this.itemCount) {
            this.error(6);
        }
        boolean bl2 = true;
        NSMenuItem nSMenuItem = menuItem.nsItem;
        if (nSMenuItem == null) {
            if ((menuItem.style & 2) != 0) {
                nSMenuItem = NSMenuItem.separatorItem();
                nSMenuItem.retain();
            } else {
                nSMenuItem = (NSMenuItem)new SWTMenuItem().alloc();
                object = NSString.string();
                nSMenuItem.initWithTitle((NSString)object, 0L, (NSString)object);
                nSMenuItem.setTarget(nSMenuItem);
                nSMenuItem.setAction(OS.sel_sendSelection);
            }
            menuItem.nsItem = nSMenuItem;
        } else {
            long l2;
            long l3 = OS.object_getClass(nSMenuItem.id);
            if (l3 != (l2 = this.display.createMenuItemSubclass(l3, "SWTSystemMenuItem", true))) {
                OS.object_setClass(nSMenuItem.id, l2);
            }
            nSMenuItem.retain();
            menuItem.nsItemAction = nSMenuItem.action();
            menuItem.nsItemTarget = nSMenuItem.target();
            nSMenuItem.setTarget(nSMenuItem);
            nSMenuItem.setAction(OS.sel_sendSelection);
            int n3 = 8;
            if (nSMenuItem.isSeparatorItem()) {
                n3 = 2;
            }
            if (nSMenuItem.submenu() != null) {
                n3 = 64;
            }
            menuItem.style |= n3;
            menuItem.text = nSMenuItem.title().getString();
            long l4 = nSMenuItem.keyEquivalentModifierMask();
            NSString nSString = nSMenuItem.keyEquivalent();
            long l5 = 0L;
            if (nSString != null) {
                l5 = nSString.characterAtIndex(0L);
                if ((l4 & 0x100000L) != 0L) {
                    l5 |= 0x400000L;
                }
                if ((l4 & 0x80000L) != 0L) {
                    l5 |= 0x10000L;
                }
                menuItem.accelerator = (int)l5;
            }
            bl2 = false;
        }
        menuItem.createJNIRef();
        menuItem.register();
        if (bl2) {
            this.nsMenu.insertItem(nSMenuItem, n2);
        }
        if (this.itemCount == this.items.length) {
            object = new MenuItem[this.items.length + 4];
            System.arraycopy(this.items, 0, object, 0, this.items.length);
            this.items = object;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount++ - n2);
        this.items[n2] = menuItem;
        if (bl2) {
            NSApplication nSApplication;
            NSMenu nSMenu;
            object = menuItem.createEmptyMenu();
            if (object != null) {
                nSMenuItem.setSubmenu((NSMenu)object);
                ((NSObject)object).release();
            }
            if (this.display.menuBar == this && (nSMenu = (nSApplication = this.display.application).mainMenu()) != null) {
                nSMenuItem.setMenu(null);
                nSMenu.insertItem(nSMenuItem, n2 + 1);
            }
        }
        if (!this.getEnabled()) {
            nSMenuItem.setEnabled(false);
        }
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.items = new MenuItem[4];
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsMenu);
    }

    void destroyItem(MenuItem menuItem) {
        NSApplication nSApplication;
        NSMenu nSMenu;
        int n2;
        for (n2 = 0; n2 < this.itemCount && this.items[n2] != menuItem; ++n2) {
        }
        if (n2 == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --this.itemCount - n2);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.items = new MenuItem[4];
        }
        this.nsMenu.removeItem(menuItem.nsItem);
        if (this.display.menuBar == this && (nSMenu = (nSApplication = this.display.application).mainMenu()) != null) {
            NSMenuItem nSMenuItem = menuItem.nsItem;
            nSMenu.removeItem(nSMenuItem);
        }
    }

    void fixMenus(Decorations decorations) {
        this.parent = decorations;
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public MenuItem getItem(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        return this.items[n2];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        MenuItem[] menuItemArray = new MenuItem[this.itemCount];
        int n2 = 0;
        if (this.items != null) {
            for (int i2 = 0; i2 < this.itemCount; ++i2) {
                MenuItem menuItem = this.items[i2];
                if (menuItem == null || menuItem.isDisposed()) continue;
                menuItemArray[n2++] = menuItem;
            }
        }
        if (n2 != menuItemArray.length) {
            MenuItem[] menuItemArray2 = new MenuItem[n2];
            System.arraycopy(menuItemArray, 0, menuItemArray2, 0, n2);
            menuItemArray = menuItemArray2;
        }
        return menuItemArray;
    }

    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n2 = menuItemArray.length;
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                string = string + menuItemArray[i2].getNameText() + ", ";
            }
            string = string + menuItemArray[n2 - 1].getNameText();
        }
        return string;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        if (this.parent != null) {
            return this.parent.getShell();
        }
        return null;
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            if (this == this.display.appMenuBar) {
                return this.display.application.isActive();
            }
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            Menu[] menuArray = this.display.popups;
            if (menuArray == null) {
                return false;
            }
            for (int i2 = 0; i2 < menuArray.length; ++i2) {
                if (menuArray[i2] != this) continue;
                return true;
            }
        }
        return this.visible;
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            if (this.items[i2] != menuItem) continue;
            return i2;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        if (this == this.display.appMenuBar) {
            return this.getEnabled();
        }
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void menu_willHighlightItem(long l2, long l3, long l4, long l5) {
        Widget widget = this.display.getWidget(l5);
        if (widget instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)widget;
            menuItem.sendEvent(30);
        }
    }

    void menuNeedsUpdate(long l2, long l3, long l4) {
    }

    void menuWillOpen(long l2, long l3, long l4) {
        Object object;
        MenuItem menuItem;
        int n2;
        this.visible = true;
        this.sendEvent(22);
        if (this.isDisposed()) {
            return;
        }
        double d2 = 0.0;
        NSAttributedString[] nSAttributedStringArray = new NSAttributedString[this.itemCount];
        for (n2 = 0; n2 < this.itemCount; ++n2) {
            menuItem = this.items[n2];
            NSMenuItem nSMenuItem = menuItem.nsItem;
            nSAttributedStringArray[n2] = nSMenuItem.attributedTitle();
            object = nSMenuItem.image();
            double d3 = 4.0;
            if (nSAttributedStringArray[n2] != null) {
                d3 += nSAttributedStringArray[n2].size().width;
            }
            if (object != null) {
                d3 += ((NSImage)object).size().width + 4.0;
            }
            if (nSAttributedStringArray[n2] == null) continue;
            d2 = Math.max(d2, d3);
        }
        for (n2 = 0; n2 < this.itemCount; ++n2) {
            int n3;
            int n4;
            menuItem = this.items[n2];
            if (menuItem.updateAccelerator(true) || menuItem.accelerator != 0 || nSAttributedStringArray[n2] == null || (this.style & 2) != 0 || (menuItem.style & 0x40) != 0 || (n4 = menuItem.text.indexOf(9)) == -1 || (n3 = ((String)(object = menuItem.text.substring(n4))).length()) <= 1) continue;
            NSMenuItem nSMenuItem = menuItem.nsItem;
            NSImage nSImage = nSMenuItem.image();
            double d4 = d2;
            if (nSImage != null) {
                d4 -= nSImage.size().width + 4.0;
            }
            NSMutableAttributedString nSMutableAttributedString = new NSMutableAttributedString(nSAttributedStringArray[n2].mutableCopy());
            NSString nSString = (NSString)new NSString().alloc();
            nSString = nSString.initWithString((String)object);
            NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(1L);
            nSMutableDictionary.setObject(NSFont.menuBarFontOfSize(0.0), OS.NSFontAttributeName);
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSString, nSMutableDictionary);
            nSMutableDictionary.release();
            nSString.release();
            nSMutableAttributedString.appendAttributedString(nSAttributedString);
            nSAttributedString.release();
            NSRange nSRange = new NSRange();
            nSRange.length = nSMutableAttributedString.length();
            NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            nSMutableParagraphStyle.setTabStops(NSArray.array());
            NSTextTab nSTextTab = (NSTextTab)new NSTextTab().alloc();
            nSTextTab = nSTextTab.initWithType(0L, d4);
            nSMutableParagraphStyle.addTabStop(nSTextTab);
            nSTextTab.release();
            nSMutableAttributedString.addAttribute(OS.NSParagraphStyleAttributeName, nSMutableParagraphStyle, nSRange);
            nSMutableParagraphStyle.release();
            nSMenuItem.setAttributedTitle(nSMutableAttributedString);
            nSMutableAttributedString.release();
        }
    }

    void menuDidClose(long l2, long l3, long l4) {
        this.sendEvent(23);
        if (this.isDisposed()) {
            return;
        }
        this.visible = false;
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            MenuItem menuItem = this.items[i2];
            menuItem.updateAccelerator(false);
            if ((menuItem.style & 2) != 0) continue;
            menuItem.updateText();
        }
    }

    void register() {
        super.register();
        this.display.addWidget(this.nsMenu, this);
    }

    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                MenuItem menuItem = this.items[i2];
                if (menuItem == null || menuItem.isDisposed()) continue;
                menuItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl2);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsMenu != null) {
            this.nsMenu.release();
        }
        this.nsMenu = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this.parent != null && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.removeMenu(this);
        this.parent = null;
        this.defaultItem = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    void reskinChildren(int n2) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
            MenuItem menuItem = menuItemArray[i2];
            menuItem.reskin(n2);
        }
        super.reskinChildren(n2);
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem != null && menuItem.isDisposed()) {
            this.error(5);
        }
        this.defaultItem = menuItem;
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        this.state = bl2 ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            MenuItem menuItem = this.items[i2];
            if (menuItem == null) continue;
            menuItem.nsItem.setEnabled(bl2 && menuItem.getEnabled());
        }
    }

    public void setLocation(int n2, int n3) {
        this.checkWidget();
        this.x = n2;
        this.y = n3;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setOrientation(int n2) {
        this.checkWidget();
    }

    public void setVisible(boolean bl2) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl2) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

