/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    NSTableColumn column;
    String[] items;
    int itemCount;
    boolean ignoreSelect;
    boolean didSelect;
    boolean rowsChanged;
    boolean mouseIsDown;
    static int NEXT_ID;
    static final int CELL_GAP = 1;

    public List(Composite composite, int n2) {
        super(composite, List.checkStyle(n2));
    }

    long accessibilityAttributeValue(long l2, long l3, long l4) {
        return super.accessibilityAttributeValue(l2, l3, l4);
    }

    boolean acceptsFirstResponder(long l2, long l3) {
        return true;
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.itemCount == this.items.length) {
            String[] stringArray = new String[this.itemCount + 4];
            System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
            this.items = stringArray;
        }
        this.items[this.itemCount++] = string;
        this.updateRowCount();
        this.setScrollWidth(string);
    }

    public void add(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n2 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            String[] stringArray = new String[this.itemCount + 4];
            System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
            this.items = stringArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount++ - n2);
        this.items[n2] = string;
        this.updateRowCount();
        if (n2 != this.itemCount) {
            this.fixSelection(n2, true);
        }
        this.setScrollWidth(string);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return List.checkBits(n2, 4, 2, 0, 0, 0, 0);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 0;
        if (n2 == -1) {
            NSCell nSCell = this.column.dataCell();
            Font font = this.font != null ? this.font : this.defaultFont();
            nSCell.setFont(font.handle);
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                if (this.items[i2] == null) continue;
                nSCell.setTitle(NSString.stringWith(this.items[i2]));
                NSSize nSSize = nSCell.cellSize();
                n4 = Math.max(n4, (int)Math.ceil(nSSize.width));
            }
            ++n4;
        } else {
            n4 = n2;
        }
        if (n4 <= 0) {
            n4 = 64;
        }
        int n5 = 0;
        if (n3 == -1) {
            int n6 = this.getItemHeight() + 1;
            n5 = this.itemCount * n6;
        } else {
            n5 = n3;
        }
        if (n5 <= 0) {
            n5 = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n4, n5);
        return new Point(rectangle.width, rectangle.height);
    }

    void createHandle() {
        NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
        nSScrollView.init();
        if ((this.style & 0x100) != 0) {
            nSScrollView.setHasHorizontalScroller(true);
        }
        if ((this.style & 0x200) != 0) {
            nSScrollView.setHasVerticalScroller(true);
        }
        nSScrollView.setAutohidesScrollers(true);
        nSScrollView.setBorderType((this.style & 0x800) != 0 ? 2L : 0L);
        NSTableView nSTableView = (NSTableView)new SWTTableView().alloc();
        nSTableView.init();
        nSTableView.setAllowsMultipleSelection((this.style & 2) != 0);
        nSTableView.setDataSource(nSTableView);
        nSTableView.setHeaderView(null);
        nSTableView.setDelegate(nSTableView);
        if ((this.style & 0x100) != 0) {
            nSTableView.setColumnAutoresizingStyle(0L);
        }
        NSSize nSSize = new NSSize();
        nSSize.height = 1.0;
        nSSize.width = 1.0;
        nSTableView.setIntercellSpacing(nSSize);
        nSTableView.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            nSTableView.setFocusRingType(1L);
        }
        this.column = (NSTableColumn)new NSTableColumn().alloc();
        this.column = this.column.initWithIdentifier(NSString.stringWith(String.valueOf(++NEXT_ID)));
        this.column.setWidth(0.0);
        nSTableView.addTableColumn(this.column);
        this.scrollView = nSScrollView;
        this.view = nSTableView;
    }

    void createWidget() {
        super.createWidget();
        this.items = new String[4];
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        return this.display.tableViewFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    public void deselect(int n2) {
        this.checkWidget();
        if (0 <= n2 && n2 < this.itemCount) {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.deselectRow(n2);
            this.ignoreSelect = false;
        }
    }

    public void deselect(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        if (n3 < 0 || n2 >= this.itemCount) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(this.itemCount - 1, n3);
        if (n2 == 0 && n3 == this.itemCount - 1) {
            this.deselectAll();
        } else {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            for (int i2 = n2; i2 <= n3; ++i2) {
                nSTableView.deselectRow(i2);
            }
            this.ignoreSelect = false;
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nSTableView.deselectRow(nArray[i2]);
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.deselectAll(null);
        this.ignoreSelect = false;
    }

    boolean dragDetect(int n2, int n3, boolean bl2, boolean[] blArray) {
        NSTableView nSTableView = (NSTableView)this.view;
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = n2;
        nSPoint.y = n3;
        long l2 = nSTableView.rowAtPoint(nSPoint);
        if (l2 == -1L) {
            return false;
        }
        boolean bl3 = super.dragDetect(n2, n3, bl2, blArray);
        if (bl3 && !nSTableView.isRowSelected(l2)) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(l2);
            nSTableView.selectRowIndexes(nSIndexSet, false);
            nSIndexSet.release();
        }
        blArray[0] = bl3;
        return bl3;
    }

    void drawBackgroundInClipRect(long l2, long l3, NSRect nSRect) {
        super.drawViewBackgroundInRect(l2, l3, nSRect);
        if (l2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, NSGraphicsContext.currentContext(), nSRect, -1);
    }

    void fixSelection(int n2, boolean bl2) {
        int[] nArray = this.getSelectionIndices();
        if (nArray.length == 0) {
            return;
        }
        int n3 = 0;
        boolean bl3 = false;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!bl2 && nArray[i2] == n2) {
                bl3 = true;
                continue;
            }
            int n4 = n3++;
            nArray[n4] = nArray[i2];
            if (nArray[n4] < n2) continue;
            int n5 = n4;
            nArray[n5] = nArray[n5] + (bl2 ? 1 : -1);
            bl3 = true;
        }
        if (bl3) {
            this.select(nArray, n3, true);
        }
    }

    public int getFocusIndex() {
        this.checkWidget();
        return (int)((NSTableView)this.view).selectedRow();
    }

    public String getItem(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        return this.items[n2];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSTableView)this.view).rowHeight();
    }

    public String[] getItems() {
        this.checkWidget();
        String[] stringArray = new String[this.itemCount];
        System.arraycopy(this.items, 0, stringArray, 0, this.itemCount);
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return new String[0];
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n2 = (int)nSIndexSet.count();
        long[] lArray = new long[n2];
        nSIndexSet.getIndexes(lArray, n2, 0L);
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.items[(int)lArray[i2]];
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)((NSTableView)this.view).numberOfSelectedRows();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return -1;
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n2 = (int)nSIndexSet.count();
        long[] lArray = new long[n2];
        nSIndexSet.getIndexes(lArray, n2, 0L);
        return (int)lArray[0];
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return new int[0];
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n2 = (int)nSIndexSet.count();
        long[] lArray = new long[n2];
        nSIndexSet.getIndexes(lArray, n2, 0L);
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = (int)lArray[i2];
        }
        return nArray;
    }

    public int getTopIndex() {
        this.checkWidget();
        NSRect nSRect = this.scrollView.documentVisibleRect();
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = nSRect.x;
        nSPoint.y = nSRect.y;
        int n2 = (int)((NSTableView)this.view).rowAtPoint(nSPoint);
        if (n2 == -1) {
            n2 = 0;
        }
        return n2;
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            if (!this.items[i2].equals(string)) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        for (int i2 = n2; i2 < this.itemCount; ++i2) {
            if (!this.items[i2].equals(string)) continue;
            return i2;
        }
        return -1;
    }

    public boolean isSelected(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 >= this.itemCount) {
            return false;
        }
        return ((NSTableView)this.view).isRowSelected(n2);
    }

    long menuForEvent(long l2, long l3, long l4) {
        NSPoint nSPoint;
        long l5;
        NSEvent nSEvent = new NSEvent(l4);
        NSTableView nSTableView = (NSTableView)this.view;
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        if (!nSIndexSet.containsIndex(l5 = nSTableView.rowAtPoint(nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null)))) {
            NSIndexSet nSIndexSet2 = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet2 = nSIndexSet2.initWithIndex(l5);
            nSTableView.selectRowIndexes(nSIndexSet2, false);
            nSIndexSet2.release();
        }
        return super.menuForEvent(l2, l3, l4);
    }

    void mouseDownSuper(long l2, long l3, long l4) {
        this.ignoreSelect = false;
        NSTableView nSTableView = (NSTableView)this.view;
        NSEvent nSEvent = new NSEvent(l4);
        NSPoint nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null);
        int n2 = (int)nSTableView.rowAtPoint(nSPoint);
        if (n2 != -1 && (nSEvent.modifierFlags() & 0xFFFF0000L) == 0L && nSEvent.clickCount() == 1L && nSTableView.isRowSelected(n2) && nSTableView.selectedRowIndexes().count() == 1L && 0 <= n2 && n2 < this.itemCount) {
            this.sendSelection();
        }
        this.didSelect = false;
        super.mouseDownSuper(l2, l3, l4);
        this.didSelect = false;
    }

    boolean needsPanelToBecomeKey(long l2, long l3) {
        return false;
    }

    long numberOfRowsInTableView(long l2, long l3, long l4) {
        return this.itemCount;
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.column != null) {
            this.column.release();
        }
        this.column = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.items = null;
    }

    public void remove(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        this.remove(n2, true);
    }

    void remove(int n2, boolean bl2) {
        if (n2 != this.itemCount - 1) {
            this.fixSelection(n2, false);
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --this.itemCount - n2);
        this.items[this.itemCount] = null;
        this.updateRowCount();
        if (bl2) {
            this.setScrollWidth();
        }
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        if (0 > n2 || n2 > n3 || n3 >= this.itemCount) {
            this.error(6);
        }
        int n4 = n3 - n2 + 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            this.remove(n2, false);
        }
        this.setScrollWidth();
    }

    public void remove(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n2);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n2 = nArray2[nArray2.length - 1];
        int n3 = nArray2[0];
        int n4 = this.getItemCount();
        if (0 > n2 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        int n5 = -1;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n6 = nArray2[i2];
            if (n6 == n5) continue;
            this.remove(n6, false);
            n5 = n6;
        }
        this.setScrollWidth();
    }

    public void removeAll() {
        this.checkWidget();
        this.items = new String[4];
        this.itemCount = 0;
        this.updateRowCount();
        this.setScrollWidth();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n2) {
        this.checkWidget();
        if (0 <= n2 && n2 < this.itemCount) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(n2);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
            nSIndexSet.release();
        }
    }

    public void select(int n2, int n3) {
        this.checkWidget();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        if (this.itemCount == 0 || n2 >= this.itemCount) {
            return;
        }
        if (n2 == 0 && n3 == this.itemCount - 1) {
            this.selectAll();
        } else {
            n2 = Math.max(0, n2);
            n3 = Math.min(n3, this.itemCount - 1);
            NSRange nSRange = new NSRange();
            nSRange.location = n2;
            nSRange.length = n3 - n2 + 1;
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndexesInRange(nSRange);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
            nSIndexSet.release();
        }
    }

    public void select(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n2 = nArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        int n3 = 0;
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = nArray[i2];
            if (n4 < 0 || n4 >= this.itemCount) continue;
            nSMutableIndexSet.addIndex(nArray[i2]);
            ++n3;
        }
        if (n3 > 0) {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSMutableIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
        }
        nSMutableIndexSet.release();
    }

    void select(int[] nArray, int n2, boolean bl2) {
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        for (int i2 = 0; i2 < n2; ++i2) {
            nSMutableIndexSet.addIndex(nArray[i2]);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectRowIndexes(nSMutableIndexSet, !bl2);
        this.ignoreSelect = false;
        nSMutableIndexSet.release();
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectAll(null);
        this.ignoreSelect = false;
    }

    void sendDoubleSelection() {
        if (((NSTableView)this.view).clickedRow() != -1L) {
            this.sendSelectionEvent(14);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n2) {
        boolean bl2 = super.sendKeyEvent(nSEvent, n2);
        if (!bl2) {
            return bl2;
        }
        if (n2 != 1) {
            return bl2;
        }
        short s2 = nSEvent.keyCode();
        switch (s2) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
            }
        }
        return bl2;
    }

    boolean sendMouseEvent(NSEvent nSEvent, int n2, boolean bl2) {
        boolean bl3 = true;
        if (nSEvent != null) {
            long l2 = nSEvent.type();
            boolean bl4 = bl3 = l2 == 1L || l2 == 2L;
        }
        if (bl3) {
            if (n2 == 3) {
                this.mouseIsDown = true;
            } else if (n2 == 4 || n2 == 29) {
                this.mouseIsDown = false;
                if (this.rowsChanged) {
                    this.rowsChanged = false;
                    ((NSTableView)this.view).noteNumberOfRowsChanged();
                }
            }
        }
        return super.sendMouseEvent(nSEvent, n2, bl2);
    }

    void sendSelection() {
        if (this.ignoreSelect) {
            return;
        }
        this.sendSelectionEvent(13);
    }

    void setBackgroundColor(NSColor nSColor) {
        ((NSTableView)this.view).setBackgroundColor(nSColor);
    }

    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        double d2 = nSFont.ascender();
        double d3 = -nSFont.descender() + nSFont.leading();
        ((NSTableView)this.view).setRowHeight((int)Math.ceil(d2 + d3) + 1);
        this.setScrollWidth();
    }

    public void setItem(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        this.items[n2] = string;
        NSTableView nSTableView = (NSTableView)this.view;
        NSRect nSRect = nSTableView.rectOfRow(n2);
        nSTableView.setNeedsDisplayInRect(nSRect);
        this.setScrollWidth(string);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] != null) continue;
            this.error(5);
        }
        this.items = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.items, 0, stringArray.length);
        this.itemCount = stringArray.length;
        ((NSTableView)this.view).reloadData();
        this.setScrollWidth();
    }

    boolean setScrollWidth(String string) {
        if ((this.style & 0x100) == 0) {
            return false;
        }
        NSCell nSCell = this.column.dataCell();
        Font font = this.font != null ? this.font : this.defaultFont();
        nSCell.setFont(font.handle);
        nSCell.setTitle(NSString.stringWith(string));
        NSSize nSSize = nSCell.cellSize();
        double d2 = this.column.width();
        if (d2 < nSSize.width) {
            this.column.setWidth(nSSize.width);
            return true;
        }
        return false;
    }

    boolean setScrollWidth() {
        if ((this.style & 0x100) == 0) {
            return false;
        }
        if (this.items == null) {
            return false;
        }
        NSCell nSCell = this.column.dataCell();
        Font font = this.font != null ? this.font : this.defaultFont();
        nSCell.setFont(font.handle);
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            nSCell.setTitle(NSString.stringWith(this.items[i2]));
            NSSize nSSize = nSCell.cellSize();
            d2 = Math.max(d2, nSSize.width);
        }
        this.column.setWidth(d2);
        return true;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.deselectAll();
        if (0 <= n2 && n2 < this.itemCount) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(n2);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, false);
            this.ignoreSelect = false;
            nSIndexSet.release();
            this.showIndex(n2);
        }
    }

    public void setSelection(int n2, int n3) {
        this.checkWidget();
        this.deselectAll();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        if (this.itemCount == 0 || n2 >= this.itemCount) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, this.itemCount - 1);
        NSRange nSRange = new NSRange();
        nSRange.location = n2;
        nSRange.length = n3 - n2 + 1;
        NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
        nSIndexSet = nSIndexSet.initWithIndexesInRange(nSRange);
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectRowIndexes(nSIndexSet, false);
        this.ignoreSelect = false;
        nSIndexSet.release();
        this.showIndex(n3);
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = nArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = nArray[n2 - i2 - 1];
            if (n4 < 0 || n4 >= this.itemCount) continue;
            nArray2[n3++] = n4;
        }
        if (n3 > 0) {
            this.select(nArray2, n3, true);
            this.showIndex(nArray2[0]);
        }
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = stringArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        int n3 = 0;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            String string = stringArray[n2 - i2 - 1];
            if ((this.style & 4) != 0) {
                n4 = this.indexOf(string, 0);
                if (n4 == -1) continue;
                n3 = 1;
                nArray = new int[]{n4};
                continue;
            }
            n4 = 0;
            while ((n4 = this.indexOf(string, n4)) != -1) {
                if (n3 == nArray.length) {
                    int[] nArray2 = new int[nArray.length + 4];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray = nArray2;
                }
                nArray[n3++] = n4++;
            }
        }
        if (n3 > 0) {
            this.select(nArray, n3, true);
            this.showIndex(nArray[0]);
        }
    }

    public void setTopIndex(int n2) {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        int n3 = Math.max(0, Math.min(n2, this.itemCount));
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = this.scrollView.contentView().bounds().x;
        nSPoint.y = nSTableView.frameOfCellAtColumn((long)0L, (long)((long)n3)).y;
        this.view.scrollPoint(nSPoint);
    }

    void showIndex(int n2) {
        if (0 <= n2 && n2 < this.itemCount) {
            ((NSTableView)this.view).scrollRowToVisible(n2);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n2 = this.getSelectionIndex();
        if (n2 >= 0) {
            this.showIndex(n2);
        }
    }

    void tableViewSelectionDidChange(long l2, long l3, long l4) {
        if (this.didSelect) {
            return;
        }
        this.sendSelection();
    }

    void tableViewSelectionIsChanging(long l2, long l3, long l4) {
        this.didSelect = true;
        this.sendSelection();
    }

    long tableView_objectValueForTableColumn_row(long l2, long l3, long l4, long l5, long l6) {
        double[] dArray = ((NSTableView)this.view).isRowSelected(l6) ? null : this.foreground;
        NSAttributedString nSAttributedString = this.createString(this.items[(int)l6], null, dArray, 16384, false, this.getEnabled(), false);
        nSAttributedString.autorelease();
        return nSAttributedString.id;
    }

    long tableView_selectionIndexesForProposedSelection(long l2, long l3, long l4, long l5) {
        if ((this.style & 4) != 0) {
            NSIndexSet nSIndexSet = new NSIndexSet(l5);
            NSTableView nSTableView = new NSTableView(l4);
            if (nSIndexSet.count() != 1L && nSTableView.selectedRow() != -1L) {
                NSIndexSet nSIndexSet2 = (NSIndexSet)new NSIndexSet().alloc();
                nSIndexSet2 = nSIndexSet2.initWithIndex(nSTableView.selectedRow());
                nSIndexSet2.autorelease();
                return nSIndexSet2.id;
            }
        }
        return l5;
    }

    void updateRowCount() {
        if (this.mouseIsDown) {
            this.rowsChanged = true;
        } else {
            NSTableView nSTableView = (NSTableView)this.view;
            this.setRedraw(false);
            this.ignoreSelect = true;
            nSTableView.noteNumberOfRowsChanged();
            this.ignoreSelect = false;
            nSTableView.tile();
            this.setRedraw(true);
        }
    }
}

