/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBox;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageView;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTBox;
import org.eclipse.swt.internal.cocoa.SWTImageView;
import org.eclipse.swt.internal.cocoa.SWTTextField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    String text;
    Image image;
    boolean isImage;
    NSTextField textView;
    NSImageView imageView;
    NSView separator;

    public Label(Composite composite, int n2) {
        super(composite, Label.checkStyle(n2));
    }

    long accessibleHandle() {
        return this.eventView().id;
    }

    boolean accessibilityIsIgnored(long l2, long l3) {
        if (l2 == this.view.id) {
            return true;
        }
        return super.accessibilityIsIgnored(l2, l3);
    }

    void addRelation(Control control) {
        if (!control.isDescribedByLabel()) {
            return;
        }
        if (this.textView != null) {
            NSObject nSObject;
            NSObject nSObject2 = control.focusView();
            if (nSObject2 instanceof NSControl && (nSObject = (NSControl)nSObject2).cell() != null) {
                nSObject2 = nSObject.cell();
            }
            nSObject2.accessibilitySetOverrideValue(this.textView.cell(), OS.NSAccessibilityTitleUIElementAttribute);
            nSObject = NSArray.arrayWithObject(nSObject2);
            this.textView.cell().accessibilitySetOverrideValue(nSObject, OS.NSAccessibilityServesAsTitleForUIElementsAttribute);
        }
    }

    static int checkStyle(int n2) {
        if (((n2 |= 0x80000) & 2) != 0) {
            n2 = Label.checkBits(n2, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(n2, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(n2, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 64;
        int n5 = 64;
        if ((this.style & 2) != 0) {
            double d2 = ((NSBox)this.view).borderWidth();
            if ((this.style & 0x100) != 0) {
                n5 = (int)Math.ceil(d2 * 2.0);
            } else {
                n4 = (int)Math.ceil(d2 * 2.0);
            }
            if (n2 != -1) {
                n4 = n2;
            }
            if (n3 != -1) {
                n5 = n3;
            }
            int n6 = this.getBorderWidth();
            return new Point(n4 += n6 * 2, n5 += n6 * 2);
        }
        if (this.isImage) {
            if (this.image != null) {
                NSImage nSImage = this.image.handle;
                NSSize nSSize = nSImage.size();
                n4 = (int)nSSize.width;
                n5 = (int)nSSize.height;
            } else {
                n5 = 0;
                n4 = 0;
            }
        } else {
            NSSize nSSize = null;
            if ((this.style & 0x40) != 0 && n2 != -1) {
                NSRect nSRect = new NSRect();
                nSRect.width = n2;
                nSRect.height = n3 != -1 ? (double)n3 : 3.4028234663852886E38;
                nSSize = this.textView.cell().cellSizeForBounds(nSRect);
            } else {
                nSSize = this.textView.cell().cellSize();
            }
            n4 = (int)Math.ceil(nSSize.width);
            n5 = (int)Math.ceil(nSSize.height);
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        return new Point(n4, n5);
    }

    void createHandle() {
        this.state |= 0x800;
        NSBox nSBox = (NSBox)new SWTBox().alloc();
        if ((this.style & 2) != 0) {
            NSRect nSRect = new NSRect();
            nSRect.width = 64.0;
            nSRect.height = 64.0;
            nSBox.initWithFrame(nSRect);
            nSBox.setTitle(NSString.string());
            nSBox.setBorderType(0L);
            nSBox.setBoxType(4L);
            nSBox.setContentViewMargins(new NSSize());
            double d2 = nSBox.borderWidth();
            if ((this.style & 0x100) != 0) {
                nSRect.height = (int)Math.ceil(d2 * 2.0);
                nSRect.y = 32.0 - nSRect.height / 2.0;
            } else {
                nSRect.width = (int)Math.ceil(d2 * 2.0);
                nSRect.x = 32.0 - nSRect.width / 2.0;
            }
            NSBox nSBox2 = (NSBox)new SWTBox().alloc();
            nSBox2.initWithFrame(nSRect);
            nSBox2.setBoxType(2L);
            if ((this.style & 0x100) != 0) {
                nSBox2.setAutoresizingMask(42L);
            } else {
                nSBox2.setAutoresizingMask(21L);
            }
            NSView nSView = (NSView)new NSView().alloc().init();
            nSBox2.setContentView(nSView);
            nSView.release();
            nSBox.addSubview(nSBox2);
            this.separator = nSBox2;
        } else {
            nSBox.init();
            nSBox.setTitle(NSString.string());
            nSBox.setBorderType(0L);
            nSBox.setBorderWidth(0.0);
            nSBox.setBoxType(4L);
            NSSize nSSize = new NSSize();
            nSBox.setContentViewMargins(nSSize);
            NSImageView nSImageView = (NSImageView)new SWTImageView().alloc();
            nSImageView.init();
            nSImageView.setImageScaling(2L);
            NSTextField nSTextField = (NSTextField)new SWTTextField().alloc();
            nSTextField.init();
            nSTextField.setBordered(false);
            nSTextField.setEditable(false);
            nSTextField.setDrawsBackground(false);
            NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(nSTextField.cell());
            nSTextFieldCell.setWraps((this.style & 0x40) != 0);
            nSBox.addSubview(nSImageView);
            nSBox.addSubview(nSTextField);
            nSBox.setContentView(nSTextField);
            this.imageView = nSImageView;
            this.textView = nSTextField;
            this._setAlignment();
        }
        this.view = nSBox;
    }

    void createWidget() {
        this.text = "";
        super.createWidget();
    }

    NSAttributedString createString() {
        NSAttributedString nSAttributedString = this.createString(this.text, null, this.foreground, this.style, (this.style & 0x40) != 0, true, true);
        nSAttributedString.autorelease();
        return nSAttributedString;
    }

    NSFont defaultNSFont() {
        return this.display.textFieldFont;
    }

    void deregister() {
        super.deregister();
        if (this.textView != null) {
            this.display.removeWidget(this.textView);
            this.display.removeWidget(this.textView.cell());
        }
        if (this.imageView != null) {
            this.display.removeWidget(this.imageView);
            this.display.removeWidget(this.imageView.cell());
        }
        if (this.separator != null) {
            this.display.removeWidget(this.separator);
        }
    }

    void drawBackground(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
    }

    long imageView() {
        return this.imageView.id;
    }

    boolean drawsBackground() {
        return this.background != null || this.backgroundImage != null;
    }

    NSView eventView() {
        return ((NSBox)this.view).contentView();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    boolean isDescribedByLabel() {
        return false;
    }

    void register() {
        super.register();
        if (this.textView != null) {
            this.display.addWidget(this.textView, this);
            this.display.addWidget(this.textView.cell(), this);
        }
        if (this.imageView != null) {
            this.display.addWidget(this.imageView, this);
            this.display.addWidget(this.imageView.cell(), this);
        }
        if (this.separator != null) {
            this.display.addWidget(this.separator, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.textView != null) {
            this.textView.release();
        }
        if (this.imageView != null) {
            this.imageView.release();
        }
        if (this.separator != null) {
            this.separator.release();
        }
        this.textView = null;
        this.imageView = null;
        this.separator = null;
    }

    void removeRelation() {
        if (this.textView != null) {
            this.textView.cell().accessibilitySetOverrideValue(null, OS.NSAccessibilityServesAsTitleForUIElementsAttribute);
        }
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((n2 & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n2 & 0x1024000;
        this._setAlignment();
    }

    void _setAlignment() {
        if (this.image != null) {
            if ((this.style & 0x20000) != 0) {
                this.imageView.setImageAlignment(8L);
            }
            if ((this.style & 0x4000) != 0) {
                this.imageView.setImageAlignment(4L);
            }
            if ((this.style & 0x1000000) != 0) {
                this.imageView.setImageAlignment(0L);
            }
        }
        if (this.text != null) {
            NSCell nSCell = new NSCell(this.textView.cell());
            nSCell.setAttributedStringValue(this.createString());
        }
    }

    void setFont(NSFont nSFont) {
        if (this.textView != null) {
            NSCell nSCell = new NSCell(this.textView.cell());
            nSCell.setAttributedStringValue(this.createString());
            this.textView.setFont(nSFont);
        }
    }

    void setForeground(double[] dArray) {
        if ((this.style & 2) != 0) {
            return;
        }
        NSCell nSCell = new NSCell(this.textView.cell());
        nSCell.setAttributedStringValue(this.createString());
    }

    boolean setTabItemFocus() {
        return false;
    }

    public void setImage(Image image) {
        NSImage nSImage;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        this.isImage = true;
        if (image != null && (nSImage = this.imageView.image()) != null && nSImage.id == image.handle.id) {
            this.imageView.setImage(null);
        }
        this.imageView.setImage(image != null ? image.handle : null);
        ((NSBox)this.view).setContentView(this.imageView);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.isImage = false;
        this.text = string;
        NSCell nSCell = new NSCell(this.textView.cell());
        nSCell.setAttributedStringValue(this.createString());
        ((NSBox)this.view).setContentView(this.textView);
    }
}

