/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;

public abstract class Item
extends Widget {
    String text = "";
    Image image;

    public Item(Widget widget, int n2) {
        super(widget, n2);
    }

    public Item(Widget widget, int n2, int n3) {
        this(widget, n2);
    }

    protected void checkSubclass() {
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
        this.image = null;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.state & 0) != 0) {
            this.updateTextDirection(0x6000000);
        }
    }

    boolean updateTextDirection(int n2) {
        if (n2 == 0x6000000) {
            this.state |= 0;
            n2 = (this.style ^ Item.resolveTextDirection(this.text)) == 0 ? 0 : Integer.MIN_VALUE;
        } else {
            this.state &= 0xFFFFFFFF;
        }
        if ((this.style & Integer.MIN_VALUE ^ n2) != 0) {
            this.style ^= Integer.MIN_VALUE;
            return true;
        }
        return n2 == 0x6000000;
    }
}

