/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSFontPanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;
    boolean selected;
    int fontID;
    int fontSize;
    boolean effectsVisible = true;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n2) {
        super(shell, FontDialog.checkStyle(shell, n2));
        this.checkSubclass();
    }

    void changeFont(long l2, long l3, long l4) {
        this.selected = true;
    }

    public boolean getEffectsVisible() {
        return this.effectsVisible;
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        NSFont nSFont;
        Display display = this.parent != null ? this.parent.display : Display.getCurrent();
        NSFontPanel nSFontPanel = NSFontPanel.sharedFontPanel();
        nSFontPanel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        boolean bl2 = this.fontData != null;
        Font font = bl2 ? new Font((Device)display, this.fontData) : display.getSystemFont();
        nSFontPanel.setPanelFont(font.handle, false);
        SWTPanelDelegate sWTPanelDelegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
        long l2 = OS.NewGlobalRef(this);
        if (l2 == 0L) {
            this.error(2);
        }
        OS.object_setInstanceVariable(sWTPanelDelegate.id, Display.SWT_OBJECT, l2);
        nSFontPanel.setDelegate(sWTPanelDelegate);
        this.fontData = null;
        this.selected = false;
        nSFontPanel.orderFront(null);
        display.setModalDialog(this);
        NSApplication.sharedApplication().runModalForWindow(nSFontPanel);
        display.setModalDialog(null);
        if (this.selected && (nSFont = nSFontPanel.panelConvertFont(font.handle)) != null) {
            this.fontData = Font.cocoa_new(display, nSFont).getFontData()[0];
        }
        nSFontPanel.setDelegate(null);
        sWTPanelDelegate.release();
        OS.DeleteGlobalRef(l2);
        if (bl2) {
            font.dispose();
        }
        return this.fontData;
    }

    void setColor_forAttribute(long l2, long l3, long l4, long l5) {
        if (l5 != 0L && NSString.stringWith("NSColor").isEqualToString(new NSString(l5))) {
            if (l4 != 0L) {
                NSColor nSColor = new NSColor(l4);
                Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
                double[] dArray = display.getNSColorRGB(nSColor);
                this.rgb = new RGB((int)(dArray[0] * 255.0), (int)(dArray[1] * 255.0), (int)(dArray[2] * 255.0));
            } else {
                this.rgb = null;
            }
        }
    }

    public void setEffectsVisible(boolean bl2) {
        this.effectsVisible = bl2;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    int validModesForFontPanel(long l2, long l3, long l4) {
        return this.effectsVisible ? -1 : -1048321;
    }

    void windowWillClose(long l2, long l3, long l4) {
        NSApplication.sharedApplication().stop(null);
    }
}

