/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.StringTokenizer;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSResponder;
import org.eclipse.swt.internal.cocoa.NSSavePanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    NSSavePanel panel;
    NSPopUpButton popup;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    int filterIndex = -1;
    boolean overwrite = false;
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n2) {
        super(shell, FileDialog.checkStyle(shell, n2));
        if (Display.getSheetEnabled() && shell != null && (n2 & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        NSObject nSObject;
        NSResponder nSResponder;
        long l2;
        Object object;
        String string = null;
        this.fileNames = new String[0];
        long l3 = 0L;
        long l4 = 0L;
        Callback callback = null;
        if ((this.style & 0x2000) != 0) {
            object = NSSavePanel.savePanel();
            this.panel = object;
            if (!this.overwrite) {
                callback = new Callback(this, "_overwriteExistingFileCheck", 3);
                l2 = callback.getAddress();
                if (l2 == 0L) {
                    this.error(3);
                }
                if ((l3 = OS.class_getInstanceMethod(OS.class_NSSavePanel, OS.sel_overwriteExistingFileCheck)) != 0L) {
                    l4 = OS.method_setImplementation(l3, l2);
                }
            }
        } else {
            object = NSOpenPanel.openPanel();
            ((NSOpenPanel)object).setAllowsMultipleSelection((this.style & 2) != 0);
            this.panel = object;
        }
        object = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.panel.setCanCreateDirectories(true);
        OS.objc_msgSend(this.panel.id, OS.sel_setShowsHiddenFiles_, true);
        l2 = 0L;
        SWTPanelDelegate sWTPanelDelegate = null;
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            sWTPanelDelegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
            l2 = OS.NewGlobalRef(this);
            if (l2 == 0L) {
                this.error(2);
            }
            OS.object_setInstanceVariable(sWTPanelDelegate.id, Display.SWT_OBJECT, l2);
            this.panel.setDelegate(sWTPanelDelegate);
            nSResponder = (NSPopUpButton)new NSPopUpButton().alloc();
            ((NSPopUpButton)nSResponder).initWithFrame(new NSRect(), false);
            ((NSControl)nSResponder).setTarget(sWTPanelDelegate);
            ((NSControl)nSResponder).setAction(OS.sel_sendSelection_);
            nSObject = ((NSPopUpButton)nSResponder).menu();
            ((NSMenu)nSObject).setAutoenablesItems(false);
            for (int i2 = 0; i2 < this.filterExtensions.length; ++i2) {
                String string2 = this.filterExtensions[i2];
                if (this.filterNames != null && this.filterNames.length > i2) {
                    string2 = this.filterNames[i2];
                }
                NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
                nSMenuItem.initWithTitle(NSString.stringWith(string2), 0L, NSString.string());
                ((NSMenu)nSObject).addItem(nSMenuItem);
                nSMenuItem.release();
            }
            ((NSPopUpButton)nSResponder).selectItemAtIndex(0 <= this.filterIndex && this.filterIndex < this.filterExtensions.length ? (long)this.filterIndex : 0L);
            ((NSControl)nSResponder).sizeToFit();
            this.panel.setAccessoryView((NSView)nSResponder);
            this.popup = nSResponder;
            this.setAllowedFileType(this.filterExtensions[0]);
            this.panel.setAllowsOtherFileTypes(true);
            this.panel.setTreatsFilePackagesAsDirectories(this.shouldTreatAppAsDirectory(this.filterExtensions[0]));
        } else {
            this.panel.setTreatsFilePackagesAsDirectories(false);
        }
        this.panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        nSResponder = NSApplication.sharedApplication();
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            ((NSApplication)nSResponder).beginSheet(this.panel, this.parent.view.window(), null, 0L, 0L);
        }
        ((Display)object).setModalDialog(this, this.panel);
        nSObject = this.filterPath != null && this.filterPath.length() > 0 ? NSString.stringWith(this.filterPath) : null;
        NSString nSString = this.fileName != null && this.fileName.length() > 0 ? NSString.stringWith(this.fileName) : null;
        long l5 = this.panel.runModalForDirectory((NSString)nSObject, nSString);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            ((NSApplication)nSResponder).endSheet(this.panel, 0L);
        }
        ((Display)object).setModalDialog(null);
        if (!this.overwrite) {
            if (l3 != 0L) {
                OS.method_setImplementation(l3, l4);
            }
            if (callback != null) {
                callback.dispose();
            }
        }
        this.filterIndex = this.popup != null ? (int)this.popup.indexOfSelectedItem() : -1;
        if (l5 == 1L) {
            NSString nSString2 = this.panel.filename();
            if ((this.style & 0x2000) != 0) {
                string = nSString2.getString();
                this.fileNames = new String[1];
                this.fileName = this.fileNames[0] = nSString2.lastPathComponent().getString();
                this.filterPath = nSString2.stringByDeletingLastPathComponent().getString();
            } else {
                string = nSString2.getString();
                NSArray nSArray = ((NSOpenPanel)this.panel).filenames();
                int n2 = (int)nSArray.count();
                this.fileNames = new String[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    nSString2 = new NSString(nSArray.objectAtIndex(i3));
                    NSString nSString3 = nSString2.lastPathComponent();
                    NSString nSString4 = nSString2.stringByDeletingLastPathComponent();
                    if (i3 == 0) {
                        this.filterPath = nSString4.getString();
                        this.fileName = this.fileNames[0] = nSString3.getString();
                        continue;
                    }
                    this.fileNames[i3] = nSString4.getString().equals(this.filterPath) ? nSString3.getString() : nSString2.getString();
                }
            }
        }
        if (this.popup != null) {
            this.panel.setAccessoryView(null);
            this.popup.release();
            this.popup = null;
        }
        if (sWTPanelDelegate != null) {
            this.panel.setDelegate(null);
            sWTPanelDelegate.release();
        }
        if (l2 != 0L) {
            OS.DeleteGlobalRef(l2);
        }
        this.panel = null;
        return string;
    }

    long _overwriteExistingFileCheck(long l2, long l3, long l4) {
        return 1L;
    }

    long panel_shouldShowFilename(long l2, long l3, long l4, long l5) {
        NSString nSString = new NSString(l5);
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            NSFileManager nSFileManager = NSFileManager.defaultManager();
            long l6 = OS.malloc(1L);
            boolean bl2 = nSFileManager.fileExistsAtPath(nSString, l6);
            byte[] byArray = new byte[1];
            OS.memmove(byArray, l6, 1L);
            OS.free(l6);
            if (bl2) {
                if (byArray[0] != 0) {
                    return 1L;
                }
                if (this.popup != null) {
                    String string = nSString.lastPathComponent().getString();
                    int n2 = (int)this.popup.indexOfSelectedItem();
                    String string2 = this.filterExtensions[n2];
                    int n3 = 0;
                    int n4 = string2.length();
                    while (n3 < n4) {
                        String string3;
                        int n5 = string2.indexOf(59, n3);
                        if (n5 == -1) {
                            n5 = n4;
                        }
                        if ((string3 = string2.substring(n3, n5).trim()).equalsIgnoreCase(string)) {
                            return 1L;
                        }
                        if (string3.equals("*") || string3.equals("*.*")) {
                            return 1L;
                        }
                        if (string3.startsWith("*.")) {
                            string3 = string3.substring(2);
                        }
                        if (string.toLowerCase().endsWith("." + string3.toLowerCase())) {
                            return 1L;
                        }
                        n3 = n5 + 1;
                    }
                    return 0L;
                }
            }
        }
        return 1L;
    }

    void sendSelection(long l2, long l3, long l4) {
        if (this.filterExtensions != null && this.filterExtensions.length > 0) {
            String string = this.filterExtensions[(int)this.popup.indexOfSelectedItem()];
            this.panel.setTreatsFilePackagesAsDirectories(this.shouldTreatAppAsDirectory(string));
            this.setAllowedFileType(string);
        }
        this.panel.validateVisibleColumns();
    }

    void setAllowedFileType(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(';'));
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(1L);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("*") || string2.equals("*.*")) {
                this.panel.setAllowedFileTypes(null);
                return;
            }
            if (string2.startsWith("*.")) {
                string2 = string2.substring(2);
            } else if (string2.startsWith(".")) {
                string2 = string2.substring(1);
            }
            nSMutableArray.addObject(NSString.stringWith(string2));
        }
        this.panel.setAllowedFileTypes(nSMutableArray);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n2) {
        this.filterIndex = n2;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl2) {
        this.overwrite = bl2;
    }

    boolean shouldTreatAppAsDirectory(String string) {
        if ((this.style & 0x2000) != 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(';'));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("*") || string2.equals("*.*")) {
                return true;
            }
            if (!string2.equals("*.app") && !string2.equals(".app")) continue;
            return false;
        }
        return true;
    }
}

