/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;
    static final int TEXT_INSET = 6;
    static final int BORDER = 1;
    static final int CHEVRON_SIZE = 24;

    public ExpandItem(ExpandBar expandBar, int n2) {
        this(expandBar, n2, ExpandItem.checkNull(expandBar).getItemCount());
    }

    public ExpandItem(ExpandBar expandBar, int n2, int n3) {
        super(expandBar, n2);
        this.parent = expandBar;
        expandBar.createItem(this, n2, n3);
    }

    static ExpandBar checkNull(ExpandBar expandBar) {
        if (expandBar == null) {
            SWT.error(4);
        }
        return expandBar;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
    }

    void drawChevron(GC gC, int n2, int n3) {
        int[] nArray;
        int[] nArray2;
        if (this.expanded) {
            int n4 = n2 + 4 + 5;
            int n5 = n3 + 4 + 7;
            nArray2 = new int[]{n4, n5, n4 + 1, n5, n4 + 1, n5 - 1, n4 + 2, n5 - 1, n4 + 2, n5 - 2, n4 + 3, n5 - 2, n4 + 3, n5 - 3, n4 + 3, n5 - 2, n4 + 4, n5 - 2, n4 + 4, n5 - 1, n4 + 5, n5 - 1, n4 + 5, n5, n4 + 6, n5};
            nArray = new int[]{n4, n5 += 4, n4 + 1, n5, n4 + 1, n5 - 1, n4 + 2, n5 - 1, n4 + 2, n5 - 2, n4 + 3, n5 - 2, n4 + 3, n5 - 3, n4 + 3, n5 - 2, n4 + 4, n5 - 2, n4 + 4, n5 - 1, n4 + 5, n5 - 1, n4 + 5, n5, n4 + 6, n5};
        } else {
            int n6 = n2 + 4 + 5;
            int n7 = n3 + 4 + 4;
            nArray2 = new int[]{n6, n7, n6 + 1, n7, n6 + 1, n7 + 1, n6 + 2, n7 + 1, n6 + 2, n7 + 2, n6 + 3, n7 + 2, n6 + 3, n7 + 3, n6 + 3, n7 + 2, n6 + 4, n7 + 2, n6 + 4, n7 + 1, n6 + 5, n7 + 1, n6 + 5, n7, n6 + 6, n7};
            nArray = new int[]{n6, n7 += 4, n6 + 1, n7, n6 + 1, n7 + 1, n6 + 2, n7 + 1, n6 + 2, n7 + 2, n6 + 3, n7 + 2, n6 + 3, n7 + 3, n6 + 3, n7 + 2, n6 + 4, n7 + 2, n6 + 4, n7 + 1, n6 + 5, n7 + 1, n6 + 5, n7, n6 + 6, n7};
        }
        gC.setForeground(this.display.getSystemColor(30));
        gC.drawPolyline(nArray2);
        gC.drawPolyline(nArray);
    }

    void drawItem(GC gC, boolean bl2) {
        int n2 = this.parent.getBandHeight();
        Display display = this.getDisplay();
        gC.setForeground(display.getSystemColor(31));
        gC.setBackground(display.getSystemColor(32));
        gC.fillGradientRectangle(this.x, this.y, this.width, n2, true);
        if (this.expanded) {
            gC.setForeground(display.getSystemColor(32));
            gC.drawLine(this.x, this.y + n2, this.x, this.y + n2 + this.height - 1);
            gC.drawLine(this.x, this.y + n2 + this.height - 1, this.x + this.width - 1, this.y + n2 + this.height - 1);
            gC.drawLine(this.x + this.width - 1, this.y + n2 + this.height - 1, this.x + this.width - 1, this.y + n2);
        }
        int n3 = this.x;
        if (this.image != null) {
            n3 += 6;
            if (this.imageHeight > n2) {
                gC.drawImage(this.image, n3, this.y + n2 - this.imageHeight);
            } else {
                gC.drawImage(this.image, n3, this.y + (n2 - this.imageHeight) / 2);
            }
            n3 += this.imageWidth;
        }
        if (this.text.length() > 0) {
            Point point = gC.stringExtent(this.text);
            gC.setForeground(this.parent.getForeground());
            gC.drawString(this.text, n3 += 6, this.y + (n2 - point.y) / 2, true);
        }
        int n4 = 24;
        this.drawChevron(gC, this.x + this.width - n4, this.y + (n2 - n4) / 2);
        if (bl2) {
            gC.drawFocus(this.x + 1, this.y + 1, this.width - 2, n2 - 2);
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return Math.max(this.parent.getBandHeight(), this.imageHeight);
    }

    public int getHeight() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(GC gC) {
        int n2 = 36;
        if (this.image != null) {
            n2 += 6 + this.imageWidth;
        }
        if (this.text.length() > 0) {
            n2 += gC.stringExtent((String)this.text).x;
        }
        return n2;
    }

    void redraw() {
        int n2 = this.parent.getBandHeight();
        if (this.imageHeight > n2) {
            this.parent.redraw(this.x + 6, this.y + n2 - this.imageHeight, this.imageWidth, this.imageHeight, false);
        }
        this.parent.redraw(this.x, this.y, this.width, n2 + this.height, false);
    }

    void setBounds(int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        this.redraw();
        int n6 = this.parent.getBandHeight();
        if (bl2) {
            if (this.imageHeight > n6) {
                n3 += this.imageHeight - n6;
            }
            this.x = n2;
            this.y = n3;
            this.redraw();
        }
        if (bl3) {
            this.width = n4;
            this.height = n5;
            this.redraw();
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (bl2) {
                this.control.setLocation(n2 + 1, n3 + n6);
            }
            if (bl3) {
                this.control.setSize(Math.max(0, n4 - 2), Math.max(0, n5 - 1));
            }
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        this.control = control;
        if (control != null) {
            control.setVisible(this.expanded);
            int n2 = this.parent.getBandHeight();
            control.setBounds(this.x + 1, this.y + n2, Math.max(0, this.width - 2), Math.max(0, this.height - 1));
        }
    }

    public void setExpanded(boolean bl2) {
        this.checkWidget();
        this.expanded = bl2;
        this.parent.showItem(this);
    }

    public void setImage(Image image) {
        super.setImage(image);
        int n2 = this.imageHeight;
        if (image != null) {
            Rectangle rectangle = image.getBounds();
            this.imageHeight = rectangle.height;
            this.imageWidth = rectangle.width;
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        if (n2 != this.imageHeight) {
            this.parent.layoutItems(this.parent.indexOf(this), true);
        } else {
            this.redraw();
        }
    }

    public void setHeight(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        this.setBounds(0, 0, this.width, n2, false, true);
        if (this.expanded) {
            this.parent.layoutItems(this.parent.indexOf(this) + 1, true);
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.redraw();
    }
}

