/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items = new ExpandItem[4];
    int itemCount;
    ExpandItem focusItem;
    int spacing;
    int yCurrentScroll;
    Font font;
    Color foreground;
    Listener listener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 12: {
                    ExpandBar.this.onDispose(event);
                    break;
                }
                case 3: {
                    ExpandBar.this.onMouseDown(event);
                    break;
                }
                case 4: {
                    ExpandBar.this.onMouseUp(event);
                    break;
                }
                case 9: {
                    ExpandBar.this.onPaint(event);
                    break;
                }
                case 11: {
                    ExpandBar.this.onResize();
                    break;
                }
                case 1: {
                    ExpandBar.this.onKeyDown(event);
                    break;
                }
                case 15: {
                    ExpandBar.this.onFocus();
                    break;
                }
                case 16: {
                    ExpandBar.this.onFocus();
                    break;
                }
                case 31: {
                    ExpandBar.this.onTraverse(event);
                }
            }
        }
    };
    boolean inDispose;

    public ExpandBar(Composite composite, int n2) {
        super(composite, ExpandBar.checkStyle(n2));
        this.addListener(12, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(1, this.listener);
        this.addListener(15, this.listener);
        this.addListener(16, this.listener);
        this.addListener(31, this.listener);
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ExpandBar.this.onScroll(event);
                }
            });
        }
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(expandListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    static int checkStyle(int n2) {
        return n2 & 0xFFFFFEFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        Object object;
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if ((n2 == -1 || n3 == -1) && this.itemCount > 0) {
            n4 += this.spacing;
            object = new GC(this);
            for (int i2 = 0; i2 < this.itemCount; ++i2) {
                ExpandItem expandItem = this.items[i2];
                n4 += expandItem.getHeaderHeight();
                if (expandItem.expanded) {
                    n4 += expandItem.height;
                }
                n4 += this.spacing;
                n5 = Math.max(n5, expandItem.getPreferredWidth((GC)object));
            }
            ((Resource)object).dispose();
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n4 = n3;
        }
        object = this.computeTrim(0, 0, n5, n4);
        return new Point(((Rectangle)object).width, ((Rectangle)object).height);
    }

    void createItem(ExpandItem expandItem, int n2, int n3) {
        if (0 > n3 || n3 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] expandItemArray = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, expandItemArray, 0, this.items.length);
            this.items = expandItemArray;
        }
        System.arraycopy(this.items, n3, this.items, n3 + 1, this.itemCount - n3);
        this.items[n3] = expandItem;
        ++this.itemCount;
        if (this.focusItem == null) {
            this.focusItem = expandItem;
        }
        expandItem.width = Math.max(0, this.getClientArea().width - this.spacing * 2);
        this.layoutItems(n3, true);
    }

    void destroyItem(ExpandItem expandItem) {
        int n2;
        if (this.inDispose) {
            return;
        }
        for (n2 = 0; n2 < this.itemCount && this.items[n2] != expandItem; ++n2) {
        }
        if (n2 == this.itemCount) {
            return;
        }
        if (expandItem == this.focusItem) {
            int n3;
            int n4 = n3 = n2 > 0 ? n2 - 1 : 1;
            if (n3 < this.itemCount) {
                this.focusItem = this.items[n3];
                this.focusItem.redraw();
            } else {
                this.focusItem = null;
            }
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --this.itemCount - n2);
        this.items[this.itemCount] = null;
        expandItem.redraw();
        this.layoutItems(n2, true);
    }

    int getBandHeight() {
        if (this.font == null) {
            return 24;
        }
        GC gC = new GC(this);
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        return Math.max(24, fontMetrics.getHeight());
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            Display display = this.getDisplay();
            return display.getSystemColor(30);
        }
        return this.foreground;
    }

    public ExpandItem getItem(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        return this.items[n2];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] expandItemArray = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, expandItemArray, 0, this.itemCount);
        return expandItemArray;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    public int indexOf(ExpandItem expandItem) {
        this.checkWidget();
        if (expandItem == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            if (this.items[i2] != expandItem) continue;
            return i2;
        }
        return -1;
    }

    void layoutItems(int n2, boolean bl2) {
        if (n2 < this.itemCount) {
            ExpandItem expandItem;
            int n3;
            int n4 = this.spacing - this.yCurrentScroll;
            for (n3 = 0; n3 < n2; ++n3) {
                expandItem = this.items[n3];
                if (expandItem.expanded) {
                    n4 += expandItem.height;
                }
                n4 += expandItem.getHeaderHeight() + this.spacing;
            }
            for (n3 = n2; n3 < this.itemCount; ++n3) {
                expandItem = this.items[n3];
                expandItem.setBounds(this.spacing, n4, 0, 0, true, false);
                if (expandItem.expanded) {
                    n4 += expandItem.height;
                }
                n4 += expandItem.getHeaderHeight() + this.spacing;
            }
        }
        if (bl2) {
            this.setScrollbar();
        }
    }

    public void removeExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, expandListener);
        this.eventTable.unhook(18, expandListener);
    }

    void reskinChildren(int n2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                ExpandItem expandItem = this.items[i2];
                if (expandItem == null) continue;
                expandItem.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.layoutItems(0, true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar == null) {
            return;
        }
        int n2 = this.getClientArea().height;
        ExpandItem expandItem = this.items[this.itemCount - 1];
        int n3 = expandItem.y + this.getBandHeight() + this.spacing;
        if (expandItem.expanded) {
            n3 += expandItem.height;
        }
        if (this.yCurrentScroll > 0 && n2 > n3) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + n3 - n2);
            this.layoutItems(0, false);
        }
        int n4 = Math.min(this.yCurrentScroll, n3 += this.yCurrentScroll);
        int n5 = scrollBar.getIncrement();
        int n6 = scrollBar.getPageIncrement();
        scrollBar.setValues(n4, 0, n3, n2, n5, n6);
        scrollBar.setVisible(n3 > n2);
    }

    public void setSpacing(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n2 == this.spacing) {
            return;
        }
        this.spacing = n2;
        int n3 = Math.max(0, this.getClientArea().width - n2 * 2);
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            ExpandItem expandItem = this.items[i2];
            if (expandItem.width == n3) continue;
            expandItem.setBounds(0, 0, n3, expandItem.height, false, true);
        }
        this.layoutItems(0, true);
        this.redraw();
    }

    void showItem(ExpandItem expandItem) {
        Control control = expandItem.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(expandItem.expanded);
        }
        expandItem.redraw();
        int n2 = this.indexOf(expandItem);
        this.layoutItems(n2 + 1, true);
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            this.items[i2].dispose();
        }
        this.items = null;
        this.font = null;
        this.foreground = null;
        this.focusItem = null;
    }

    void onFocus() {
        if (this.focusItem != null) {
            this.focusItem.redraw();
        }
    }

    void onKeyDown(Event event) {
        if (this.focusItem == null) {
            return;
        }
        switch (event.keyCode) {
            case 13: 
            case 32: {
                Event event2 = new Event();
                event2.item = this.focusItem;
                this.sendEvent(this.focusItem.expanded ? 18 : 17, event2);
                this.focusItem.expanded = !this.focusItem.expanded;
                this.showItem(this.focusItem);
                break;
            }
            case 0x1000001: {
                int n2 = this.indexOf(this.focusItem);
                if (n2 <= 0) break;
                this.focusItem.redraw();
                this.focusItem = this.items[n2 - 1];
                this.focusItem.redraw();
                break;
            }
            case 0x1000002: {
                int n3 = this.indexOf(this.focusItem);
                if (n3 >= this.itemCount - 1) break;
                this.focusItem.redraw();
                this.focusItem = this.items[n3 + 1];
                this.focusItem.redraw();
                break;
            }
        }
    }

    void onMouseDown(Event event) {
        if (event.button != 1) {
            return;
        }
        int n2 = event.x;
        int n3 = event.y;
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            boolean bl2;
            ExpandItem expandItem = this.items[i2];
            boolean bl3 = bl2 = expandItem.x <= n2 && n2 < expandItem.x + expandItem.width && expandItem.y <= n3 && n3 < expandItem.y + this.getBandHeight();
            if (!bl2 || expandItem == this.focusItem) continue;
            this.focusItem.redraw();
            this.focusItem = expandItem;
            this.focusItem.redraw();
            this.forceFocus();
            break;
        }
    }

    void onMouseUp(Event event) {
        boolean bl2;
        if (event.button != 1) {
            return;
        }
        if (this.focusItem == null) {
            return;
        }
        int n2 = event.x;
        int n3 = event.y;
        boolean bl3 = bl2 = this.focusItem.x <= n2 && n2 < this.focusItem.x + this.focusItem.width && this.focusItem.y <= n3 && n3 < this.focusItem.y + this.getBandHeight();
        if (bl2) {
            Event event2 = new Event();
            event2.item = this.focusItem;
            this.notifyListeners(this.focusItem.expanded ? 18 : 17, event2);
            this.focusItem.expanded = !this.focusItem.expanded;
            this.showItem(this.focusItem);
        }
    }

    void onPaint(Event event) {
        boolean bl2 = this.isFocusControl();
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            ExpandItem expandItem = this.items[i2];
            expandItem.drawItem(event.gc, bl2 && expandItem == this.focusItem);
        }
    }

    void onResize() {
        Rectangle rectangle = this.getClientArea();
        int n2 = Math.max(0, rectangle.width - this.spacing * 2);
        for (int i2 = 0; i2 < this.itemCount; ++i2) {
            ExpandItem expandItem = this.items[i2];
            expandItem.setBounds(0, 0, n2, expandItem.height, false, true);
        }
        this.setScrollbar();
    }

    void onScroll(Event event) {
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            this.yCurrentScroll = scrollBar.getSelection();
            this.layoutItems(0, false);
        }
    }

    void onTraverse(Event event) {
        switch (event.detail) {
            case 8: 
            case 16: {
                event.doit = true;
            }
        }
    }
}

