/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.cocoa.CGPoint;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBundle;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSColorPanel;
import org.eclipse.swt.internal.cocoa.NSColorSpace;
import org.eclipse.swt.internal.cocoa.NSComboBox;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageView;
import org.eclipse.swt.internal.cocoa.NSLocale;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNotificationCenter;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPanel;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSResponder;
import org.eclipse.swt.internal.cocoa.NSRunLoop;
import org.eclipse.swt.internal.cocoa.NSRunningApplication;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSearchField;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSSlider;
import org.eclipse.swt.internal.cocoa.NSStepper;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSTimer;
import org.eclipse.swt.internal.cocoa.NSTouch;
import org.eclipse.swt.internal.cocoa.NSUserDefaults;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTApplicationDelegate;
import org.eclipse.swt.internal.cocoa.SWTWindowDelegate;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.TouchSource;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    static byte[] types = new byte[]{42, 0};
    static int size = C.PTR_SIZEOF;
    static int align = C.PTR_SIZEOF == 4 ? 2 : 3;
    Event[] eventQueue;
    EventTable eventTable;
    EventTable filterTable;
    boolean disposing;
    int sendEventCount;
    double rotation;
    double magnification;
    boolean gestureActive;
    int touchCounter;
    long primaryIdentifier;
    NSMutableArray currentTouches;
    TouchSource[] touchSources;
    Synchronizer synchronizer;
    Thread thread;
    boolean allowTimers = true;
    boolean runAsyncMessages = true;
    static final String RUN_AWT_INVOKE_LATER_KEY = "org.eclipse.swt.internal.runAWTInvokeLater";
    GCData[] contexts;
    Caret currentCaret;
    boolean sendEvent;
    int clickCountButton;
    int clickCount;
    int blinkTime;
    Control currentControl;
    Control trackingControl;
    Control tooltipControl;
    Control ignoreFocusControl;
    Widget tooltipTarget;
    NSMutableArray isPainting;
    NSMutableArray needsDisplay;
    NSMutableArray needsDisplayInRect;
    NSMutableArray runLoopModes;
    NSDictionary markedAttributes;
    boolean smallFonts;
    NSFont buttonFont;
    NSFont popUpButtonFont;
    NSFont textFieldFont;
    NSFont secureTextFieldFont;
    NSFont searchFieldFont;
    NSFont comboBoxFont;
    NSFont sliderFont;
    NSFont scrollerFont;
    NSFont textViewFont;
    NSFont tableViewFont;
    NSFont outlineViewFont;
    NSFont datePickerFont;
    NSFont boxFont;
    NSFont tabViewFont;
    NSFont progressIndicatorFont;
    Shell[] modalShells;
    Dialog modalDialog;
    NSPanel modalPanel;
    Menu menuBar;
    Menu[] menus;
    Menu[] popups;
    boolean escAsAcceleratorPresent = false;
    NSApplication application;
    long applicationClass;
    NSImage dockImage;
    boolean isEmbedded;
    static boolean launched = false;
    int systemUIMode;
    int systemUIOptions;
    Control focusControl;
    Control currentFocusControl;
    int focusEvent;
    NSWindow screenWindow;
    NSWindow keyWindow;
    NSAutoreleasePool[] pools;
    int poolCount;
    int loopCount;
    int[] screenID = new int[32];
    NSPoint[] screenCascade = new NSPoint[32];
    long runLoopObserver;
    Callback observerCallback;
    boolean lockCursor = true;
    static final String LOCK_CURSOR = "org.eclipse.swt.internal.lockCursor";
    long oldCursorSetProc;
    Callback cursorSetCallback;
    Combo currentCombo;
    boolean mozillaRunning;
    static final String MOZILLA_RUNNING = "org.eclipse.swt.internal.mozillaRunning";
    static Callback windowCallback2;
    static Callback windowCallback3;
    static Callback windowCallback4;
    static Callback windowCallback5;
    static Callback windowCallback6;
    static Callback dialogCallback3;
    static Callback dialogCallback4;
    static Callback dialogCallback5;
    static Callback applicationCallback2;
    static Callback applicationCallback3;
    static Callback applicationCallback4;
    static Callback applicationCallback6;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    TrayItem currentTrayItem;
    Menu trayItemMenu;
    Menu appMenuBar;
    Menu appMenu;
    TaskBar taskBar;
    Image errorImage;
    Image infoImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    double[][] colors;
    double[] alternateSelectedControlTextColor;
    double[] selectedControlTextColor;
    double[] alternateSelectedControlColor;
    double[] secondarySelectedControlColor;
    static int[][] KeyTable;
    static String APP_NAME;
    static String APP_VERSION;
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final byte[] SWT_OBJECT;
    static final byte[] SWT_EMBED_FRAMES;
    static final byte[] SWT_IMAGE;
    static final byte[] SWT_ROW;
    static final byte[] SWT_COLUMN;
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.modalDialog";
    static Display Default;
    static Display[] Displays;
    static final int GROW_SIZE = 1024;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    Runnable[] timerList;
    NSTimer[] nsTimers;
    SWTWindowDelegate timerDelegate;
    static SWTApplicationDelegate applicationDelegate;
    static NSObject currAppDelegate;
    boolean runSettings;
    SWTWindowDelegate settingsDelegate;
    static final int DEFAULT_BUTTON_INTERVAL = 30;
    Object data;
    String[] keys;
    Object[] values;
    static Map dynamicObjectMap;
    NSPoint hoverLastLocation;
    Runnable hoverTimer = new Runnable(){

        public void run() {
            if (Display.this.currentControl != null && !Display.this.currentControl.isDisposed()) {
                Display.this.currentControl.sendMouseEvent(null, 32, Display.this.trackingControl != null && !Display.this.trackingControl.isDisposed());
            }
        }
    };
    Runnable caretTimer = new Runnable(){

        public void run() {
            if (Display.this.currentCaret != null) {
                if (Display.this.currentCaret == null || Display.this.currentCaret.isDisposed()) {
                    return;
                }
                if (Display.this.currentCaret.blinkCaret()) {
                    int n2 = Display.this.currentCaret.blinkRate;
                    if (n2 != 0) {
                        Display.this.timerExec(n2, this);
                    }
                } else {
                    Display.this.currentCaret = null;
                }
            }
        }
    };
    Runnable defaultButtonTimer = new Runnable(){

        public void run() {
            Button button;
            if (Display.this.isDisposed()) {
                return;
            }
            Shell shell = Display.this.getActiveShell();
            if (shell != null && !shell.isDisposed() && (button = shell.defaultButton) != null && !button.isDisposed()) {
                NSView nSView = button.view;
                nSView.display();
            }
            if (Display.this.isDisposed()) {
                return;
            }
            if (Display.this.hasDefaultButton()) {
                Display.this.timerExec(30, this);
            }
        }
    };

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    static byte[] ascii(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 + 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)cArray[i2];
        }
        return byArray;
    }

    static int translateKey(int n2) {
        for (int i2 = 0; i2 < KeyTable.length; ++i2) {
            if (KeyTable[i2][0] != n2) continue;
            return KeyTable[i2][1];
        }
        return 0;
    }

    static int untranslateKey(int n2) {
        for (int i2 = 0; i2 < KeyTable.length; ++i2) {
            if (KeyTable[i2][1] != n2) continue;
            return KeyTable[i2][0];
        }
        return 0;
    }

    void addContext(GCData gCData) {
        if (this.contexts == null) {
            this.contexts = new GCData[12];
        }
        for (int i2 = 0; i2 < this.contexts.length; ++i2) {
            if (this.contexts[i2] != null && this.contexts[i2] != gCData) continue;
            this.contexts[i2] = gCData;
            return;
        }
        GCData[] gCDataArray = new GCData[this.contexts.length + 12];
        gCDataArray[this.contexts.length] = gCData;
        System.arraycopy(this.contexts, 0, gCDataArray, 0, this.contexts.length);
        this.contexts = gCDataArray;
    }

    public void addFilter(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n2, listener);
    }

    void addLayoutDeferred(Composite composite) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] compositeArray = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, compositeArray, 0, this.layoutDeferred.length);
            this.layoutDeferred = compositeArray;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = composite;
    }

    public void addListener(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n2, listener);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[12];
        }
        for (int i2 = 0; i2 < this.menus.length; ++i2) {
            if (this.menus[i2] != null) continue;
            this.menus[i2] = menu;
            return;
        }
        Menu[] menuArray = new Menu[this.menus.length + 12];
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    void addPool() {
        this.addPool((NSAutoreleasePool)new NSAutoreleasePool().alloc().init());
    }

    void addPool(NSAutoreleasePool nSAutoreleasePool) {
        Object object;
        if (this.pools == null) {
            this.pools = new NSAutoreleasePool[4];
        }
        if (this.poolCount == this.pools.length) {
            object = new NSAutoreleasePool[this.poolCount + 4];
            System.arraycopy(this.pools, 0, object, 0, this.poolCount);
            this.pools = object;
        }
        if (this.poolCount == 0) {
            object = NSThread.currentThread().threadDictionary();
            ((NSMutableDictionary)object).setObject(NSNumber.numberWithInteger(nSAutoreleasePool.id), NSString.stringWith("SWT_NSAutoreleasePool"));
        }
        this.pools[this.poolCount++] = nSAutoreleasePool;
    }

    void addPopup(Menu menu) {
        int n2;
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n3 = this.popups.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.popups[n2] != menu) continue;
            return;
        }
        for (n2 = 0; n2 < n3 && this.popups[n2] != null; ++n2) {
        }
        if (n2 == n3) {
            Menu[] menuArray = new Menu[n3 + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n3);
            this.popups = menuArray;
        }
        this.popups[n2] = menu;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] widgetArray = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, widgetArray, 0, this.skinList.length);
            this.skinList = widgetArray;
        }
        this.skinList[this.skinCount++] = widget;
    }

    void addWidget(NSObject nSObject, Widget widget) {
        if (nSObject == null) {
            return;
        }
        long l2 = OS.object_setInstanceVariable(nSObject.id, SWT_OBJECT, widget.jniRef);
        if (l2 == 0L) {
            if (dynamicObjectMap == null) {
                dynamicObjectMap = new HashMap();
            }
            LONG lONG = new LONG(widget.jniRef);
            dynamicObjectMap.put(nSObject, lONG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        this.checkDevice();
        OS.NSBeep();
    }

    void cascadeWindow(NSWindow nSWindow, NSScreen nSScreen) {
        NSDictionary nSDictionary = nSScreen.deviceDescription();
        int n2 = new NSNumber(nSDictionary.objectForKey((id)NSString.stringWith((String)"NSScreenNumber")).id).intValue();
        int n3 = 0;
        while (this.screenID[n3] != 0 && this.screenID[n3] != n2) {
            ++n3;
        }
        this.screenID[n3] = n2;
        NSPoint nSPoint = this.screenCascade[n3];
        if (nSPoint == null) {
            NSRect nSRect = nSScreen.frame();
            nSPoint = new NSPoint();
            nSPoint.x = nSRect.x;
            nSPoint.y = nSRect.y + nSRect.height;
        }
        this.screenCascade[n3] = nSWindow.cascadeTopLeftFromPoint(nSPoint);
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    void checkEnterExit(Control control, NSEvent nSEvent, boolean bl2) {
        if (control != this.currentControl) {
            if (this.currentControl != null && !this.currentControl.isDisposed()) {
                this.currentControl.sendMouseEvent(nSEvent, 7, bl2);
            }
            if (control != null && control.isDisposed()) {
                control = null;
            }
            this.currentControl = control;
            if (control != null) {
                control.sendMouseEvent(nSEvent, 6, bl2);
            }
            this.setCursor(control);
        }
        NSPoint nSPoint = NSEvent.mouseLocation();
        if (control == null || control != this.currentControl || this.hoverLastLocation == null || nSPoint.x != this.hoverLastLocation.x || nSPoint.y != this.hoverLastLocation.y) {
            this.hoverLastLocation = nSPoint;
            this.timerExec(control != null && !control.isDisposed() ? this.getToolTipTime() : -1, this.hoverTimer);
        }
    }

    void checkFocus() {
        Control control = this.currentFocusControl;
        Control control2 = this.getFocusControl();
        if (control == this.ignoreFocusControl && control2 == null) {
            return;
        }
        if (control != control2) {
            if (control != null && !control.isDisposed()) {
                control.sendFocusEvent(16);
            }
            this.currentFocusControl = control2;
            if (control2 != null && !control2.isDisposed()) {
                control2.sendFocusEvent(15);
            }
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean bl2) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i2 = 0; i2 < Displays.length; ++i2) {
                if (Displays[i2] == null) continue;
                if (!bl2) {
                    SWT.error(20, null, " [multiple displays]");
                }
                if (Display.Displays[i2].thread != thread) continue;
                SWT.error(22);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static NSRect convertRect(NSScreen nSScreen, NSRect nSRect) {
        double d2 = nSScreen.userSpaceScaleFactor();
        nSRect.x /= d2;
        nSRect.y /= d2;
        nSRect.width /= d2;
        nSRect.height /= d2;
        return nSRect;
    }

    static String convertToLf(String string) {
        char c2 = '\r';
        char c3 = '\n';
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = string.indexOf(c3, 0);
        if (n3 == -1 || n3 == 0) {
            return string;
        }
        if (string.charAt(n3 - 1) != c2) {
            return string;
        }
        n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < n2) {
            int n4 = string.indexOf(c2, n3);
            if (n4 == -1) {
                n4 = n2;
            }
            String string2 = string.substring(n3, n4);
            stringBuffer.append(string2);
            n3 = n4 + 2;
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    void clearModal(Shell shell) {
        int n2;
        if (this.modalShells == null) {
            return;
        }
        int n3 = this.modalShells.length;
        for (n2 = 0; n2 < n3 && this.modalShells[n2] != shell; ++n2) {
            if (this.modalShells[n2] != null) continue;
            return;
        }
        if (n2 == n3) {
            return;
        }
        System.arraycopy(this.modalShells, n2 + 1, this.modalShells, n2, --n3 - n2);
        this.modalShells[n3] = null;
        if (n2 == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            shellArray[i2].updateModal();
        }
    }

    void clearPool() {
        if (this.sendEventCount == 0 && this.loopCount == this.poolCount - 1 && Callback.getEntryCount() == 0) {
            this.removePool();
            this.addPool();
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(deviceData);
        Display.register(this);
        this.synchronizer = new Synchronizer(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
        String string;
        Class<?> clazz;
        long l2;
        if (OS.VERSION < 4176) {
            System.out.println("***WARNING: SWT requires MacOS X version 10.5 or greater");
            System.out.println("***WARNING: Detected: " + Integer.toHexString((OS.VERSION & 0xFF00) >> 8) + "." + Integer.toHexString((OS.VERSION & 0xF0) >> 4) + "." + Integer.toHexString(OS.VERSION & 0xF));
            this.error(20);
        }
        NSThread nSThread = NSThread.currentThread();
        if (!NSThread.isMainThread()) {
            System.out.println("***WARNING: Display must be created on main thread due to Cocoa restrictions.");
            this.error(22);
        }
        NSMutableDictionary nSMutableDictionary = nSThread.threadDictionary();
        NSString nSString = NSString.stringWith("SWT_NSAutoreleasePool");
        NSNumber nSNumber = new NSNumber(nSMutableDictionary.objectForKey(nSString));
        this.addPool(new NSAutoreleasePool(nSNumber.integerValue()));
        this.application = NSApplication.sharedApplication();
        this.isEmbedded = this.application.isRunning();
        int[] nArray = new int[2];
        if (OS.GetCurrentProcess(nArray) == 0) {
            int n2 = OS.getpid();
            l2 = Display.getApplicationName().UTF8String();
            if (l2 != 0L) {
                OS.CPSSetProcessName(nArray, l2);
            }
            if (!this.isBundled()) {
                if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 9, 0)) {
                    this.application.setActivationPolicy(0L);
                    NSRunningApplication.currentApplication().activateWithOptions(2L);
                } else {
                    OS.TransformProcessType(nArray, 1);
                    OS.SetFrontProcess(nArray);
                }
            }
            if ((l2 = OS.getenv(Display.ascii("APP_ICON_" + n2))) != 0L) {
                clazz = NSString.stringWithUTF8String(l2);
                NSImage nSImage = (NSImage)new NSImage().alloc();
                this.dockImage = nSImage = nSImage.initByReferencingFile((NSString)((Object)clazz));
                this.application.setApplicationIconImage(nSImage);
            }
        }
        if ((l2 = OS.objc_lookUpClass(string = "SWTApplication")) == 0L) {
            long l3;
            long l4;
            long l5;
            clazz = this.getClass();
            applicationCallback2 = new Callback(clazz, "applicationProc", 2);
            long l6 = applicationCallback2.getAddress();
            if (l6 == 0L) {
                this.error(3);
            }
            if ((l5 = (applicationCallback3 = new Callback(clazz, "applicationProc", 3)).getAddress()) == 0L) {
                this.error(3);
            }
            if ((l4 = (applicationCallback4 = new Callback(clazz, "applicationProc", 4)).getAddress()) == 0L) {
                this.error(3);
            }
            if ((l3 = (applicationCallback6 = new Callback(clazz, "applicationProc", 6)).getAddress()) == 0L) {
                this.error(3);
            }
            l2 = OS.objc_allocateClassPair(OS.object_getClass(this.application.id), string, 0L);
            OS.class_addMethod(l2, OS.sel_sendEvent_, l5, "@:@");
            OS.class_addMethod(l2, OS.sel_nextEventMatchingMask_untilDate_inMode_dequeue_, l3, "@:i@@B");
            OS.class_addMethod(l2, OS.sel_isRunning, l6, "@:");
            OS.class_addMethod(l2, OS.sel_finishLaunching, l6, "@:");
            OS.objc_registerClassPair(l2);
        }
        this.applicationClass = OS.object_setClass(this.application.id, l2);
        string = "SWTApplicationDelegate";
        if (OS.objc_lookUpClass(string) == 0L) {
            long l7 = applicationCallback3.getAddress();
            if (l7 == 0L) {
                this.error(3);
            }
            l2 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0L);
            long l8 = applicationCallback4.getAddress();
            if (l8 == 0L) {
                this.error(3);
            }
            l2 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0L);
            OS.class_addMethod(l2, OS.sel_applicationWillFinishLaunching_, l7, "@:@");
            OS.class_addMethod(l2, OS.sel_terminate_, l7, "@:@");
            OS.class_addMethod(l2, OS.sel_orderFrontStandardAboutPanel_, l7, "@:@");
            OS.class_addMethod(l2, OS.sel_hideOtherApplications_, l7, "@:@");
            OS.class_addMethod(l2, OS.sel_hide_, l7, "@:@");
            OS.class_addMethod(l2, OS.sel_unhideAllApplications_, l7, "@:@");
            OS.class_addMethod(l2, OS.sel_applicationDidBecomeActive_, l7, "@:@");
            OS.class_addMethod(l2, OS.sel_applicationDidResignActive_, l7, "@:@");
            OS.class_addMethod(l2, OS.sel_applicationDockMenu_, l7, "@:@");
            OS.class_addMethod(l2, OS.sel_application_openFile_, l8, "@:@@");
            OS.class_addMethod(l2, OS.sel_application_openFiles_, l8, "@:@@");
            OS.class_addMethod(l2, OS.sel_applicationShouldHandleReopen_hasVisibleWindows_, l8, "@:@B");
            OS.class_addMethod(l2, OS.sel_applicationShouldTerminate_, l7, "@:@");
            OS.objc_registerClassPair(l2);
        }
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.GetSystemUIMode(nArray2, nArray3);
        this.systemUIMode = nArray2[0];
        this.systemUIOptions = nArray3[0];
    }

    void createMainMenu() {
        NSMenuItem nSMenuItem;
        NSString nSString = Display.getApplicationName();
        NSString nSString2 = NSString.string();
        NSMenu nSMenu = (NSMenu)new NSMenu().alloc();
        nSMenu.initWithTitle(nSString2);
        NSString nSString3 = NSString.stringWith("%@ %@");
        NSMenuItem nSMenuItem2 = nSMenuItem = nSMenu.addItemWithTitle(nSString2, 0L, nSString2);
        NSMenu nSMenu2 = (NSMenu)new NSMenu().alloc();
        nSMenu2.initWithTitle(nSString2);
        OS.objc_msgSend(this.application.id, OS.sel_registerName("setAppleMenu:"), nSMenu2.id);
        NSString nSString4 = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, nSString3.id, NSString.stringWith((String)SWT.getMessage((String)"About")).id, nSString.id));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, OS.sel_orderFrontStandardAboutPanel_, nSString2);
        nSMenuItem.setTarget(applicationDelegate);
        nSMenu2.addItem(NSMenuItem.separatorItem());
        nSString4 = NSString.stringWith(SWT.getMessage("Preferences..."));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, 0L, NSString.stringWith(","));
        nSMenuItem.setTag(42L);
        nSMenu2.addItem(NSMenuItem.separatorItem());
        nSString4 = NSString.stringWith(SWT.getMessage("Services"));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, 0L, nSString2);
        NSMenu nSMenu3 = (NSMenu)new NSMenu().alloc();
        nSMenu3.initWithTitle(nSString2);
        nSMenu2.setSubmenu(nSMenu3, nSMenuItem);
        nSMenu3.release();
        this.application.setServicesMenu(nSMenu3);
        nSMenu2.addItem(NSMenuItem.separatorItem());
        nSString4 = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, nSString3.id, NSString.stringWith((String)SWT.getMessage((String)"Hide")).id, nSString.id));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, OS.sel_hide_, NSString.stringWith("h"));
        nSMenuItem.setTarget(applicationDelegate);
        nSString4 = NSString.stringWith(SWT.getMessage("Hide Others"));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, OS.sel_hideOtherApplications_, NSString.stringWith("h"));
        nSMenuItem.setKeyEquivalentModifierMask(0x180000L);
        nSMenuItem.setTarget(applicationDelegate);
        nSString4 = NSString.stringWith(SWT.getMessage("Show All"));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, OS.sel_unhideAllApplications_, nSString2);
        nSMenuItem.setTarget(applicationDelegate);
        nSMenu2.addItem(NSMenuItem.separatorItem());
        nSString4 = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, nSString3.id, NSString.stringWith((String)SWT.getMessage((String)"Quit")).id, nSString.id));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, OS.sel_applicationShouldTerminate_, NSString.stringWith("q"));
        nSMenuItem.setTarget(applicationDelegate);
        nSMenu.setSubmenu(nSMenu2, nSMenuItem2);
        nSMenu2.release();
        this.application.setMainMenu(nSMenu);
        nSMenu.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NSMutableArray currentTouches() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.currentTouches == null) {
                this.currentTouches = (NSMutableArray)new NSMutableArray().alloc();
                this.currentTouches = this.currentTouches.initWithCapacity(5L);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentTouches;
        }
    }

    long cursorSetProc(long l2, long l3) {
        Cursor cursor;
        if (this.lockCursor && this.currentControl != null && (cursor = this.currentControl.findCursor()) != null && cursor.handle.id != l2) {
            return 0L;
        }
        OS.call(this.oldCursorSetProc, l2, l3);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i2 = 0; i2 < Displays.length; ++i2) {
                if (display != Displays[i2]) continue;
                Display.Displays[i2] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        this.application = null;
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        for (int i2 = 0; i2 < this.disposeList.length; ++i2) {
            if (this.disposeList[i2] != null) continue;
            this.disposeList[i2] = runnable;
            return;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void error(int n2) {
        SWT.error(n2);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            int n2 = event.type;
            this.sendPreEvent(n2);
            try {
                this.filterTable.sendEvent(event);
            }
            finally {
                this.sendPostEvent(n2);
            }
        }
        return false;
    }

    boolean filters(int n2) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n2);
    }

    public Widget findWidget(long l2) {
        this.checkDevice();
        return this.getWidget(l2);
    }

    public Widget findWidget(long l2, long l3) {
        this.checkDevice();
        return this.getWidget(l2);
    }

    public Widget findWidget(Widget widget, long l2) {
        this.checkDevice();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i2 = 0; i2 < Displays.length; ++i2) {
                Display display = Displays[i2];
                if (display == null || display.thread != thread) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return display;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    TouchSource findTouchSource(NSTouch nSTouch) {
        Object object;
        int n2;
        if (this.touchSources == null) {
            this.touchSources = new TouchSource[4];
        }
        int n3 = this.touchSources.length;
        id id2 = nSTouch.device();
        TouchSource touchSource = null;
        for (n2 = 0; n2 < n3 && this.touchSources[n2] != null; ++n2) {
            if (this.touchSources[n2].handle != id2.id) continue;
            touchSource = this.touchSources[n2];
            break;
        }
        if (touchSource != null) {
            return touchSource;
        }
        if (n2 == n3) {
            object = new TouchSource[n3 + 4];
            System.arraycopy(this.touchSources, 0, object, 0, n3);
            this.touchSources = object;
        }
        object = new Rectangle(0, 0, (int)Math.ceil(nSTouch.deviceSize().width), (int)Math.ceil(nSTouch.deviceSize().height));
        this.touchSources[n2] = touchSource = new TouchSource(id2.id, false, (Rectangle)object);
        return touchSource;
    }

    public Shell getActiveShell() {
        NSWindow nSWindow;
        this.checkDevice();
        NSWindow nSWindow2 = nSWindow = this.keyWindow != null ? this.keyWindow : this.application.keyWindow();
        if (nSWindow != null) {
            Widget widget = this.getWidget(nSWindow.contentView());
            if (widget instanceof Shell) {
                return (Shell)widget;
            }
            NSPoint nSPoint = nSWindow.mouseLocationOutsideOfEventStream();
            for (NSView nSView = nSWindow.contentView().hitTest(nSPoint); nSView != null && !((widget = this.getWidget(nSView.id)) instanceof Shell); nSView = nSView.superview()) {
            }
            return (Shell)widget;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        NSArray nSArray = NSScreen.screens();
        return this.getBounds(nSArray);
    }

    Rectangle getBounds(NSArray nSArray) {
        NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(0L));
        NSRect nSRect = Display.convertRect(nSScreen, nSScreen.frame());
        double d2 = 3.4028234663852886E38;
        double d3 = 1.4E-45f;
        double d4 = 3.4028234663852886E38;
        double d5 = 1.4E-45f;
        long l2 = nSArray.count();
        int n2 = 0;
        while ((long)n2 < l2) {
            nSScreen = new NSScreen(nSArray.objectAtIndex(n2));
            NSRect nSRect2 = Display.convertRect(nSScreen, nSScreen.frame());
            double d6 = nSRect2.x;
            double d7 = nSRect2.x + nSRect2.width;
            double d8 = nSRect.height - nSRect2.y;
            double d9 = nSRect.height - (nSRect2.y + nSRect2.height);
            if (d6 < d2) {
                d2 = d6;
            }
            if (d7 < d2) {
                d2 = d7;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if (d7 > d3) {
                d3 = d7;
            }
            if (d8 < d4) {
                d4 = d8;
            }
            if (d9 < d4) {
                d4 = d9;
            }
            if (d8 > d5) {
                d5 = d8;
            }
            if (d9 > d5) {
                d5 = d9;
            }
            ++n2;
        }
        return new Rectangle((int)d2, (int)d4, (int)(d3 - d2), (int)(d5 - d4));
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        return this.blinkTime;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        NSArray nSArray = NSScreen.screens();
        if (nSArray.count() != 1L) {
            return this.getBounds(nSArray);
        }
        NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(0L));
        NSRect nSRect = Display.convertRect(nSScreen, nSScreen.frame());
        NSRect nSRect2 = Display.convertRect(nSScreen, nSScreen.visibleFrame());
        double d2 = nSRect.height - (nSRect2.y + nSRect2.height);
        return new Rectangle((int)nSRect2.x, (int)d2, (int)nSRect2.width, (int)nSRect2.height);
    }

    public Control getCursorControl() {
        this.checkDevice();
        return this.findControl(false);
    }

    public Point getCursorLocation() {
        this.checkDevice();
        NSPoint nSPoint = NSEvent.mouseLocation();
        NSRect nSRect = this.getPrimaryFrame();
        return new Point((int)nSPoint.x, (int)(nSRect.height - nSPoint.y));
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            if (!this.keys[i2].equals(string)) continue;
            return this.values[i2];
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDblTime() * 1000 / 60;
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        NSWindow nSWindow = this.keyWindow != null ? this.keyWindow : this.application.keyWindow();
        return this._getFocusControl(nSWindow);
    }

    Control _getFocusControl(NSWindow nSWindow) {
        if (nSWindow != null) {
            NSResponder nSResponder = nSWindow.firstResponder();
            if (nSResponder != null && !nSResponder.respondsToSelector(OS.sel_superview)) {
                return null;
            }
            NSView nSView = new NSView(nSResponder.id);
            if (nSView != null) {
                do {
                    Widget widget;
                    if (!((widget = Display.GetWidget(nSView.id)) instanceof Control)) continue;
                    return (Control)widget;
                } while ((nSView = nSView.superview()) != null);
            }
        }
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32), new Point(64, 64), new Point(128, 128)};
    }

    int getLastEventTime() {
        double d2;
        NSEvent nSEvent = this.application.currentEvent();
        if (nSEvent == null) {
            return 0;
        }
        for (d2 = nSEvent.timestamp() * 1000.0; d2 > 2.147483647E9; d2 -= 2.147483647E9) {
        }
        return (int)d2;
    }

    Menu[] getMenus(Decorations decorations) {
        Menu[] menuArray;
        int n2;
        if (this.menus == null) {
            return new Menu[0];
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.menus.length; ++n2) {
            menuArray = this.menus[n2];
            if (menuArray == null || menuArray.parent != decorations) continue;
            ++n3;
        }
        n2 = 0;
        menuArray = new Menu[n3];
        for (int i2 = 0; i2 < this.menus.length; ++i2) {
            Menu menu = this.menus[i2];
            if (menu == null || menu.parent != decorations) continue;
            menuArray[n2++] = menu;
        }
        return menuArray;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    NSPanel getModalPanel() {
        return this.modalPanel;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        NSArray nSArray = NSScreen.screens();
        NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(0L));
        NSRect nSRect = Display.convertRect(nSScreen, nSScreen.frame());
        int n2 = (int)nSArray.count();
        Monitor[] monitorArray = new Monitor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Monitor monitor = new Monitor();
            nSScreen = new NSScreen(nSArray.objectAtIndex(i2));
            NSRect nSRect2 = Display.convertRect(nSScreen, nSScreen.frame());
            monitor.handle = nSScreen.id;
            monitor.x = (int)nSRect2.x;
            monitor.y = (int)(nSRect.height - (nSRect2.y + nSRect2.height));
            monitor.width = (int)nSRect2.width;
            monitor.height = (int)nSRect2.height;
            NSRect nSRect3 = Display.convertRect(nSScreen, nSScreen.visibleFrame());
            monitor.clientX = (int)nSRect3.x;
            monitor.clientY = (int)(nSRect.height - (nSRect3.y + nSRect3.height));
            monitor.clientWidth = (int)nSRect3.width;
            monitor.clientHeight = (int)nSRect3.height;
            monitorArray[i2] = monitor;
        }
        return monitorArray;
    }

    NSRect getPrimaryFrame() {
        NSArray nSArray = NSScreen.screens();
        return new NSScreen(nSArray.objectAtIndex(0L)).frame();
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor monitor = new Monitor();
        NSArray nSArray = NSScreen.screens();
        NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(0L));
        NSRect nSRect = Display.convertRect(nSScreen, nSScreen.frame());
        monitor.handle = nSScreen.id;
        monitor.x = (int)nSRect.x;
        monitor.y = (int)(nSRect.height - (nSRect.y + nSRect.height));
        monitor.width = (int)nSRect.width;
        monitor.height = (int)nSRect.height;
        NSRect nSRect2 = Display.convertRect(nSScreen, nSScreen.visibleFrame());
        monitor.clientX = (int)nSRect2.x;
        monitor.clientY = (int)(nSRect.height - (nSRect2.y + nSRect2.height));
        monitor.clientWidth = (int)nSRect2.width;
        monitor.clientHeight = (int)nSRect2.height;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        NSArray nSArray = this.application.windows();
        int n2 = 0;
        Shell[] shellArray = new Shell[(int)nSArray.count()];
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            NSWindow nSWindow = new NSWindow(nSArray.objectAtIndex(i2));
            Widget widget = this.getWidget(nSWindow.contentView());
            if (!(widget instanceof Shell)) continue;
            shellArray[n2++] = (Shell)widget;
        }
        if (n2 == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray2 = new Shell[n2];
        System.arraycopy(shellArray, 0, shellArray2, 0, n2);
        return shellArray2;
    }

    static boolean getSheetEnabled() {
        return !"false".equals(System.getProperty("org.eclipse.swt.sheet"));
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    public Color getSystemColor(int n2) {
        this.checkDevice();
        Color color = this.getWidgetColor(n2);
        if (color != null) {
            return color;
        }
        return super.getSystemColor(n2);
    }

    Color getWidgetColor(int n2) {
        if (0 <= n2 && n2 < this.colors.length && this.colors[n2] != null) {
            return Color.cocoa_new(this, this.colors[n2]);
        }
        return null;
    }

    double[] getWidgetColorRGB(int n2) {
        NSColor nSColor = null;
        switch (n2) {
            case 28: {
                nSColor = NSColor.blackColor();
                break;
            }
            case 29: {
                double[] dArray;
                if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 10, 0)) {
                    double[] dArray2 = new double[4];
                    dArray2[0] = 0.9254902005195618;
                    dArray2[1] = 0.9215686321258545;
                    dArray2[2] = 0.9254902005195618;
                    dArray = dArray2;
                    dArray2[3] = 1.0;
                } else {
                    double[] dArray3 = new double[4];
                    dArray3[0] = 0.984f;
                    dArray3[1] = 0.988f;
                    dArray3[2] = 0.773f;
                    dArray = dArray3;
                    dArray3[3] = 1.0;
                }
                return dArray;
            }
            case 30: {
                nSColor = NSColor.windowFrameTextColor();
                break;
            }
            case 31: {
                nSColor = NSColor.alternateSelectedControlColor();
                break;
            }
            case 32: {
                nSColor = NSColor.selectedControlColor();
                break;
            }
            case 33: {
                nSColor = NSColor.disabledControlTextColor();
                break;
            }
            case 34: {
                nSColor = NSColor.secondarySelectedControlColor();
                break;
            }
            case 35: {
                nSColor = NSColor.secondarySelectedControlColor();
                break;
            }
            case 17: {
                nSColor = NSColor.controlDarkShadowColor();
                break;
            }
            case 18: {
                nSColor = NSColor.controlShadowColor();
                break;
            }
            case 19: {
                nSColor = NSColor.controlHighlightColor();
                break;
            }
            case 20: {
                nSColor = NSColor.controlLightHighlightColor();
                break;
            }
            case 22: {
                nSColor = NSColor.controlHighlightColor();
                break;
            }
            case 21: {
                nSColor = NSColor.controlTextColor();
                break;
            }
            case 23: {
                nSColor = NSColor.blackColor();
                break;
            }
            case 24: {
                nSColor = NSColor.textColor();
                break;
            }
            case 25: {
                nSColor = NSColor.textBackgroundColor();
                break;
            }
            case 27: {
                nSColor = NSColor.selectedTextColor();
                break;
            }
            case 26: {
                nSColor = NSColor.selectedTextBackgroundColor();
                break;
            }
            case 36: {
                NSTextView nSTextView = (NSTextView)new NSTextView().alloc();
                nSTextView.init();
                NSDictionary nSDictionary = nSTextView.linkTextAttributes();
                nSColor = new NSColor(nSDictionary.valueForKey(OS.NSForegroundColorAttributeName));
                nSTextView.release();
            }
        }
        return this.getNSColorRGB(nSColor);
    }

    double[] getNSColorRGB(NSColor nSColor) {
        if (nSColor == null) {
            return null;
        }
        NSColorSpace nSColorSpace = nSColor.colorSpace();
        if (nSColorSpace == null || nSColorSpace.colorSpaceModel() != 1L) {
            nSColor = nSColor.colorUsingColorSpaceName(OS.NSDeviceRGBColorSpace);
        }
        if (nSColor == null) {
            return null;
        }
        double[] dArray = new double[(int)nSColor.numberOfComponents()];
        nSColor.getComponents(dArray);
        return new double[]{dArray[0], dArray[1], dArray[2], dArray[3]};
    }

    public Cursor getSystemCursor(int n2) {
        this.checkDevice();
        if (0 > n2 || n2 >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n2] == null) {
            this.cursors[n2] = new Cursor(this, n2);
        }
        return this.cursors[n2];
    }

    NSImage getSystemImageForID(int n2) {
        long[] lArray = new long[1];
        OS.GetIconRefFromTypeInfo(1835098995, n2, 0L, 0L, 0, lArray);
        NSImage nSImage = (NSImage)new NSImage().alloc();
        nSImage = nSImage.initWithIconRef(lArray[0]);
        NSSize nSSize = new NSSize();
        nSSize.height = 32.0;
        nSSize.width = 32.0;
        nSImage.setSize(nSSize);
        nSImage.setScalesWhenResized(true);
        return nSImage;
    }

    public Image getSystemImage(int n2) {
        this.checkDevice();
        switch (n2) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                NSImage nSImage = this.getSystemImageForID(1937010544);
                this.errorImage = Image.cocoa_new(this, 1, nSImage);
                return this.errorImage;
            }
            case 2: 
            case 4: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                NSImage nSImage = this.getSystemImageForID(1852798053);
                this.infoImage = Image.cocoa_new(this, 1, nSImage);
                return this.infoImage;
            }
            case 8: {
                if (this.warningImage != null) {
                    return this.warningImage;
                }
                NSImage nSImage = this.getSystemImageForID(1667331444);
                this.warningImage = Image.cocoa_new(this, 1, nSImage);
                return this.warningImage;
            }
        }
        return null;
    }

    public Menu getMenuBar() {
        this.checkDevice();
        if (this.appMenuBar != null) {
            return this.appMenuBar;
        }
        this.appMenuBar = new Menu(this);
        return this.appMenuBar;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        if (this.appMenu == null) {
            NSMenu nSMenu = NSApplication.sharedApplication().mainMenu();
            NSMenu nSMenu2 = nSMenu.itemAtIndex(0L).submenu();
            this.appMenu = new Menu(this, nSMenu2);
            long l2 = nSMenu2.numberOfItems();
            int n2 = 0;
            while ((long)n2 < l2) {
                NSMenuItem nSMenuItem = nSMenu2.itemAtIndex(n2);
                new MenuItem(this.appMenu, nSMenuItem);
                ++n2;
            }
        }
        return this.appMenu;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        if (this.taskBar != null) {
            return this.taskBar;
        }
        this.taskBar = new TaskBar(this, 0);
        return this.taskBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        return OS.VERSION > 4179;
    }

    int getToolTipTime() {
        this.checkDevice();
        return 560;
    }

    Widget getWidget(long l2) {
        return Display.GetWidget(l2);
    }

    static Widget GetWidget(long l2) {
        NSObject nSObject;
        LONG lONG;
        if (l2 == 0L) {
            return null;
        }
        long[] lArray = new long[1];
        long l3 = OS.object_getInstanceVariable(l2, SWT_OBJECT, lArray);
        if (l3 == 0L && dynamicObjectMap != null && (lONG = (LONG)dynamicObjectMap.get(nSObject = new NSObject(l2))) != null) {
            lArray[0] = lONG.value;
        }
        if (lArray[0] == 0L) {
            return null;
        }
        return (Widget)OS.JNIGetObject(lArray[0]);
    }

    Widget getWidget(NSView nSView) {
        if (nSView == null) {
            return null;
        }
        return this.getWidget(nSView.id);
    }

    boolean hasDefaultButton() {
        NSArray nSArray = this.application.windows();
        long l2 = nSArray.count();
        int n2 = 0;
        while ((long)n2 < l2) {
            NSWindow nSWindow = new NSWindow(nSArray.objectAtIndex(n2));
            if (nSWindow.defaultButtonCell() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void init() {
        long l2;
        long l3;
        NSMenu nSMenu;
        NSMenuItem nSMenuItem;
        super.init();
        this.initClasses();
        this.initColors();
        this.initFonts();
        if (applicationDelegate == null) {
            applicationDelegate = (SWTApplicationDelegate)new SWTApplicationDelegate().alloc().init();
            if (currAppDelegate == null) {
                long l4;
                if (OS.class_JRSAppKitAWT != 0L && (l4 = OS.objc_msgSend(OS.class_JRSAppKitAWT, OS.sel_awtAppDelegate)) != 0L) {
                    currAppDelegate = new NSObject(l4);
                    currAppDelegate.retain();
                }
                this.application.setDelegate(applicationDelegate);
            }
        }
        if (!launched) {
            this.application.finishLaunching();
            launched = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    NSApplication.sharedApplication().terminate(null);
                }
            });
        }
        if ((nSMenuItem = (nSMenu = this.application.mainMenu().itemAtIndex(0L).submenu()).itemWithTag(-2L)) != null) {
            nSMenuItem.setTag(42L);
        }
        if (currAppDelegate != null) {
            currAppDelegate.init();
        }
        if (nSMenuItem != null) {
            nSMenuItem.setTag(-2L);
        }
        this.observerCallback = new Callback(this, "observerProc", 3);
        long l5 = this.observerCallback.getAddress();
        if (l5 == 0L) {
            this.error(3);
        }
        int n2 = 32;
        this.runLoopObserver = OS.CFRunLoopObserverCreate(0L, n2, true, 0L, l5, 0L);
        if (this.runLoopObserver == 0L) {
            this.error(2);
        }
        OS.CFRunLoopAddObserver(OS.CFRunLoopGetCurrent(), this.runLoopObserver, OS.kCFRunLoopCommonModes());
        long l6 = OS.objc_lookUpClass("JNFRunLoop");
        if (l6 != 0L && (l3 = OS.objc_msgSend(l6, OS.sel_javaRunLoopMode)) != 0L) {
            OS.CFRunLoopAddObserver(OS.CFRunLoopGetCurrent(), this.runLoopObserver, l3);
        }
        this.cursorSetCallback = new Callback(this, "cursorSetProc", 2);
        l3 = this.cursorSetCallback.getAddress();
        if (l3 == 0L) {
            this.error(3);
        }
        if ((l2 = OS.class_getInstanceMethod(OS.class_NSCursor, OS.sel_set)) != 0L) {
            this.oldCursorSetProc = OS.method_setImplementation(l2, l3);
        }
        this.timerDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        this.settingsDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        NSNotificationCenter nSNotificationCenter = NSNotificationCenter.defaultCenter();
        nSNotificationCenter.addObserver(this.settingsDelegate, OS.sel_systemSettingsChanged_, OS.NSSystemColorsDidChangeNotification, null);
        nSNotificationCenter.addObserver(this.settingsDelegate, OS.sel_systemSettingsChanged_, OS.NSApplicationDidChangeScreenParametersNotification, null);
        NSTextView nSTextView = (NSTextView)new NSTextView().alloc();
        nSTextView.init();
        this.markedAttributes = nSTextView.markedTextAttributes();
        this.markedAttributes.retain();
        nSTextView.release();
        NSUserDefaults nSUserDefaults = NSUserDefaults.standardUserDefaults();
        nSUserDefaults.setInteger(0L, NSString.stringWith(OS.VERSION >= 4224 ? "NSScrollAnimationEnabled" : "AppleScrollAnimationEnabled"));
        id id2 = nSUserDefaults.objectForKey(NSString.stringWith("NSTextInsertionPointBlinkPeriod"));
        if (id2 != null) {
            this.blinkTime = (int)new NSNumber(id2).integerValue();
        }
        if (this.blinkTime == 0) {
            this.blinkTime = 560;
        }
        this.isPainting = (NSMutableArray)new NSMutableArray().alloc();
        this.isPainting = this.isPainting.initWithCapacity(12L);
    }

    void addEventMethods(long l2, long l3, long l4, long l5, long l6, long l7) {
        if (l4 != 0L) {
            OS.class_addMethod(l2, OS.sel_mouseDown_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_mouseUp_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_scrollWheel_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_rightMouseDown_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_rightMouseUp_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_rightMouseDragged_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_otherMouseDown_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_otherMouseUp_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_otherMouseDragged_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_mouseDragged_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_mouseMoved_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_mouseEntered_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_mouseExited_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_menuForEvent_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_keyDown_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_keyUp_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_flagsChanged_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_cursorUpdate_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_setNeedsDisplay_, l4, "@:B");
            OS.class_addMethod(l2, OS.sel_shouldDelayWindowOrderingForEvent_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_acceptsFirstMouse_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_changeColor_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_cancelOperation_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_touchesBeganWithEvent_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_touchesMovedWithEvent_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_touchesEndedWithEvent_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_touchesCancelledWithEvent_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_beginGestureWithEvent_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_endGestureWithEvent_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_swipeWithEvent_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_rotateWithEvent_, l4, "@:@");
            OS.class_addMethod(l2, OS.sel_magnifyWithEvent_, l4, "@:@");
        }
        if (l3 != 0L) {
            OS.class_addMethod(l2, OS.sel_resignFirstResponder, l3, "@:");
            OS.class_addMethod(l2, OS.sel_becomeFirstResponder, l3, "@:");
            OS.class_addMethod(l2, OS.sel_resetCursorRects, l3, "@:");
            OS.class_addMethod(l2, OS.sel_updateTrackingAreas, l3, "@:");
            OS.class_addMethod(l2, OS.sel_getImageView, l3, "@:");
            OS.class_addMethod(l2, OS.sel_mouseDownCanMoveWindow, l3, "@:");
        }
        if (l7 != 0L) {
            OS.class_addMethod(l2, OS.sel_setNeedsDisplayInRect_, l7, "@:{NSRect}");
        }
        if (l5 != 0L) {
            OS.class_addMethod(l2, OS.sel_drawRect_, l5, "@:{NSRect}");
        }
        if (l6 != 0L) {
            OS.class_addMethod(l2, OS.sel_hitTest_, l6, "@:{NSPoint}");
        }
    }

    void addFrameMethods(long l2, long l3, long l4) {
        OS.class_addMethod(l2, OS.sel_setFrameOrigin_, l3, "@:{NSPoint}");
        OS.class_addMethod(l2, OS.sel_setFrameSize_, l4, "@:{NSSize}");
    }

    void addAccessibilityMethods(long l2, long l3, long l4, long l5, long l6) {
        OS.class_addMethod(l2, OS.sel_accessibilityActionNames, l3, "@:");
        OS.class_addMethod(l2, OS.sel_accessibilityAttributeNames, l3, "@:");
        OS.class_addMethod(l2, OS.sel_accessibilityParameterizedAttributeNames, l3, "@:");
        OS.class_addMethod(l2, OS.sel_accessibilityFocusedUIElement, l3, "@:");
        OS.class_addMethod(l2, OS.sel_accessibilityIsIgnored, l3, "@:");
        OS.class_addMethod(l2, OS.sel_accessibilityAttributeValue_, l4, "@:@");
        OS.class_addMethod(l2, OS.sel_accessibilityHitTest_, l6, "@:{NSPoint}");
        OS.class_addMethod(l2, OS.sel_accessibilityAttributeValue_forParameter_, l5, "@:@@");
        OS.class_addMethod(l2, OS.sel_accessibilityPerformAction_, l4, "@:@");
        OS.class_addMethod(l2, OS.sel_accessibilityActionDescription_, l4, "@:@");
        OS.class_addMethod(l2, OS.sel_accessibilityIsAttributeSettable_, l4, "@:@");
        OS.class_addMethod(l2, OS.sel_accessibilitySetValue_forAttribute_, l5, "@:@@");
        OS.class_addMethod(l2, OS.sel_accessibleHandle, l3, "@:");
    }

    long registerCellSubclass(long l2, int n2, int n3, byte[] byArray) {
        String string = OS.class_getName(l2);
        long l3 = OS.objc_allocateClassPair(l2, "SWTAccessible" + string, 0L);
        OS.class_addIvar(l3, SWT_OBJECT, n2, (byte)n3, byArray);
        OS.objc_registerClassPair(l3);
        return l3;
    }

    long createWindowSubclass(long l2, String string, boolean bl2) {
        long l3 = OS.objc_lookUpClass(string);
        if (l3 != 0L) {
            return l3;
        }
        l3 = OS.objc_allocateClassPair(l2, string, 0L);
        long l4 = windowCallback3.getAddress();
        long l5 = windowCallback2.getAddress();
        long l6 = windowCallback4.getAddress();
        long l7 = windowCallback6.getAddress();
        long l8 = OS.CALLBACK_view_stringForToolTip_point_userData_(l7);
        long l9 = OS.CALLBACK_accessibilityHitTest_(l4);
        if (!bl2) {
            OS.class_addIvar(l3, SWT_OBJECT, size, (byte)align, types);
        }
        OS.class_addMethod(l3, OS.sel_sendEvent_, l4, "@:@");
        OS.class_addMethod(l3, OS.sel_helpRequested_, l4, "@:@");
        OS.class_addMethod(l3, OS.sel_canBecomeKeyWindow, l5, "@:");
        OS.class_addMethod(l3, OS.sel_becomeKeyWindow, l5, "@:");
        OS.class_addMethod(l3, OS.sel_makeFirstResponder_, l4, "@:@");
        OS.class_addMethod(l3, OS.sel_noResponderFor_, l4, "@:@");
        OS.class_addMethod(l3, OS.sel_view_stringForToolTip_point_userData_, l8, "@:@i{NSPoint}@");
        this.addAccessibilityMethods(l3, l5, l4, l6, l9);
        OS.objc_registerClassPair(l3);
        return l3;
    }

    long createMenuSubclass(long l2, String string, boolean bl2) {
        long l3 = OS.objc_lookUpClass(string);
        if (l3 != 0L) {
            return l3;
        }
        l3 = OS.objc_allocateClassPair(l2, string, 0L);
        long l4 = windowCallback3.getAddress();
        long l5 = windowCallback4.getAddress();
        OS.class_addIvar(l3, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l3, OS.sel_menuWillOpen_, l4, "@:@");
        OS.class_addMethod(l3, OS.sel_menuDidClose_, l4, "@:@");
        OS.class_addMethod(l3, OS.sel_menu_willHighlightItem_, l5, "@:@@");
        OS.class_addMethod(l3, OS.sel_menuNeedsUpdate_, l4, "@:@");
        OS.objc_registerClassPair(l3);
        return l3;
    }

    long createMenuItemSubclass(long l2, String string, boolean bl2) {
        long l3 = OS.objc_lookUpClass(string);
        if (l3 != 0L) {
            return l3;
        }
        l3 = OS.objc_allocateClassPair(l2, string, 0L);
        long l4 = windowCallback2.getAddress();
        if (!bl2) {
            OS.class_addIvar(l3, SWT_OBJECT, size, (byte)align, types);
        }
        OS.class_addMethod(l3, OS.sel_sendSelection, l4, "@:");
        OS.objc_registerClassPair(l3);
        return l3;
    }

    void initClasses() {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        if (OS.objc_lookUpClass("SWTView") != 0L) {
            return;
        }
        Class<?> clazz = this.getClass();
        dialogCallback3 = new Callback(clazz, "dialogProc", 3);
        long l10 = dialogCallback3.getAddress();
        if (l10 == 0L) {
            this.error(3);
        }
        if ((l9 = (dialogCallback4 = new Callback(clazz, "dialogProc", 4)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((l8 = (dialogCallback5 = new Callback(clazz, "dialogProc", 5)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((l7 = (windowCallback3 = new Callback(clazz, "windowProc", 3)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((l6 = (windowCallback2 = new Callback(clazz, "windowProc", 2)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((l5 = (windowCallback4 = new Callback(clazz, "windowProc", 4)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((l4 = (windowCallback5 = new Callback(clazz, "windowProc", 5)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((l3 = (windowCallback6 = new Callback(clazz, "windowProc", 6)).getAddress()) == 0L) {
            this.error(3);
        }
        long l11 = OS.isFlipped_CALLBACK();
        long l12 = OS.CALLBACK_drawRect_(l7);
        long l13 = OS.CALLBACK_drawInteriorWithFrame_inView_(l5);
        long l14 = OS.CALLBACK_drawWithExpansionFrame_inView_(l5);
        long l15 = OS.CALLBACK_imageRectForBounds_(l7);
        long l16 = OS.CALLBACK_titleRectForBounds_(l7);
        long l17 = OS.CALLBACK_cellSizeForBounds_(l7);
        long l18 = OS.CALLBACK_hitTestForEvent_inRect_ofView_(l4);
        long l19 = OS.CALLBACK_cellSize(l6);
        long l20 = OS.CALLBACK_drawImage_withFrame_inView_(l4);
        long l21 = OS.CALLBACK_drawTitle_withFrame_inView_(l4);
        long l22 = OS.CALLBACK_setFrameOrigin_(l7);
        long l23 = OS.CALLBACK_setFrameSize_(l7);
        long l24 = OS.CALLBACK_hitTest_(l7);
        long l25 = OS.CALLBACK_markedRange(l6);
        long l26 = OS.CALLBACK_selectedRange(l6);
        long l27 = OS.CALLBACK_highlightSelectionInClipRect_(l7);
        long l28 = OS.CALLBACK_setMarkedText_selectedRange_(l5);
        long l29 = OS.CALLBACK_attributedSubstringFromRange_(l7);
        long l30 = OS.CALLBACK_characterIndexForPoint_(l7);
        long l31 = OS.CALLBACK_firstRectForCharacterRange_(l7);
        long l32 = OS.CALLBACK_textView_willChangeSelectionFromCharacterRange_toCharacterRange_(l4);
        long l33 = OS.CALLBACK_accessibilityHitTest_(l7);
        long l34 = OS.CALLBACK_shouldChangeTextInRange_replacementString_(l5);
        long l35 = OS.CALLBACK_view_stringForToolTip_point_userData_(l3);
        long l36 = OS.CALLBACK_canDragRowsWithIndexes_atPoint_(l5);
        long l37 = OS.CALLBACK_setNeedsDisplayInRect_(l7);
        long l38 = OS.CALLBACK_expansionFrameWithFrame_inView_(l5);
        long l39 = OS.CALLBACK_focusRingMaskBoundsForFrame_inView_(l5);
        long l40 = OS.CALLBACK_sizeOfLabel_(l7);
        long l41 = OS.CALLBACK_drawLabel_inRect_(l5);
        long l42 = OS.CALLBACK_drawViewBackgroundInRect_(l7);
        long l43 = OS.CALLBACK_drawBackgroundInClipRect_(l7);
        long l44 = OS.CALLBACK_scrollClipView_toPoint_(l5);
        long l45 = OS.CALLBACK_headerRectOfColumn_(l7);
        long l46 = OS.CALLBACK_columnAtPoint_(l7);
        String string = "SWTBox";
        long l47 = OS.objc_allocateClassPair(OS.class_NSBox, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTButton";
        l47 = OS.objc_allocateClassPair(OS.class_NSButton, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_sendSelection, l6, "@:");
        OS.class_addMethod(l47, OS.sel_validateMenuItem_, l7, "@:@");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        OS.objc_registerClassPair(l47);
        OS.class_addMethod(OS.object_getClass(l47), OS.sel_cellClass, l6, "@:");
        l47 = this.registerCellSubclass(NSButton.cellClass(), size, align, types);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.class_addMethod(l47, OS.sel_nextState, l6, "@:");
        string = "SWTButtonCell";
        l47 = OS.objc_allocateClassPair(OS.class_NSButtonCell, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.class_addMethod(l47, OS.sel_drawImage_withFrame_inView_, l20, "@:@{NSRect}@");
        OS.class_addMethod(l47, OS.sel_drawTitle_withFrame_inView_, l21, "@:@{NSRect}@");
        OS.class_addMethod(l47, OS.sel_drawInteriorWithFrame_inView_, l13, "@:{NSRect}@");
        OS.class_addMethod(l47, OS.sel_titleRectForBounds_, l16, "@:{NSRect}");
        OS.class_addMethod(l47, OS.sel_cellSizeForBounds_, l17, "@:{NSRect}");
        if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 10, 0)) {
            OS.class_addMethod(l47, OS.sel_focusRingMaskBoundsForFrame_inView_, l39, "@:{NSRect}@");
        }
        OS.objc_registerClassPair(l47);
        string = "SWTCanvasView";
        l47 = OS.objc_allocateClassPair(OS.class_NSView, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addProtocol(l47, OS.protocol_NSTextInput);
        OS.class_addMethod(l47, OS.sel_hasMarkedText, l6, "@:");
        OS.class_addMethod(l47, OS.sel_markedRange, l25, "@:");
        OS.class_addMethod(l47, OS.sel_selectedRange, l26, "@:");
        OS.class_addMethod(l47, OS.sel_setMarkedText_selectedRange_, l28, "@:@{NSRange}");
        OS.class_addMethod(l47, OS.sel_unmarkText, l6, "@:");
        OS.class_addMethod(l47, OS.sel_validAttributesForMarkedText, l6, "@:");
        OS.class_addMethod(l47, OS.sel_attributedSubstringFromRange_, l29, "@:{NSRange}");
        OS.class_addMethod(l47, OS.sel_insertText_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_characterIndexForPoint_, l30, "@:{NSPoint}");
        OS.class_addMethod(l47, OS.sel_firstRectForCharacterRange_, l31, "@:{NSRange}");
        OS.class_addMethod(l47, OS.sel_doCommandBySelector_, l7, "@::");
        OS.class_addMethod(l47, OS.sel_canBecomeKeyView, l6, "@:");
        OS.class_addMethod(l47, OS.sel_isFlipped, l11, "@:");
        OS.class_addMethod(l47, OS.sel_acceptsFirstResponder, l6, "@:");
        OS.class_addMethod(l47, OS.sel_isOpaque, l6, "@:");
        OS.class_addMethod(l47, OS.sel_updateOpenGLContext_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_clearDeferFlushing, l6, "@:");
        OS.class_addMethod(l47, OS.sel_validRequestorForSendType_returnType_, l5, "@:@@");
        OS.class_addMethod(l47, OS.sel_readSelectionFromPasteboard_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_writeSelectionToPasteboard_types_, l5, "@:@@");
        OS.class_addMethod(l47, OS.sel_viewWillMoveToWindow_, l7, "@:@");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTComboBox";
        l47 = OS.objc_allocateClassPair(OS.class_NSComboBox, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_sendSelection, l6, "@:");
        OS.class_addMethod(l47, OS.sel_textDidChange_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_textViewDidChangeSelection_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_comboBoxSelectionDidChange_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_comboBoxWillDismiss_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_comboBoxWillPopUp_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, l32, "@:@{NSRange}{NSRange}");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        OS.class_addMethod(OS.object_getClass(l47), OS.sel_cellClass, l6, "@:");
        l47 = this.registerCellSubclass(NSComboBox.cellClass(), size, align, types);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.class_addMethod(l47, OS.sel_setObjectValue_, l7, "@:@");
        string = "SWTDatePicker";
        l47 = OS.objc_allocateClassPair(OS.class_NSDatePicker, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_isFlipped, l6, "@:");
        OS.class_addMethod(l47, OS.sel_sendSelection, l6, "@:");
        OS.class_addMethod(l47, OS.sel_sendVerticalSelection, l6, "@:");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTEditorView";
        l47 = OS.objc_allocateClassPair(OS.class_NSTextView, string, 0L);
        this.addEventMethods(l47, 0L, l7, l12, 0L, 0L);
        OS.class_addMethod(l47, OS.sel_insertText_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_doCommandBySelector_, l7, "@::");
        OS.class_addMethod(l47, OS.sel_shouldChangeTextInRange_replacementString_, l34, "@:{NSRange}@");
        OS.objc_registerClassPair(l47);
        string = "SWTImageView";
        l47 = OS.objc_allocateClassPair(OS.class_NSImageView, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_isFlipped, l11, "@:");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        OS.class_addMethod(OS.object_getClass(l47), OS.sel_cellClass, l6, "@:");
        l47 = this.registerCellSubclass(NSImageView.cellClass(), size, align, types);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        string = "SWTImageTextCell";
        l47 = OS.objc_allocateClassPair(OS.class_NSTextFieldCell, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addIvar(l47, SWT_IMAGE, size, (byte)align, types);
        OS.class_addIvar(l47, SWT_ROW, size, (byte)align, types);
        OS.class_addIvar(l47, SWT_COLUMN, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_drawInteriorWithFrame_inView_, l13, "@:{NSRect}@");
        OS.class_addMethod(l47, OS.sel_drawWithExpansionFrame_inView_, l14, "@:{NSRect}@");
        OS.class_addMethod(l47, OS.sel_imageRectForBounds_, l15, "@:{NSRect}");
        OS.class_addMethod(l47, OS.sel_titleRectForBounds_, l16, "@:{NSRect}");
        OS.class_addMethod(l47, OS.sel_hitTestForEvent_inRect_ofView_, l18, "@:@{NSRect}@");
        OS.class_addMethod(l47, OS.sel_cellSize, l19, "@:");
        OS.class_addMethod(l47, OS.sel_image, l6, "@:");
        OS.class_addMethod(l47, OS.sel_setImage_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_expansionFrameWithFrame_inView_, l38, "@:{NSRect}@");
        OS.objc_registerClassPair(l47);
        this.createMenuSubclass(OS.class_NSMenu, "SWTMenu", false);
        this.createMenuItemSubclass(OS.class_NSMenuItem, "SWTMenuItem", false);
        string = "SWTOutlineView";
        l47 = OS.objc_allocateClassPair(OS.class_NSOutlineView, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_highlightSelectionInClipRect_, l27, "@:{NSRect}");
        OS.class_addMethod(l47, OS.sel_sendDoubleSelection, l6, "@:");
        OS.class_addMethod(l47, OS.sel_outlineViewSelectionDidChange_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_outlineViewSelectionIsChanging_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_outlineView_child_ofItem_, l4, "@:@i@");
        OS.class_addMethod(l47, OS.sel_outlineView_isItemExpandable_, l5, "@:@@");
        OS.class_addMethod(l47, OS.sel_outlineView_numberOfChildrenOfItem_, l5, "@:@@");
        OS.class_addMethod(l47, OS.sel_selectRowIndexes_byExtendingSelection_, l5, "@:@Z");
        OS.class_addMethod(l47, OS.sel_deselectRow_, l7, "@:i");
        OS.class_addMethod(l47, OS.sel_deselectAll_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_outlineView_objectValueForTableColumn_byItem_, l4, "@:@@@");
        OS.class_addMethod(l47, OS.sel_outlineView_willDisplayCell_forTableColumn_item_, l3, "@:@@@@");
        OS.class_addMethod(l47, OS.sel_outlineView_shouldReorderColumn_toColumn_, l4, "@:@ii");
        OS.class_addMethod(l47, OS.sel_outlineView_setObjectValue_forTableColumn_byItem_, l3, "@:@@@@");
        OS.class_addMethod(l47, OS.sel_outlineView_shouldEditTableColumn_item_, l4, "@:@@@");
        OS.class_addMethod(l47, OS.sel_outlineView_shouldTrackCell_forTableColumn_item_, l3, "@:@@@@@@");
        OS.class_addMethod(l47, OS.sel_outlineView_shouldExpandItem_, l5, "@:@@");
        OS.class_addMethod(l47, OS.sel_setShouldExpandItem_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_setShouldScrollClipView_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_outlineViewColumnDidMove_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_outlineViewColumnDidResize_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_outlineView_didClickTableColumn_, l5, "@:@@");
        OS.class_addMethod(l47, OS.sel_canDragRowsWithIndexes_atPoint_, l36, "@:@{NSPoint=ff}");
        OS.class_addMethod(l47, OS.sel_outlineView_writeItems_toPasteboard_, l4, "@:@@@");
        OS.class_addMethod(l47, OS.sel_expandItem_expandChildren_, l5, "@:@Z");
        OS.class_addMethod(l47, OS.sel_collapseItem_collapseChildren_, l5, "@:@Z");
        OS.class_addMethod(l47, OS.sel_drawBackgroundInClipRect_, l43, "@:{NSRect}");
        OS.class_addMethod(l47, OS.sel_acceptsFirstResponder, l6, "@:");
        OS.class_addMethod(l47, OS.sel_needsPanelToBecomeKey, l6, "@:");
        OS.class_addMethod(l47, OS.sel_canBecomeKeyView, l6, "@:");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTPanelDelegate";
        l47 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_windowWillClose_, l10, "@:@");
        OS.class_addMethod(l47, OS.sel_changeColor_, l10, "@:@");
        OS.class_addMethod(l47, OS.sel_setColor_forAttribute_, l9, "@:@@");
        OS.class_addMethod(l47, OS.sel_changeFont_, l10, "@:@");
        OS.class_addMethod(l47, OS.sel_validModesForFontPanel_, l10, "@:@");
        OS.class_addMethod(l47, OS.sel_sendSelection_, l10, "@:@");
        OS.class_addMethod(l47, OS.sel_panel_shouldShowFilename_, l9, "@:@@");
        OS.class_addMethod(l47, OS.sel_panelDidEnd_returnCode_contextInfo_, l8, "@:@i@");
        OS.objc_registerClassPair(l47);
        string = "SWTPopUpButton";
        l47 = OS.objc_allocateClassPair(OS.class_NSPopUpButton, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_sendSelection, l6, "@:");
        OS.class_addMethod(l47, OS.sel_menuWillOpen_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_menuDidClose_, l7, "@:@");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        OS.class_addMethod(OS.object_getClass(l47), OS.sel_cellClass, l6, "@:");
        l47 = this.registerCellSubclass(NSPopUpButton.cellClass(), size, align, types);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 10, 0)) {
            OS.class_addMethod(l47, OS.sel_focusRingMaskBoundsForFrame_inView_, l39, "@:{NSRect}@");
        }
        string = "SWTProgressIndicator";
        l47 = OS.objc_allocateClassPair(OS.class_NSProgressIndicator, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_viewDidMoveToWindow, l6, "@:");
        OS.class_addMethod(l47, OS.sel__drawThemeProgressArea_, l7, "@:c");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTScroller";
        l47 = OS.objc_allocateClassPair(OS.class_NSScroller, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_sendSelection, l6, "@:");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        if (OS.VERSION >= 4208) {
            l2 = OS.objc_getMetaClass(string);
            OS.class_addMethod(l2, OS.sel_isCompatibleWithOverlayScrollers, l11, "@:");
        }
        string = "SWTScrollView";
        l47 = OS.objc_allocateClassPair(OS.class_NSScrollView, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_sendVerticalSelection, l6, "@:");
        OS.class_addMethod(l47, OS.sel_sendHorizontalSelection, l6, "@:");
        OS.class_addMethod(l47, OS.sel_pageDown_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_pageUp_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_reflectScrolledClipView_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_scrollClipView_toPoint_, l44, "@:@{NSPoint}");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTSearchField";
        l47 = OS.objc_allocateClassPair(OS.class_NSSearchField, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.class_addMethod(l47, OS.sel_textDidChange_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_textViewDidChangeSelection_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, l32, "@:@{NSRange}{NSRange}");
        OS.class_addMethod(l47, OS.sel_sendSearchSelection, l6, "@:");
        OS.class_addMethod(l47, OS.sel_sendCancelSelection, l6, "@:");
        OS.objc_registerClassPair(l47);
        OS.class_addMethod(OS.object_getClass(l47), OS.sel_cellClass, l6, "@:");
        l47 = this.registerCellSubclass(NSSearchField.cellClass(), size, align, types);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        string = "SWTSecureTextField";
        l47 = OS.objc_allocateClassPair(OS.class_NSSecureTextField, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.class_addMethod(l47, OS.sel_textDidChange_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_textViewDidChangeSelection_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, l32, "@:@{NSRange}{NSRange}");
        OS.objc_registerClassPair(l47);
        l2 = OS.objc_lookUpClass("NSSecureTextView");
        if (l2 != 0L) {
            string = "SWTSecureEditorView";
            l47 = OS.objc_allocateClassPair(l2, string, 0L);
            this.addEventMethods(l47, 0L, l7, l12, 0L, 0L);
            OS.class_addMethod(l47, OS.sel_insertText_, l7, "@:@");
            OS.class_addMethod(l47, OS.sel_doCommandBySelector_, l7, "@::");
            OS.class_addMethod(l47, OS.sel_shouldChangeTextInRange_replacementString_, l34, "@:{NSRange}@");
            OS.objc_registerClassPair(l47);
        }
        string = "SWTSlider";
        l47 = OS.objc_allocateClassPair(OS.class_NSSlider, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_sendSelection, l6, "@:");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        OS.class_addMethod(OS.object_getClass(l47), OS.sel_cellClass, l6, "@:");
        l47 = this.registerCellSubclass(NSSlider.cellClass(), size, align, types);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        string = "SWTStepper";
        l47 = OS.objc_allocateClassPair(OS.class_NSStepper, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_sendSelection, l6, "@:");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        OS.class_addMethod(OS.object_getClass(l47), OS.sel_cellClass, l6, "@:");
        l47 = this.registerCellSubclass(NSStepper.cellClass(), size, align, types);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        string = "SWTTableHeaderCell";
        l47 = OS.objc_allocateClassPair(OS.class_NSTableHeaderCell, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_drawInteriorWithFrame_inView_, l13, "@:{NSRect}@");
        OS.objc_registerClassPair(l47);
        string = "SWTTableHeaderView";
        l47 = OS.objc_allocateClassPair(OS.class_NSTableHeaderView, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_mouseDown_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_resetCursorRects, l6, "@:");
        OS.class_addMethod(l47, OS.sel_updateTrackingAreas, l6, "@:");
        OS.class_addMethod(l47, OS.sel_menuForEvent_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_headerRectOfColumn_, l45, "@:i");
        OS.class_addMethod(l47, OS.sel_columnAtPoint_, l46, "@:{NSPoint}");
        OS.objc_registerClassPair(l47);
        string = "SWTTableView";
        l47 = OS.objc_allocateClassPair(OS.class_NSTableView, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_highlightSelectionInClipRect_, l27, "@:{NSRect}");
        OS.class_addMethod(l47, OS.sel_sendDoubleSelection, l6, "@:");
        OS.class_addMethod(l47, OS.sel_numberOfRowsInTableView_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_tableView_objectValueForTableColumn_row_, l4, "@:@@i");
        OS.class_addMethod(l47, OS.sel_tableView_shouldEditTableColumn_row_, l4, "@:@@i");
        OS.class_addMethod(l47, OS.sel_tableView_shouldReorderColumn_toColumn_, l4, "@:@ii");
        OS.class_addMethod(l47, OS.sel_tableView_shouldTrackCell_forTableColumn_row_, l3, "@:@@@i");
        OS.class_addMethod(l47, OS.sel_tableViewSelectionIsChanging_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_tableViewSelectionDidChange_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_tableView_willDisplayCell_forTableColumn_row_, l3, "@:@@@i");
        OS.class_addMethod(l47, OS.sel_tableView_setObjectValue_forTableColumn_row_, l3, "@:@@@i");
        OS.class_addMethod(l47, OS.sel_tableViewColumnDidMove_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_tableViewColumnDidResize_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_setShouldScrollClipView_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_tableView_didClickTableColumn_, l5, "@:@@");
        OS.class_addMethod(l47, OS.sel_canDragRowsWithIndexes_atPoint_, l36, "@:@{NSPoint=ff}");
        OS.class_addMethod(l47, OS.sel_selectRowIndexes_byExtendingSelection_, l5, "@:@Z");
        OS.class_addMethod(l47, OS.sel_deselectRow_, l7, "@:i");
        OS.class_addMethod(l47, OS.sel_deselectAll_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_tableView_writeRowsWithIndexes_toPasteboard_, l4, "@:@@@");
        OS.class_addMethod(l47, OS.sel_drawBackgroundInClipRect_, l43, "@:{NSRect}");
        OS.class_addMethod(l47, OS.sel_acceptsFirstResponder, l6, "@:");
        OS.class_addMethod(l47, OS.sel_needsPanelToBecomeKey, l6, "@:");
        OS.class_addMethod(l47, OS.sel_canBecomeKeyView, l6, "@:");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTTabView";
        l47 = OS.objc_allocateClassPair(OS.class_NSTabView, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_tabView_willSelectTabViewItem_, l5, "@:@@");
        OS.class_addMethod(l47, OS.sel_tabView_didSelectTabViewItem_, l5, "@:@@");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTTabViewItem";
        l47 = OS.objc_allocateClassPair(OS.class_NSTabViewItem, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_sizeOfLabel_, l40, "@::");
        OS.class_addMethod(l47, OS.sel_drawLabel_inRect_, l41, "@::{NSRect}");
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTTextView";
        l47 = OS.objc_allocateClassPair(OS.class_NSTextView, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.class_addMethod(l47, OS.sel_insertText_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_doCommandBySelector_, l7, "@::");
        OS.class_addMethod(l47, OS.sel_textDidChange_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_textView_clickedOnLink_atIndex_, l4, "@:@@@");
        OS.class_addMethod(l47, OS.sel_dragSelectionWithEvent_offset_slideBack_, l4, "@:@@@");
        OS.class_addMethod(l47, OS.sel_shouldChangeTextInRange_replacementString_, l34, "@:{NSRange}@");
        OS.class_addMethod(l47, OS.sel_drawViewBackgroundInRect_, l42, "@:{NSRect}");
        OS.class_addMethod(l47, OS.sel_shouldDrawInsertionPoint, l6, "@:");
        OS.objc_registerClassPair(l47);
        string = "SWTTextField";
        l47 = OS.objc_allocateClassPair(OS.class_NSTextField, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.class_addMethod(l47, OS.sel_acceptsFirstResponder, l6, "@:");
        OS.class_addMethod(l47, OS.sel_textDidChange_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_textDidEndEditing_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_textViewDidChangeSelection_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, l32, "@:@{NSRange}{NSRange}");
        OS.objc_registerClassPair(l47);
        OS.class_addMethod(OS.object_getClass(l47), OS.sel_cellClass, l6, "@:");
        l47 = this.registerCellSubclass(NSTextField.cellClass(), size, align, types);
        OS.class_addMethod(l47, OS.sel_drawInteriorWithFrame_inView_, l13, "@:{NSRect}@");
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        string = "SWTTreeItem";
        l47 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_dealloc, l6, "@:");
        OS.objc_registerClassPair(l47);
        string = "SWTView";
        l47 = OS.objc_allocateClassPair(OS.class_NSView, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_canBecomeKeyView, l6, "@:");
        OS.class_addMethod(l47, OS.sel_isFlipped, l11, "@:");
        OS.class_addMethod(l47, OS.sel_acceptsFirstResponder, l6, "@:");
        OS.class_addMethod(l47, OS.sel_isOpaque, l6, "@:");
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTWindow";
        this.createWindowSubclass(OS.class_NSWindow, string, false);
        string = "SWTPanel";
        l47 = OS.objc_allocateClassPair(OS.class_NSPanel, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_sendEvent_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_helpRequested_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_canBecomeKeyWindow, l6, "@:");
        OS.class_addMethod(l47, OS.sel_becomeKeyWindow, l6, "@:");
        OS.class_addMethod(l47, OS.sel_makeFirstResponder_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_noResponderFor_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_view_stringForToolTip_point_userData_, l35, "@:@i{NSPoint}@");
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTToolbar";
        l47 = OS.objc_allocateClassPair(OS.class_NSToolbar, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar_, l4, "@:@@Z");
        OS.class_addMethod(l47, OS.sel_toolbarAllowedItemIdentifiers_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_toolbarDefaultItemIdentifiers_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_toolbarSelectableItemIdentifiers_, l7, "@:@");
        this.addAccessibilityMethods(l47, l6, l7, l5, l33);
        OS.objc_registerClassPair(l47);
        string = "SWTToolbarView";
        l47 = OS.objc_allocateClassPair(OS.class_NSToolbarView, string, 0L);
        this.addEventMethods(l47, l6, l7, l12, l24, l37);
        this.addFrameMethods(l47, l22, l23);
        OS.objc_registerClassPair(l47);
        string = "SWTWindowDelegate";
        l47 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0L);
        OS.class_addIvar(l47, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(l47, OS.sel_windowDidResize_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_windowDidMove_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_windowShouldClose_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_windowWillClose_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_windowDidResignKey_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_windowDidBecomeKey_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_timerProc_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_systemSettingsChanged_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_windowDidMiniaturize_, l7, "@:@");
        OS.class_addMethod(l47, OS.sel_windowDidDeminiaturize_, l7, "@:@");
        OS.objc_registerClassPair(l47);
    }

    NSFont getFont(long l2, long l3) {
        long l4 = OS.objc_msgSend(OS.objc_msgSend(l2, OS.sel_alloc), OS.sel_initWithFrame_, new NSRect());
        long l5 = 0L;
        if (OS.objc_msgSend_bool(l4, OS.sel_respondsToSelector_, l3)) {
            l5 = OS.objc_msgSend(l4, l3);
        }
        NSFont nSFont = null;
        nSFont = l5 != 0L ? new NSFont(l5) : NSFont.systemFontOfSize(NSFont.systemFontSizeForControlSize(0L));
        nSFont.retain();
        OS.objc_msgSend(l4, OS.sel_release);
        return nSFont;
    }

    void initColors() {
        this.colors = new double[37][];
        this.colors[28] = this.getWidgetColorRGB(28);
        this.colors[29] = this.getWidgetColorRGB(29);
        this.colors[30] = this.getWidgetColorRGB(30);
        this.colors[31] = this.getWidgetColorRGB(31);
        this.colors[32] = this.getWidgetColorRGB(32);
        this.colors[33] = this.getWidgetColorRGB(33);
        this.colors[34] = this.getWidgetColorRGB(34);
        this.colors[35] = this.getWidgetColorRGB(35);
        this.colors[17] = this.getWidgetColorRGB(17);
        this.colors[18] = this.getWidgetColorRGB(18);
        this.colors[19] = this.getWidgetColorRGB(19);
        this.colors[20] = this.getWidgetColorRGB(20);
        this.colors[22] = this.getWidgetColorRGB(22);
        this.colors[21] = this.getWidgetColorRGB(21);
        this.colors[23] = this.getWidgetColorRGB(23);
        this.colors[24] = this.getWidgetColorRGB(24);
        this.colors[25] = this.getWidgetColorRGB(25);
        this.colors[27] = this.getWidgetColorRGB(27);
        this.colors[26] = this.getWidgetColorRGB(26);
        this.colors[36] = this.getWidgetColorRGB(36);
        this.alternateSelectedControlColor = this.getNSColorRGB(NSColor.alternateSelectedControlColor());
        this.alternateSelectedControlTextColor = this.getNSColorRGB(NSColor.alternateSelectedControlTextColor());
        this.secondarySelectedControlColor = this.getNSColorRGB(NSColor.secondarySelectedControlColor());
        this.selectedControlTextColor = this.getNSColorRGB(NSColor.selectedControlTextColor());
    }

    void initFonts() {
        this.smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        this.buttonFont = this.getFont(OS.class_NSButton, OS.sel_font);
        this.popUpButtonFont = this.getFont(OS.class_NSPopUpButton, OS.sel_font);
        this.textFieldFont = this.getFont(OS.class_NSTextField, OS.sel_font);
        this.secureTextFieldFont = this.getFont(OS.class_NSSecureTextField, OS.sel_font);
        this.searchFieldFont = this.getFont(OS.class_NSSearchField, OS.sel_font);
        this.comboBoxFont = this.getFont(OS.class_NSComboBox, OS.sel_font);
        this.sliderFont = this.getFont(OS.class_NSSlider, OS.sel_font);
        this.scrollerFont = this.getFont(OS.class_NSScroller, OS.sel_font);
        this.textViewFont = this.getFont(OS.class_NSTextView, OS.sel_font);
        this.tableViewFont = this.getFont(OS.class_NSTableView, OS.sel_font);
        this.outlineViewFont = this.getFont(OS.class_NSOutlineView, OS.sel_font);
        this.datePickerFont = this.getFont(OS.class_NSDatePicker, OS.sel_font);
        this.boxFont = this.getFont(OS.class_NSBox, OS.sel_titleFont);
        this.tabViewFont = this.getFont(OS.class_NSTabView, OS.sel_font);
        this.progressIndicatorFont = this.getFont(OS.class_NSProgressIndicator, OS.sel_font);
    }

    public long internal_new_GC(GCData gCData) {
        NSObject nSObject;
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.screenWindow == null) {
            nSObject = (NSWindow)new NSWindow().alloc();
            NSRect nSRect = new NSRect();
            nSObject = ((NSWindow)nSObject).initWithContentRect(nSRect, 0L, 2L, false);
            ((NSWindow)nSObject).setReleasedWhenClosed(false);
            this.screenWindow = nSObject;
        }
        nSObject = this.screenWindow.graphicsContext();
        if (gCData != null) {
            int n2 = 0x6000000;
            if ((gCData.style & n2) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.background = this.getSystemColor((int)1).handle;
            gCData.foreground = this.getSystemColor((int)2).handle;
            gCData.font = this.getSystemFont();
        }
        return ((NSGraphicsContext)nSObject).id;
    }

    public void internal_dispose_GC(long l2, GCData gCData) {
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    boolean isBundled() {
        NSDictionary nSDictionary;
        NSBundle nSBundle = NSBundle.mainBundle();
        if (nSBundle != null && (nSDictionary = nSBundle.infoDictionary()) != null) {
            return NSString.stringWith("APPL").isEqual(nSDictionary.objectForKey(NSString.stringWith("CFBundlePackageType")));
        }
        return false;
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        return string.substring(0, n2 + 1).equals(PACKAGE_PREFIX);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean post(Event event) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (event == null) {
                this.error(4);
            }
            long l2 = 0L;
            long l3 = OS.CGEventSourceCreate(1);
            if (l3 == 0L) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            boolean bl2 = false;
            int[] nArray = new int[1];
            int n2 = event.type;
            switch (n2) {
                case 1: 
                case 2: {
                    int n3 = Display.untranslateKey(event.keyCode);
                    if (n3 == 0) {
                        int n4;
                        long l4 = 0L;
                        long l5 = OS.TISCopyCurrentKeyboardInputSource();
                        long l6 = OS.TISGetInputSourceProperty(l5, OS.kTISPropertyUnicodeKeyLayoutData());
                        if (l6 == 0L) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                        l4 = OS.CFDataGetBytePtr(l6);
                        if (l4 == 0L) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                        if (OS.CFDataGetLength(l6) == 0L) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                        int n5 = 256;
                        n3 = -1;
                        char[] cArray = new char[n5];
                        int[] nArray2 = new int[1];
                        for (n4 = 0; n4 <= 127; n4 = (int)((short)(n4 + 1))) {
                            nArray[0] = 0;
                            OS.UCKeyTranslate(l4, (short)n4, (short)(n2 != 1 ? 1 : 0), 0, OS.LMGetKbdType(), 0, nArray, n5, nArray2, cArray);
                            if (cArray[0] != event.character) continue;
                            n3 = n4;
                            break;
                        }
                        if (n3 == -1) {
                            for (n4 = 0; n4 <= 127; n4 = (int)((short)(n4 + 1))) {
                                nArray[0] = 0;
                                OS.UCKeyTranslate(l4, (short)n4, (short)(n2 != 1 ? 1 : 0), 2, OS.LMGetKbdType(), 0, nArray, n5, nArray2, cArray);
                                if (cArray[0] != event.character) continue;
                                n3 = n4;
                                break;
                            }
                        }
                    }
                    if (n3 == -1 && event.character == '\u0000') {
                        n3 = 127;
                    }
                    if (n3 == -1) break;
                    if (OS.VERSION < 4192) {
                        bl2 = OS.CGPostKeyboardEvent((short)0, (short)n3, n2 == 1) == 0;
                        break;
                    }
                    l2 = OS.CGEventCreateKeyboardEvent(l3, (short)n3, n2 == 1);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    int n6;
                    CGPoint cGPoint = new CGPoint();
                    if (n2 == 5) {
                        cGPoint.x = event.x;
                        cGPoint.y = event.y;
                        l2 = OS.CGEventCreateMouseEvent(l3, 5, cGPoint, 0);
                        break;
                    }
                    NSPoint nSPoint = NSEvent.mouseLocation();
                    NSRect nSRect = this.getPrimaryFrame();
                    cGPoint.x = nSPoint.x;
                    cGPoint.y = (int)(nSRect.height - nSPoint.y);
                    int n7 = 0;
                    switch (event.button) {
                        case 1: {
                            n7 = event.type == 3 ? 1 : 2;
                            n6 = 0;
                            break;
                        }
                        case 2: {
                            n7 = event.type == 3 ? 25 : 26;
                            n6 = 2;
                            break;
                        }
                        case 3: {
                            n7 = event.type == 3 ? 3 : 4;
                            n6 = 1;
                            break;
                        }
                        default: {
                            n7 = event.type == 3 ? 25 : 26;
                            n6 = event.button - 1;
                        }
                    }
                    if (n6 < 0) break;
                    l2 = OS.CGEventCreateMouseEvent(l3, n7, cGPoint, n6);
                    break;
                }
                case 37: {
                    l2 = OS.CGEventCreateScrollWheelEvent(l3, 1, 1, event.count);
                }
            }
            if (!bl2 && l2 != 0L) {
                OS.CGEventPost(0, l2);
                OS.CFRelease(l2);
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl2 = true;
            }
            if (l3 != 0L) {
                OS.CFRelease(l3);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bl2;
        }
    }

    void postEvent(Event event) {
        int n2;
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n3 = this.eventQueue.length;
        for (n2 = 0; n2 < n3 && this.eventQueue[n2] != null; ++n2) {
        }
        if (n2 == n3) {
            Event[] eventArray = new Event[n3 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n3);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n2] = event;
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n2, int n3) {
        NSWindow nSWindow;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(n2, n3);
        if (control == control2) {
            return point;
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = n2;
        nSPoint.y = n3;
        NSWindow nSWindow2 = control != null ? control.view.window() : null;
        NSWindow nSWindow3 = nSWindow = control2 != null ? control2.view.window() : null;
        if (nSWindow != null && nSWindow2 != null && nSWindow.id == nSWindow2.id) {
            if (!control.view.isFlipped()) {
                nSPoint.y = control.view.bounds().height - nSPoint.y;
            }
            nSPoint = control.view.convertPoint_toView_(nSPoint, control2.view);
            if (!control2.view.isFlipped()) {
                nSPoint.y = control2.view.bounds().height - nSPoint.y;
            }
        } else {
            double d2;
            NSView nSView;
            NSRect nSRect = this.getPrimaryFrame();
            if (control != null) {
                nSView = control.eventView();
                if (!nSView.isFlipped()) {
                    nSPoint.y = nSView.bounds().height - nSPoint.y;
                }
                nSPoint = nSView.convertPoint_toView_(nSPoint, null);
                nSPoint = nSWindow2.convertBaseToScreen(nSPoint);
                nSPoint.y = nSRect.height - nSPoint.y;
                d2 = nSWindow2.userSpaceScaleFactor();
                nSPoint.x /= d2;
                nSPoint.y /= d2;
            }
            if (control2 != null) {
                nSView = control2.eventView();
                d2 = nSWindow.userSpaceScaleFactor();
                nSPoint.x *= d2;
                nSPoint.y = nSRect.height - nSPoint.y * d2;
                nSPoint = nSWindow.convertScreenToBase(nSPoint);
                nSPoint = nSView.convertPoint_fromView_(nSPoint, null);
                if (!nSView.isFlipped()) {
                    nSPoint.y = nSView.bounds().height - nSPoint.y;
                }
            }
        }
        point.x = (int)nSPoint.x;
        point.y = (int)nSPoint.y;
        return point;
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n2, int n3, int n4, int n5) {
        NSWindow nSWindow;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        if (control == control2) {
            return rectangle;
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = n2;
        nSPoint.y = n3;
        NSWindow nSWindow2 = control != null ? control.view.window() : null;
        NSWindow nSWindow3 = nSWindow = control2 != null ? control2.view.window() : null;
        if (nSWindow != null && nSWindow2 != null && nSWindow.id == nSWindow2.id) {
            if (!control.view.isFlipped()) {
                nSPoint.y = control.view.bounds().height - nSPoint.y;
            }
            nSPoint = control.view.convertPoint_toView_(nSPoint, control2.view);
            if (!control2.view.isFlipped()) {
                nSPoint.y = control2.view.bounds().height - nSPoint.y;
            }
        } else {
            double d2;
            NSView nSView;
            NSRect nSRect = this.getPrimaryFrame();
            if (control != null) {
                nSView = control.eventView();
                if (!nSView.isFlipped()) {
                    nSPoint.y = nSView.bounds().height - nSPoint.y;
                }
                nSPoint = nSView.convertPoint_toView_(nSPoint, null);
                nSPoint = nSWindow2.convertBaseToScreen(nSPoint);
                nSPoint.y = nSRect.height - nSPoint.y;
                d2 = nSWindow2.userSpaceScaleFactor();
                nSPoint.x /= d2;
                nSPoint.y /= d2;
            }
            if (control2 != null) {
                nSView = control2.eventView();
                d2 = nSWindow.userSpaceScaleFactor();
                nSPoint.x *= d2;
                nSPoint.y = nSRect.height - nSPoint.y * d2;
                nSPoint = nSWindow.convertScreenToBase(nSPoint);
                nSPoint = nSView.convertPoint_fromView_(nSPoint, null);
                if (!nSView.isFlipped()) {
                    nSPoint.y = nSView.bounds().height - nSPoint.y;
                }
            }
        }
        rectangle.x = (int)nSPoint.x;
        rectangle.y = (int)nSPoint.y;
        return rectangle;
    }

    long observerProc(long l2, long l3, long l4) {
        switch ((int)l3) {
            case 32: {
                if (!this.runAsyncMessages || !this.runAsyncMessages(false)) break;
                this.wakeThread();
            }
        }
        return 0L;
    }

    boolean performKeyEquivalent(NSWindow nSWindow, NSEvent nSEvent) {
        if (this.modalDialog == null) {
            return false;
        }
        if (nSEvent.type() != 10L) {
            return false;
        }
        int n2 = 0;
        long l2 = 0L;
        long l3 = nSEvent.modifierFlags();
        if ((l3 & 0x80000L) != 0L) {
            n2 |= 0x10000;
        }
        if ((l3 & 0x20000L) != 0L) {
            n2 |= 0x20000;
        }
        if ((l3 & 0x40000L) != 0L) {
            n2 |= 0x40000;
        }
        if ((l3 & 0x100000L) != 0L) {
            n2 |= 0x400000;
        }
        if (n2 == 0x400000) {
            short s2 = nSEvent.keyCode();
            switch (s2) {
                case 7: {
                    l2 = OS.sel_cut_;
                    break;
                }
                case 8: {
                    l2 = OS.sel_copy_;
                    break;
                }
                case 9: {
                    l2 = OS.sel_paste_;
                    break;
                }
                case 0: {
                    l2 = OS.sel_selectAll_;
                }
            }
            if (l2 != 0L) {
                NSApplication.sharedApplication().sendAction(l2, null, NSApplication.sharedApplication());
                return true;
            }
        }
        return false;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        if (this.sendEventCount == 0 && this.loopCount == this.poolCount - 1 && Callback.getEntryCount() == 0) {
            this.removePool();
        }
        this.addPool();
        this.runSkin();
        this.runDeferredLayouts();
        ++this.loopCount;
        boolean bl2 = false;
        try {
            bl2 |= this.runSettings();
            bl2 |= this.runTimers();
            bl2 |= this.runContexts();
            bl2 |= this.runPopups();
            NSEvent nSEvent = this.application.nextEventMatchingMask(0L, null, OS.NSDefaultRunLoopMode, true);
            if (nSEvent != null) {
                bl2 = true;
                this.application.sendEvent(nSEvent);
            }
            bl2 |= this.runPaint();
            if (!(bl2 |= this.runDeferredEvents())) {
                bl2 = this.isDisposed() || this.runAsyncMessages(false);
            }
        }
        finally {
            this.removePool();
            --this.loopCount;
            if (this.sendEventCount == 0 && this.loopCount == this.poolCount && Callback.getEntryCount() == 0) {
                this.addPool();
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i2 = 0; i2 < Displays.length; ++i2) {
                if (Displays[i2] != null) continue;
                Display.Displays[i2] = display;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Display[] displayArray = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
            displayArray[Display.Displays.length] = display;
            Displays = displayArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void release() {
        int n2;
        this.disposing = true;
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        for (n2 = 0; n2 < shellArray.length; ++n2) {
            Shell shell = shellArray[n2];
            if (shell.isDisposed()) continue;
            shell.dispose();
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        if (this.taskBar != null) {
            this.taskBar.dispose();
        }
        this.taskBar = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            for (n2 = 0; n2 < this.disposeList.length; ++n2) {
                if (this.disposeList[n2] == null) continue;
                this.disposeList[n2].run();
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        if (this.appMenu != null) {
            this.appMenu.dispose();
        }
        this.appMenu = null;
        if (this.appMenuBar != null) {
            this.appMenuBar.dispose();
        }
        this.appMenuBar = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int n2;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.infoImage = null;
        this.errorImage = null;
        this.currentCaret = null;
        if (this.hoverTimer != null) {
            this.timerExec(-1, this.hoverTimer);
        }
        this.hoverTimer = null;
        if (this.caretTimer != null) {
            this.timerExec(-1, this.caretTimer);
        }
        this.caretTimer = null;
        if (this.nsTimers != null) {
            for (n2 = 0; n2 < this.nsTimers.length; ++n2) {
                if (this.nsTimers[n2] == null) continue;
                this.nsTimers[n2].invalidate();
                this.nsTimers[n2].release();
            }
        }
        this.nsTimers = null;
        if (this.timerDelegate != null) {
            this.timerDelegate.release();
        }
        this.timerDelegate = null;
        for (n2 = 0; n2 < this.cursors.length; ++n2) {
            if (this.cursors[n2] == null) continue;
            this.cursors[n2].dispose();
        }
        this.cursors = null;
        if (this.buttonFont != null) {
            this.buttonFont.release();
        }
        if (this.popUpButtonFont != null) {
            this.popUpButtonFont.release();
        }
        if (this.textFieldFont != null) {
            this.textFieldFont.release();
        }
        if (this.secureTextFieldFont != null) {
            this.secureTextFieldFont.release();
        }
        if (this.searchFieldFont != null) {
            this.searchFieldFont.release();
        }
        if (this.comboBoxFont != null) {
            this.comboBoxFont.release();
        }
        if (this.sliderFont != null) {
            this.sliderFont.release();
        }
        if (this.scrollerFont != null) {
            this.scrollerFont.release();
        }
        if (this.textViewFont != null) {
            this.textViewFont.release();
        }
        if (this.tableViewFont != null) {
            this.tableViewFont.release();
        }
        if (this.outlineViewFont != null) {
            this.outlineViewFont.release();
        }
        if (this.datePickerFont != null) {
            this.datePickerFont.release();
        }
        if (this.boxFont != null) {
            this.boxFont.release();
        }
        if (this.tabViewFont != null) {
            this.tabViewFont.release();
        }
        if (this.progressIndicatorFont != null) {
            this.progressIndicatorFont.release();
        }
        this.secureTextFieldFont = null;
        this.textFieldFont = null;
        this.popUpButtonFont = null;
        this.buttonFont = null;
        this.comboBoxFont = this.sliderFont = this.scrollerFont;
        this.searchFieldFont = this.sliderFont;
        this.datePickerFont = null;
        this.outlineViewFont = null;
        this.tableViewFont = null;
        this.textViewFont = null;
        this.progressIndicatorFont = null;
        this.tabViewFont = null;
        this.boxFont = null;
        if (this.dockImage != null) {
            this.dockImage.release();
        }
        this.dockImage = null;
        if (this.screenWindow != null) {
            this.screenWindow.release();
        }
        this.screenWindow = null;
        if (this.needsDisplay != null) {
            this.needsDisplay.release();
        }
        if (this.needsDisplayInRect != null) {
            this.needsDisplayInRect.release();
        }
        if (this.isPainting != null) {
            this.isPainting.release();
        }
        if (this.runLoopModes != null) {
            this.runLoopModes.release();
        }
        this.runLoopModes = null;
        this.isPainting = null;
        this.needsDisplayInRect = null;
        this.needsDisplay = null;
        this.modalShells = null;
        this.modalDialog = null;
        this.menuBar = null;
        this.menus = null;
        if (this.markedAttributes != null) {
            this.markedAttributes.release();
        }
        this.markedAttributes = null;
        if (this.oldCursorSetProc != 0L) {
            long l2 = OS.class_getInstanceMethod(OS.class_NSCursor, OS.sel_set);
            OS.method_setImplementation(l2, this.oldCursorSetProc);
        }
        if (this.cursorSetCallback != null) {
            this.cursorSetCallback.dispose();
        }
        this.cursorSetCallback = null;
        if (this.settingsDelegate != null) {
            NSNotificationCenter.defaultCenter().removeObserver(this.settingsDelegate);
            this.settingsDelegate.release();
        }
        this.settingsDelegate = null;
        if (!this.isEmbedded) {
            NSMenu nSMenu = this.application.mainMenu();
            for (long i2 = nSMenu.numberOfItems(); i2 > 1L; --i2) {
                nSMenu.removeItemAtIndex(i2 - 1L);
            }
        }
        if (dynamicObjectMap != null) {
            dynamicObjectMap.clear();
            dynamicObjectMap = null;
        }
        if (this.application != null && this.applicationClass != 0L) {
            OS.object_setClass(this.application.id, this.applicationClass);
        }
        this.application = null;
        this.applicationClass = 0L;
        if (this.runLoopObserver != 0L) {
            OS.CFRunLoopObserverInvalidate(this.runLoopObserver);
            OS.CFRelease(this.runLoopObserver);
        }
        this.runLoopObserver = 0L;
        if (this.observerCallback != null) {
            this.observerCallback.dispose();
        }
        this.observerCallback = null;
    }

    void removeContext(GCData gCData) {
        if (this.contexts == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.contexts.length; ++i2) {
            if (this.contexts[i2] == null) continue;
            if (this.contexts[i2] == gCData) {
                this.contexts[i2] = null;
                continue;
            }
            ++n2;
        }
        if (n2 == 0) {
            this.contexts = null;
        }
    }

    public void removeFilter(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n2, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, listener);
    }

    Widget removeWidget(NSObject nSObject) {
        Object object;
        if (nSObject == null) {
            return null;
        }
        long[] lArray = new long[1];
        long l2 = OS.object_getInstanceVariable(nSObject.id, SWT_OBJECT, lArray);
        if (l2 == 0L && dynamicObjectMap != null) {
            object = (LONG)dynamicObjectMap.get(nSObject);
            if (object != null) {
                lArray[0] = ((LONG)object).value;
            }
            dynamicObjectMap.remove(nSObject);
        }
        if (lArray[0] == 0L) {
            return null;
        }
        object = (Widget)OS.JNIGetObject(lArray[0]);
        OS.object_setInstanceVariable(nSObject.id, SWT_OBJECT, 0L);
        return object;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        for (int i2 = 0; i2 < this.menus.length; ++i2) {
            if (this.menus[i2] != menu) continue;
            this.menus[i2] = null;
            break;
        }
    }

    void removePool() {
        NSAutoreleasePool nSAutoreleasePool = this.pools[this.poolCount - 1];
        this.pools[--this.poolCount] = null;
        if (this.poolCount == 0) {
            NSMutableDictionary nSMutableDictionary = NSThread.currentThread().threadDictionary();
            nSMutableDictionary.removeObjectForKey(NSString.stringWith("SWT_NSAutoreleasePool"));
        }
        nSAutoreleasePool.release();
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        for (int i2 = 0; i2 < this.popups.length; ++i2) {
            if (this.popups[i2] != menu) continue;
            this.popups[i2] = null;
            return;
        }
    }

    boolean runAsyncMessages(boolean bl2) {
        return this.synchronizer.runAsyncMessages(bl2);
    }

    boolean runAWTInvokeLater() {
        long l2 = OS.objc_lookUpClass("JNFRunLoop");
        if (l2 == 0L) {
            return false;
        }
        long l3 = OS.objc_msgSend(l2, OS.sel_javaRunLoopMode);
        if (l3 == 0L) {
            return false;
        }
        NSString nSString = new NSString(l3);
        this.runAsyncMessages = false;
        this.allowTimers = false;
        NSRunLoop.currentRunLoop().runMode(nSString, NSDate.distantFuture());
        this.runAsyncMessages = true;
        this.allowTimers = true;
        return true;
    }

    boolean runContexts() {
        if (this.contexts != null) {
            for (int i2 = 0; i2 < this.contexts.length; ++i2) {
                if (this.contexts[i2] == null || this.contexts[i2].flippedContext == null) continue;
                this.contexts[i2].flippedContext.flushGraphics();
            }
        }
        return false;
    }

    boolean runDeferredEvents() {
        Event event;
        boolean bl2 = false;
        while (this.eventQueue != null && (event = this.eventQueue[0]) != null) {
            Widget widget;
            int n2 = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n2);
            this.eventQueue[n2] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            bl2 = true;
            widget2.notifyListeners(event.type, event);
        }
        this.eventQueue = null;
        return bl2;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] compositeArray = this.layoutDeferred;
            int n2 = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Composite composite = compositeArray[i2];
                if (composite.isDisposed()) continue;
                composite.setLayoutDeferred(false);
            }
            return true;
        }
        return false;
    }

    NSArray runLoopModes() {
        if (this.runLoopModes == null) {
            this.runLoopModes = NSMutableArray.arrayWithCapacity(3L);
            this.runLoopModes.addObject(OS.NSEventTrackingRunLoopMode);
            this.runLoopModes.addObject(OS.NSDefaultRunLoopMode);
            this.runLoopModes.addObject(OS.NSModalPanelRunLoopMode);
            this.runLoopModes.retain();
        }
        this.runLoopModes.retain();
        this.runLoopModes.autorelease();
        return this.runLoopModes;
    }

    boolean runPaint() {
        int n2;
        long l2;
        if (this.needsDisplay == null && this.needsDisplayInRect == null) {
            return false;
        }
        if (this.needsDisplay != null) {
            l2 = this.needsDisplay.count();
            n2 = 0;
            while ((long)n2 < l2) {
                OS.objc_msgSend(this.needsDisplay.objectAtIndex((long)((long)n2)).id, OS.sel_setNeedsDisplay_, true);
                ++n2;
            }
            this.needsDisplay.release();
            this.needsDisplay = null;
        }
        if (this.needsDisplayInRect != null) {
            l2 = this.needsDisplayInRect.count();
            n2 = 0;
            while ((long)n2 < l2) {
                NSValue nSValue = new NSValue(this.needsDisplayInRect.objectAtIndex(n2 + 1));
                OS.objc_msgSend(this.needsDisplayInRect.objectAtIndex((long)((long)n2)).id, OS.sel_setNeedsDisplayInRect_, nSValue.rectValue());
                n2 += 2;
            }
            this.needsDisplayInRect.release();
            this.needsDisplayInRect = null;
        }
        return true;
    }

    boolean runPopups() {
        Menu menu;
        if (this.popups == null) {
            return false;
        }
        boolean bl2 = false;
        while (this.popups != null && (menu = this.popups[0]) != null) {
            int n2 = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n2);
            this.popups[n2] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            bl2 = true;
        }
        this.popups = null;
        return bl2;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.initColors();
        this.sendEvent(39, null);
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            Shell shell = shellArray[i2];
            if (shell.isDisposed()) continue;
            shell.redraw(true);
            shell.layout(true, true);
        }
        return true;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] widgetArray = this.skinList;
            int n2 = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    Widget widget = widgetArray[i2];
                    if (widget == null || widget.isDisposed()) continue;
                    widget.state &= 0xFFDFFFFF;
                    widgetArray[i2] = null;
                    Event event = new Event();
                    event.widget = widget;
                    this.sendEvent(45, event);
                }
            }
            return true;
        }
        return false;
    }

    boolean runTimers() {
        if (this.timerList == null) {
            return false;
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.timerList.length; ++i2) {
            if (this.nsTimers[i2] != null || this.timerList[i2] == null) continue;
            Runnable runnable = this.timerList[i2];
            this.timerList[i2] = null;
            if (runnable == null) continue;
            bl2 = true;
            runnable.run();
        }
        return bl2;
    }

    void sendEvent(int n2, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n2;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        this.sendEvent(this.eventTable, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(EventTable eventTable, Event event) {
        block6: {
            try {
                ++this.sendEventCount;
                if (this.filterEvent(event) || eventTable == null) break block6;
                int n2 = event.type;
                this.sendPreEvent(n2);
                try {
                    eventTable.sendEvent(event);
                }
                finally {
                    this.sendPostEvent(n2);
                }
            }
            finally {
                --this.sendEventCount;
            }
        }
    }

    void sendPreEvent(int n2) {
        if (n2 != 50 && n2 != 51 && n2 != 52 && n2 != 53 && this.eventTable != null && this.eventTable.hooks(50)) {
            Event event = new Event();
            event.detail = n2;
            this.sendEvent(50, event);
        }
    }

    void sendPostEvent(int n2) {
        if (n2 != 50 && n2 != 51 && n2 != 52 && n2 != 53 && this.eventTable != null && this.eventTable.hooks(51)) {
            Event event = new Event();
            event.detail = n2;
            this.sendEvent(51, event);
        }
    }

    public void sendPreExternalEventDispatchEvent() {
        if (this.eventTable != null && this.eventTable.hooks(52)) {
            this.sendEvent(52, null);
        }
    }

    public void sendPostExternalEventDispatchEvent() {
        if (this.eventTable != null && this.eventTable.hooks(53)) {
            this.sendEvent(53, null);
        }
    }

    static NSString getApplicationName() {
        Object object;
        NSString nSString = null;
        int n2 = OS.getpid();
        long l2 = OS.getenv(Display.ascii("APP_NAME_" + n2));
        if (l2 != 0L) {
            nSString = NSString.stringWithUTF8String(l2);
        }
        if (nSString == null && APP_NAME != null) {
            nSString = NSString.stringWith(APP_NAME);
        }
        if (nSString == null && (object = NSBundle.mainBundle().objectForInfoDictionaryKey(NSString.stringWith("CFBundleName"))) != null) {
            nSString = new NSString((id)object);
        }
        if (nSString == null && (object = System.getProperty("com.apple.mrj.application.apple.menu.about.name")) != null) {
            nSString = NSString.stringWith((String)object);
        }
        if (nSString == null) {
            nSString = NSString.stringWith("SWT");
        }
        return nSString;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    public static void setAppVersion(String string) {
        APP_VERSION = string;
    }

    void setCurrentCaret(Caret caret) {
        this.currentCaret = caret;
        int n2 = this.currentCaret != null ? this.currentCaret.blinkRate : -1;
        this.timerExec(n2, this.caretTimer);
    }

    void setCursor(Control control) {
        Cursor cursor = null;
        if (control != null && !control.isDisposed()) {
            cursor = control.findCursor();
        }
        if (cursor == null) {
            NSWindow nSWindow = this.application.keyWindow();
            if (nSWindow != null) {
                if (nSWindow.areCursorRectsEnabled()) {
                    nSWindow.disableCursorRects();
                    nSWindow.enableCursorRects();
                }
                return;
            }
            cursor = this.getSystemCursor(0);
        }
        this.lockCursor = false;
        cursor.handle.set();
        this.lockCursor = true;
    }

    public void setCursorLocation(int n2, int n3) {
        this.checkDevice();
        Event event = new Event();
        event.type = 5;
        event.x = n2;
        event.y = n3;
        this.post(event);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String string, Object object) {
        Object[] objectArray;
        Object[] objectArray2;
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(ADD_WIDGET_KEY)) {
            Object[] objectArray3 = (Object[])object;
            objectArray2 = (Object[])objectArray3[0];
            objectArray = (Object[])objectArray3[1];
            if (objectArray == null) {
                this.removeWidget((NSObject)objectArray2);
            } else {
                this.addWidget((NSObject)objectArray2, (Widget)objectArray);
            }
        }
        if (string.equals(SET_MODAL_DIALOG)) {
            this.setModalDialog(object != null ? (Dialog)object : null);
        }
        if (string.equals(MOZILLA_RUNNING)) {
            this.mozillaRunning = (Boolean)object;
        }
        if (string.equals(LOCK_CURSOR)) {
            this.lockCursor = (Boolean)object;
        }
        if (string.equals(RUN_AWT_INVOKE_LATER_KEY) && object != null) {
            object = new Boolean(this.runAWTInvokeLater());
        }
        if (object == null) {
            int n2;
            if (this.keys == null) {
                return;
            }
            for (n2 = 0; n2 < this.keys.length && !this.keys[n2].equals(string); ++n2) {
            }
            if (n2 == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                objectArray2 = new String[this.keys.length - 1];
                objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, objectArray2, 0, n2);
                System.arraycopy(this.keys, n2 + 1, objectArray2, n2, objectArray2.length - n2);
                System.arraycopy(this.values, 0, objectArray, 0, n2);
                System.arraycopy(this.values, n2 + 1, objectArray, n2, objectArray.length - n2);
                this.keys = objectArray2;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            if (!this.keys[i2].equals(string)) continue;
            this.values[i2] = object;
            return;
        }
        String[] stringArray = new String[this.keys.length + 1];
        objectArray2 = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray2, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray2[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray2;
    }

    void setMenuBar(Menu menu) {
        if (menu == null) {
            menu = this.appMenuBar;
        }
        if (menu == this.menuBar) {
            return;
        }
        this.menuBar = menu;
        NSMenu nSMenu = this.application.mainMenu();
        OS.CancelMenuTracking(OS.AcquireRootMenu(), true, 0);
        for (long i2 = nSMenu.numberOfItems(); i2 > 1L; --i2) {
            nSMenu.removeItemAtIndex(i2 - 1L);
        }
        if (menu != null) {
            MenuItem[] menuItemArray = menu.getItems();
            for (int i3 = 0; i3 < menuItemArray.length; ++i3) {
                NSMenu nSMenu2;
                MenuItem menuItem = menuItemArray[i3];
                NSMenuItem nSMenuItem = menuItem.nsItem;
                if (OS.VERSION >= 4192 && (nSMenu2 = nSMenuItem.submenu()) != null && nSMenu2.title().getString().equals(SWT.getMessage("SWT_Help"))) {
                    this.application.setHelpMenu(nSMenu2);
                }
                nSMenuItem.setMenu(null);
                nSMenu.addItem(nSMenuItem);
                boolean bl2 = menu.getEnabled() && menuItem.getEnabled();
                nSMenuItem.setEnabled(!bl2);
                nSMenuItem.setEnabled(bl2);
            }
        }
    }

    void setModalDialog(Dialog dialog) {
        this.setModalDialog(dialog, null);
    }

    void setModalDialog(Dialog dialog, NSPanel nSPanel) {
        this.modalDialog = dialog;
        this.modalPanel = nSPanel;
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        int n2;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n3 = this.modalShells.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.modalShells[n2] == shell) {
                return;
            }
            if (this.modalShells[n2] == null) break;
        }
        if (n2 == n3) {
            shellArray = new Shell[n3 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n3);
            this.modalShells = shellArray;
        }
        this.modalShells[n2] = shell;
        shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            shellArray[i2].updateModal();
        }
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Synchronizer synchronizer2 = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (synchronizer2 != null) {
                synchronizer2.runAsyncMessages(true);
            }
            return;
        }
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        this.sendPreExternalEventDispatchEvent();
        try {
            this.addPool();
            this.runAsyncMessages = false;
            this.allowTimers = false;
            NSRunLoop.currentRunLoop().runMode(OS.NSDefaultRunLoopMode, NSDate.distantFuture());
            this.runAsyncMessages = true;
            this.allowTimers = true;
        }
        finally {
            this.removePool();
        }
        this.sendPostExternalEventDispatchEvent();
        return true;
    }

    int sourceProc(int n2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    public void timerExec(int n2, Runnable runnable) {
        NSTimer[] nSTimerArray;
        Object object;
        int n3;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.nsTimers == null) {
            this.nsTimers = new NSTimer[4];
        }
        for (n3 = 0; n3 < this.timerList.length && this.timerList[n3] != runnable; ++n3) {
        }
        if (n3 != this.timerList.length) {
            object = this.nsTimers[n3];
            if (object == null) {
                this.timerList[n3] = null;
            } else {
                if (n2 < 0) {
                    object.invalidate();
                    object.release();
                    this.timerList[n3] = null;
                    this.nsTimers[n3] = null;
                } else {
                    object.setFireDate(NSDate.dateWithTimeIntervalSinceNow((double)n2 / 1000.0));
                }
                return;
            }
        }
        if (n2 < 0) {
            return;
        }
        for (n3 = 0; n3 < this.timerList.length && this.timerList[n3] != null; ++n3) {
        }
        if (n3 == this.timerList.length) {
            object = new Runnable[this.timerList.length + 4];
            System.arraycopy(this.timerList, 0, object, 0, this.timerList.length);
            this.timerList = object;
            nSTimerArray = new NSTimer[this.nsTimers.length + 4];
            System.arraycopy(this.nsTimers, 0, nSTimerArray, 0, this.nsTimers.length);
            this.nsTimers = nSTimerArray;
        }
        object = NSNumber.numberWithInt(n3);
        nSTimerArray = NSTimer.scheduledTimerWithTimeInterval((double)n2 / 1000.0, this.timerDelegate, OS.sel_timerProc_, (id)object, false);
        NSRunLoop nSRunLoop = NSRunLoop.currentRunLoop();
        nSRunLoop.addTimer((NSTimer)nSTimerArray, OS.NSModalPanelRunLoopMode);
        nSRunLoop.addTimer((NSTimer)nSTimerArray, OS.NSEventTrackingRunLoopMode);
        nSTimerArray.retain();
        if (nSTimerArray != null) {
            this.nsTimers[n3] = nSTimerArray;
            this.timerList[n3] = runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long timerProc(long l2, long l3, long l4) {
        NSTimer nSTimer = new NSTimer(l4);
        try {
            NSNumber nSNumber = new NSNumber(nSTimer.userInfo());
            int n2 = nSNumber.intValue();
            if (this.timerList == null) {
                long l5 = 0L;
                return l5;
            }
            if (0 <= n2 && n2 < this.timerList.length) {
                if (this.allowTimers) {
                    Runnable runnable = this.timerList[n2];
                    this.timerList[n2] = null;
                    this.nsTimers[n2] = null;
                    if (runnable != null) {
                        runnable.run();
                    }
                } else {
                    this.nsTimers[n2] = null;
                    this.wakeThread();
                }
            }
        }
        finally {
            nSTimer.invalidate();
            nSTimer.release();
        }
        return 0L;
    }

    public void update() {
        this.checkDevice();
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            Shell shell = shellArray[i2];
            if (shell.isDisposed()) continue;
            shell.update(true);
        }
    }

    void updateDefaultButton() {
        this.timerExec(this.hasDefaultButton() ? 30 : -1, this.defaultButtonTimer);
    }

    void updateQuitMenu() {
        NSMenu nSMenu;
        long l2;
        NSMenu nSMenu2;
        Object object;
        if (this.isEmbedded) {
            return;
        }
        boolean bl2 = true;
        Shell[] shellArray = this.getShells();
        int n2 = 229376;
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            object = shellArray[i2];
            if ((((Shell)object).style & n2) == 0 || !((Shell)object).isVisible()) continue;
            bl2 = false;
            break;
        }
        if ((object = (nSMenu2 = this.application.mainMenu()).itemAtIndex(0L)) != null && (l2 = (nSMenu = ((NSMenuItem)object).submenu()).indexOfItemWithTarget(applicationDelegate, OS.sel_applicationShouldTerminate_)) != -1L) {
            NSMenuItem nSMenuItem = nSMenu.itemAtIndex(l2);
            nSMenuItem.setEnabled(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        NSObject nSObject = new NSObject().alloc().init();
        nSObject.performSelectorOnMainThread(OS.sel_release, null, false);
    }

    Control findControl(boolean bl2) {
        return this.findControl(bl2, null);
    }

    Control findControl(boolean bl2, NSView[] nSViewArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        NSPoint nSPoint = NSEvent.mouseLocation();
        long l2 = 0L;
        if (OS.VERSION >= 4192) {
            l2 = NSWindow.windowNumberAtPoint(nSPoint, 0L);
        } else {
            object3 = new long[1];
            OS.FindWindow((long)nSPoint.x, (long)(this.getPrimaryFrame().height - nSPoint.y), (long[])object3);
            if (object3[0] != 0L) {
                l2 = OS.HIWindowGetCGWindowID((long)object3[0]);
            }
        }
        object3 = this.application.windowWithWindowNumber(l2);
        if (object3 != null) {
            object2 = ((NSWindow)object3).contentView();
            if (object2 != null) {
                object2 = ((NSView)object2).superview();
            }
            if (object2 != null && (object4 = ((NSView)object2).hitTest((NSPoint)(object = ((NSWindow)object3).convertScreenToBase(nSPoint)))) == null && !bl2) {
                object4 = object2;
            }
        }
        object2 = null;
        if (object4 != null) {
            do {
                if (!((object = this.getWidget((NSView)object4)) instanceof Control)) continue;
                object2 = (Control)object;
                break;
            } while ((object4 = ((NSView)object4).superview()) != null);
        }
        if (bl2 && object2 != null && ((Control)object2).isTrim((NSView)object4)) {
            object2 = null;
        }
        if (object2 != null && nSViewArray != null) {
            nSViewArray[0] = object4;
        }
        return object2;
    }

    void finishLaunching(long l2, long l3) {
        if (launched) {
            return;
        }
        launched = true;
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l2;
        objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l3);
    }

    void applicationDidBecomeActive(long l2, long l3, long l4) {
        NSWindow nSWindow = this.application.keyWindow();
        if (nSWindow != null) {
            nSWindow.orderFrontRegardless();
        } else {
            this.setMenuBar(this.menuBar);
        }
        this.checkFocus();
        this.checkEnterExit(this.findControl(true), null, false);
    }

    void applicationDidResignActive(long l2, long l3, long l4) {
        this.checkFocus();
        this.checkEnterExit(null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long applicationNextEventMatchingMask(long l2, long l3, long l4, long l5, long l6, long l7) {
        if (l7 != 0L && this.trackingControl != null && !this.trackingControl.isDisposed()) {
            this.runDeferredEvents();
        }
        this.sendPreExternalEventDispatchEvent();
        try {
            objc_super objc_super2 = new objc_super();
            objc_super2.receiver = l2;
            objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
            long l8 = OS.objc_msgSendSuper(objc_super2, l3, l4, l5, l6, l7 != 0L);
            if (l8 != 0L) {
                if (l7 != 0L && this.currentCombo != null && !this.currentCombo.isDisposed()) {
                    NSEvent nSEvent = new NSEvent(l8);
                    if (this.mozillaRunning && nSEvent.type() == 15L) {
                        long l9 = 0L;
                        return l9;
                    }
                    if (nSEvent.type() == 10L) {
                        this.currentCombo.sendTrackingKeyEvent(nSEvent, 1);
                    }
                }
                if (l7 != 0L && this.trackingControl != null && !this.trackingControl.isDisposed()) {
                    this.applicationSendTrackingEvent(new NSEvent(l8), this.trackingControl);
                }
            }
            long l10 = l8;
            return l10;
        }
        finally {
            this.sendPostExternalEventDispatchEvent();
        }
    }

    void applicationSendTrackingEvent(NSEvent nSEvent, Control control) {
        int n2 = (int)nSEvent.type();
        boolean bl2 = false;
        Control control2 = null;
        switch (n2) {
            case 1: 
            case 3: 
            case 25: {
                this.clickCount = (int)((long)this.clickCountButton == nSEvent.buttonNumber() ? nSEvent.clickCount() : 1L);
                this.clickCountButton = (int)nSEvent.buttonNumber();
                control.sendMouseEvent(nSEvent, 3, true);
                break;
            }
            case 2: 
            case 4: 
            case 26: {
                bl2 = true;
                control2 = this.findControl(true);
                Control control3 = control;
                this.trackingControl = null;
                if (this.clickCount == 2) {
                    control3.sendMouseEvent(nSEvent, 8, false);
                }
                if (control3.isDisposed()) break;
                control3.sendMouseEvent(nSEvent, 4, false);
                break;
            }
            case 6: 
            case 7: 
            case 27: {
                bl2 = true;
                control2 = control;
            }
            case 5: {
                control.sendMouseEvent(nSEvent, 5, true);
            }
        }
        if (bl2 && (control2 == null || !control2.isDisposed())) {
            this.checkEnterExit(control2, nSEvent, false);
        }
    }

    void applicationSendEvent(long l2, long l3, long l4) {
        Object object;
        NSEvent nSEvent = new NSEvent(l4);
        NSWindow nSWindow = nSEvent.window();
        if (this.performKeyEquivalent(nSWindow, nSEvent)) {
            return;
        }
        int n2 = (int)nSEvent.type();
        boolean bl2 = false;
        boolean bl3 = false;
        switch (n2) {
            case 1: 
            case 3: 
            case 25: {
                bl3 = true;
                bl2 = true;
            }
            case 2: 
            case 4: 
            case 26: {
                bl2 = true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: 
            case 27: {
                Shell shell;
                if (nSWindow == null || (object = (Shell)this.getWidget(nSWindow.id)) == null || (shell = ((Shell)object).getModalShell()) == null) break;
                if (bl2) {
                    if (this.application.isActive()) {
                        shell.window.orderFrontRegardless();
                    } else {
                        this.application.activateIgnoringOtherApps(true);
                    }
                    if (bl3) {
                        NSRect nSRect = nSWindow.contentView().frame();
                        NSPoint nSPoint = nSWindow.convertBaseToScreen(nSEvent.locationInWindow());
                        if (OS.NSPointInRect(nSPoint, nSRect)) {
                            this.beep();
                        }
                    }
                }
                return;
            }
        }
        if (n2 != 13) {
            this.sendEvent = true;
        }
        if (nSWindow != null && nSWindow.isKeyWindow() && nSEvent.type() == 10L && (nSEvent.modifierFlags() & 0x400000L) != 0L) {
            nSWindow.sendEvent(nSEvent);
        }
        if (nSWindow != null && nSWindow.isKeyWindow() && nSEvent.type() == 11L && (nSEvent.modifierFlags() & 0x100000L) != 0L) {
            nSWindow.sendEvent(nSEvent);
        } else {
            object = new objc_super();
            ((objc_super)object).receiver = l2;
            ((objc_super)object).super_class = OS.objc_msgSend(l2, OS.sel_superclass);
            OS.objc_msgSendSuper((objc_super)object, l3, l4);
        }
        if (n2 != 13) {
            this.sendEvent = false;
        }
    }

    void applicationWillFinishLaunching(long l2, long l3, long l4) {
        NSMenuItem nSMenuItem;
        NSObject nSObject;
        Object object;
        Object object2;
        boolean bl2 = false;
        if (this.isEmbedded) {
            object2 = new long[1];
            object = new short[1];
            int n2 = OS.GetIndMenuItemWithCommandID(0L, 1751737445, 1, (long[])object2, (short[])object);
            if (n2 == 0) {
                OS.DeleteMenuItem((long)object2[0], (short)object[0]);
            }
            if ((n2 = OS.GetIndMenuItemWithCommandID(0L, 1751737455, 1, (long[])object2, (short[])object)) == 0) {
                OS.DeleteMenuItem((long)object2[0], (short)object[0]);
            }
            if ((n2 = OS.GetIndMenuItemWithCommandID(0L, 1936220524, 1, (long[])object2, (short[])object)) == 0) {
                OS.DeleteMenuItem((long)object2[0], (short)object[0]);
            }
            if ((n2 = OS.GetIndMenuItemWithCommandID(0L, 1903520116, 1, (long[])object2, (short[])object)) == 0) {
                OS.DeleteMenuItem((long)object2[0], (short)object[0]);
            }
            if ((n2 = OS.GetIndMenuItemWithCommandID(0L, 1936028278, 1, (long[])object2, (short[])object)) == 0) {
                OS.DeleteMenuItem((long)object2[0], (short)object[0]);
            }
        }
        object2 = Locale.getDefault();
        object = ((Locale)object2).getLanguage();
        NSLocale nSLocale = (NSLocale)new NSLocale().alloc();
        nSLocale = new NSLocale(nSLocale.initWithLocaleIdentifier(NSString.stringWith("en_US")));
        NSString nSString = nSLocale.displayNameForKey(OS.NSLocaleLanguageCode, NSString.stringWith((String)object));
        if (nSLocale != null) {
            nSLocale.release();
        }
        NSBundle nSBundle = NSBundle.bundleWithIdentifier(NSString.stringWith("com.apple.JavaVM"));
        NSDictionary nSDictionary = NSDictionary.dictionaryWithObject(applicationDelegate, NSString.stringWith("NSOwner"));
        NSString nSString2 = nSBundle.pathForResource(NSString.stringWith("DefaultApp"), NSString.stringWith("nib"), null, nSString);
        if (nSString2 == null) {
            nSString2 = nSBundle.pathForResource(NSString.stringWith("DefaultApp"), NSString.stringWith("nib"), null, NSString.stringWith((String)object));
        }
        if (nSString2 == null) {
            nSString2 = nSBundle.pathForResource(NSString.stringWith("DefaultApp"), NSString.stringWith("nib"));
        }
        if (!bl2) {
            boolean bl3 = bl2 = nSString2 != null && NSBundle.loadNibFile(nSString2, nSDictionary, 0L);
        }
        if (!bl2) {
            nSObject = nSBundle.resourcePath();
            nSString2 = nSObject != null ? ((NSString)nSObject).stringByAppendingString(NSString.stringWith("/English.lproj/DefaultApp.nib")) : null;
            boolean bl4 = bl2 = nSString2 != null && NSBundle.loadNibFile(nSString2, nSDictionary, 0L);
        }
        if (!bl2) {
            nSString2 = NSString.stringWith(System.getProperty("java.home") + "/../Resources/English.lproj/DefaultApp.nib");
            boolean bl5 = bl2 = nSString2 != null && NSBundle.loadNibFile(nSString2, nSDictionary, 0L);
        }
        if (!bl2) {
            this.createMainMenu();
        }
        if ((nSMenuItem = ((NSMenu)(nSObject = this.application.mainMenu())).itemAtIndex(0L)) != null) {
            NSObject nSObject2;
            NSString nSString3 = Display.getApplicationName();
            NSString nSString4 = NSString.stringWith("%@");
            nSMenuItem.setTitle(nSString3);
            NSMenu nSMenu = nSMenuItem.submenu();
            NSArray nSArray = nSMenu.itemArray();
            int n3 = 0;
            while ((long)n3 < nSArray.count()) {
                NSMenuItem nSMenuItem2 = new NSMenuItem(nSArray.objectAtIndex(n3));
                nSObject2 = nSMenuItem2.title().stringByReplacingOccurrencesOfString(nSString4, nSString3);
                nSMenuItem2.setTitle((NSString)nSObject2);
                long l5 = 0L;
                switch (n3) {
                    case 0: {
                        l5 = -1L;
                        break;
                    }
                    case 2: {
                        l5 = -2L;
                        break;
                    }
                    case 6: {
                        l5 = -3L;
                        break;
                    }
                    case 7: {
                        l5 = -4L;
                        break;
                    }
                    case 8: {
                        l5 = -5L;
                        break;
                    }
                    case 10: {
                        l5 = -6L;
                    }
                }
                if (l5 != 0L) {
                    nSMenuItem2.setTag(l5);
                }
                ++n3;
            }
            long l6 = nSMenu.indexOfItemWithTarget(applicationDelegate, OS.sel_terminate_);
            if (l6 != -1L) {
                nSObject2 = nSMenu.itemAtIndex(l6);
                ((NSMenuItem)nSObject2).setAction(OS.sel_applicationShouldTerminate_);
            }
        }
    }

    static long applicationProc(long l2, long l3) {
        Display display = Display.getCurrent();
        if (display == null) {
            objc_super objc_super2 = new objc_super();
            objc_super2.receiver = l2;
            objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
            return OS.objc_msgSendSuper(objc_super2, l3);
        }
        if (l3 == OS.sel_isRunning) {
            return display.isDisposed() ? 0L : 1L;
        }
        if (l3 == OS.sel_finishLaunching) {
            display.finishLaunching(l2, l3);
        }
        return 0L;
    }

    static long applicationProc(long l2, long l3, long l4) {
        Display display = Display.getCurrent();
        if (display == null && l2 != Display.applicationDelegate.id) {
            objc_super objc_super2 = new objc_super();
            objc_super2.receiver = l2;
            objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
            return OS.objc_msgSendSuper(objc_super2, l3, l4);
        }
        if (currAppDelegate != null && currAppDelegate.respondsToSelector(l3)) {
            OS.objc_msgSend(Display.currAppDelegate.id, l3, l4);
        }
        NSApplication nSApplication = display.application;
        if (l3 == OS.sel_sendEvent_) {
            display.applicationSendEvent(l2, l3, l4);
        } else if (l3 == OS.sel_applicationWillFinishLaunching_) {
            display.applicationWillFinishLaunching(l2, l3, l4);
        } else {
            if (l3 == OS.sel_applicationShouldTerminate_) {
                int n2 = 0;
                if (!display.disposing) {
                    Event event = new Event();
                    display.sendEvent(21, event);
                    if (event.doit) {
                        display.dispose();
                        n2 = 1;
                    }
                }
                return n2;
            }
            if (l3 != OS.sel_orderFrontStandardAboutPanel_) {
                Menu menu;
                TaskItem taskItem;
                TaskBar taskBar;
                if (l3 == OS.sel_hideOtherApplications_) {
                    nSApplication.hideOtherApplications(nSApplication);
                } else if (l3 == OS.sel_hide_) {
                    nSApplication.hide(nSApplication);
                } else if (l3 == OS.sel_unhideAllApplications_) {
                    nSApplication.unhideAllApplications(nSApplication);
                } else if (l3 == OS.sel_applicationDidBecomeActive_) {
                    display.applicationDidBecomeActive(l2, l3, l4);
                } else if (l3 == OS.sel_applicationDidResignActive_) {
                    display.applicationDidResignActive(l2, l3, l4);
                } else if (l3 == OS.sel_applicationDockMenu_ && (taskBar = display.taskBar) != null && taskBar.itemCount != 0 && (taskItem = taskBar.getItem(null)) != null && (menu = taskItem.getMenu()) != null && !menu.isDisposed()) {
                    return menu.nsMenu.id;
                }
            }
        }
        return 0L;
    }

    static long applicationProc(long l2, long l3, long l4, long l5) {
        Display display = Display.getCurrent();
        if (display == null && l2 != Display.applicationDelegate.id) {
            objc_super objc_super2 = new objc_super();
            objc_super2.receiver = l2;
            objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
            return OS.objc_msgSendSuper(objc_super2, l3, l4, l5);
        }
        if (currAppDelegate != null && currAppDelegate.respondsToSelector(l3)) {
            OS.objc_msgSend(Display.currAppDelegate.id, l3, l4, l5);
        }
        if (l3 == OS.sel_application_openFile_) {
            String string = new NSString(l5).getString();
            Event event = new Event();
            event.text = string;
            display.sendEvent(46, event);
            return 1L;
        }
        if (l3 == OS.sel_application_openFiles_) {
            NSArray nSArray = new NSArray(l5);
            long l6 = nSArray.count();
            int n2 = 0;
            while ((long)n2 < l6) {
                String string = new NSString(nSArray.objectAtIndex(n2)).getString();
                Event event = new Event();
                event.text = string;
                display.sendEvent(46, event);
                ++n2;
            }
            new NSApplication(l4).replyToOpenOrPrint(0L);
        } else if (l3 == OS.sel_applicationShouldHandleReopen_hasVisibleWindows_) {
            Event event = new Event();
            display.sendEvent(26, event);
            return event.doit ? 1L : 0L;
        }
        return 0L;
    }

    static long applicationProc(long l2, long l3, long l4, long l5, long l6, long l7) {
        Display display = Display.getCurrent();
        if (display == null && l2 != Display.applicationDelegate.id) {
            objc_super objc_super2 = new objc_super();
            objc_super2.receiver = l2;
            objc_super2.super_class = OS.objc_msgSend(l2, OS.sel_superclass);
            return OS.objc_msgSendSuper(objc_super2, l3, l4, l5, l6, l7 != 0L);
        }
        if (l3 == OS.sel_nextEventMatchingMask_untilDate_inMode_dequeue_) {
            return display.applicationNextEventMatchingMask(l2, l3, l4, l5, l6, l7);
        }
        return 0L;
    }

    static long dialogProc(long l2, long l3, long l4) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l2, SWT_OBJECT, lArray);
        if (lArray[0] == 0L) {
            return 0L;
        }
        if (l3 == OS.sel_changeColor_) {
            ColorDialog colorDialog = (ColorDialog)OS.JNIGetObject(lArray[0]);
            if (colorDialog == null) {
                return 0L;
            }
            colorDialog.changeColor(l2, l3, l4);
        } else if (l3 == OS.sel_changeFont_) {
            FontDialog fontDialog = (FontDialog)OS.JNIGetObject(lArray[0]);
            if (fontDialog == null) {
                return 0L;
            }
            fontDialog.changeFont(l2, l3, l4);
        } else {
            if (l3 == OS.sel_validModesForFontPanel_) {
                FontDialog fontDialog = (FontDialog)OS.JNIGetObject(lArray[0]);
                if (fontDialog == null) {
                    return 0L;
                }
                return fontDialog.validModesForFontPanel(l2, l3, l4);
            }
            if (l3 == OS.sel_sendSelection_) {
                FileDialog fileDialog = (FileDialog)OS.JNIGetObject(lArray[0]);
                if (fileDialog == null) {
                    return 0L;
                }
                fileDialog.sendSelection(l2, l3, l4);
            } else if (l3 == OS.sel_windowWillClose_) {
                Object object = OS.JNIGetObject(lArray[0]);
                if (object instanceof FontDialog) {
                    ((FontDialog)object).windowWillClose(l2, l3, l4);
                } else if (object instanceof ColorDialog) {
                    ((ColorDialog)object).windowWillClose(l2, l3, l4);
                }
            }
        }
        return 0L;
    }

    static long dialogProc(long l2, long l3, long l4, long l5) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l2, SWT_OBJECT, lArray);
        if (lArray[0] == 0L) {
            return 0L;
        }
        if (l3 == OS.sel_panel_shouldShowFilename_) {
            FileDialog fileDialog = (FileDialog)OS.JNIGetObject(lArray[0]);
            if (fileDialog == null) {
                return 0L;
            }
            return fileDialog.panel_shouldShowFilename(l2, l3, l4, l5);
        }
        if (l3 == OS.sel_setColor_forAttribute_) {
            FontDialog fontDialog = (FontDialog)OS.JNIGetObject(lArray[0]);
            if (fontDialog == null) {
                return 0L;
            }
            fontDialog.setColor_forAttribute(l2, l3, l4, l5);
            return 0L;
        }
        return 0L;
    }

    static long dialogProc(long l2, long l3, long l4, long l5, long l6) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l2, SWT_OBJECT, lArray);
        if (lArray[0] == 0L) {
            return 0L;
        }
        if (l3 == OS.sel_panelDidEnd_returnCode_contextInfo_) {
            MessageBox messageBox = (MessageBox)OS.JNIGetObject(lArray[0]);
            if (messageBox == null) {
                return 0L;
            }
            messageBox.panelDidEnd_returnCode_contextInfo(l2, l3, l4, l5, l6);
        }
        return 0L;
    }

    static Widget LookupWidget(long l2, long l3) {
        NSView nSView;
        Widget widget = Display.GetWidget(l2);
        if (widget == null && (nSView = new NSView(l2)).isKindOfClass(OS.class_NSView)) {
            while (widget == null && (nSView = nSView.superview()) != null) {
                widget = Display.GetWidget(nSView.id);
            }
        }
        return widget;
    }

    static long windowProc(long l2, long l3) {
        if (l3 == OS.sel_cellClass) {
            long l4 = OS.objc_msgSend(OS.class_getSuperclass(l2), l3);
            long l5 = OS.objc_lookUpClass("SWTAccessible" + OS.class_getName(l4));
            return l5 != 0L ? l5 : l4;
        }
        if (!NSThread.isMainThread() && l3 == OS.sel_isOpaque) {
            return 1L;
        }
        Widget widget = Display.LookupWidget(l2, l3);
        if (widget == null) {
            return 0L;
        }
        if (l3 == OS.sel_sendSelection) {
            widget.sendSelection();
        } else if (l3 == OS.sel_dealloc) {
            widget.dealloc(l2, l3);
        } else if (l3 == OS.sel_sendDoubleSelection) {
            widget.sendDoubleSelection();
        } else if (l3 == OS.sel_sendVerticalSelection) {
            widget.sendVerticalSelection();
        } else if (l3 == OS.sel_sendHorizontalSelection) {
            widget.sendHorizontalSelection();
        } else if (l3 == OS.sel_sendSearchSelection) {
            widget.sendSearchSelection();
        } else if (l3 == OS.sel_sendCancelSelection) {
            widget.sendCancelSelection();
        } else {
            if (l3 == OS.sel_acceptsFirstResponder) {
                return widget.acceptsFirstResponder(l2, l3) ? 1L : 0L;
            }
            if (l3 == OS.sel_becomeFirstResponder) {
                return widget.becomeFirstResponder(l2, l3) ? 1L : 0L;
            }
            if (l3 == OS.sel_resignFirstResponder) {
                return widget.resignFirstResponder(l2, l3) ? 1L : 0L;
            }
            if (l3 == OS.sel_isOpaque) {
                return widget.isOpaque(l2, l3) ? 1L : 0L;
            }
            if (l3 == OS.sel_isFlipped) {
                return widget.isFlipped(l2, l3) ? 1L : 0L;
            }
            if (l3 == OS.sel_canBecomeKeyView) {
                return widget.canBecomeKeyView(l2, l3) ? 1L : 0L;
            }
            if (l3 == OS.sel_needsPanelToBecomeKey) {
                return widget.needsPanelToBecomeKey(l2, l3) ? 1L : 0L;
            }
            if (l3 == OS.sel_canBecomeKeyView) {
                return widget.canBecomeKeyView(l2, l3) ? 1L : 0L;
            }
            if (l3 == OS.sel_becomeKeyWindow) {
                widget.becomeKeyWindow(l2, l3);
            } else if (l3 != OS.sel_unmarkText) {
                if (l3 == OS.sel_validAttributesForMarkedText) {
                    return widget.validAttributesForMarkedText(l2, l3);
                }
                if (l3 == OS.sel_markedRange) {
                    NSRange nSRange = widget.markedRange(l2, l3);
                    long l6 = OS.malloc(NSRange.sizeof);
                    OS.memmove(l6, nSRange, (long)NSRange.sizeof);
                    return l6;
                }
                if (l3 == OS.sel_selectedRange) {
                    NSRange nSRange = widget.selectedRange(l2, l3);
                    long l7 = OS.malloc(NSRange.sizeof);
                    OS.memmove(l7, nSRange, (long)NSRange.sizeof);
                    return l7;
                }
                if (l3 == OS.sel_cellSize) {
                    NSSize nSSize = widget.cellSize(l2, l3);
                    long l8 = OS.malloc(NSSize.sizeof);
                    OS.memmove(l8, nSSize, (long)NSSize.sizeof);
                    return l8;
                }
                if (l3 == OS.sel_hasMarkedText) {
                    return widget.hasMarkedText(l2, l3) ? 1L : 0L;
                }
                if (l3 == OS.sel_canBecomeKeyWindow) {
                    return widget.canBecomeKeyWindow(l2, l3) ? 1L : 0L;
                }
                if (l3 == OS.sel_accessibilityActionNames) {
                    return widget.accessibilityActionNames(l2, l3);
                }
                if (l3 == OS.sel_accessibilityAttributeNames) {
                    return widget.accessibilityAttributeNames(l2, l3);
                }
                if (l3 == OS.sel_accessibilityParameterizedAttributeNames) {
                    return widget.accessibilityParameterizedAttributeNames(l2, l3);
                }
                if (l3 == OS.sel_getImageView) {
                    return widget.imageView();
                }
                if (l3 == OS.sel_mouseDownCanMoveWindow) {
                    return widget.mouseDownCanMoveWindow(l2, l3) ? 1 : 0;
                }
                if (l3 == OS.sel_accessibilityFocusedUIElement) {
                    return widget.accessibilityFocusedUIElement(l2, l3);
                }
                if (l3 == OS.sel_accessibilityIsIgnored) {
                    return widget.accessibilityIsIgnored(l2, l3) ? 1 : 0;
                }
                if (l3 == OS.sel_nextState) {
                    return widget.nextState(l2, l3);
                }
                if (l3 == OS.sel_resetCursorRects) {
                    widget.resetCursorRects(l2, l3);
                } else if (l3 == OS.sel_updateTrackingAreas) {
                    widget.updateTrackingAreas(l2, l3);
                } else if (l3 == OS.sel_viewDidMoveToWindow) {
                    widget.viewDidMoveToWindow(l2, l3);
                } else {
                    if (l3 == OS.sel_image) {
                        return widget.image(l2, l3);
                    }
                    if (l3 == OS.sel_shouldDrawInsertionPoint) {
                        return widget.shouldDrawInsertionPoint(l2, l3) ? 1L : 0L;
                    }
                    if (l3 == OS.sel_accessibleHandle) {
                        return widget.accessibleHandle();
                    }
                    if (l3 == OS.sel_clearDeferFlushing) {
                        widget.clearDeferFlushing(l2, l3);
                    }
                }
            }
        }
        return 0L;
    }

    static long windowProc(long l2, long l3, long l4) {
        if (!NSThread.isMainThread() && l3 == OS.sel_drawRect_) {
            return 0L;
        }
        if (l3 == OS.sel_changeColor_) {
            NSColorPanel nSColorPanel = NSColorPanel.sharedColorPanel();
            id id2 = nSColorPanel.delegate();
            if (id2 != null && OS.objc_msgSend_bool(id2.id, OS.sel_isKindOfClass_, OS.objc_getClass("SWTPanelDelegate"))) {
                OS.objc_msgSend(id2.id, OS.sel_changeColor_, l4);
            }
            return 0L;
        }
        if (l3 == OS.sel_timerProc_) {
            Display display = Display.getCurrent();
            if (display == null) {
                return 0L;
            }
            return display.timerProc(l2, l3, l4);
        }
        if (l3 == OS.sel_systemSettingsChanged_) {
            Display display = Display.getCurrent();
            if (display == null) {
                return 0L;
            }
            display.runSettings = true;
            return 0L;
        }
        Widget widget = Display.LookupWidget(l2, l3);
        if (widget == null) {
            return 0L;
        }
        if (l3 == OS.sel_windowWillClose_) {
            widget.windowWillClose(l2, l3, l4);
        } else if (l3 == OS.sel_drawRect_) {
            NSRect nSRect = new NSRect();
            OS.memmove(nSRect, l4, (long)NSRect.sizeof);
            widget.drawRect(l2, l3, nSRect);
        } else {
            if (l3 == OS.sel_columnAtPoint_) {
                NSPoint nSPoint = new NSPoint();
                OS.memmove(nSPoint, l4, (long)NSPoint.sizeof);
                return widget.columnAtPoint(l2, l3, nSPoint);
            }
            if (l3 == OS.sel__drawThemeProgressArea_) {
                widget._drawThemeProgressArea(l2, l3, l4);
            } else if (l3 == OS.sel_setFrameOrigin_) {
                NSPoint nSPoint = new NSPoint();
                OS.memmove(nSPoint, l4, (long)NSPoint.sizeof);
                widget.setFrameOrigin(l2, l3, nSPoint);
            } else if (l3 == OS.sel_setFrameSize_) {
                NSSize nSSize = new NSSize();
                OS.memmove(nSSize, l4, (long)NSSize.sizeof);
                widget.setFrameSize(l2, l3, nSSize);
            } else {
                if (l3 == OS.sel_hitTest_) {
                    NSPoint nSPoint = new NSPoint();
                    OS.memmove(nSPoint, l4, (long)NSPoint.sizeof);
                    return widget.hitTest(l2, l3, nSPoint);
                }
                if (l3 == OS.sel_windowShouldClose_) {
                    return widget.windowShouldClose(l2, l3, l4) ? 1L : 0L;
                }
                if (l3 == OS.sel_mouseDown_) {
                    widget.mouseDown(l2, l3, l4);
                } else if (l3 == OS.sel_keyDown_) {
                    widget.keyDown(l2, l3, l4);
                } else if (l3 == OS.sel_keyUp_) {
                    widget.keyUp(l2, l3, l4);
                } else if (l3 == OS.sel_flagsChanged_) {
                    widget.flagsChanged(l2, l3, l4);
                } else if (l3 == OS.sel_mouseUp_) {
                    widget.mouseUp(l2, l3, l4);
                } else if (l3 == OS.sel_rightMouseDown_) {
                    widget.rightMouseDown(l2, l3, l4);
                } else if (l3 == OS.sel_rightMouseDragged_) {
                    widget.rightMouseDragged(l2, l3, l4);
                } else if (l3 == OS.sel_rightMouseUp_) {
                    widget.rightMouseUp(l2, l3, l4);
                } else if (l3 == OS.sel_otherMouseDown_) {
                    widget.otherMouseDown(l2, l3, l4);
                } else if (l3 == OS.sel_otherMouseUp_) {
                    widget.otherMouseUp(l2, l3, l4);
                } else if (l3 == OS.sel_otherMouseDragged_) {
                    widget.otherMouseDragged(l2, l3, l4);
                } else if (l3 == OS.sel_mouseMoved_) {
                    widget.mouseMoved(l2, l3, l4);
                } else if (l3 == OS.sel_mouseDragged_) {
                    widget.mouseDragged(l2, l3, l4);
                } else if (l3 == OS.sel_mouseEntered_) {
                    widget.mouseEntered(l2, l3, l4);
                } else if (l3 == OS.sel_mouseExited_) {
                    widget.mouseExited(l2, l3, l4);
                } else if (l3 == OS.sel_cursorUpdate_) {
                    widget.cursorUpdate(l2, l3, l4);
                } else {
                    if (l3 == OS.sel_menuForEvent_) {
                        return widget.menuForEvent(l2, l3, l4);
                    }
                    if (l3 == OS.sel_noResponderFor_) {
                        widget.noResponderFor(l2, l3, l4);
                    } else {
                        if (l3 == OS.sel_shouldDelayWindowOrderingForEvent_) {
                            return widget.shouldDelayWindowOrderingForEvent(l2, l3, l4) ? 1L : 0L;
                        }
                        if (l3 == OS.sel_acceptsFirstMouse_) {
                            return widget.acceptsFirstMouse(l2, l3, l4) ? 1L : 0L;
                        }
                        if (l3 == OS.sel_numberOfRowsInTableView_) {
                            return widget.numberOfRowsInTableView(l2, l3, l4);
                        }
                        if (l3 == OS.sel_tableViewSelectionDidChange_) {
                            widget.tableViewSelectionDidChange(l2, l3, l4);
                        } else if (l3 == OS.sel_tableViewSelectionIsChanging_) {
                            widget.tableViewSelectionIsChanging(l2, l3, l4);
                        } else if (l3 == OS.sel_windowDidResignKey_) {
                            widget.windowDidResignKey(l2, l3, l4);
                        } else if (l3 == OS.sel_windowDidBecomeKey_) {
                            widget.windowDidBecomeKey(l2, l3, l4);
                        } else if (l3 == OS.sel_windowDidResize_) {
                            widget.windowDidResize(l2, l3, l4);
                        } else if (l3 == OS.sel_windowDidMove_) {
                            widget.windowDidMove(l2, l3, l4);
                        } else if (l3 == OS.sel_menuWillOpen_) {
                            widget.menuWillOpen(l2, l3, l4);
                        } else if (l3 == OS.sel_menuDidClose_) {
                            widget.menuDidClose(l2, l3, l4);
                        } else if (l3 == OS.sel_menuNeedsUpdate_) {
                            widget.menuNeedsUpdate(l2, l3, l4);
                        } else if (l3 == OS.sel_outlineViewSelectionDidChange_) {
                            widget.outlineViewSelectionDidChange(l2, l3, l4);
                        } else if (l3 == OS.sel_outlineViewSelectionIsChanging_) {
                            widget.outlineViewSelectionIsChanging(l2, l3, l4);
                        } else if (l3 == OS.sel_sendEvent_) {
                            widget.windowSendEvent(l2, l3, l4);
                        } else if (l3 == OS.sel_helpRequested_) {
                            widget.helpRequested(l2, l3, l4);
                        } else if (l3 == OS.sel_scrollWheel_) {
                            widget.scrollWheel(l2, l3, l4);
                        } else if (l3 == OS.sel_pageDown_) {
                            widget.pageDown(l2, l3, l4);
                        } else if (l3 == OS.sel_pageUp_) {
                            widget.pageUp(l2, l3, l4);
                        } else if (l3 == OS.sel_textViewDidChangeSelection_) {
                            widget.textViewDidChangeSelection(l2, l3, l4);
                        } else if (l3 == OS.sel_textDidChange_) {
                            widget.textDidChange(l2, l3, l4);
                        } else if (l3 == OS.sel_textDidEndEditing_) {
                            widget.textDidEndEditing(l2, l3, l4);
                        } else {
                            if (l3 == OS.sel_attributedSubstringFromRange_) {
                                return widget.attributedSubstringFromRange(l2, l3, l4);
                            }
                            if (l3 == OS.sel_characterIndexForPoint_) {
                                return widget.characterIndexForPoint(l2, l3, l4);
                            }
                            if (l3 == OS.sel_firstRectForCharacterRange_) {
                                NSRect nSRect = widget.firstRectForCharacterRange(l2, l3, l4);
                                long l5 = OS.malloc(NSRect.sizeof);
                                OS.memmove(l5, nSRect, (long)NSRect.sizeof);
                                return l5;
                            }
                            if (l3 == OS.sel_insertText_) {
                                return widget.insertText(l2, l3, l4) ? 1L : 0L;
                            }
                            if (l3 == OS.sel_doCommandBySelector_) {
                                widget.doCommandBySelector(l2, l3, l4);
                            } else if (l3 == OS.sel_highlightSelectionInClipRect_) {
                                widget.highlightSelectionInClipRect(l2, l3, l4);
                            } else if (l3 == OS.sel_reflectScrolledClipView_) {
                                widget.reflectScrolledClipView(l2, l3, l4);
                            } else {
                                if (l3 == OS.sel_accessibilityHitTest_) {
                                    NSPoint nSPoint = new NSPoint();
                                    OS.memmove(nSPoint, l4, (long)NSPoint.sizeof);
                                    return widget.accessibilityHitTest(l2, l3, nSPoint);
                                }
                                if (l3 == OS.sel_accessibilityAttributeValue_) {
                                    return widget.accessibilityAttributeValue(l2, l3, l4);
                                }
                                if (l3 == OS.sel_accessibilityPerformAction_) {
                                    widget.accessibilityPerformAction(l2, l3, l4);
                                } else {
                                    if (l3 == OS.sel_accessibilityActionDescription_) {
                                        return widget.accessibilityActionDescription(l2, l3, l4);
                                    }
                                    if (l3 == OS.sel_accessibilityIsAttributeSettable_) {
                                        return widget.accessibilityIsAttributeSettable(l2, l3, l4) ? 1L : 0L;
                                    }
                                    if (l3 == OS.sel_makeFirstResponder_) {
                                        return widget.makeFirstResponder(l2, l3, l4) ? 1L : 0L;
                                    }
                                    if (l3 == OS.sel_tableViewColumnDidMove_) {
                                        widget.tableViewColumnDidMove(l2, l3, l4);
                                    } else if (l3 == OS.sel_tableViewColumnDidResize_) {
                                        widget.tableViewColumnDidResize(l2, l3, l4);
                                    } else if (l3 == OS.sel_outlineViewColumnDidMove_) {
                                        widget.outlineViewColumnDidMove(l2, l3, l4);
                                    } else if (l3 == OS.sel_outlineViewColumnDidResize_) {
                                        widget.outlineViewColumnDidResize(l2, l3, l4);
                                    } else if (l3 == OS.sel_setNeedsDisplay_) {
                                        widget.setNeedsDisplay(l2, l3, l4 != 0L);
                                    } else if (l3 == OS.sel_setNeedsDisplayInRect_) {
                                        widget.setNeedsDisplayInRect(l2, l3, l4);
                                    } else if (l3 == OS.sel_setImage_) {
                                        widget.setImage(l2, l3, l4);
                                    } else {
                                        if (l3 == OS.sel_headerRectOfColumn_) {
                                            NSRect nSRect = widget.headerRectOfColumn(l2, l3, l4);
                                            long l6 = OS.malloc(NSRect.sizeof);
                                            OS.memmove(l6, nSRect, (long)NSRect.sizeof);
                                            return l6;
                                        }
                                        if (l3 == OS.sel_imageRectForBounds_) {
                                            NSRect nSRect = new NSRect();
                                            OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                                            nSRect = widget.imageRectForBounds(l2, l3, nSRect);
                                            long l7 = OS.malloc(NSRect.sizeof);
                                            OS.memmove(l7, nSRect, (long)NSRect.sizeof);
                                            return l7;
                                        }
                                        if (l3 == OS.sel_titleRectForBounds_) {
                                            NSRect nSRect = new NSRect();
                                            OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                                            nSRect = widget.titleRectForBounds(l2, l3, nSRect);
                                            long l8 = OS.malloc(NSRect.sizeof);
                                            OS.memmove(l8, nSRect, (long)NSRect.sizeof);
                                            return l8;
                                        }
                                        if (l3 == OS.sel_cellSizeForBounds_) {
                                            NSRect nSRect = new NSRect();
                                            OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                                            NSSize nSSize = widget.cellSizeForBounds(l2, l3, nSRect);
                                            long l9 = OS.malloc(NSSize.sizeof);
                                            OS.memmove(l9, nSSize, (long)NSSize.sizeof);
                                            return l9;
                                        }
                                        if (l3 == OS.sel_setObjectValue_) {
                                            widget.setObjectValue(l2, l3, l4);
                                        } else if (l3 == OS.sel_updateOpenGLContext_) {
                                            widget.updateOpenGLContext(l2, l3, l4);
                                        } else {
                                            if (l3 == OS.sel_sizeOfLabel_) {
                                                NSSize nSSize = widget.sizeOfLabel(l2, l3, l4 != 0L);
                                                long l10 = OS.malloc(NSSize.sizeof);
                                                OS.memmove(l10, nSSize, (long)NSSize.sizeof);
                                                return l10;
                                            }
                                            if (l3 == OS.sel_comboBoxSelectionDidChange_) {
                                                widget.comboBoxSelectionDidChange(l2, l3, l4);
                                            } else if (l3 == OS.sel_comboBoxWillDismiss_) {
                                                widget.comboBoxWillDismiss(l2, l3, l4);
                                            } else if (l3 == OS.sel_comboBoxWillPopUp_) {
                                                widget.comboBoxWillPopUp(l2, l3, l4);
                                            } else if (l3 == OS.sel_drawViewBackgroundInRect_) {
                                                NSRect nSRect = new NSRect();
                                                OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                                                widget.drawViewBackgroundInRect(l2, l3, nSRect);
                                            } else if (l3 == OS.sel_drawBackgroundInClipRect_) {
                                                NSRect nSRect = new NSRect();
                                                OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                                                widget.drawBackgroundInClipRect(l2, l3, nSRect);
                                            } else if (l3 == OS.sel_windowDidMiniaturize_) {
                                                widget.windowDidMiniturize(l2, l3, l4);
                                            } else if (l3 == OS.sel_windowDidDeminiaturize_) {
                                                widget.windowDidDeminiturize(l2, l3, l4);
                                            } else if (l3 == OS.sel_touchesBeganWithEvent_) {
                                                widget.touchesBeganWithEvent(l2, l3, l4);
                                            } else if (l3 == OS.sel_touchesMovedWithEvent_) {
                                                widget.touchesMovedWithEvent(l2, l3, l4);
                                            } else if (l3 == OS.sel_touchesEndedWithEvent_) {
                                                widget.touchesEndedWithEvent(l2, l3, l4);
                                            } else if (l3 == OS.sel_touchesCancelledWithEvent_) {
                                                widget.touchesCancelledWithEvent(l2, l3, l4);
                                            } else if (l3 == OS.sel_beginGestureWithEvent_) {
                                                widget.beginGestureWithEvent(l2, l3, l4);
                                            } else if (l3 == OS.sel_endGestureWithEvent_) {
                                                widget.endGestureWithEvent(l2, l3, l4);
                                            } else if (l3 == OS.sel_swipeWithEvent_) {
                                                widget.swipeWithEvent(l2, l3, l4);
                                            } else if (l3 == OS.sel_magnifyWithEvent_) {
                                                widget.magnifyWithEvent(l2, l3, l4);
                                            } else if (l3 == OS.sel_rotateWithEvent_) {
                                                widget.rotateWithEvent(l2, l3, l4);
                                            } else {
                                                if (l3 == OS.sel_toolbarAllowedItemIdentifiers_) {
                                                    return widget.toolbarAllowedItemIdentifiers(l2, l3, l4);
                                                }
                                                if (l3 == OS.sel_toolbarDefaultItemIdentifiers_) {
                                                    return widget.toolbarDefaultItemIdentifiers(l2, l3, l4);
                                                }
                                                if (l3 == OS.sel_toolbarSelectableItemIdentifiers_) {
                                                    return widget.toolbarSelectableItemIdentifiers(l2, l3, l4);
                                                }
                                                if (l3 == OS.sel_validateMenuItem_) {
                                                    return widget.validateMenuItem(l2, l3, l4) ? 1 : 0;
                                                }
                                                if (l3 == OS.sel_readSelectionFromPasteboard_) {
                                                    return widget.readSelectionFromPasteboard(l2, l3, l4) ? 1 : 0;
                                                }
                                                if (l3 == OS.sel_viewWillMoveToWindow_) {
                                                    widget.viewWillMoveToWindow(l2, l3, l4);
                                                } else if (l3 == OS.sel_cancelOperation_) {
                                                    widget.cancelOperation(l2, l3, l4);
                                                } else if (l3 == OS.sel_setShouldExpandItem_) {
                                                    widget.setShouldExpandItem(l2, l3, l4 != 0L);
                                                } else if (l3 == OS.sel_setShouldScrollClipView_) {
                                                    widget.setShouldScrollClipView(l2, l3, l4 != 0L);
                                                } else if (l3 == OS.sel_deselectRow_) {
                                                    widget.deselectRow(l2, l3, l4);
                                                } else if (l3 == OS.sel_deselectAll_) {
                                                    widget.deselectAll(l2, l3, l4);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return 0L;
    }

    static long windowProc(long l2, long l3, long l4, long l5) {
        Widget widget = Display.LookupWidget(l2, l3);
        if (widget == null) {
            return 0L;
        }
        if (l3 == OS.sel_tabView_willSelectTabViewItem_) {
            widget.tabView_willSelectTabViewItem(l2, l3, l4, l5);
        } else if (l3 == OS.sel_tabView_didSelectTabViewItem_) {
            widget.tabView_didSelectTabViewItem(l2, l3, l4, l5);
        } else {
            if (l3 == OS.sel_outlineView_isItemExpandable_) {
                return widget.outlineView_isItemExpandable(l2, l3, l4, l5) ? 1L : 0L;
            }
            if (l3 == OS.sel_outlineView_numberOfChildrenOfItem_) {
                return widget.outlineView_numberOfChildrenOfItem(l2, l3, l4, l5);
            }
            if (l3 == OS.sel_menu_willHighlightItem_) {
                widget.menu_willHighlightItem(l2, l3, l4, l5);
            } else if (l3 == OS.sel_setMarkedText_selectedRange_) {
                widget.setMarkedText_selectedRange(l2, l3, l4, l5);
            } else if (l3 == OS.sel_drawInteriorWithFrame_inView_) {
                NSRect nSRect = new NSRect();
                OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                widget.drawInteriorWithFrame_inView(l2, l3, nSRect, l5);
            } else if (l3 == OS.sel_drawWithExpansionFrame_inView_) {
                NSRect nSRect = new NSRect();
                OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                widget.drawWithExpansionFrame_inView(l2, l3, nSRect, l5);
            } else {
                if (l3 == OS.sel_accessibilityAttributeValue_forParameter_) {
                    return widget.accessibilityAttributeValue_forParameter(l2, l3, l4, l5);
                }
                if (l3 == OS.sel_tableView_didClickTableColumn_) {
                    widget.tableView_didClickTableColumn(l2, l3, l4, l5);
                } else if (l3 == OS.sel_outlineView_didClickTableColumn_) {
                    widget.outlineView_didClickTableColumn(l2, l3, l4, l5);
                } else {
                    if (l3 == OS.sel_shouldChangeTextInRange_replacementString_) {
                        return widget.shouldChangeTextInRange_replacementString(l2, l3, l4, l5) ? 1L : 0L;
                    }
                    if (l3 == OS.sel_canDragRowsWithIndexes_atPoint_) {
                        NSPoint nSPoint = new NSPoint();
                        OS.memmove(nSPoint, l5, (long)NSPoint.sizeof);
                        return widget.canDragRowsWithIndexes_atPoint(l2, l3, l4, nSPoint) ? 1L : 0L;
                    }
                    if (l3 == OS.sel_expandItem_expandChildren_) {
                        widget.expandItem_expandChildren(l2, l3, l4, l5 != 0L);
                    } else if (l3 == OS.sel_collapseItem_collapseChildren_) {
                        widget.collapseItem_collapseChildren(l2, l3, l4, l5 != 0L);
                    } else {
                        if (l3 == OS.sel_expansionFrameWithFrame_inView_) {
                            NSRect nSRect = new NSRect();
                            OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                            nSRect = widget.expansionFrameWithFrame_inView(l2, l3, nSRect, l5);
                            long l6 = OS.malloc(NSRect.sizeof);
                            OS.memmove(l6, nSRect, (long)NSRect.sizeof);
                            return l6;
                        }
                        if (l3 == OS.sel_focusRingMaskBoundsForFrame_inView_) {
                            NSRect nSRect = new NSRect();
                            OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                            nSRect = widget.focusRingMaskBoundsForFrame(l2, l3, nSRect, l5);
                            long l7 = OS.malloc(NSRect.sizeof);
                            OS.memmove(l7, nSRect, (long)NSRect.sizeof);
                            return l7;
                        }
                        if (l3 == OS.sel_drawLabel_inRect_) {
                            NSRect nSRect = new NSRect();
                            OS.memmove(nSRect, l5, (long)NSRect.sizeof);
                            widget.drawLabelInRect(l2, l3, l4 == 1L, nSRect);
                        } else if (l3 == OS.sel_scrollClipView_toPoint_) {
                            NSPoint nSPoint = new NSPoint();
                            OS.memmove(nSPoint, l5, (long)NSPoint.sizeof);
                            widget.scrollClipViewToPoint(l2, l3, l4, nSPoint);
                        } else if (l3 == OS.sel_accessibilitySetValue_forAttribute_) {
                            widget.accessibilitySetValue_forAttribute(l2, l3, l4, l5);
                        } else {
                            if (l3 == OS.sel_validRequestorForSendType_returnType_) {
                                return widget.validRequestorForSendType(l2, l3, l4, l5);
                            }
                            if (l3 == OS.sel_writeSelectionToPasteboard_types_) {
                                return widget.writeSelectionToPasteboard(l2, l3, l4, l5) ? 1 : 0;
                            }
                            if (l3 == OS.sel_outlineView_shouldExpandItem_) {
                                return widget.outlineView_shouldExpandItem_item(l2, l3, l4, l5) ? 1 : 0;
                            }
                            if (l3 == OS.sel_selectRowIndexes_byExtendingSelection_) {
                                widget.selectRowIndexes_byExtendingSelection(l2, l3, l4, l5 != 0L);
                            }
                        }
                    }
                }
            }
        }
        return 0L;
    }

    static long windowProc(long l2, long l3, long l4, long l5, long l6) {
        Widget widget = Display.LookupWidget(l2, l3);
        if (widget == null) {
            return 0L;
        }
        if (l3 == OS.sel_tableView_objectValueForTableColumn_row_) {
            return widget.tableView_objectValueForTableColumn_row(l2, l3, l4, l5, l6);
        }
        if (l3 == OS.sel_tableView_shouldReorderColumn_toColumn_) {
            return widget.tableView_shouldReorderColumn_toColumn(l2, l3, l4, l5, l6) ? 1L : 0L;
        }
        if (l3 == OS.sel_tableView_shouldEditTableColumn_row_) {
            return widget.tableView_shouldEditTableColumn_row(l2, l3, l4, l5, l6) ? 1L : 0L;
        }
        if (l3 == OS.sel_outlineView_shouldReorderColumn_toColumn_) {
            return widget.outlineView_shouldReorderColumn_toColumn(l2, l3, l4, l5, l6) ? 1L : 0L;
        }
        if (l3 == OS.sel_outlineView_shouldEditTableColumn_item_) {
            return widget.outlineView_shouldEditTableColumn_row(l2, l3, l4, l5, l6) ? 1L : 0L;
        }
        if (l3 == OS.sel_textView_clickedOnLink_atIndex_) {
            return widget.textView_clickOnLink_atIndex(l2, l3, l4, l5, l6) ? 1L : 0L;
        }
        if (l3 == OS.sel_outlineView_child_ofItem_) {
            return widget.outlineView_child_ofItem(l2, l3, l4, l5, l6);
        }
        if (l3 == OS.sel_outlineView_objectValueForTableColumn_byItem_) {
            return widget.outlineView_objectValueForTableColumn_byItem(l2, l3, l4, l5, l6);
        }
        if (l3 == OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_) {
            NSRange nSRange = widget.textView_willChangeSelectionFromCharacterRange_toCharacterRange(l2, l3, l4, l5, l6);
            long l7 = OS.malloc(NSRange.sizeof);
            OS.memmove(l7, nSRange, (long)NSRange.sizeof);
            return l7;
        }
        if (l3 == OS.sel_dragSelectionWithEvent_offset_slideBack_) {
            NSSize nSSize = new NSSize();
            OS.memmove(nSSize, l4, (long)NSSize.sizeof);
            return widget.dragSelectionWithEvent(l2, l3, l4, l5, l6) ? 1 : 0;
        }
        if (l3 == OS.sel_drawImage_withFrame_inView_) {
            NSRect nSRect = new NSRect();
            OS.memmove(nSRect, l5, (long)NSRect.sizeof);
            widget.drawImageWithFrameInView(l2, l3, l4, nSRect, l6);
        } else {
            if (l3 == OS.sel_drawTitle_withFrame_inView_) {
                NSRect nSRect = new NSRect();
                OS.memmove(nSRect, l5, (long)NSRect.sizeof);
                nSRect = widget.drawTitleWithFrameInView(l2, l3, l4, nSRect, l6);
                long l8 = OS.malloc(NSRect.sizeof);
                OS.memmove(l8, nSRect, (long)NSRect.sizeof);
                return l8;
            }
            if (l3 == OS.sel_hitTestForEvent_inRect_ofView_) {
                NSRect nSRect = new NSRect();
                OS.memmove(nSRect, l5, (long)NSRect.sizeof);
                return widget.hitTestForEvent(l2, l3, l4, nSRect, l6);
            }
            if (l3 == OS.sel_tableView_writeRowsWithIndexes_toPasteboard_) {
                return widget.tableView_writeRowsWithIndexes_toPasteboard(l2, l3, l4, l5, l6) ? 1 : 0;
            }
            if (l3 == OS.sel_outlineView_writeItems_toPasteboard_) {
                return widget.outlineView_writeItems_toPasteboard(l2, l3, l4, l5, l6) ? 1 : 0;
            }
            if (l3 == OS.sel_toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar_) {
                return widget.toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(l2, l3, l4, l5, l6 != 0L);
            }
        }
        return 0L;
    }

    static long windowProc(long l2, long l3, long l4, long l5, long l6, long l7) {
        Widget widget = Display.LookupWidget(l2, l3);
        if (widget == null) {
            return 0L;
        }
        if (l3 == OS.sel_tableView_willDisplayCell_forTableColumn_row_) {
            widget.tableView_willDisplayCell_forTableColumn_row(l2, l3, l4, l5, l6, l7);
        } else if (l3 == OS.sel_outlineView_willDisplayCell_forTableColumn_item_) {
            widget.outlineView_willDisplayCell_forTableColumn_item(l2, l3, l4, l5, l6, l7);
        } else if (l3 == OS.sel_outlineView_setObjectValue_forTableColumn_byItem_) {
            widget.outlineView_setObjectValue_forTableColumn_byItem(l2, l3, l4, l5, l6, l7);
        } else if (l3 == OS.sel_tableView_setObjectValue_forTableColumn_row_) {
            widget.tableView_setObjectValue_forTableColumn_row(l2, l3, l4, l5, l6, l7);
        } else {
            if (l3 == OS.sel_view_stringForToolTip_point_userData_) {
                return widget.view_stringForToolTip_point_userData(l2, l3, l4, l5, l6, l7);
            }
            if (l3 == OS.sel_tableView_shouldTrackCell_forTableColumn_row_) {
                return widget.tableView_shouldTrackCell_forTableColumn_row(l2, l3, l4, l5, l6, l7) ? 1L : 0L;
            }
            if (l3 == OS.sel_outlineView_shouldTrackCell_forTableColumn_item_) {
                return widget.outlineView_shouldTrackCell_forTableColumn_item(l2, l3, l4, l5, l6, l7) ? 1L : 0L;
            }
        }
        return 0L;
    }

    static {
        KeyTable = new int[][]{{58, 65536}, {56, 131072}, {59, 262144}, {55, 0x400000}, {61, 65536}, {62, 262144}, {60, 131072}, {54, 0x400000}, {126, 0x1000001}, {125, 0x1000002}, {123, 0x1000003}, {124, 0x1000004}, {116, 0x1000005}, {121, 0x1000006}, {115, 0x1000007}, {119, 0x1000008}, {51, 8}, {36, 13}, {117, 127}, {53, 27}, {76, 10}, {48, 9}, {122, 0x100000A}, {120, 0x100000B}, {99, 0x100000C}, {118, 0x100000D}, {96, 0x100000E}, {97, 0x100000F}, {98, 0x1000010}, {100, 0x1000011}, {101, 0x1000012}, {109, 0x1000013}, {103, 0x1000014}, {111, 0x1000015}, {105, 0x1000016}, {107, 0x1000017}, {113, 0x1000018}, {106, 0x1000019}, {64, 0x100001A}, {79, 0x100001B}, {80, 0x100001C}, {67, 16777258}, {69, 16777259}, {76, 0x1000050}, {78, 16777261}, {65, 16777262}, {75, 16777263}, {82, 0x1000030}, {83, 0x1000031}, {84, 16777266}, {85, 0x1000033}, {86, 16777268}, {87, 16777269}, {88, 16777270}, {89, 16777271}, {91, 16777272}, {92, 16777273}, {81, 16777277}, {57, 16777298}, {71, 16777299}, {114, 0x1000051}};
        APP_VERSION = "";
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
        SWT_EMBED_FRAMES = new byte[]{83, 87, 84, 95, 69, 77, 66, 69, 68, 95, 70, 82, 65, 77, 69, 83, 0};
        SWT_IMAGE = new byte[]{83, 87, 84, 95, 73, 77, 65, 71, 69, 0};
        SWT_ROW = new byte[]{83, 87, 84, 95, 82, 79, 87, 0};
        SWT_COLUMN = new byte[]{83, 87, 84, 95, 67, 79, 76, 85, 77, 78, 0};
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Display.setDevice(display);
            }
        };
    }
}

