/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CoolBar
extends Composite {
    CoolItem[][] items = new CoolItem[0][0];
    CoolItem[] originalItems = new CoolItem[0];
    Cursor hoverCursor;
    Cursor dragCursor;
    Cursor cursor;
    CoolItem dragging = null;
    int mouseXOffset;
    int itemXOffset;
    boolean isLocked = false;
    boolean inDispose = false;
    static final int ROW_SPACING = 2;
    static final int CLICK_DISTANCE = 3;
    static final int DEFAULT_COOLBAR_WIDTH = 0;
    static final int DEFAULT_COOLBAR_HEIGHT = 0;

    public CoolBar(Composite composite, int n2) {
        super(composite, CoolBar.checkStyle(n2));
        if ((n2 & 0x200) != 0) {
            this.style |= 0x200;
            this.hoverCursor = new Cursor(this.display, 7);
        } else {
            this.style |= 0x100;
            this.hoverCursor = new Cursor(this.display, 9);
        }
        this.dragCursor = new Cursor(this.display, 5);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CoolBar.this.onDispose(event);
                        break;
                    }
                    case 3: {
                        CoolBar.this.onMouseDown(event);
                        break;
                    }
                    case 7: {
                        CoolBar.this.onMouseExit();
                        break;
                    }
                    case 5: {
                        CoolBar.this.onMouseMove(event);
                        break;
                    }
                    case 4: {
                        CoolBar.this.onMouseUp(event);
                        break;
                    }
                    case 8: {
                        CoolBar.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 9: {
                        CoolBar.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CoolBar.this.onResize();
                    }
                }
            }
        };
        int[] nArray = new int[]{12, 3, 7, 5, 4, 8, 9, 11};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.addListener(nArray[i2], listener);
        }
    }

    static int checkStyle(int n2) {
        return ((n2 |= 0x80000) | 0x100000) & 0xFFFFFCFF;
    }

    void _setCursor(Cursor cursor) {
        if (this.cursor != null) {
            return;
        }
        super.setCursor(cursor);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        this.wrapItems((this.style & 0x200) != 0 ? n3 : n2);
        boolean bl3 = (this.style & 0x800000) != 0;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            int n6 = 0;
            int n7 = 0;
            for (int i3 = 0; i3 < this.items[i2].length; ++i3) {
                CoolItem coolItem = this.items[i2][i3];
                n6 += coolItem.preferredWidth;
                n7 = Math.max(n7, coolItem.preferredHeight);
            }
            n5 += n7;
            if (!bl3 && i2 > 0) {
                n5 += 2;
            }
            n4 = Math.max(n4, n6);
        }
        this.wrapItems(this.getWidth());
        if (n4 == 0) {
            n4 = 0;
        }
        if (n5 == 0) {
            n5 = 0;
        }
        Point point = this.fixPoint(n4, n5);
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    CoolItem getGrabbedItem(int n2, int n3) {
        block0: for (int i2 = 0; i2 < this.items.length; ++i2) {
            for (int i3 = 0; i3 < this.items[i2].length; ++i3) {
                CoolItem coolItem = this.items[i2][i3];
                Rectangle rectangle = coolItem.internalGetBounds();
                rectangle.width = 10;
                if (rectangle.x > n2) continue block0;
                if (rectangle.y > n3) {
                    return null;
                }
                if (!rectangle.contains(n2, n3)) continue;
                return coolItem;
            }
        }
        return null;
    }

    public CoolItem getItem(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(6);
        }
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (this.items[i2].length > n2) {
                return this.items[i2][n2];
            }
            n2 -= this.items[i2].length;
        }
        this.error(6);
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.originalItems.length;
    }

    public CoolItem[] getItems() {
        this.checkWidget();
        CoolItem[] coolItemArray = new CoolItem[this.getItemCount()];
        int n2 = 0;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            System.arraycopy(this.items[i2], 0, coolItemArray, n2, this.items[i2].length);
            n2 += this.items[i2].length;
        }
        return coolItemArray;
    }

    Point findItem(CoolItem coolItem) {
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            for (int i3 = 0; i3 < this.items[i2].length; ++i3) {
                if (!this.items[i2][i3].equals(coolItem)) continue;
                return new Point(i3, i2);
            }
        }
        return new Point(-1, -1);
    }

    void fixEvent(Event event) {
        if ((this.style & 0x200) != 0) {
            int n2 = event.x;
            event.x = event.y;
            event.y = n2;
        }
    }

    Rectangle fixRectangle(int n2, int n3, int n4, int n5) {
        if ((this.style & 0x200) != 0) {
            return new Rectangle(n3, n2, n5, n4);
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    Point fixPoint(int n2, int n3) {
        if ((this.style & 0x200) != 0) {
            return new Point(n3, n2);
        }
        return new Point(n2, n3);
    }

    public int indexOf(CoolItem coolItem) {
        this.checkWidget();
        if (coolItem == null) {
            this.error(4);
        }
        if (coolItem.isDisposed()) {
            this.error(5);
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            for (int i3 = 0; i3 < this.items[i2].length; ++i3) {
                if (this.items[i2][i3].equals(coolItem)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    boolean insertItemIntoRow(CoolItem coolItem, int n2, int n3) {
        int n4;
        if (n2 < 0 || n2 >= this.items.length) {
            boolean bl2 = n2 >= this.items.length;
            CoolItem[][] coolItemArrayArray = new CoolItem[this.items.length + 1][];
            System.arraycopy(this.items, 0, coolItemArrayArray, bl2 ? 0 : 1, this.items.length);
            int n5 = bl2 ? this.items.length : 0;
            coolItemArrayArray[n5] = new CoolItem[1];
            coolItemArrayArray[n5][0] = coolItem;
            this.items = coolItemArrayArray;
            coolItem.wrap = true;
            return true;
        }
        int n6 = this.getWidth();
        Rectangle rectangle = this.items[n2][0].internalGetBounds();
        int n7 = rectangle.y;
        int n8 = rectangle.height;
        int n9 = Math.max(0, Math.abs(n3 - this.toDisplay((Point)new Point((int)0, (int)0)).x));
        for (n4 = 0; n4 < this.items[n2].length && n9 >= this.items[n2][n4].internalGetBounds().x; ++n4) {
        }
        if (n4 == 0) {
            coolItem.wrap = true;
            this.items[n2][0].wrap = false;
        }
        int n10 = this.items[n2].length;
        CoolItem[] coolItemArray = new CoolItem[n10 + 1];
        System.arraycopy(this.items[n2], 0, coolItemArray, 0, n4);
        coolItemArray[n4] = coolItem;
        System.arraycopy(this.items[n2], n4, coolItemArray, n4 + 1, n10 - n4);
        this.items[n2] = coolItemArray;
        if (n4 > 0) {
            CoolItem coolItem2 = this.items[n2][n4 - 1];
            Rectangle rectangle2 = coolItem2.internalGetBounds();
            int n11 = n9 - rectangle2.x;
            if (n11 < coolItem2.internalGetMinimumWidth()) {
                n9 += coolItem2.internalGetMinimumWidth() - n11;
                n11 = coolItem2.internalGetMinimumWidth();
            }
            coolItem2.setBounds(rectangle2.x, rectangle2.y, n11, rectangle2.height);
            coolItem2.requestedWidth = n11;
        }
        int n12 = 0;
        int n13 = coolItem.preferredHeight;
        if (n4 < this.items[n2].length - 1) {
            CoolItem coolItem3;
            n12 = coolItem3.internalGetBounds().x - n9;
            coolItem3 = this.items[n2][n4 + 1];
            if (n12 < coolItem3.internalGetMinimumWidth()) {
                this.moveRight(coolItem3, coolItem3.internalGetMinimumWidth() - n12);
                n12 = coolItem3.internalGetBounds().x - n9;
            }
            coolItem.setBounds(n9, n7, n12, n13);
            if (n12 < coolItem.internalGetMinimumWidth()) {
                this.moveLeft(coolItem, coolItem.internalGetMinimumWidth() - n12);
            }
        } else {
            n12 = Math.max(coolItem.internalGetMinimumWidth(), n6 - n9);
            coolItem.setBounds(n9, n7, n12, n13);
            if (n9 + n12 > n6) {
                this.moveLeft(coolItem, n9 + n12 - n6);
            }
        }
        rectangle = coolItem.internalGetBounds();
        coolItem.requestedWidth = rectangle.width;
        this.internalRedraw(rectangle.x, rectangle.y, coolItem.internalGetMinimumWidth(), rectangle.height);
        return n13 > n8;
    }

    void internalRedraw(int n2, int n3, int n4, int n5) {
        if ((this.style & 0x200) != 0) {
            this.redraw(n3, n2, n5, n4, false);
        } else {
            this.redraw(n2, n3, n4, n5, false);
        }
    }

    void createItem(CoolItem coolItem, int n2) {
        int n3;
        int n4 = this.getItemCount();
        int n5 = 0;
        if (0 > n2 || n2 > n4) {
            this.error(6);
        }
        if (this.items.length == 0) {
            this.items = new CoolItem[1][1];
            this.items[0][0] = coolItem;
        } else {
            n3 = n2;
            if (n2 < n4) {
                while (n3 > this.items[n5].length) {
                    n3 -= this.items[n5].length;
                    ++n5;
                }
            } else {
                n5 = this.items.length - 1;
                n3 = this.items[n5].length;
            }
            int n6 = this.items[n5].length - 1;
            CoolItem coolItem2 = this.items[n5][n6];
            if (coolItem2.ideal) {
                Rectangle rectangle = coolItem2.internalGetBounds();
                rectangle.width = coolItem2.preferredWidth;
                rectangle.height = coolItem2.preferredHeight;
                coolItem2.requestedWidth = coolItem2.preferredWidth;
                coolItem2.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (n3 == 0) {
                coolItem.wrap = true;
                this.items[n5][0].wrap = false;
            }
            int n7 = this.items[n5].length;
            CoolItem[] coolItemArray = new CoolItem[n7 + 1];
            System.arraycopy(this.items[n5], 0, coolItemArray, 0, n3);
            coolItemArray[n3] = coolItem;
            System.arraycopy(this.items[n5], n3, coolItemArray, n3 + 1, n7 - n3);
            this.items[n5] = coolItemArray;
        }
        coolItem.requestedWidth = 10;
        n3 = this.originalItems.length;
        CoolItem[] coolItemArray = new CoolItem[n3 + 1];
        System.arraycopy(this.originalItems, 0, coolItemArray, 0, n2);
        System.arraycopy(this.originalItems, n2, coolItemArray, n2 + 1, n3 - n2);
        coolItemArray[n2] = coolItem;
        this.originalItems = coolItemArray;
        this.layoutItems();
    }

    void destroyItem(CoolItem coolItem) {
        int n2;
        if (this.inDispose) {
            return;
        }
        int n3 = this.findItem((CoolItem)coolItem).y;
        if (n3 == -1) {
            return;
        }
        Rectangle rectangle = coolItem.internalGetBounds();
        this.removeItemFromRow(coolItem, n3, true);
        for (n2 = 0; n2 < this.originalItems.length && this.originalItems[n2] != coolItem; ++n2) {
        }
        int n4 = this.originalItems.length - 1;
        CoolItem[] coolItemArray = new CoolItem[n4];
        System.arraycopy(this.originalItems, 0, coolItemArray, 0, n2);
        System.arraycopy(this.originalItems, n2 + 1, coolItemArray, n2, n4 - n2);
        this.originalItems = coolItemArray;
        this.internalRedraw(rectangle.x, rectangle.y, 10, rectangle.height);
        this.relayout();
    }

    void moveDown(CoolItem coolItem, int n2) {
        int n3 = this.findItem((CoolItem)coolItem).y;
        if (this.items[n3].length == 1 && n3 == this.items.length - 1) {
            return;
        }
        int n4 = this.items[n3].length == 1 ? n3 : n3 + 1;
        boolean bl2 = this.removeItemFromRow(coolItem, n3, false);
        Rectangle rectangle = coolItem.internalGetBounds();
        this.internalRedraw(rectangle.x, rectangle.y, 10, rectangle.height);
        if (bl2 |= this.insertItemIntoRow(coolItem, n4, n2)) {
            this.relayout();
        } else {
            this.layoutItems();
        }
    }

    void moveLeft(CoolItem coolItem, int n2) {
        int n3;
        int n4;
        Point point = this.findItem(coolItem);
        int n5 = point.y;
        int n6 = point.x;
        if (n6 == 0) {
            return;
        }
        Rectangle rectangle = coolItem.internalGetBounds();
        int n7 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            n7 += this.items[n5][n4].internalGetMinimumWidth();
        }
        n4 = Math.max(n7, rectangle.x - n2);
        CoolItem coolItem2 = this.items[n5][n6 - 1];
        Rectangle rectangle2 = coolItem2.internalGetBounds();
        if (rectangle2.x + coolItem2.internalGetMinimumWidth() > n4) {
            n3 = rectangle2.x + coolItem2.internalGetMinimumWidth() - n4;
            this.moveLeft(coolItem2, n3);
            rectangle2 = coolItem2.internalGetBounds();
        }
        n3 = Math.max(coolItem2.internalGetMinimumWidth(), rectangle2.width - n2);
        coolItem2.setBounds(rectangle2.x, rectangle2.y, n3, rectangle2.height);
        coolItem2.requestedWidth = n3;
        int n8 = rectangle.width + (rectangle.x - n4);
        coolItem.setBounds(n4, rectangle.y, n8, rectangle.height);
        coolItem.requestedWidth = n8;
        int n9 = rectangle.x - n4 + 10;
        if (n9 > 10) {
            this.internalRedraw(n4, rectangle.y, n9, rectangle.height);
        }
    }

    void moveRight(CoolItem coolItem, int n2) {
        int n3;
        Rectangle rectangle;
        CoolItem coolItem2;
        int n4;
        Point point = this.findItem(coolItem);
        int n5 = point.y;
        int n6 = point.x;
        if (n6 == 0) {
            return;
        }
        Rectangle rectangle2 = coolItem.internalGetBounds();
        int n7 = 0;
        for (n4 = n6; n4 < this.items[n5].length; ++n4) {
            n7 += this.items[n5][n4].internalGetMinimumWidth();
        }
        n4 = this.getWidth() - n7;
        int n8 = Math.min(n4, rectangle2.x + n2);
        int n9 = 0;
        if (n6 + 1 == this.items[n5].length) {
            n9 = this.getWidth() - n8;
        } else {
            coolItem2 = this.items[n5][n6 + 1];
            rectangle = coolItem2.internalGetBounds();
            if (n8 + coolItem.internalGetMinimumWidth() > rectangle.x) {
                n3 = n8 + coolItem.internalGetMinimumWidth() - rectangle.x;
                this.moveRight(coolItem2, n3);
                rectangle = coolItem2.internalGetBounds();
            }
            n9 = rectangle.x - n8;
        }
        coolItem.setBounds(n8, rectangle2.y, n9, rectangle2.height);
        coolItem.requestedWidth = n9;
        coolItem2 = this.items[n5][n6 - 1];
        rectangle = coolItem2.internalGetBounds();
        n3 = n8 - rectangle.x;
        coolItem2.setBounds(rectangle.x, rectangle.y, n3, rectangle.height);
        coolItem2.requestedWidth = n3;
        int n10 = n8 - rectangle2.x + 10 + 4;
        if (n8 - rectangle2.x > 0) {
            this.internalRedraw(rectangle2.x - 4, rectangle2.y, n10, rectangle2.height);
        }
    }

    void moveUp(CoolItem coolItem, int n2) {
        Point point = this.findItem(coolItem);
        int n3 = point.y;
        if (this.items[n3].length == 1 && n3 == 0) {
            return;
        }
        boolean bl2 = this.removeItemFromRow(coolItem, n3, false);
        Rectangle rectangle = coolItem.internalGetBounds();
        this.internalRedraw(rectangle.x, rectangle.y, 10, rectangle.height);
        int n4 = n3 - 1;
        if (bl2 |= this.insertItemIntoRow(coolItem, n4, n2)) {
            this.relayout();
        } else {
            this.layoutItems();
        }
    }

    void onDispose(Event event) {
        if (this.inDispose) {
            return;
        }
        this.inDispose = true;
        this.notifyListeners(12, event);
        event.type = 0;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            for (int i3 = 0; i3 < this.items[i2].length; ++i3) {
                this.items[i2][i3].dispose();
            }
        }
        this.hoverCursor.dispose();
        this.dragCursor.dispose();
        this.cursor = null;
    }

    void onMouseDown(Event event) {
        if (this.isLocked || event.button != 1) {
            return;
        }
        this.fixEvent(event);
        this.dragging = this.getGrabbedItem(event.x, event.y);
        if (this.dragging != null) {
            this.mouseXOffset = event.x;
            this.itemXOffset = this.mouseXOffset - this.dragging.internalGetBounds().x;
            this._setCursor(this.dragCursor);
        }
        this.fixEvent(event);
    }

    void onMouseExit() {
        if (this.dragging == null) {
            this._setCursor(null);
        }
    }

    void onMouseMove(Event event) {
        if (this.isLocked) {
            return;
        }
        this.fixEvent(event);
        CoolItem coolItem = this.getGrabbedItem(event.x, event.y);
        if (this.dragging != null) {
            int n2;
            int n3 = this.toDisplay((Point)new Point((int)(event.x - this.itemXOffset), (int)event.y)).x;
            Rectangle rectangle = this.dragging.internalGetBounds();
            if (event.y < rectangle.y) {
                this.moveUp(this.dragging, n3);
            } else if (event.y > rectangle.y + rectangle.height) {
                this.moveDown(this.dragging, n3);
            } else if (event.x < this.mouseXOffset) {
                int n4 = Math.min(this.mouseXOffset, rectangle.x + this.itemXOffset) - event.x;
                if (n4 > 0) {
                    this.moveLeft(this.dragging, n4);
                }
            } else if (event.x > this.mouseXOffset && (n2 = event.x - Math.max(this.mouseXOffset, rectangle.x + this.itemXOffset)) > 0) {
                this.moveRight(this.dragging, n2);
            }
            this.mouseXOffset = event.x;
        } else if (coolItem != null) {
            this._setCursor(this.hoverCursor);
        } else {
            this._setCursor(null);
        }
        this.fixEvent(event);
    }

    void onMouseUp(Event event) {
        this.dragging = null;
        CoolItem coolItem = this.getGrabbedItem(event.x, event.y);
        if (coolItem != null) {
            this._setCursor(this.hoverCursor);
        } else {
            this._setCursor(null);
        }
    }

    void onMouseDoubleClick(Event event) {
        if (this.isLocked) {
            return;
        }
        this.dragging = null;
        this.fixEvent(event);
        CoolItem coolItem = this.getGrabbedItem(event.x, event.y);
        if (coolItem == null) {
            this._setCursor(null);
        } else {
            Point point = this.findItem(coolItem);
            int n2 = point.y;
            int n3 = point.x;
            if (this.items[n2].length > 1) {
                int n4;
                Rectangle rectangle = coolItem.internalGetBounds();
                int n5 = this.getWidth();
                for (n4 = 0; n4 < this.items[n2].length; ++n4) {
                    if (n4 == n3) continue;
                    n5 -= this.items[n2][n4].internalGetMinimumWidth();
                }
                if (rectangle.width == n5) {
                    n4 = rectangle.width - coolItem.internalGetMinimumWidth();
                    if (n3 + 1 < this.items[n2].length) {
                        CoolItem coolItem2 = this.items[n2][n3 + 1];
                        this.moveLeft(coolItem2, n4);
                    } else {
                        this.moveRight(coolItem, n4);
                    }
                } else if (rectangle.width < coolItem.preferredWidth) {
                    n4 = coolItem.preferredWidth - rectangle.width;
                    if (n3 + 1 < this.items[n2].length) {
                        CoolItem coolItem3 = this.items[n2][n3 + 1];
                        this.moveRight(coolItem3, n4);
                        n4 = coolItem.preferredWidth - coolItem.internalGetBounds().width;
                    }
                    if (n4 > 0) {
                        this.moveLeft(coolItem, n4);
                    }
                } else {
                    for (n4 = 0; n4 < this.items[n2].length; ++n4) {
                        if (n4 == n3) continue;
                        CoolItem coolItem4 = this.items[n2][n4];
                        coolItem4.requestedWidth = Math.max(coolItem4.internalGetMinimumWidth(), 10);
                    }
                    coolItem.requestedWidth = n5;
                    this.layoutItems();
                }
                this._setCursor(this.hoverCursor);
            }
        }
        this.fixEvent(event);
    }

    void onPaint(Event event) {
        GC gC = event.gc;
        if (this.items.length == 0) {
            return;
        }
        Color color = this.display.getSystemColor(18);
        Color color2 = this.display.getSystemColor(20);
        boolean bl2 = (this.style & 0x200) != 0;
        boolean bl3 = (this.style & 0x800000) != 0;
        int n2 = this.getWidth();
        Rectangle rectangle = gC.getClipping();
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            Rectangle rectangle2;
            int n3;
            Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
            for (n3 = 0; n3 < this.items[i2].length; ++n3) {
                rectangle3 = this.items[i2][n3].internalGetBounds();
                rectangle2 = this.fixRectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                if (!rectangle.intersects(rectangle2)) continue;
                boolean bl4 = false;
                if (!this.isLocked) {
                    rectangle2 = this.fixRectangle(rectangle3.x, rectangle3.y, 10, rectangle3.height);
                    if (!bl3) {
                        bl4 = this.drawGripper(gC, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, bl2);
                    }
                    if (!bl4) {
                        int n4 = 2;
                        int n5 = rectangle3.height - 2 * n4 - 1;
                        gC.setForeground(color);
                        rectangle2 = this.fixRectangle(rectangle3.x + 4, rectangle3.y + n4, 2, n5);
                        gC.drawRectangle(rectangle2);
                        gC.setForeground(color2);
                        rectangle2 = this.fixRectangle(rectangle3.x + 4, rectangle3.y + n4 + 1, rectangle3.x + 4, rectangle3.y + n4 + n5 - 1);
                        gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        rectangle2 = this.fixRectangle(rectangle3.x + 4, rectangle3.y + n4, rectangle3.x + 4 + 1, rectangle3.y + n4);
                        gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                }
                if (bl3 || bl4 || n3 == 0) continue;
                gC.setForeground(color);
                rectangle2 = this.fixRectangle(rectangle3.x, rectangle3.y, rectangle3.x, rectangle3.y + rectangle3.height - 1);
                gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                gC.setForeground(color2);
                rectangle2 = this.fixRectangle(rectangle3.x + 1, rectangle3.y, rectangle3.x + 1, rectangle3.y + rectangle3.height - 1);
                gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            if (bl3 || i2 + 1 >= this.items.length) continue;
            n3 = rectangle3.y + rectangle3.height;
            gC.setForeground(color);
            rectangle2 = this.fixRectangle(0, n3, n2, n3);
            gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            gC.setForeground(color2);
            rectangle2 = this.fixRectangle(0, n3 + 1, n2, n3 + 1);
            gC.drawLine(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    void onResize() {
        this.layoutItems();
    }

    void removeControl(Control control) {
        super.removeControl(control);
        CoolItem[] coolItemArray = this.getItems();
        for (int i2 = 0; i2 < coolItemArray.length; ++i2) {
            CoolItem coolItem = coolItemArray[i2];
            if (coolItem.control != control) continue;
            coolItem.setControl(null);
        }
    }

    boolean removeItemFromRow(CoolItem coolItem, int n2, boolean bl2) {
        int n3 = this.findItem((CoolItem)coolItem).x;
        int n4 = this.items[n2].length - 1;
        Rectangle rectangle = coolItem.internalGetBounds();
        int n5 = rectangle.height;
        coolItem.wrap = false;
        if (n4 <= 0) {
            CoolItem[][] coolItemArrayArray = new CoolItem[this.items.length - 1][];
            System.arraycopy(this.items, 0, coolItemArrayArray, 0, n2);
            System.arraycopy(this.items, n2 + 1, coolItemArrayArray, n2, coolItemArrayArray.length - n2);
            this.items = coolItemArrayArray;
            return true;
        }
        Object object = new CoolItem[n4];
        System.arraycopy(this.items[n2], 0, object, 0, n3);
        System.arraycopy(this.items[n2], n3 + 1, object, n3, ((CoolItem[])object).length - n3);
        this.items[n2] = object;
        this.items[n2][0].wrap = true;
        if (!bl2) {
            int n6;
            Rectangle rectangle2;
            if (n3 == 0) {
                object = this.items[n2][0];
                rectangle2 = ((CoolItem)object).internalGetBounds();
                n6 = rectangle2.x + rectangle2.width;
                ((CoolItem)object).setBounds(0, rectangle2.y, n6, rectangle2.height);
                ((CoolItem)object).requestedWidth = n6;
                this.internalRedraw(rectangle2.x, rectangle2.y, 10, rectangle2.height);
            } else {
                object = this.items[n2][n3 - 1];
                rectangle2 = ((CoolItem)object).internalGetBounds();
                n6 = rectangle2.width + rectangle.width;
                ((CoolItem)object).setBounds(rectangle2.x, rectangle2.y, n6, rectangle2.height);
                ((CoolItem)object).requestedWidth = n6;
            }
        }
        int n7 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            n7 = Math.max(n7, this.items[n2][i2].preferredHeight);
        }
        return n7 != n5;
    }

    int layoutItems() {
        int n2 = 0;
        int n3 = (this.style & 0x200) != 0 ? this.getClientArea().height : this.getClientArea().width;
        this.wrapItems(n3);
        int n4 = (this.style & 0x800000) != 0 ? 0 : 2;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            CoolItem coolItem;
            int n5;
            int n6 = this.items[i2].length;
            int n7 = 0;
            int n8 = 0;
            int n9 = n3;
            for (n5 = 0; n5 < n6; ++n5) {
                coolItem = this.items[i2][n5];
                n8 = Math.max(n8, coolItem.preferredHeight);
                n9 -= coolItem.internalGetMinimumWidth();
            }
            if (i2 > 0) {
                n2 += n4;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                Rectangle rectangle;
                Rectangle rectangle2;
                coolItem = this.items[i2][n5];
                int n10 = n9 + coolItem.internalGetMinimumWidth();
                if (n5 + 1 < n6) {
                    n10 = Math.min(n10, coolItem.requestedWidth);
                    n9 -= n10 - coolItem.internalGetMinimumWidth();
                }
                if (!(rectangle2 = coolItem.internalGetBounds()).equals(rectangle = new Rectangle(n7, n2, n10, n8))) {
                    coolItem.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
                    if (rectangle2.y != rectangle.y) {
                        rectangle3 = rectangle;
                        rectangle3.add(rectangle2);
                        rectangle3.y -= n4;
                        rectangle3.height += 2 * n4;
                    } else if (rectangle2.height != rectangle.height) {
                        rectangle3.y = rectangle.y + Math.min(rectangle2.height, rectangle.height) - 3;
                        rectangle3.height = rectangle.y + rectangle.height + n4;
                        rectangle3.x = rectangle2.x - 4;
                        rectangle3.width = rectangle2.width + 4;
                    } else if (rectangle2.x != rectangle.x) {
                        rectangle3.x = Math.min(rectangle2.x, rectangle.x);
                        rectangle3.width = Math.abs(rectangle2.x - rectangle.x) + 10;
                        rectangle3.y = rectangle2.y;
                        rectangle3.height = rectangle2.height;
                    }
                    this.internalRedraw(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                }
                n7 += n10;
            }
            n2 += n8;
        }
        return n2;
    }

    void relayout() {
        Point point = this.getSize();
        int n2 = this.layoutItems();
        if ((this.style & 0x200) != 0) {
            Rectangle rectangle = this.computeTrim(0, 0, n2, 0);
            if (n2 != point.x) {
                super.setSize(rectangle.width, point.y);
            }
        } else {
            Rectangle rectangle = this.computeTrim(0, 0, 0, n2);
            if (n2 != point.y) {
                super.setSize(point.x, rectangle.height);
            }
        }
    }

    public int[] getItemOrder() {
        this.checkWidget();
        int n2 = this.getItemCount();
        int[] nArray = new int[n2];
        n2 = 0;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            for (int i3 = 0; i3 < this.items[i2].length; ++i3) {
                int n3;
                CoolItem coolItem = this.items[i2][i3];
                for (n3 = 0; n3 < this.originalItems.length && this.originalItems[n3] != coolItem; ++n3) {
                }
                if (n3 == this.originalItems.length) {
                    this.error(8);
                }
                nArray[n2++] = n3;
            }
        }
        return nArray;
    }

    void setItemOrder(int[] nArray) {
        int n2;
        int n3;
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length != (n3 = this.originalItems.length)) {
            this.error(5);
        }
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < blArray.length; ++n2) {
            blArray[n2] = false;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] < 0 || nArray[n2] >= n3) {
                this.error(5);
            }
            if (blArray[nArray[n2]]) {
                this.error(5);
            }
            blArray[nArray[n2]] = true;
        }
        CoolItem[] coolItemArray = new CoolItem[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            coolItemArray[i2] = this.originalItems[nArray[i2]];
        }
        this.items = new CoolItem[1][n3];
        this.items[0] = coolItemArray;
    }

    public Point[] getItemSizes() {
        this.checkWidget();
        CoolItem[] coolItemArray = this.getItems();
        Point[] pointArray = new Point[coolItemArray.length];
        for (int i2 = 0; i2 < coolItemArray.length; ++i2) {
            pointArray[i2] = coolItemArray[i2].getSize();
        }
        return pointArray;
    }

    void setItemSizes(Point[] pointArray) {
        CoolItem[] coolItemArray;
        if (pointArray == null) {
            this.error(4);
        }
        if (pointArray.length != (coolItemArray = this.getItems()).length) {
            this.error(5);
        }
        for (int i2 = 0; i2 < coolItemArray.length; ++i2) {
            coolItemArray[i2].setSize(pointArray[i2]);
        }
    }

    public boolean getLocked() {
        this.checkWidget();
        return this.isLocked;
    }

    int getWidth() {
        if ((this.style & 0x200) != 0) {
            return this.getSize().y;
        }
        return this.getSize().x;
    }

    public int[] getWrapIndices() {
        this.checkWidget();
        if (this.items.length <= 1) {
            return new int[0];
        }
        int[] nArray = new int[this.items.length - 1];
        int n2 = 0;
        int n3 = this.items[0].length;
        for (int i2 = 1; i2 < this.items.length; ++i2) {
            if (this.items[i2][0].wrap) {
                nArray[n2++] = n3;
            }
            n3 += this.items[i2].length;
        }
        if (n2 != nArray.length) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            return nArray2;
        }
        return nArray;
    }

    public void setLocked(boolean bl2) {
        this.checkWidget();
        if (this.isLocked != bl2) {
            this.redraw();
        }
        this.isLocked = bl2;
    }

    public void setWrapIndices(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            nArray = new int[]{};
        }
        int n3 = this.originalItems.length;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0 && nArray[n2] < n3) continue;
            this.error(5);
        }
        for (n2 = 0; n2 < this.originalItems.length; ++n2) {
            this.originalItems[n2].wrap = false;
        }
        block2: for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                if (this.items[i2].length > n4) {
                    this.items[i2][n4].wrap = true;
                    continue block2;
                }
                n4 -= this.items[i2].length;
            }
        }
        this.relayout();
    }

    void reskinChildren(int n2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                for (int i3 = 0; i3 < this.items[i2].length; ++i3) {
                    CoolItem coolItem = this.items[i2][i3];
                    if (coolItem == null) continue;
                    coolItem.reskin(n2);
                }
            }
        }
        super.reskinChildren(n2);
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.cursor = cursor;
        super.setCursor(this.cursor);
    }

    public void setItemLayout(int[] nArray, int[] nArray2, Point[] pointArray) {
        this.checkWidget();
        this.setItemOrder(nArray);
        this.setWrapIndices(nArray2);
        this.setItemSizes(pointArray);
        this.relayout();
    }

    public void setOrientation(int n2) {
        super.setOrientation(n2);
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            for (int i3 = 0; i3 < this.items[i2].length; ++i3) {
                CoolItem coolItem = this.items[i2][i3];
                if (coolItem.arrowImage != null) {
                    coolItem.arrowImage.dispose();
                    coolItem.arrowImage = null;
                }
                coolItem.updateChevron();
            }
        }
    }

    void wrapItems(int n2) {
        int n3;
        int n4 = this.originalItems.length;
        if (n4 < 2) {
            return;
        }
        CoolItem[] coolItemArray = new CoolItem[n4];
        int n5 = 0;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            System.arraycopy(this.items[i2], 0, coolItemArray, n5, this.items[i2].length);
            n5 += this.items[i2].length;
        }
        CoolItem[][] coolItemArrayArray = new CoolItem[n4][];
        int n6 = 0;
        int n7 = 0;
        n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            CoolItem coolItem = coolItemArray[n3];
            int n8 = coolItem.internalGetMinimumWidth();
            if (n3 > 0 && coolItem.wrap || n2 != -1 && n7 + n8 > n2) {
                if (n3 == n5) {
                    coolItemArrayArray[n6] = new CoolItem[1];
                    coolItemArrayArray[n6][0] = coolItem;
                    n5 = n3 + 1;
                    n7 = 0;
                } else {
                    int n9 = n3 - n5;
                    coolItemArrayArray[n6] = new CoolItem[n9];
                    System.arraycopy(coolItemArray, n5, coolItemArrayArray[n6], 0, n9);
                    n5 = n3;
                    n7 = n8;
                }
                ++n6;
                continue;
            }
            n7 += n8;
        }
        if (n5 < n4) {
            n3 = n4 - n5;
            coolItemArrayArray[n6] = new CoolItem[n3];
            System.arraycopy(coolItemArray, n5, coolItemArrayArray[n6], 0, n3);
            ++n6;
        }
        if (coolItemArrayArray.length != n6) {
            CoolItem[][] coolItemArrayArray2 = new CoolItem[n6][];
            System.arraycopy(coolItemArrayArray, 0, coolItemArrayArray2, 0, n6);
            this.items = coolItemArrayArray2;
        } else {
            this.items = coolItemArrayArray;
        }
    }
}

