/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTCanvasView;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;

    Composite() {
    }

    public Composite(Composite composite, int n2) {
        super(composite, n2);
    }

    Control[] _getChildren() {
        NSArray nSArray = this.contentView().subviews();
        int n2 = (int)nSArray.count();
        Control[] controlArray = new Control[n2];
        if (n2 == 0) {
            return controlArray;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Widget widget = this.display.getWidget(nSArray.objectAtIndex((long)((long)(n2 - i2 - 1))).id);
            if (widget == null || widget == this || !(widget instanceof Control)) continue;
            controlArray[n3++] = (Control)widget;
        }
        if (n3 == n2) {
            return controlArray;
        }
        Control[] controlArray2 = new Control[n3];
        System.arraycopy(controlArray, 0, controlArray2, 0, n3);
        return controlArray2;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return null;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.tabList.length; ++i2) {
            if (this.tabList[i2].isDisposed()) continue;
            ++n2;
        }
        if (n2 == this.tabList.length) {
            return this.tabList;
        }
        Control[] controlArray = new Control[n2];
        int n3 = 0;
        for (int i3 = 0; i3 < this.tabList.length; ++i3) {
            if (this.tabList[i3].isDisposed()) continue;
            controlArray[n3++] = this.tabList[i3];
        }
        this.tabList = controlArray;
        return this.tabList;
    }

    boolean acceptsFirstMouse(long l2, long l3, long l4) {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.acceptsFirstMouse(l2, l3, l4);
    }

    boolean acceptsFirstResponder(long l2, long l3) {
        if ((this.state & 2) != 0) {
            return (this.style & 0x80000) == 0 && this.hooksKeys() && this.contentView().subviews().count() == 0L;
        }
        return super.acceptsFirstResponder(l2, l3);
    }

    long accessibilityAttributeValue(long l2, long l3, long l4) {
        NSString nSString = new NSString(l4);
        long l5 = super.accessibilityAttributeValue(l2, l3, l4);
        if ((this.state & 2) != 0 && l2 == this.accessibleHandle()) {
            if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                NSString nSString2;
                if (l5 != 0L && !(nSString2 = new NSString(l5)).isEqualToString(OS.NSAccessibilityUnknownRole)) {
                    return l5;
                }
                nSString2 = NSString.stringWith("SWTComposite");
                return nSString2.id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
                NSString nSString3;
                if (l5 != 0L && !(nSString3 = new NSString(l5)).isEqualToString(OS.NSAccessibilityUnknownSubrole)) {
                    return l5;
                }
                nSString3 = NSString.stringWith("generic container view");
                return nSString3.id;
            }
        }
        return l5;
    }

    boolean accessibilityIsIgnored(long l2, long l3) {
        if (l2 == this.accessibleHandle() && this.accessible != null) {
            return this.accessible.internal_accessibilityIsIgnored(-1);
        }
        return super.accessibilityIsIgnored(l2, l3);
    }

    public void changed(Control[] controlArray) {
        Control control;
        int n2;
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean bl2 = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl3 = bl2 = composite == this;
                if (bl2) break;
                composite = composite.parent;
            }
            if (bl2) continue;
            this.error(32);
        }
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            Composite composite = control.parent;
            while (control != this) {
                if (composite.layout == null || !composite.layout.flushCache(control)) {
                    composite.state |= 0x2000;
                }
                control = composite;
                composite = control.parent;
            }
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        Point point;
        this.checkWidget();
        this.display.runSkin();
        if (this.layout != null) {
            if (n2 == -1 || n3 == -1) {
                point = this.layout.computeSize(this, n2, n3, bl2 |= (this.state & 0x2000) != 0);
                this.state &= 0xFFFFDFFF;
            } else {
                point = new Point(n2, n3);
            }
        } else {
            point = this.minimumSize(n2, n3, bl2);
            if (point.x == 0) {
                point.x = 64;
            }
            if (point.y == 0) {
                point.y = 64;
            }
        }
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    protected void checkSubclass() {
    }

    Widget[] computeTabList() {
        Widget[] widgetArray = super.computeTabList();
        if (widgetArray.length == 0) {
            return widgetArray;
        }
        Control[] controlArray = this.tabList != null ? this._getTabList() : this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            Widget[] widgetArray2 = control.computeTabList();
            if (widgetArray2.length == 0) continue;
            Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
            System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
            System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
            widgetArray = widgetArray3;
        }
        return widgetArray;
    }

    void createHandle() {
        NSView nSView;
        boolean bl2;
        this.state |= 2;
        boolean bl3 = bl2 = (this.style & 0x300) != 0;
        if (!bl2) {
            this.state |= 0x800;
        }
        NSRect nSRect = new NSRect();
        if (bl2 || this.hasBorder()) {
            nSView = (NSScrollView)new SWTScrollView().alloc();
            nSView.initWithFrame(nSRect);
            ((NSScrollView)nSView).setDrawsBackground(false);
            if ((this.style & 0x100) != 0) {
                ((NSScrollView)nSView).setHasHorizontalScroller(true);
            }
            if ((this.style & 0x200) != 0) {
                ((NSScrollView)nSView).setHasVerticalScroller(true);
            }
            ((NSScrollView)nSView).setBorderType(this.hasBorder() ? 2L : 0L);
            this.scrollView = nSView;
        }
        nSView = (NSView)new SWTCanvasView().alloc();
        nSView.initWithFrame(nSRect);
        this.view = nSView;
        if (this.scrollView != null) {
            NSClipView nSClipView = this.scrollView.contentView();
            nSClipView.setAutoresizesSubviews(true);
            this.view.setAutoresizingMask(18L);
        }
    }

    public void drawBackground(GC gC, int n2, int n3, int n4, int n5, int n6, int n7) {
        Control control;
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            NSRect nSRect = new NSRect();
            nSRect.x = n2;
            nSRect.y = n3;
            nSRect.width = n4;
            nSRect.height = n5;
            int n8 = -1;
            GCData gCData = gC.getGCData();
            if (gCData.image != null) {
                n8 = gCData.image.getBounds().height;
            }
            NSGraphicsContext nSGraphicsContext = gC.handle;
            if (gCData.flippedContext != null) {
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(nSGraphicsContext);
            }
            control.fillBackground(this.view, nSGraphicsContext, nSRect, n8, gCData.view, n6, n7);
            if (gCData.flippedContext != null) {
                NSGraphicsContext.static_restoreGraphicsState();
            }
        } else {
            gC.fillRectangle(n2, n3, n4, n5);
        }
    }

    void drawBackground(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l2 != this.view.id) {
            return;
        }
        if ((this.state & 2) != 0 && (this.style & 0x40000) == 0) {
            this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
        }
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] menuArray = super.findMenus(control);
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control2 = controlArray[i2];
            Menu[] menuArray2 = control2.findMenus(control);
            if (menuArray2.length == 0) continue;
            Menu[] menuArray3 = new Menu[menuArray.length + menuArray2.length];
            System.arraycopy(menuArray, 0, menuArray3, 0, menuArray.length);
            System.arraycopy(menuArray2, 0, menuArray3, menuArray.length, menuArray2.length);
            menuArray = menuArray3;
        }
        return menuArray;
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            controlArray[i2].fixChildren(shell, shell2, decorations, decorations2, menuArray);
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.tabList.length; ++i2) {
            if (this.tabList[i2] != control) continue;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        Control[] controlArray = null;
        int n3 = this.tabList.length - n2;
        if (n3 != 0) {
            controlArray = new Control[n3];
            int n4 = 0;
            for (int i3 = 0; i3 < this.tabList.length; ++i3) {
                if (this.tabList[i3] == control) continue;
                controlArray[n4++] = this.tabList[i3];
            }
        }
        this.tabList = controlArray;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] controlArray = this._getTabList();
        if (controlArray == null) {
            int n2;
            int n3 = 0;
            Control[] controlArray2 = this._getChildren();
            for (n2 = 0; n2 < controlArray2.length; ++n2) {
                if (!controlArray2[n2].isTabGroup()) continue;
                ++n3;
            }
            controlArray = new Control[n3];
            n2 = 0;
            for (int i2 = 0; i2 < controlArray2.length; ++i2) {
                if (!controlArray2[i2].isTabGroup()) continue;
                controlArray[n2++] = controlArray2[i2];
            }
        }
        return controlArray;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    void invalidateChildrenVisibleRegion() {
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            control.resetVisibleRegion();
            control.invalidateChildrenVisibleRegion();
        }
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    boolean isOpaque(long l2, long l3) {
        if ((this.state & 2) != 0 && l2 == this.view.id) {
            return this.region == null && this.background != null && this.background[3] == 1.0 && !this.isObscured();
        }
        return super.isOpaque(l2, l3);
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    void keyDown(long l2, long l3, long l4) {
        if (this.hasFocus() && (this.state & 2) != 0) {
            Shell shell = this.getShell();
            shell.deferFlushing();
            NSArray nSArray = NSArray.arrayWithObject(new NSEvent(l4));
            shell.keyInputHappened = false;
            this.view.interpretKeyEvents(nSArray);
            if (this.imeInComposition()) {
                return;
            }
            if (!shell.keyInputHappened) {
                NSEvent nSEvent = new NSEvent(l4);
                boolean[] blArray = new boolean[1];
                if (this.translateTraversal(nSEvent.keyCode(), nSEvent, blArray)) {
                    return;
                }
                if (this.isDisposed()) {
                    return;
                }
                if (!this.sendKeyEvent(nSEvent, 1)) {
                    return;
                }
                if (blArray[0]) {
                    return;
                }
            }
            return;
        }
        super.keyDown(l2, l3, l4);
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean bl2) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(bl2, false);
    }

    public void layout(boolean bl2, boolean bl3) {
        this.checkWidget();
        if (this.layout == null && !bl3) {
            return;
        }
        this.markLayout(bl2, bl3);
        this.updateLayout(bl3);
    }

    public void layout(Control[] controlArray) {
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        this.layout(controlArray, 0);
    }

    public void layout(Control[] controlArray, int n2) {
        this.checkWidget();
        if (controlArray != null) {
            Control control;
            int n3;
            Composite[] compositeArray;
            int n4;
            for (n4 = 0; n4 < controlArray.length; ++n4) {
                compositeArray = controlArray[n4];
                if (compositeArray == null) {
                    this.error(5);
                }
                if (compositeArray.isDisposed()) {
                    this.error(5);
                }
                n3 = 0;
                control = compositeArray.parent;
                while (control != null) {
                    int n5 = n3 = control == this ? 1 : 0;
                    if (n3 != 0) break;
                    control = control.parent;
                }
                if (n3 != 0) continue;
                this.error(32);
            }
            n4 = 0;
            compositeArray = new Composite[16];
            for (n3 = 0; n3 < controlArray.length; ++n3) {
                control = controlArray[n3];
                Composite composite = control.parent;
                while (control != this) {
                    if (composite.layout != null) {
                        composite.state |= 0x1000;
                        if (!composite.layout.flushCache(control)) {
                            composite.state |= 0x2000;
                        }
                    }
                    if (n4 == compositeArray.length) {
                        Composite[] compositeArray2 = new Composite[compositeArray.length + 16];
                        System.arraycopy(compositeArray, 0, compositeArray2, 0, compositeArray.length);
                        compositeArray = compositeArray2;
                    }
                    int n6 = n4++;
                    Composite composite2 = composite;
                    compositeArray[n6] = composite2;
                    control = composite2;
                    composite = control.parent;
                }
            }
            if ((n2 & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                compositeArray[n3].updateLayout(false);
            }
        } else {
            if (this.layout == null && (n2 & 1) == 0) {
                return;
            }
            this.markLayout((n2 & 2) != 0, (n2 & 1) != 0);
            if ((n2 & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((n2 & 1) != 0);
        }
    }

    void markLayout(boolean bl2, boolean bl3) {
        if (this.layout != null) {
            this.state |= 0x1000;
            if (bl2) {
                this.state |= 0x2000;
            }
        }
        if (bl3) {
            Control[] controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                controlArray[i2].markLayout(bl2, bl3);
            }
        }
    }

    Point minimumSize(int n2, int n3, boolean bl2) {
        Control[] controlArray = this._getChildren();
        Rectangle rectangle = this.getClientArea();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Rectangle rectangle2 = controlArray[i2].getBounds();
            n4 = Math.max(n4, rectangle2.x - rectangle.x + rectangle2.width);
            n5 = Math.max(n5, rectangle2.y - rectangle.y + rectangle2.height);
        }
        return new Point(n4, n5);
    }

    boolean mouseEvent(long l2, long l3, long l4, int n2) {
        boolean bl2 = super.mouseEvent(l2, l3, l4, n2);
        return (this.state & 2) == 0 ? bl2 : new NSEvent(l4).type() != 1L;
    }

    void pageDown(long l2, long l3, long l4) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.pageDown(l2, l3, l4);
    }

    void pageUp(long l2, long l3, long l4) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.pageUp(l2, l3, l4);
    }

    void reflectScrolledClipView(long l2, long l3, long l4) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.reflectScrolledClipView(l2, l3, l4);
    }

    void releaseChildren(boolean bl2) {
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            if (control == null || control.isDisposed()) continue;
            control.release(false);
        }
        super.releaseChildren(bl2);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        if (control.hasFocus()) {
            this.redrawWidget(this.view, true);
        }
        this.fixTabList(control);
    }

    void reskinChildren(int n2) {
        super.reskinChildren(n2);
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            if (control == null) continue;
            control.reskin(n2);
        }
    }

    void resized() {
        super.resized();
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
    }

    void scrollWheel(long l2, long l3, long l4) {
        if ((this.state & 2) != 0) {
            NSView nSView;
            NSView nSView2 = nSView = this.scrollView != null ? this.scrollView : this.view;
            if (l2 == nSView.id) {
                this.getShell().deferFlushing();
                NSEvent nSEvent = new NSEvent(l4);
                boolean bl2 = false;
                double d2 = nSEvent.deltaY();
                double d3 = nSEvent.deltaX();
                if (!(!this.hooks(48) && !this.filters(48) || d3 == 0.0 && d2 == 0.0 || this.gestureEvent(l2, l4, 64))) {
                    bl2 = true;
                }
                if (!bl2) {
                    Event event;
                    int n2;
                    ScrollBar scrollBar;
                    boolean bl3;
                    if (d2 != 0.0) {
                        bl3 = true;
                        if (this.hooks(37) || this.filters(37)) {
                            bl3 = this.sendMouseEvent(nSEvent, 37, true);
                        }
                        scrollBar = this.verticalBar;
                        if (bl3 && scrollBar != null && scrollBar.getEnabled()) {
                            if (-1.0 < d2 && d2 < 0.0) {
                                d2 = -1.0;
                            }
                            if (0.0 < d2 && d2 < 1.0) {
                                d2 = 1.0;
                            }
                            n2 = Math.max(0, (int)((double)(0.5f + (float)scrollBar.getSelection()) - (double)scrollBar.getIncrement() * d2));
                            scrollBar.setSelection(n2);
                            event = new Event();
                            event.detail = d2 > 0.0 ? 0x1000005 : 0x1000006;
                            scrollBar.sendSelectionEvent(13, event, true);
                            bl2 = true;
                        }
                        if (!bl3) {
                            bl2 = true;
                        }
                    }
                    if (d3 != 0.0) {
                        bl3 = true;
                        if (this.hooks(38) || this.filters(38)) {
                            bl3 = this.sendMouseEvent(nSEvent, 38, true);
                        }
                        scrollBar = this.horizontalBar;
                        if (bl3 && scrollBar != null && scrollBar.getEnabled()) {
                            if (-1.0 < d3 && d3 < 0.0) {
                                d3 = -1.0;
                            }
                            if (0.0 < d3 && d3 < 1.0) {
                                d3 = 1.0;
                            }
                            n2 = Math.max(0, (int)((double)(0.5f + (float)scrollBar.getSelection()) - (double)scrollBar.getIncrement() * d3));
                            scrollBar.setSelection(n2);
                            event = new Event();
                            event.detail = d3 > 0.0 ? 0x1000005 : 0x1000006;
                            scrollBar.sendSelectionEvent(13, event, true);
                            bl2 = true;
                        }
                        if (!bl3) {
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        nSView.superview().scrollWheel(nSEvent);
                    }
                }
                return;
            }
            this.callSuper(l2, l3, l4);
            return;
        }
        super.scrollWheel(l2, l3, l4);
    }

    public void setBackgroundMode(int n2) {
        this.checkWidget();
        this.backgroundMode = n2;
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            controlArray[i2].updateBackgroundMode();
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            if (!controlArray[i2].setFocus()) continue;
            return true;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean bl2) {
        this.checkWidget();
        if (!bl2) {
            if (--this.layoutCount == 0 && ((this.state & 0x4000) != 0 || (this.state & 0x1000) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl2) {
        boolean bl3 = super.setScrollBarVisible(scrollBar, bl2);
        if (bl3 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return bl3;
    }

    boolean setTabGroupFocus() {
        boolean bl2;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl3 = bl2 = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            bl2 = this.hooksKeys();
        }
        if (bl2 && this.setTabItemFocus()) {
            return true;
        }
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            if (!control.isTabItem() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    public void setTabList(Control[] controlArray) {
        this.checkWidget();
        if (controlArray != null) {
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Control control = controlArray[i2];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent == this) continue;
                this.error(32);
            }
            Control[] controlArray2 = new Control[controlArray.length];
            System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
            controlArray = controlArray2;
        }
        this.tabList = controlArray;
    }

    int traversalCode(int n2, NSEvent nSEvent) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(n2, nSEvent);
    }

    void updateBackgroundColor() {
        super.updateBackgroundColor();
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            if ((controlArray[i2].state & 0x400) == 0) continue;
            controlArray[i2].updateBackgroundColor();
        }
    }

    void updateBackgroundImage() {
        super.updateBackgroundImage();
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            if ((controlArray[i2].state & 0x400) == 0) continue;
            controlArray[i2].updateBackgroundImage();
        }
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            controlArray[i2].updateBackgroundMode();
        }
    }

    void updateCursorRects(boolean bl2) {
        super.updateCursorRects(bl2);
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            control.updateCursorRects(bl2 && control.isEnabled());
        }
    }

    void updateLayout(boolean bl2) {
        Composite composite = this.findDeferredControl();
        if (composite != null) {
            composite.state |= 0x4000;
            return;
        }
        if ((this.state & 0x1000) != 0) {
            boolean bl3 = (this.state & 0x2000) != 0;
            this.state &= 0xFFFFCFFF;
            this.display.runSkin();
            this.layout.layout(this, bl3);
        }
        if (bl2) {
            this.state &= 0xFFFFBFFF;
            Control[] controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                controlArray[i2].updateLayout(bl2);
            }
        }
    }
}

