/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSComboBox;
import org.eclipse.swt.internal.cocoa.NSComboBoxCell;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableString;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTComboBox;
import org.eclipse.swt.internal.cocoa.SWTPopUpButton;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    String text;
    int textLimit = LIMIT;
    boolean receivingFocus;
    boolean ignoreSetObject;
    boolean ignoreSelection;
    NSRange selectionRange;
    boolean listVisible;
    static final int VISIBLE_COUNT = 5;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite composite, int n2) {
        super(composite, Combo.checkStyle(n2));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        NSAttributedString nSAttributedString = this.createString(string);
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            long l2 = nSPopUpButton.indexOfSelectedItem();
            NSMenu nSMenu = nSPopUpButton.menu();
            NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
            NSString nSString = NSString.string();
            nSMenuItem.initWithTitle(nSString, 0L, nSString);
            nSMenuItem.setAttributedTitle(nSAttributedString);
            nSMenu.addItem(nSMenuItem);
            nSMenuItem.release();
            if (l2 == -1L) {
                nSPopUpButton.selectItemAtIndex(-1L);
            }
        } else {
            ((NSComboBox)this.view).addItemWithObjectValue(nSAttributedString);
        }
    }

    public void add(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = this.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        NSAttributedString nSAttributedString = this.createString(string);
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            long l2 = nSPopUpButton.indexOfSelectedItem();
            NSMenu nSMenu = nSPopUpButton.menu();
            NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
            NSString nSString = NSString.string();
            nSMenuItem.initWithTitle(nSString, 0L, nSString);
            nSMenuItem.setAttributedTitle(nSAttributedString);
            nSMenu.insertItem(nSMenuItem, n2);
            nSMenuItem.release();
            if (l2 == -1L) {
                nSPopUpButton.selectItemAtIndex(-1L);
            }
        } else {
            ((NSComboBox)this.view).insertItemWithObjectValue(nSAttributedString, n2);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    boolean becomeFirstResponder(long l2, long l3) {
        this.receivingFocus = true;
        boolean bl2 = super.becomeFirstResponder(l2, l3);
        this.receivingFocus = false;
        return bl2;
    }

    static int checkStyle(int n2) {
        n2 &= 0xFFFFF7FF;
        n2 &= 0xFFFFFCFF;
        if (((n2 = Combo.checkBits(n2, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n2 & 0xFFFFFFF7;
        }
        return n2;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            Point point = this.getSelection();
            point.y = point.x;
            this.setSelection(point);
        }
    }

    void setObjectValue(long l2, long l3, long l4) {
        super.setObjectValue(l2, l3, this.ignoreSetObject ? l4 : this.createString((String)this.text).id);
    }

    void comboBoxSelectionDidChange(long l2, long l3, long l4) {
        NSComboBox nSComboBox = (NSComboBox)this.view;
        long l5 = nSComboBox.indexOfSelectedItem();
        nSComboBox.selectItemAtIndex(l5);
        NSAttributedString nSAttributedString = new NSAttributedString(nSComboBox.itemObjectValueAtIndex(l5));
        NSString nSString = nSAttributedString.string();
        if (nSString != null) {
            this.setText(nSString.getString(), true);
        }
        if (!this.ignoreSelection) {
            this.sendSelectionEvent(13, null, this.display.trackingControl != this);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        NSControl nSControl = (NSControl)this.view;
        NSCell nSCell = nSControl.cell();
        NSSize nSSize = nSCell.cellSize();
        n4 = (int)Math.ceil(nSSize.width);
        n5 = (int)Math.ceil(nSSize.height);
        if ((this.style & 8) == 0) {
            int n6;
            Object object;
            this.ignoreSetObject = true;
            NSComboBoxCell nSComboBoxCell = new NSComboBoxCell(nSCell.id);
            NSArray nSArray = nSComboBoxCell.objectValues();
            int n7 = (int)nSArray.count();
            if (n7 > 0) {
                nSComboBoxCell = new NSComboBoxCell(nSComboBoxCell.copy());
                for (int i2 = 0; i2 < n7; ++i2) {
                    object = new NSAttributedString(nSArray.objectAtIndex(i2));
                    nSComboBoxCell.setAttributedStringValue((NSAttributedString)object);
                    nSSize = nSComboBoxCell.cellSize();
                    n4 = Math.max(n4, (int)Math.ceil(nSSize.width));
                }
                nSComboBoxCell.release();
            }
            this.ignoreSetObject = false;
            NSString nSString = nSControl.stringValue();
            if (nSString != null && (object = nSString.getString()) != null && (((String)object).indexOf(10) >= 0 || ((String)object).indexOf(13) >= 0) && (n6 = (int)this.view.frame().height) > 0) {
                n5 = n6;
            }
        } else {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            if (nSPopUpButton.numberOfItems() == 1L && nSPopUpButton.indexOfSelectedItem() == -1L) {
                nSPopUpButton.selectItemAtIndex(0L);
                nSSize = nSCell.cellSize();
                n4 = Math.max(n4, (int)Math.ceil(nSSize.width));
                nSPopUpButton.selectItemAtIndex(-1L);
            }
        }
        if (n3 != -1 && ((this.style & 8) != 0 || n3 < n5)) {
            n5 = n3;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n4, n5);
    }

    public void copy() {
        this.checkWidget();
        Point point = this.getSelection();
        if (point.x == point.y) {
            return;
        }
        this.copyToClipboard(this.getText(point.x, point.y));
    }

    void createHandle() {
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)new SWTPopUpButton().alloc();
            nSPopUpButton.initWithFrame(new NSRect(), false);
            nSPopUpButton.menu().setAutoenablesItems(false);
            nSPopUpButton.setTarget(nSPopUpButton);
            nSPopUpButton.setAction(OS.sel_sendSelection);
            nSPopUpButton.menu().setDelegate(nSPopUpButton);
            this.view = nSPopUpButton;
        } else {
            NSComboBox nSComboBox = (NSComboBox)new SWTComboBox().alloc();
            nSComboBox.init();
            nSComboBox.setDelegate(nSComboBox);
            NSCell nSCell = nSComboBox.cell();
            if (OS.VERSION >= 4192 && nSCell != null) {
                nSCell.setUsesSingleLineMode(true);
            }
            this.view = nSComboBox;
        }
    }

    NSAttributedString createString(String string) {
        NSAttributedString nSAttributedString = this.createString(string, null, this.foreground, 16384, false, true, false);
        nSAttributedString.autorelease();
        return nSAttributedString;
    }

    void createWidget() {
        this.text = "";
        super.createWidget();
        if ((this.style & 8) == 0) {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            NSScreen nSScreen = nSComboBox.window().screen();
            NSRect nSRect = nSScreen != null ? nSScreen.frame() : NSScreen.mainScreen().frame();
            int n2 = Math.max(5, (int)(nSRect.height / 3.0 / nSComboBox.itemHeight()));
            nSComboBox.setNumberOfVisibleItems(n2);
        }
    }

    void comboBoxWillDismiss(long l2, long l3, long l4) {
        this.display.currentCombo = null;
        this.listVisible = false;
    }

    void comboBoxWillPopUp(long l2, long l3, long l4) {
        this.display.currentCombo = this;
        this.listVisible = true;
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point point = this.getSelection();
        if (point.x == point.y) {
            return;
        }
        int n2 = point.x;
        int n3 = point.y;
        String string = this.getText();
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n3, string.length());
        String string4 = string.substring(n2, n3);
        String string5 = "";
        if ((this.hooks(25) || this.filters(25)) && (string5 = this.verifyText(string5, n2, n3, null)) == null) {
            return;
        }
        char[] cArray = new char[string4.length()];
        string4.getChars(0, cArray.length, cArray, 0);
        this.copyToClipboard(cArray);
        this.setText(string2 + string5 + string3, false);
        this.setSelection(new Point(n2 += string5.length(), n2));
        this.sendEvent(24);
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        if ((this.style & 8) != 0) {
            return this.display.popUpButtonFont;
        }
        return this.display.comboBoxFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
    }

    public void deselect(int n2) {
        this.checkWidget();
        if (n2 == -1) {
            return;
        }
        if (n2 == this.getSelectionIndex()) {
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItem(null);
                this.sendEvent(24);
            } else {
                ((NSComboBox)this.view).deselectItemAtIndex(n2);
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).selectItem(null);
            this.sendEvent(24);
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            long l2 = nSComboBox.indexOfSelectedItem();
            if (l2 != -1L) {
                nSComboBox.deselectItemAtIndex(l2);
            }
        }
    }

    boolean dragDetect(int n2, int n3, boolean bl2, boolean[] blArray) {
        if ((this.style & 8) == 0) {
            NSText nSText = ((NSControl)this.view).currentEditor();
            if (nSText != null) {
                NSRange nSRange = nSText.selectedRange();
                if (nSRange.length > 0L) {
                    NSTextView nSTextView = new NSTextView(nSText);
                    NSPoint nSPoint = new NSPoint();
                    nSPoint.x = n2;
                    nSPoint.y = n3;
                    long l2 = nSTextView.characterIndexForInsertionAtPoint(nSPoint);
                    if (l2 != Integer.MAX_VALUE && l2 >= nSRange.location && l2 < nSRange.location + nSRange.length && super.dragDetect(n2, n3, bl2, blArray)) {
                        if (blArray != null) {
                            blArray[0] = true;
                        }
                        return true;
                    }
                }
            }
            return false;
        }
        return super.dragDetect(n2, n3, bl2, blArray);
    }

    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        return cursor != null || (this.style & 8) != 0 ? cursor : this.display.getSystemCursor(19);
    }

    NSRect focusRingMaskBoundsForFrame(long l2, long l3, NSRect nSRect, long l4) {
        return nSRect;
    }

    public int getCaretPosition() {
        this.checkWidget();
        return this.selectionRange != null ? (int)this.selectionRange.location : 0;
    }

    public Point getCaretLocation() {
        this.checkWidget();
        NSTextView nSTextView = null;
        if (this.hasFocus()) {
            nSTextView = new NSTextView(this.view.window().fieldEditor(true, this.view));
        }
        if (nSTextView == null) {
            return new Point(0, 0);
        }
        NSLayoutManager nSLayoutManager = nSTextView.layoutManager();
        NSTextContainer nSTextContainer = nSTextView.textContainer();
        NSRange nSRange = nSTextView.selectedRange();
        long[] lArray = new long[1];
        long l2 = nSLayoutManager.rectArrayForCharacterRange(nSRange, nSRange, nSTextContainer, lArray);
        NSRect nSRect = new NSRect();
        if (lArray[0] > 0L) {
            OS.memmove(nSRect, l2, (long)NSRect.sizeof);
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = (int)nSRect.x;
        nSPoint.y = (int)nSRect.y;
        nSPoint = nSTextView.convertPoint_toView_(nSPoint, this.view);
        return new Point((int)nSPoint.x, (int)nSPoint.y);
    }

    int getCharCount() {
        NSString nSString = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (nSString == null) {
            return 0;
        }
        return (int)nSString.length();
    }

    public String getItem(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        NSString nSString = null;
        if ((this.style & 8) != 0) {
            nSString = ((NSPopUpButton)this.view).itemTitleAtIndex(n2);
        } else {
            NSAttributedString nSAttributedString = new NSAttributedString(((NSComboBox)this.view).itemObjectValueAtIndex(n2));
            if (nSAttributedString != null) {
                nSString = nSAttributedString.string();
            }
        }
        if (nSString == null) {
            this.error(8);
        }
        return nSString.getString();
    }

    public int getItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return (int)((NSPopUpButton)this.view).numberOfItems();
        }
        return (int)((NSComboBox)this.view).numberOfItems();
    }

    public int getItemHeight() {
        this.checkWidget();
        return 26;
    }

    public String[] getItems() {
        this.checkWidget();
        int n2 = this.getItemCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.getItem(i2);
        }
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.listVisible;
    }

    String getNameText() {
        return this.getText();
    }

    int getMininumHeight() {
        return this.getTextHeight();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, this.getCharCount());
        }
        if (this.selectionRange == null) {
            NSString nSString = new NSTextFieldCell(((NSTextField)this.view).cell()).title();
            return new Point((int)nSString.length(), (int)nSString.length());
        }
        return new Point((int)this.selectionRange.location, (int)(this.selectionRange.location + this.selectionRange.length));
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return (int)((NSPopUpButton)this.view).indexOfSelectedItem();
        }
        return (int)((NSComboBox)this.view).indexOfSelectedItem();
    }

    public String getText() {
        this.checkWidget();
        return new String(this.getText(0, -1));
    }

    char[] getText(int n2, int n3) {
        NSString nSString = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (nSString == null) {
            return new char[0];
        }
        NSRange nSRange = new NSRange();
        nSRange.location = n2;
        if (n3 == -1) {
            long l2 = nSString.length();
            nSRange.length = l2 - (long)n2;
        } else {
            nSRange.length = n3 - n2;
        }
        char[] cArray = new char[(int)nSRange.length];
        nSString.getCharacters(cArray, nSRange);
        return cArray;
    }

    public int getTextHeight() {
        this.checkWidget();
        NSCell nSCell = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).cell() : ((NSComboBox)this.view).cell();
        return (int)nSCell.cellSize().height;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return this.getItemCount();
        }
        return (int)((NSComboBox)this.view).numberOfVisibleItems();
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            return -1;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!string.equals(this.getItem(i2))) continue;
            return i2;
        }
        return -1;
    }

    boolean isEventView(long l2) {
        return true;
    }

    void menuWillOpen(long l2, long l3, long l4) {
        this.listVisible = true;
    }

    void menuDidClose(long l2, long l3, long l4) {
        this.listVisible = false;
    }

    void mouseDown(long l2, long l3, long l4) {
        this.display.sendPreExternalEventDispatchEvent();
        NSView nSView = this.view;
        nSView.retain();
        super.mouseDown(l2, l3, l4);
        nSView.release();
        this.display.sendPostExternalEventDispatchEvent();
    }

    public void paste() {
        int n2;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point point = this.getSelection();
        int n3 = point.x;
        int n4 = point.y;
        String string = this.getText();
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n4, string.length());
        String string4 = this.getClipboardText();
        if (string4 == null) {
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string4 = this.verifyText(string4, n3, n4, null)) == null) {
            return;
        }
        if (this.textLimit != LIMIT && (n2 = string.length()) - (n4 - n3) + string4.length() > this.textLimit) {
            string4 = string4.substring(0, this.textLimit - n2 + (n4 - n3));
        }
        this.setText(string2 + string4 + string3, false);
        this.setSelection(new Point(n3 += string4.length(), n3));
        this.sendEvent(24);
    }

    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
    }

    void releaseWidget() {
        if (this.display.currentCombo == this) {
            this.display.currentCombo = null;
        }
        super.releaseWidget();
        if ((this.style & 8) == 0) {
            ((NSControl)this.view).abortEditing();
        }
        this.text = null;
        this.selectionRange = null;
    }

    public void remove(int n2) {
        this.checkWidget();
        if (n2 == -1) {
            this.error(6);
        }
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeItemAtIndex(n2);
        } else {
            ((NSComboBox)this.view).removeItemAtIndex(n2);
        }
    }

    public void remove(int n2, int n3) {
        int n4;
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n5 = this.getItemCount();
        if (0 > n2 || n2 > n3 || n3 >= n5) {
            this.error(6);
        }
        for (int i2 = n4 = Math.min(n3, n5 - 1); i2 >= n2; --i2) {
            this.remove(i2);
        }
    }

    public void remove(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n2);
    }

    public void removeAll() {
        this.checkWidget();
        this.ignoreSelection = true;
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeAllItems();
        } else {
            this.setText("", true);
            ((NSComboBox)this.view).removeAllItems();
        }
        this.ignoreSelection = false;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 <= n2 && n2 < n3) {
            if (n2 == this.getSelectionIndex()) {
                return;
            }
            this.ignoreSelection = true;
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItemAtIndex(n2);
                this.sendEvent(24);
            } else {
                NSComboBox nSComboBox = (NSComboBox)this.view;
                nSComboBox.deselectItemAtIndex(n2);
                nSComboBox.selectItemAtIndex(n2);
            }
            this.ignoreSelection = false;
        }
    }

    void sendSelection() {
        this.sendEvent(24);
        if (!this.ignoreSelection) {
            this.sendSelectionEvent(13);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n2) {
        boolean bl2 = super.sendKeyEvent(nSEvent, n2);
        if (!bl2) {
            return bl2;
        }
        int n3 = 0;
        long l2 = nSEvent.modifierFlags();
        if ((l2 & 0x80000L) != 0L) {
            n3 |= 0x10000;
        }
        if ((l2 & 0x20000L) != 0L) {
            n3 |= 0x20000;
        }
        if ((l2 & 0x40000L) != 0L) {
            n3 |= 0x40000;
        }
        if ((l2 & 0x100000L) != 0L) {
            n3 |= 0x400000;
        }
        if (n2 != 1) {
            return bl2;
        }
        short s2 = nSEvent.keyCode();
        if (n3 == 0x400000) {
            switch (s2) {
                case 7: {
                    this.cut();
                    return false;
                }
                case 8: {
                    this.copy();
                    return false;
                }
                case 9: {
                    this.paste();
                    return false;
                }
                case 0: {
                    if ((this.style & 8) != 0) break;
                    ((NSComboBox)this.view).selectText(null);
                    return false;
                }
            }
        }
        switch (s2) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
            }
        }
        return bl2;
    }

    boolean sendTrackingKeyEvent(NSEvent nSEvent, int n2) {
        long l2 = nSEvent.modifierFlags();
        if ((l2 & 0x20000L) == 0L) {
            short s2 = nSEvent.keyCode();
            switch (s2) {
                case 125: 
                case 126: {
                    this.sendKeyEvent(nSEvent, n2);
                    return true;
                }
            }
        }
        return false;
    }

    void setBackgroundColor(NSColor nSColor) {
        if ((this.style & 8) == 0) {
            ((NSTextField)this.view).setBackgroundColor(nSColor);
        }
    }

    void setBackgroundImage(NSImage nSImage) {
    }

    void setBounds(int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        if ((this.style & 8) == 0) {
            int n6;
            Object object;
            NSControl nSControl = (NSControl)this.view;
            int n7 = 0;
            NSString nSString = nSControl.stringValue();
            if (nSString != null && (object = nSString.getString()) != null && (((String)object).indexOf(10) >= 0 || ((String)object).indexOf(13) >= 0) && (n6 = (int)this.view.frame().height) > 0) {
                n7 = n6;
            }
            if (n7 == 0) {
                object = nSControl.cell().cellSize();
                n7 = (int)Math.ceil(((NSSize)object).height);
            }
            n5 = Math.min(n5, n7);
        }
        super.setBounds(n2, n3, n4, n5, bl2, bl3);
    }

    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        this.updateItems();
    }

    void setForeground(double[] dArray) {
        super.setForeground(dArray);
        this.updateItems();
        if ((this.style & 8) == 0) {
            NSColor nSColor = dArray == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], 1.0);
            ((NSTextField)this.view).setTextColor(nSColor);
        }
    }

    public void setItem(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = this.getSelectionIndex();
        NSAttributedString nSAttributedString = this.createString(string);
        this.ignoreSelection = true;
        if ((this.style & 8) != 0) {
            NSMenuItem nSMenuItem = ((NSPopUpButton)this.view).itemAtIndex(n2);
            nSMenuItem.setAttributedTitle(nSAttributedString);
            if (string.length() == 0) {
                nSMenuItem.setTitle(NSString.string());
            }
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            nSComboBox.insertItemWithObjectValue(nSAttributedString, n2);
            nSComboBox.removeItemAtIndex(n2 + 1);
        }
        if (n4 != -1) {
            this.select(n4);
        }
        this.ignoreSelection = false;
    }

    public void setItems(String[] stringArray) {
        int n2;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] != null) continue;
            this.error(5);
        }
        this.removeAll();
        if (stringArray.length == 0) {
            return;
        }
        this.ignoreSelection = true;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            NSAttributedString nSAttributedString = this.createString(stringArray[n2]);
            if ((this.style & 8) != 0) {
                NSMenu nSMenu = ((NSPopUpButton)this.view).menu();
                NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
                NSString nSString = NSString.string();
                nSMenuItem.initWithTitle(nSString, 0L, nSString);
                nSMenuItem.setAttributedTitle(nSAttributedString);
                nSMenu.addItem(nSMenuItem);
                nSMenuItem.release();
                ((NSPopUpButton)this.view).selectItemAtIndex(-1L);
                continue;
            }
            ((NSComboBox)this.view).addItemWithObjectValue(nSAttributedString);
        }
        this.ignoreSelection = false;
    }

    public void setListVisible(boolean bl2) {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).setPullsDown(bl2);
        }
    }

    public void setOrientation(int n2) {
        this.checkWidget();
    }

    void setOrientation() {
        int n2 = (this.style & 0x4000000) != 0 ? 1 : 0;
        ((NSControl)this.view).setBaseWritingDirection(n2);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) == 0) {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            NSString nSString = new NSCell(nSComboBox.cell()).title();
            int n2 = (int)nSString.length();
            int n3 = Math.min(Math.max(Math.min(point.x, point.y), 0), n2);
            int n4 = Math.min(Math.max(Math.max(point.x, point.y), 0), n2);
            this.selectionRange = new NSRange();
            this.selectionRange.location = n3;
            this.selectionRange.length = n4 - n3;
            NSText nSText = nSComboBox.currentEditor();
            if (nSText != null) {
                nSText.setSelectedRange(this.selectionRange);
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.setText(string, true);
    }

    void setText(String string, boolean bl2) {
        if (bl2 && (this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 8) != 0) {
            int n2 = this.indexOf(string);
            if (n2 != -1) {
                this.select(n2);
            }
        } else {
            char[] cArray = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, cArray.length, cArray, 0);
            this.text = new String(cArray, 0, cArray.length);
            ((NSComboBox)this.view).cell().setAttributedStringValue(this.createString(this.text));
            if (bl2) {
                this.sendEvent(24);
            }
        }
        this.selectionRange = null;
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        if (n2 == 0) {
            this.error(7);
        }
        this.textLimit = n2;
    }

    public void setVisibleItemCount(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if ((this.style & 8) == 0) {
            ((NSComboBox)this.view).setNumberOfVisibleItems(n2);
        }
    }

    boolean shouldChangeTextInRange_replacementString(long l2, long l3, long l4, long l5) {
        NSObject nSObject;
        Object object;
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, l4, (long)NSRange.sizeof);
        boolean bl2 = this.callSuperBoolean(l2, l3, nSRange, l5);
        if (this.hooks(25)) {
            String string;
            object = new NSString(l5).getString();
            nSObject = this.display.application.currentEvent();
            long l6 = ((NSEvent)nSObject).type();
            if (l6 != 10L && l6 != 11L) {
                nSObject = null;
            }
            if ((string = this.verifyText((String)object, (int)nSRange.location, (int)(nSRange.location + nSRange.length), (NSEvent)nSObject)) == null) {
                return false;
            }
            if (!((String)object).equals(string)) {
                int n2;
                int n3 = string.length();
                Point point = this.getSelection();
                if (this.textLimit != LIMIT && (n2 = this.getCharCount()) - (point.y - point.x) + n3 > this.textLimit) {
                    n3 = this.textLimit - n2 + (point.y - point.x);
                }
                char[] cArray = new char[n3];
                string.getChars(0, cArray.length, cArray, 0);
                NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
                NSText nSText = ((NSTextField)this.view).currentEditor();
                nSText.replaceCharactersInRange(nSText.selectedRange(), nSString);
                this.text = nSText.string().getString();
                this.sendEvent(24);
                bl2 = false;
            }
        }
        if (bl2) {
            object = new char[this.text.length()];
            this.text.getChars(0, ((Object)object).length, (char[])object, 0);
            nSObject = (NSMutableString)NSMutableString.stringWithCharacters((char[])object, ((Object)object).length);
            ((NSMutableString)nSObject).replaceCharactersInRange(nSRange, new NSString(l5));
            this.text = ((NSString)nSObject).getString();
            this.selectionRange = null;
        }
        return bl2;
    }

    void textViewDidChangeSelection(long l2, long l3, long l4) {
        NSNotification nSNotification = new NSNotification(l4);
        NSText nSText = new NSText(nSNotification.object().id);
        this.selectionRange = nSText.selectedRange();
    }

    void textDidChange(long l2, long l3, long l4) {
        super.textDidChange(l2, l3, l4);
        this.postEvent(24);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long l2, long l3, long l4, long l5, long l6) {
        if (this.receivingFocus && this.selectionRange != null) {
            return this.selectionRange;
        }
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, l6, (long)NSRange.sizeof);
        return nSRange;
    }

    void updateItems() {
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            int n2 = (int)nSPopUpButton.numberOfItems();
            for (int i2 = 0; i2 < n2; ++i2) {
                NSMenuItem nSMenuItem = new NSMenuItem(nSPopUpButton.itemAtIndex(i2));
                NSAttributedString nSAttributedString = nSMenuItem.attributedTitle();
                String string = nSAttributedString.string().getString();
                nSMenuItem.setAttributedTitle(this.createString(string));
            }
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            int n3 = (int)nSComboBox.numberOfItems();
            for (int i3 = 0; i3 < n3; ++i3) {
                NSAttributedString nSAttributedString = new NSAttributedString(nSComboBox.itemObjectValueAtIndex(i3));
                String string = nSAttributedString.string().getString();
                nSComboBox.insertItemWithObjectValue(this.createString(string), i3);
                nSComboBox.removeItemAtIndex(i3 + 1);
            }
            nSComboBox.cell().setAttributedStringValue(this.createString(this.text));
        }
    }

    String verifyText(String string, int n2, int n3, NSEvent nSEvent) {
        Event event = new Event();
        if (nSEvent != null) {
            this.setKeyState(event, 3, nSEvent);
        }
        event.text = string;
        event.start = n2;
        event.end = n3;
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

