/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSOpenGLContext;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;
    NSOpenGLContext glcontext;
    NSBezierPath visiblePath;
    static NSMutableArray supportedPboardTypes = NSMutableArray.arrayWithCapacity(1L);

    Canvas() {
    }

    long attributedSubstringFromRange(long l2, long l3, long l4) {
        if (this.ime != null) {
            return this.ime.attributedSubstringFromRange(l2, l3, l4);
        }
        return super.attributedSubstringFromRange(l2, l3, l4);
    }

    void sendFocusEvent(int n2) {
        if (this.caret != null) {
            if (n2 == 15) {
                this.caret.setFocus();
            } else {
                this.caret.killFocus();
            }
        }
        super.sendFocusEvent(n2);
    }

    public Canvas(Composite composite, int n2) {
        super(composite, n2);
    }

    long characterIndexForPoint(long l2, long l3, long l4) {
        if (this.ime != null) {
            return this.ime.characterIndexForPoint(l2, l3, l4);
        }
        return super.characterIndexForPoint(l2, l3, l4);
    }

    public void drawBackground(GC gC, int n2, int n3, int n4, int n5) {
        this.drawBackground(gC, n2, n3, n4, n5, 0, 0);
    }

    void drawBackground(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        super.drawBackground(l2, nSGraphicsContext, nSRect);
        if (this.glcontext != null) {
            if (this.isObscured()) {
                this.glcontext.setValues(new int[]{-1}, 235);
                nSGraphicsContext.saveGraphicsState();
                nSGraphicsContext.setCompositingOperation(0L);
                if (this.visiblePath == null) {
                    long l3 = this.getVisibleRegion();
                    this.visiblePath = this.getPath(l3);
                    OS.DisposeRgn(l3);
                }
                this.visiblePath.addClip();
                NSBezierPath.fillRect(nSRect);
                nSGraphicsContext.restoreGraphicsState();
            } else {
                this.glcontext.setValues(new int[]{1}, 235);
            }
        }
    }

    void drawRect(long l2, long l3, NSRect nSRect) {
        if (this.glcontext != null && this.glcontext.view() == null) {
            this.glcontext.setView(this.view);
        }
        super.drawRect(l2, l3, nSRect);
    }

    void drawWidget(long l2, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l2 != this.view.id) {
            return;
        }
        super.drawWidget(l2, nSGraphicsContext, nSRect);
        if (this.caret == null) {
            return;
        }
        if (this.caret.isShowing) {
            long l3 = nSGraphicsContext.graphicsPort();
            OS.CGContextSaveGState(l3);
            OS.CGContextSetBlendMode(l3, 10);
            Image image = this.caret.image;
            if (image != null) {
                NSImage nSImage = image.handle;
                NSImageRep nSImageRep = nSImage.bestRepresentationForDevice(null);
                if (!nSImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                    return;
                }
                NSBitmapImageRep nSBitmapImageRep = new NSBitmapImageRep(nSImageRep);
                CGRect cGRect = new CGRect();
                cGRect.origin.x = this.caret.x;
                cGRect.origin.y = this.caret.y;
                NSSize nSSize = nSImage.size();
                cGRect.size.width = nSSize.width;
                cGRect.size.height = nSSize.height;
                long l4 = nSBitmapImageRep.bitmapData();
                long l5 = nSBitmapImageRep.bitmapFormat();
                long l6 = nSBitmapImageRep.bytesPerRow();
                int n2 = nSBitmapImageRep.hasAlpha() ? ((l5 & 1L) != 0L ? 4 : 3) : ((l5 & 1L) != 0L ? 6 : 5);
                long l7 = OS.CGDataProviderCreateWithData(0L, l4, l6 * (long)((int)nSSize.height), 0L);
                long l8 = OS.CGColorSpaceCreateDeviceRGB();
                long l9 = OS.CGImageCreate((int)nSSize.width, (int)nSSize.height, nSBitmapImageRep.bitsPerSample(), nSBitmapImageRep.bitsPerPixel(), l6, l8, n2, l7, 0L, true, 0);
                OS.CGColorSpaceRelease(l8);
                OS.CGDataProviderRelease(l7);
                OS.CGContextScaleCTM(l3, 1.0, -1.0);
                OS.CGContextTranslateCTM(l3, 0.0, -(nSSize.height + 2.0 * cGRect.origin.y));
                OS.CGContextSetBlendMode(l3, 10);
                OS.CGContextDrawImage(l3, cGRect, l9);
                OS.CGImageRelease(l9);
            } else {
                CGRect cGRect = new CGRect();
                cGRect.origin.x = this.caret.x;
                cGRect.origin.y = this.caret.y;
                cGRect.size.width = this.caret.width != 0 ? (double)this.caret.width : 1.0;
                cGRect.size.height = this.caret.height;
                long l10 = OS.CGColorSpaceCreateDeviceRGB();
                OS.CGContextSetFillColorSpace(l3, l10);
                OS.CGColorSpaceRelease(l10);
                OS.CGContextSetFillColor(l3, new double[]{1.0, 1.0, 1.0, 1.0});
                OS.CGContextFillRect(l3, cGRect);
            }
            OS.CGContextRestoreGState(l3);
        }
    }

    NSRect firstRectForCharacterRange(long l2, long l3, long l4) {
        if (this.ime != null) {
            return this.ime.firstRectForCharacterRange(l2, l3, l4);
        }
        return super.firstRectForCharacterRange(l2, l3, l4);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    boolean hasMarkedText(long l2, long l3) {
        if (this.ime != null) {
            return this.ime.hasMarkedText(l2, l3);
        }
        return super.hasMarkedText(l2, l3);
    }

    boolean imeInComposition() {
        return this.ime != null && this.ime.isInlineEnabled() && this.ime.startOffset != -1;
    }

    boolean insertText(long l2, long l3, long l4) {
        if (this.ime != null && !this.ime.insertText(l2, l3, l4)) {
            return false;
        }
        return super.insertText(l2, l3, l4);
    }

    boolean isOpaque(long l2, long l3) {
        if (this.glcontext != null) {
            return true;
        }
        return super.isOpaque(l2, l3);
    }

    NSRange markedRange(long l2, long l3) {
        if (this.ime != null) {
            return this.ime.markedRange(l2, l3);
        }
        return super.markedRange(l2, l3);
    }

    boolean readSelectionFromPasteboard(long l2, long l3, long l4) {
        boolean bl2 = false;
        NSPasteboard nSPasteboard = new NSPasteboard(l4);
        NSArray nSArray = nSPasteboard.types();
        for (long i2 = 0L; i2 < supportedPboardTypes.count() && !bl2; ++i2) {
            NSString nSString = new NSString(supportedPboardTypes.objectAtIndex(i2));
            if (!nSArray.containsObject(nSString)) continue;
            bl2 = this.readSelectionFromPasteboard(nSPasteboard, nSString);
        }
        return bl2;
    }

    boolean readSelectionFromPasteboard(NSPasteboard nSPasteboard, NSString nSString) {
        Object object;
        boolean bl2 = false;
        Object object2 = null;
        if (nSString.isEqualToString(OS.NSStringPboardType) && (object = nSPasteboard.stringForType(OS.NSStringPboardType)) != null && ((NSString)object).length() > 0L) {
            object2 = object;
        }
        if (object2 != null) {
            object = this.getAccessible();
            ((Accessible)object).internal_accessibilitySetValue_forAttribute((id)object2, OS.NSAccessibilitySelectedTextAttribute, -1);
            bl2 = true;
        }
        return bl2;
    }

    void releaseChildren(boolean bl2) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl2);
    }

    void reskinChildren(int n2) {
        if (this.caret != null) {
            this.caret.reskin(n2);
        }
        if (this.ime != null) {
            this.ime.reskin(n2);
        }
        super.reskinChildren(n2);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    void resetVisibleRegion() {
        super.resetVisibleRegion();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    public void scroll(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        Object object;
        Control[] controlArray;
        Control control;
        boolean bl3;
        Rectangle rectangle;
        Rectangle rectangle2;
        boolean bl4;
        this.checkWidget();
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        int n8 = n2 - n4;
        int n9 = n3 - n5;
        if (n8 == 0 && n9 == 0) {
            return;
        }
        if (!this.isDrawing()) {
            return;
        }
        NSRect nSRect = this.view.visibleRect();
        if (nSRect.width <= 0.0 || nSRect.height <= 0.0) {
            return;
        }
        boolean bl5 = bl4 = this.caret != null && this.caret.isFocusCaret();
        if (bl4) {
            this.caret.killFocus();
        }
        if ((rectangle2 = new Rectangle(n4, n5, n6, n7)).intersects(rectangle = this.getClientArea())) {
            this.getShell().setScrolling();
            this.update(bl2);
        }
        boolean bl6 = bl3 = (control = this.findBackgroundControl()) != null && control.backgroundImage != null;
        if (!bl3) {
            bl3 = this.hasRegion();
        }
        if (!bl3) {
            bl3 = this.isObscured();
        }
        if (bl3) {
            this.redrawWidget(this.view, n4, n5, n6, n7, false);
            this.redrawWidget(this.view, n2, n3, n6, n7, false);
        } else {
            boolean bl7;
            controlArray = new NSRect();
            controlArray.x = n4;
            controlArray.y = n5;
            controlArray.width = n6;
            controlArray.height = n7;
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n2;
            nSPoint.y = n3;
            this.view.lockFocus();
            OS.NSCopyBits(0L, (NSRect)controlArray, nSPoint);
            this.view.unlockFocus();
            boolean bl8 = bl7 = n2 + n6 < n4 || n4 + n6 < n2 || n3 + n7 < n5 || n5 + n7 < n3;
            if (bl7) {
                this.view.setNeedsDisplayInRect((NSRect)controlArray);
            } else {
                int n10;
                if (n8 != 0) {
                    n10 = n2 - n8;
                    if (n8 < 0) {
                        n10 = n2 + n6;
                    }
                    controlArray.x = n10;
                    controlArray.width = Math.abs(n8);
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (n9 != 0) {
                    n10 = n3 - n9;
                    if (n9 < 0) {
                        n10 = n3 + n7;
                    }
                    controlArray.x = n4;
                    controlArray.y = n10;
                    controlArray.width = n6;
                    controlArray.height = Math.abs(n9);
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
            }
            object = new NSRect();
            ((NSRect)object).x = rectangle2.x;
            ((NSRect)object).y = rectangle2.y;
            ((NSRect)object).width = rectangle2.width;
            ((NSRect)object).height = rectangle2.height;
            OS.NSIntersectionRect(nSRect, nSRect, (NSRect)object);
            if (!OS.NSEqualRects(nSRect, (NSRect)object)) {
                if (((NSRect)object).x != nSRect.x) {
                    controlArray.x = ((NSRect)object).x + (double)n8;
                    controlArray.y = ((NSRect)object).y + (double)n9;
                    controlArray.width = nSRect.x - ((NSRect)object).x;
                    controlArray.height = ((NSRect)object).height;
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (nSRect.x + nSRect.width != ((NSRect)object).x + ((NSRect)object).width) {
                    controlArray.x = ((NSRect)object).x + nSRect.width + (double)n8;
                    controlArray.y = ((NSRect)object).y + (double)n9;
                    controlArray.width = ((NSRect)object).width - nSRect.width;
                    controlArray.height = ((NSRect)object).height;
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (nSRect.y != ((NSRect)object).y) {
                    controlArray.x = nSRect.x + (double)n8;
                    controlArray.y = ((NSRect)object).y + (double)n9;
                    controlArray.width = nSRect.width;
                    controlArray.height = nSRect.y - ((NSRect)object).y;
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (nSRect.y + nSRect.height != ((NSRect)object).y + ((NSRect)object).height) {
                    controlArray.x = nSRect.x + (double)n8;
                    controlArray.y = nSRect.y + nSRect.height + (double)n9;
                    controlArray.width = nSRect.width;
                    controlArray.height = ((NSRect)object).y + ((NSRect)object).height - (nSRect.y + nSRect.height);
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
            }
        }
        if (bl2) {
            controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Control control2 = controlArray[i2];
                object = control2.getBounds();
                if (Math.min(n4 + n6, ((Rectangle)object).x + ((Rectangle)object).width) < Math.max(n4, ((Rectangle)object).x) || Math.min(n5 + n7, ((Rectangle)object).y + ((Rectangle)object).height) < Math.max(n5, ((Rectangle)object).y)) continue;
                control2.setLocation(((Rectangle)object).x + n8, ((Rectangle)object).y + n9);
            }
        }
        if (bl4) {
            this.caret.setFocus();
        }
    }

    NSRange selectedRange(long l2, long l3) {
        if (this.ime != null) {
            return this.ime.selectedRange(l2, l3);
        }
        return super.selectedRange(l2, l3);
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n2) {
        if (this.caret != null) {
            NSCursor.setHiddenUntilMouseMoves(true);
        }
        return super.sendKeyEvent(nSEvent, n2);
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    void setOpenGLContext(Object object) {
        this.glcontext = (NSOpenGLContext)object;
        Shell shell = this.getShell();
        shell.glContextCount = this.glcontext != null ? ++shell.glContextCount : --shell.glContextCount;
        shell.updateOpaque();
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }

    boolean setMarkedText_selectedRange(long l2, long l3, long l4, long l5) {
        if (this.ime != null && !this.ime.setMarkedText_selectedRange(l2, l3, l4, l5)) {
            return false;
        }
        return super.setMarkedText_selectedRange(l2, l3, l4, l5);
    }

    long validAttributesForMarkedText(long l2, long l3) {
        if (this.ime != null) {
            return this.ime.validAttributesForMarkedText(l2, l3);
        }
        return super.validAttributesForMarkedText(l2, l3);
    }

    long validRequestorForSendType(long l2, long l3, long l4, long l5) {
        NSArray nSArray;
        Accessible accessible;
        if (l2 == this.view.id && (accessible = this.getAccessible()) != null && (nSArray = accessible.internal_accessibilityAttributeNames(-1)) != null) {
            NSString nSString;
            id id2;
            boolean bl2;
            boolean bl3 = nSArray.containsObject(OS.NSAccessibilitySelectedTextAttribute);
            boolean bl4 = accessible.internal_accessibilityIsAttributeSettable(OS.NSAccessibilitySelectedTextAttribute, -1);
            boolean bl5 = bl2 = supportedPboardTypes.containsObject(new id(l4)) && supportedPboardTypes.containsObject(new id(l5));
            if (bl3 && bl4 && bl2 && (id2 = accessible.internal_accessibilityAttributeValue(OS.NSAccessibilitySelectedTextAttribute, -1)) != null && (nSString = new NSString(id2)).length() > 0L) {
                return this.view.id;
            }
        }
        return super.validRequestorForSendType(l2, l3, l4, l5);
    }

    void updateOpenGLContext(long l2, long l3, long l4) {
        if (this.glcontext != null) {
            this.glcontext.update();
        }
    }

    void viewWillMoveToWindow(long l2, long l3, long l4) {
        super.viewWillMoveToWindow(l2, l3, l4);
        if (this.glcontext != null && l2 == this.view.id && l4 != 0L) {
            Widget widget = this.display.getWidget(new NSWindow(l4).contentView());
            if (widget instanceof Shell) {
                ++((Shell)widget).glContextCount;
                ((Shell)widget).updateOpaque();
            }
            Shell shell = this.getShell();
            --shell.glContextCount;
            shell.updateOpaque();
        }
    }

    boolean writeSelectionToPasteboard(long l2, long l3, long l4, long l5) {
        NSString nSString;
        long l6;
        boolean bl2 = false;
        NSPasteboard nSPasteboard = new NSPasteboard(l4);
        NSArray nSArray = new NSArray(l5);
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(2L);
        for (l6 = 0L; l6 < supportedPboardTypes.count(); ++l6) {
            nSString = new NSString(supportedPboardTypes.objectAtIndex(l6));
            if (!nSArray.containsObject(nSString)) continue;
            nSMutableArray.addObject(nSString);
        }
        if (nSMutableArray.count() > 0L) {
            nSPasteboard.declareTypes(nSMutableArray, this.view);
            for (l6 = 0L; l6 < nSMutableArray.count(); ++l6) {
                nSString = new NSString(nSMutableArray.objectAtIndex(l6));
                if (!this.writeSelectionToPasteboard(nSPasteboard, nSString)) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    boolean writeSelectionToPasteboard(NSPasteboard nSPasteboard, NSString nSString) {
        NSString nSString2;
        Accessible accessible;
        id id2;
        boolean bl2 = false;
        if (nSString.isEqualToString(OS.NSStringPboardType) && (id2 = (accessible = this.getAccessible()).internal_accessibilityAttributeValue(OS.NSAccessibilitySelectedTextAttribute, -1)) != null && (nSString2 = new NSString(id2)).length() > 0L) {
            bl2 = nSPasteboard.setString(nSString2, OS.NSStringPboardType);
        }
        return bl2;
    }

    static {
        supportedPboardTypes.retain();
        supportedPboardTypes.addObject(OS.NSStringPboardType);
    }
}

