/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class RowLayout
extends Layout {
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 3;
    public boolean wrap = true;
    public boolean pack = true;
    public boolean fill = false;
    public boolean center = false;
    public boolean justify = false;
    public int marginLeft = 3;
    public int marginTop = 3;
    public int marginRight = 3;
    public int marginBottom = 3;

    public RowLayout() {
    }

    public RowLayout(int n2) {
        this.type = n2;
    }

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl2) {
        Point point = this.type == 256 ? this.layoutHorizontal(composite, false, n2 != -1 && this.wrap, n2, bl2) : this.layoutVertical(composite, false, n3 != -1 && this.wrap, n3, bl2);
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        return point;
    }

    Point computeSize(Control control, boolean bl2) {
        int n2 = -1;
        int n3 = -1;
        RowData rowData = (RowData)control.getLayoutData();
        if (rowData != null) {
            n2 = rowData.width;
            n3 = rowData.height;
        }
        return control.computeSize(n2, n3, bl2);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    protected void layout(Composite composite, boolean bl2) {
        Rectangle rectangle = composite.getClientArea();
        if (this.type == 256) {
            this.layoutHorizontal(composite, true, this.wrap, rectangle.width, bl2);
        } else {
            this.layoutVertical(composite, true, this.wrap, rectangle.height, bl2);
        }
    }

    Point layoutHorizontal(Composite composite, boolean bl2, boolean bl3, int n2, boolean bl4) {
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        Control[] controlArray = composite.getChildren();
        int n7 = 0;
        for (n6 = 0; n6 < controlArray.length; ++n6) {
            Control control = controlArray[n6];
            RowData rowData = (RowData)control.getLayoutData();
            if (rowData != null && rowData.exclude) continue;
            controlArray[n7++] = controlArray[n6];
        }
        if (n7 == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        n6 = 0;
        int n8 = 0;
        int n9 = 0;
        if (!this.pack) {
            for (n5 = 0; n5 < n7; ++n5) {
                Control control = controlArray[n5];
                object = this.computeSize(control, bl4);
                n6 = Math.max(n6, ((Point)object).x);
                n8 = Math.max(n8, ((Point)object).y);
            }
            n9 = n8;
        }
        n5 = 0;
        int n10 = 0;
        if (bl2) {
            object = composite.getClientArea();
            n5 = ((Rectangle)object).x;
            n10 = ((Rectangle)object).y;
        }
        object = null;
        boolean bl5 = false;
        Rectangle[] rectangleArray = null;
        if (bl2 && (this.justify || this.fill || this.center)) {
            rectangleArray = new Rectangle[n7];
            object = new int[n7];
        }
        int n11 = 0;
        int n12 = this.marginLeft + this.marginWidth;
        int n13 = this.marginTop + this.marginHeight;
        for (n4 = 0; n4 < n7; ++n4) {
            Control control = controlArray[n4];
            if (this.pack) {
                Point point = this.computeSize(control, bl4);
                n6 = point.x;
                n8 = point.y;
            }
            if (bl3 && n4 != 0 && n12 + n6 > n2) {
                bl5 = true;
                if (bl2 && (this.justify || this.fill || this.center)) {
                    object[n4 - 1] = n9;
                }
                n12 = this.marginLeft + this.marginWidth;
                n13 += this.spacing + n9;
                if (this.pack) {
                    n9 = 0;
                }
            }
            if (this.pack || this.fill || this.center) {
                n9 = Math.max(n9, n8);
            }
            if (bl2) {
                int n14 = n12 + n5;
                n3 = n13 + n10;
                if (this.justify || this.fill || this.center) {
                    rectangleArray[n4] = new Rectangle(n14, n3, n6, n8);
                } else {
                    control.setBounds(n14, n3, n6, n8);
                }
            }
            n11 = Math.max(n11, n12 += this.spacing + n6);
        }
        n11 = Math.max(n5 + this.marginLeft + this.marginWidth, n11 - this.spacing);
        if (!bl5) {
            n11 += this.marginRight + this.marginWidth;
        }
        if (bl2 && (this.justify || this.fill || this.center)) {
            n4 = 0;
            int n15 = 0;
            if (!bl5) {
                n4 = Math.max(0, (n2 - n11) / (n7 + 1));
                n15 = Math.max(0, (n2 - n11) % (n7 + 1) / 2);
            } else if (this.fill || this.justify || this.center) {
                int n16 = 0;
                if (n7 > 0) {
                    object[n7 - 1] = n9;
                }
                for (n3 = 0; n3 < n7; ++n3) {
                    int n17;
                    if (object[n3] == false) continue;
                    int n18 = n3 - n16 + 1;
                    if (this.justify) {
                        n17 = 0;
                        for (int i2 = n16; i2 <= n3; ++i2) {
                            n17 += rectangleArray[i2].width + this.spacing;
                        }
                        n4 = Math.max(0, (n2 - n17) / (n18 + 1));
                        n15 = Math.max(0, (n2 - n17) % (n18 + 1) / 2);
                    }
                    for (n17 = n16; n17 <= n3; ++n17) {
                        if (this.justify) {
                            rectangleArray[n17].x += n4 * (n17 - n16 + 1) + n15;
                        }
                        if (this.fill) {
                            rectangleArray[n17].height = (int)object[n3];
                            continue;
                        }
                        if (!this.center) continue;
                        rectangleArray[n17].y += Math.max(0, (int)((object[n3] - rectangleArray[n17].height) / 2));
                    }
                    n16 = n3 + 1;
                }
            }
            for (int i3 = 0; i3 < n7; ++i3) {
                if (!bl5) {
                    if (this.justify) {
                        rectangleArray[i3].x += n4 * (i3 + 1) + n15;
                    }
                    if (this.fill) {
                        rectangleArray[i3].height = n9;
                    } else if (this.center) {
                        rectangleArray[i3].y += Math.max(0, (n9 - rectangleArray[i3].height) / 2);
                    }
                }
                controlArray[i3].setBounds(rectangleArray[i3]);
            }
        }
        return new Point(n11, n13 + n9 + this.marginBottom + this.marginHeight);
    }

    Point layoutVertical(Composite composite, boolean bl2, boolean bl3, int n2, boolean bl4) {
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        Control[] controlArray = composite.getChildren();
        int n7 = 0;
        for (n6 = 0; n6 < controlArray.length; ++n6) {
            Control control = controlArray[n6];
            RowData rowData = (RowData)control.getLayoutData();
            if (rowData != null && rowData.exclude) continue;
            controlArray[n7++] = controlArray[n6];
        }
        if (n7 == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        n6 = 0;
        int n8 = 0;
        int n9 = 0;
        if (!this.pack) {
            for (n5 = 0; n5 < n7; ++n5) {
                Control control = controlArray[n5];
                object = this.computeSize(control, bl4);
                n6 = Math.max(n6, ((Point)object).x);
                n8 = Math.max(n8, ((Point)object).y);
            }
            n9 = n6;
        }
        n5 = 0;
        int n10 = 0;
        if (bl2) {
            object = composite.getClientArea();
            n5 = ((Rectangle)object).x;
            n10 = ((Rectangle)object).y;
        }
        object = null;
        boolean bl5 = false;
        Rectangle[] rectangleArray = null;
        if (bl2 && (this.justify || this.fill || this.center)) {
            rectangleArray = new Rectangle[n7];
            object = new int[n7];
        }
        int n11 = 0;
        int n12 = this.marginLeft + this.marginWidth;
        int n13 = this.marginTop + this.marginHeight;
        for (n4 = 0; n4 < n7; ++n4) {
            Control control = controlArray[n4];
            if (this.pack) {
                Point point = this.computeSize(control, bl4);
                n6 = point.x;
                n8 = point.y;
            }
            if (bl3 && n4 != 0 && n13 + n8 > n2) {
                bl5 = true;
                if (bl2 && (this.justify || this.fill || this.center)) {
                    object[n4 - 1] = n9;
                }
                n12 += this.spacing + n9;
                n13 = this.marginTop + this.marginHeight;
                if (this.pack) {
                    n9 = 0;
                }
            }
            if (this.pack || this.fill || this.center) {
                n9 = Math.max(n9, n6);
            }
            if (bl2) {
                int n14 = n12 + n5;
                n3 = n13 + n10;
                if (this.justify || this.fill || this.center) {
                    rectangleArray[n4] = new Rectangle(n14, n3, n6, n8);
                } else {
                    control.setBounds(n14, n3, n6, n8);
                }
            }
            n11 = Math.max(n11, n13 += this.spacing + n8);
        }
        n11 = Math.max(n10 + this.marginTop + this.marginHeight, n11 - this.spacing);
        if (!bl5) {
            n11 += this.marginBottom + this.marginHeight;
        }
        if (bl2 && (this.justify || this.fill || this.center)) {
            n4 = 0;
            int n15 = 0;
            if (!bl5) {
                n4 = Math.max(0, (n2 - n11) / (n7 + 1));
                n15 = Math.max(0, (n2 - n11) % (n7 + 1) / 2);
            } else if (this.fill || this.justify || this.center) {
                int n16 = 0;
                if (n7 > 0) {
                    object[n7 - 1] = n9;
                }
                for (n3 = 0; n3 < n7; ++n3) {
                    int n17;
                    if (object[n3] == false) continue;
                    int n18 = n3 - n16 + 1;
                    if (this.justify) {
                        n17 = 0;
                        for (int i2 = n16; i2 <= n3; ++i2) {
                            n17 += rectangleArray[i2].height + this.spacing;
                        }
                        n4 = Math.max(0, (n2 - n17) / (n18 + 1));
                        n15 = Math.max(0, (n2 - n17) % (n18 + 1) / 2);
                    }
                    for (n17 = n16; n17 <= n3; ++n17) {
                        if (this.justify) {
                            rectangleArray[n17].y += n4 * (n17 - n16 + 1) + n15;
                        }
                        if (this.fill) {
                            rectangleArray[n17].width = (int)object[n3];
                            continue;
                        }
                        if (!this.center) continue;
                        rectangleArray[n17].x += Math.max(0, (int)((object[n3] - rectangleArray[n17].width) / 2));
                    }
                    n16 = n3 + 1;
                }
            }
            for (int i3 = 0; i3 < n7; ++i3) {
                if (!bl5) {
                    if (this.justify) {
                        rectangleArray[i3].y += n4 * (i3 + 1) + n15;
                    }
                    if (this.fill) {
                        rectangleArray[i3].width = n9;
                    } else if (this.center) {
                        rectangleArray[i3].x += Math.max(0, (n9 - rectangleArray[i3].width) / 2);
                    }
                }
                controlArray[i3].setBounds(rectangleArray[i3]);
            }
        }
        return new Point(n12 + n9 + this.marginRight + this.marginWidth, n11);
    }

    public String toString() {
        String string = this.getName() + " {";
        string = string + "type=" + (this.type != 256 ? "SWT.VERTICAL" : "SWT.HORIZONTAL") + " ";
        if (this.marginWidth != 0) {
            string = string + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = string + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string = string + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginTop != 0) {
            string = string + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginRight != 0) {
            string = string + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginBottom != 0) {
            string = string + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.spacing != 0) {
            string = string + "spacing=" + this.spacing + " ";
        }
        string = string + "wrap=" + this.wrap + " ";
        string = string + "pack=" + this.pack + " ";
        string = string + "fill=" + this.fill + " ";
        string = string + "justify=" + this.justify + " ";
        string = string.trim();
        string = string + "}";
        return string;
    }
}

