/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class FillLayout
extends Layout {
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 0;

    public FillLayout() {
    }

    public FillLayout(int n2) {
        this.type = n2;
    }

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl2) {
        int n4;
        Control[] controlArray = composite.getChildren();
        int n5 = controlArray.length;
        int n6 = 0;
        int n7 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            Control control = controlArray[n4];
            int n8 = n2;
            int n9 = n3;
            if (n5 > 0) {
                if (this.type == 256 && n2 != -1) {
                    n8 = Math.max(0, (n2 - (n5 - 1) * this.spacing) / n5);
                }
                if (this.type == 512 && n3 != -1) {
                    n9 = Math.max(0, (n3 - (n5 - 1) * this.spacing) / n5);
                }
            }
            Point point = this.computeChildSize(control, n8, n9, bl2);
            n6 = Math.max(n6, point.x);
            n7 = Math.max(n7, point.y);
        }
        n4 = 0;
        int n10 = 0;
        if (this.type == 256) {
            n4 = n5 * n6;
            if (n5 != 0) {
                n4 += (n5 - 1) * this.spacing;
            }
            n10 = n7;
        } else {
            n4 = n6;
            n10 = n5 * n7;
            if (n5 != 0) {
                n10 += (n5 - 1) * this.spacing;
            }
        }
        n4 += this.marginWidth * 2;
        n10 += this.marginHeight * 2;
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n10 = n3;
        }
        return new Point(n4, n10);
    }

    Point computeChildSize(Control control, int n2, int n3, boolean bl2) {
        FillData fillData = (FillData)control.getLayoutData();
        if (fillData == null) {
            fillData = new FillData();
            control.setLayoutData(fillData);
        }
        Point point = null;
        if (n2 == -1 && n3 == -1) {
            point = fillData.computeSize(control, n2, n3, bl2);
        } else {
            int n4;
            int n5;
            if (control instanceof Scrollable) {
                Rectangle rectangle = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                n5 = rectangle.width;
                n4 = rectangle.height;
            } else {
                n5 = n4 = control.getBorderWidth() * 2;
            }
            int n6 = n2 == -1 ? n2 : Math.max(0, n2 - n5);
            int n7 = n3 == -1 ? n3 : Math.max(0, n3 - n4);
            point = fillData.computeSize(control, n6, n7, bl2);
        }
        return point;
    }

    protected boolean flushCache(Control control) {
        Object object = control.getLayoutData();
        if (object != null) {
            ((FillData)object).flushCache();
        }
        return true;
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    protected void layout(Composite composite, boolean bl2) {
        Rectangle rectangle = composite.getClientArea();
        Control[] controlArray = composite.getChildren();
        int n2 = controlArray.length;
        if (n2 == 0) {
            return;
        }
        int n3 = rectangle.width - this.marginWidth * 2;
        int n4 = rectangle.height - this.marginHeight * 2;
        if (this.type == 256) {
            int n5 = rectangle.x + this.marginWidth;
            int n6 = (n3 -= (n2 - 1) * this.spacing) % n2;
            int n7 = rectangle.y + this.marginHeight;
            int n8 = n3 / n2;
            for (int i2 = 0; i2 < n2; ++i2) {
                Control control = controlArray[i2];
                int n9 = n8;
                if (i2 == 0) {
                    n9 += n6 / 2;
                } else if (i2 == n2 - 1) {
                    n9 += (n6 + 1) / 2;
                }
                control.setBounds(n5, n7, n9, n4);
                n5 += n9 + this.spacing;
            }
        } else {
            int n10 = rectangle.x + this.marginWidth;
            int n11 = (n4 -= (n2 - 1) * this.spacing) / n2;
            int n12 = rectangle.y + this.marginHeight;
            int n13 = n4 % n2;
            for (int i3 = 0; i3 < n2; ++i3) {
                Control control = controlArray[i3];
                int n14 = n11;
                if (i3 == 0) {
                    n14 += n13 / 2;
                } else if (i3 == n2 - 1) {
                    n14 += (n13 + 1) / 2;
                }
                control.setBounds(n10, n12, n3, n14);
                n12 += n14 + this.spacing;
            }
        }
    }

    public String toString() {
        String string = this.getName() + " {";
        string = string + "type=" + (this.type == 512 ? "SWT.VERTICAL" : "SWT.HORIZONTAL") + " ";
        if (this.marginWidth != 0) {
            string = string + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = string + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.spacing != 0) {
            string = string + "spacing=" + this.spacing + " ";
        }
        string = string.trim();
        string = string + "}";
        return string;
    }
}

