/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.mozilla;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIInterfaceInfo;
import org.eclipse.swt.internal.mozilla.nsIInterfaceInfoManager;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;

public class nsISupports {
    static final boolean IsSolaris;
    static final int FIRST_METHOD_ID;
    static final int LAST_METHOD_ID;
    public static final String NS_ISUPPORTS_IID_STR = "00000000-0000-0000-c000-000000000046";
    long address;

    protected static boolean IsXULRunner10() {
        return MozillaVersion.CheckVersion(5, true);
    }

    protected static boolean IsXULRunner24() {
        return MozillaVersion.CheckVersion(6, true);
    }

    protected static boolean IsXULRunner31() {
        return MozillaVersion.CheckVersion(7, true);
    }

    protected static boolean IsXULRVersionOrLater(int n2) {
        return MozillaVersion.CheckVersion(n2, false);
    }

    private static byte[] toByteArray(String string) {
        byte[] byArray = new byte[string.length() + 1];
        int n2 = string.length();
        while (n2-- > 0) {
            byArray[n2] = (byte)string.charAt(n2);
        }
        return byArray;
    }

    protected int getGetterIndex(String string) {
        return this.getMethodIndex(string);
    }

    protected int getSetterIndex(String string) {
        return this.getMethodIndex(string) + 1;
    }

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    protected int getMethodIndex(String string) {
        long[] lArray = new long[]{0L};
        int n2 = XPCOM.NS_GetServiceManager(lArray);
        if (n2 != 0) {
            throw new SWTError(n2);
        }
        nsIServiceManager nsIServiceManager2 = new nsIServiceManager(lArray[0]);
        lArray[0] = 0L;
        n2 = nsIServiceManager2.GetServiceByContractID(nsISupports.toByteArray("@mozilla.org/xpti/interfaceinfomanager-service;1"), IIDStore.GetIID(nsIInterfaceInfoManager.class), lArray);
        nsIServiceManager2.Release();
        if (n2 != 0) {
            throw new SWTError(n2);
        }
        nsIInterfaceInfoManager nsIInterfaceInfoManager2 = new nsIInterfaceInfoManager(lArray[0]);
        lArray[0] = 0L;
        n2 = nsIInterfaceInfoManager2.GetInfoForName(nsISupports.toByteArray(this.getClassName()), lArray);
        nsIInterfaceInfoManager2.Release();
        if (n2 != 0) {
            throw new SWTError(n2);
        }
        nsIInterfaceInfo nsIInterfaceInfo2 = new nsIInterfaceInfo(lArray[0]);
        int[] nArray = new int[1];
        long[] lArray2 = new long[1];
        n2 = nsIInterfaceInfo2.GetMethodInfoForName(nsISupports.toByteArray(string), nArray, lArray2);
        nsIInterfaceInfo2.Release();
        if (n2 != 0) {
            throw new SWTError(n2);
        }
        return nArray[0];
    }

    public nsISupports(long l2) {
        this.address = l2;
    }

    public long getAddress() {
        return this.address;
    }

    public int QueryInterface(nsID nsID2, long[] lArray) {
        return XPCOM.VtblCall(FIRST_METHOD_ID, this.getAddress(), nsID2, lArray);
    }

    public int AddRef() {
        return XPCOM.VtblCall(FIRST_METHOD_ID + 1, this.getAddress());
    }

    public int Release() {
        return XPCOM.VtblCall(FIRST_METHOD_ID + 2, this.getAddress());
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        IsSolaris = string.startsWith("sunos") || string.startsWith("solaris");
        FIRST_METHOD_ID = IsSolaris ? 2 : 0;
        LAST_METHOD_ID = FIRST_METHOD_ID + 2;
        IIDStore.RegisterIID(nsISupports.class, 0, new nsID(NS_ISUPPORTS_IID_STR));
    }
}

