/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.PNGFileFormat;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngFileReadState;
import org.eclipse.swt.internal.image.PngIhdrChunk;
import org.eclipse.swt.internal.image.PngPlteChunk;

public class PngTrnsChunk
extends PngChunk {
    static final int TRANSPARENCY_TYPE_PIXEL = 0;
    static final int TRANSPARENCY_TYPE_ALPHAS = 1;
    static final int RGB_DATA_LENGTH = 6;

    PngTrnsChunk(RGB rGB) {
        super(6);
        this.setType(TYPE_tRNS);
        this.setInt16(8, rGB.red);
        this.setInt16(10, rGB.green);
        this.setInt16(12, rGB.blue);
        this.setCRC(this.computeCRC());
    }

    PngTrnsChunk(byte[] byArray) {
        super(byArray);
    }

    int getChunkType() {
        return 5;
    }

    void validateLength(PngIhdrChunk pngIhdrChunk, PngPlteChunk pngPlteChunk) {
        boolean bl2;
        switch (pngIhdrChunk.getColorType()) {
            case 2: {
                bl2 = this.getLength() == 6;
                break;
            }
            case 3: {
                bl2 = this.getLength() <= pngPlteChunk.getLength();
                break;
            }
            case 0: {
                bl2 = this.getLength() == 2;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (!bl2) {
            SWT.error(40);
        }
    }

    void validate(PngFileReadState pngFileReadState, PngIhdrChunk pngIhdrChunk, PngPlteChunk pngPlteChunk) {
        if (!pngFileReadState.readIHDR || pngIhdrChunk.getMustHavePalette() && !pngFileReadState.readPLTE || pngFileReadState.readIDAT || pngFileReadState.readIEND) {
            SWT.error(40);
        } else {
            pngFileReadState.readTRNS = true;
        }
        this.validateLength(pngIhdrChunk, pngPlteChunk);
        super.validate(pngFileReadState, pngIhdrChunk);
    }

    int getTransparencyType(PngIhdrChunk pngIhdrChunk) {
        if (pngIhdrChunk.getColorType() == 3) {
            return 1;
        }
        return 0;
    }

    int getSwtTransparentPixel(PngIhdrChunk pngIhdrChunk) {
        switch (pngIhdrChunk.getColorType()) {
            case 0: {
                int n2 = ((this.reference[8] & 0xFF) << 8) + (this.reference[9] & 0xFF);
                if (pngIhdrChunk.getBitDepth() > 8) {
                    return PNGFileFormat.compress16BitDepthTo8BitDepth(n2);
                }
                return n2 & 0xFF;
            }
            case 2: {
                int n3 = (this.reference[8] & 0xFF) << 8 | this.reference[9] & 0xFF;
                int n4 = (this.reference[10] & 0xFF) << 8 | this.reference[11] & 0xFF;
                int n5 = (this.reference[12] & 0xFF) << 8 | this.reference[13] & 0xFF;
                if (pngIhdrChunk.getBitDepth() > 8) {
                    n3 = PNGFileFormat.compress16BitDepthTo8BitDepth(n3);
                    n4 = PNGFileFormat.compress16BitDepthTo8BitDepth(n4);
                    n5 = PNGFileFormat.compress16BitDepthTo8BitDepth(n5);
                }
                return n3 << 16 | n4 << 8 | n5;
            }
        }
        SWT.error(40);
        return -1;
    }

    byte[] getAlphaValues(PngIhdrChunk pngIhdrChunk, PngPlteChunk pngPlteChunk) {
        if (pngIhdrChunk.getColorType() != 3) {
            SWT.error(40);
        }
        byte[] byArray = new byte[pngPlteChunk.getPaletteSize()];
        int n2 = this.getLength();
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            byArray[n3] = this.reference[8 + n3];
        }
        for (int i2 = n3; i2 < byArray.length; ++i2) {
            byArray[i2] = -1;
        }
        return byArray;
    }
}

