/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.internal.image.PngDecodingDataStream;

public class PngHuffmanTable {
    CodeLengthInfo[] codeLengthInfo;
    int[] codeValues;
    static final int MAX_CODE_LENGTH = 15;
    static final int BAD_CODE = 0xFFFFFFF;
    static final int[] incs = new int[]{1391376, 463792, 198768, 86961, 33936, 13776, 4592, 1968, 861, 336, 112, 48, 21, 7, 3, 1};

    PngHuffmanTable(int[] nArray) {
        this.initialize(nArray);
        this.generateTable(nArray);
    }

    private void initialize(int[] nArray) {
        int n2;
        this.codeValues = new int[nArray.length];
        for (n2 = 0; n2 < this.codeValues.length; ++n2) {
            this.codeValues[n2] = n2;
        }
        this.codeLengthInfo = new CodeLengthInfo[15];
        for (n2 = 0; n2 < 15; ++n2) {
            this.codeLengthInfo[n2] = new CodeLengthInfo();
            this.codeLengthInfo[n2].length = n2;
            this.codeLengthInfo[n2].baseIndex = 0;
            this.codeLengthInfo[n2].min = 0xFFFFFFF;
            this.codeLengthInfo[n2].max = -1;
        }
    }

    private void generateTable(int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        for (int i2 = 0; i2 < 16; ++i2) {
            for (n5 = n4 = incs[i2]; n5 < nArray.length; ++n5) {
                n3 = nArray[n5];
                int n6 = this.codeValues[n5];
                for (n2 = n5; n2 >= n4 && (nArray[n2 - n4] > n3 || nArray[n2 - n4] == n3 && this.codeValues[n2 - n4] > n6); n2 -= n4) {
                    nArray[n2] = nArray[n2 - n4];
                    this.codeValues[n2] = this.codeValues[n2 - n4];
                }
                nArray[n2] = n3;
                this.codeValues[n2] = n6;
            }
        }
        int[] nArray2 = new int[nArray.length];
        n4 = 0;
        n5 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            while (n4 != nArray[n3]) {
                ++n4;
                n5 <<= 1;
            }
            if (n4 == 0) continue;
            nArray2[n3] = n5++;
        }
        n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n3 != nArray[n2]) {
                n3 = nArray[n2];
                this.codeLengthInfo[n3 - 1].baseIndex = n2;
                this.codeLengthInfo[n3 - 1].min = nArray2[n2];
            }
            if (n3 == 0) continue;
            this.codeLengthInfo[n3 - 1].max = nArray2[n2];
        }
    }

    int getNextValue(PngDecodingDataStream pngDecodingDataStream) throws IOException {
        int n2;
        int n3 = pngDecodingDataStream.getNextIdatBit();
        for (n2 = 0; n2 < 15 && n3 > this.codeLengthInfo[n2].max; ++n2) {
            n3 = n3 << 1 | pngDecodingDataStream.getNextIdatBit();
        }
        if (n2 >= 15) {
            pngDecodingDataStream.error();
        }
        int n4 = n3 - this.codeLengthInfo[n2].min;
        int n5 = this.codeLengthInfo[n2].baseIndex + n4;
        return this.codeValues[n5];
    }

    static class CodeLengthInfo {
        int length;
        int max;
        int min;
        int baseIndex;

        CodeLengthInfo() {
        }
    }
}

