/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.image.LEDataOutputStream;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngDeflater;

final class PngEncoder {
    static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    static final byte[] TAG_IHDR = new byte[]{73, 72, 68, 82};
    static final byte[] TAG_PLTE = new byte[]{80, 76, 84, 69};
    static final byte[] TAG_TRNS = new byte[]{116, 82, 78, 83};
    static final byte[] TAG_IDAT = new byte[]{73, 68, 65, 84};
    static final byte[] TAG_IEND = new byte[]{73, 69, 78, 68};
    static final int NO_COMPRESSION = 0;
    static final int BEST_SPEED = 1;
    static final int BEST_COMPRESSION = 9;
    static final int DEFAULT_COMPRESSION = -1;
    ByteArrayOutputStream bytes = new ByteArrayOutputStream(1024);
    PngChunk chunk;
    ImageLoader loader;
    ImageData data;
    int transparencyType;
    int width;
    int height;
    int bitDepth;
    int colorType;
    int compressionMethod = 0;
    int filterMethod = 0;
    int interlaceMethod = 0;

    public PngEncoder(ImageLoader imageLoader) {
        this.loader = imageLoader;
        this.data = imageLoader.data[0];
        this.transparencyType = this.data.getTransparencyType();
        this.width = this.data.width;
        this.height = this.data.height;
        this.bitDepth = 8;
        this.colorType = 2;
        if (this.data.palette.isDirect) {
            if (this.transparencyType == 1) {
                this.colorType = 6;
            }
        } else {
            this.colorType = 3;
        }
        if (this.colorType != 2 && this.colorType != 3 && this.colorType != 6) {
            SWT.error(40);
        }
    }

    void writeShort(ByteArrayOutputStream byteArrayOutputStream, int n2) {
        byte by = (byte)(n2 >> 8 & 0xFF);
        byte by2 = (byte)(n2 & 0xFF);
        byte[] byArray = new byte[]{by, by2};
        byteArrayOutputStream.write(byArray, 0, 2);
    }

    void writeInt(ByteArrayOutputStream byteArrayOutputStream, int n2) {
        byte by = (byte)(n2 >> 24 & 0xFF);
        byte by2 = (byte)(n2 >> 16 & 0xFF);
        byte by3 = (byte)(n2 >> 8 & 0xFF);
        byte by4 = (byte)(n2 & 0xFF);
        byte[] byArray = new byte[]{by, by2, by3, by4};
        byteArrayOutputStream.write(byArray, 0, 4);
    }

    void writeChunk(byte[] byArray, byte[] byArray2) {
        int n2 = byArray2 != null ? byArray2.length : 0;
        this.chunk = new PngChunk(n2);
        this.writeInt(this.bytes, n2);
        this.bytes.write(byArray, 0, 4);
        this.chunk.setType(byArray);
        if (n2 != 0) {
            this.bytes.write(byArray2, 0, n2);
            this.chunk.setData(byArray2);
        } else {
            this.chunk.setCRC(this.chunk.computeCRC());
        }
        this.writeInt(this.bytes, this.chunk.getCRC());
    }

    void writeSignature() {
        this.bytes.write(SIGNATURE, 0, 8);
    }

    void writeHeader() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(13);
        this.writeInt(byteArrayOutputStream, this.width);
        this.writeInt(byteArrayOutputStream, this.height);
        byteArrayOutputStream.write(this.bitDepth);
        byteArrayOutputStream.write(this.colorType);
        byteArrayOutputStream.write(this.compressionMethod);
        byteArrayOutputStream.write(this.filterMethod);
        byteArrayOutputStream.write(this.interlaceMethod);
        this.writeChunk(TAG_IHDR, byteArrayOutputStream.toByteArray());
    }

    void writePalette() {
        RGB[] rGBArray = this.data.palette.getRGBs();
        if (rGBArray.length > 256) {
            SWT.error(40);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(rGBArray.length);
        for (int i2 = 0; i2 < rGBArray.length; ++i2) {
            byteArrayOutputStream.write((byte)rGBArray[i2].red);
            byteArrayOutputStream.write((byte)rGBArray[i2].green);
            byteArrayOutputStream.write((byte)rGBArray[i2].blue);
        }
        this.writeChunk(TAG_PLTE, byteArrayOutputStream.toByteArray());
    }

    void writeTransparency() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        switch (this.transparencyType) {
            case 1: {
                byte[] byArray = new byte[this.data.palette.getRGBs().length];
                for (int i2 = 0; i2 < this.height; ++i2) {
                    for (int i3 = 0; i3 < this.width; ++i3) {
                        int n2 = this.data.getPixel(i3, i2);
                        int n3 = this.data.getAlpha(i3, i2);
                        byArray[n2] = (byte)n3;
                    }
                }
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                break;
            }
            case 4: {
                int n4;
                int n5 = this.data.transparentPixel;
                if (this.colorType == 2) {
                    int n6 = this.data.palette.redMask;
                    n4 = this.data.palette.redShift;
                    int n7 = this.data.palette.greenMask;
                    int n8 = this.data.palette.greenShift;
                    int n9 = this.data.palette.blueShift;
                    int n10 = this.data.palette.blueMask;
                    int n11 = n5 & n6;
                    n11 = n4 < 0 ? n11 >>> -n4 : n11 << n4;
                    int n12 = n5 & n7;
                    n12 = n8 < 0 ? n12 >>> -n8 : n12 << n8;
                    int n13 = n5 & n10;
                    n13 = n9 < 0 ? n13 >>> -n9 : n13 << n9;
                    this.writeShort(byteArrayOutputStream, n11);
                    this.writeShort(byteArrayOutputStream, n12);
                    this.writeShort(byteArrayOutputStream, n13);
                }
                if (this.colorType != 3) break;
                byte[] byArray = new byte[n5 + 1];
                for (n4 = 0; n4 < n5; ++n4) {
                    byArray[n4] = -1;
                }
                byArray[n5] = 0;
                byteArrayOutputStream.write(byArray, 0, byArray.length);
            }
        }
        this.writeChunk(TAG_TRNS, byteArrayOutputStream.toByteArray());
    }

    void writeImageData() throws IOException {
        Object[] objectArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        OutputStream outputStream = null;
        switch (this.loader.compression) {
            case 0: {
                outputStream = Compatibility.newDeflaterOutputStream(byteArrayOutputStream, 0);
                break;
            }
            case 1: {
                outputStream = Compatibility.newDeflaterOutputStream(byteArrayOutputStream, 1);
                break;
            }
            case 3: {
                outputStream = Compatibility.newDeflaterOutputStream(byteArrayOutputStream, 9);
                break;
            }
            default: {
                outputStream = Compatibility.newDeflaterOutputStream(byteArrayOutputStream, -1);
            }
        }
        if (outputStream == null) {
            outputStream = byteArrayOutputStream;
        }
        if (this.colorType == 3) {
            objectArray = new byte[this.width];
            for (int i2 = 0; i2 < this.height; ++i2) {
                int n2 = 0;
                outputStream.write(n2);
                this.data.getPixels(0, i2, this.width, (byte[])objectArray, 0);
                outputStream.write((byte[])objectArray);
            }
        } else {
            objectArray = new int[this.width];
            byte[] byArray = null;
            if (this.colorType == 6) {
                byArray = new byte[this.width];
            }
            int n3 = this.data.palette.redMask;
            int n4 = this.data.palette.redShift;
            int n5 = this.data.palette.greenMask;
            int n6 = this.data.palette.greenShift;
            int n7 = this.data.palette.blueShift;
            int n8 = this.data.palette.blueMask;
            byte[] byArray2 = new byte[this.width * (this.colorType == 6 ? 4 : 3)];
            for (int i3 = 0; i3 < this.height; ++i3) {
                int n9 = 0;
                outputStream.write(n9);
                this.data.getPixels(0, i3, this.width, (int[])objectArray, 0);
                if (this.colorType == 6) {
                    this.data.getAlphas(0, i3, this.width, byArray, 0);
                }
                int n10 = 0;
                for (int i4 = 0; i4 < objectArray.length; ++i4) {
                    byte by = objectArray[i4];
                    int n11 = by & n3;
                    byArray2[n10++] = (byte)(n4 < 0 ? n11 >>> -n4 : n11 << n4);
                    int n12 = by & n5;
                    byArray2[n10++] = (byte)(n6 < 0 ? n12 >>> -n6 : n12 << n6);
                    int n13 = by & n8;
                    byArray2[n10++] = (byte)(n7 < 0 ? n13 >>> -n7 : n13 << n7);
                    if (this.colorType != 6) continue;
                    byArray2[n10++] = byArray[i4];
                }
                outputStream.write(byArray2);
            }
        }
        outputStream.flush();
        outputStream.close();
        objectArray = byteArrayOutputStream.toByteArray();
        if (outputStream == byteArrayOutputStream) {
            PngDeflater pngDeflater = new PngDeflater();
            objectArray = pngDeflater.deflate((byte[])objectArray);
        }
        this.writeChunk(TAG_IDAT, (byte[])objectArray);
    }

    void writeEnd() {
        this.writeChunk(TAG_IEND, null);
    }

    public void encode(LEDataOutputStream lEDataOutputStream) {
        try {
            boolean bl2;
            this.writeSignature();
            this.writeHeader();
            if (this.colorType == 3) {
                this.writePalette();
            }
            boolean bl3 = this.transparencyType == 1;
            boolean bl4 = this.transparencyType == 4;
            boolean bl5 = this.colorType == 2 && bl4;
            boolean bl6 = bl2 = this.colorType == 3 && (bl3 || bl4);
            if (bl5 || bl2) {
                this.writeTransparency();
            }
            this.writeImageData();
            this.writeEnd();
            lEDataOutputStream.write(this.bytes.toByteArray());
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }
}

