/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.C;

public class Callback {
    Object object;
    String method;
    String signature;
    int argCount;
    long address;
    long errorResult;
    boolean isStatic;
    boolean isArrayBased;
    static final String PTR_SIGNATURE = C.PTR_SIZEOF == 4 ? "I" : "J";
    static final String SIGNATURE_0 = Callback.getSignature(0);
    static final String SIGNATURE_1 = Callback.getSignature(1);
    static final String SIGNATURE_2 = Callback.getSignature(2);
    static final String SIGNATURE_3 = Callback.getSignature(3);
    static final String SIGNATURE_4 = Callback.getSignature(4);
    static final String SIGNATURE_N = "([" + PTR_SIGNATURE + ")" + PTR_SIGNATURE;

    public Callback(Object object, String string, int n2) {
        this(object, string, n2, false);
    }

    public Callback(Object object, String string, int n2, boolean bl2) {
        this(object, string, n2, bl2, 0L);
    }

    public Callback(Object object, String string, int n2, boolean bl2, long l2) {
        this.object = object;
        this.method = string;
        this.argCount = n2;
        this.isStatic = object instanceof Class;
        this.isArrayBased = bl2;
        this.errorResult = l2;
        if (bl2) {
            this.signature = SIGNATURE_N;
        } else {
            switch (n2) {
                case 0: {
                    this.signature = SIGNATURE_0;
                    break;
                }
                case 1: {
                    this.signature = SIGNATURE_1;
                    break;
                }
                case 2: {
                    this.signature = SIGNATURE_2;
                    break;
                }
                case 3: {
                    this.signature = SIGNATURE_3;
                    break;
                }
                case 4: {
                    this.signature = SIGNATURE_4;
                    break;
                }
                default: {
                    this.signature = Callback.getSignature(n2);
                }
            }
        }
        this.address = Callback.bind(this, object, string, this.signature, n2, this.isStatic, bl2, l2);
    }

    static synchronized native long bind(Callback var0, Object var1, String var2, String var3, int var4, boolean var5, boolean var6, long var7);

    public void dispose() {
        if (this.object == null) {
            return;
        }
        Callback.unbind(this);
        this.signature = null;
        this.method = null;
        this.object = null;
        this.address = 0L;
    }

    public long getAddress() {
        return this.address;
    }

    public static native String getPlatform();

    public static native int getEntryCount();

    static String getSignature(int n2) {
        String string = "(";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + PTR_SIGNATURE;
        }
        string = string + ")" + PTR_SIGNATURE;
        return string;
    }

    public static final synchronized native void setEnabled(boolean var0);

    public static final synchronized native boolean getEnabled();

    @Deprecated
    static final void ignoreCallbacks(boolean bl2) {
        Callback.setEnabled(!bl2);
    }

    public static final synchronized native void reset();

    static final synchronized native void unbind(Callback var0);
}

