/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextAttachment;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTextAttachmentCell;
import org.eclipse.swt.internal.cocoa.id;

public final class TextLayout
extends Resource {
    NSTextStorage textStorage;
    NSLayoutManager layoutManager;
    NSTextContainer textContainer;
    Font font;
    String text = "";
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    int spacing;
    int ascent = -1;
    int descent = -1;
    int indent;
    int wrapIndent;
    boolean justify;
    int alignment = 16384;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int[] lineOffsets;
    NSRect[] lineBounds;
    static Callback textLayoutCallback2;
    static final byte[] SWT_OBJECT;
    static final int TAB_COUNT = 32;
    static final int UNDERLINE_THICK = 65536;
    static final RGB LINK_FOREGROUND;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    float[] computePolyline(int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n5 - n3;
        int n8 = 2 * n7;
        int n9 = Compatibility.ceil(n4 - n2, n8);
        if (n9 == 0 && n4 - n2 > 2) {
            n9 = 1;
        }
        if ((n6 = (2 * n9 + 1) * 2) < 0) {
            return new float[0];
        }
        float[] fArray = new float[n6];
        for (int i2 = 0; i2 < n9; ++i2) {
            int n10 = 4 * i2;
            fArray[n10] = n2 + n8 * i2;
            fArray[n10 + 1] = n5;
            fArray[n10 + 2] = fArray[n10] + (float)(n8 / 2);
            fArray[n10 + 3] = n3;
        }
        fArray[n6 - 2] = n2 + n8 * n9;
        fArray[n6 - 1] = n5;
        return fArray;
    }

    void computeRuns() {
        Object object;
        Object object2;
        int n2;
        if (this.lineBounds != null) {
            return;
        }
        String string = this.getSegmentsText();
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithCharacters(cArray, cArray.length);
        NSMutableAttributedString nSMutableAttributedString = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        nSMutableAttributedString.id = nSMutableAttributedString.initWithString((NSString)nSString).id;
        nSString.release();
        nSMutableAttributedString.beginEditing();
        Font font = this.font != null ? this.font : this.device.systemFont;
        NSRange nSRange = new NSRange();
        nSRange.length = nSMutableAttributedString.length();
        nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font.handle, nSRange);
        nSMutableAttributedString.addAttribute(OS.NSLigatureAttributeName, NSNumber.numberWithInt(0), nSRange);
        font.addTraits(nSMutableAttributedString, nSRange);
        NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        int n3 = 0;
        if (this.wrapWidth != -1) {
            if (this.justify) {
                n3 = 3;
            } else {
                switch (this.alignment) {
                    case 0x1000000: {
                        n3 = 2;
                        break;
                    }
                    case 131072: {
                        n3 = 1;
                    }
                }
            }
        }
        if ((this.orientation & 0x4000000) != 0) {
            nSMutableParagraphStyle.setBaseWritingDirection(1L);
        } else {
            nSMutableParagraphStyle.setBaseWritingDirection(0L);
        }
        nSMutableParagraphStyle.setAlignment(n3);
        nSMutableParagraphStyle.setLineSpacing(this.spacing);
        nSMutableParagraphStyle.setFirstLineHeadIndent(this.indent);
        nSMutableParagraphStyle.setHeadIndent(this.wrapIndent);
        nSMutableParagraphStyle.setLineBreakMode(this.wrapWidth != -1 ? 0L : 2L);
        nSMutableParagraphStyle.setTabStops(NSArray.array());
        if (this.tabs != null && this.tabs.length > 0) {
            int n4 = this.tabs.length;
            if (n4 == 1) {
                nSMutableParagraphStyle.setDefaultTabInterval(this.tabs[0]);
            } else {
                int n5;
                n2 = 0;
                for (n5 = 0; n5 < n4; ++n5) {
                    n2 = this.tabs[n5];
                    NSTextTab nSTextTab = (NSTextTab)new NSTextTab().alloc();
                    nSTextTab = nSTextTab.initWithType(0L, n2);
                    nSMutableParagraphStyle.addTabStop(nSTextTab);
                    nSTextTab.release();
                }
                int n6 = this.tabs[n4 - 1] - this.tabs[n4 - 2];
                while (n5 < 32) {
                    object2 = (NSTextTab)new NSTextTab().alloc();
                    object2 = ((NSTextTab)object2).initWithType(0L, n2 += n6);
                    nSMutableParagraphStyle.addTabStop((NSTextTab)object2);
                    ((NSObject)object2).release();
                    ++n5;
                }
            }
        }
        nSMutableAttributedString.addAttribute(OS.NSParagraphStyleAttributeName, nSMutableParagraphStyle, nSRange);
        nSMutableParagraphStyle.release();
        long l2 = nSMutableAttributedString.length();
        for (n2 = 0; n2 < this.stylesCount - 1; ++n2) {
            Object object3;
            Object object4;
            Object object5;
            Color color;
            StyleItem styleItem = this.styles[n2];
            if (styleItem.style == null) continue;
            object2 = styleItem.style;
            nSRange.location = l2 != 0L ? (long)this.translateOffset(styleItem.start) : 0L;
            nSRange.length = (long)this.translateOffset(this.styles[n2 + 1].start) - nSRange.location;
            Font font2 = ((TextStyle)object2).font;
            if (font2 != null) {
                nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font2.handle, nSRange);
                font2.addTraits(nSMutableAttributedString, nSRange);
            }
            if ((color = ((TextStyle)object2).foreground) != null) {
                object5 = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], 1.0);
                nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, (id)object5, nSRange);
            }
            if ((object5 = ((TextStyle)object2).background) != null) {
                object4 = NSColor.colorWithDeviceRed(((Color)object5).handle[0], ((Color)object5).handle[1], ((Color)object5).handle[2], 1.0);
                nSMutableAttributedString.addAttribute(OS.NSBackgroundColorAttributeName, (id)object4, nSRange);
            }
            if (((TextStyle)object2).strikeout) {
                nSMutableAttributedString.addAttribute(OS.NSStrikethroughStyleAttributeName, NSNumber.numberWithInt(1), nSRange);
                object4 = ((TextStyle)object2).strikeoutColor;
                if (object4 != null) {
                    object3 = NSColor.colorWithDeviceRed(((Color)object4).handle[0], ((Color)object4).handle[1], ((Color)object4).handle[2], 1.0);
                    nSMutableAttributedString.addAttribute(OS.NSStrikethroughColorAttributeName, (id)object3, nSRange);
                }
            }
            if (this.isUnderlineSupported((TextStyle)object2)) {
                int n7 = 0;
                switch (((TextStyle)object2).underlineStyle) {
                    case 0: {
                        n7 = 1;
                        break;
                    }
                    case 1: {
                        n7 = 9;
                        break;
                    }
                    case 65536: {
                        n7 = 2;
                        break;
                    }
                    case 4: {
                        n7 = 1;
                        if (color != null) break;
                        object3 = NSColor.colorWithDeviceRed((float)TextLayout.LINK_FOREGROUND.red / 255.0f, (float)TextLayout.LINK_FOREGROUND.green / 255.0f, (float)TextLayout.LINK_FOREGROUND.blue / 255.0f, 1.0);
                        nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, (id)object3, nSRange);
                    }
                }
                if (n7 != 0) {
                    nSMutableAttributedString.addAttribute(OS.NSUnderlineStyleAttributeName, NSNumber.numberWithInt(n7), nSRange);
                    object3 = ((TextStyle)object2).underlineColor;
                    if (object3 != null) {
                        object = NSColor.colorWithDeviceRed(((Color)object3).handle[0], ((Color)object3).handle[1], ((Color)object3).handle[2], 1.0);
                        nSMutableAttributedString.addAttribute(OS.NSUnderlineColorAttributeName, (id)object, nSRange);
                    }
                }
            }
            if (((TextStyle)object2).rise != 0) {
                nSMutableAttributedString.addAttribute(OS.NSBaselineOffsetAttributeName, NSNumber.numberWithInt(((TextStyle)object2).rise), nSRange);
            }
            if (((TextStyle)object2).metrics == null) continue;
            this.initClasses();
            char[] cArray2 = new char[(int)nSRange.length];
            for (int i2 = 0; i2 < cArray2.length; ++i2) {
                cArray2[i2] = 65532;
            }
            object3 = (NSString)new NSString().alloc();
            object3 = ((NSString)object3).initWithCharacters(cArray2, cArray2.length);
            nSMutableAttributedString.replaceCharactersInRange(nSRange, (NSString)object3);
            ((NSObject)object3).release();
            styleItem.jniRef = OS.NewGlobalRef(styleItem);
            if (styleItem.jniRef == 0L) {
                SWT.error(2);
            }
            styleItem.cell = (SWTTextAttachmentCell)new SWTTextAttachmentCell().alloc().init();
            OS.object_setInstanceVariable(styleItem.cell.id, SWT_OBJECT, styleItem.jniRef);
            object = ((NSTextAttachment)new NSTextAttachment().alloc()).initWithFileWrapper(null);
            ((NSTextAttachment)object).setAttachmentCell(styleItem.cell);
            nSMutableAttributedString.addAttribute(OS.NSAttachmentAttributeName, (id)object, nSRange);
            ((NSObject)object).release();
        }
        nSMutableAttributedString.endEditing();
        NSSize nSSize = new NSSize();
        nSSize.width = this.wrapWidth != -1 ? (double)this.wrapWidth : 5000000.0;
        nSSize.height = 5000000.0;
        if (this.textStorage == null) {
            this.textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            this.layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            this.layoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
            this.textContainer = (NSTextContainer)new NSTextContainer().alloc();
            this.textContainer = this.textContainer.initWithContainerSize(nSSize);
            this.textContainer.setLineFragmentPadding(0.0);
            this.textStorage.addLayoutManager(this.layoutManager);
            this.layoutManager.addTextContainer(this.textContainer);
            this.layoutManager.release();
            this.textContainer.release();
        } else {
            this.textContainer.setContainerSize(nSSize);
        }
        this.textStorage.setAttributedString(nSMutableAttributedString);
        nSMutableAttributedString.release();
        this.layoutManager.glyphRangeForTextContainer(this.textContainer);
        long l3 = this.layoutManager.numberOfGlyphs();
        long l4 = OS.malloc(NSRange.sizeof);
        object = new NSRange();
        int n8 = 0;
        long l5 = 0L;
        while (l5 < l3) {
            this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(l5, l4, true);
            OS.memmove((NSRange)object, l4, (long)NSRange.sizeof);
            l5 = ((NSRange)object).location + ((NSRange)object).length;
            ++n8;
        }
        if (n8 == 0) {
            ++n8;
        }
        int[] nArray = new int[n8 + 1];
        NSRect[] nSRectArray = new NSRect[n8];
        n8 = 0;
        l5 = 0L;
        while (l5 < l3) {
            nSRectArray[n8] = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(l5, l4, true);
            if (n8 < nSRectArray.length - 1) {
                nSRectArray[n8].height -= (double)this.spacing;
            }
            OS.memmove((NSRange)object, l4, (long)NSRange.sizeof);
            nArray[n8] = (int)((NSRange)object).location;
            l5 = ((NSRange)object).location + ((NSRange)object).length;
            ++n8;
        }
        if (n8 == 0) {
            Font font3 = this.font != null ? this.font : this.device.systemFont;
            NSFont nSFont = font3.handle;
            nSRectArray[0] = new NSRect();
            nSRectArray[0].height = Math.max(this.layoutManager.defaultLineHeightForFont(nSFont), (double)(this.ascent + this.descent));
        }
        OS.free(l4);
        nArray[n8] = (int)this.textStorage.length();
        this.lineOffsets = nArray;
        this.lineBounds = nSRectArray;
    }

    void destroy() {
        this.freeRuns();
        if (this.textStorage != null) {
            this.textStorage.release();
        }
        this.textStorage = null;
        this.layoutManager = null;
        this.textContainer = null;
        this.font = null;
        this.text = null;
        this.styles = null;
        this.segments = null;
        this.segmentsChars = null;
    }

    public void draw(GC gC, int n2, int n3) {
        this.draw(gC, n2, n3, -1, -1, null, null);
    }

    public void draw(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2) {
        this.draw(gC, n2, n3, n4, n5, color, color2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2, int n6) {
        this.checkLayout();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = gC.checkGC(3073);
        try {
            int n7;
            Object object;
            Object object2;
            Object object3;
            boolean bl2;
            this.computeRuns();
            int n8 = this.translateOffset(this.text.length());
            if (n8 == 0 && n6 == 0) {
                Object var51_11 = null;
                gC.uncheckGC(nSAutoreleasePool);
                return;
            }
            gC.handle.saveGraphicsState();
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n2;
            nSPoint.y = n3;
            NSRange nSRange = new NSRange();
            long l2 = this.layoutManager.numberOfGlyphs();
            if (l2 > 0L) {
                nSRange.location = 0L;
                nSRange.length = l2;
                this.layoutManager.drawBackgroundForGlyphRange(nSRange, nSPoint);
            }
            boolean bl3 = bl2 = n4 <= n5 && n4 != -1 && n5 != -1;
            if (bl2 || (n6 & 0x100000) != 0 && (n6 & 0x30000) != 0) {
                if (color2 == null) {
                    color2 = this.device.getSystemColor(26);
                }
                object3 = NSColor.colorWithDeviceRed(color2.handle[0], color2.handle[1], color2.handle[2], color2.handle[3]);
                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                object2 = new NSRect();
                if (bl2) {
                    nSRange.location = this.translateOffset(n4);
                    nSRange.length = this.translateOffset(n5 - n4 + 1);
                    object = new long[1];
                    long l3 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, (long[])object);
                    n7 = 0;
                    while ((long)n7 < object[0]) {
                        OS.memmove((NSRect)object2, l3, (long)NSRect.sizeof);
                        this.fixRect((NSRect)object2);
                        ((NSRect)object2).x += nSPoint.x;
                        ((NSRect)object2).y += nSPoint.y;
                        ((NSRect)object2).height = Math.max(((NSRect)object2).height, (double)(this.ascent + this.descent));
                        nSBezierPath.appendBezierPathWithRect((NSRect)object2);
                        ++n7;
                        l3 += (long)NSRect.sizeof;
                    }
                }
                if ((n6 & 0x30000) != 0 && (n6 & 0x100000) != 0) {
                    object = this.lineBounds[this.lineBounds.length - 1];
                    ((NSRect)object2).x = nSPoint.x + ((NSRect)object).x + ((NSRect)object).width;
                    ((NSRect)object2).y = (double)n3 + ((NSRect)object).y;
                    ((NSRect)object2).width = (n6 & 0x10000) != 0 ? 2.147483647E9 : ((NSRect)object).height / 3.0;
                    ((NSRect)object2).height = Math.max(((NSRect)object).height, (double)(this.ascent + this.descent));
                    nSBezierPath.appendBezierPathWithRect((NSRect)object2);
                }
                object3.setFill();
                nSBezierPath.fill();
            }
            if (l2 > 0L) {
                boolean bl4;
                nSRange.location = 0L;
                nSRange.length = l2;
                object3 = gC.data.foreground;
                boolean bl5 = bl4 = object3[0] == 0.0 && object3[1] == 0.0 && object3[2] == 0.0 && object3[3] == 1.0 && gC.data.alpha == 255;
                if (!bl4) {
                    for (int i2 = 0; i2 < this.stylesCount - 1; ++i2) {
                        object = this.styles[i2];
                        if (((StyleItem)object).style != null && ((StyleItem)object).style.foreground != null || ((StyleItem)object).style != null && ((StyleItem)object).style.underline && ((StyleItem)object).style.underlineStyle == 4) continue;
                        nSRange.location = n8 != 0 ? (long)this.translateOffset(((StyleItem)object).start) : 0L;
                        nSRange.length = (long)this.translateOffset(this.styles[i2 + 1].start) - nSRange.location;
                        this.layoutManager.addTemporaryAttribute(OS.NSForegroundColorAttributeName, gC.data.fg, nSRange);
                    }
                }
                nSRange.location = 0L;
                nSRange.length = l2;
                this.layoutManager.drawGlyphsForGlyphRange(nSRange, nSPoint);
                if (!bl4) {
                    nSRange.location = 0L;
                    nSRange.length = n8;
                    this.layoutManager.removeTemporaryAttribute(OS.NSForegroundColorAttributeName, nSRange);
                }
                object2 = new NSPoint();
                for (int i3 = 0; i3 < this.stylesCount; ++i3) {
                    StyleItem styleItem = this.styles[i3];
                    TextStyle textStyle = styleItem.style;
                    if (textStyle == null) continue;
                    n7 = textStyle.underline && !this.isUnderlineSupported(textStyle) ? 1 : 0;
                    n7 = n7 != 0 && (i3 + 1 == this.stylesCount || !textStyle.isAdherentUnderline(this.styles[i3 + 1].style)) ? 1 : 0;
                    boolean bl6 = textStyle.borderStyle != 0;
                    boolean bl7 = bl6 = bl6 && (i3 + 1 == this.stylesCount || !textStyle.isAdherentBorder(this.styles[i3 + 1].style));
                    if (n7 == 0 && !bl6) continue;
                    int n9 = i3 + 1 < this.stylesCount ? this.translateOffset(this.styles[i3 + 1].start - 1) : n8;
                    for (int i4 = 0; i4 < this.lineOffsets.length - 1; ++i4) {
                        Object[] objectArray;
                        NSRect nSRect;
                        long l4;
                        int n10;
                        int n11;
                        int n12 = this.untranslateOffset(this.lineOffsets[i4]);
                        int n13 = this.untranslateOffset(this.lineOffsets[i4 + 1] - 1);
                        if (n7 != 0) {
                            n11 = styleItem.start;
                            for (n10 = i3; n10 > 0 && textStyle.isAdherentUnderline(this.styles[n10 - 1].style); --n10) {
                                n11 = this.styles[n10 - 1].start;
                            }
                            if ((n11 = this.translateOffset(n11)) <= n13 && n9 >= n12) {
                                nSRange.location = Math.max(n12, n11);
                                nSRange.length = (long)(Math.min(n13, n9) + 1) - nSRange.location;
                                if (nSRange.length > 0L) {
                                    long[] lArray = new long[1];
                                    l4 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, lArray);
                                    nSRect = new NSRect();
                                    gC.handle.saveGraphicsState();
                                    double d2 = this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, n12);
                                    objectArray = null;
                                    if (textStyle.underlineColor != null) {
                                        objectArray = textStyle.underlineColor.handle;
                                    }
                                    if (objectArray == null && textStyle.foreground != null) {
                                        objectArray = textStyle.foreground.handle;
                                    }
                                    if (objectArray != null) {
                                        NSColor.colorWithDeviceRed(objectArray[0], objectArray[1], objectArray[2], objectArray[3]).setStroke();
                                    }
                                    int n14 = 0;
                                    while ((long)n14 < lArray[0]) {
                                        OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                                        this.fixRect(nSRect);
                                        double d3 = nSPoint.x + nSRect.x;
                                        double d4 = nSPoint.y + nSRect.y + nSRect.height - d2 + 1.0;
                                        NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                                        switch (textStyle.underlineStyle) {
                                            case 2: {
                                                nSBezierPath.setLineWidth(2.0);
                                                nSBezierPath.setLineCapStyle(1L);
                                                nSBezierPath.setLineJoinStyle(1L);
                                                nSBezierPath.setLineDash(new double[]{1.0, 3.0}, 2L, 0.0);
                                                ((NSPoint)object2).x = d3;
                                                ((NSPoint)object2).y = d4 + 0.5;
                                                nSBezierPath.moveToPoint((NSPoint)object2);
                                                ((NSPoint)object2).x = d3 + nSRect.width;
                                                ((NSPoint)object2).y = d4 + 0.5;
                                                nSBezierPath.lineToPoint((NSPoint)object2);
                                                break;
                                            }
                                            case 3: {
                                                gC.handle.setShouldAntialias(false);
                                                nSBezierPath.setLineWidth(1.0);
                                                nSBezierPath.setLineCapStyle(0L);
                                                nSBezierPath.setLineJoinStyle(0L);
                                                double d5 = nSPoint.y + nSRect.y + nSRect.height;
                                                float f2 = 1.0f;
                                                float f3 = 2.0f * f2;
                                                double d6 = Math.min(d4 - (double)(f3 / 2.0f), d5 - (double)f3 - 1.0);
                                                float[] fArray = this.computePolyline((int)d3, (int)d6, (int)(d3 + nSRect.width), (int)(d6 + (double)f3));
                                                ((NSPoint)object2).x = fArray[0] + 0.5f;
                                                ((NSPoint)object2).y = fArray[1] + 0.5f;
                                                nSBezierPath.moveToPoint((NSPoint)object2);
                                                for (int i5 = 2; i5 < fArray.length; i5 += 2) {
                                                    ((NSPoint)object2).x = fArray[i5] + 0.5f;
                                                    ((NSPoint)object2).y = fArray[i5 + 1] + 0.5f;
                                                    nSBezierPath.lineToPoint((NSPoint)object2);
                                                }
                                                break;
                                            }
                                        }
                                        nSBezierPath.stroke();
                                        ++n14;
                                        l4 += (long)NSRect.sizeof;
                                    }
                                    gC.handle.restoreGraphicsState();
                                }
                            }
                        }
                        if (!bl6) continue;
                        n11 = styleItem.start;
                        for (n10 = i3; n10 > 0 && textStyle.isAdherentBorder(this.styles[n10 - 1].style); --n10) {
                            n11 = this.styles[n10 - 1].start;
                        }
                        if ((n11 = this.translateOffset(n11)) > n13 || n9 < n12) continue;
                        nSRange.location = Math.max(n12, n11);
                        nSRange.length = (long)(Math.min(n13, n9) + 1) - nSRange.location;
                        if (nSRange.length <= 0L) continue;
                        long[] lArray = new long[1];
                        l4 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, lArray);
                        nSRect = new NSRect();
                        gC.handle.saveGraphicsState();
                        double[] dArray = null;
                        if (textStyle.borderColor != null) {
                            dArray = textStyle.borderColor.handle;
                        }
                        if (dArray == null && textStyle.foreground != null) {
                            dArray = textStyle.foreground.handle;
                        }
                        if (dArray != null) {
                            NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], dArray[3]).setStroke();
                        }
                        boolean bl8 = true;
                        objectArray = null;
                        switch (textStyle.borderStyle) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                objectArray = bl8 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                break;
                            }
                            case 4: {
                                objectArray = bl8 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                            }
                        }
                        double[] dArray2 = null;
                        if (objectArray != null) {
                            dArray2 = new double[objectArray.length];
                            for (int i6 = 0; i6 < dArray2.length; ++i6) {
                                dArray2[i6] = !bl8 ? (double)objectArray[i6] : (double)(objectArray[i6] * (float)bl8);
                            }
                        }
                        int n15 = 0;
                        while ((long)n15 < lArray[0]) {
                            OS.memmove(nSRect, l4, (long)NSRect.sizeof);
                            this.fixRect(nSRect);
                            nSRect.x += nSPoint.x + 0.5;
                            nSRect.y += nSPoint.y + 0.5;
                            nSRect.width -= 0.5;
                            nSRect.height -= 0.5;
                            NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                            nSBezierPath.setLineDash(dArray2, dArray2 != null ? (long)dArray2.length : 0L, 0.0);
                            nSBezierPath.appendBezierPathWithRect(nSRect);
                            nSBezierPath.stroke();
                            ++n15;
                            l4 += (long)NSRect.sizeof;
                        }
                        gC.handle.restoreGraphicsState();
                    }
                }
            }
            gC.handle.restoreGraphicsState();
        }
        catch (Throwable throwable) {
            Object var51_13 = null;
            gC.uncheckGC(nSAutoreleasePool);
            throw throwable;
        }
        Object var51_12 = null;
        gC.uncheckGC(nSAutoreleasePool);
    }

    void fixRect(NSRect nSRect) {
        double d2 = -1.0;
        for (int i2 = 0; i2 < this.lineBounds.length; ++i2) {
            NSRect nSRect2 = this.lineBounds[i2];
            if (!(nSRect.y <= nSRect2.y) || !(nSRect2.y <= nSRect.y + nSRect.height)) continue;
            d2 = Math.max(d2, nSRect2.x + nSRect2.width);
        }
        if (d2 != -1.0 && nSRect.x + nSRect.width > d2) {
            nSRect.width = d2 - nSRect.x;
        }
    }

    void freeRuns() {
        this.lineBounds = null;
        this.lineOffsets = null;
        for (int i2 = 0; i2 < this.stylesCount - 1; ++i2) {
            StyleItem styleItem = this.styles[i2];
            if (styleItem.cell == null) continue;
            OS.object_setInstanceVariable(styleItem.cell.id, SWT_OBJECT, 0L);
            styleItem.cell.release();
            styleItem.cell = null;
            OS.DeleteGlobalRef(styleItem.jniRef);
            styleItem.jniRef = 0L;
        }
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        Object object;
        block5: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                NSRect nSRect = this.layoutManager.usedRectForTextContainer(this.textContainer);
                if (this.wrapWidth != -1) {
                    nSRect.width = this.wrapWidth;
                }
                if (this.text.length() == 0) {
                    object = this.font != null ? this.font : this.device.systemFont;
                    NSFont nSFont = ((Font)object).handle;
                    nSRect.height = this.layoutManager.defaultLineHeightForFont(nSFont);
                }
                nSRect.height = Math.max(nSRect.height, (double)(this.ascent + this.descent)) + (double)this.spacing;
                object = new Rectangle(0, 0, (int)Math.ceil(nSRect.width), (int)Math.ceil(nSRect.height));
                Object var6_5 = null;
                if (nSAutoreleasePool == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_6 = null;
                    if (nSAutoreleasePool == null) break block6;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds(int n2, int n3) {
        Rectangle rectangle;
        block10: {
            int n4;
            NSAutoreleasePool nSAutoreleasePool;
            block8: {
                Rectangle rectangle2;
                block9: {
                    block6: {
                        Rectangle rectangle3;
                        block7: {
                            this.checkLayout();
                            nSAutoreleasePool = null;
                            if (!NSThread.isMainThread()) {
                                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            this.computeRuns();
                            n4 = this.text.length();
                            if (n4 != 0) break block6;
                            rectangle3 = new Rectangle(0, 0, 0, 0);
                            Object var16_8 = null;
                            if (nSAutoreleasePool == null) break block7;
                            nSAutoreleasePool.release();
                        }
                        return rectangle3;
                    }
                    if (n2 <= n3) break block8;
                    rectangle2 = new Rectangle(0, 0, 0, 0);
                    Object var16_9 = null;
                    if (nSAutoreleasePool == null) break block9;
                    nSAutoreleasePool.release();
                }
                return rectangle2;
            }
            try {
                n2 = Math.min(Math.max(0, n2), n4 - 1);
                n3 = Math.min(Math.max(0, n3), n4 - 1);
                n2 = this.translateOffset(n2);
                n3 = this.translateOffset(n3);
                NSRange nSRange = new NSRange();
                nSRange.location = n2;
                nSRange.length = n3 - n2 + 1;
                long[] lArray = new long[1];
                long l2 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, lArray);
                NSRect nSRect = new NSRect();
                int n5 = Integer.MAX_VALUE;
                int n6 = 0;
                int n7 = Integer.MAX_VALUE;
                int n8 = 0;
                int n9 = 0;
                while ((long)n9 < lArray[0]) {
                    OS.memmove(nSRect, l2, (long)NSRect.sizeof);
                    this.fixRect(nSRect);
                    n5 = Math.min(n5, (int)nSRect.x);
                    n6 = Math.max(n6, (int)Math.ceil(nSRect.x + nSRect.width));
                    n7 = Math.min(n7, (int)nSRect.y);
                    n8 = Math.max(n8, (int)Math.ceil(nSRect.y + nSRect.height));
                    ++n9;
                    l2 += (long)NSRect.sizeof;
                }
                rectangle = new Rectangle(n5, n7, n6 - n5, n8 - n7);
                Object var16_10 = null;
                if (nSAutoreleasePool == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var16_11 = null;
                    if (nSAutoreleasePool == null) break block11;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLevel(int n2) {
        byte by;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int n3 = this.text.length();
                if (0 > n2 || n2 > n3) {
                    SWT.error(6);
                }
                n2 = this.translateOffset(n2);
                long l2 = this.layoutManager.glyphIndexForCharacterAtIndex(n2);
                NSRange nSRange = new NSRange();
                nSRange.location = l2;
                nSRange.length = 1L;
                byte[] byArray = new byte[1];
                this.layoutManager.getGlyphsInRange(nSRange, 0L, 0L, 0L, 0L, byArray);
                by = byArray[0];
                Object var10_8 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var10_9 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getLineOffsets() {
        int[] nArray;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int[] nArray2 = new int[this.lineOffsets.length];
                for (int i2 = 0; i2 < nArray2.length; ++i2) {
                    nArray2[i2] = this.untranslateOffset(this.lineOffsets[i2]);
                }
                nArray = nArray2;
                Object var5_5 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_6 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLineIndex(int n2) {
        int n3;
        NSAutoreleasePool nSAutoreleasePool;
        block6: {
            int n4;
            block5: {
                this.checkLayout();
                nSAutoreleasePool = null;
                if (!NSThread.isMainThread()) {
                    nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                }
                try {
                    this.computeRuns();
                    int n5 = this.text.length();
                    if (0 > n2 || n2 > n5) {
                        SWT.error(6);
                    }
                    n2 = this.translateOffset(n2);
                    for (n3 = 0; n3 < this.lineOffsets.length - 1; ++n3) {
                        if (this.lineOffsets[n3 + 1] <= n2) continue;
                        n4 = n3;
                        Object var7_6 = null;
                        if (nSAutoreleasePool == null) return n4;
                        break block5;
                    }
                    n3 = this.lineBounds.length - 1;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (nSAutoreleasePool == null) throw throwable;
                    nSAutoreleasePool.release();
                    throw throwable;
                }
            }
            nSAutoreleasePool.release();
            return n4;
        }
        Object var7_7 = null;
        if (nSAutoreleasePool == null) return n3;
        nSAutoreleasePool.release();
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getLineBounds(int n2) {
        Rectangle rectangle;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                if (0 > n2 || n2 >= this.lineBounds.length) {
                    SWT.error(6);
                }
                NSRect nSRect = this.lineBounds[n2];
                int n3 = Math.max((int)Math.ceil(nSRect.height), this.ascent + this.descent);
                rectangle = new Rectangle((int)nSRect.x, (int)nSRect.y, (int)Math.ceil(nSRect.width), n3);
                Object var7_6 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_7 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineCount() {
        int n2;
        block3: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                n2 = this.lineOffsets.length - 1;
                Object var4_3 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_4 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontMetrics getLineMetrics(int n2) {
        FontMetrics fontMetrics;
        block7: {
            NSAutoreleasePool nSAutoreleasePool;
            block5: {
                FontMetrics fontMetrics2;
                block6: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        int n3;
                        this.computeRuns();
                        int n4 = this.getLineCount();
                        if (0 > n2 || n2 >= n4) {
                            SWT.error(6);
                        }
                        if ((n3 = this.text.length()) != 0) break block5;
                        Font font = this.font != null ? this.font : this.device.systemFont;
                        int n5 = (int)this.layoutManager.defaultBaselineOffsetForFont(font.handle);
                        int n6 = (int)this.layoutManager.defaultLineHeightForFont(font.handle) - n5;
                        n5 = Math.max(n5, this.ascent);
                        n6 = Math.max(n6, this.descent);
                        fontMetrics2 = FontMetrics.cocoa_new(n5, n6, 0, 0, n5 + n6);
                        Object var10_12 = null;
                        if (nSAutoreleasePool == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var10_14 = null;
                            if (nSAutoreleasePool == null) break block8;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return fontMetrics2;
            }
            Rectangle rectangle = this.getLineBounds(n2);
            int n7 = (int)this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, this.getLineOffsets()[n2]);
            fontMetrics = FontMetrics.cocoa_new(rectangle.height - n7, n7, 0, 0, rectangle.height);
            Object var10_13 = null;
            if (nSAutoreleasePool == null) break block7;
            nSAutoreleasePool.release();
        }
        return fontMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocation(int n2, boolean bl2) {
        Object object;
        block13: {
            NSAutoreleasePool nSAutoreleasePool;
            block11: {
                Point point;
                block12: {
                    int n3;
                    block9: {
                        Point point2;
                        block10: {
                            this.checkLayout();
                            nSAutoreleasePool = null;
                            if (!NSThread.isMainThread()) {
                                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            try {
                                this.computeRuns();
                                n3 = this.text.length();
                                if (0 > n2 || n2 > n3) {
                                    SWT.error(6);
                                }
                                if (n3 != 0) break block9;
                                point2 = new Point(0, 0);
                                Object var19_8 = null;
                                if (nSAutoreleasePool == null) break block10;
                            }
                            catch (Throwable throwable) {
                                block14: {
                                    Object var19_11 = null;
                                    if (nSAutoreleasePool == null) break block14;
                                    nSAutoreleasePool.release();
                                }
                                throw throwable;
                            }
                            nSAutoreleasePool.release();
                        }
                        return point2;
                    }
                    if (n2 != n3) break block11;
                    NSRect nSRect = this.lineBounds[this.lineBounds.length - 1];
                    point = new Point((int)(nSRect.x + nSRect.width), (int)nSRect.y);
                    Object var19_9 = null;
                    if (nSAutoreleasePool == null) break block12;
                    nSAutoreleasePool.release();
                }
                return point;
            }
            n2 = this.translateOffset(n2);
            long l2 = this.layoutManager.glyphIndexForCharacterAtIndex(n2);
            NSRect nSRect = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(l2, 0L);
            NSPoint nSPoint = this.layoutManager.locationForGlyphAtIndex(l2);
            boolean bl3 = false;
            NSRange nSRange = new NSRange();
            nSRange.location = l2;
            nSRange.length = 1L;
            byte[] byArray = new byte[1];
            long l3 = this.layoutManager.getGlyphsInRange(nSRange, 0L, 0L, 0L, 0L, byArray);
            if (l3 > 0L) {
                boolean bl4 = bl3 = (byArray[0] & 1) != 0;
            }
            if (bl2 != bl3) {
                object = new long[1];
                long l4 = this.layoutManager.rectArrayForGlyphRange(nSRange, nSRange, this.textContainer, (long[])object);
                if (object[0] > 0L) {
                    NSRect nSRect2 = new NSRect();
                    OS.memmove(nSRect2, l4, (long)NSRect.sizeof);
                    this.fixRect(nSRect2);
                    nSPoint.x += nSRect2.width;
                }
            }
            object = new Point((int)nSPoint.x, (int)nSRect.y);
            Object var19_10 = null;
            if (nSAutoreleasePool == null) break block13;
            nSAutoreleasePool.release();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextOffset(int n2, int n3) {
        int n4;
        block3: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n4 = this._getOffset(n2, n3, true);
                Object var6_5 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int _getOffset(int n2, int n3, boolean bl2) {
        int n4;
        this.checkLayout();
        this.computeRuns();
        int n5 = this.text.length();
        if (0 > n2 || n2 > n5) {
            SWT.error(6);
        }
        if (bl2 && n2 == n5) {
            return n5;
        }
        if (!bl2 && n2 == 0) {
            return 0;
        }
        int n6 = n4 = bl2 ? 1 : -1;
        if ((n3 & 1) != 0) {
            return n2 + n4;
        }
        switch (n3) {
            case 2: {
                char c2;
                if (0 > (n2 += n4) || n2 >= n5 || '\udc00' > (c2 = this.text.charAt(n2)) || c2 > '\udfff' || n2 <= 0 || '\ud800' > (c2 = this.text.charAt(n2 - 1)) || c2 > '\udbff') return n2;
                n2 += n4;
                return n2;
            }
            case 4: {
                n2 = this.translateOffset(n2);
                n2 = (int)this.textStorage.nextWordFromIndex(n2, bl2);
                return this.untranslateOffset(n2);
            }
            case 8: {
                n2 = this.translateOffset(n2);
                if (bl2) {
                    n2 = (int)this.textStorage.nextWordFromIndex(n2, true);
                    return this.untranslateOffset(n2);
                } else {
                    n5 = this.translateOffset(n5);
                    int n7 = 0;
                    while (n7 < n5) {
                        int n8 = (int)this.textStorage.nextWordFromIndex(n7, true);
                        if (n8 >= n2) {
                            n2 = n7;
                            return this.untranslateOffset(n2);
                        }
                        n7 = n8;
                    }
                }
                return this.untranslateOffset(n2);
            }
            case 16: {
                n2 = this.translateOffset(n2);
                if (bl2) {
                    int n9 = this.translateOffset(n5);
                    while (n9 > 0) {
                        int n10 = (int)this.textStorage.nextWordFromIndex(n9, false);
                        if (n10 <= n2) {
                            n2 = n9;
                            return this.untranslateOffset(n2);
                        }
                        n9 = n10;
                    }
                    return this.untranslateOffset(n2);
                }
                n2 = (int)this.textStorage.nextWordFromIndex(n2, false);
                return this.untranslateOffset(n2);
            }
        }
        return n2;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOffset(int n2, int n3, int[] nArray) {
        int n4;
        block9: {
            int n5;
            NSAutoreleasePool nSAutoreleasePool;
            block7: {
                int n6;
                block8: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        this.computeRuns();
                        if (nArray != null && nArray.length < 1) {
                            SWT.error(5);
                        }
                        if ((n5 = this.text.length()) != 0) break block7;
                        n6 = 0;
                        Object var13_8 = null;
                        if (nSAutoreleasePool == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var13_10 = null;
                            if (nSAutoreleasePool == null) break block10;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return n6;
            }
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n2;
            nSPoint.y = n3;
            double[] dArray = new double[1];
            long l2 = this.layoutManager.glyphIndexForPoint(nSPoint, this.textContainer, dArray);
            int n7 = (int)this.layoutManager.characterIndexForGlyphAtIndex(l2);
            n7 = Math.min(this.untranslateOffset(n7), n5 - 1);
            if (nArray != null) {
                nArray[0] = Math.round((float)dArray[0]);
                if (dArray[0] >= 0.5 && 55296 <= (n4 = (int)this.text.charAt(n7)) && n4 <= 56319 && n7 + 1 < n5 && 56320 <= (n4 = (int)this.text.charAt(n7 + 1)) && n4 <= 57343) {
                    nArray[0] = nArray[0] + 1;
                }
            }
            n4 = n7;
            Object var13_9 = null;
            if (nSAutoreleasePool == null) break block9;
            nSAutoreleasePool.release();
        }
        return n4;
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreviousOffset(int n2, int n3) {
        int n4;
        block3: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n4 = this._getOffset(n2, n3, false);
                Object var6_5 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n4;
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n2 = 0;
        for (int i2 = 0; i2 < this.stylesCount - 1; ++i2) {
            if (this.styles[i2].style == null) continue;
            nArray[n2++] = this.styles[i2].start;
            nArray[n2++] = this.styles[i2 + 1].start - 1;
        }
        if (n2 != nArray.length) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int n2;
        int n3;
        int n4 = this.text.length();
        if (n4 == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int n5 = this.segments.length;
        if (n5 == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (n5 == 1) {
                return this.text;
            }
            if (n5 == 2 && this.segments[0] == 0 && this.segments[1] == n4) {
                return this.text;
            }
        }
        char[] cArray = new char[n4];
        this.text.getChars(0, n4, cArray, 0);
        char[] cArray2 = new char[n4 + n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = n3 = this.orientation == 0x4000000 ? 8207 : 8206;
        while (n6 < n4) {
            if (n7 < n5 && n6 == this.segments[n7]) {
                n2 = this.segmentsChars != null && this.segmentsChars.length > n7 ? this.segmentsChars[n7] : n3;
                cArray2[n6 + n7++] = n2;
                continue;
            }
            cArray2[n6 + n7] = cArray[n6++];
        }
        while (n7 < n5) {
            this.segments[n7] = n6;
            n2 = this.segmentsChars != null && this.segmentsChars.length > n7 ? this.segmentsChars[n7] : n3;
            cArray2[n6 + n7++] = n2;
        }
        return new String(cArray2, 0, cArray2.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public TextStyle getStyle(int n2) {
        this.checkLayout();
        int n3 = this.text.length();
        if (0 > n2 || n2 >= n3) {
            SWT.error(6);
        }
        for (int i2 = 1; i2 < this.stylesCount; ++i2) {
            StyleItem styleItem = this.styles[i2];
            if (styleItem.start <= n2) continue;
            return this.styles[i2 - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n2 = 0;
        for (int i2 = 0; i2 < this.stylesCount; ++i2) {
            if (this.styles[i2].style == null) continue;
            textStyleArray[n2++] = this.styles[i2].style;
        }
        if (n2 != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n2];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n2);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getTextDirection() {
        this.checkLayout();
        return this.orientation;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return this.wrapIndent;
    }

    void initClasses() {
        String string = "SWTTextAttachmentCell";
        if (OS.objc_lookUpClass(string) != 0L) {
            return;
        }
        textLayoutCallback2 = new Callback(this.getClass(), "textLayoutProc", 2);
        long l2 = textLayoutCallback2.getAddress();
        if (l2 == 0L) {
            SWT.error(3);
        }
        long l3 = OS.CALLBACK_cellBaselineOffset(l2);
        long l4 = OS.CALLBACK_NSTextAttachmentCell_cellSize(l2);
        byte[] byArray = new byte[]{42, 0};
        int n2 = C.PTR_SIZEOF;
        int n3 = C.PTR_SIZEOF == 4 ? 2 : 3;
        long l5 = OS.objc_allocateClassPair(OS.class_NSCell, string, 0L);
        OS.class_addIvar(l5, SWT_OBJECT, n2, (byte)n3, byArray);
        OS.class_addProtocol(l5, OS.protocol_NSTextAttachmentCell);
        OS.class_addMethod(l5, OS.sel_cellSize, l4, "@:");
        OS.class_addMethod(l5, OS.sel_cellBaselineOffset, l3, "@:");
        OS.objc_registerClassPair(l5);
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    boolean isUnderlineSupported(TextStyle textStyle) {
        if (textStyle != null && textStyle.underline) {
            int n2 = textStyle.underlineStyle;
            return n2 == 0 || n2 == 1 || n2 == 4 || n2 == 65536;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAlignment(int n2) {
        this.checkLayout();
        int n3 = 16924672;
        if ((n2 &= n3) == 0) {
            return;
        }
        if ((n2 & 0x4000) != 0) {
            n2 = 16384;
        }
        if ((n2 & 0x20000) != 0) {
            n2 = 131072;
        }
        if (this.alignment == n2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.alignment = n2;
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAscent(int n2) {
        this.checkLayout();
        if (n2 < -1) {
            SWT.error(5);
        }
        if (this.ascent == n2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.ascent = n2;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDescent(int n2) {
        this.checkLayout();
        if (n2 < -1) {
            SWT.error(5);
        }
        if (this.descent == n2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.descent = n2;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIndent(int n2) {
        this.checkLayout();
        if (n2 < 0) {
            return;
        }
        if (this.indent == n2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.indent = n2;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setWrapIndent(int n2) {
        this.checkLayout();
        if (n2 < 0) {
            return;
        }
        if (this.wrapIndent == n2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.wrapIndent = n2;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setJustify(boolean bl2) {
        this.checkLayout();
        if (bl2 == this.justify) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.justify = bl2;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOrientation(int n2) {
        this.checkLayout();
        int n3 = 0x6000000;
        if ((n2 &= n3) == 0) {
            return;
        }
        if ((n2 & 0x2000000) != 0) {
            n2 = 0x2000000;
        }
        if (this.orientation == n2) {
            return;
        }
        this.orientation = n2;
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n2;
            for (n2 = 0; n2 < nArray.length && this.segments[n2] == nArray[n2]; ++n2) {
            }
            if (n2 == nArray.length) {
                return;
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.segments = nArray;
            Object var4_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSegmentsChars(char[] cArray) {
        this.checkLayout();
        if (this.segmentsChars == null && cArray == null) {
            return;
        }
        if (this.segmentsChars != null && cArray != null && this.segmentsChars.length == cArray.length) {
            int n2;
            for (n2 = 0; n2 < cArray.length && this.segmentsChars[n2] == cArray[n2]; ++n2) {
            }
            if (n2 == cArray.length) {
                return;
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.segmentsChars = cArray;
            Object var4_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSpacing(int n2) {
        this.checkLayout();
        if (n2 < 0) {
            SWT.error(5);
        }
        if (this.spacing == n2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.spacing = n2;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStyle(TextStyle textStyle, int n2, int n3) {
        NSAutoreleasePool nSAutoreleasePool;
        block27: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    this.checkLayout();
                                    nSAutoreleasePool = null;
                                    if (!NSThread.isMainThread()) {
                                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                                    }
                                    try {
                                        int n4;
                                        int n5;
                                        int n6;
                                        int n7;
                                        int n8 = this.text.length();
                                        if (n8 == 0) {
                                            Object var16_6 = null;
                                            if (nSAutoreleasePool == null) return;
                                            break block21;
                                        }
                                        if (n2 > n3) {
                                            break block22;
                                        }
                                        n2 = Math.min(Math.max(0, n2), n8 - 1);
                                        n3 = Math.min(Math.max(0, n3), n8 - 1);
                                        int n9 = -1;
                                        int n10 = this.stylesCount;
                                        while (n10 - n9 > 1) {
                                            int n11 = (n10 + n9) / 2;
                                            if (this.styles[n11 + 1].start > n2) {
                                                n10 = n11;
                                                continue;
                                            }
                                            n9 = n11;
                                        }
                                        if (0 <= n10 && n10 < this.stylesCount) {
                                            StyleItem styleItem = this.styles[n10];
                                            if (styleItem.start == n2 && this.styles[n10 + 1].start - 1 == n3) {
                                                if (textStyle == null) {
                                                    if (styleItem.style == null) {
                                                        break block23;
                                                    }
                                                } else if (textStyle.equals(styleItem.style)) {
                                                    break block24;
                                                }
                                            }
                                        }
                                        this.freeRuns();
                                        for (n7 = n6 = n10; n7 < this.stylesCount && this.styles[n7 + 1].start <= n3; ++n7) {
                                        }
                                        if (n6 == n7) {
                                            n5 = this.styles[n6].start;
                                            n4 = this.styles[n7 + 1].start - 1;
                                            if (n5 == n2 && n4 == n3) {
                                                this.styles[n6].style = textStyle;
                                                break block25;
                                            }
                                            if (n5 != n2 && n4 != n3) {
                                                int n12 = this.stylesCount + 2;
                                                if (n12 > this.styles.length) {
                                                    int n13 = Math.min(n12 + 1024, Math.max(64, n12 * 2));
                                                    StyleItem[] styleItemArray = new StyleItem[n13];
                                                    System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
                                                    this.styles = styleItemArray;
                                                }
                                                System.arraycopy(this.styles, n7 + 1, this.styles, n7 + 3, this.stylesCount - n7 - 1);
                                                StyleItem styleItem = new StyleItem();
                                                styleItem.start = n2;
                                                styleItem.style = textStyle;
                                                this.styles[n6 + 1] = styleItem;
                                                styleItem = new StyleItem();
                                                styleItem.start = n3 + 1;
                                                styleItem.style = this.styles[n6].style;
                                                this.styles[n6 + 2] = styleItem;
                                                this.stylesCount = n12;
                                                break block26;
                                            }
                                        }
                                        if (n2 == this.styles[n6].start) {
                                            --n6;
                                        }
                                        if (n3 == this.styles[n7 + 1].start - 1) {
                                            ++n7;
                                        }
                                        if ((n5 = this.stylesCount + 1 - (n7 - n6 - 1)) > this.styles.length) {
                                            n4 = Math.min(n5 + 1024, Math.max(64, n5 * 2));
                                            StyleItem[] styleItemArray = new StyleItem[n4];
                                            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
                                            this.styles = styleItemArray;
                                        }
                                        System.arraycopy(this.styles, n7, this.styles, n6 + 2, this.stylesCount - n7);
                                        StyleItem styleItem = new StyleItem();
                                        styleItem.start = n2;
                                        styleItem.style = textStyle;
                                        this.styles[n6 + 1] = styleItem;
                                        this.styles[n6 + 2].start = n3 + 1;
                                        this.stylesCount = n5;
                                        break block27;
                                    }
                                    catch (Throwable throwable) {
                                        Object var16_13 = null;
                                        if (nSAutoreleasePool == null) throw throwable;
                                        nSAutoreleasePool.release();
                                        throw throwable;
                                    }
                                }
                                nSAutoreleasePool.release();
                                return;
                            }
                            Object var16_7 = null;
                            if (nSAutoreleasePool == null) return;
                            nSAutoreleasePool.release();
                            return;
                        }
                        Object var16_8 = null;
                        if (nSAutoreleasePool == null) return;
                        nSAutoreleasePool.release();
                        return;
                    }
                    Object var16_9 = null;
                    if (nSAutoreleasePool == null) return;
                    nSAutoreleasePool.release();
                    return;
                }
                Object var16_10 = null;
                if (nSAutoreleasePool == null) return;
                nSAutoreleasePool.release();
                return;
            }
            Object var16_11 = null;
            if (nSAutoreleasePool == null) return;
            nSAutoreleasePool.release();
            return;
        }
        Object var16_12 = null;
        if (nSAutoreleasePool == null) return;
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n2;
            for (n2 = 0; n2 < nArray.length && this.tabs[n2] == nArray[n2]; ++n2) {
            }
            if (n2 == nArray.length) {
                return;
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.tabs = nArray;
            Object var4_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.text = string;
            this.styles = new StyleItem[2];
            this.styles[0] = new StyleItem();
            this.styles[1] = new StyleItem();
            this.styles[1].start = string.length();
            this.stylesCount = 2;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    public void setTextDirection(int n2) {
        this.checkLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setWidth(int n2) {
        this.checkLayout();
        if (n2 < -1 || n2 == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.wrapWidth = n2;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.text + "}";
    }

    static long textLayoutProc(long l2, long l3) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l2, SWT_OBJECT, lArray);
        if (lArray[0] == 0L) {
            return 0L;
        }
        StyleItem styleItem = (StyleItem)OS.JNIGetObject(lArray[0]);
        if (styleItem == null) {
            return 0L;
        }
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return 0L;
        }
        GlyphMetrics glyphMetrics = textStyle.metrics;
        if (glyphMetrics == null) {
            return 0L;
        }
        if (l3 == OS.sel_cellSize) {
            NSSize nSSize = new NSSize();
            nSSize.width = glyphMetrics.width;
            nSSize.height = glyphMetrics.ascent + glyphMetrics.descent;
            long l4 = OS.malloc(NSSize.sizeof);
            OS.memmove(l4, nSSize, (long)NSSize.sizeof);
            return l4;
        }
        if (l3 == OS.sel_cellBaselineOffset) {
            NSPoint nSPoint = new NSPoint();
            nSPoint.y = -glyphMetrics.descent;
            long l5 = OS.malloc(NSPoint.sizeof);
            OS.memmove(l5, nSPoint, (long)NSPoint.sizeof);
            return l5;
        }
        return 0L;
    }

    int translateOffset(int n2) {
        int n3 = this.text.length();
        if (n3 == 0) {
            return n2;
        }
        if (this.segments == null) {
            return n2;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return n2;
        }
        if (this.segmentsChars == null) {
            if (n4 == 1) {
                return n2;
            }
            if (n4 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
                return n2;
            }
        }
        for (int i2 = 0; i2 < n4 && n2 - i2 >= this.segments[i2]; ++i2) {
            ++n2;
        }
        return n2;
    }

    int untranslateOffset(int n2) {
        int n3 = this.text.length();
        if (n3 == 0) {
            return n2;
        }
        if (this.segments == null) {
            return n2;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return n2;
        }
        if (this.segmentsChars == null) {
            if (n4 == 1) {
                return n2;
            }
            if (n4 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
                return n2;
            }
        }
        for (int i2 = 0; i2 < n4 && n2 > this.segments[i2]; --n2, ++i2) {
        }
        return n2;
    }

    static {
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
        LINK_FOREGROUND = new RGB(0, 51, 153);
    }

    static class StyleItem {
        TextStyle style;
        int start;
        long jniRef;
        NSCell cell;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

