/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Region
extends Resource {
    public long handle;
    NSAffineTransform transform;
    NSPoint pt = new NSPoint();
    short[] rect = new short[4];

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle = OS.NewRgn();
            if (this.handle == 0L) {
                SWT.error(2);
            }
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    Region(Device device, long l2) {
        super(device);
        this.handle = l2;
    }

    public static Region cocoa_new(Device device, long l2) {
        return new Region(device, l2);
    }

    static long polyToRgn(int[] nArray, int n2) {
        short[] sArray = new short[4];
        long l2 = OS.NewRgn();
        long l3 = OS.NewRgn();
        int n3 = nArray[1];
        int n4 = nArray[1];
        for (int i2 = 3; i2 < n2; i2 += 2) {
            if (nArray[i2] < n3) {
                n3 = nArray[i2];
            }
            if (nArray[i2] <= n4) continue;
            n4 = nArray[i2];
        }
        int[] nArray2 = new int[n2 + 1];
        for (int i3 = n3; i3 <= n4; ++i3) {
            int n5;
            int n6;
            int n7;
            int n8 = 0;
            int n9 = nArray[0];
            int n10 = nArray[1];
            for (n7 = 2; n7 < n2; n7 += 2) {
                n6 = nArray[n7];
                n5 = nArray[n7 + 1];
                if (n10 != n5 && (n10 <= i3 && i3 < n5 || n5 <= i3 && i3 < n10)) {
                    nArray2[n8++] = (int)((float)(i3 - n10) / (float)(n5 - n10) * (float)(n6 - n9) + (float)n9 + 0.5f);
                }
                n9 = n6;
                n10 = n5;
            }
            n7 = nArray[0];
            n6 = nArray[1];
            if (n10 != n6 && (n10 <= i3 && i3 < n6 || n6 <= i3 && i3 < n10)) {
                nArray2[n8++] = (int)((float)(i3 - n10) / (float)(n6 - n10) * (float)(n7 - n9) + (float)n9 + 0.5f);
            }
            for (n5 = n8 / 2; n5 > 0; n5 /= 2) {
                for (int i4 = n5; i4 < n8; ++i4) {
                    for (int i5 = i4 - n5; i5 >= 0 && nArray2[i5] - nArray2[i5 + n5] > 0; i5 -= n5) {
                        int n11 = nArray2[i5];
                        nArray2[i5] = nArray2[i5 + n5];
                        nArray2[i5 + n5] = n11;
                    }
                }
            }
            for (n5 = 0; n5 < n8; n5 += 2) {
                OS.SetRect(sArray, (short)nArray2[n5], (short)i3, (short)nArray2[n5 + 1], (short)(i3 + 1));
                OS.RectRgn(l3, sArray);
                OS.UnionRgn(l2, l3, l2);
            }
        }
        OS.DisposeRgn(l3);
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long polyRgn(int[] nArray, int n2) {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l2;
            if (C.PTR_SIZEOF == 4) {
                l2 = OS.NewRgn();
                OS.OpenRgn();
                OS.MoveTo((short)nArray[0], (short)nArray[1]);
                for (int i2 = 1; i2 < n2 / 2; ++i2) {
                    OS.LineTo((short)nArray[2 * i2], (short)nArray[2 * i2 + 1]);
                }
                OS.LineTo((short)nArray[0], (short)nArray[1]);
                OS.CloseRgn(l2);
            } else {
                l2 = Region.polyToRgn(nArray, n2);
            }
            long l3 = l2;
            return l3;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void add(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.add(nArray, nArray.length);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(int[] nArray, int n2) {
        if ((n2 = n2 / 2 * 2) <= 2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l2 = Region.polyRgn(nArray, n2);
            OS.UnionRgn(this.handle, l2, this.handle);
            OS.DisposeRgn(l2);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void add(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (rectangle.width < 0 || rectangle.height < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n4 < 0 || n5 < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l2 = OS.NewRgn();
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n2, (short)n3, (short)(n2 + n4), (short)(n3 + n5));
            OS.RectRgn(l2, sArray);
            OS.UnionRgn(this.handle, l2, this.handle);
            OS.DisposeRgn(l2);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.UnionRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int n2, int n3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] sArray = new short[]{(short)n3, (short)n2};
            boolean bl2 = OS.PtInRgn(sArray, this.handle);
            return bl2;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public boolean contains(Point point) {
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    void convertRgn(NSAffineTransform nSAffineTransform) {
        long l2 = OS.NewRgn();
        Callback callback = new Callback(this, "convertRgn", 4);
        long l3 = callback.getAddress();
        if (l3 == 0L) {
            SWT.error(3);
        }
        this.transform = nSAffineTransform;
        OS.QDRegionToRects(this.handle, 5, l3, l2);
        this.transform = null;
        callback.dispose();
        OS.CopyRgn(l2, this.handle);
        OS.DisposeRgn(l2);
    }

    long convertRgn(long l2, long l3, long l4, long l5) {
        if (l2 == 2L) {
            short[] sArray = new short[4];
            OS.memmove(sArray, l4, (long)(sArray.length * 2));
            int n2 = 0;
            NSPoint nSPoint = new NSPoint();
            int[] nArray = new int[10];
            nSPoint.x = sArray[1];
            nSPoint.y = sArray[0];
            nSPoint = this.transform.transformPoint(nSPoint);
            int n3 = n2++;
            short s2 = (short)nSPoint.x;
            nArray[n3] = s2;
            int n4 = n2++;
            short s3 = (short)nSPoint.y;
            nArray[n4] = s3;
            nSPoint.x = sArray[3];
            nSPoint.y = sArray[0];
            nSPoint = this.transform.transformPoint(nSPoint);
            nArray[n2++] = (short)Math.round(nSPoint.x);
            nArray[n2++] = (short)nSPoint.y;
            nSPoint.x = sArray[3];
            nSPoint.y = sArray[2];
            nSPoint = this.transform.transformPoint(nSPoint);
            nArray[n2++] = (short)Math.round(nSPoint.x);
            nArray[n2++] = (short)Math.round(nSPoint.y);
            nSPoint.x = sArray[1];
            nSPoint.y = sArray[2];
            nSPoint = this.transform.transformPoint(nSPoint);
            nArray[n2++] = (short)nSPoint.x;
            nArray[n2++] = (short)Math.round(nSPoint.y);
            nArray[n2++] = s2;
            nArray[n2++] = s3;
            long l6 = Region.polyRgn(nArray, nArray.length);
            OS.UnionRgn(l5, l6, l5);
            OS.DisposeRgn(l6);
        }
        return 0L;
    }

    void destroy() {
        OS.DisposeRgn(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] sArray = new short[4];
            OS.GetRegionBounds(this.handle, sArray);
            int n2 = sArray[3] - sArray[1];
            int n3 = sArray[2] - sArray[0];
            Rectangle rectangle = new Rectangle(sArray[1], sArray[0], n2, n3);
            return rectangle;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    NSBezierPath getPath() {
        Callback callback = new Callback(this, "regionToRects", 4);
        if (callback.getAddress() == 0L) {
            SWT.error(3);
        }
        NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
        nSBezierPath.retain();
        OS.QDRegionToRects(this.handle, 5, callback.getAddress(), nSBezierPath.id);
        callback.dispose();
        if (nSBezierPath.isEmpty()) {
            nSBezierPath.appendBezierPathWithRect(new NSRect());
        }
        return nSBezierPath;
    }

    long regionToRects(long l2, long l3, long l4, long l5) {
        if (l2 == 2L) {
            OS.memmove(this.rect, l4, (long)(this.rect.length * 2));
            this.pt.x = this.rect[1];
            this.pt.y = this.rect[0];
            OS.objc_msgSend(l5, OS.sel_moveToPoint_, this.pt);
            this.pt.x = this.rect[3];
            OS.objc_msgSend(l5, OS.sel_lineToPoint_, this.pt);
            this.pt.x = this.rect[3];
            this.pt.y = this.rect[2];
            OS.objc_msgSend(l5, OS.sel_lineToPoint_, this.pt);
            this.pt.x = this.rect[1];
            OS.objc_msgSend(l5, OS.sel_lineToPoint_, this.pt);
            OS.objc_msgSend(l5, OS.sel_closePath);
        }
        return 0L;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    public void intersect(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intersect(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n4 < 0 || n5 < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l2 = OS.NewRgn();
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n2, (short)n3, (short)(n2 + n4), (short)(n3 + n5));
            OS.RectRgn(l2, sArray);
            OS.SectRgn(this.handle, l2, this.handle);
            OS.DisposeRgn(l2);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.SectRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean intersects(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n2, (short)n3, (short)(n2 + n4), (short)(n3 + n5));
            boolean bl2 = OS.RectInRgn(sArray, this.handle);
            return bl2;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            boolean bl2 = OS.EmptyRgn(this.handle);
            return bl2;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l2 = Region.polyRgn(nArray, nArray.length);
            OS.DiffRgn(this.handle, l2, this.handle);
            OS.DisposeRgn(l2);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void subtract(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n4 < 0 || n5 < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l2 = OS.NewRgn();
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n2, (short)n3, (short)(n2 + n4), (short)(n3 + n5));
            OS.RectRgn(l2, sArray);
            OS.DiffRgn(this.handle, l2, this.handle);
            OS.DisposeRgn(l2);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.DiffRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(int n2, int n3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.OffsetRgn(this.handle, (short)n2, (short)n3);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void translate(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.translate(point.x, point.y);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

