/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class RGBA
implements SerializableCompatibility {
    public final RGB rgb;
    public int alpha;
    static final long serialVersionUID = 1049467103126495855L;

    public RGBA(int n2, int n3, int n4, int n5) {
        if (n5 > 255 || n5 < 0) {
            SWT.error(5);
        }
        this.rgb = new RGB(n2, n3, n4);
        this.alpha = n5;
    }

    public RGBA(float f2, float f3, float f4, float f5) {
        if (f5 > 255.0f || f5 < 0.0f) {
            SWT.error(5);
        }
        this.rgb = new RGB(f2, f3, f4);
        this.alpha = (int)((double)f5 + 0.5);
    }

    public float[] getHSBA() {
        float[] fArray = this.rgb.getHSB();
        return new float[]{fArray[0], fArray[1], fArray[2], this.alpha};
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RGBA)) {
            return false;
        }
        RGBA rGBA = (RGBA)object;
        return rGBA.rgb.red == this.rgb.red && rGBA.rgb.green == this.rgb.green && rGBA.rgb.blue == this.rgb.blue && rGBA.alpha == this.alpha;
    }

    public int hashCode() {
        return this.alpha << 32 | this.rgb.blue << 16 | this.rgb.green << 8 | this.rgb.red;
    }

    public String toString() {
        return "RGBA {" + this.rgb.red + ", " + this.rgb.green + ", " + this.rgb.blue + ", " + this.alpha + "}";
    }
}

