/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGradient;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSThread;

public class Pattern
extends Resource {
    NSColor color;
    NSGradient gradient;
    NSPoint pt1;
    NSPoint pt2;
    Image image;
    double[] color1;
    double[] color2;
    int alpha1;
    int alpha2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pattern(Device device, Image image) {
        super(device);
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.image = image;
            this.color = NSColor.colorWithPatternImage(image.handle);
            this.color.retain();
            this.init();
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    public Pattern(Device device, float f2, float f3, float f4, float f5, Color color, Color color2) {
        this(device, f2, f3, f4, f5, color, 255, color2, 255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pattern(Device device, float f2, float f3, float f4, float f5, Color color, int n2, Color color2, int n3) {
        super(device);
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 == null) {
            SWT.error(4);
        }
        if (color2.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.pt1 = new NSPoint();
            this.pt2 = new NSPoint();
            this.pt1.x = f2;
            this.pt1.y = f3;
            this.pt2.x = f4;
            this.pt2.y = f5;
            this.color1 = color.handle;
            this.color2 = color2.handle;
            this.alpha1 = n2;
            this.alpha2 = n3;
            NSColor nSColor = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], (float)n2 / 255.0f);
            NSColor nSColor2 = NSColor.colorWithDeviceRed(color2.handle[0], color2.handle[1], color2.handle[2], (float)n3 / 255.0f);
            this.gradient = ((NSGradient)new NSGradient().alloc()).initWithStartingColor(nSColor, nSColor2);
            this.init();
            Object var14_13 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    void destroy() {
        if (this.color != null) {
            this.color.release();
        }
        this.color = null;
        if (this.gradient != null) {
            this.gradient.release();
        }
        this.gradient = null;
        this.image = null;
        this.color2 = null;
        this.color1 = null;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + (this.color != null ? this.color.id : this.gradient.id) + "}";
    }
}

