/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public class Path
extends Resource {
    public NSBezierPath handle;
    boolean closed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path(Device device) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle = NSBezierPath.bezierPath();
            if (this.handle == null) {
                SWT.error(2);
            }
            this.handle.retain();
            this.handle.moveToPoint(new NSPoint());
            this.init();
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path(Device device, Path path, float f2) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (path == null) {
                SWT.error(4);
            }
            if (path.isDisposed()) {
                SWT.error(5);
            }
            if ((f2 = Math.max(0.0f, f2)) == 0.0f) {
                this.handle = new NSBezierPath(path.handle.copy().id);
            } else {
                double d2 = NSBezierPath.defaultFlatness();
                NSBezierPath.setDefaultFlatness(f2);
                this.handle = path.handle.bezierPathByFlatteningPath();
                this.handle.retain();
                NSBezierPath.setDefaultFlatness(d2);
            }
            if (this.handle == null) {
                SWT.error(2);
            }
            this.init();
            Object var8_6 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path(Device device, PathData pathData) {
        this(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (pathData == null) {
                SWT.error(4);
            }
            this.init(pathData);
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addArc(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(f2 + f4 / 2.0f, f3 + f5 / 2.0f);
            nSAffineTransform.scaleXBy(f4 / 2.0f, f5 / 2.0f);
            NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
            NSPoint nSPoint = new NSPoint();
            float f8 = -f6;
            float f9 = -(f6 + f7);
            nSBezierPath.appendBezierPathWithArcWithCenter(nSPoint, 1.0, f8, f9, f7 > 0.0f);
            nSBezierPath.transformUsingAffineTransform(nSAffineTransform);
            this.appendBezierPath(nSBezierPath);
            this.closed = Math.abs(f7) >= 360.0f;
            if (this.closed) {
                this.handle.closePath();
            }
            Object var14_13 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    void appendBezierPath(NSBezierPath nSBezierPath) {
        int n2 = (int)nSBezierPath.elementCount();
        long l2 = OS.malloc(3 * NSPoint.sizeof);
        if (l2 == 0L) {
            SWT.error(2);
        }
        NSPoint nSPoint = new NSPoint();
        NSPoint nSPoint2 = new NSPoint();
        NSPoint nSPoint3 = new NSPoint();
        block6: for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = (int)nSBezierPath.elementAtIndex(i2, l2);
            switch (n3) {
                case 0: {
                    OS.memmove(nSPoint, l2, (long)NSPoint.sizeof);
                    if (this.closed) {
                        this.handle.moveToPoint(nSPoint);
                        continue block6;
                    }
                    this.handle.lineToPoint(nSPoint);
                    continue block6;
                }
                case 1: {
                    OS.memmove(nSPoint, l2, (long)NSPoint.sizeof);
                    this.handle.lineToPoint(nSPoint);
                    this.closed = false;
                    continue block6;
                }
                case 2: {
                    OS.memmove(nSPoint, l2, (long)NSPoint.sizeof);
                    OS.memmove(nSPoint2, l2 + (long)NSPoint.sizeof, (long)NSPoint.sizeof);
                    OS.memmove(nSPoint3, l2 + (long)NSPoint.sizeof + (long)NSPoint.sizeof, (long)NSPoint.sizeof);
                    this.handle.curveToPoint(nSPoint3, nSPoint, nSPoint2);
                    this.closed = false;
                    continue block6;
                }
                case 3: {
                    this.handle.closePath();
                    this.closed = true;
                }
            }
        }
        OS.free(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.appendBezierPath(path.handle);
            this.closed = path.closed;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRectangle(float f2, float f3, float f4, float f5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSRect nSRect = new NSRect();
        nSRect.x = f2;
        nSRect.y = f3;
        nSRect.width = f4;
        nSRect.height = f5;
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.appendBezierPathWithRect(nSRect);
            this.closed = true;
            Object var8_7 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addString(String string, float f2, float f3, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.closed = true;
            NSString nSString = NSString.stringWith(string);
            NSTextStorage nSTextStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            NSLayoutManager nSLayoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            NSTextContainer nSTextContainer = (NSTextContainer)new NSTextContainer().alloc();
            NSSize nSSize = new NSSize();
            nSSize.width = 5000000.0;
            nSSize.height = 5000000.0;
            nSTextContainer.initWithContainerSize(nSSize);
            nSTextContainer.setLineFragmentPadding(0.0);
            nSTextStorage.addLayoutManager(nSLayoutManager);
            nSLayoutManager.addTextContainer(nSTextContainer);
            NSRange nSRange = new NSRange();
            nSRange.length = nSString.length();
            NSMutableAttributedString nSMutableAttributedString = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
            nSMutableAttributedString.id = nSMutableAttributedString.initWithString((NSString)nSString).id;
            nSMutableAttributedString.beginEditing();
            nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font.handle, nSRange);
            font.addTraits(nSMutableAttributedString, nSRange);
            nSMutableAttributedString.endEditing();
            nSTextStorage.setAttributedString(nSMutableAttributedString);
            nSMutableAttributedString.release();
            nSRange = nSLayoutManager.glyphRangeForTextContainer(nSTextContainer);
            if (nSRange.length != 0L) {
                long l2 = OS.malloc((nSRange.length + 1L) * 4L);
                long l3 = nSLayoutManager.getGlyphs(l2, nSRange);
                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                int n2 = 0;
                while ((long)n2 < l3) {
                    NSPoint nSPoint = nSLayoutManager.locationForGlyphAtIndex(n2);
                    NSRect nSRect = nSLayoutManager.lineFragmentUsedRectForGlyphAtIndex(n2, 0L);
                    NSFont nSFont = new NSFont(nSTextStorage.attribute(OS.NSFontAttributeName, nSLayoutManager.characterIndexForGlyphAtIndex(n2), 0L));
                    nSPoint.x = nSPoint.x + (double)f2 + nSRect.x;
                    nSPoint.y = -nSPoint.y - (double)f3 - nSRect.y;
                    nSBezierPath.moveToPoint(nSPoint);
                    nSBezierPath.appendBezierPathWithGlyphs(l2 + (long)(n2 * 4), 1L, nSFont);
                    ++n2;
                }
                OS.free(l2);
                NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
                nSAffineTransform.scaleXBy(1.0, -1.0);
                nSBezierPath.transformUsingAffineTransform(nSAffineTransform);
                this.handle.appendBezierPath(nSBezierPath);
            }
            nSTextContainer.release();
            nSLayoutManager.release();
            nSTextStorage.release();
            Object var23_21 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var23_22 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.closePath();
            this.closed = true;
            Object var3_2 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(float f2, float f3, GC gC, boolean bl2) {
        boolean bl3;
        block21: {
            NSAutoreleasePool nSAutoreleasePool;
            block19: {
                boolean bl4;
                block20: {
                    if (this.isDisposed()) {
                        SWT.error(44);
                    }
                    if (gC == null) {
                        SWT.error(4);
                    }
                    if (gC.isDisposed()) {
                        SWT.error(5);
                    }
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        if (!bl2) break block19;
                        long l2 = OS.malloc(4L);
                        if (l2 == 0L) {
                            SWT.error(2);
                        }
                        int[] nArray = new int[]{-1};
                        OS.memmove(l2, nArray, 4L);
                        long l3 = OS.CGColorSpaceCreateDeviceRGB();
                        long l4 = OS.CGBitmapContextCreate(l2, 1L, 1L, 8L, 4L, l3, 6);
                        OS.CGColorSpaceRelease(l3);
                        if (l4 == 0L) {
                            OS.free(l2);
                            SWT.error(2);
                        }
                        GCData gCData = gC.data;
                        int n2 = 0;
                        switch (gCData.lineCap) {
                            case 2: {
                                n2 = 1;
                                break;
                            }
                            case 1: {
                                n2 = 0;
                                break;
                            }
                            case 3: {
                                n2 = 2;
                            }
                        }
                        OS.CGContextSetLineCap(l4, n2);
                        int n3 = 0;
                        switch (gCData.lineJoin) {
                            case 1: {
                                n3 = 0;
                                break;
                            }
                            case 2: {
                                n3 = 1;
                                break;
                            }
                            case 3: {
                                n3 = 2;
                            }
                        }
                        OS.CGContextSetLineJoin(l4, n3);
                        OS.CGContextSetLineWidth(l4, gCData.lineWidth);
                        OS.CGContextTranslateCTM(l4, -f2 + 0.5f, -f3 + 0.5f);
                        long l5 = GC.createCGPathRef(this.handle);
                        OS.CGContextAddPath(l4, l5);
                        OS.CGPathRelease(l5);
                        OS.CGContextStrokePath(l4);
                        OS.CGContextRelease(l4);
                        OS.memmove(nArray, l2, 4L);
                        OS.free(l2);
                        bl4 = nArray[0] != -1;
                        Object var20_16 = null;
                        if (nSAutoreleasePool == null) break block20;
                    }
                    catch (Throwable throwable) {
                        block22: {
                            Object var20_18 = null;
                            if (nSAutoreleasePool == null) break block22;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return bl4;
            }
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = f2;
            nSPoint.y = f3;
            bl3 = this.handle.containsPoint(nSPoint);
            Object var20_17 = null;
            if (nSAutoreleasePool == null) break block21;
            nSAutoreleasePool.release();
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cubicTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = f6;
            nSPoint.y = f7;
            NSPoint nSPoint2 = new NSPoint();
            nSPoint2.x = f2;
            nSPoint2.y = f3;
            NSPoint nSPoint3 = new NSPoint();
            nSPoint3.x = f4;
            nSPoint3.y = f5;
            this.handle.curveToPoint(nSPoint, nSPoint2, nSPoint3);
            this.closed = false;
            Object var12_11 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    void destroy() {
        this.handle.release();
        this.handle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getBounds(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 4) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSRect nSRect = this.handle.controlPointBounds();
            fArray[0] = (float)nSRect.x;
            fArray[1] = (float)nSRect.y;
            fArray[2] = (float)nSRect.width;
            fArray[3] = (float)nSRect.height;
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getCurrentPoint(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 2) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = this.handle.currentPoint();
            fArray[0] = (float)nSPoint.x;
            fArray[1] = (float)nSPoint.y;
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathData getPathData() {
        PathData pathData;
        block13: {
            if (this.isDisposed()) {
                SWT.error(44);
            }
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                int n2 = (int)this.handle.elementCount();
                int n3 = 0;
                int n4 = 0;
                byte[] byArray = new byte[n2];
                float[] fArray = new float[n2 * 6];
                long l2 = OS.malloc(3 * NSPoint.sizeof);
                if (l2 == 0L) {
                    SWT.error(2);
                }
                NSPoint nSPoint = new NSPoint();
                block8: for (int i2 = 0; i2 < n2; ++i2) {
                    int n5 = (int)this.handle.elementAtIndex(i2, l2);
                    switch (n5) {
                        case 0: {
                            byArray[n4++] = 1;
                            OS.memmove(nSPoint, l2, (long)NSPoint.sizeof);
                            fArray[n3++] = (float)nSPoint.x;
                            fArray[n3++] = (float)nSPoint.y;
                            continue block8;
                        }
                        case 1: {
                            byArray[n4++] = 2;
                            OS.memmove(nSPoint, l2, (long)NSPoint.sizeof);
                            fArray[n3++] = (float)nSPoint.x;
                            fArray[n3++] = (float)nSPoint.y;
                            continue block8;
                        }
                        case 2: {
                            byArray[n4++] = 4;
                            OS.memmove(nSPoint, l2, (long)NSPoint.sizeof);
                            fArray[n3++] = (float)nSPoint.x;
                            fArray[n3++] = (float)nSPoint.y;
                            OS.memmove(nSPoint, l2 + (long)NSPoint.sizeof, (long)NSPoint.sizeof);
                            fArray[n3++] = (float)nSPoint.x;
                            fArray[n3++] = (float)nSPoint.y;
                            OS.memmove(nSPoint, l2 + (long)NSPoint.sizeof + (long)NSPoint.sizeof, (long)NSPoint.sizeof);
                            fArray[n3++] = (float)nSPoint.x;
                            fArray[n3++] = (float)nSPoint.y;
                            continue block8;
                        }
                        case 3: {
                            byArray[n4++] = 5;
                        }
                    }
                }
                OS.free(l2);
                if (n3 != fArray.length) {
                    float[] fArray2 = new float[n3];
                    System.arraycopy(fArray, 0, fArray2, 0, n3);
                    fArray = fArray2;
                }
                PathData pathData2 = new PathData();
                pathData2.types = byArray;
                pathData2.points = fArray;
                pathData = pathData2;
                Object var13_14 = null;
                if (nSAutoreleasePool == null) break block13;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var13_15 = null;
                    if (nSAutoreleasePool == null) break block14;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return pathData;
    }

    void init(PathData pathData) {
        byte[] byArray = pathData.types;
        float[] fArray = pathData.points;
        int n2 = 0;
        block7: for (int i2 = 0; i2 < byArray.length; ++i2) {
            switch (byArray[i2]) {
                case 1: {
                    this.moveTo(fArray[n2++], fArray[n2++]);
                    continue block7;
                }
                case 2: {
                    this.lineTo(fArray[n2++], fArray[n2++]);
                    continue block7;
                }
                case 4: {
                    this.cubicTo(fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++]);
                    continue block7;
                }
                case 3: {
                    this.quadTo(fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++]);
                    continue block7;
                }
                case 5: {
                    this.close();
                    continue block7;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lineTo(float f2, float f3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = f2;
            nSPoint.y = f3;
            this.handle.lineToPoint(nSPoint);
            this.closed = false;
            Object var6_5 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveTo(float f2, float f3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = f2;
            nSPoint.y = f3;
            this.handle.moveToPoint(nSPoint);
            this.closed = true;
            Object var6_5 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void quadTo(float f2, float f3, float f4, float f5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = this.handle.isEmpty() ? new NSPoint() : this.handle.currentPoint();
            NSPoint nSPoint2 = new NSPoint();
            nSPoint2.x = nSPoint.x + 2.0 * ((double)f2 - nSPoint.x) / 3.0;
            nSPoint2.y = nSPoint.y + 2.0 * ((double)f3 - nSPoint.y) / 3.0;
            NSPoint nSPoint3 = new NSPoint();
            nSPoint3.x = nSPoint2.x + ((double)f4 - nSPoint.x) / 3.0;
            nSPoint3.y = nSPoint2.y + ((double)f5 - nSPoint.y) / 3.0;
            NSPoint nSPoint4 = new NSPoint();
            nSPoint4.x = f4;
            nSPoint4.y = f5;
            this.handle.curveToPoint(nSPoint4, nSPoint2, nSPoint3);
            this.closed = false;
            Object var11_10 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

