/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public NSImage handle;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;
    ImageFileNameProvider imageFileNameProvider;
    ImageDataProvider imageDataProvider;

    Image(Device device) {
        super(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, int n2, int n3) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(n2, n3);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, Image image, int n2) {
        super(device);
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            device = this.device;
            this.type = image.type;
            NSSize nSSize = image.handle.size();
            int n3 = (int)nSSize.width;
            int n4 = (int)nSSize.height;
            NSBitmapImageRep nSBitmapImageRep = image.getRepresentation();
            long l2 = nSBitmapImageRep.bytesPerRow();
            this.transparentPixel = image.transparentPixel;
            this.alpha = image.alpha;
            if (image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            long l3 = nSBitmapImageRep.bitmapData();
            long l4 = nSBitmapImageRep.bitmapFormat();
            long l5 = nSBitmapImageRep.bitsPerPixel();
            this.handle = (NSImage)new NSImage().alloc();
            this.handle = this.handle.initWithSize(nSSize);
            NSBitmapImageRep nSBitmapImageRep2 = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            nSBitmapImageRep2 = nSBitmapImageRep2.initWithBitmapDataPlanes(0L, n3, n4, nSBitmapImageRep.bitsPerSample(), nSBitmapImageRep.samplesPerPixel(), nSBitmapImageRep.hasAlpha(), nSBitmapImageRep.isPlanar(), OS.NSDeviceRGBColorSpace, l4, nSBitmapImageRep.bytesPerRow(), l5);
            this.handle.addRepresentation(nSBitmapImageRep2);
            nSBitmapImageRep2.release();
            this.handle.setCacheMode(3L);
            long l6 = nSBitmapImageRep2.bitmapData();
            OS.memmove(l6, l3, (long)(n3 * n4 * 4));
            if (n2 != 0) {
                int n5;
                int n6;
                int n7;
                if (l5 == 32L && (l4 & 1L) == 0L) {
                    n7 = 0;
                    n6 = 1;
                    n5 = 2;
                } else {
                    n7 = 1;
                    n6 = 2;
                    n5 = 3;
                }
                switch (n2) {
                    case 1: {
                        Color color = device.getSystemColor(18);
                        RGB rGB = color.getRGB();
                        byte by = (byte)rGB.red;
                        byte by2 = (byte)rGB.green;
                        byte by3 = (byte)rGB.blue;
                        Color color2 = device.getSystemColor(22);
                        RGB rGB2 = color2.getRGB();
                        byte by4 = (byte)rGB2.red;
                        byte by5 = (byte)rGB2.green;
                        byte by6 = (byte)rGB2.blue;
                        byte[] byArray = new byte[(int)l2];
                        for (int i2 = 0; i2 < n4; ++i2) {
                            OS.memmove(byArray, l6 + (long)i2 * l2, l2);
                            int n8 = 0;
                            for (int i3 = 0; i3 < n3; ++i3) {
                                int n9 = byArray[n8 + n7] & 0xFF;
                                int n10 = byArray[n8 + n6] & 0xFF;
                                int n11 = byArray[n8 + n5] & 0xFF;
                                int n12 = n9 * n9 + n10 * n10 + n11 * n11;
                                if (n12 < 98304) {
                                    byArray[n8 + n7] = by;
                                    byArray[n8 + n6] = by2;
                                    byArray[n8 + n5] = by3;
                                } else {
                                    byArray[n8 + n7] = by4;
                                    byArray[n8 + n6] = by5;
                                    byArray[n8 + n5] = by6;
                                }
                                n8 += 4;
                            }
                            OS.memmove(l6 + (long)i2 * l2, byArray, l2);
                        }
                        break;
                    }
                    case 2: {
                        byte[] byArray = new byte[(int)l2];
                        for (int i4 = 0; i4 < n4; ++i4) {
                            OS.memmove(byArray, l6 + (long)i4 * l2, l2);
                            int n13 = 0;
                            for (int i5 = 0; i5 < n3; ++i5) {
                                byte by;
                                int n14 = byArray[n13 + n7] & 0xFF;
                                int n15 = byArray[n13 + n6] & 0xFF;
                                int n16 = byArray[n13 + n5] & 0xFF;
                                byte by7 = by = (byte)(n14 + n14 + n15 + n15 + n15 + n15 + n15 + n16 >> 3);
                                byArray[n13 + n5] = by7;
                                byArray[n13 + n6] = by7;
                                byArray[n13 + n7] = by7;
                                n13 += 4;
                            }
                            OS.memmove(l6 + (long)i4 * l2, byArray, l2);
                        }
                        break;
                    }
                }
            }
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(rectangle.width, rectangle.height);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageData imageData) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(imageData);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            imageData2 = ImageData.convertMask(imageData2);
            ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
            imageData3.maskPad = imageData2.scanlinePad;
            imageData3.maskData = imageData2.data;
            this.init(imageData3);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, InputStream inputStream) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(new ImageData(inputStream));
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, String string) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (string == null) {
                SWT.error(4);
            }
            this.initNative(string);
            if (this.handle == null) {
                this.init(new ImageData(string));
            }
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageFileNameProvider imageFileNameProvider) {
        super(device);
        if (imageFileNameProvider == null) {
            SWT.error(4);
        }
        this.imageFileNameProvider = imageFileNameProvider;
        String string = imageFileNameProvider.getImagePath(100);
        if (string == null) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.initNative(string);
            if (this.handle == null) {
                this.init(new ImageData(string));
            }
            this.init();
            String string2 = imageFileNameProvider.getImagePath(200);
            if (string2 != null) {
                id id2 = NSImageRep.imageRepWithContentsOfFile(NSString.stringWith(string2));
                NSImageRep nSImageRep = new NSImageRep(id2);
                this.handle.addRepresentation(nSImageRep);
            }
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        this.imageDataProvider = imageDataProvider;
        ImageData imageData = imageDataProvider.getImageData(100);
        if (imageData == null) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(imageData);
            this.init();
            ImageData imageData2 = imageDataProvider.getImageData(200);
            if (imageData2 != null) {
                NSBitmapImageRep nSBitmapImageRep = this.createRepresentaion(imageData2);
                this.handle.addRepresentation(nSBitmapImageRep);
                nSBitmapImageRep.release();
            }
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createAlpha() {
        if (this.transparentPixel == -1 && this.alpha == -1 && this.alphaData == null) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            long l2 = nSBitmapImageRep.pixelsHigh();
            long l3 = nSBitmapImageRep.bytesPerRow();
            long l4 = nSBitmapImageRep.bitmapData();
            long l5 = nSBitmapImageRep.bitmapFormat();
            long l6 = l2 * l3;
            byte[] byArray = new byte[(int)l6];
            OS.memmove(byArray, l4, l6);
            if (this.transparentPixel != -1) {
                if ((l5 & 1L) != 0L) {
                    int n2 = 0;
                    while ((long)n2 < l6) {
                        int n3 = (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
                        byArray[n2] = (byte)(n3 == this.transparentPixel ? 0 : 255);
                        n2 += 4;
                    }
                } else {
                    int n4 = 0;
                    while ((long)n4 < l6) {
                        int n5 = (byArray[n4 + 0] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4 + 2] & 0xFF;
                        byArray[n4] = (byte)(n5 == this.transparentPixel ? 0 : 255);
                        n4 += 4;
                    }
                }
            } else if (this.alpha != -1) {
                int n6;
                byte by = (byte)this.alpha;
                int n7 = n6 = (l5 & 1L) != 0L ? 0 : 3;
                while ((long)n6 < l6) {
                    byArray[n6] = by;
                    n6 += 4;
                }
            } else {
                long l7 = nSBitmapImageRep.pixelsWide();
                int n8 = 0;
                int n9 = (l5 & 1L) != 0L ? 0 : 3;
                int n10 = 0;
                while ((long)n10 < l2) {
                    int n11 = 0;
                    while ((long)n11 < l7) {
                        byArray[n8] = this.alphaData[n9];
                        n8 += 4;
                        ++n9;
                        ++n11;
                    }
                    ++n10;
                }
            }
            nSBitmapImageRep.setAlpha(true);
            OS.memmove(l4, byArray, l6);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        this.handle.release();
        this.handle = null;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.device != image.device || this.transparentPixel != image.transparentPixel) {
            return false;
        }
        if (this.imageDataProvider != null && image.imageDataProvider != null) {
            return this.imageDataProvider.equals(image.imageDataProvider);
        }
        if (this.imageFileNameProvider != null && image.imageFileNameProvider != null) {
            return this.imageFileNameProvider.equals(image.imageFileNameProvider);
        }
        return this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        int n2 = this.transparentPixel >> 16 & 0xFF;
        int n3 = this.transparentPixel >> 8 & 0xFF;
        int n4 = this.transparentPixel >> 0 & 0xFF;
        return Color.cocoa_new(this.device, new double[]{(float)n2 / 255.0f, (float)n3 / 255.0f, (float)n4 / 255.0f, 1.0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.width != -1 && this.height != -1) {
                Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
                return rectangle;
            }
            NSSize nSSize = this.handle.size();
            this.width = (int)nSSize.width;
            this.height = (int)nSSize.height;
            Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
            return rectangle;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n2;
            Object object;
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            long l2 = nSBitmapImageRep.pixelsWide();
            long l3 = nSBitmapImageRep.pixelsHigh();
            long l4 = nSBitmapImageRep.bytesPerRow();
            long l5 = nSBitmapImageRep.bitsPerPixel();
            long l6 = nSBitmapImageRep.bitmapData();
            long l7 = nSBitmapImageRep.bitmapFormat();
            long l8 = l3 * l4;
            byte[] byArray = new byte[(int)l8];
            OS.memmove(byArray, l6, l8);
            PaletteData paletteData = l5 == 32L && (l7 & 1L) == 0L ? new PaletteData(-16777216, 0xFF0000, 65280) : new PaletteData(0xFF0000, 65280, 255);
            ImageData imageData = new ImageData((int)l2, (int)l3, (int)l5, paletteData, 1, byArray);
            imageData.bytesPerLine = (int)l4;
            if (nSBitmapImageRep.hasAlpha() && this.transparentPixel == -1 && this.alpha == -1 && this.alphaData == null) {
                object = new byte[(int)(l2 * l3)];
                n2 = (l7 & 1L) != 0L ? 0 : 3;
                int n3 = 0;
                for (int i2 = n2; i2 < byArray.length; i2 += 4) {
                    object[n3++] = byArray[i2];
                }
                imageData.alphaData = object;
            } else {
                imageData.transparentPixel = this.transparentPixel;
                if (this.transparentPixel == -1 && this.type == 1) {
                    int n4 = 2;
                    long l9 = ((l2 + 7L) / 8L + (long)(n4 - 1)) / (long)n4 * (long)n4;
                    byte[] byArray2 = new byte[(int)(l3 * l9)];
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    while ((long)n7 < l3) {
                        int n8 = 0;
                        while ((long)n8 < l2) {
                            if (byArray[n5] != 0) {
                                int n9 = n6 + (n8 >> 3);
                                byArray2[n9] = (byte)(byArray2[n9] | 1 << 7 - (n8 & 7));
                            } else {
                                int n10 = n6 + (n8 >> 3);
                                byArray2[n10] = (byte)(byArray2[n10] & ~(1 << 7 - (n8 & 7)));
                            }
                            n5 += 4;
                            ++n8;
                        }
                        n6 = (int)((long)n6 + l9);
                        ++n7;
                    }
                    imageData.maskData = byArray2;
                    imageData.maskPad = n4;
                }
                imageData.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    imageData.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
                }
            }
            if (l5 == 32L) {
                int n11;
                for (n2 = n11 = (l7 & 1L) != 0L ? 0 : 3; n2 < byArray.length; n2 += 4) {
                    byArray[n2] = 0;
                }
            }
            object = imageData;
            return object;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public static Image cocoa_new(Device device, int n2, NSImage nSImage) {
        Image image = new Image(device);
        image.type = n2;
        image.handle = nSImage;
        return image;
    }

    NSBitmapImageRep getRepresentation() {
        NSBitmapImageRep nSBitmapImageRep = new NSBitmapImageRep(this.handle.bestRepresentationForDevice(null));
        if (nSBitmapImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
            return nSBitmapImageRep;
        }
        NSArray nSArray = this.handle.representations();
        NSSize nSSize = this.handle.size();
        long l2 = nSArray.count();
        NSObject nSObject = null;
        int n2 = 0;
        while ((long)n2 < l2) {
            nSBitmapImageRep = new NSBitmapImageRep(nSArray.objectAtIndex(n2));
            if (nSBitmapImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return nSBitmapImageRep;
            }
            if (nSObject == null || (long)((int)nSSize.width) == nSBitmapImageRep.pixelsWide() && (long)((int)nSSize.height) == nSBitmapImageRep.pixelsHigh()) {
                nSObject = nSBitmapImageRep;
            }
            ++n2;
        }
        nSObject.retain();
        n2 = 0;
        while ((long)n2 < l2) {
            this.handle.removeRepresentation(new NSImageRep(this.handle.representations().objectAtIndex(0L)));
            ++n2;
        }
        this.handle.addRepresentation((NSImageRep)nSObject);
        NSBitmapImageRep nSBitmapImageRep2 = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        nSBitmapImageRep2 = nSBitmapImageRep2.initWithData(this.handle.TIFFRepresentation());
        this.handle.addRepresentation(nSBitmapImageRep2);
        this.handle.removeRepresentation((NSImageRep)nSObject);
        nSObject.release();
        nSBitmapImageRep2.release();
        return nSBitmapImageRep2;
    }

    public int hashCode() {
        if (this.imageDataProvider != null) {
            return this.imageDataProvider.hashCode();
        }
        if (this.imageFileNameProvider != null) {
            return this.imageFileNameProvider.hashCode();
        }
        return this.handle != null ? (int)this.handle.id : 0;
    }

    void init(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.width = n2;
        this.height = n3;
        this.handle = (NSImage)new NSImage().alloc();
        NSSize nSSize = new NSSize();
        nSSize.width = n2;
        nSSize.height = n3;
        this.handle = this.handle.initWithSize(nSSize);
        NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0L, n2, n3, 8L, 3L, false, false, OS.NSDeviceRGBColorSpace, 3L, n2 * 4, 32L);
        OS.memset(nSBitmapImageRep.bitmapData(), 255, n2 * n3 * 4);
        this.handle.addRepresentation(nSBitmapImageRep);
        nSBitmapImageRep.release();
        this.handle.setCacheMode(3L);
    }

    void init(ImageData imageData) {
        if (imageData == null) {
            SWT.error(4);
        }
        if (this.handle != null) {
            this.handle.release();
        }
        this.handle = (NSImage)new NSImage().alloc();
        NSSize nSSize = new NSSize();
        nSSize.width = this.width;
        nSSize.height = this.height;
        this.handle = this.handle.initWithSize(nSSize);
        this.width = imageData.width;
        this.height = imageData.height;
        NSBitmapImageRep nSBitmapImageRep = this.createRepresentaion(imageData);
        this.handle.addRepresentation(nSBitmapImageRep);
        nSBitmapImageRep.release();
        this.handle.setCacheMode(3L);
    }

    private NSBitmapImageRep createRepresentaion(ImageData imageData) {
        RGB rGB;
        int n2;
        byte[] byArray;
        Object object;
        boolean bl2;
        NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        int n3 = imageData.width * imageData.height * 4;
        int n4 = imageData.width * 4;
        byte[] byArray2 = new byte[n3];
        if (paletteData.isDirect) {
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray2, 32, n4, 1, 0, 0, imageData.width, imageData.height, 0xFF0000, 65280, 255, false, false);
        } else {
            RGB[] rGBArray = paletteData.getRGBs();
            bl2 = rGBArray.length;
            object = new byte[bl2];
            byArray = new byte[bl2];
            byte[] byArray3 = new byte[bl2];
            for (n2 = 0; n2 < rGBArray.length; ++n2) {
                rGB = rGBArray[n2];
                if (rGB == null) continue;
                object[n2] = (byte)rGB.red;
                byArray[n2] = (byte)rGB.green;
                byArray3[n2] = (byte)rGB.blue;
            }
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, object, byArray, byArray3, 255, null, 0, 0, 0, byArray2, 32, n4, 1, 0, 0, imageData.width, imageData.height, 0xFF0000, 65280, 255, false, false);
        }
        int n5 = imageData.getTransparencyType();
        boolean bl3 = bl2 = n5 != 0;
        if (n5 == 2 || imageData.transparentPixel != -1) {
            int n6 = this.type = imageData.transparentPixel != -1 ? 0 : 1;
            if (imageData.transparentPixel != -1) {
                Object object2;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                if (paletteData.isDirect) {
                    object2 = paletteData.getRGB(imageData.transparentPixel);
                    n7 = object2.red;
                    n8 = object2.green;
                    n9 = object2.blue;
                } else {
                    object2 = paletteData.getRGBs();
                    if (imageData.transparentPixel < ((RGB[])object2).length) {
                        rGB = object2[imageData.transparentPixel];
                        n7 = rGB.red;
                        n8 = rGB.green;
                        n9 = rGB.blue;
                    }
                }
                this.transparentPixel = n7 << 16 | n8 << 8 | n9;
            }
            object = imageData.getTransparencyMask();
            byArray = object.data;
            int n10 = object.bytesPerLine;
            n2 = 0;
            int n11 = 0;
            for (int i2 = 0; i2 < imageData.height; ++i2) {
                for (int i3 = 0; i3 < imageData.width; ++i3) {
                    byArray2[n2] = (byArray[n11 + (i3 >> 3)] & 1 << 7 - (i3 & 7)) != 0 ? -1 : 0;
                    n2 += 4;
                }
                n11 += n10;
            }
        } else {
            this.type = 0;
            if (imageData.alpha != -1) {
                bl2 = true;
                this.alpha = imageData.alpha;
                byte by = (byte)this.alpha;
                for (int i4 = 0; i4 < byArray2.length; i4 += 4) {
                    byArray2[i4] = by;
                }
            } else if (imageData.alphaData != null) {
                bl2 = true;
                this.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                int n12 = 0;
                int n13 = 0;
                for (int i5 = 0; i5 < imageData.height; ++i5) {
                    for (n2 = 0; n2 < imageData.width; ++n2) {
                        byArray2[n12] = this.alphaData[n13];
                        n12 += 4;
                        ++n13;
                    }
                }
            }
        }
        nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0L, imageData.width, imageData.height, 8L, bl2 ? 4L : 3L, bl2, false, OS.NSDeviceRGBColorSpace, 3L, n4, 32L);
        OS.memmove(nSBitmapImageRep.bitmapData(), byArray2, (long)n3);
        return nSBitmapImageRep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initNative(String string) {
        NSAutoreleasePool nSAutoreleasePool = null;
        NSImage nSImage = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            nSImage = new NSImage();
            nSImage.alloc();
            nSImage = nSImage.initWithContentsOfFile(NSString.stringWith(string));
            if (nSImage == null) {
                return;
            }
            NSImageRep nSImageRep = nSImage.bestRepresentationForDevice(null);
            if (!nSImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return;
            }
            this.width = (int)nSImageRep.pixelsWide();
            this.height = (int)nSImageRep.pixelsHigh();
            boolean bl2 = nSImageRep.hasAlpha();
            int n2 = this.width * 4;
            this.handle = (NSImage)new NSImage().alloc();
            NSSize nSSize = new NSSize();
            nSSize.width = this.width;
            nSSize.height = this.height;
            this.handle = this.handle.initWithSize(nSSize);
            NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0L, this.width, this.height, 8L, bl2 ? 4L : 3L, bl2, false, OS.NSDeviceRGBColorSpace, 3L, n2, 32L);
            this.handle.addRepresentation(nSBitmapImageRep);
            nSBitmapImageRep.release();
            this.handle.setCacheMode(3L);
            NSRect nSRect = new NSRect();
            nSRect.width = this.width;
            nSRect.height = this.height;
            long l2 = OS.CGColorSpaceCreateDeviceRGB();
            long l3 = OS.CGBitmapContextCreate(nSBitmapImageRep.bitmapData(), this.width, this.height, 8L, n2, l2, 6);
            OS.CGColorSpaceRelease(l2);
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(l3, false));
            nSImageRep.drawInRect(nSRect);
            NSGraphicsContext.static_restoreGraphicsState();
            OS.CGContextRelease(l3);
            if (bl2) {
                long l4 = this.width;
                long l5 = l4 * (long)this.height;
                long l6 = OS.malloc(l5);
                long l7 = OS.CGBitmapContextCreate(l6, this.width, this.height, 8L, l4, 0L, 7);
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(l7, false));
                nSImageRep.drawInRect(nSRect);
                NSGraphicsContext.static_restoreGraphicsState();
                byte[] byArray = new byte[(int)l5];
                OS.memmove(byArray, l6, l5);
                OS.free(l6);
                OS.CGContextRelease(l7);
                byte[] byArray2 = new byte[this.height * n2];
                OS.memmove(byArray2, nSBitmapImageRep.bitmapData(), (long)byArray2.length);
                int n3 = 0;
                int n4 = 0;
                while (n3 < byArray.length) {
                    byArray2[n4] = byArray[n3];
                    float f2 = byArray[n3] & 0xFF;
                    if (f2 != 0.0f) {
                        byArray2[n4 + 1] = (byte)((float)(byArray2[n4 + 1] & 0xFF) / f2 * 255.0f);
                        byArray2[n4 + 2] = (byte)((float)(byArray2[n4 + 2] & 0xFF) / f2 * 255.0f);
                        byArray2[n4 + 3] = (byte)((float)(byArray2[n4 + 3] & 0xFF) / f2 * 255.0f);
                    }
                    ++n3;
                    n4 += 4;
                }
                OS.memmove(nSBitmapImageRep.bitmapData(), byArray2, (long)byArray2.length);
                n3 = -1;
                n4 = 0;
                for (n4 = 0; n4 < byArray.length; ++n4) {
                    byte by = byArray[n4];
                    if (n3 == -1 && by == 0) {
                        n3 = n4;
                    }
                    if (by != 0 && by != -1) break;
                }
                this.alpha = -1;
                if (n4 == byArray.length && n3 != -1) {
                    NSColor nSColor = nSBitmapImageRep.colorAtX(n3 % this.width, n3 / this.width);
                    int n5 = (int)(nSColor.redComponent() * 255.0);
                    int n6 = (int)(nSColor.greenComponent() * 255.0);
                    int n7 = (int)(nSColor.blueComponent() * 255.0);
                    this.transparentPixel = n5 << 16 | n6 << 8 | n7;
                    for (int i2 = 0; i2 < byArray2.length; i2 += 4) {
                        int n8;
                        if (byArray2[i2] == 0 || (n8 = (byArray2[i2 + 1] & 0xFF) << 16 | (byArray2[i2 + 2] & 0xFF) << 8 | byArray2[i2 + 3] & 0xFF) != this.transparentPixel) continue;
                        this.transparentPixel = -1;
                        break;
                    }
                }
                if (this.transparentPixel == -1) {
                    this.alphaData = byArray;
                }
            }
            this.type = string.toLowerCase().endsWith(".ico") ? 1 : 0;
        }
        finally {
            if (nSImage != null) {
                nSImage.release();
            }
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long internal_new_GC(GCData gCData) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSGraphicsContext nSGraphicsContext;
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            nSBitmapImageRep.setAlpha(false);
            NSGraphicsContext nSGraphicsContext2 = NSGraphicsContext.graphicsContextWithBitmapImageRep(nSBitmapImageRep);
            nSGraphicsContext2 = nSGraphicsContext = NSGraphicsContext.graphicsContextWithGraphicsPort(nSGraphicsContext2.graphicsPort(), true);
            nSGraphicsContext2.retain();
            if (gCData != null) {
                gCData.flippedContext = nSGraphicsContext;
            }
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(nSGraphicsContext2);
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            NSSize nSSize = this.handle.size();
            nSAffineTransform.translateXBy(0.0, nSSize.height);
            nSAffineTransform.scaleXBy(1.0, -1.0);
            nSAffineTransform.set();
            NSGraphicsContext.static_restoreGraphicsState();
            if (gCData != null) {
                int n2 = 0x6000000;
                if ((gCData.style & n2) == 0) {
                    gCData.style |= 0x2000000;
                }
                gCData.device = this.device;
                gCData.background = this.device.COLOR_WHITE.handle;
                gCData.foreground = this.device.COLOR_BLACK.handle;
                gCData.font = this.device.systemFont;
                gCData.image = this;
            }
            long l2 = nSGraphicsContext2.id;
            return l2;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internal_dispose_GC(long l2, GCData gCData) {
        long l3 = l2;
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (l3 != 0L) {
                NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
                nSBitmapImageRep.bitmapData();
                NSGraphicsContext nSGraphicsContext = new NSGraphicsContext(l3);
                nSGraphicsContext.release();
            }
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n2;
            int n3;
            int n4;
            byte by = (byte)(this.transparentPixel >> 16 & 0xFF);
            byte by2 = (byte)(this.transparentPixel >> 8 & 0xFF);
            byte by3 = (byte)(this.transparentPixel >> 0 & 0xFF);
            byte by4 = (byte)((int)(color.handle[0] * 255.0) & 0xFF);
            byte by5 = (byte)((int)(color.handle[1] * 255.0) & 0xFF);
            byte by6 = (byte)((int)(color.handle[2] * 255.0) & 0xFF);
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            long l2 = nSBitmapImageRep.bytesPerRow();
            long l3 = nSBitmapImageRep.bitmapData();
            long l4 = nSBitmapImageRep.bitmapFormat();
            long l5 = nSBitmapImageRep.bitsPerPixel();
            if (l5 == 32L && (l4 & 1L) == 0L) {
                n4 = 0;
                n3 = 1;
                n2 = 2;
            } else {
                n4 = 1;
                n3 = 2;
                n2 = 3;
            }
            byte[] byArray = new byte[(int)l2];
            int n5 = 0;
            for (int i2 = 0; i2 < this.height; ++i2) {
                OS.memmove(byArray, l3 + (long)n5, l2);
                for (int i3 = 0; i3 < byArray.length; i3 += 4) {
                    if (byArray[i3 + n4] != by || byArray[i3 + n3] != by2 || byArray[i3 + n2] != by3) continue;
                    byArray[i3 + n4] = by4;
                    byArray[i3 + n3] = by5;
                    byArray[i3 + n2] = by6;
                }
                OS.memmove(l3 + (long)n5, byArray, l2);
                n5 = (int)((long)n5 + l2);
            }
            this.transparentPixel = (by4 & 0xFF) << 16 | (by5 & 0xFF) << 8 | by6 & 0xFF;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }
}

